/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.sdk.bis.service.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.sdk.bis.model.DefendGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class DefendGroupDao
extends CommonDaoImpl {
    private final Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public DefendGroup get(Long id) {
        String hql = "from DefendGroup where id = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (DefendGroup)result.get(0);
    }

    public List<DefendGroup> getByUpstreamGroupId(Long upstreamGroupId) {
        String hql = "from DefendGroup where upstreamGroupId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, upstreamGroupId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void remove(Long id) {
        String hql = "delete from DefendGroup where id = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void update(Long upId) {
        String hql = "update DefendGroup set upstreamGroupId = null, cleanMode = null where upstreamGroupId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{upId});
    }

    public boolean isExists(Long excludeId, String defendGroupName) {
        List result;
        String tempName = defendGroupName.trim().toLowerCase(Locale.ENGLISH);
        String hql = "from DefendGroup where lower(groupName) = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, tempName);
        if (null != excludeId) {
            hql = hql + " and id != ?1";
            param.put(1, excludeId.toString());
        }
        return !(result = this.findByHql(hql, param)).isEmpty();
    }

    public List<DefendGroup> getAll() {
        String hql = "from DefendGroup";
        List list = this.findByHql(hql);
        if (list != null) {
            return list;
        }
        return new ArrayList<DefendGroup>();
    }

    public List<DefendGroup> getAllOrderBySortType(Map<String, String> conditionMap) {
        List list;
        String regular;
        String hql = "from DefendGroup";
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^(|groupName)$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        if ((list = this.findByHql(hql)) != null) {
            return list;
        }
        return new ArrayList<DefendGroup>();
    }

    public List<Long> queryAllMoId(Long userId) {
        String securityHql = "select u.id.moId from UserRelMoInfo u where u.id.userId = ?0 ";
        List list = this.getHibernateTemplate().find(securityHql, new Object[]{userId});
        return list;
    }

    public String getDevicesNotBelongMe(Long groupId) {
        StringBuffer buf = new StringBuffer();
        String result = "";
        List<DefendGroup> defendGroupList = this.getAll();
        long tempId = -1L;
        if (groupId != null) {
            tempId = groupId;
        }
        for (DefendGroup group : defendGroupList) {
            if (group.getId() == tempId || group.getDevices() == null) continue;
            buf.append(group.getDevices() + ",");
        }
        result = buf.toString();
        if (!AticUtil.isNull((String)result)) {
            result = result.substring(0, result.length() - 1);
        }
        this.log.info((Object)("query devices not belong the defendgroup. result = " + AticUtil.getcleanedMessage((String)result)));
        return result;
    }

    public DefendGroup getDefendGroupByDevId(Long devId) {
        if (devId == null) {
            return null;
        }
        List<DefendGroup> defendGroupList = this.getAll();
        for (DefendGroup group : defendGroupList) {
            String devices = group.getDevices();
            if (devices == null || !(devices = "," + devices + ",").contains("," + devId + ",")) continue;
            return group;
        }
        return null;
    }
}

