/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.adapter.frame.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.model.DevVer2PkgNameBean;
import com.huawei.atic.secne.adapter.frame.model.DeviceAdapterBean;
import com.huawei.atic.secne.adapter.frame.model.DeviceTypeBean;
import com.huawei.atic.secne.adapter.frame.util.AdapterHelper;
import com.huawei.atic.util.CapaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public final class DevPkgManager {
    private static DevPkgManager instance = null;
    private static ReentrantLock lock = new ReentrantLock();
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private DeviceAdapterBean devAdapterBean = null;

    private DevPkgManager() {
    }

    public static DevPkgManager getInstance() {
        lock.lock();
        try {
            if (null == instance) {
                instance = new DevPkgManager();
            }
            DevPkgManager devPkgManager = instance;
            return devPkgManager;
        }
        finally {
            lock.unlock();
        }
    }

    private void loadDevAdapterFile() {
        String confFile = "conf/adapter/DeviceAdapterControl.xml";
        String confFileRule = "conf/adapter/rule/DeviceAdapterControlRule.xml";
        this.devAdapterBean = (DeviceAdapterBean)AdapterHelper.parseXml2Bean(confFile, confFileRule);
    }

    private DeviceAdapterBean getDevAdapterBean() {
        if (null == this.devAdapterBean) {
            this.loadDevAdapterFile();
        }
        return this.devAdapterBean;
    }

    public String getDevPkgNameByDevId(long devid) {
        DeviceTypeInfo devTypeInfo = CapaUtil.getDevTypeInfo(devid);
        String pkgName = this.getDevPkgName(devTypeInfo);
        this.logger.info((Object)("out adapter function @getDevPkgNameByDevId,devid: " + devid + " pkgName: " + pkgName));
        return pkgName;
    }

    public Set<String> getDevPkgNameList(List<Long> devIDs) {
        this.logger.info((Object)"in adapter function @getDevPkgNameList");
        HashSet<String> pkgLst = new HashSet<String>();
        if (null == devIDs) {
            this.logger.warn((Object)"in adapter function @getDevPkgNameList devIDs is null!");
            return pkgLst;
        }
        HashSet<DeviceTypeInfo> devTypeInfoLst = new HashSet<DeviceTypeInfo>();
        DeviceTypeInfo info = null;
        for (long devid : devIDs) {
            info = CapaUtil.getDevTypeInfo(devid);
            devTypeInfoLst.add(info);
        }
        String pkgName = "";
        for (DeviceTypeInfo deviceTypeInfo : devTypeInfoLst) {
            pkgName = this.getDevPkgName(deviceTypeInfo);
            pkgLst.add(pkgName);
        }
        this.logger.info((Object)"out adapter function @getDevPkgNameList");
        return pkgLst;
    }

    public String getDevPkgName(DeviceTypeInfo devTypeInfo) {
        return this.getDevPkgName(devTypeInfo.getDevType(), devTypeInfo.getDevOSVersion());
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public String getDevPkgName(String devType, String devVer) {
        this.logger.info((Object)("in adapter function @getDevPkgName,devType:" + this.getcleanedMessage(devType) + " devVer: " + this.getcleanedMessage(devVer)));
        String pkgName = "";
        Map<String, DeviceTypeBean> map = this.getDevAdapterBean().getDevType2BeanMap();
        if (map.containsKey(devType)) {
            DeviceTypeBean devTypeBean = map.get(devType);
            Map<String, DevVer2PkgNameBean> ver2PkgMap = devTypeBean.getDevVer2PkgBeanMap();
            if (null == ver2PkgMap) {
                this.logger.warn((Object)"in adapter function @getDevPkgName ver2PkgMap is null!");
                return pkgName;
            }
            Set<String> verSet = ver2PkgMap.keySet();
            String verTmp = "";
            boolean isExist = false;
            for (String ver : verSet) {
                isExist = Pattern.matches(ver, devVer);
                if (!isExist) continue;
                verTmp = ver;
                break;
            }
            if (isExist) {
                pkgName = ver2PkgMap.get(verTmp).getPkgName();
            }
        }
        this.logger.info((Object)"out adapter function @getDevPkgName");
        return pkgName;
    }

    public Set<String> getPkgNameLstByDevType(String devType) {
        this.logger.info((Object)("in adapter function @getPkgNameLstByDevType devType: " + this.getcleanedMessage(devType)));
        HashSet<String> pkgNames = new HashSet<String>();
        DeviceTypeBean devTypeBean = this.getDevAdapterBean().getDevType2BeanMap().get(devType);
        if (null != devTypeBean) {
            Collection<DevVer2PkgNameBean> devVer2PkgNameBeanLst = devTypeBean.getDevVer2PkgBeanMap().values();
            if (null == devVer2PkgNameBeanLst) {
                this.logger.warn((Object)"in adapter function @getPkgNameLstByDevType devVer2PkgNameBeanLst is null!");
                return pkgNames;
            }
            for (DevVer2PkgNameBean devVer2PkgNameBean : devVer2PkgNameBeanLst) {
                pkgNames.add(devVer2PkgNameBean.getPkgName());
            }
        }
        this.logger.info((Object)"out adapter function @getPkgNameLstByDevType");
        return pkgNames;
    }

    public Collection<String> getDevTypeLst4Pkg(String pkgName) {
        this.logger.info((Object)"in adapter function @getDevTypeLst4Pkg");
        ArrayList<String> devTypeLst = new ArrayList<String>();
        Map<String, DeviceTypeBean> map = this.getDevAdapterBean().getDevType2BeanMap();
        Collection<DeviceTypeBean> devTypeBeanLst = map.values();
        Collection<DevVer2PkgNameBean> ver2PkgLst = null;
        for (DeviceTypeBean deviceTypeBean : devTypeBeanLst) {
            ver2PkgLst = deviceTypeBean.getDevVer2PkgBeanMap().values();
            if (null == ver2PkgLst) {
                this.logger.warn((Object)"in adapter function @getDevTypeLst4Pkg ver2PkgLst is null!");
                continue;
            }
            for (DevVer2PkgNameBean ver2PkgBean : ver2PkgLst) {
                if (!ver2PkgBean.getPkgName().equalsIgnoreCase(pkgName)) continue;
                devTypeLst.add(deviceTypeBean.getDevType());
            }
        }
        this.logger.info((Object)"out adapter function @getDevTypeLst4Pkg");
        return devTypeLst;
    }
}

