/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.adapter.frame.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

public final class AdapterHelper {
    private static transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final char FILE_SPARATOR_WIN = '\\';
    private static final char FILE_SPARATOR_OTHER = '/';

    private AdapterHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseXml2Bean(String confFile, String confFileRule) throws LegoCheckedException {
        logger.info((Object)("in adapter function @parseXml2Bean,confFile: " + AdapterHelper.getcleanedMessage(confFile) + " confFileRule: " + AdapterHelper.getcleanedMessage(confFileRule)));
        Object bean = null;
        String tmpPath = "/";
        String tmpConf = AdapterHelper.formatFileSeparator(tmpPath + confFile);
        String tmpConfRule = AdapterHelper.formatFileSeparator(tmpPath + confFileRule);
        logger.info((Object)"@ adapter function changed Path");
        InputStream in = null;
        ClassLoader classLoader = null;
        try {
            classLoader = AdapterHelper.class.getClassLoader();
            if (null != classLoader) {
                Digester digester = DigesterLoader.createDigester((URL)classLoader.getResource(tmpConfRule));
                digester.setClassLoader(classLoader);
                in = classLoader.getResourceAsStream(tmpConf);
                bean = digester.parse(in);
            }
        }
        catch (RuntimeException exc) {
            logger.error((Object)("@ adapter function @parseXml2Bean,confFile: " + AdapterHelper.getcleanedMessage(confFile) + " confFileRule: " + AdapterHelper.getcleanedMessage(confFileRule) + " RuntimeException"));
            throw new LegoCheckedException(660018L, (Throwable)exc);
        }
        catch (SAXException exc) {
            logger.error((Object)("@ adapter function @parseXml2Bean,confFile: " + AdapterHelper.getcleanedMessage(confFile) + " confFileRule: " + AdapterHelper.getcleanedMessage(confFileRule) + " SAXException"));
        }
        catch (IOException exc) {
            logger.error((Object)("@ adapter function @parseXml2Bean,confFile: " + AdapterHelper.getcleanedMessage(confFile) + " confFileRule: " + AdapterHelper.getcleanedMessage(confFileRule) + " IOException"));
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"parseXml2Bean close inputStream error");
            }
        }
        return bean;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public static String formatFileSeparator(String path) {
        String ret = "";
        if ('/' == File.separatorChar) {
            logger.info((Object)("\u5176\u5b83\u64cd\u4f5c\u7cfb\u7edf:linux\u3001solaris\u4e0b\u8def\u5f84\u5206\u9694\u7b26 '/'and File.separatorChar = " + File.separatorChar));
            ret = path.replace("\\", "/");
        } else {
            logger.info((Object)("path = pathand File.separatorChar = " + File.separatorChar));
            ret = path;
        }
        return ret;
    }

    public static String appendFileSeparator(String path) {
        String ret = "";
        ret = path.endsWith("\\") || path.endsWith("/") ? path : path + File.separator;
        return ret;
    }

    public static boolean checkFileIsExist(String newFile) {
        boolean isExist = true;
        try {
            File file = new File(newFile);
            if (!file.exists()) {
                isExist = false;
            }
        }
        catch (Exception e) {
            isExist = false;
        }
        return isExist;
    }
}

