/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.list;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNexthop;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.parents.servcice.CleanTaskBufferParentService;
import com.huawei.atic.parents.servcice.IHomePageParentService;
import com.huawei.atic.parents.servcice.IZoneDeviceParentService;
import com.huawei.atic.secne.common.SecNELogFactory;
import com.huawei.atic.secne.sdk.common.StringUtils;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.struts2.ServletActionContext;

public class SecNEListAction
extends BaseAction {
    private static final long serialVersionUID = -5166010161191429998L;
    private static final int COLLECTOR_STATUS_IN = 1;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private List<AticDevice> list;
    private String jyqxIp = null;
    private String jyqxIpv6 = null;
    private String jmdqxIp = null;
    private String jmdqxIpv6 = null;
    private String listContaner = null;
    private String name = null;
    private String simpleSystemName = null;
    private long moId;
    private int deviceType;
    private Long aticCollectVale;
    private String sortField = null;
    private String sortType = null;
    private String helpLanguage = "";
    private IAticDeviceService aticDeviceService;
    private IDiscoveryService discoveryService;
    private IClusterService clusterService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private IAticDeviceNfaRouterService aticDeviceNfaRouterService;
    private IAticDeviceRouterService aticDeviceRouterService;

    public String queryNEDataList() {
        try {
            Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
            if ("zh".equalsIgnoreCase(locale.getLanguage())) {
                this.setHelpLanguage("zh_cn");
            } else {
                this.setHelpLanguage("en");
            }
            Map<String, String> map = this.getConditions();
            CleanTaskBufferParentService cleanTaskBufferService = (CleanTaskBufferParentService)ServiceContext.getInstance().getService("cleanTaskBufferService", CleanTaskBufferParentService.class);
            Paging paging1 = this.aticDeviceService.getDeviceByPage(map, this.start, this.pageSize);
            this.list = paging1.getData();
            boolean isOpen = cleanTaskBufferService.isUnicomOpen();
            int unicomSwitchType = 0;
            if (isOpen) {
                unicomSwitchType = 1;
            }
            for (AticDevice aticDevice : this.list) {
                aticDevice.setStatus(this.aticDeviceService.getStatusByMoid(aticDevice.getMoId()));
                aticDevice.setUnicomSwitchType(unicomSwitchType);
            }
            this.total = paging1.getCount();
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)("Exception happened when get the discovered devicelist!" + e.getMessage()));
            this.list = new ArrayList<AticDevice>();
            this.total = 0;
        }
        return "success";
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.simpleSystemName)) {
            map.put("nameOrIp", this.simpleSystemName.trim());
        }
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        map.put("userId", String.valueOf(currentUser.getUserID()));
        map.put("isAdmin", currentUser.getIsAdmin());
        return map;
    }

    private boolean checkNeStateForDelete1() {
        boolean bVal = true;
        String[] modiarr = this.listContaner.split(",");
        int len = modiarr.length;
        for (int i = 0; i < len; ++i) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(Long.valueOf(modiarr[i]));
            BisUtil.checkUserSecurity(moIdList);
            AticDevice firewall = this.aticDeviceService.getDeviceByMoid(Long.parseLong(modiarr[i]));
            if (null != firewall) continue;
            bVal = false;
            break;
        }
        return bVal;
    }

    public void deleteNE() {
        try {
            if (null == this.listContaner || !this.checkNeStateForDelete1()) {
                this.responseResult("neisdeleted");
                return;
            }
            ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
            ArrayList<BatchOperation> bathOprLstTemp = new ArrayList<BatchOperation>();
            ArrayList<Long> idList = new ArrayList<Long>();
            ArrayList<String> devIps = new ArrayList<String>();
            String[] moidarr = this.listContaner.split(",");
            int len = moidarr.length;
            for (int i = 0; i < len; ++i) {
                BatchOperation tempBatch = new BatchOperation();
                AticDevice secNe = this.aticDeviceService.getDeviceByMoid(Long.parseLong(moidarr[i]));
                tempBatch.setTargetId(Long.parseLong(moidarr[i]));
                tempBatch.setTargetName(secNe.getName());
                String[] temp = new String[]{secNe.getName(), secNe.getIpAddress()};
                tempBatch.setOptDetail("secne.log.module.ne.list.deleted.name.sucess");
                tempBatch.setDetailParam(temp);
                bathOprLst.add(tempBatch);
                idList.add(Long.valueOf(moidarr[i]));
                devIps.add(secNe.getIpAddress());
            }
            try {
                BisUtil.checkUserSecurity(idList);
                this.delHomePageByDevIp(devIps, idList);
                List<BatchOperation> operations = this.aticDeviceService.deleteDevice(idList);
                if (null != this.discoveryService) {
                    this.batchOperationResult = this.discoveryService.deleteDeviceNew(bathOprLst, this.getUserId());
                    this.systemOpeLog("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", true, null, "atic.bis.divert.tactics.log.result.success", "lego.lab.discovery.deldevice", SysoplogLevel.risk.getValue(), true, null);
                    if (this.batchOperationResult != null) {
                        this.dealOperation(operations);
                        List bathOprLstResult = this.batchOperationResult.getResult();
                        for (BatchOperation batchOperation : bathOprLstResult) {
                            for (BatchOperation bath : bathOprLst) {
                                if (batchOperation.getTargetId() != bath.getTargetId()) continue;
                                if (batchOperation.getErrorCode() == 0L) {
                                    bathOprLstTemp.add(bath);
                                    continue;
                                }
                                bathOprLstTemp.add(batchOperation);
                            }
                        }
                        SecNELogFactory.getInstance().info((Object)"deleteNE -> vsm deleted logger displace Logo deleted logger...");
                        this.batchOperationResult.setResult(bathOprLstTemp);
                        this.bathResult(this.batchOperationResult);
                    }
                }
            }
            catch (LegoCheckedException e) {
                this.systemOpeLog("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", true, null, "atic.bis.divert.tactics.log.result.fail", "lego.lab.discovery.deldevice", SysoplogLevel.risk.getValue(), false, (Exception)((Object)e));
                SecNELogFactory.getInstance().error((Object)"Exception happened when deleted the discovered device");
                throw e;
            }
            catch (RuntimeException e) {
                this.systemOpeLog("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", true, null, "atic.bis.divert.tactics.log.result.fail", "lego.lab.discovery.deldevice", SysoplogLevel.risk.getValue(), false, e);
                SecNELogFactory.getInstance().error((Object)"Exception happened when deleted the discovered device");
                throw new LegoCheckedException(570507L);
            }
        }
        catch (RuntimeException e) {
            this.systemOpeLog("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", true, null, "atic.bis.divert.tactics.log.result.fail", "lego.lab.discovery.deldevice", SysoplogLevel.risk.getValue(), false, e);
            throw new LegoCheckedException(570507L);
        }
        catch (Exception e) {
            this.systemOpeLog("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", true, null, "atic.bis.divert.tactics.log.result.fail", "lego.lab.discovery.deldevice", SysoplogLevel.risk.getValue(), false, e);
            throw new LegoCheckedException(570507L);
        }
    }

    private void dealOperation(List<BatchOperation> operations) {
        if (!operations.isEmpty()) {
            List bathOprLstResult = this.batchOperationResult.getResult();
            int fail = this.batchOperationResult.getFailCount();
            int success = this.batchOperationResult.getSucceedCount();
            ArrayList<Long> deviceIds = new ArrayList<Long>();
            ArrayList<BatchOperation> delOperation = new ArrayList<BatchOperation>();
            for (BatchOperation operation : operations) {
                deviceIds.add(operation.getTargetId());
            }
            for (BatchOperation operation : bathOprLstResult) {
                if (!deviceIds.contains(operation.getTargetId())) continue;
                delOperation.add(operation);
                --success;
            }
            bathOprLstResult.removeAll(delOperation);
            bathOprLstResult.addAll(operations);
            this.batchOperationResult.setResult(bathOprLstResult);
            this.batchOperationResult.setFailCount(fail += operations.size());
            this.batchOperationResult.setSucceedCount(success);
        }
    }

    private void delHomePageByDevIp(List<String> devIps, List<Long> idList) {
        if (null == devIps || devIps.isEmpty()) {
            return;
        }
        IHomePageParentService iHomePageService = null;
        ServiceContext context = null;
        try {
            context = ServiceContext.getInstance();
            iHomePageService = (IHomePageParentService)ServiceContext.getInstance().getService("homePageService", IHomePageParentService.class);
            if (iHomePageService == null) {
                throw new LegoCheckedException(570506L);
            }
            iHomePageService.delByDevIp(devIps);
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)("Exception happened when delHomePageByDevIp!" + e.getMessage()));
        }
        try {
            if (null == context) {
                throw new LegoCheckedException(570506L);
            }
            IZoneDeviceParentService zoneDeviceService = (IZoneDeviceParentService)ServiceContext.getInstance().getService("zoneDeviceService", IZoneDeviceParentService.class);
            if (zoneDeviceService == null) {
                throw new LegoCheckedException(570506L);
            }
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            for (Long deviceId : idList) {
                Long zoneId = zoneDeviceService.getDefaultZoneIdByDevIdToSecne(deviceId);
                if (zoneId == null || zoneId <= 0L || zoneIds.contains(zoneId)) continue;
                zoneIds.add(zoneId);
            }
            if (iHomePageService != null) {
                iHomePageService.delByZoneId(zoneIds);
            }
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)("Exception happened when delHomePageByDevIp!" + e.getMessage()));
        }
    }

    public void checkNeStateForDelete() {
        AticDevice firewall = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (null == firewall) {
            this.responseResult("neisdeleted");
        } else {
            this.responseResult("success");
        }
    }

    public String editMOName() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice secNe = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (secNe == null) {
            throw new LegoCheckedException(201L);
        }
        this.name = secNe.getName();
        return "success";
    }

    public boolean processPara() {
        String nameTemp = this.name.trim();
        if (CommonUtil.isNull(nameTemp) || nameTemp.length() > 32) {
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return nameTemp.matches(nameRegex);
    }

    public boolean validatorJyqxIp() {
        String nameTemp = this.jyqxIp.trim();
        if (CommonUtil.isNull(nameTemp)) {
            return true;
        }
        return AticUtil.validateIpv4((String)nameTemp);
    }

    public boolean validatorJyqxIpv6() {
        String nameTemp = this.jyqxIpv6.trim();
        if (CommonUtil.isNull(nameTemp)) {
            return true;
        }
        return IPUtil.isIpv6((String)nameTemp);
    }

    public boolean validatorJmdqxIp() {
        String nameTemp = this.jmdqxIp.trim();
        if (CommonUtil.isNull(nameTemp)) {
            return true;
        }
        return AticUtil.validateIpv4((String)nameTemp);
    }

    public boolean validatorJmdqxIpv6() {
        String nameTemp = this.jmdqxIpv6.trim();
        if (CommonUtil.isNull(nameTemp)) {
            return true;
        }
        return IPUtil.isIpv6((String)nameTemp);
    }

    public void saveMOName() {
        String operation = "secne.detall.group.value.name.tip";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.name;
        String[] temp = new String[2];
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        try {
            AticDevice secNEData = null;
            if (0L != this.moId) {
                secNEData = this.aticDeviceService.getDeviceByMoid(this.moId);
                if (secNEData == null) {
                    SecNELogFactory.getInstance().error((Object)"this SecurityNE is null...");
                    this.systemOpeLog(operation, module, false, null, "secne.log.module.ne.list.modify.name.failed", target, SysoplogLevel.normal.getValue(), false, null);
                    this.responseResult("failure");
                    return;
                }
                target = secNEData.getName();
                temp[0] = secNEData.getName();
                temp[1] = secNEData.getIpAddress();
            }
            this.aticDeviceService.updateMOName(this.moId, this.name);
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.list.modify.name.sucess", target, SysoplogLevel.normal.getValue(), true, null);
            SecNELogFactory.getInstance().info((Object)("saveMOName--> SecurityNE modify  MO Name --> " + temp[0] + ", ipAddress = " + temp[1]));
            this.responseResult("success");
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.list.modify.name.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            this.responseResult("failure");
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.list.modify.name.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            this.responseResult("failure");
        }
    }

    public void isNEExist() {
        if (this.moId > 0L) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moId);
            BisUtil.checkUserSecurity(moIdList);
            AticDevice secNEData = this.aticDeviceService.getDeviceByMoid(this.moId);
            if (null == secNEData) {
                throw new LegoCheckedException(1050L);
            }
        }
        this.responseResult("ok");
    }

    public void synchronizeNE() {
        String operation = "secne.detall.group.list.img.tooltip.discovery.device";
        String module = "lego.dic.module.ResourceApplication";
        String target = String.valueOf(this.moId);
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.moId);
        try {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.moId);
            if (null == aticDevice) {
                throw new LegoCheckedException(201L);
            }
            this.logger.info((Object)("Before synchronization  device moId:" + this.moId + ",device Name :" + aticDevice.getName() + ",deviceDdosType :" + aticDevice.getDdosType()));
            target = aticDevice.getName();
            BisUtil.checkUserSecurity(deviceList);
            this.aticDeviceService.syncDeviceList(deviceList);
            if (aticDevice.getDeviceType() != 1 && aticDevice.getDeviceType() != 8) {
                this.systemOpeLog(operation, module, false, null, "secne.detall.group.list.img.tooltip.discovery.device.success", target, SysoplogLevel.normal.getValue(), true, null);
                this.responseResult("success");
                return;
            }
            AticDevice aDevice = this.aticDeviceService.getDeviceByMoid(this.moId);
            this.logger.info((Object)("After synchronization  device moId:" + this.moId + ",device Name :" + aDevice.getName() + ",deviceDdosType :" + aDevice.getDdosType()));
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(this.moId);
            CollectorInfo collectorInfo = null;
            boolean updateDevice = true;
            if (null != collectorId) {
                collectorInfo = this.collectorService.getCollectorInfo(collectorId);
                if (1 != collectorInfo.getStatus()) {
                    updateDevice = false;
                    this.logger.info((Object)("collector is not online, collectorId =" + collectorId));
                } else {
                    if (StringUtils.isEmpty(aticDevice.getLogPwd())) {
                        this.systemOpeLog(operation, module, true, null, "secne.detail.discovery.dlg.result.sync.success.nologconfig", target, SysoplogLevel.normal.getValue(), false, null);
                        this.responseResult("success:logConfigIsNull");
                        return;
                    }
                    updateDevice = this.collectorDeviceService.updateDeviceAccess(aDevice, collectorInfo.getIpAddress());
                }
            } else {
                this.logger.info((Object)("The device is not bound to the collector, deviceId=" + this.moId));
            }
            if (updateDevice) {
                this.systemOpeLog(operation, module, true, null, "secne.detall.group.list.img.tooltip.discovery.device.success", target, SysoplogLevel.normal.getValue(), true, null);
                this.responseResult("success");
            } else {
                this.systemOpeLog(operation, module, true, null, "secne.detall.group.list.img.tooltip.discovery.device.fail", target, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult("success:collectorIsOffline");
            }
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog(operation, module, true, null, "secne.detall.group.list.img.tooltip.discovery.device.fail", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, null, "secne.detall.group.list.img.tooltip.discovery.device.fail", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void validateRestFul() {
        this.responseResult("success");
    }

    public boolean simpleSystemNameValidation() {
        if (!StringUtils.isEmpty(this.simpleSystemName)) {
            String nameRegex = "^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            if (!this.simpleSystemName.matches(nameRegex)) {
                return false;
            }
            if (this.simpleSystemName.length() > 32) {
                return false;
            }
        }
        return true;
    }

    public long getUserId() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        return currentUser.getUserID();
    }

    public boolean validateListContaner() {
        String[] modiarr = this.listContaner.split(",");
        for (int i = 0; i < modiarr.length; ++i) {
            try {
                long id = Long.parseLong(modiarr[i]);
                if (id >= 0L) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateDeviceType() {
        String deviceTypeRegex = "^[1-9]{1}$";
        return String.valueOf(this.deviceType).matches(deviceTypeRegex);
    }

    public String editNexthopIp() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        SecNELogFactory.getInstance().info((Object)("moid :" + this.moId));
        AticDevice secNe = this.aticDeviceService.getDeviceByMoid(this.moId);
        SecNELogFactory.getInstance().info((Object)("secNe:" + secNe));
        if (secNe == null) {
            throw new LegoCheckedException(201L);
        }
        AticDeviceNexthop aticDeviceNexthop = this.aticDeviceService.getNexthopIpByMoid(this.moId);
        this.jyqxIp = aticDeviceNexthop.getJyqxIp();
        this.jyqxIpv6 = aticDeviceNexthop.getJyqxIpv6();
        this.jmdqxIp = aticDeviceNexthop.getJmdqxIp();
        this.jmdqxIpv6 = aticDeviceNexthop.getJmdqxIpv6();
        return "success";
    }

    public void saveNexthopIp() {
        String operation = "secne.detall.group.value.nexthop";
        String module = "lego.dic.module.ResourceApplication";
        String[] temp = new String[5];
        temp[0] = String.valueOf(this.moId);
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moId);
            BisUtil.checkUserSecurity(moIdList);
            AticDevice deviceByMoid = this.aticDeviceService.getDeviceByMoid(this.moId);
            if (null == deviceByMoid) {
                SecNELogFactory.getInstance().error((Object)"this SecurityNE is null...");
                this.systemOpeLog(operation, module, false, null, "secne.detall.group.value.nexthop.failed", temp[0], SysoplogLevel.normal.getValue(), false, null);
                this.responseResult("failure");
                return;
            }
            temp[0] = deviceByMoid.getName();
            temp[1] = this.jyqxIp;
            temp[2] = this.jmdqxIp;
            temp[3] = this.jyqxIpv6;
            temp[4] = this.jmdqxIpv6;
            AticDeviceNexthop aticDeviceNexthop = new AticDeviceNexthop(this.moId, this.jyqxIp, this.jmdqxIp, this.jyqxIpv6, this.jmdqxIpv6);
            this.aticDeviceService.saveNexthopIp(aticDeviceNexthop);
            this.systemOpeLog(operation, module, false, temp, "secne.detall.group.value.nexthop.success", temp[0], SysoplogLevel.normal.getValue(), true, null);
            SecNELogFactory.getInstance().info((Object)("updateNexthopIp--> SecurityNE modify nexthopIp --> " + temp[0] + ", cleanType = JYQX and nexthopIp ipv4= " + temp[1] + ", cleanType = JMDQX and nexthopIp ipv4= " + temp[2]));
            this.responseResult("success");
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.detall.group.value.nexthop.failed", temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            this.responseResult("failure");
        }
        catch (Exception ex) {
            this.systemOpeLog("secne.detall.group.value.nexthop", "lego.dic.module.ResourceApplication", false, temp, "secne.detall.group.value.nexthop.failed", temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            this.responseResult("failure");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getListContaner() {
        return this.listContaner;
    }

    public void setListContaner(String listContaner) {
        this.listContaner = listContaner;
    }

    public String getSimpleSystemName() {
        return this.simpleSystemName;
    }

    public void setSimpleSystemName(String simpleSystemName) {
        this.simpleSystemName = simpleSystemName;
    }

    public Long getAticCollectVale() {
        return this.aticCollectVale;
    }

    public void setAticCollectVale(Long aticCollectVale) {
        this.aticCollectVale = aticCollectVale;
    }

    public List<AticDevice> getList() {
        return this.list;
    }

    public long getMoId() {
        return this.moId;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public String getHelpLanguage() {
        return this.helpLanguage;
    }

    public void setHelpLanguage(String helpLanguage) {
        this.helpLanguage = helpLanguage;
    }

    public String getJyqxIp() {
        return this.jyqxIp;
    }

    public void setJyqxIp(String jyqxIp) {
        this.jyqxIp = jyqxIp;
    }

    public String getJmdqxIp() {
        return this.jmdqxIp;
    }

    public void setJmdqxIp(String jmdqxIp) {
        this.jmdqxIp = jmdqxIp;
    }

    public String getJyqxIpv6() {
        return this.jyqxIpv6;
    }

    public void setJyqxIpv6(String jyqxIpv6) {
        this.jyqxIpv6 = jyqxIpv6;
    }

    public String getJmdqxIpv6() {
        return this.jmdqxIpv6;
    }

    public void setJmdqxIpv6(String jmdqxIpv6) {
        this.jmdqxIpv6 = jmdqxIpv6;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IAticDeviceNfaRouterService getAticDeviceNfaRouterService() {
        return this.aticDeviceNfaRouterService;
    }

    public void setAticDeviceNfaRouterService(IAticDeviceNfaRouterService aticDeviceNfaRouterService) {
        this.aticDeviceNfaRouterService = aticDeviceNfaRouterService;
    }

    public IAticDeviceRouterService getAticDeviceRouterService() {
        return this.aticDeviceRouterService;
    }

    public void setAticDeviceRouterService(IAticDeviceRouterService aticDeviceRouterService) {
        this.aticDeviceRouterService = aticDeviceRouterService;
    }
}

