/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.list.perfmonitor;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.perfmonitor.model.CpuMemUsage;
import com.huawei.atic.sdk.perfmonitor.model.DeviceIfTraffic;
import com.huawei.atic.sdk.perfmonitor.model.PerfMonitorForm;
import com.huawei.atic.sdk.perfmonitor.service.ICpuMemUsageService;
import com.huawei.atic.sdk.perfmonitor.service.IfTrafficService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.ActionUtil;
import com.huawei.atic.util.DevCpuDescrUtil;
import com.huawei.atic.util.ExcelFileUtil;
import com.huawei.atic.util.PerfMonitorUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;

public class DevPerfMonitorAction
extends BaseAction {
    static Comparator<LangPair> comparator = new Comparator<LangPair>(){

        @Override
        public int compare(LangPair o1, LangPair o2) {
            String o1Str = "";
            String o2Str = "";
            try {
                if (!o1.getLabel().equals("0") && !o2.getLabel().equals("0")) {
                    o1Str = o1.getValue();
                    o2Str = o2.getValue();
                }
                return o1Str.compareToIgnoreCase(o2Str);
            }
            catch (LegoCheckedException e) {
                return 0;
            }
        }
    };
    static Comparator<LangPair> comparator2 = new Comparator<LangPair>(){

        @Override
        public int compare(LangPair o1, LangPair o2) {
            try {
                return Integer.parseInt(o1.getLabel()) < Integer.parseInt(o2.getLabel()) ? -1 : 1;
            }
            catch (Exception e) {
                return 0;
            }
        }
    };
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final int LATELY_2HOUR = 1;
    private static final int LAST_DAY = 2;
    private static final int CPU_INDEX = 0;
    private static final int IF_INDEX = 0;
    private static final int FLOW_UNIT = 1;
    private static final String UNKNOW_CPU = "unknow";
    private PerfMonitorForm perfMonitorForm = new PerfMonitorForm();
    private long moId;
    private String name;
    private int timeTypeValue;
    private String startTime;
    private String endTime;
    private int cpuIndexValue;
    private int ifIndexValue;
    private int flowUnitValue;
    private String ifIndex;
    private List<LangPair> cpuIndexList = new ArrayList<LangPair>();
    private List<LangPair> ifIndexList = new ArrayList<LangPair>();
    private String label;
    private String sysRunTime;
    private String netflowCount;
    private String recentDetectTime;
    private String interStatus;
    private double totalDiskValue;
    private String diskUtilization;
    private int deviceType;
    private String ifName;
    private String cpuName;
    private String flowUnit;
    private String deviceName;
    private IAticDeviceService aticDeviceService;
    private ICpuMemUsageService iCpuMemUsageService;
    private IfTrafficService ifTrafficService;
    private int refreshButtonState;

    public String perfMonitorConf() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice secNe = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (null == secNe) {
            throw new LegoCheckedException(201L);
        }
        this.deviceType = secNe.getDeviceType();
        this.name = secNe.getName();
        this.timeTypeValue = 1;
        this.cpuIndexValue = 0;
        this.ifIndexValue = 0;
        this.flowUnitValue = 1;
        Calendar currentTime = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.endTime = formatter.format(currentTime.getTime());
        currentTime.add(10, -2);
        this.startTime = formatter.format(currentTime.getTime());
        long startMillis = currentTime.getTime().getTime();
        long endMillis = startMillis + 0x6DDD00L;
        if (secNe.getDeviceModel().contains("1000")) {
            this.cpuIndexList.add(new LangPair("0", this.getText("atic.ddos.monitor.all.cpu")));
        } else {
            List<Integer> cpuIndex = this.iCpuMemUsageService.getCpuIndexById(this.moId, startMillis, endMillis);
            if (secNe.getDeviceType() == 6) {
                LangPair cpuPair = new LangPair("0", this.getText("atic.ddos.monitor.cpu.usage"));
                LangPair memoryPair = new LangPair("1", this.getText("atic.ddos.monitor.route.memory.usage"));
                this.cpuIndexList.add(cpuPair);
                this.cpuIndexList.add(memoryPair);
            } else {
                this.processCpuIndex(cpuIndex, secNe);
            }
        }
        this.cpuDescSort();
        Map<Integer, String> ifIndexMap = this.ifTrafficService.getIfIndexById(this.moId);
        this.processIfIndex(ifIndexMap);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        this.recentDetectTime = format.format(new Date());
        this.sysRunTime = this.getSystemRuntime(this.moId);
        this.queryNetFlow(secNe);
        return "success";
    }

    private String getSystemRuntime(long mid) {
        String sysruntime = "0";
        ArrayList<String> sysOids = new ArrayList<String>();
        sysOids.add("1.3.6.1.2.1.1.3.0");
        List<String> resultList = this.aticDeviceService.snmpGet(sysOids, mid);
        if (null != resultList && !resultList.isEmpty()) {
            String time = resultList.get(0);
            String timeRange = time.substring(0, time.length() - 3);
            String removeSpaceTime = timeRange.replace(" ", "");
            sysruntime = removeSpaceTime.replace(",", "");
        }
        return sysruntime;
    }

    public String queryNetFlowAuto() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice secNe = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (null == secNe) {
            throw new LegoCheckedException(201L);
        }
        this.queryNetFlow(secNe);
        return "success";
    }

    private void queryNetFlow(AticDevice secNe) {
        if (secNe.getDeviceType() != 8) {
            return;
        }
        try {
            String[] array;
            this.netflowCount = "0";
            List<String> cmds = Arrays.asList("sys", "diagnose", "display ddos license-car slot 11 cpu 0");
            logger.info((Object)("to get netflow cmds : " + cmds));
            List<String> result = this.aticDeviceService.execCmd(cmds, secNe.getMoId());
            for (String eachResult : result) {
                if (!eachResult.toLowerCase(Locale.ENGLISH).contains("error")) continue;
                logger.error((Object)("to get netflow result error : " + eachResult));
                return;
            }
            if (result.size() != 3) {
                return;
            }
            String[] lines = result.get(2).trim().split("\\r\\n");
            boolean accept = false;
            String countLine = "";
            Pattern pattern = Pattern.compile("^[\\d]+([\\s]+[\\d]+){4,4}$");
            for (String line : lines) {
                Matcher matcher;
                logger.info((Object)("to get netflow result info : " + line));
                if (null == line || !(matcher = pattern.matcher(line = line.trim())).find()) continue;
                countLine = matcher.group();
                accept = true;
                break;
            }
            for (String string : array = accept ? countLine.split("\\s+") : new String[]{}) {
                if (null != string && !string.trim().equals("") && array[1].matches("^[0-9]+$")) continue;
                return;
            }
            if (accept && array.length > 2 && null != array[1] && array[1].matches("^[0-9]+$")) {
                this.netflowCount = array[1];
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("to get netflow Lego error : " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("to get netflow error : " + e.getMessage()));
        }
    }

    private void processCpuIndex(List<Integer> cpuIndex, AticDevice secNe) {
        if (null == cpuIndex || cpuIndex.isEmpty()) {
            LangPair deviceAllCpu = new LangPair("0", this.getText("atic.ddos.monitor.all.cpu"));
            this.cpuIndexList.add(deviceAllCpu);
        } else {
            for (Integer index : cpuIndex) {
                if (index == 0) {
                    LangPair deviceAllCpu = new LangPair("0", this.getText("atic.ddos.monitor.all.cpu"));
                    this.cpuIndexList.add(deviceAllCpu);
                }
                if (1 != secNe.getDeviceType()) continue;
                if (!(DevCpuDescrUtil.checkSpuSlot(secNe, index) || secNe.getDeviceModel().toLowerCase(Locale.getDefault()).contains("antiddos1880") || secNe.getDeviceModel().toLowerCase(Locale.getDefault()).contains("antiddos1825"))) {
                    logger.info((Object)("index is LPU.The index is " + index));
                    continue;
                }
                String cpuDescr = DevCpuDescrUtil.getCpuDesc(secNe, index);
                if (cpuDescr.equals(UNKNOW_CPU)) continue;
                LangPair deviceCpuIndex = new LangPair(index.toString(), cpuDescr);
                this.cpuIndexList.add(deviceCpuIndex);
            }
        }
    }

    public void refreshCard() {
        if (this.moId != 0L) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moId);
            BisUtil.checkUserSecurity(moIdList);
        }
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.moId);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.ddos.monitor.nfa.sync.card.information");
        sysLog.setModule("lego.dic.module.ResourceApplication");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(currentUser.getIpAdr());
        sysLog.setOperator(currentUser.getUserName());
        sysLog.setTarget(aticDevice.getName());
        try {
            this.aticDeviceService.refreshCard(aticDevice);
            this.perfMonitorConf();
            sysLog.setResult(1);
            sysLog.setDetail("atic.ddos.monitor.nfa.sync.card.information.succeed");
            sysOptLog.writeOptLog(sysLog);
        }
        catch (LegoCheckedException e) {
            sysLog.setResult(0);
            long errCode = e.getErrorCode();
            sysLog.setDetail("lego.err." + errCode);
            sysOptLog.writeOptLog(sysLog);
        }
    }

    public void changeInterface() {
        if (this.moId != 0L) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moId);
            BisUtil.checkUserSecurity(moIdList);
        }
        this.interStatus = this.ifTrafficService.getInterStatus(this.moId, this.ifIndex);
        this.responseResult(this.interStatus);
    }

    private void processIfIndex(Map<Integer, String> ifIndexMap) {
        if (null == ifIndexMap || ifIndexMap.isEmpty()) {
            LangPair deviceAllIf = new LangPair("0", this.getText("atic.ddos.monitor.all.interface"));
            this.ifIndexList.add(deviceAllIf);
        } else {
            LangPair deviceAllIf = new LangPair("0", this.getText("atic.ddos.monitor.all.interface"));
            this.ifIndexList.add(deviceAllIf);
            for (Map.Entry<Integer, String> index : ifIndexMap.entrySet()) {
                LangPair deviceIfIndex = new LangPair(index.getKey().toString(), ifIndexMap.get(index.getKey()));
                this.ifIndexList.add(deviceIfIndex);
            }
            Collections.sort(this.ifIndexList, comparator2);
        }
    }

    private void cpuDescSort() {
        Collections.sort(this.cpuIndexList, comparator);
    }

    public void getCpuMemData() {
        try {
            List<CpuMemUsage> cpuUsageList;
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moId);
            BisUtil.checkUserSecurity(moIdList);
            this.perfMonitorForm.setDeviceId(this.moId);
            this.perfMonitorForm.setCpuIndex(this.cpuIndexValue);
            this.processTimeByType();
            String cpuMemUsage = "";
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.moId);
            if (aticDevice.getDeviceType() == 6) {
                this.perfMonitorForm.setCpuIndex(0);
            }
            if (CollectionUtils.isEmpty(cpuUsageList = this.iCpuMemUsageService.getTimeByIndex(this.moId, this.perfMonitorForm.getStartTime(), this.perfMonitorForm.getEndTime()))) {
                logger.info((Object)("getCpuMemData(), cpuUsageList is null, cpuUsageList = " + cpuUsageList));
                ServletActionContext.getResponse().getWriter().write(cpuMemUsage);
                return;
            }
            if (0 != this.cpuIndexValue) {
                List<CpuMemUsage> usageList = this.iCpuMemUsageService.getCpuMemUsage(this.perfMonitorForm);
                block2: for (int j = 0; j < cpuUsageList.size(); ++j) {
                    cpuUsageList.get(j).setCpuIndex(this.cpuIndexValue);
                    cpuUsageList.get(j).setCpuUsage(0);
                    cpuUsageList.get(j).setMemSize(0L);
                    cpuUsageList.get(j).setMemUsage(0);
                    cpuUsageList.get(j).setMemUsed(0L);
                    for (int i = 0; i < usageList.size(); ++i) {
                        if (cpuUsageList.get(j).getMonitorTime() != usageList.get(i).getMonitorTime()) continue;
                        cpuUsageList.get(j).setMonitorTime(usageList.get(i).getMonitorTime());
                        cpuUsageList.get(j).setCpuUsage(usageList.get(i).getCpuUsage());
                        cpuUsageList.get(j).setMemSize(usageList.get(i).getMemSize());
                        cpuUsageList.get(j).setMemUsage(usageList.get(i).getMemUsage());
                        cpuUsageList.get(j).setMemUsed(usageList.get(i).getMemUsed());
                        continue block2;
                    }
                }
            }
            PerfMonitorUtil.getDataMap().put("usage", cpuUsageList);
            cpuMemUsage = this.processUsageData(cpuUsageList);
            ServletActionContext.getResponse().getWriter().write(cpuMemUsage);
        }
        catch (IOException e) {
            logger.error((Object)"getCpuMemData() write IOException");
        }
    }

    public void getDevIfTrafficData() {
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moId);
            BisUtil.checkUserSecurity(moIdList);
            this.perfMonitorForm.setDeviceId(this.moId);
            this.perfMonitorForm.setIfIndex(this.ifIndexValue);
            this.processTimeByType();
            String trafficData = "";
            List<DeviceIfTraffic> trafficList = this.ifTrafficService.queryIfTaffic(this.perfMonitorForm);
            if (null != trafficList) {
                PerfMonitorUtil.getDataMap().put("traffic", trafficList);
                trafficData = this.processIfTrafficData(trafficList, this.flowUnitValue);
            }
            ServletActionContext.getResponse().getWriter().write(trafficData);
        }
        catch (Exception e) {
            logger.error((Object)("getDevIfTrafficData is exception!" + e.getMessage()));
        }
    }

    public void processTimeByType() {
        try {
            if (this.timeTypeValue == 1) {
                Calendar now = Calendar.getInstance();
                this.perfMonitorForm.setEndTime(now.getTimeInMillis());
                now.add(10, -2);
                this.perfMonitorForm.setStartTime(now.getTimeInMillis());
            } else if (this.timeTypeValue == 2) {
                Calendar now = Calendar.getInstance();
                this.perfMonitorForm.setEndTime(now.getTimeInMillis());
                now.add(10, -24);
                this.perfMonitorForm.setStartTime(now.getTimeInMillis());
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date start = formatter.parse(this.startTime);
                Date end = formatter.parse(this.endTime);
                this.perfMonitorForm.setStartTime(start.getTime());
                this.perfMonitorForm.setEndTime(end.getTime());
            }
        }
        catch (ParseException e) {
            logger.debug((Object)"processTimeByType || process sartTime or endTime is error!");
        }
    }

    private String processUsageData(List<CpuMemUsage> usageList) {
        String json = "";
        String cpuData = "";
        String memoryData = "";
        StringBuffer buf = new StringBuffer();
        StringBuffer buf1 = new StringBuffer();
        if (usageList != null) {
            int size = usageList.size();
            int sample = size / 100;
            int num = 0;
            if (0 == sample) {
                sample = 1;
            }
            CpuMemUsage cup = usageList.get(0);
            for (int i = 0; i < size; ++i) {
                ++num;
                if (usageList.get(i).getCpuUsage() > cup.getCpuUsage()) {
                    cup = usageList.get(i);
                }
                if (sample == num) {
                    buf1.append(this.getCupData(cup));
                    if (i < usageList.size() - 1) {
                        buf1.append(',');
                    }
                    buf.append(this.getMemData(cup));
                    if (i < usageList.size() - 1) {
                        buf.append(',');
                        cup = usageList.get(i + 1);
                    } else {
                        cup = usageList.get(i);
                    }
                    num = 0;
                    continue;
                }
                if (i != size - 1) continue;
                buf1.append(this.getCupData(cup));
                buf.append(this.getMemData(cup));
            }
            cpuData = buf1.toString();
            memoryData = buf.toString();
        }
        String unit = "(%)";
        String cpuStr = this.getText("atic.ddos.monitor.cpu.usage") + " " + unit;
        String memoryStr = this.getText("atic.ddos.monitor.memory.usage") + " " + unit;
        json = "{label :'" + cpuStr + "', color: 'rgb(77,130,249)', data: [" + cpuData + "]}#";
        json = json + "{label: '" + memoryStr + "', color: 'rgb(94,237,79)', data: [" + memoryData + "]}";
        return json;
    }

    private String getCupData(CpuMemUsage cup) {
        return "[" + cup.getMonitorTime() + "," + cup.getCpuUsage() + "]";
    }

    private String getMemData(CpuMemUsage cup) {
        return "[" + cup.getMonitorTime() + "," + cup.getMemUsage() + "]";
    }

    private String processIfTrafficData(List<DeviceIfTraffic> trafficList, int flowUnits) {
        String json = "";
        String inData = "";
        String outData = "";
        if (trafficList != null && !trafficList.isEmpty()) {
            int size = trafficList.size();
            int sample = size / 100;
            int num = 0;
            if (0 == sample) {
                sample = 1;
            }
            DeviceIfTraffic deviceIfIndex = trafficList.get(0);
            for (int i = 0; i < size; ++i) {
                ++num;
                if (flowUnits == 1 && trafficList.get(i).getInKbps() > deviceIfIndex.getInKbps()) {
                    deviceIfIndex = trafficList.get(i);
                } else if (flowUnits != 1 && trafficList.get(i).getInPps() > deviceIfIndex.getInPps()) {
                    deviceIfIndex = trafficList.get(i);
                }
                if (sample == num) {
                    inData = inData + "[" + deviceIfIndex.getMonitorTime() + "," + (flowUnits == 1 ? deviceIfIndex.getInKbps() : deviceIfIndex.getInPps()) + "]";
                    if (i < trafficList.size() - 1) {
                        inData = inData + ",";
                    }
                    outData = outData + "[" + deviceIfIndex.getMonitorTime() + "," + (flowUnits == 1 ? deviceIfIndex.getOutKbps() : deviceIfIndex.getOutPps()) + "]";
                    if (i < trafficList.size() - 1) {
                        outData = outData + ",";
                        deviceIfIndex = trafficList.get(i + 1);
                    } else {
                        deviceIfIndex = trafficList.get(i);
                    }
                    num = 0;
                    continue;
                }
                if (i != size - 1) continue;
                inData = inData + "[" + deviceIfIndex.getMonitorTime() + "," + (flowUnits == 1 ? deviceIfIndex.getInKbps() : deviceIfIndex.getInPps()) + "]";
                outData = outData + "[" + deviceIfIndex.getMonitorTime() + "," + (flowUnits == 1 ? deviceIfIndex.getOutKbps() : deviceIfIndex.getOutPps()) + "]";
            }
        }
        String unit = flowUnits == 1 ? "(kbps)" : "(pps)";
        String inFluxStr = this.getText("atic.ddos.monitor.interface.traffic.in") + " " + unit;
        String outFluxStr = this.getText("atic.ddos.monitor.interface.traffic.out") + " " + unit;
        json = "{label: '" + inFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}#";
        json = json + "{label: '" + outFluxStr + "', color: 'rgb(94,237,79)', data: [" + outData + "]}";
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData() {
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.exportData)) {
            throw new LegoCheckedException(570516L);
        }
        try {
            boolean ret;
            HttpSession session = this.getSession();
            User currentUser = (User)session.getAttribute("currentUser");
            int unitValue = Integer.parseInt(this.flowUnit);
            List<AticDevice> deviceList = this.aticDeviceService.getDeviceIdByDeviceName(this.deviceName);
            if (null != deviceList && !deviceList.isEmpty()) {
                for (AticDevice device : deviceList) {
                    if (ActionUtil.checkExportDeviceAuthority(device.getDdosType(), currentUser, device.getMoId())) continue;
                    logger.error((Object)("Export device syslog error, the user does not have authority of device " + this.deviceName));
                    throw new LegoCheckedException(571991L);
                }
            } else {
                logger.error((Object)("Export device syslog error, the user does not have authority of device " + this.deviceName));
                throw new LegoCheckedException(571991L);
            }
            String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
            File file = new File(downloadPath);
            if (!file.exists() && !(ret = file.mkdir())) {
                return;
            }
            Long dateTime = System.currentTimeMillis();
            String fileNameTmp = "exportData_" + dateTime;
            downloadPath = downloadPath + File.separator + fileNameTmp;
            ArrayList<String> labelName = new ArrayList<String>();
            labelName.add(this.getText("atic.ddos.monitor.device.peformance"));
            labelName.add(this.getText("atic.ddos.monitor.interface.traffic"));
            ArrayList<List<String>> colTitel = new ArrayList<List<String>>();
            ArrayList<String> usageCol = new ArrayList<String>();
            usageCol.add(this.getText("atic.ddos.monitor.time"));
            usageCol.add(this.getText("atic.ddos.monitor.device.name"));
            usageCol.add(this.getText("atic.ddos.monitor.cpu.index.name"));
            usageCol.add(this.getText("atic.ddos.monitor.cpu.usage"));
            usageCol.add(this.getText("atic.ddos.monitor.memory.usage"));
            colTitel.add(usageCol);
            ArrayList<String> trafficCol = new ArrayList<String>();
            trafficCol.add(this.getText("atic.ddos.monitor.time"));
            trafficCol.add(this.getText("atic.ddos.monitor.device.name"));
            trafficCol.add(this.getText("atic.ddos.monitor.inteface.name"));
            if (unitValue == 1) {
                trafficCol.add(this.getText("atic.ddos.monitor.inteface.in.kbps"));
                trafficCol.add(this.getText("atic.ddos.monitor.inteface.out.kbps"));
            } else {
                trafficCol.add(this.getText("atic.ddos.monitor.inteface.in.pps"));
                trafficCol.add(this.getText("atic.ddos.monitor.inteface.out.pps"));
            }
            colTitel.add(trafficCol);
            ExcelFileUtil fileUtil = new ExcelFileUtil();
            fileUtil.fileSetCol(labelName, colTitel, downloadPath);
            fileUtil.writeData2File(this.logToStr(unitValue, this.deviceName, this.ifName, this.cpuName));
            try {
                fileUtil.closeFile();
            }
            catch (IOException e) {
                this.systemOpeLog("atic.ddos.monitor.export.log", "lego.dic.module.ResourceApplication", false, new String[]{this.deviceName}, "atic.ddos.monitor.export.fail.detail", this.deviceName, SysoplogLevel.normal.getValue(), false, null);
                logger.error((Object)"Export data of perfMonitor is exception");
                OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.exportData);
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = df.format(new Date());
            fileUtil.downloadNameFile(this.getResponse(), "perfMonitor_" + date);
            this.systemOpeLog("atic.ddos.monitor.export.log", "lego.dic.module.ResourceApplication", false, new String[]{this.deviceName}, "atic.ddos.monitor.export.success.detail", this.deviceName, SysoplogLevel.normal.getValue(), true, null);
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog("atic.ddos.monitor.export.log", "lego.dic.module.ResourceApplication", false, new String[]{this.deviceName}, "atic.ddos.monitor.export.fail.detail", this.deviceName, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            this.systemOpeLog("atic.ddos.monitor.export.log", "lego.dic.module.ResourceApplication", false, new String[]{this.deviceName}, "atic.ddos.monitor.export.fail.detail", this.deviceName, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.exportData);
        }
    }

    public Map<String, List<List<String>>> logToStr(int unitValue, String deviceNames, String ifNames, String cpuNames) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, List<List<String>>> mapStr = new HashMap<String, List<List<String>>>();
        ArrayList trafficStr = new ArrayList();
        ArrayList cpuStr = new ArrayList();
        Map<String, List<?>> dataMap = PerfMonitorUtil.getDataMap();
        List<?> usageList = dataMap.get("usage");
        List<?> trafficList = dataMap.get("traffic");
        if (null != usageList) {
            for (CpuMemUsage usage : usageList) {
                ArrayList<String> tempUsage = new ArrayList<String>();
                tempUsage.add(formatter.format(usage.getMonitorTime()));
                tempUsage.add(deviceNames);
                tempUsage.add(cpuNames);
                tempUsage.add(usage.getCpuUsage() + "");
                tempUsage.add(usage.getMemUsage() + "");
                cpuStr.add(tempUsage);
            }
        }
        mapStr.put("usage", cpuStr);
        if (null != trafficList) {
            for (DeviceIfTraffic traffic : trafficList) {
                ArrayList<String> tempTraffic = new ArrayList<String>();
                tempTraffic.add(formatter.format(traffic.getMonitorTime()));
                tempTraffic.add(deviceNames);
                tempTraffic.add(ifNames);
                if (unitValue == 1) {
                    tempTraffic.add(traffic.getInKbps() + "");
                    tempTraffic.add(traffic.getOutKbps() + "");
                } else {
                    tempTraffic.add(traffic.getInPps() + "");
                    tempTraffic.add(traffic.getOutPps() + "");
                }
                trafficStr.add(tempTraffic);
            }
        }
        mapStr.put("traffic", trafficStr);
        return mapStr;
    }

    public boolean validateDeviceName() {
        if (this.deviceName == null || "".equals(this.deviceName.trim()) || "null".equals(this.deviceName)) {
            return false;
        }
        if (this.deviceName.length() > 32) {
            return false;
        }
        String nameRegex = "^[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return this.deviceName.matches(nameRegex);
    }

    public boolean validateIfIndex() {
        if (this.ifIndex == null) {
            return true;
        }
        Integer iIndex = Integer.parseInt(this.ifIndex);
        return iIndex >= 0;
    }

    public boolean validateStringIfName() {
        String regex = "^[\u4e00-\u9fa5|\\w|\\.|\\-|\\ |\\/]*$";
        if (null != this.ifName) {
            try {
                this.ifName = URLDecoder.decode(this.ifName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage());
                this.ifName = "";
            }
            return this.ifName.matches(regex);
        }
        return false;
    }

    public boolean validateStringCpuName() {
        String regex = "^[A-Z|a-z|0-9|\u4e00-\u9fa5|\\/|\\ ]*$";
        if (null != this.cpuName) {
            try {
                this.cpuName = URLDecoder.decode(this.cpuName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage());
                this.cpuName = "";
            }
            return this.cpuName.matches(regex);
        }
        return false;
    }

    public boolean validateDate(String date) {
        if (null != date) {
            if (date.equals("")) {
                return true;
            }
            return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
        }
        return false;
    }

    public PerfMonitorForm getPerfMonitorForm() {
        return this.perfMonitorForm;
    }

    public void setPerfMonitorForm(PerfMonitorForm perfMonitorForm) {
        this.perfMonitorForm = perfMonitorForm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getMoId() {
        return this.moId;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public int getTimeTypeValue() {
        return this.timeTypeValue;
    }

    public void setTimeTypeValue(int timeTypeValue) {
        this.timeTypeValue = timeTypeValue;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public int getCpuIndexValue() {
        return this.cpuIndexValue;
    }

    public void setCpuIndexValue(int cpuIndexValue) {
        this.cpuIndexValue = cpuIndexValue;
    }

    public int getIfIndexValue() {
        return this.ifIndexValue;
    }

    public void setIfIndexValue(int ifIndexValue) {
        this.ifIndexValue = ifIndexValue;
    }

    public int getFlowUnitValue() {
        return this.flowUnitValue;
    }

    public void setFlowUnitValue(int flowUnitValue) {
        this.flowUnitValue = flowUnitValue;
    }

    public List<LangPair> getCpuIndexList() {
        return this.cpuIndexList;
    }

    public void setCpuIndexList(List<LangPair> cpuIndexList) {
        this.cpuIndexList = cpuIndexList;
    }

    public List<LangPair> getIfIndexList() {
        return this.ifIndexList;
    }

    public void setIfIndexList(List<LangPair> ifIndexList) {
        this.ifIndexList = ifIndexList;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSysRunTime() {
        return this.sysRunTime;
    }

    public void setSysRunTime(String sysRunTime) {
        this.sysRunTime = sysRunTime;
    }

    public String getInterStatus() {
        return this.interStatus;
    }

    public void setInterStatus(String interStatus) {
        this.interStatus = interStatus;
    }

    public double getTotalDiskValue() {
        return this.totalDiskValue;
    }

    public void setTotalDiskValue(double totalDiskValue) {
        this.totalDiskValue = totalDiskValue;
    }

    public String getDiskUtilization() {
        return this.diskUtilization;
    }

    public void setDiskUtilization(String diskUtilization) {
        this.diskUtilization = diskUtilization;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public String getRecentDetectTime() {
        return this.recentDetectTime;
    }

    public void setRecentDetectTime(String recentDetectTime) {
        this.recentDetectTime = recentDetectTime;
    }

    public String getIfName() {
        return this.ifName;
    }

    public void setIfName(String ifName) {
        this.ifName = ifName;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public void setCpuName(String cpuName) {
        this.cpuName = cpuName;
    }

    public String getFlowUnit() {
        return this.flowUnit;
    }

    public void setFlowUnit(String flowUnit) {
        this.flowUnit = flowUnit;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ICpuMemUsageService getiCpuMemUsageService() {
        return this.iCpuMemUsageService;
    }

    public void setiCpuMemUsageService(ICpuMemUsageService cpuMemUsageService) {
        this.iCpuMemUsageService = cpuMemUsageService;
    }

    public IfTrafficService getIfTrafficService() {
        return this.ifTrafficService;
    }

    public void setIfTrafficService(IfTrafficService ifTrafficService) {
        this.ifTrafficService = ifTrafficService;
    }

    public String getIfIndex() {
        return this.ifIndex;
    }

    public void setIfIndex(String ifIndex) {
        this.ifIndex = ifIndex;
    }

    public int getRefreshButtonState() {
        return this.refreshButtonState;
    }

    public void setRefreshButtonState(int refreshButtonState) {
        this.refreshButtonState = refreshButtonState;
    }

    public String getNetflowCount() {
        return this.netflowCount;
    }

    public void setNetflowCount(String netflowCount) {
        this.netflowCount = netflowCount;
    }
}

