/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.protocol;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.sdk.res.service.ICertManagementParentService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AESUtil;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogResultLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.device.model.AticDeviceNfaRouter;
import com.huawei.atic.device.model.AticDeviceRouter;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.plat.template.webapp.TelnetTemplateVO;
import com.huawei.atic.plat.template.webapp.TemplateVO;
import com.huawei.atic.res.model.form.AticDeviceRouterForm;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.common.SecNELogFactory;
import com.huawei.atic.secne.common.SecNEReportLogFactory;
import com.huawei.atic.secne.protocol.FtpVO;
import com.huawei.atic.secne.protocol.RestfulDdosVO;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secne.sdk.service.IUndoZoneParentService;
import com.huawei.atic.secservice.ddos.restful.model.RequestURLForm;
import com.huawei.atic.secservice.ddos.restful.service.IRestfulDdosService;
import com.huawei.atic.secservice.ddos.restful.util.RestDdosUtil;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.south.model.Protocol;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.system.template.sdk.service.ITemplateService;
import com.huawei.atic.util.CommonUtil;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ManageProtocalAction
extends BaseAction {
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    public static final String COLLECTOR_MAIN_TYPE = "atic.portal.mainType.collector";
    public static final int MIN_LENGTH_0 = 0;
    public static final int MIN_LENGTH_1 = -1;
    public static final int READ_WRITE_MIN_LENGTH = 6;
    public static final int MAX_LENGTH_32 = 33;
    public static final int MAX_LENGTH_64 = 65;
    public static final int START_DELAY_DEFAULT = 1;
    public static final int END_DELAY_DEFAULT = 10;
    public static final int SSH_PUBLICKEY_NULL = 0;
    private static List<LangPair> lstauthProtocol = null;
    private static final long serialVersionUID = -1057520591759045317L;
    private static final long NUM_5 = 5L;
    private static final int MAXPROTEMPLATENUM = 100;
    private static final int COLLECTOR_STATUS_IN = 1;
    private static List<LangPair> lstencryptProtocol = null;
    List<AticDeviceRouterForm> flowFormList;
    List<AticDeviceRouterForm> existList;
    private transient TemplateVO snmpTemplate;
    private transient TelnetTemplateVO telnetTemplate;
    private transient FtpVO ftpTemplate;
    private transient RestfulDdosVO restfulDdosTemplate;
    private List<LangPair> lstAuthtemp;
    private List<LangPair> lstTelAuthtemp;
    private List<LangPair> lstPrivateLevel;
    private List<LangPair> lstsnmpv1temp;
    private List<LangPair> lstsnmpv2temp;
    private List<LangPair> lstsnmpv3temp;
    private List<LangPair> lstTelnettemp;
    private List<LangPair> lstStelnettemp;
    private AticDeviceRouter aticDeviceRouter;
    private String flowIdList;
    private boolean isSupportOutbound = false;
    private String hasTel;
    private List<LangPair> sampleModeList;
    private transient TemplateVO snmpTempate;
    private String adminId;
    private Long templateID;
    private Integer sauthMode;
    private String authModeName;
    private String sauthModeName;
    private Long moid;
    private String simpleSystemName;
    private String logIp;
    private String ipAddress;
    private String deviceName;
    private File privateKeyFile;
    private String neIDsStr;
    private String testOid;
    private String sshPublicKey;
    private String logPwd;
    private boolean encryptType;
    private int deviceType;
    private int logSwitchValue;
    private List<AticDevice> firewallList;
    private List<AticDevice> fireDeviceList;
    private String neIds;
    private String deviceIdList;
    private transient IAticDeviceService aticDeviceService;
    private int isClusterNfa;
    private String addNeTestFlag = "false";
    private String authMode;
    private String prototolType;
    private String port;
    private String deviceLoginUser;
    private String deviceLoginPwd;
    private String protocolVersion;
    private String loginTimeout;
    private String responseTimeout;
    private String versionType;
    private String retries;
    private String timeout;
    private String snmpReadComm;
    private String snmpWriteComm;
    private String v3securityName;
    private String v3contextName;
    private String v3contextEngineId;
    private String v3authProtocol;
    private String v3authPwd;
    private String v3encryptProtocol;
    private String v3encryptPwd;
    private Boolean clusterOutbound = false;
    private String addNeTestRouter = "";
    private transient IResourceService resourceService;
    private transient IClusterService clusterService;
    private transient IAticDeviceRouterService aticDeviceRouterService;
    private transient IAticDeviceNfaRouterService aticDeviceNfaRouterService;
    private transient ITemplateService templateService;
    private transient IDiscoveryService discoveryService;
    private transient ICollectorDeviceService collectorDeviceService;
    private transient ICollectorService collectorService;
    private transient IDefendGroupService defendGroupService;
    private transient ISysOptLog sysLogService;
    private Boolean restfulDdosEnable;
    private Integer restfulDdosType;
    private Integer restfulDdosPort;
    private String restfulDdosIp;
    private String restfulDdosUser;
    private String restfulDdosPassword;
    private String restfulCertAlias;
    private ArrayList<LangPair> certList;

    public String getSimpleSystemName() {
        return this.simpleSystemName;
    }

    public void setSimpleSystemName(String simpleSystemName) {
        this.simpleSystemName = simpleSystemName;
    }

    public String sendEditConfig() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(Long.parseLong(this.neIDsStr));
        BisUtil.checkUserSecurity(moIdList);
        Node neNode = this.resourceService.getDeviceDetailInfo(Long.parseLong(this.neIDsStr));
        if (neNode == null) {
            throw new LegoCheckedException(660020L);
        }
        if (neNode.getManagementProtocolMap().containsKey(TelnetPara.class.getName())) {
            this.fetchRequest().setAttribute("hasTelnet", (Object)"true");
        } else {
            this.fetchRequest().setAttribute("hasTelnet", (Object)"false");
        }
        boolean flag = this.clusterService.isBelongCluster(Long.valueOf(this.neIDsStr));
        this.isClusterNfa = flag ? 1 : 0;
        this.fetchRequest().setAttribute("cluster", (Object)String.valueOf(this.isClusterNfa));
        if (!StringUtils.isNotBlank((CharSequence)this.neIDsStr)) {
            logger.error((Object)"neIDsStr is null");
            throw new LegoCheckedException(570505L);
        }
        this.fetchRequest().setAttribute("neIDs", (Object)this.neIDsStr);
        return "success";
    }

    public String secNeEditRoute() {
        if (!StringUtils.isNotBlank((CharSequence)this.neIDsStr)) {
            logger.error((Object)"neIDsStr is null");
            throw new LegoCheckedException(570505L);
        }
        this.fetchRequest().setAttribute("neIDs", (Object)this.neIDsStr);
        return "success";
    }

    public String secNeEditNfaCluster() {
        if (!StringUtils.isNotBlank((CharSequence)this.neIDsStr)) {
            logger.error((Object)"neIDsStr is null");
            throw new LegoCheckedException(570505L);
        }
        this.fetchRequest().setAttribute("neIDs", (Object)this.neIDsStr);
        return "success";
    }

    public String editClusterDevices() {
        if (null != this.moid) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moid);
            BisUtil.checkUserSecurity(moIdList);
        }
        this.fireDeviceList = this.aticDeviceService.getDeviceListByClusterId(this.moid);
        return "success";
    }

    public String editSnmpFra() {
        this.lstsnmpv1temp = new ArrayList<LangPair>();
        List<SnmpPara> snmpv1Lst = this.getSnmpLstByVer("v1");
        if (snmpv1Lst != null) {
            for (SnmpPara snmpPara : snmpv1Lst) {
                LangPair langPair = new LangPair(snmpPara.getTemplateName(), snmpPara.getId() + "");
                this.lstsnmpv1temp.add(langPair);
            }
        }
        this.lstsnmpv2temp = new ArrayList<LangPair>();
        List<SnmpPara> snmpv2Lst = this.getSnmpLstByVer("v2c");
        if (snmpv2Lst != null) {
            for (SnmpPara snmpPara : snmpv2Lst) {
                LangPair tempLp = new LangPair(snmpPara.getTemplateName(), snmpPara.getId() + "");
                this.lstsnmpv2temp.add(tempLp);
            }
        }
        this.lstsnmpv3temp = new ArrayList<LangPair>();
        List<SnmpPara> list = this.getSnmpLstByVer("v3");
        if (list != null) {
            for (SnmpPara snmpPar : list) {
                LangPair tempLp = new LangPair(snmpPar.getTemplateName(), snmpPar.getId() + "");
                this.lstsnmpv3temp.add(tempLp);
            }
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(this.moid);
        BisUtil.checkUserSecurity(arrayList);
        Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
        this.ipAddress = neNode.getIpAddress();
        Map<String, Protocol> map = neNode.getManagementProtocolMap();
        if (map.containsKey(SnmpPara.class.getName())) {
            SnmpPara snmp = (SnmpPara)map.get(SnmpPara.class.getName());
            this.snmpTemplate = new TemplateVO(snmp);
        } else {
            this.snmpTemplate = new TemplateVO();
            this.snmpTemplate.setVersion(3);
            this.snmpTemplate.setRetries(5);
            this.snmpTemplate.setTimeout(5);
            this.snmpTemplate.setPort(161);
            this.snmpTemplate.setAuthProtocol("HMACMD5");
        }
        return "success";
    }

    public String editSnmpRouterFra() {
        this.lstsnmpv1temp = new ArrayList<LangPair>();
        List<SnmpPara> snmpv1List = this.getSnmpLstByVer("v1");
        if (null != snmpv1List) {
            for (SnmpPara snmpPara : snmpv1List) {
                LangPair langPair = new LangPair(snmpPara.getTemplateName(), String.valueOf(snmpPara.getId()));
                this.lstsnmpv1temp.add(langPair);
            }
        }
        this.lstsnmpv2temp = new ArrayList<LangPair>();
        List<SnmpPara> snmpv2List = this.getSnmpLstByVer("v2c");
        if (null != snmpv2List) {
            for (SnmpPara snmpPara : snmpv2List) {
                LangPair tempLp = new LangPair(snmpPara.getTemplateName(), String.valueOf(snmpPara.getId()));
                this.lstsnmpv2temp.add(tempLp);
            }
        }
        this.lstsnmpv3temp = new ArrayList<LangPair>();
        List<SnmpPara> list = this.getSnmpLstByVer("v3");
        if (null != list) {
            for (SnmpPara snmpPar : list) {
                LangPair tempLp = new LangPair(snmpPar.getTemplateName(), String.valueOf(snmpPar.getId()));
                this.lstsnmpv3temp.add(tempLp);
            }
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(this.moid);
        BisUtil.checkUserSecurity(arrayList);
        Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
        this.ipAddress = neNode.getIpAddress();
        Map<String, Protocol> map = neNode.getManagementProtocolMap();
        if (map.containsKey(SnmpPara.class.getName())) {
            SnmpPara snmp = (SnmpPara)map.get(SnmpPara.class.getName());
            this.snmpTemplate = new TemplateVO(snmp);
        } else {
            this.snmpTemplate = new TemplateVO();
            this.snmpTemplate.setVersion(3);
            this.snmpTemplate.setRetries(5);
            this.snmpTemplate.setTimeout(5);
            this.snmpTemplate.setPort(161);
            this.snmpTemplate.setAuthProtocol("HMACMD5");
            logger.error((Object)"ManageProtocalAction.editSnmpRouterFra() init snmp failed");
        }
        this.aticDeviceRouter = this.aticDeviceRouterService.findByMoId(this.moid);
        return "success";
    }

    public String editFlowRouterFra() {
        this.sampleModeList = new ArrayList<LangPair>();
        this.sampleModeList.add(new LangPair(this.getText("vsm.secne.ddos.device.flow.manual"), "1"));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        this.aticDeviceRouter = this.aticDeviceRouterService.findByMoId(this.moid);
        return "success";
    }

    public String secNEEditFlowFra() {
        List<AticDeviceRouter> list;
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.moid);
        if (null == aticDevice) {
            throw new LegoCheckedException(201L);
        }
        this.ipAddress = aticDevice.getIpAddress();
        List<AticDeviceNfaRouter> aticDeviceNfaRouterList = this.aticDeviceNfaRouterService.findByNfaId(this.moid);
        ArrayList<Long> paramters = new ArrayList<Long>();
        if (null != aticDeviceNfaRouterList && !aticDeviceNfaRouterList.isEmpty()) {
            for (AticDeviceNfaRouter entity : aticDeviceNfaRouterList) {
                paramters.add(entity.getRouterId());
            }
        }
        if (null != (list = this.aticDeviceRouterService.queryListByMoId(paramters)) && !list.isEmpty()) {
            this.existList = new ArrayList<AticDeviceRouterForm>();
            for (AticDeviceRouter entity : list) {
                AticDeviceRouterForm form = new AticDeviceRouterForm();
                form.setMoId(entity.getMoId());
                form.setName(entity.getParameter().getName());
                form.setFlowSrcIp(entity.getFlowSrcIp());
                form.setFlowDstPort(entity.getFlowDstPort());
                form.setSampleMode(entity.getSampleMode());
                form.setSampleRatio(entity.getSampleRatio());
                form.setAgeTime(entity.getAgeTime());
                form.setCpuOid(entity.getCpuOid());
                form.setMemeryOid(entity.getMemeryOid());
                this.existList.add(form);
            }
        }
        return "success";
    }

    public String editTelnetFra() {
        this.lstAuthtemp = new ArrayList<LangPair>();
        this.lstAuthtemp.add(new LangPair(this.getText("lego.dic.auth.pwd"), "0"));
        this.lstAuthtemp.add(new LangPair(this.getText("lego.dic.auth.rsa"), "1"));
        this.lstTelAuthtemp = new ArrayList<LangPair>();
        this.lstTelAuthtemp.add(new LangPair(this.getText("lego.dic.auth.none"), "0"));
        this.lstTelAuthtemp.add(new LangPair(this.getText("lego.dic.auth.user"), "1"));
        this.lstTelAuthtemp.add(new LangPair(this.getText("lego.dic.auth.pwd"), "2"));
        this.lstTelnettemp = new ArrayList<LangPair>();
        List<TelnetPara> telLst = this.getTelnetLstByType("Telnet");
        if (telLst != null) {
            for (TelnetPara telnetPara : telLst) {
                LangPair tempLp = new LangPair(telnetPara.getTemplateName(), telnetPara.getId() + "");
                this.lstTelnettemp.add(tempLp);
            }
        }
        this.lstStelnettemp = new ArrayList<LangPair>();
        List<TelnetPara> stelLst = this.getTelnetLstByType("STELNET");
        if (stelLst != null) {
            for (TelnetPara telPar : stelLst) {
                LangPair tempLp = new LangPair(telPar.getTemplateName(), telPar.getId() + "");
                this.lstStelnettemp.add(tempLp);
            }
        }
        this.lstPrivateLevel = new ArrayList<LangPair>();
        int n = 16;
        for (int i = 0; i < n; ++i) {
            this.lstPrivateLevel.add(new LangPair(i + "", i + ""));
        }
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
        this.ipAddress = neNode.getIpAddress();
        this.sshPublicKey = this.getDdosDevSshPublicKey(this.ipAddress);
        Map<String, Protocol> map = neNode.getManagementProtocolMap();
        if (map.containsKey(TelnetPara.class.getName())) {
            TelnetPara tel = (TelnetPara)map.get(TelnetPara.class.getName());
            this.telnetTemplate = new TelnetTemplateVO(tel);
            if (0 == this.telnetTemplate.getPrototolType()) {
                this.authModeName = 0L == (long)this.telnetTemplate.getAuthMode() ? this.getText("lego.dic.auth.none") : (1L == (long)this.telnetTemplate.getAuthMode() ? this.getText("lego.dic.auth.user") : this.getText("lego.dic.auth.pwd"));
            } else {
                this.sauthMode = this.telnetTemplate.getAuthMode();
                this.sauthModeName = 0L == (long)this.telnetTemplate.getAuthMode() ? this.getText("lego.dic.auth.pwd") : this.getText("lego.dic.auth.rsa");
            }
        } else {
            this.telnetTemplate = new TelnetTemplateVO();
            this.telnetTemplate.setPrototolType(1);
            this.telnetTemplate.setAuthMode(0);
            this.telnetTemplate.setPort(22);
            this.telnetTemplate.setLoginTimeout(5L);
            this.telnetTemplate.setResponseTimeout(5L);
            this.sauthMode = this.telnetTemplate.getAuthMode();
            this.sauthModeName = this.getText("lego.dic.auth.pwd");
        }
        return "success";
    }

    private String getDdosDevSshPublicKey(String ddosIpAddress) {
        AticDevice device = this.aticDeviceService.getDeviceByIp(ddosIpAddress);
        return device.getSshPublicKey();
    }

    public String editFtpFra() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
        if (null == device) {
            throw new LegoCheckedException(201L);
        }
        this.ftpTemplate = new FtpVO();
        this.ftpTemplate.setProtocolType(device.getFtpType());
        this.ftpTemplate.setPort(device.getFtpPort());
        this.ftpTemplate.setLoginUser(device.getFtpUser());
        this.ftpTemplate.setLoginPwd(device.getFtpPassword());
        return "success";
    }

    public String editlogIpFra() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
        if (null == device) {
            throw new LegoCheckedException(201L);
        }
        this.logIp = device.getLogIp();
        this.logPwd = device.getLogPwd();
        this.deviceType = device.getDeviceType();
        this.logSwitchValue = device.getEncryptType();
        this.encryptType = device.getEncryptType() == 1;
        return "success";
    }

    public String editClusterKey() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
        if (null == device) {
            throw new LegoCheckedException(201L);
        }
        this.logPwd = device.getLogPwd();
        return "success";
    }

    public List<SnmpPara> getSnmpLstByVer(String version) {
        List snmpLst = null;
        Properties pro = new Properties();
        if ("v1".equals(version)) {
            pro.put("version", (Object)0);
        } else if ("v3".equals(version)) {
            pro.put("version", (Object)3);
        } else if ("v2c".equals(version)) {
            pro.put("version", (Object)1);
        } else {
            return null;
        }
        Paging paging = this.templateService.getTemplateList(pro, SnmpPara.class.getName(), 0, 100);
        if (null != paging) {
            snmpLst = paging.getData();
        }
        return snmpLst;
    }

    public List<TelnetPara> getTelnetLstByType(String type) {
        List telnetLst = null;
        Properties pro1 = new Properties();
        if ("Telnet".equals(type)) {
            pro1.put("protocolType", (Object)0);
        } else if ("STELNET".equals(type)) {
            pro1.put("protocolType", (Object)1);
        }
        Paging paging1 = this.templateService.getTemplateList(pro1, TelnetPara.class.getName(), this.start, this.pageSize);
        if (null != paging1) {
            telnetLst = paging1.getData();
        }
        return telnetLst;
    }

    public void saveTelnet() {
        this.getResponse().setContentType("text/html");
        String operation = "secne.dic.function.settelnet";
        String module = "lego.dic.module.ResourceApplication";
        String[] temp = new String[2];
        try {
            AticDevice device;
            if (this.telnetTemplate.getPrototolType() == 1) {
                this.telnetTemplate.setAuthMode(this.sauthMode);
            }
            TelnetPara sp = this.telnetTemplate.getTemplate();
            this.enCrytpTelnet(sp);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moid);
            BisUtil.checkUserSecurity(moIdList);
            Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
            if (neNode == null) {
                throw new LegoCheckedException(660020L);
            }
            temp[0] = neNode.getName();
            temp[1] = neNode.getIpAddress();
            if (sp.getProtocolType() == 0 && sp.getAuthMode() != 0 && sp.getLoginPwd() == null) {
                sp.setLoginPwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getLoginPwd());
            }
            if (sp.getProtocolType() == 1) {
                if (sp.getAuthMode() == 0 && sp.getLoginPwd() == null) {
                    sp.setLoginPwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getLoginPwd());
                }
                if (sp.getAuthMode() == 1 && sp.getPrivateKeyPwd() == null) {
                    sp.setPrivateKeyPwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getPrivateKeyPwd());
                }
            }
            if (sp.isIsEnable() && sp.getPrivilegePwd() == null) {
                sp.setPrivilegePwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getPrivilegePwd());
            }
            if (neNode.getManagementProtocolMap().containsKey(TelnetPara.class.getName())) {
                sp.setId(neNode.getManagementProtocolMap().get(TelnetPara.class.getName()).getId());
                sp.setNode(neNode);
                this.discoveryService.modifyManagementProtocol(sp);
            } else {
                sp.setId(null);
                this.discoveryService.addManagementProtocol(sp, this.moid);
            }
            if (0 == sp.getProtocolType()) {
                this.sshPublicKey = "";
            }
            if (null != (device = this.aticDeviceService.getDeviceByMoid(this.moid))) {
                String sshKey = AticUtil.replaceBlank((String)this.sshPublicKey.trim());
                device.setSshPublicKey(sshKey);
                this.aticDeviceService.saveOrUpdate(device);
            }
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.telnet.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
            SecNELogFactory.getInstance().info((Object)("save Telnet--> " + temp[0] + ", ipAddress = " + temp[1]));
            this.responseResult("success");
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.telnet.info.failed", temp[0] == null ? this.deviceName : temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.telnet.info.failed", temp[0] == null ? this.deviceName : temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void saveClusterKey() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
        if (null == device) {
            throw new LegoCheckedException(201L);
        }
        String[] temp = new String[]{device.getName(), device.getIpAddress()};
        try {
            if (null != this.logPwd && !"".equals(this.logPwd.trim())) {
                device.setLogPwd(DataProtectServiceConst.sdpEncryptLocal((String)this.logPwd));
            } else {
                device.setLogPwd(null);
            }
            boolean deployResult = true;
            if (null != this.logPwd) {
                deployResult = this.deployClusterKey(this.logPwd);
            }
            if (deployResult) {
                this.aticDeviceService.saveOrUpdate(device);
                this.systemOpeLog("secne.dic.function.setclusterkey", "lego.dic.module.ResourceApplication", false, temp, "secne.log.module.ne.protocol.clusterkey.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
                this.responseResult("success");
            } else {
                this.writeSysLog(device, "secne.dic.function.setclusterkey", "secne.log.module.ne.protocol.clusterkey.info.failed", temp);
                this.responseResult("failure");
            }
        }
        catch (LegoCheckedException e) {
            this.writeSysLog(device, "secne.dic.function.setclusterkey", "secne.log.module.ne.protocol.clusterkey.info.failed", temp);
            logger.error((Object)"logPwd is error");
            this.responseResult("failure");
        }
        catch (Exception e) {
            this.writeSysLog(device, "secne.dic.function.setclusterkey", "secne.log.module.ne.protocol.clusterkey.info.failed", temp);
            logger.error((Object)"logPwd is error");
            this.responseResult("failure");
        }
    }

    private boolean deployClusterKey(String secretKey) {
        List<AticDevice> nfaDeviceList = this.clusterService.getDeviceListByVirtualId(this.moid);
        if (null == nfaDeviceList) {
            logger.error((Object)"nfaDeviceList is null");
            return false;
        }
        boolean deployState = true;
        for (AticDevice aticDevice : nfaDeviceList) {
            if (this.aticDeviceService.deployClusterCommuKey(aticDevice.getMoId(), secretKey)) continue;
            deployState = false;
        }
        return deployState;
    }

    public void savelogIp() {
        String operation = "secne.dic.function.setlogIp";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.logIp;
        String[] temp = new String[3];
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moid);
            BisUtil.checkUserSecurity(moIdList);
            AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
            if (null == device) {
                throw new LegoCheckedException(201L);
            }
            temp[0] = device.getName();
            target = device.getName();
            temp[1] = device.getIpAddress();
            temp[2] = this.encryptType ? "secne.log.module.ne.protocol.logIp.info.open" : "secne.log.module.ne.protocol.logIp.info.close";
            String templogIp = "";
            if (null != device.getLogIp()) {
                templogIp = device.getLogIp();
                if (!AticUtil.isNull((String)this.logIp)) {
                    if (this.isCollectorIpExists(this.logIp)) {
                        this.systemOpeLog(operation, module, false, temp, "lego.err.660086", target, SysoplogLevel.normal.getValue(), false, null);
                        this.setResponse();
                        this.responseResult("failure," + this.getText("lego.err.660086"));
                        return;
                    }
                    if (this.isDeviceIpExists(this.logIp) && !this.logIp.equals(device.getIpAddress())) {
                        this.systemOpeLog(operation, module, false, temp, "lego.err.660077", target, SysoplogLevel.normal.getValue(), false, null);
                        this.setResponse();
                        this.responseResult("failure," + this.getText("lego.err.660077"));
                        return;
                    }
                }
                device.setLogIp(this.logIp);
            } else if (null != this.logIp) {
                device.setLogIp(this.logIp);
            }
            try {
                if (null != this.logPwd) {
                    device.setLogPwd(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(AESUtil.getPBKDF2SHA256Pwd((String)this.logPwd))));
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)("logPwd is error " + e.getMessage()));
            }
            catch (InvalidKeySpecException e) {
                logger.error((Object)("logPwd is error " + e.getMessage()));
            }
            if (CommonUtil.isNewDevice(device)) {
                if (this.encryptType) {
                    device.setEncryptType(1);
                } else {
                    device.setEncryptType(2);
                }
            } else {
                device.setEncryptType(0);
            }
            Long collectorId = null;
            if (this.clusterService.isBelongCluster(this.moid)) {
                AticDeviceNfaCluster aticDeviceNfaCluster = this.clusterService.getClusterByNfaId(this.moid);
                collectorId = this.collectorDeviceService.getCollectorIdByDevId(aticDeviceNfaCluster.getClusterId());
            } else {
                collectorId = this.collectorDeviceService.getCollectorIdByDevId(this.moid);
            }
            CollectorInfo collectorInfo = null;
            if (null != collectorId) {
                collectorInfo = this.collectorService.getCollectorInfo(collectorId);
                if (1 != collectorInfo.getStatus()) {
                    this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.logIp.info.failedone", target, SysoplogLevel.normal.getValue(), false, null);
                    this.setResponse();
                    this.responseResult("failure," + this.getText("lego.err.660080"));
                    return;
                }
                boolean update = false;
                if (device.getDeviceType() == 1 || device.getDeviceType() == 8) {
                    update = this.collectorDeviceService.updateLogIp(device);
                }
                if (!update) {
                    this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.logIp.info.failedtwo", target, SysoplogLevel.normal.getValue(), false, null);
                    this.setResponse();
                    this.responseResult("failure," + this.getText("lego.err.660081"));
                    return;
                }
                boolean updateDevice = this.collectorDeviceService.updateDeviceAccess(device, collectorInfo.getIpAddress());
                if (!updateDevice) {
                    this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.logIp.info.failedthree", target, SysoplogLevel.normal.getValue(), false, null);
                    device.setLogIp(templogIp);
                    this.collectorDeviceService.updateLogIp(device);
                    this.setResponse();
                    this.responseResult("failure," + this.getText("lego.err.660082"));
                    return;
                }
            }
            this.aticDeviceService.saveOrUpdate(device);
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.logIp.info.sucess", target, SysoplogLevel.normal.getValue(), true, null);
            this.responseResult("success");
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.logIp.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.logIp.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void saveFtp() {
        String operation = "secne.dic.function.setftp";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.ftpTemplate.getLoginUser();
        String[] temp = new String[2];
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moid);
            BisUtil.checkUserSecurity(moIdList);
            AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
            if (null == device) {
                throw new LegoCheckedException(201L);
            }
            temp[0] = device.getName();
            temp[1] = device.getIpAddress();
            device.setFtpType(this.ftpTemplate.getProtocolType());
            device.setFtpPort(this.ftpTemplate.getPort());
            device.setFtpUser(this.ftpTemplate.getLoginUser());
            if (this.ftpTemplate.getLoginPwd() != null) {
                try {
                    device.setFtpPassword(DataProtectServiceConst.sdpEncryptLocal((String)this.ftpTemplate.getLoginPwd()));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            this.aticDeviceService.saveOrUpdate(device);
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.ftp.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
            this.responseResult("success");
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog(operation, module, false, temp, null, target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, temp, null, target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public String editRestfulDddos() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        this.initCertList();
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
        if (null == device) {
            throw new LegoCheckedException(201L);
        }
        this.restfulDdosTemplate = new RestfulDdosVO();
        int restfulType = device.getRestfulType() == null ? 0 : device.getRestfulType();
        int restfulPort = device.getRestfulPort() == null ? 8447 : device.getRestfulPort();
        this.restfulDdosTemplate.setRestfulEnable(null == device.getRestfulEnable() ? Boolean.FALSE : device.getRestfulEnable());
        this.restfulDdosTemplate.setRestfulType(restfulType);
        this.restfulDdosTemplate.setRestfulPort(restfulPort);
        this.restfulDdosTemplate.setRestfulIp(device.getRestfulIp());
        this.restfulDdosTemplate.setRestfulUser(device.getRestfulUser());
        this.restfulDdosTemplate.setRestfulPassword(device.getRestfulPassword());
        this.restfulDdosTemplate.setRestfulCertAlias(device.getRestfulCertAlias());
        return "success";
    }

    private void initCertList() {
        ICertManagementParentService certManagementService = (ICertManagementParentService)ServiceContext.getInstance().getService("certManagementService", ICertManagementParentService.class);
        this.certList = new ArrayList();
        this.certList.addAll(certManagementService.queryAllCertName());
    }

    public void saveRestfulDdos() {
        String operation = "vsm.secne.ddos.device.restful.save";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.restfulDdosTemplate.getRestfulIp();
        String[] temp = new String[2];
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moid);
            BisUtil.checkUserSecurity(moIdList);
            AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
            if (null == device) {
                throw new LegoCheckedException(201L);
            }
            temp[0] = device.getName();
            target = device.getName();
            temp[1] = device.getIpAddress();
            device.setRestfulEnable(null == this.restfulDdosTemplate.getRestfulEnable() ? Boolean.FALSE : this.restfulDdosTemplate.getRestfulEnable());
            if (device.getRestfulEnable().booleanValue()) {
                device.setRestfulType(this.restfulDdosTemplate.getRestfulType());
                device.setRestfulPort(this.restfulDdosTemplate.getRestfulPort());
                device.setRestfulIp(this.restfulDdosTemplate.getRestfulIp());
                device.setRestfulUser(this.restfulDdosTemplate.getRestfulUser());
                device.setRestfulCertAlias(this.restfulDdosTemplate.getRestfulCertAlias());
            } else {
                device.setRestfulType(0);
                device.setRestfulPort(8447);
                device.setRestfulIp(null);
                device.setRestfulUser(null);
                device.setRestfulPassword(null);
                device.setRestfulCertAlias(null);
            }
            if (this.restfulDdosTemplate.getRestfulPassword() != null) {
                try {
                    device.setRestfulPassword(DataProtectServiceConst.sdpEncryptLocal((String)this.restfulDdosTemplate.getRestfulPassword()));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            this.aticDeviceService.saveOrUpdate(device);
            this.systemOpeLog(operation, module, false, temp, "vsm.secne.ddos.device.restful.save.success", target, SysoplogLevel.normal.getValue(), true, null);
            this.responseResult("success");
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog(operation, module, false, temp, "", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, temp, "", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void testRestfulDdos() {
        String operation = "vsm.secne.ddos.device.restful.test";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.restfulDdosTemplate.getRestfulIp();
        try {
            AticDevice device = null;
            if ("true".equals(this.addNeTestFlag)) {
                device = new AticDevice();
                device.setRestfulEnable(null == this.restfulDdosTemplate.getRestfulEnable() ? Boolean.FALSE : this.restfulDdosTemplate.getRestfulEnable());
                device.setRestfulType(this.restfulDdosTemplate.getRestfulType());
                device.setRestfulPort(this.restfulDdosTemplate.getRestfulPort());
                device.setRestfulIp(this.restfulDdosTemplate.getRestfulIp());
                device.setRestfulUser(this.restfulDdosTemplate.getRestfulUser());
                device.setRestfulPassword(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.restfulDdosTemplate.getRestfulPassword())));
                device.setRestfulCertAlias(this.restfulDdosTemplate.getRestfulCertAlias());
                target = this.restfulDdosTemplate.getRestfulIp();
            } else {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(this.moid);
                BisUtil.checkUserSecurity(moIdList);
                device = this.aticDeviceService.getDeviceByMoid(this.moid);
                device.setRestfulEnable(null == this.restfulDdosTemplate.getRestfulEnable() ? Boolean.FALSE : this.restfulDdosTemplate.getRestfulEnable());
                device.setRestfulType(this.restfulDdosTemplate.getRestfulType());
                device.setRestfulPort(this.restfulDdosTemplate.getRestfulPort());
                device.setRestfulIp(this.restfulDdosTemplate.getRestfulIp());
                device.setRestfulUser(this.restfulDdosTemplate.getRestfulUser());
                device.setRestfulCertAlias(this.restfulDdosTemplate.getRestfulCertAlias());
                target = device.getName();
                if (this.restfulDdosTemplate.getRestfulPassword() != null) {
                    try {
                        device.setRestfulPassword(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.restfulDdosTemplate.getRestfulPassword())));
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                    }
                }
            }
            IRestfulDdosService restfulDdosService = (IRestfulDdosService)ServiceContext.getInstance().getService("restfulDdosService", IRestfulDdosService.class);
            RequestURLForm requestURLForm = RestDdosUtil.getRequestURLForm(device);
            Result rs = restfulDdosService.restDdosAuth(requestURLForm);
            boolean result = rs.getStatusCode() == 201;
            logger.info((Object)("testRestfulDdos " + device.getRestfulIp() + "result:" + rs.getStatusCode() + "," + rs.getJson()));
            if (result) {
                String detail = "vsm.secne.ddos.device.restful.test.success.https";
                if (0 != this.restfulDdosTemplate.getRestfulType()) {
                    detail = "vsm.secne.ddos.device.restful.test.success.http";
                }
                this.systemOpeLog(operation, module, false, new String[]{target}, detail, target, SysoplogLevel.normal.getValue(), true, null);
                this.responseResult(this.getText("lego.discover.testsuccess"));
            } else {
                this.systemOpeLog(operation, module, false, new String[]{target}, "vsm.secne.ddos.device.restful.test.failed", target, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult(this.getText("lego.discover.testfailure"));
            }
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog(operation, module, false, new String[]{target}, "vsm.secne.ddos.device.restful.test.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            this.systemOpeLog(operation, module, false, new String[]{target}, "vsm.secne.ddos.device.restful.test.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoCheckedException(660050L, (Throwable)e)));
            SecNEReportLogFactory.getInstance().error((Object)("test telnet!" + e.getMessage()));
            throw new LegoCheckedException(660050L, (Throwable)e);
        }
    }

    private void enCrytpSnmp(SnmpPara snmpPara) {
        if (snmpPara.getAuthPwd() != null && !snmpPara.getAuthPwd().equals("")) {
            snmpPara.setAuthPwd(this.encryptLocal(new StringBuffer(snmpPara.getAuthPwd())));
        }
        if (snmpPara.getEncryptPwd() != null && !snmpPara.getEncryptPwd().equals("")) {
            snmpPara.setEncryptPwd(this.encryptLocal(new StringBuffer(snmpPara.getEncryptPwd())));
        }
        if (snmpPara.getReadComm() != null && !snmpPara.getReadComm().equals("")) {
            snmpPara.setReadComm(this.encryptLocal(new StringBuffer(snmpPara.getReadComm())));
        }
        if (snmpPara.getWriteComm() != null && !snmpPara.getWriteComm().equals("")) {
            snmpPara.setWriteComm(this.encryptLocal(new StringBuffer(snmpPara.getWriteComm())));
        }
    }

    private void enCrytpTelnet(TelnetPara telnetPara) {
        if (telnetPara.getLoginPwd() != null && !telnetPara.getLoginPwd().equals("")) {
            telnetPara.setLoginPwd(this.encryptLocal(new StringBuffer(telnetPara.getLoginPwd())));
        }
        if (telnetPara.getPrivateKeyPwd() != null && !telnetPara.getPrivateKeyPwd().equals("")) {
            telnetPara.setPrivateKeyPwd(this.encryptLocal(new StringBuffer(telnetPara.getPrivateKeyPwd())));
        }
        if (telnetPara.getPrivilegePwd() != null && !telnetPara.getPrivilegePwd().equals("")) {
            telnetPara.setPrivilegePwd(this.encryptLocal(new StringBuffer(telnetPara.getPrivilegePwd())));
        }
    }

    private String encryptLocal(StringBuffer pucPlainText) {
        return DataProtectServiceConst.sdpEncryptLocal((StringBuffer)pucPlainText);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void saveFlow() {
        block14: {
            String operation = "secne.dic.function.setflow";
            String module = "lego.dic.module.ResourceApplication";
            String target = this.deviceName;
            String[] temp = new String[2];
            this.getResponse().setContentType("text/html");
            try {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(this.moid);
                BisUtil.checkUserSecurity(moIdList);
                Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
                if (null == neNode) {
                    throw new LegoCheckedException(660020L);
                }
                temp[0] = neNode.getName();
                target = temp[0];
                temp[1] = neNode.getIpAddress();
                if (null != this.flowIdList && this.flowIdList.length() > 0) {
                    String[] idArray = this.flowIdList.split(",");
                    ArrayList<Long> list = new ArrayList<Long>();
                    for (int i = 0; i < idArray.length; ++i) {
                        if (StringUtils.isEmpty((CharSequence)idArray[i].trim())) continue;
                        list.add(Long.parseLong(idArray[i]));
                    }
                    if (list.size() > 100) {
                        this.responseResult("size");
                        return;
                    }
                    try {
                        List<AticDeviceRouter> entityList;
                        List<String> resultStr;
                        List<AticDeviceNfaRouter> findByNfaId = this.aticDeviceNfaRouterService.findByNfaId(this.moid);
                        if (null != findByNfaId && !findByNfaId.isEmpty()) {
                            ArrayList<Long> undoList = new ArrayList<Long>();
                            for (AticDeviceNfaRouter aticDeviceNfaRouter : findByNfaId) {
                                undoList.add(aticDeviceNfaRouter.getRouterId());
                            }
                            List<AticDeviceRouter> undoEntityList = this.aticDeviceRouterService.queryListByMoId(undoList);
                            this.aticDeviceService.deployFlowSrc(true, this.moid, undoEntityList);
                        }
                        if (null != (resultStr = this.aticDeviceService.deployFlowSrc(false, this.moid, entityList = this.aticDeviceRouterService.queryListByMoId(list))) && !resultStr.isEmpty()) {
                            for (String result : resultStr) {
                                if (!result.contains("Error:")) continue;
                                logger.error((Object)"ManageProtocalAction.saveFlow() is failed");
                                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.flow.info.failed", temp[0], SysoplogLevel.normal.getValue(), false, null);
                                return;
                            }
                        }
                    }
                    catch (LegoCheckedException e) {
                        logger.error((Object)("ManageProtocalAction.saveFlow() is failed!" + e.getMessage()));
                        this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.flow.info.failed", temp[0], SysoplogLevel.normal.getValue(), false, null);
                        return;
                    }
                    this.aticDeviceNfaRouterService.deleteByNfaId(this.moid);
                    HashSet<AticDeviceNfaRouter> addSet = new HashSet<AticDeviceNfaRouter>();
                    for (Long id : list) {
                        AticDeviceNfaRouter aticDeviceNfaRouter = new AticDeviceNfaRouter();
                        aticDeviceNfaRouter.setNfaId(this.moid);
                        aticDeviceNfaRouter.setRouterId(id);
                        addSet.add(aticDeviceNfaRouter);
                    }
                    this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.flow.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
                    SecNELogFactory.getInstance().info((Object)("save flow--> " + temp[0] + ", ipAddress = " + temp[1]));
                    this.aticDeviceNfaRouterService.saveAll(addSet);
                    this.responseResult("success");
                    break block14;
                }
                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.flow.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
                SecNELogFactory.getInstance().info((Object)("save flow--> " + temp[0] + ", ipAddress = " + temp[1]));
                this.aticDeviceNfaRouterService.deleteByNfaId(this.moid);
                this.responseResult("success");
            }
            catch (LegoCheckedException ex) {
                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.flow.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.flow.info.failed", target, SysoplogLevel.normal.getValue(), true, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            }
        }
    }

    public void saveNfaCluster() {
        String operation = "lego.detail.discovery.editNfaCluster";
        String module = "lego.dic.module.ResourceApplication";
        String target = String.valueOf(this.moid);
        String[] detailPara = new String[]{target};
        this.fireDeviceList = this.aticDeviceService.getDeviceListByClusterId(this.moid);
        String[] idStrings = this.deviceIdList.split(",");
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        for (String str : idStrings) {
            moIdList.add(Long.parseLong(str));
        }
        BisUtil.checkUserSecurity(moIdList);
        try {
            List<AticDevice> preAddNfas;
            Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
            if (null == neNode) {
                throw new LegoCheckedException(660020L);
            }
            target = neNode.getName();
            ArrayList<Long> idList = new ArrayList<Long>();
            ArrayList<Long> addIdList = new ArrayList<Long>();
            ArrayList<Long> oldIdList = new ArrayList<Long>();
            ArrayList<Long> delIds = new ArrayList<Long>();
            if (0 != idStrings.length) {
                for (String string : idStrings) {
                    idList.add(Long.valueOf(string));
                }
            }
            if ((preAddNfas = this.aticDeviceService.getNfa2000VByIds(idList)).size() > 20) {
                this.responseResult(this.getText("lego.err.660094"));
                return;
            }
            ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
            ArrayList<AticDevice> nfaDevs = new ArrayList<AticDevice>();
            this.batchOperationResult = new BatchOperationResult();
            if (null != this.fireDeviceList && !this.fireDeviceList.isEmpty()) {
                for (AticDevice aticDevice : this.fireDeviceList) {
                    oldIdList.add(aticDevice.getMoId());
                    if (idList.contains(aticDevice.getMoId())) {
                        deviceList.add(aticDevice);
                    }
                    if (8 != aticDevice.getDeviceType()) continue;
                    nfaDevs.add(aticDevice);
                }
                this.fireDeviceList.removeAll(deviceList);
                if (!this.fireDeviceList.isEmpty()) {
                    this.deployDeleteCommand(this.fireDeviceList, nfaDevs);
                }
            }
            for (Long l : idList) {
                if (oldIdList.contains(l)) continue;
                addIdList.add(l);
                delIds.add(l);
            }
            for (Long l : oldIdList) {
                if (idList.contains(l)) continue;
                delIds.add(l);
            }
            if (deviceList.size() == idList.size() && (null == this.fireDeviceList || this.fireDeviceList.isEmpty())) {
                this.responseResult("success");
                SecNELogFactory.getInstance().info((Object)"cluster has been not edited.");
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (Long addId : addIdList) {
                AticDevice addDevice = this.aticDeviceService.getDeviceByMoid(addId);
                stringBuffer.append(addDevice.getName());
                stringBuffer.append(" ");
            }
            for (AticDevice deleDev : this.fireDeviceList) {
                stringBuffer.append(deleDev.getName());
                stringBuffer.append(" ");
            }
            target = stringBuffer.toString();
            detailPara = new String[]{target};
            if (!addIdList.isEmpty()) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.moid);
                String secretKey = DataProtectServiceConst.sdpDecryptLocal((String)aticDevice.getLogPwd());
                this.deployAddCommand(idList, addIdList, secretKey);
            }
            this.unboundNfaRelation(idList);
            this.deleteCollectorAccess();
            this.clusterService.deleteByClusterId(this.moid);
            this.clusterService.saveCluster(this.moid, idList, delIds, this.clusterOutbound);
            IUndoZoneParentService iUndoZoneParentService = (IUndoZoneParentService)ServiceContext.getInstance().getService("zoneService", IUndoZoneParentService.class);
            iUndoZoneParentService.removeSingleDevToCulster(this.moid, addIdList);
            iUndoZoneParentService.modifyZoneMsgForEditCluster(this.moid, addIdList, this.fireDeviceList, nfaDevs);
            this.associateCollector();
            this.systemOpeLog(operation, module, false, detailPara, "secne.log.module.ne.protocol.cluster.info.sucess", target, SysoplogLevel.normal.getValue(), true, null);
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, detailPara, "secne.log.module.ne.protocol.cluster.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, detailPara, "secne.log.module.ne.protocol.cluster.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw new LegoUncheckedException((Throwable)ex);
        }
        if (this.batchOperationResult.getFailCount() == 0) {
            this.batchOperationResult = null;
            this.responseResult("success");
            return;
        }
        this.bathResult(this.batchOperationResult);
    }

    public void generateProgressBarId() {
        Long progressBarId = new Date().getTime();
        this.responseResult(String.valueOf(progressBarId));
    }

    private void associateCollector() {
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(this.moid);
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.moid);
        if (null != collectorId) {
            this.collectorDeviceService.addDeviceAccess(collectorId, deviceList);
        }
    }

    private void deleteCollectorAccess() {
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(this.moid);
        if (null != collectorId && null != this.fireDeviceList && !this.fireDeviceList.isEmpty()) {
            ArrayList<Long> nfaIds = new ArrayList<Long>();
            for (AticDevice aticDevice : this.fireDeviceList) {
                nfaIds.add(aticDevice.getMoId());
            }
            this.collectorDeviceService.delDeviceAccess(collectorId, nfaIds);
        }
    }

    private void deployDeleteCommand(List<AticDevice> fireDevList, List<AticDevice> nfaDevs) {
        SecNELogFactory.getInstance().info((Object)("cluster has been not edited." + fireDevList.size()));
        List<BatchOperation> operationList = this.aticDeviceService.undoAntiDDoS1820NClusterInfo(fireDevList, nfaDevs);
        AticDevice clusterDevice = this.aticDeviceService.getDeviceByMoid(this.moid);
        for (BatchOperation operation : operationList) {
            if (operation.getOptDetail().contains("The number of current rule exceeds maximum already")) {
                operation.setErrorCode(575004L);
            } else {
                operation.setErrorCode(575005L);
                operation.setDetailParam(new String[]{operation.getTargetName()});
            }
            operation.setTargetName(clusterDevice.getName());
            operation.setTargetId(clusterDevice.getMoId());
        }
        this.batchOperationResult.setResult(operationList);
        this.batchOperationResult.setTotalCount(nfaDevs.size());
        this.batchOperationResult.setFailCount(operationList.size());
        this.batchOperationResult.setSucceedCount(fireDevList.size() - operationList.size());
    }

    private void deployAddCommand(List<Long> idList, List<Long> addIdList, String secretKey) {
        ArrayList<AticDevice> nfaListExAdd = new ArrayList<AticDevice>();
        ArrayList<AticDevice> addDeviceList = new ArrayList<AticDevice>();
        for (Long mId : idList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(mId);
            boolean isAdd = true;
            for (Long devId : addIdList) {
                if (!devId.equals(mId)) continue;
                addDeviceList.add(aticDevice);
                isAdd = false;
                break;
            }
            if (!isAdd) continue;
            nfaListExAdd.add(aticDevice);
        }
        List<BatchOperation> batchOpList = this.aticDeviceService.deployAntiDDoS1820NClusterInfo(addDeviceList, nfaListExAdd, this.moid, secretKey);
        AticDevice clusterDevice = this.aticDeviceService.getDeviceByMoid(this.moid);
        for (BatchOperation operation : batchOpList) {
            if (operation.getOptDetail().contains("The number of current rule exceeds maximum already")) {
                operation.setErrorCode(575004L);
            } else {
                operation.setErrorCode(575001L);
                operation.setDetailParam(new String[]{operation.getTargetName()});
            }
            operation.setTargetName(clusterDevice.getName());
            operation.setTargetId(clusterDevice.getMoId());
        }
        batchOpList.addAll(this.batchOperationResult.getResult());
        this.batchOperationResult.setResult(batchOpList);
        this.batchOperationResult.setTotalCount(addDeviceList.size() + nfaListExAdd.size() + this.batchOperationResult.getTotalCount());
        this.batchOperationResult.setFailCount(batchOpList.size());
        this.batchOperationResult.setSucceedCount(this.batchOperationResult.getTotalCount() - this.batchOperationResult.getFailCount());
    }

    private void unboundNfaRelation(List<Long> idList) {
        for (Long id : idList) {
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(id);
            if (null == collectorId) continue;
            ArrayList<Long> devIdList = new ArrayList<Long>();
            devIdList.add(id);
            this.collectorDeviceService.delDeviceAccess(collectorId, devIdList);
        }
        List<DefendGroupForm> defendGroupForms = this.defendGroupService.getAll();
        for (DefendGroupForm defendGroupForm : defendGroupForms) {
            String idString = defendGroupForm.getDevices();
            for (Long id : idList) {
                if (!idString.contains(String.valueOf(id))) continue;
                if (!idString.contains(",")) {
                    this.defendGroupService.delById(defendGroupForm.getId());
                    continue;
                }
                this.defendGroupService.updateDefendGroupByDevId(defendGroupForm.getId(), id);
            }
        }
        for (Long id : idList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(id);
            if (aticDevice.getDeviceType() == 8) {
                this.aticDeviceNfaRouterService.deleteByNfaId(id);
                continue;
            }
            this.aticDeviceNfaRouterService.deleteByRouterId(id);
        }
    }

    public void saveTelnet(TelnetPara sp) {
        this.getResponse().setContentType("text/html");
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        BisUtil.checkUserSecurity(moIdList);
        Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
        if (neNode == null) {
            this.getOperateLog().normal("secne.dic.function.settelnet", "lego.dic.module.ResourceApplication", null, false, "secne.log.module.ne.protocol.telnet.info.failed", null);
            throw new LegoCheckedException(660020L);
        }
        if (neNode.getManagementProtocolMap().containsKey(TelnetPara.class.getName())) {
            sp.setId(neNode.getManagementProtocolMap().get(TelnetPara.class.getName()).getId());
            sp.setNode(neNode);
            this.discoveryService.modifyManagementProtocol(sp);
        } else {
            sp.setId(null);
            this.discoveryService.addManagementProtocol(sp, this.moid);
        }
        String[] temp = new String[]{neNode.getName(), neNode.getIpAddress()};
        this.getOperateLog().normal("secne.dic.function.settelnet", "lego.dic.module.ResourceApplication", temp[0], false, "secne.log.module.ne.protocol.telnet.info.sucess", temp);
        SecNELogFactory.getInstance().info((Object)("save Telnet--> " + temp[0] + ", ipAddress = " + temp[1]));
    }

    public void saveSnmp() {
        String operation = "secne.dic.function.setsnmp";
        String module = "lego.dic.module.ResourceApplication";
        this.getResponse().setContentType("text/html");
        String[] temp = new String[2];
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.moid);
            BisUtil.checkUserSecurity(moIdList);
            Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
            SnmpPara sp = this.snmpTemplate.getSnmpTemplate();
            this.enCrytpSnmp(sp);
            if (neNode == null) {
                throw new LegoCheckedException(660020L);
            }
            temp[0] = neNode.getName();
            temp[1] = neNode.getIpAddress();
            if (sp.getVersion() != 3 && sp.getReadComm() == null) {
                sp.setReadComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getReadComm());
            }
            if (sp.getVersion() != 3 && sp.getWriteComm() == null) {
                sp.setWriteComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getWriteComm());
            }
            if (sp.getAuthProtocol() != null && !sp.getAuthProtocol().isEmpty() && sp.getAuthPwd() == null) {
                sp.setAuthPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getAuthPwd());
            }
            if (sp.getEncryptProtocol() != null && !sp.getEncryptProtocol().isEmpty() && sp.getEncryptPwd() == null) {
                sp.setEncryptPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getEncryptPwd());
            }
            if (neNode.getManagementProtocolMap().containsKey(SnmpPara.class.getName())) {
                sp.setId(neNode.getManagementProtocolMap().get(SnmpPara.class.getName()).getId());
                sp.setNode(neNode);
                this.discoveryService.modifyManagementProtocol(sp);
            } else {
                sp.setId(null);
                this.discoveryService.addManagementProtocol(sp, this.moid);
            }
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.snmp.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
            SecNELogFactory.getInstance().info((Object)("save snmp--> " + temp[0] + ", ipAddress = " + temp[1]));
            this.responseResult("success");
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.snmp.info.failed", temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.cluster.info.failed", temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            throw ex;
        }
    }

    public void saveSnmp(SnmpPara sp) {
        this.getResponse().setContentType("text/html");
        Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
        if (neNode == null) {
            throw new LegoCheckedException(660020L);
        }
        if (neNode.getManagementProtocolMap().containsKey(SnmpPara.class.getName())) {
            sp.setId(neNode.getManagementProtocolMap().get(SnmpPara.class.getName()).getId());
            sp.setNode(neNode);
            this.discoveryService.modifyManagementProtocol(sp);
        } else {
            sp.setId(null);
            this.discoveryService.addManagementProtocol(sp, this.moid);
        }
        String[] temp = new String[]{neNode.getName(), neNode.getIpAddress()};
        this.getOperateLog().normal("secne.dic.function.setsnmp", "lego.dic.module.ResourceApplication", temp[0], false, "secne.log.module.ne.protocol.snmp.info.sucess", temp);
        SecNELogFactory.getInstance().info((Object)("save snmp--> " + temp[0] + ", ipAddress = " + temp[1]));
    }

    public void testSNMPProtocol() {
        this.getResponse().setContentType("text/html");
        SnmpPara sp = this.snmpTemplate.getSnmpTemplate();
        this.enCrytpSnmp(sp);
        Node neNode = null;
        String operation = "secne.dic.function.snmp.test";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.ipAddress;
        String[] temp = new String[2];
        try {
            if (!"true".equals(this.addNeTestFlag)) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(this.moid);
                BisUtil.checkUserSecurity(moIdList);
                neNode = this.resourceService.getDeviceDetailInfo(this.moid);
            }
            if (!"true".equals(this.addNeTestFlag)) {
                if (neNode == null) {
                    throw new LegoCheckedException(660020L);
                }
                temp[0] = neNode.getName();
                temp[1] = neNode.getIpAddress();
                if (sp.getVersion() != 3 && sp.getReadComm() == null) {
                    sp.setReadComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getReadComm());
                }
                if (sp.getVersion() != 3 && sp.getWriteComm() == null) {
                    sp.setWriteComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getWriteComm());
                }
                if (sp.getAuthProtocol() != null && !sp.getAuthProtocol().isEmpty() && sp.getAuthPwd() == null) {
                    sp.setAuthPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getAuthPwd());
                }
                if (sp.getEncryptProtocol() != null && !sp.getEncryptProtocol().isEmpty() && sp.getEncryptPwd() == null) {
                    sp.setEncryptPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getEncryptPwd());
                }
            } else {
                temp[0] = this.deviceName;
                temp[1] = this.ipAddress;
            }
            target = temp[1];
            sp.setIsSnmpTest(true);
            boolean result = this.aticDeviceService.testSnmp(temp[1], sp);
            if (result) {
                this.responseResult(this.getText("lego.discover.testsuccess"));
                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.snmp.test.success", temp[0], SysoplogLevel.normal.getValue(), true, null);
            } else if (3 == sp.getVersion()) {
                this.systemOpeLog(operation, module, false, new String[]{sp.getSecurityName()}, "lego.discover.snmpv3.testfailure", target, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult(this.getText("lego.discover.snmpv3.testfailure", new String[]{sp.getSecurityName()}));
            } else {
                this.systemOpeLog(operation, module, false, new String[]{sp.getSecurityName()}, "lego.discover.snmpv12.testfailure", target, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult(this.getText("lego.discover.snmpv12.testfailure"));
            }
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.snmp.test.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            throw new LegoCheckedException(ex.getErrorCode(), (Throwable)ex);
        }
        catch (Exception e) {
            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.snmp.test.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)e)));
            SecNEReportLogFactory.getInstance().error((Object)("test snmp!" + e.getMessage()));
            throw new LegoCheckedException(660052L, (Throwable)e);
        }
    }

    public void testSNMPOID() {
        this.getResponse().setContentType("text/html");
        SnmpPara sp = this.snmpTemplate.getSnmpTemplate();
        this.enCrytpSnmp(sp);
        Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
        if (null == neNode) {
            throw new LegoCheckedException(660020L);
        }
        if (3 != sp.getVersion() && null == sp.getReadComm()) {
            sp.setReadComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getReadComm());
        }
        if (3 != sp.getVersion() && null == sp.getWriteComm()) {
            sp.setWriteComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getWriteComm());
        }
        if (null != sp.getAuthProtocol() && !sp.getAuthProtocol().isEmpty() && null == sp.getAuthPwd()) {
            sp.setAuthPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getAuthPwd());
        }
        if (null != sp.getEncryptProtocol() && !sp.getEncryptProtocol().isEmpty() && null == sp.getEncryptPwd()) {
            sp.setEncryptPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getEncryptPwd());
        }
        try {
            String result = this.aticDeviceService.testSnmpOid(this.ipAddress, sp, this.testOid);
            if (!StringUtils.isEmpty((CharSequence)result)) {
                this.responseResult("success," + result);
            } else {
                this.responseResult("failure," + this.getText("lego.discover.testfailure"));
            }
        }
        catch (Exception e) {
            SecNEReportLogFactory.getInstance().error((Object)("test snmp testOid!" + e.getMessage()));
            throw new LegoCheckedException(660052L, (Throwable)e);
        }
    }

    public void testTelnetProtocol() {
        this.getResponse().setContentType("text/html");
        String operation = "secne.dic.function.telnet.test";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.ipAddress;
        if (this.telnetTemplate.getPrototolType() == 1) {
            this.telnetTemplate.setAuthMode(this.sauthMode);
        }
        TelnetPara sp = this.telnetTemplate.getTemplate();
        this.enCrytpTelnet(sp);
        try {
            boolean result;
            if (sp.getProtocolType() == 0 && sp.getPort() != 23) {
                throw new LegoCheckedException(660050L);
            }
            if (!"true".equals(this.addNeTestFlag)) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(this.moid);
                BisUtil.checkUserSecurity(moIdList);
                AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
                if (!this.ipAddress.equals(device.getIpAddress())) {
                    throw new LegoCheckedException(660050L);
                }
                target = device.getName();
                Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
                if (neNode == null) {
                    throw new LegoCheckedException(660020L);
                }
                if (sp.getProtocolType() == 0 && sp.getAuthMode() != 0 && sp.getLoginPwd() == null) {
                    sp.setLoginPwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getLoginPwd());
                }
                if (sp.getProtocolType() == 1) {
                    String sshKey;
                    if (sp.getAuthMode() == 0 && sp.getLoginPwd() == null) {
                        sp.setLoginPwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getLoginPwd());
                    }
                    if (sp.getAuthMode() == 1 && sp.getPrivateKeyPwd() == null) {
                        sp.setPrivateKeyPwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getPrivateKeyPwd());
                    }
                    if (!AticUtil.isNull((String)(sshKey = AticUtil.replaceBlank((String)this.sshPublicKey.trim())))) {
                        sp.setHostKey(sshKey);
                    }
                }
                if (sp.isIsEnable() && sp.getPrivilegePwd() == null) {
                    sp.setPrivilegePwd(((TelnetPara)neNode.getManagementProtocolMap().get(TelnetPara.class.getName())).getPrivilegePwd());
                }
            }
            if (result = this.aticDeviceService.testTelnet(this.ipAddress, sp)) {
                this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testsuccess", target, SysoplogLevel.normal.getValue(), true, null);
                this.responseResult(this.getText("lego.discover.testsuccess"));
            } else {
                this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testfailure", target, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult(this.getText("lego.discover.testfailure"));
            }
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testfailure", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testfailure", target, SysoplogLevel.normal.getValue(), false, e);
            SecNEReportLogFactory.getInstance().error((Object)("test telnet!" + e.getMessage()));
            throw new LegoCheckedException(660050L, (Throwable)e);
        }
    }

    public void testFtpProtocol() {
        String operation = "secne.dic.function.ftp.test";
        String module = "lego.dic.module.ResourceApplication";
        String target = this.ftpTemplate.getLoginUser();
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moid);
        try {
            boolean result;
            BisUtil.checkUserSecurity(moIdList);
            AticDevice device = this.aticDeviceService.getDeviceByMoid(this.moid);
            device.setFtpType(this.ftpTemplate.getProtocolType());
            device.setFtpPort(this.ftpTemplate.getPort());
            device.setFtpUser(this.ftpTemplate.getLoginUser());
            target = device.getName();
            if (this.ftpTemplate.getLoginPwd() != null) {
                try {
                    device.setFtpPassword(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.ftpTemplate.getLoginPwd())));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            if (result = this.aticDeviceService.testFtp(device)) {
                this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testsuccess", target, SysoplogLevel.normal.getValue(), true, null);
                this.responseResult(this.getText("lego.discover.testsuccess"));
            } else {
                this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testfailure", target, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult(this.getText("lego.discover.testfailure"));
            }
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testfailure", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            this.systemOpeLog(operation, module, false, new String[]{target}, "lego.discover.testfailure", target, SysoplogLevel.normal.getValue(), false, ex);
            SecNEReportLogFactory.getInstance().error((Object)("test telnet!" + ex.getMessage()));
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public String editFlowList() {
        HashSet<Long> flowSet = new HashSet<Long>();
        this.dealRelNe(flowSet);
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List<AticDeviceRouter> list = this.aticDeviceRouterService.queryAll(currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
        if (null != list && !list.isEmpty()) {
            this.flowFormList = new ArrayList<AticDeviceRouterForm>();
            for (AticDeviceRouter entity : list) {
                if (flowSet.contains(entity.getMoId())) continue;
                AticDeviceRouterForm form = new AticDeviceRouterForm();
                form.setMoId(entity.getMoId());
                form.setName(entity.getParameter().getName());
                form.setFlowSrcIp(entity.getFlowSrcIp());
                form.setFlowDstPort(entity.getFlowDstPort());
                form.setSampleMode(entity.getSampleMode());
                form.setSampleRatio(entity.getSampleRatio());
                form.setAgeTime(entity.getAgeTime());
                form.setCpuOid(entity.getCpuOid());
                form.setMemeryOid(entity.getMemeryOid());
                this.flowFormList.add(form);
            }
        }
        return "success";
    }

    public String editFireDeviceList() {
        ArrayList<AticDevice> aticDevices;
        ArrayList<Long> moidList = new ArrayList<Long>();
        moidList.add(this.moid);
        BisUtil.checkUserSecurity(moidList);
        this.fireDeviceList = this.aticDeviceService.getDeviceListByClusterId(this.moid);
        Object userObj = ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        long userId = null == userObj ? 1L : ((User)userObj).getUserID();
        this.firewallList = this.aticDeviceService.getNfaAndRouteByPrivilege(userId);
        this.firewallList.addAll(this.fireDeviceList);
        this.firewallList = this.aticDeviceService.setStatusToAticDevice(this.firewallList);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        if (this.neIds != null && !"".equals(this.neIds)) {
            String[] idStrings = this.neIds.split(",");
            for (String id : idStrings) {
                moIdList.add(Long.valueOf(id));
            }
        }
        if (0 != moIdList.size()) {
            aticDevices = new ArrayList<AticDevice>();
            for (AticDevice aticDevice : this.firewallList) {
                if (!moIdList.contains(aticDevice.getMoId())) continue;
                aticDevices.add(aticDevice);
            }
            this.firewallList.removeAll(aticDevices);
        }
        aticDevices = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)this.simpleSystemName)) {
            for (AticDevice temp : this.firewallList) {
                if (!temp.getName().contains(String.valueOf(this.simpleSystemName))) continue;
                aticDevices.add(temp);
            }
            this.firewallList.clear();
            for (AticDevice temp : aticDevices) {
                this.firewallList.add(temp);
            }
        }
        return "success";
    }

    private void dealRelNe(Set<Long> flowSet) {
        if (!StringUtils.isEmpty((CharSequence)this.flowIdList)) {
            String[] flowArray;
            for (String moId : flowArray = this.flowIdList.split(",")) {
                if (StringUtils.isEmpty((CharSequence)moId)) continue;
                try {
                    flowSet.add(Long.parseLong(moId));
                }
                catch (Exception e) {
                    logger.error((Object)(moId + "is not in flowSet"));
                }
            }
        }
        BisUtil.checkUserSecurity(new ArrayList<Long>(flowSet));
    }

    public void saveRouterFlow() {
        block24: {
            String operation = "secne.dic.function.setrouterflow";
            String module = "lego.dic.module.ResourceApplication";
            String target = "";
            this.getResponse().setContentType("text/html");
            if (null != this.aticDeviceRouter) {
                target = this.aticDeviceRouter.getFlowSrcIp();
                logger.info((Object)("aticDeviceRouter info: " + this.aticDeviceRouter));
                try {
                    String inboundStr = this.aticDeviceRouter.getInbound();
                    String outboundStr = this.aticDeviceRouter.getOutbound();
                    if (null != inboundStr && !inboundStr.isEmpty()) {
                        String[] inboundList = inboundStr.split("\n");
                        HashSet<String> inboundSet = new HashSet<String>();
                        for (String inboundSub : inboundList) {
                            if (null == inboundSub || inboundSub.trim().length() == 0) continue;
                            inboundSet.add(inboundSub);
                        }
                        if (inboundSet.size() > 1000) {
                            this.responseResult("inbounds");
                        }
                    }
                    if (null != outboundStr && !outboundStr.isEmpty()) {
                        String[] outboundList = outboundStr.split("\n");
                        HashSet<String> outboundSet = new HashSet<String>();
                        for (String outboundSub : outboundList) {
                            if (null == outboundSub || outboundSub.trim().length() == 0) continue;
                            outboundSet.add(outboundSub);
                        }
                        if (outboundSet.size() > 1000) {
                            this.responseResult("outbounds");
                        }
                    }
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    moIdList.add(this.moid);
                    BisUtil.checkUserSecurity(moIdList);
                    Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
                    if (null == neNode) {
                        throw new LegoCheckedException(660020L);
                    }
                    String[] temp = new String[2];
                    target = neNode.getName();
                    temp[1] = neNode.getIpAddress();
                    AticDeviceNfaRouter aticRouter = this.aticDeviceNfaRouterService.findByRouterId(this.aticDeviceRouter.getMoId());
                    AticDeviceNfaCluster aticCluster = this.clusterService.findClusterByRouterId(this.aticDeviceRouter.getMoId());
                    if (null != aticRouter) {
                        AticDevice atic = this.aticDeviceService.getDeviceByMoid(aticRouter.getNfaId());
                        ArrayList<AticDeviceRouter> entityList = new ArrayList<AticDeviceRouter>();
                        AticDeviceRouter oldDeviceRouter = this.aticDeviceRouterService.findByMoId(this.aticDeviceRouter.getMoId());
                        entityList.add(oldDeviceRouter);
                        try {
                            this.aticDeviceService.deployFlowSrc(true, aticRouter.getNfaId(), entityList);
                            entityList.remove(oldDeviceRouter);
                            entityList.add(this.aticDeviceRouter);
                            List<String> resultStr = this.aticDeviceService.deployFlowSrc(false, aticRouter.getNfaId(), entityList);
                            if (null != resultStr && !resultStr.isEmpty()) {
                                for (String result : resultStr) {
                                    if (!result.contains("Error:")) continue;
                                    logger.error((Object)"ManageProtocalAction.saveSysLog() is failed");
                                    this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, null);
                                    return;
                                }
                            }
                        }
                        catch (LegoCheckedException e) {
                            logger.error((Object)("ManageProtocalAction.saveSysLog() is failed!" + e.getMessage()));
                            this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, null);
                            return;
                        }
                        temp[0] = atic.getName();
                        temp[1] = atic.getIpAddress();
                        this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routerflow.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
                        SecNELogFactory.getInstance().info((Object)("save routerflow--> " + temp[0] + ", ipAddress = " + temp[1]));
                        this.aticDeviceRouterService.saveOrUpdate(this.aticDeviceRouter);
                        this.responseResult("success");
                        break block24;
                    }
                    if (null != aticCluster) {
                        ArrayList<AticDeviceRouter> undoEntityList = new ArrayList<AticDeviceRouter>();
                        ArrayList<AticDeviceRouter> entityList = new ArrayList<AticDeviceRouter>();
                        entityList.add(this.aticDeviceRouter);
                        AticDeviceRouter oldDeviceRouter = this.aticDeviceRouterService.findByMoId(this.aticDeviceRouter.getMoId());
                        undoEntityList.add(oldDeviceRouter);
                        List<AticDeviceNfaCluster> aticDeviceNfas = this.clusterService.getBindNfaDevice(aticCluster.getClusterId());
                        int countError = 0;
                        for (AticDeviceNfaCluster aNfaCluster : aticDeviceNfas) {
                            AticDevice atic = this.aticDeviceService.getDeviceByMoid(aNfaCluster.getDeviceId());
                            if (null != atic) {
                                this.aticDeviceService.deployFlowSrc(true, atic.getMoId(), undoEntityList);
                                List<String> resultStr = this.aticDeviceService.deployFlowSrc(false, atic.getMoId(), entityList);
                                if (null == resultStr || resultStr.isEmpty()) continue;
                                for (String result : resultStr) {
                                    if (!result.contains("Error:")) continue;
                                    logger.error((Object)"ManageProtocalAction.saveSysLog() is failed");
                                    this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, null);
                                    return;
                                }
                                continue;
                            }
                            ++countError;
                            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, null);
                        }
                        if (aticDeviceNfas.size() == countError) {
                            logger.error((Object)"ManageProtocalAction.saveSysLog() is failed");
                            this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, null);
                            this.responseResult("failures");
                        } else if (countError > 0 && countError < aticDeviceNfas.size()) {
                            this.aticDeviceRouterService.saveOrUpdate(this.aticDeviceRouter);
                            this.responseResult("success:partOfSuccess");
                        } else {
                            this.aticDeviceRouterService.saveOrUpdate(this.aticDeviceRouter);
                            this.responseResult("success");
                        }
                        break block24;
                    }
                    this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routerflow.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
                    SecNELogFactory.getInstance().info((Object)("save routerflow--> " + temp[0] + ", ipAddress = " + temp[1]));
                    this.aticDeviceRouterService.saveOrUpdate(this.aticDeviceRouter);
                    this.responseResult("success");
                }
                catch (LegoCheckedException ex) {
                    this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
                }
                catch (Exception ex) {
                    this.systemOpeLog(operation, module, false, new String[]{this.deviceName}, "secne.log.module.ne.protocol.routerflow.info.failed", target, SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
                }
            }
        }
    }

    public boolean validateParam() {
        if (null != this.aticDeviceRouter) {
            if (!this.ipValidate(this.aticDeviceRouter.getFlowSrcIp())) {
                return false;
            }
            if (null != this.aticDeviceRouter.getFlowDstPort()) {
                if (this.aticDeviceRouter.getFlowDstPort() < 1 || this.aticDeviceRouter.getFlowDstPort() > 65535) {
                    logger.error((Object)"flowDstPort validation failed");
                    return false;
                }
            } else {
                logger.error((Object)"flowDstPort validation failed");
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)this.aticDeviceRouter.getSampleRatio())) {
                int sampleRatioInt = Integer.parseInt(this.aticDeviceRouter.getSampleRatio());
                if (sampleRatioInt <= 0 || sampleRatioInt > 65535) {
                    logger.error((Object)"sampleRatio validation failed");
                    return false;
                }
            } else {
                logger.error((Object)"sampleRatio validation failed");
                return false;
            }
            if (null != this.aticDeviceRouter.getAgeTime()) {
                if (this.aticDeviceRouter.getAgeTime() < 30 && this.aticDeviceRouter.getAgeTime() > 0 || this.aticDeviceRouter.getAgeTime() > 1800) {
                    logger.error((Object)"ageTime validation failed");
                    return false;
                }
            } else {
                logger.error((Object)"ageTime is null");
                return false;
            }
        }
        return true;
    }

    public void saveRouterSnmp() {
        block12: {
            this.getResponse().setContentType("text/html");
            String operation = "secne.dic.function.setroutersnmp";
            String module = "lego.dic.module.ResourceApplication";
            String[] temp = new String[2];
            try {
                if (null == this.aticDeviceRouter) break block12;
                SnmpPara snmpPara = this.snmpTemplate.getSnmpTemplate();
                this.enCrytpSnmp(snmpPara);
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(this.moid);
                BisUtil.checkUserSecurity(moIdList);
                Node neNode = this.resourceService.getDeviceDetailInfo(this.moid);
                if (null == neNode) {
                    throw new LegoCheckedException(660020L);
                }
                temp[0] = neNode.getName();
                temp[1] = neNode.getIpAddress();
                if (3 != snmpPara.getVersion() && null == snmpPara.getReadComm()) {
                    snmpPara.setReadComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getReadComm());
                }
                if (3 != snmpPara.getVersion() && null == snmpPara.getWriteComm()) {
                    snmpPara.setWriteComm(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getWriteComm());
                }
                if (null != snmpPara.getAuthProtocol() && !snmpPara.getAuthProtocol().isEmpty() && null == snmpPara.getAuthPwd()) {
                    snmpPara.setAuthPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getAuthPwd());
                }
                if (null != snmpPara.getEncryptProtocol() && !snmpPara.getEncryptProtocol().isEmpty() && null == snmpPara.getEncryptPwd()) {
                    snmpPara.setEncryptPwd(((SnmpPara)neNode.getManagementProtocolMap().get(SnmpPara.class.getName())).getEncryptPwd());
                }
                try {
                    if (neNode.getManagementProtocolMap().containsKey(SnmpPara.class.getName())) {
                        snmpPara.setId(neNode.getManagementProtocolMap().get(SnmpPara.class.getName()).getId());
                        snmpPara.setNode(neNode);
                        this.discoveryService.modifyManagementProtocol(snmpPara);
                    } else {
                        snmpPara.setId(null);
                        this.discoveryService.addManagementProtocol(snmpPara, this.moid);
                    }
                    AticDeviceRouter entity = this.aticDeviceRouterService.findByMoId(this.aticDeviceRouter.getMoId());
                    entity.setCpuOid(this.aticDeviceRouter.getCpuOid());
                    entity.setMemeryOid(this.aticDeviceRouter.getMemeryOid());
                    this.aticDeviceRouterService.saveOrUpdate(entity);
                    this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routersnmp.info.sucess", temp[0], SysoplogLevel.normal.getValue(), true, null);
                    SecNELogFactory.getInstance().info((Object)("save routersnmp--> " + temp[0] + ", ipAddress = " + temp[1]));
                    this.responseResult("success");
                }
                catch (Exception e) {
                    logger.error((Object)("save Router SNMP Exception." + e.getMessage()));
                    this.responseResult("failure");
                    throw e;
                }
            }
            catch (LegoCheckedException ex) {
                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routersnmp.info.failed", temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.systemOpeLog(operation, module, false, temp, "secne.log.module.ne.protocol.routersnmp.info.failed", temp[0], SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
                this.responseResult("failure");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean snmpValidate() {
        if ("true".equals(this.addNeTestFlag)) {
            this.snmpTemplate = new TemplateVO();
            this.snmpTemplate.setPort(Integer.parseInt(this.port));
            this.snmpTemplate.setVersion(Integer.parseInt(this.versionType));
            this.snmpTemplate.setRetries(Integer.parseInt(this.retries));
            this.snmpTemplate.setTimeout(Integer.parseInt(this.timeout));
            if ("3".equals(this.versionType)) {
                this.snmpTemplate.setSecurityName(this.v3securityName);
                this.snmpTemplate.setContextName(this.v3contextName);
                this.snmpTemplate.setContextEngineId(this.v3contextEngineId);
                this.snmpTemplate.setAuthProtocol(this.v3authProtocol);
                this.snmpTemplate.setAuthPwd(this.v3authPwd);
                this.snmpTemplate.setEncryptProtocol(this.v3encryptProtocol);
                this.snmpTemplate.setEncryptPwd(this.v3encryptPwd);
            } else {
                this.snmpTemplate.setReadComm(this.snmpReadComm);
                this.snmpTemplate.setWriteComm(this.snmpWriteComm);
            }
        }
        if (null != this.snmpTemplate) {
            String authProtocol;
            String contextEngineId;
            String contextName;
            SnmpPara snmpPara = this.snmpTemplate.getSnmpTemplate();
            int version = snmpPara.getVersion();
            String versionRegex = "^[0-3]{1}$";
            if (!String.valueOf(version).matches(versionRegex)) {
                logger.error((Object)("version validation failed, version = " + version));
                return false;
            }
            if (0 == version || 1 == version) {
                String readComm = snmpPara.getReadComm();
                if (!this.validateRouterPwd(readComm)) {
                    return false;
                }
                String writeComm = snmpPara.getWriteComm();
                if (this.validateRouterPwd(writeComm)) return true;
                return false;
            }
            if (3 != version) return true;
            String securityName = snmpPara.getSecurityName();
            if (StringUtils.isNotBlank((CharSequence)securityName)) {
                String securityNameRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
                if (!securityName.matches(securityNameRegex)) {
                    logger.error((Object)("securityName validation failed, securityName = " + this.getcleanedMessage(securityName)));
                    return false;
                }
                if (securityName.length() >= 65) {
                    logger.error((Object)("securityName validation failed, securityName = " + this.getcleanedMessage(securityName)));
                    return false;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(contextName = snmpPara.getContextName()))) {
                String contextNameRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
                if (!contextName.matches(contextNameRegex)) {
                    logger.error((Object)("contextName validation failed, contextName = " + this.getcleanedMessage(contextName)));
                    return false;
                }
                if (contextName.length() >= 65) {
                    logger.error((Object)("contextName validation failed, contextName = " + this.getcleanedMessage(contextName)));
                    return false;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(contextEngineId = snmpPara.getContextEngineId()))) {
                String contextEngineIdRegex = "^[A-Fa-f0-9]+$";
                if (!contextEngineId.matches(contextEngineIdRegex)) {
                    logger.error((Object)("contextEngineId validation failed, contextEngineId = " + this.getcleanedMessage(contextEngineId)));
                    return false;
                }
                if (contextEngineId.length() >= 65) {
                    logger.error((Object)("contextEngineId validation failed, contextEngineId = " + this.getcleanedMessage(contextEngineId)));
                    return false;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(authProtocol = snmpPara.getAuthProtocol()))) return true;
            if ("HMACMD5".equals(authProtocol) || "HMACSHA".equals(authProtocol)) {
                String authPwd = snmpPara.getAuthPwd();
                if (!this.validateRouterPwd(authPwd)) {
                    return false;
                }
                String encryptProtocol = snmpPara.getEncryptProtocol();
                if (!StringUtils.isNotBlank((CharSequence)encryptProtocol)) return true;
                if ("AES256".equals(encryptProtocol) || "AES128".equals(encryptProtocol) || "DES".equals(encryptProtocol)) {
                    String encryptPwd = snmpPara.getEncryptPwd();
                    if (this.validateRouterPwd(encryptPwd)) return true;
                    return false;
                }
                logger.error((Object)"encryptProtocol validation failed");
                return false;
            }
            logger.error((Object)"authProtocol validation failed");
            return false;
        }
        logger.error((Object)"snmpTempate is null");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean snmpValidate1() {
        if ("true".equals(this.addNeTestFlag)) {
            this.snmpTemplate = new TemplateVO();
            this.snmpTemplate.setPort(Integer.parseInt(this.port));
            this.snmpTemplate.setVersion(Integer.parseInt(this.versionType));
            this.snmpTemplate.setRetries(Integer.parseInt(this.retries));
            this.snmpTemplate.setTimeout(Integer.parseInt(this.timeout));
            if ("3".equals(this.versionType)) {
                this.snmpTemplate.setSecurityName(this.v3securityName);
                this.snmpTemplate.setContextName(this.v3contextName);
                this.snmpTemplate.setContextEngineId(this.v3contextEngineId);
                this.snmpTemplate.setAuthProtocol(this.v3authProtocol);
                this.snmpTemplate.setAuthPwd(this.v3authPwd);
                this.snmpTemplate.setEncryptProtocol(this.v3encryptProtocol);
                this.snmpTemplate.setEncryptPwd(this.v3encryptPwd);
            } else {
                this.snmpTemplate.setReadComm(this.snmpReadComm);
                this.snmpTemplate.setWriteComm(this.snmpWriteComm);
            }
        }
        Pattern p1 = Pattern.compile("[a-zA-Z]+");
        Pattern p2 = Pattern.compile("[0-9]+");
        Pattern p3 = Pattern.compile("[=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+");
        String regexPwd = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        if (null != this.snmpTemplate) {
            String authProtocol;
            String contextEngineId;
            SnmpPara snmpPara = this.snmpTemplate.getSnmpTemplate();
            int version = snmpPara.getVersion();
            String versionRegex = "^[0-3]{1}$";
            if (!String.valueOf(version).matches(versionRegex)) {
                logger.error((Object)("version validation failed, version = " + version));
                return false;
            }
            if (0 == version || 1 == version) {
                String readComm = snmpPara.getReadComm();
                if (!this.validatePwd(readComm)) {
                    return false;
                }
                String writeComm = snmpPara.getWriteComm();
                if (null != writeComm && !writeComm.isEmpty() && writeComm.trim().equals("")) {
                    return false;
                }
                if (!StringUtils.isNotBlank((CharSequence)writeComm)) return true;
                if (writeComm.indexOf(32) > 0) {
                    logger.error((Object)"writeComm validation failed");
                    return false;
                }
                if (writeComm.length() < 6 || writeComm.length() >= 65) {
                    logger.error((Object)"writeComm validation failed");
                    return false;
                }
                Matcher m1 = p1.matcher(writeComm);
                Matcher m2 = p2.matcher(writeComm);
                Matcher m3 = p3.matcher(writeComm);
                if (!(m1.find() && m2.find() && m3.find())) {
                    logger.error((Object)"writeComm validation failed");
                    return false;
                }
                if (writeComm.matches(regexPwd)) return true;
                return false;
            }
            if (3 != version) return true;
            String securityName = snmpPara.getSecurityName();
            if (StringUtils.isNotBlank((CharSequence)securityName)) {
                String securityNameRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
                if (!securityName.matches(securityNameRegex)) {
                    logger.error((Object)("securityName validation failed, securityName = " + this.getcleanedMessage(securityName)));
                    return false;
                }
                if (securityName.length() >= 65) {
                    logger.error((Object)("securityName validation failed, securityName = " + this.getcleanedMessage(securityName)));
                    return false;
                }
            } else {
                logger.error((Object)"securityName is null");
                return false;
            }
            String contextName = snmpPara.getContextName();
            if (StringUtils.isNotBlank((CharSequence)contextName)) {
                String contextNameRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
                if (!contextName.matches(contextNameRegex)) {
                    logger.error((Object)("contextName validation failed, contextName = " + this.getcleanedMessage(contextName)));
                    return false;
                }
                if (contextName.length() >= 65) {
                    logger.error((Object)("contextName validation failed, contextName = " + this.getcleanedMessage(contextName)));
                    return false;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(contextEngineId = snmpPara.getContextEngineId()))) {
                String contextEngineIdRegex = "^[A-Fa-f0-9]+$";
                if (!contextEngineId.matches(contextEngineIdRegex)) {
                    logger.error((Object)("contextEngineId validation failed, contextEngineId = " + this.getcleanedMessage(contextEngineId)));
                    return false;
                }
                if (contextEngineId.length() >= 65) {
                    logger.error((Object)("contextEngineId validation failed, contextEngineId = " + this.getcleanedMessage(contextEngineId)));
                    return false;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(authProtocol = snmpPara.getAuthProtocol()))) return true;
            if ("HMACMD5".equals(authProtocol) || "HMACSHA".equals(authProtocol)) {
                String authPwd = snmpPara.getAuthPwd();
                if (!this.validatePwd(authPwd)) {
                    return false;
                }
                String encryptProtocol = snmpPara.getEncryptProtocol();
                if (!StringUtils.isNotBlank((CharSequence)encryptProtocol)) return true;
                if ("AES256".equals(encryptProtocol) || "AES128".equals(encryptProtocol) || "DES".equals(encryptProtocol)) {
                    String encryptPwd = snmpPara.getEncryptPwd();
                    if (this.validatePwd(encryptPwd)) return true;
                    return false;
                }
                logger.error((Object)("encryptProtocol validation failed, encryptProtocol = " + this.getcleanedMessage(encryptProtocol)));
                return false;
            }
            logger.error((Object)("authProtocol validation failed, authProtocol = " + this.getcleanedMessage(authProtocol)));
            return false;
        }
        logger.error((Object)"snmpTempate is null");
        return false;
    }

    public boolean validateOid() {
        String oidRegex = "^[\\d.]*$";
        if (StringUtils.isNotBlank((CharSequence)this.testOid)) {
            if (this.testOid.length() > 128) {
                logger.error((Object)("testOid validation failed, testOid = " + this.getcleanedMessage(this.testOid)));
                return false;
            }
            if (!this.testOid.matches(oidRegex)) {
                logger.error((Object)("testOid validation failed, testOid = " + this.getcleanedMessage(this.testOid)));
                return false;
            }
        } else {
            logger.error((Object)"testOid validation failed, testOid is null");
            return false;
        }
        return true;
    }

    public boolean processParaForLogIp() {
        if (null == this.logIp) {
            logger.error((Object)"logIp is null");
            return false;
        }
        if (!this.logIp.equals("") && !this.ipValidate(this.logIp)) {
            return false;
        }
        String deviceTypeRegex = "^[1-9]{1}$";
        if (!String.valueOf(this.deviceType).matches(deviceTypeRegex)) {
            logger.error((Object)"deviceType validation failed");
            return false;
        }
        String logSwitchValueRegex = "^[0-2]{1}$";
        if (!String.valueOf(this.logSwitchValue).matches(logSwitchValueRegex)) {
            logger.error((Object)"logSwitchValue validation failed");
            return false;
        }
        return this.validatePwd(this.logPwd);
    }

    private boolean isCollectorIpExists(String devIp) {
        return this.collectorService.validateCollectorIpExist(-1L, devIp);
    }

    private boolean isDeviceIpExists(String devIp) {
        if (null != this.aticDeviceService) {
            return this.aticDeviceService.checkIpAddress(devIp);
        }
        throw new LegoCheckedException(570506L);
    }

    private void setResponse() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html;charset=utf-8");
    }

    private void writeSysLog(AticDevice device, String operation, String detail, String[] para) {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(new Date());
        oOptLog.setTarget(device.getName());
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.ResourceApplication");
        oOptLog.setOperation("secne.dic.function.setlogIp");
        oOptLog.setOperation(operation);
        oOptLog.setDetail(detail + "");
        oOptLog.setDetailPara(para);
        oOptLog.setTargetLocal(Boolean.valueOf(false));
        oOptLog.setResult(SysoplogResultLevel.failed.getValue());
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        if (null != this.sysLogService) {
            this.sysLogService.writeOptLog(oOptLog);
        } else {
            logger.error((Object)"ManageProtocalAction.java.writeSysLog(Update logIP) error. sysOpLog = sysOpLog");
        }
    }

    public boolean validateAdminId() {
        long id = 0L;
        try {
            id = Long.parseLong(this.adminId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean ipAddressValidate() {
        return !StringUtils.isNotBlank((CharSequence)this.ipAddress) || this.ipValidate(this.ipAddress);
    }

    private boolean ipValidate(String ip) {
        if (!AticUtil.validateIpv4((String)ip) && !IPUtil.isIpv6((String)ip)) {
            return false;
        }
        return !ip.equals("0:0:0:0:0:0:0:0");
    }

    public boolean telnetValidate() {
        if ("true".equals(this.addNeTestFlag)) {
            this.telnetTemplate = new TelnetTemplateVO();
            this.telnetTemplate.setAuthMode(Integer.parseInt(this.authMode));
            this.telnetTemplate.setPrototolType(Integer.parseInt(this.prototolType));
            this.telnetTemplate.setPort(Integer.parseInt(this.port));
            this.telnetTemplate.setLoginUser(this.deviceLoginUser);
            this.telnetTemplate.setLoginPwd(this.deviceLoginPwd);
            this.telnetTemplate.setProtocolVersion(Integer.parseInt(this.protocolVersion));
            this.telnetTemplate.setLoginTimeout(Integer.parseInt(this.loginTimeout));
            this.telnetTemplate.setResponseTimeout(Integer.parseInt(this.responseTimeout));
        }
        if (null != this.telnetTemplate && null != this.telnetTemplate.getTemplate()) {
            if (null != this.telnetTemplate.getUserPrivateKey() && !"".equals(this.telnetTemplate.getUserPrivateKey())) {
                return false;
            }
            TelnetPara telnetPara = this.telnetTemplate.getTemplate();
            int protocolType = telnetPara.getProtocolType();
            String protocolTypeRegex = "^[0-1]{1}$";
            if (!String.valueOf(protocolType).matches(protocolTypeRegex)) {
                logger.error((Object)("protocolType validation failed, protocolType = " + protocolType));
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)this.sshPublicKey)) {
                String regex = "^[A-Z|a-z|0-9|\\/|\\+|\\=|\\||\\!|\\*|\\@|\\#|\\$|\\%|\\:|\\;|\\-|\\_|\\.]*$";
                if (this.sshPublicKey.indexOf(" ", 1) > -1) {
                    return false;
                }
                if (!this.sshPublicKey.matches(regex)) {
                    return false;
                }
                if (this.sshPublicKey.length() > 2048) {
                    return false;
                }
            }
            String loginUser = telnetPara.getLoginUser();
            String loginUserRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!StringUtils.isNotBlank((CharSequence)loginUser) || !loginUser.matches(loginUserRegex)) {
                logger.error((Object)("loginUser validation failed, loginUser = " + this.getcleanedMessage(loginUser)));
                return false;
            }
            if (loginUser.length() < 0 || loginUser.length() > 33) {
                logger.error((Object)("loginUser validation failed, loginUser = " + this.getcleanedMessage(loginUser)));
                return false;
            }
            String loginPwd = telnetPara.getLoginPwd();
            return this.validatePwd(loginPwd);
        }
        logger.error((Object)"telnetTemplate or telnetTemplate.getTemplate() is null");
        return false;
    }

    public boolean ftpValidate() {
        if (null != this.ftpTemplate) {
            String loginUser = this.ftpTemplate.getLoginUser();
            String loginUserRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!StringUtils.isNotBlank((CharSequence)loginUser) || !loginUser.matches(loginUserRegex)) {
                logger.error((Object)("loginUser validation failed, loginUser = " + this.getcleanedMessage(loginUser)));
                return false;
            }
            if (loginUser.length() < 0 || loginUser.length() >= 33) {
                logger.error((Object)("loginUser validation failed, loginUser = " + this.getcleanedMessage(loginUser)));
                return false;
            }
            String loginPwd = this.ftpTemplate.getLoginPwd();
            return this.validatePwd(loginPwd);
        }
        logger.error((Object)"ftpTemplate is null");
        return false;
    }

    public boolean validateLogPwd() {
        Pattern p1 = Pattern.compile("[a-zA-Z]+");
        Pattern p2 = Pattern.compile("[0-9]+");
        Pattern p3 = Pattern.compile("[=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+");
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        if (StringUtils.isNotBlank((CharSequence)this.logPwd)) {
            if (this.logPwd.indexOf(32) > 0) {
                return false;
            }
            if (this.logPwd.length() < 6 || this.logPwd.length() >= 65) {
                return false;
            }
            Matcher m1 = p1.matcher(this.logPwd);
            Matcher m2 = p2.matcher(this.logPwd);
            Matcher m3 = p3.matcher(this.logPwd);
            if (!(m1.find() && m2.find() && m3.find())) {
                return false;
            }
            if (!this.logPwd.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean restfulDdosValidate() {
        if (null != this.addNeTestFlag && "true".equals(this.addNeTestFlag)) {
            this.restfulDdosTemplate = new RestfulDdosVO();
            this.restfulDdosTemplate.setRestfulEnable(null == this.restfulDdosEnable ? Boolean.FALSE : this.restfulDdosEnable);
            this.restfulDdosTemplate.setRestfulType(this.restfulDdosType);
            this.restfulDdosTemplate.setRestfulPort(this.restfulDdosPort);
            this.restfulDdosTemplate.setRestfulIp(this.restfulDdosIp);
            this.restfulDdosTemplate.setRestfulUser(this.restfulDdosUser);
            this.restfulDdosTemplate.setRestfulCertAlias(this.restfulCertAlias);
            this.restfulDdosTemplate.setRestfulPassword(this.restfulDdosPassword);
        } else if (null != this.addNeTestFlag && "false".equals(this.addNeTestFlag)) {
            this.restfulDdosTemplate = new RestfulDdosVO();
            this.restfulDdosTemplate.setRestfulEnable(null == this.restfulDdosEnable ? Boolean.FALSE : this.restfulDdosEnable);
            this.restfulDdosTemplate.setRestfulType(this.restfulDdosType);
            this.restfulDdosTemplate.setRestfulPort(this.restfulDdosPort);
            this.restfulDdosTemplate.setRestfulIp(this.restfulDdosIp);
            this.restfulDdosTemplate.setRestfulUser(this.restfulDdosUser);
            this.restfulDdosTemplate.setRestfulCertAlias(this.restfulCertAlias);
            if (null != this.restfulDdosPassword) {
                this.restfulDdosTemplate.setRestfulPassword(this.restfulDdosPassword);
            }
        }
        if (null != this.restfulDdosTemplate && !this.restfulDdosTemplate.getRestfulEnable().booleanValue()) {
            return true;
        }
        if (null != this.restfulDdosTemplate) {
            String loginPwd;
            String loginUser = this.restfulDdosTemplate.getRestfulUser();
            String loginUserRegex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!StringUtils.isNotBlank((CharSequence)loginUser) || !loginUser.matches(loginUserRegex)) {
                logger.error((Object)("loginUser validation failed, loginUser = " + this.getcleanedMessage(loginUser)));
                return false;
            }
            if (loginUser.length() < 0 || loginUser.length() >= 33) {
                logger.error((Object)("loginUser validation failed, loginUser = " + this.getcleanedMessage(loginUser)));
                return false;
            }
            return null == this.restfulDdosPassword || this.validatePwd(loginPwd = this.restfulDdosTemplate.getRestfulPassword());
        }
        logger.error((Object)"restfulDdosTemplate is null");
        return false;
    }

    public boolean oidValidate() {
        if (null == this.aticDeviceRouter) {
            return false;
        }
        String oidRegex = "^[\\d.]*$";
        String cpuOid = this.aticDeviceRouter.getCpuOid();
        String memeryOid = this.aticDeviceRouter.getMemeryOid();
        if (StringUtils.isNotBlank((CharSequence)cpuOid)) {
            if (cpuOid.length() > 128) {
                logger.error((Object)("cpuOid validation failed, cpuOid = " + this.getcleanedMessage(cpuOid)));
                return false;
            }
            if (!cpuOid.matches(oidRegex)) {
                logger.error((Object)("cpuOid validation failed, cpuOid = " + this.getcleanedMessage(cpuOid)));
                return false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)memeryOid)) {
            if (memeryOid.length() > 128) {
                logger.error((Object)("memeryOid validation failed, memeryOid = " + this.getcleanedMessage(memeryOid)));
                return false;
            }
            if (!memeryOid.matches(oidRegex)) {
                logger.error((Object)("memeryOid validation failed, memeryOid = " + this.getcleanedMessage(memeryOid)));
                return false;
            }
        }
        return true;
    }

    public boolean validateSecurityName() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.snmpTemplate.getSecurityName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                logger.error((Object)("securityName validation failed, securityName = " + this.getcleanedMessage(name)));
                return false;
            }
            if (!name.matches(regex)) {
                logger.error((Object)("securityName validation failed, securityName = " + this.getcleanedMessage(name)));
                return false;
            }
        }
        return true;
    }

    public boolean validateContextName() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.snmpTemplate.getContextName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                logger.error((Object)("ContextName validation failed, ContextName = " + this.getcleanedMessage(name)));
                return false;
            }
            if (!name.matches(regex)) {
                logger.error((Object)("ContextName validation failed, ContextName = " + this.getcleanedMessage(name)));
                return false;
            }
        }
        return true;
    }

    public boolean validateContextEngineId() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String regex = "^[A-Fa-f0-9]+$";
        String name = this.snmpTemplate.getContextEngineId();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                logger.error((Object)("contextEngineId validation failed, contextEngineId = " + this.getcleanedMessage(name)));
                return false;
            }
            if (!name.matches(regex)) {
                logger.error((Object)("contextEngineId validation failed, contextEngineId = " + this.getcleanedMessage(name)));
                return false;
            }
        }
        return true;
    }

    public boolean validateAuthPwd() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String reg = "^[a-zA-Z]+$";
        String reg1 = "^[0-9]+$";
        String reg2 = "^[=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+$";
        String reg3 = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.snmpTemplate.getAuthPwd();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                return false;
            }
            if (!(name.matches(reg) && name.matches(reg1) && name.matches(reg2) && name.matches(reg3))) {
                return false;
            }
        }
        return true;
    }

    public boolean validateEncryptPwd() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String reg = "^[a-zA-Z]+$";
        String reg1 = "^[0-9]+$";
        String reg2 = "^[=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+$";
        String reg3 = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.snmpTemplate.getEncryptPwd();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                return false;
            }
            if (!(name.matches(reg) && name.matches(reg1) && name.matches(reg2) && name.matches(reg3))) {
                return false;
            }
        }
        return true;
    }

    public boolean validateReadComm() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.snmpTemplate.getReadComm();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                logger.error((Object)("readComm validation failed, readComm = " + this.getcleanedMessage(name)));
                return false;
            }
            if (!name.matches(regex)) {
                logger.error((Object)("readComm validation failed, readComm = " + this.getcleanedMessage(name)));
                return false;
            }
        }
        return true;
    }

    public boolean validateWriteComm() {
        if (null == this.snmpTemplate) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.snmpTemplate.getWriteComm();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() > 64) {
                logger.error((Object)("writeComm validation failed, writeComm = " + this.getcleanedMessage(name)));
                return false;
            }
            if (!name.matches(regex)) {
                logger.error((Object)("writeComm validation failed, writeComm = " + this.getcleanedMessage(name)));
                return false;
            }
        }
        return true;
    }

    public boolean validateRestfulIp() {
        if (null == this.restfulDdosTemplate) {
            return true;
        }
        String name = this.restfulDdosTemplate.getRestfulIp();
        if (StringUtils.isNotBlank((CharSequence)name) && !AticUtil.validateIpv4((String)name)) {
            logger.error((Object)("writeComm validation failed, writeComm = " + this.getcleanedMessage(name)));
            return false;
        }
        return true;
    }

    public boolean validateRestfulUser() {
        if (null == this.restfulDdosTemplate) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.restfulDdosTemplate.getRestfulUser();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (!name.matches(regex)) {
                return false;
            }
            if (name.length() > 32) {
                return false;
            }
        }
        return true;
    }

    public boolean validateRestfulPassword() {
        if (null == this.restfulDdosTemplate) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        String name = this.restfulDdosTemplate.getRestfulPassword();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (name.length() < 6 || name.length() > 64) {
                return false;
            }
            if (!name.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateAddNeTestFlag() {
        if (null == this.addNeTestFlag) {
            return true;
        }
        return !StringUtils.isNotBlank((CharSequence)this.addNeTestFlag) || "true".equals(this.addNeTestFlag) || "false".equals(this.addNeTestFlag);
    }

    public boolean validateRestfulDdosUser() {
        if (null == this.restfulDdosUser) {
            return true;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        if (StringUtils.isNotBlank((CharSequence)this.restfulDdosUser)) {
            if (!this.restfulDdosUser.matches(regex)) {
                return false;
            }
            if (this.restfulDdosUser.length() > 32) {
                return false;
            }
        }
        return true;
    }

    public boolean validateRestfulDdosPassword() {
        if (null == this.restfulDdosPassword) {
            return true;
        }
        Pattern p1 = Pattern.compile("[a-zA-Z]+");
        Pattern p2 = Pattern.compile("[0-9]+");
        Pattern p3 = Pattern.compile("[=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+");
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        if (StringUtils.isNotBlank((CharSequence)this.restfulDdosPassword)) {
            if (this.restfulDdosPassword.indexOf(32) > 0) {
                return false;
            }
            if (this.restfulDdosPassword.length() < 6 || this.restfulDdosPassword.length() >= 65) {
                return false;
            }
            Matcher m1 = p1.matcher(this.restfulDdosPassword);
            Matcher m2 = p2.matcher(this.restfulDdosPassword);
            Matcher m3 = p3.matcher(this.restfulDdosPassword);
            if (!(m1.find() && m2.find() && m3.find())) {
                return false;
            }
            if (!this.restfulDdosPassword.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateRestfulDdosIp() {
        if (null == this.restfulDdosIp) {
            return true;
        }
        return !StringUtils.isNotBlank((CharSequence)this.restfulDdosIp) || AticUtil.validateIpv4((String)this.restfulDdosIp);
    }

    public boolean validateNeIDsStr() {
        if (!StringUtils.isNotBlank((CharSequence)this.neIDsStr)) {
            return false;
        }
        try {
            long id = Long.parseLong(this.neIDsStr);
            if (id < 0L) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean validateFlowIdList() {
        if (!StringUtils.isEmpty((CharSequence)this.flowIdList)) {
            String[] flowArray = this.flowIdList.split(",");
            if (flowArray.length > 100) {
                return false;
            }
            for (String moId : flowArray) {
                if (AticUtil.isNullForVpn((String)moId)) continue;
                try {
                    long id = Long.parseLong(moId);
                    if (id >= 0L) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateDeviceIdList() {
        if (!StringUtils.isEmpty((CharSequence)this.deviceIdList)) {
            String[] flowArray = this.deviceIdList.split(",");
            if (flowArray.length > 100) {
                return false;
            }
            for (String moId : flowArray) {
                if (AticUtil.isNullForVpn((String)moId)) continue;
                try {
                    long id = Long.parseLong(moId);
                    if (id >= 0L) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateHasTel() {
        return StringUtils.equals((CharSequence)this.hasTel, (CharSequence)"true") || StringUtils.equals((CharSequence)this.hasTel, (CharSequence)"false");
    }

    public boolean validateTestSnmp() {
        if (null == this.aticDeviceRouter && StringUtils.isEmpty((CharSequence)this.addNeTestRouter)) {
            boolean flag = this.snmpValidate1();
            if (!flag) {
                return false;
            }
        } else {
            boolean flag = this.snmpValidate();
            if (!flag) {
                return false;
            }
            if ("true".equals(this.addNeTestRouter)) {
                return true;
            }
            boolean blean = this.oidValidate();
            if (!blean) {
                return false;
            }
            long id = this.aticDeviceRouter.getMoId();
            if (id < 0L) {
                logger.error((Object)"id validation failed");
                return false;
            }
        }
        return true;
    }

    public boolean validatePwd(String pwd) {
        Pattern p1 = Pattern.compile("[a-zA-Z]+");
        Pattern p2 = Pattern.compile("[0-9]+");
        Pattern p3 = Pattern.compile("[=|\\-|_|!|@|#|$|%|\\*|\\^|||:|;|\\,|\\.|/|\\'|\\+|\\}|\\{|&]+");
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|/|'|+|}|{|&]+$";
        if (StringUtils.isNotBlank((CharSequence)pwd) && !this.checkPwdByLengthAndPattern(pwd, p1, p2, p3, regex)) {
            return false;
        }
        return null == pwd || !pwd.trim().equals("");
    }

    public boolean validateRouterPwd(String pwd) {
        if (null != pwd && !pwd.isEmpty() && pwd.trim().equals("")) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)pwd)) {
            if (pwd.indexOf(" ", 1) > -1) {
                return false;
            }
            if (pwd.length() >= 65) {
                return false;
            }
            String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!pwd.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateVersionType() {
        if (this.versionType == null) {
            return true;
        }
        String versionRegex = "^[0-3]{1}$";
        if (!this.versionType.matches(versionRegex)) {
            logger.error((Object)("version validation failed, version = " + this.versionType));
            return false;
        }
        return true;
    }

    public boolean validateNeIds() {
        if (null != this.neIds) {
            if ("".equals(this.neIds)) {
                return true;
            }
            if (!StringUtils.isEmpty((CharSequence)this.neIds)) {
                String[] idStrs = this.neIds.split(",");
                if (idStrs.length > 100) {
                    return false;
                }
                for (String idm : idStrs) {
                    if (!AticUtil.isNull((String)idm) && Integer.parseInt(idm) >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateCertAliasSave() {
        if (null != this.restfulDdosTemplate && !this.restfulDdosTemplate.getRestfulEnable().booleanValue()) {
            return true;
        }
        return this.validateCertAlias();
    }

    public boolean validateCertAlias() {
        if (AticUtil.isNull((String)this.restfulCertAlias)) {
            return this.restfulDdosType == 1;
        }
        Pattern pattern = Pattern.compile("^(?!_)(?![0-9])[a-zA-Z_0-9]+$");
        Matcher matcher = pattern.matcher(this.restfulCertAlias);
        if (!matcher.matches()) {
            return false;
        }
        return this.restfulCertAlias.length() > 0 && this.restfulCertAlias.length() <= 128;
    }

    public boolean validatePort() {
        try {
            if (null == this.port) {
                return true;
            }
            int vPort = Integer.parseInt(this.port);
            if (vPort >= 1 && vPort <= 65535) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean validateTimeout() {
        try {
            if (null == this.timeout) {
                return true;
            }
            int vTimeout = Integer.parseInt(this.timeout);
            if (vTimeout >= 1 && vTimeout <= 600) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean validateLoginTimeout() {
        try {
            if (null == this.loginTimeout) {
                return true;
            }
            int vTimeout = Integer.parseInt(this.loginTimeout);
            if (vTimeout >= 1 && vTimeout <= 600) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean validateResponseTimeout() {
        try {
            if (null == this.responseTimeout) {
                return true;
            }
            int vTimeout = Integer.parseInt(this.responseTimeout);
            if (vTimeout >= 1 && vTimeout <= 600) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean simpleSystemNameValidation() {
        if (!StringUtils.isEmpty((CharSequence)this.simpleSystemName)) {
            String nameRegex = "^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            if (!this.simpleSystemName.matches(nameRegex)) {
                return false;
            }
            if (this.simpleSystemName.length() > 32) {
                return false;
            }
        }
        return true;
    }

    public TemplateVO getSnmpTempate() {
        return this.snmpTempate;
    }

    public void setSnmpTempate(TemplateVO snmpTempate) {
        this.snmpTempate = snmpTempate;
    }

    public TelnetTemplateVO getTelnetTemplate() {
        return this.telnetTemplate;
    }

    public void setTelnetTemplate(TelnetTemplateVO telnetTemplate) {
        this.telnetTemplate = telnetTemplate;
    }

    public FtpVO getFtpTemplate() {
        return this.ftpTemplate;
    }

    public void setFtpTemplate(FtpVO ftpTemplate) {
        this.ftpTemplate = ftpTemplate;
    }

    public List<LangPair> getLstAuthtemp() {
        return this.lstAuthtemp;
    }

    public List<LangPair> getLstTelAuthtemp() {
        return this.lstTelAuthtemp;
    }

    public String getAuthModeName() {
        return this.authModeName;
    }

    public Long getMoid() {
        return this.moid;
    }

    public void setMoid(Long moid) {
        this.moid = moid;
    }

    public String getSauthModeName() {
        return this.sauthModeName;
    }

    public Integer getSauthMode() {
        return this.sauthMode;
    }

    public void setSauthMode(Integer sauthMode) {
        this.sauthMode = sauthMode;
    }

    public List<LangPair> getLstPrivateLevel() {
        return this.lstPrivateLevel;
    }

    public void setLstPrivateLevel(List<LangPair> lstPrivateLevel) {
        this.lstPrivateLevel = lstPrivateLevel;
    }

    public Long getTemplateID() {
        return this.templateID;
    }

    public void setTemplateID(Long templateID) {
        this.templateID = templateID;
    }

    public List<LangPair> getLstTelnettemp() {
        return this.lstTelnettemp;
    }

    public void setLstTelnettemp(List<LangPair> lstTelnettemp) {
        this.lstTelnettemp = lstTelnettemp;
    }

    public List<LangPair> getLstStelnettemp() {
        return this.lstStelnettemp;
    }

    public void setLstStelnettemp(List<LangPair> lstStelnettemp) {
        this.lstStelnettemp = lstStelnettemp;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public List<LangPair> getLstsnmpv1temp() {
        return this.lstsnmpv1temp;
    }

    public void setLstsnmpv1temp(List<LangPair> lstsnmpv1temp) {
        this.lstsnmpv1temp = lstsnmpv1temp;
    }

    public List<LangPair> getLstsnmpv2temp() {
        return this.lstsnmpv2temp;
    }

    public void setLstsnmpv2temp(List<LangPair> lstsnmpv2temp) {
        this.lstsnmpv2temp = lstsnmpv2temp;
    }

    public List<LangPair> getLstsnmpv3temp() {
        return this.lstsnmpv3temp;
    }

    public void setLstsnmpv3temp(List<LangPair> lstsnmpv3temp) {
        this.lstsnmpv3temp = lstsnmpv3temp;
    }

    public TemplateVO getSnmpTemplate() {
        return this.snmpTemplate;
    }

    public void setSnmpTemplate(TemplateVO snmpTemplate) {
        this.snmpTemplate = snmpTemplate;
    }

    public List<LangPair> getLstauthProtocol() {
        return lstauthProtocol;
    }

    public List<LangPair> getLstencryptProtocol() {
        return lstencryptProtocol;
    }

    public File getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(File privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getNeIDsStr() {
        return this.neIDsStr;
    }

    public void setNeIDsStr(String neIDsStr) {
        this.neIDsStr = neIDsStr;
    }

    public List<AticDeviceRouterForm> getExistList() {
        return this.existList;
    }

    public void setExistList(List<AticDeviceRouterForm> existList) {
        this.existList = existList;
    }

    public String getFlowIdList() {
        return this.flowIdList;
    }

    public void setFlowIdList(String flowIdList) {
        this.flowIdList = flowIdList;
    }

    public List<AticDeviceRouterForm> getFlowFormList() {
        return this.flowFormList;
    }

    public void setFlowFormList(List<AticDeviceRouterForm> flowFormList) {
        this.flowFormList = flowFormList;
    }

    public AticDeviceRouter getAticDeviceRouter() {
        return this.aticDeviceRouter;
    }

    public void setAticDeviceRouter(AticDeviceRouter aticDeviceRouter) {
        this.aticDeviceRouter = aticDeviceRouter;
    }

    public List<LangPair> getSampleModeList() {
        return this.sampleModeList;
    }

    public void setSampleModeList(List<LangPair> sampleModeList) {
        this.sampleModeList = sampleModeList;
    }

    public String getTestOid() {
        return this.testOid;
    }

    public void setTestOid(String testOid) {
        this.testOid = testOid;
    }

    public String getLogIp() {
        return this.logIp;
    }

    public void setLogIp(String logIp) {
        this.logIp = logIp;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    public void setSshPublicKey(String sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
    }

    public String getLogPwd() {
        return this.logPwd;
    }

    public void setLogPwd(String logPwd) {
        this.logPwd = logPwd;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public boolean isEncryptType() {
        return this.encryptType;
    }

    public void setEncryptType(boolean encryptType) {
        this.encryptType = encryptType;
    }

    public int getLogSwitchValue() {
        return this.logSwitchValue;
    }

    public void setLogSwitchValue(int logSwitchValue) {
        this.logSwitchValue = logSwitchValue;
    }

    public HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    public User getLegoUser() {
        return (User)this.getSession().getAttribute("currentUser");
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public List<AticDevice> getFireDeviceList() {
        return this.fireDeviceList;
    }

    public void setFireDeviceList(List<AticDevice> fireDeviceList) {
        this.fireDeviceList = fireDeviceList;
    }

    public String getNeIds() {
        return this.neIds;
    }

    public void setNeIds(String neIds) {
        this.neIds = neIds;
    }

    public String getDeviceIdList() {
        return this.deviceIdList;
    }

    public void setDeviceIdList(String deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    public int getIsClusterNfa() {
        return this.isClusterNfa;
    }

    public void setIsClusterNfa(int isClusterNfa) {
        this.isClusterNfa = isClusterNfa;
    }

    public String getAddNeTestFlag() {
        return this.addNeTestFlag;
    }

    public void setAddNeTestFlag(String addNeTestFlag) {
        this.addNeTestFlag = addNeTestFlag;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getPrototolType() {
        return this.prototolType;
    }

    public void setPrototolType(String prototolType) {
        this.prototolType = prototolType;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDeviceLoginUser() {
        return this.deviceLoginUser;
    }

    public void setDeviceLoginUser(String deviceLoginUser) {
        this.deviceLoginUser = deviceLoginUser;
    }

    public String getDeviceLoginPwd() {
        return this.deviceLoginPwd;
    }

    public void setDeviceLoginPwd(String deviceLoginPwd) {
        this.deviceLoginPwd = deviceLoginPwd;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(String loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public String getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(String responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public void setVersionType(String versionType) {
        this.versionType = versionType;
    }

    public String getRetries() {
        return this.retries;
    }

    public void setRetries(String retries) {
        this.retries = retries;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getSnmpReadComm() {
        return this.snmpReadComm;
    }

    public void setSnmpReadComm(String snmpReadComm) {
        this.snmpReadComm = snmpReadComm;
    }

    public String getSnmpWriteComm() {
        return this.snmpWriteComm;
    }

    public void setSnmpWriteComm(String snmpWriteComm) {
        this.snmpWriteComm = snmpWriteComm;
    }

    public String getV3securityName() {
        return this.v3securityName;
    }

    public void setV3securityName(String v3securityName) {
        this.v3securityName = v3securityName;
    }

    public String getV3contextName() {
        return this.v3contextName;
    }

    public void setV3contextName(String v3contextName) {
        this.v3contextName = v3contextName;
    }

    public String getV3contextEngineId() {
        return this.v3contextEngineId;
    }

    public void setV3contextEngineId(String v3contextEngineId) {
        this.v3contextEngineId = v3contextEngineId;
    }

    public String getV3authProtocol() {
        return this.v3authProtocol;
    }

    public void setV3authProtocol(String v3authProtocol) {
        this.v3authProtocol = v3authProtocol;
    }

    public String getV3authPwd() {
        return this.v3authPwd;
    }

    public void setV3authPwd(String v3authPwd) {
        this.v3authPwd = v3authPwd;
    }

    public String getV3encryptProtocol() {
        return this.v3encryptProtocol;
    }

    public void setV3encryptProtocol(String v3encryptProtocol) {
        this.v3encryptProtocol = v3encryptProtocol;
    }

    public String getV3encryptPwd() {
        return this.v3encryptPwd;
    }

    public void setV3encryptPwd(String v3encryptPwd) {
        this.v3encryptPwd = v3encryptPwd;
    }

    public String getAddNeTestRouter() {
        return this.addNeTestRouter;
    }

    public void setAddNeTestRouter(String addNeTestRouter) {
        this.addNeTestRouter = addNeTestRouter;
    }

    public boolean isSupportOutbound() {
        return this.isSupportOutbound;
    }

    public void setIsSupportOutbound(boolean isSupportOutbound) {
        this.isSupportOutbound = isSupportOutbound;
    }

    public Boolean getClusterOutbound() {
        return this.clusterOutbound;
    }

    public void setClusterOutbound(Boolean clusterOutbound) {
        this.clusterOutbound = clusterOutbound;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public IAticDeviceRouterService getAticDeviceRouterService() {
        return this.aticDeviceRouterService;
    }

    public void setAticDeviceRouterService(IAticDeviceRouterService aticDeviceRouterService) {
        this.aticDeviceRouterService = aticDeviceRouterService;
    }

    public IAticDeviceNfaRouterService getAticDeviceNfaRouterService() {
        return this.aticDeviceNfaRouterService;
    }

    public void setAticDeviceNfaRouterService(IAticDeviceNfaRouterService aticDeviceNfaRouterService) {
        this.aticDeviceNfaRouterService = aticDeviceNfaRouterService;
    }

    public ITemplateService getTemplateService() {
        return this.templateService;
    }

    public void setTemplateService(ITemplateService templateService) {
        this.templateService = templateService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IDefendGroupService getDefendGroupService() {
        return this.defendGroupService;
    }

    public void setDefendGroupService(IDefendGroupService defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public IDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public RestfulDdosVO getRestfulDdosTemplate() {
        return this.restfulDdosTemplate;
    }

    public void setRestfulDdosTemplate(RestfulDdosVO restfulDdosTemplate) {
        this.restfulDdosTemplate = restfulDdosTemplate;
    }

    public Boolean getRestfulDdosEnable() {
        return this.restfulDdosEnable;
    }

    public void setRestfulDdosEnable(Boolean restfulDdosEnable) {
        this.restfulDdosEnable = restfulDdosEnable;
    }

    public Integer getRestfulDdosType() {
        return this.restfulDdosType;
    }

    public void setRestfulDdosType(Integer restfulDdosType) {
        this.restfulDdosType = restfulDdosType;
    }

    public Integer getRestfulDdosPort() {
        return this.restfulDdosPort;
    }

    public void setRestfulDdosPort(Integer restfulDdosPort) {
        this.restfulDdosPort = restfulDdosPort;
    }

    public String getRestfulDdosIp() {
        return this.restfulDdosIp;
    }

    public void setRestfulDdosIp(String restfulDdosIp) {
        this.restfulDdosIp = restfulDdosIp;
    }

    public String getRestfulDdosUser() {
        return this.restfulDdosUser;
    }

    public void setRestfulDdosUser(String restfulDdosUser) {
        this.restfulDdosUser = restfulDdosUser;
    }

    public String getRestfulDdosPassword() {
        return this.restfulDdosPassword;
    }

    public void setRestfulDdosPassword(String restfulDdosPassword) {
        this.restfulDdosPassword = restfulDdosPassword;
    }

    public String getHasTel() {
        return this.hasTel;
    }

    public void setHasTel(String hasTel) {
        this.hasTel = hasTel;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }

    public String getRestfulCertAlias() {
        return this.restfulCertAlias;
    }

    public void setRestfulCertAlias(String restfulCertAlias) {
        this.restfulCertAlias = restfulCertAlias;
    }

    public ArrayList<LangPair> getCertList() {
        return this.certList;
    }

    public void setCertList(ArrayList<LangPair> certList) {
        this.certList = certList;
    }

    private boolean checkPwdLength(String pwd) {
        if (pwd.indexOf(32) > 0) {
            return false;
        }
        return pwd.length() >= 6 && pwd.length() < 65;
    }

    private boolean checkPwdByPattern(String pwd, Pattern p1, Pattern p2, Pattern p3, String regex) {
        Matcher m1 = p1.matcher(pwd);
        Matcher m2 = p2.matcher(pwd);
        Matcher m3 = p3.matcher(pwd);
        if (!(m1.find() && m2.find() && m3.find())) {
            return false;
        }
        return pwd.matches(regex);
    }

    private boolean checkPwdByLengthAndPattern(String pwd, Pattern p1, Pattern p2, Pattern p3, String regex) {
        if (!this.checkPwdLength(pwd)) {
            return false;
        }
        return this.checkPwdByPattern(pwd, p1, p2, p3, regex);
    }

    static {
        lstauthProtocol = new ArrayList<LangPair>(3);
        lstauthProtocol.add(new LangPair("", "1"));
        lstauthProtocol.add(new LangPair("HMACMD5", "2"));
        lstauthProtocol.add(new LangPair("HMACSHA", "3"));
        lstencryptProtocol = new ArrayList<LangPair>(3);
        lstencryptProtocol.add(new LangPair("", "1"));
        lstencryptProtocol.add(new LangPair("DES", "2"));
        lstencryptProtocol.add(new LangPair("AES128", "3"));
        lstencryptProtocol.add(new LangPair("AES256", "4"));
    }
}

