/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.resource.dao;

import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNexthop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AticDeviceDao
extends CommonDaoImpl {
    public List<AticDevice> getAllDevice() {
        String hql = "from AticDevice";
        List deviceList = this.findByHql(hql);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getNfa2000VByIds(List<Long> moidList) {
        StringBuilder conditionsb = new StringBuilder("");
        for (Long moid : moidList) {
            conditionsb.append("moId = " + moid + " or ");
        }
        String condition = conditionsb.toString().trim();
        if (condition.endsWith("or")) {
            condition = condition.substring(0, condition.length() - 2);
        }
        if (condition.length() > 0) {
            condition = " and ( " + condition + " )";
        }
        String hql = "from AticDevice where deviceType = 8" + condition;
        this.logger.info((Object)("getAntiDDoS1280NByIds sql ,condition " + condition));
        List deviceList = this.findByHql(hql);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getAllNfa2000VCluster() {
        String hql = "from AticDevice where deviceType = 9";
        List deviceList = this.findByHql(hql);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getAllSysLog() {
        String hql = "from AticDevice where deviceType = 3";
        List deviceList = this.findByHql(hql);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getAllAntiDDoS1820N() {
        String hql = "from AticDevice where deviceType = 8";
        List deviceList = this.findByHql(hql);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getAllDevice(long userId, boolean isAdmin) {
        List deviceList;
        StringBuffer hql = new StringBuffer("from AticDevice");
        if (userId > 1L && !isAdmin) {
            hql.append(" where moid in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")");
        }
        if ((deviceList = this.findByHql(hql.toString())) != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public AticDevice getDeviceByMoid(long moid) {
        String hql = "from AticDevice where moId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(moid));
        List deviceList = this.findByHql(hql, param);
        if (deviceList == null || deviceList.isEmpty()) {
            return null;
        }
        return (AticDevice)deviceList.get(0);
    }

    public void deleteDeviceByMoid(long moid) {
        String hql = "delete from AticDevice where moId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{moid});
    }

    public AticDevice getDeviceByIp(String ipAdress) {
        String hql = "from AticDevice where ipAddress = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, ipAdress);
        List deviceList = this.findByHql(hql, param);
        if (deviceList == null || deviceList.isEmpty()) {
            return null;
        }
        return (AticDevice)deviceList.get(0);
    }

    public List<AticDevice> queryDevice(int ddosType, long userId, boolean isAdmin) {
        String hql = "from AticDevice where (ddosType = 2 or ddosType = ?0) ";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(ddosType));
        List deviceList = this.findByHql(hql, queryMap);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> queryDevice(int ddosType) {
        return this.queryDevice(ddosType, 0L, true);
    }

    public List<AticDevice> getAntiDDoSDevice() {
        return this.getAntiDDoSDevice(0L, true);
    }

    public List<AticDevice> getAntiDDoSDevice(long userId, boolean isAdmin) {
        List deviceList;
        String hql = "from AticDevice where deviceType = 1";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        if ((deviceList = this.findByHql(hql)) != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getNFA2000VDevice() {
        return this.getNFA2000VDevice(0L, true);
    }

    public List<AticDevice> getNFA2000VDevice(long userId, boolean isAdmin) {
        List deviceList;
        String hql = "from AticDevice where deviceType = 8";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        if ((deviceList = this.findByHql(hql)) != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getClusterDevice(long userId, boolean isAdmin) {
        List deviceList;
        String hql = "from AticDevice where deviceType = 9";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        if ((deviceList = this.findByHql(hql)) != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getSyslogDevice() {
        return this.getSyslogDevice(0L, true);
    }

    public List<AticDevice> getSyslogDevice(long userId, boolean isAdmin) {
        List deviceList;
        String hql = "from AticDevice where deviceType = 3";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        if ((deviceList = this.findByHql(hql)) != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getNeedMonitDevice() {
        String hql = "from AticDevice where deviceType in ( 1,8,6)";
        List deviceList = this.findByHql(hql);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public boolean checkMoName4Edit(String name, Long moId) {
        String hql = "select name from AticDevice where name = ?0 and moId != ?1";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, name);
        queryMap.put(1, String.valueOf(moId));
        List deviceList = this.findByHql(hql, queryMap);
        return deviceList != null && !deviceList.isEmpty();
    }

    public boolean checkMoName4Add(String name) {
        String hql = "select name from AticDevice where upper(name) = ?0";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, name.toUpperCase(Locale.getDefault()));
        List deviceList = this.findByHql(hql, queryMap);
        return deviceList != null && !deviceList.isEmpty();
    }

    public boolean checkMoIPAdd(String devIp) {
        String hql = "select ipAddress from AticDevice where ipAddress = ?0";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, devIp);
        List deviceList = this.findByHql(hql, queryMap);
        return deviceList != null && !deviceList.isEmpty();
    }

    public Paging queryDeviceByPage(String nameOrIp, int start, int pageSize, long userId, boolean isAdmin) {
        Paging page = new Paging();
        String hql = "from AticDevice where (upper(name) like ?0 or ipAddress = ?1) ";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, "%" + nameOrIp.toUpperCase(Locale.getDefault()) + "%");
        queryMap.put(1, nameOrIp);
        List deviceList = this.findByHql(hql, queryMap);
        if (deviceList != null && !deviceList.isEmpty()) {
            int count = deviceList.size();
            List tempList = this.findPage(hql, start, pageSize, queryMap);
            page.setData(tempList);
            page.setCount(count);
        }
        return page;
    }

    public Paging queryDeviceByPage(Map<String, String> conditionMap, int start, int pageSize) {
        List deviceList;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from AticDevice where (1=1) ";
        int index = 0;
        String nameOrIp = conditionMap.get("nameOrIp");
        if (nameOrIp != null) {
            hql = hql + "and (upper(name) like ?0 or ipAddress = ?1)";
            queryMap.put(index++, "%" + nameOrIp.toUpperCase(Locale.getDefault()) + "%");
            queryMap.put(index, nameOrIp);
        }
        String isAdmin = conditionMap.get("isAdmin");
        String userId = conditionMap.get("userId");
        if (isAdmin.equalsIgnoreCase("false") && userId != null) {
            long uid = Long.parseLong(userId);
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(uid) + ")";
        }
        if ((deviceList = this.findByHql(hql, queryMap)) != null && !deviceList.isEmpty()) {
            int count = deviceList.size();
            List tempList = this.findPage(hql, start, pageSize, queryMap);
            page.setData(tempList);
            page.setCount(count);
        }
        return page;
    }

    public List<AticDevice> getDeviceByZoneId(long zoneId) {
        String hql = "from AticDevice where moId in(select deviceId from ZoneDeviceInfo where zoneId = ?0) ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(zoneId));
        List deviceList = this.findByHql(hql, param);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getDeviceByZoneId(long zoneId, long userId) {
        List deviceList;
        String hql = "SELECT device FROM AticDevice device ";
        if (userId != 1L) {
            hql = hql + " LEFT JOIN UserRelMoInfo userRelMo ON device.moId = userRelMo.id.moId";
        }
        hql = hql + " WHERE device.moId in(select deviceId from ZoneDeviceInfo where zoneId = ?0) ";
        if (userId != 1L) {
            hql = hql + " AND userRelMo.id.userId = ?1";
            hql = hql + " GROUP BY device.moId";
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(zoneId));
        if (userId != 1L) {
            param.put(1, String.valueOf(userId));
        }
        if ((deviceList = this.findByHql(hql, param)) != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> getDeviceIdByDeviceName(String deviceName) {
        String hql = "from AticDevice where name = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceName);
        List deviceList = this.findByHql(hql, param);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> queryAntiddosDevice(int ddosType, long userId, boolean isAdmin) {
        String hql = "from AticDevice where (ddosType = ?0) ";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and  moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(ddosType));
        List deviceList = this.findByHql(hql, queryMap);
        if (deviceList != null) {
            return deviceList;
        }
        return new ArrayList<AticDevice>();
    }

    public List<AticDevice> queryDeviceListByClusterId(Long id) {
        String hql = "from AticDevice where moId in( select deviceId from  AticDeviceNfaCluster where clusterId = ?0 )";
        List deviceList = this.getHibernateTemplate().find(hql, new Object[]{id});
        return deviceList;
    }

    public List<AticDevice> queryNfaAndRouteByPrivilege(long userId, boolean isAdmin) {
        String hql = "from AticDevice where deviceType in(:ids)";
        if (userId > 1L && !isAdmin) {
            hql = hql + " and moId in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")";
        }
        List deviceList = this.currentSession().createQuery(hql).setParameterList("ids", new Object[]{8, 6}).list();
        return deviceList;
    }

    public List<AticDevice> queryNfaByClusterId(Long id) {
        String hql = "from AticDevice where moId in( select deviceId from  AticDeviceNfaCluster where clusterId = ?0 and deviceType = 8)";
        List deviceList = this.getHibernateTemplate().find(hql, new Object[]{id});
        return deviceList;
    }

    public AticDeviceNexthop getNexthopIpByMoid(long moid) {
        String hql = "from AticDeviceNexthop where moId = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(moid));
        List findByHql = this.findByHql(hql, param);
        if (null == findByHql || findByHql.isEmpty()) {
            return new AticDeviceNexthop();
        }
        return (AticDeviceNexthop)findByHql.get(0);
    }

    public List<AticDevice> getAllDeviceWithLicense(long userId) {
        List objs;
        StringBuffer hql = new StringBuffer("SELECT a FROM AticDevice a LEFT JOIN LicenseInfoDb l ON a.moId = l.ddosDeviceId");
        if (userId > 1L) {
            hql.append(" LEFT JOIN UserRelMoInfo userRelMo ON a.moId = userRelMo.id.moId");
        }
        hql.append(" WHERE l.ddosDeviceId is not null");
        if (userId > 1L) {
            hql.append(" AND userRelMo.id.userId = ?0");
            hql.append(" GROUP BY a.moId");
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (userId > 1L) {
            param.put(0, userId + "");
        }
        if (null == (objs = this.findByHql(hql.toString(), param))) {
            return new ArrayList<AticDevice>();
        }
        return objs;
    }
}

