/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.resource.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.huawei.atic.device.model.Vpn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class VpnDao
extends CommonDaoImpl {
    public int deleteByMoid(long moId) {
        String hql = "delete from Vpn where moid = ?0 ";
        return this.getHibernateTemplate().bulkUpdate(hql, new Object[]{moId});
    }

    public List<Vpn> getVpnListByMoId(long moId) {
        String hql = "from Vpn where moid = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(moId));
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<Vpn>();
        }
        return result;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String vpnName;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from Vpn where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String moId = conditionMap.get("moId");
        if (!AticUtil.isNull((String)moId)) {
            hql = hql + " and moId = ?" + index;
            queryMap.put(index++, moId);
        }
        if (!AticUtil.isNullForVpn((String)(vpnName = conditionMap.get("vpnName")))) {
            hql = hql + " and lower(vpnName) like ?" + index;
            queryMap.put(index, "%" + vpnName.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public boolean isVpnExist(long deviceId, String vpnName) {
        String hql = "from Vpn where moid = ?0 and vpnName = ?1";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(deviceId));
        queryMap.put(1, vpnName);
        List vpnList = this.findByHql(hql, queryMap);
        return vpnList == null ? false : !vpnList.isEmpty();
    }
}

