/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.atic.sdk.util.AticSdkConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.common.snmp.SnmpParameter;
import com.huawei.atic.common.snmp.SnmpUtil;
import com.huawei.atic.device.license.service.ILicenseManagementService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.device.model.AticDeviceNexthop;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.device.model.AticDeviceRouter;
import com.huawei.atic.device.model.Interface;
import com.huawei.atic.device.model.Vpn;
import com.huawei.atic.parents.servcice.IFWDefenceAbnormalParentService;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.sdk.bis.form.VpnForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaRouterDao;
import com.huawei.atic.secne.resource.dao.AticDeviceRouterDao;
import com.huawei.atic.secne.resource.dao.InterfaceDao;
import com.huawei.atic.secne.resource.dao.VpnDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.FtpPara;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.south.sdk.constant.ProtocolConstant;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.struts2.ServletActionContext;
import org.snmp4j.util.TableEvent;

public class AticDeviceServiceImpl
implements IAticDeviceService {
    private static final int DEVICE_OFFLINE = -1;
    private static transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final List<Integer> IFTYPE_LIST = new ArrayList<Integer>();
    private AticDeviceDao aticDeviceDao;
    private IResourceService resourceService;
    private VpnDao vpnDao;
    private InterfaceDao interfaceDao;
    private IFWDefenceAbnormalParentService abnormalDfnService;
    private AticDeviceNfaRouterDao aticDeviceNfaRouterDao;
    private AticDeviceRouterDao aticDeviceRouterDao;
    private AticDeviceNfaClusterDao aticDeviceNfaClusterDao;
    private ILicenseManagementService licenseManagementServiceImpl;
    private IMessageCenter messageCenter = null;
    private IUserMgr userMgr;
    private IClusterService clusterService;

    @Override
    public List<AticDevice> setStatusToAticDevice(List<AticDevice> aticDeviceList) {
        ArrayList<AticDevice> setStatusAticList = new ArrayList<AticDevice>();
        for (AticDevice aticDevice : aticDeviceList) {
            aticDevice.setStatus(this.getStatusByMoid(aticDevice.getMoId()));
            setStatusAticList.add(aticDevice);
        }
        return setStatusAticList;
    }

    @Override
    public void saveOrUpdate(AticDevice aticDevice) {
        this.aticDeviceDao.saveOrUpdate(aticDevice);
        logger.info((Object)"update AticDevice info success");
    }

    @Override
    public Long getMoidByIP(String ipAddress) {
        ManagedObject mo = this.resourceService.getMoByIp(ipAddress);
        if (mo != null) {
            return mo.getMoId();
        }
        return null;
    }

    @Override
    public AticDevice getDeviceByMoid(long moid) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        if (null == aticDevice) {
            return null;
        }
        aticDevice.setStatus(this.getStatusByMoid(moid));
        return aticDevice;
    }

    @Override
    public int getStatusByMoid(long moid) {
        ManagedObject mo = this.resourceService.getMoByMoId(moid, true);
        if (null == mo) {
            return -1;
        }
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        if (null != aticDevice && 1 != aticDevice.getDeviceType() && 6 != aticDevice.getDeviceType() && 8 != aticDevice.getDeviceType()) {
            return -2;
        }
        return mo.getStatus();
    }

    @Override
    public void updateMOName(long moid, String name) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        ManagedObject mo = this.resourceService.getMoByMoId(moid, true);
        if (aticDevice != null) {
            aticDevice.setName(name);
            this.aticDeviceDao.saveOrUpdate(aticDevice);
            logger.info((Object)"update MOName(at AticDevice) success");
        }
        if (mo != null) {
            mo.setName(name);
            if (mo.getStatus() == null) {
                mo.setStatus(Integer.valueOf(0));
            }
            this.resourceService.updateMo(mo);
            logger.info((Object)"update MOName(at ManagedObject) success");
        }
    }

    @Override
    public SnmpPara getDeviceSnmpPara(long moid) {
        SnmpPara snmpPara = null;
        Node node = this.resourceService.getDeviceDetailInfo(moid);
        if (node != null) {
            snmpPara = (SnmpPara)node.getManagementProtocol(ProtocolConstant.SNMP_PARA);
        }
        return snmpPara;
    }

    @Override
    public TelnetPara getDeviceTelnetPara(long moid) {
        TelnetPara telnetPara = null;
        Node node = this.resourceService.getDeviceDetailInfo(moid);
        if (node != null) {
            telnetPara = (TelnetPara)node.getManagementProtocol(ProtocolConstant.TELNET_PARA);
            telnetPara.setHostKey(this.getDeviceByIp(node.getIpAddress()).getSshPublicKey());
        }
        return telnetPara;
    }

    @Override
    public AticDevice getDeviceByIp(String ip) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByIp(ip);
        if (null == aticDevice) {
            return null;
        }
        aticDevice.setStatus(this.getStatusByMoid(aticDevice.getMoId()));
        return aticDevice;
    }

    @Override
    public Paging getDeviceByPage(String nameOrIp, int start, int pageSize, long userId) {
        Paging page = this.aticDeviceDao.queryDeviceByPage(nameOrIp, start, pageSize, userId, this.isAdminFromUserId(userId));
        List data = page.getData();
        if (null != data && !data.isEmpty()) {
            List<AticDevice> list = this.setStatusToAticDevice(data);
            page.setData(list);
        }
        return page;
    }

    @Override
    public Paging getDeviceByPage(String nameOrIp, int start, int pageSize) {
        Paging page = this.aticDeviceDao.queryDeviceByPage(nameOrIp, start, pageSize, 0L, true);
        List data = page.getData();
        if (null != data && !data.isEmpty()) {
            List<AticDevice> list = this.setStatusToAticDevice(data);
            page.setData(list);
        }
        return page;
    }

    @Override
    public Paging getDeviceByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging page = this.aticDeviceDao.queryDeviceByPage(conditionMap, start, pageSize);
        List data = page.getData();
        page.setData(data);
        if (null != data && !data.isEmpty()) {
            List<AticDevice> list = this.setStatusToAticDevice(data);
            page.setData(list);
        }
        return page;
    }

    @Override
    public List<AticDevice> getAllDevice() {
        List<AticDevice> list = this.aticDeviceDao.getAllDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNfa2000VByIds(List<Long> moidList) {
        return this.aticDeviceDao.getNfa2000VByIds(moidList);
    }

    @Override
    public List<AticDevice> getAllNfa2000VCluster() {
        return this.aticDeviceDao.getAllNfa2000VCluster();
    }

    @Override
    public List<AticDevice> getAllSysLog() {
        return this.aticDeviceDao.getAllSysLog();
    }

    @Override
    public List<AticDevice> getAllAntiDDoS1820N() {
        return this.aticDeviceDao.getAllAntiDDoS1820N();
    }

    @Override
    public List<AticDevice> getAllDevice(long userId, boolean isAdmin) {
        List<AticDevice> list = this.aticDeviceDao.getAllDevice(userId, isAdmin);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getCleanDevice() {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(0, 0L, true);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getDetectDevice() {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(1, 0L, true);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getCleanDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(0, userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getDetectDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(1, userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getAntiDDoSDevice() {
        List<AticDevice> list = this.aticDeviceDao.getAntiDDoSDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getAntiDDoSDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getAntiDDoSDevice(userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNFA2000VDevice() {
        List<AticDevice> list = this.aticDeviceDao.getNFA2000VDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNFA2000VDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getNFA2000VDevice(userId, true);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNFA2000VDevicePrivilege(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getNFA2000VDevice(userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getSyslogDevice() {
        List<AticDevice> list = this.aticDeviceDao.getSyslogDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getSyslogDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getSyslogDevice(userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    private boolean isAdminFromUserId(long userId) {
        User user = this.userMgr.getUserInfo(userId);
        String isAdmin = "";
        if (null != user) {
            isAdmin = user.getIsAdmin();
        }
        return isAdmin.equalsIgnoreCase("true");
    }

    @Override
    public List<BatchOperation> deleteDevice(List<Long> moidList) {
        this.deleteCommandOnCluster(moidList);
        ArrayList<AticDeviceForm> aticDeviceList = new ArrayList<AticDeviceForm>();
        for (long moid : moidList) {
            AticDeviceForm deviceForm = new AticDeviceForm();
            AticDevice aticDevice = this.getDeviceByMoid(moid);
            AticUtil.copyProperties((Object)aticDevice, (Object)deviceForm);
            aticDeviceList.add(deviceForm);
        }
        this.sendMsgDeleteDevices(aticDeviceList);
        List<BatchOperation> operations = this.deleteCollectorFormDevice(moidList);
        logger.info((Object)"call defendGroupService.respondMsgDelDevice()");
        IDefendGroupService defendGroupService = (IDefendGroupService)ServiceContext.getInstance().getService("defendGroupService", IDefendGroupService.class);
        defendGroupService.respondMsgDelDevice(moidList);
        for (long moid : moidList) {
            this.vpnDao.deleteByMoid(moid);
            this.interfaceDao.deleteByDeviceId(moid);
            AticDevice secNe = this.aticDeviceDao.getDeviceByMoid(moid);
            if (null != secNe) {
                if (6 == secNe.getDeviceType()) {
                    this.aticDeviceRouterDao.deleteByMoid(moid);
                }
                if (8 == secNe.getDeviceType()) {
                    this.aticDeviceNfaRouterDao.deleteByNfaId(moid);
                }
                if (9 == secNe.getDeviceType()) {
                    this.aticDeviceNfaClusterDao.deleteClusterByClusterId(moid);
                }
            }
            this.aticDeviceDao.deleteDeviceByMoid(moid);
        }
        return operations;
    }

    private void deleteCommandOnCluster(List<Long> idList) {
        for (Long id : idList) {
            List<AticDevice> nfaList;
            AticDevice aticDevice = this.getDeviceByMoid(id);
            if (9 != aticDevice.getDeviceType() || null == (nfaList = this.clusterService.getDeviceListByVirtualId(aticDevice.getMoId()))) continue;
            this.deployDeleteCommand(nfaList);
        }
    }

    private void deployDeleteCommand(List<AticDevice> aticDeviceList) {
        logger.info((Object)("deployDeleteCommand aticDeviceList " + aticDeviceList.size()));
        for (AticDevice aticDevice : aticDeviceList) {
            this.deployUndoAntiDDoS1820NClusterInfo(aticDevice);
        }
    }

    private List<BatchOperation> deleteCollectorFormDevice(List<Long> moidList) {
        ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
        ICollectorDeviceService collectorDeviceService = (ICollectorDeviceService)ServiceContext.getInstance().getService("collectorDeviceService", ICollectorDeviceService.class);
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        for (Long moid : moidList) {
            Object operation;
            String collectorIp;
            Long collectorId;
            ArrayList<String> cmds;
            logger.info((Object)"undo device config: ");
            AticDevice device = null;
            device = this.getDeviceByMoid(moid);
            logger.info((Object)("firewall id:" + moid + "; name:" + device.getName()));
            if (device.getDeviceType() == 1) {
                cmds = new ArrayList<String>();
                cmds.add("system-view");
                cmds.add("undo firewall ddos log-local-ip");
                collectorId = collectorDeviceService.getCollectorIdByDevId(moid);
                if (null != collectorId && (collectorIp = collectorService.getCollectorInfo(collectorId).getIpAddress()) != null) {
                    cmds.add("undo firewall ddos log-server-ip " + collectorIp);
                    cmds.add("undo info-center loghost " + collectorIp);
                }
                cmds.add("undo ddos-zone all");
                cmds.add("y");
                cmds.add("undo anti-ddos filter all");
                cmds.add("y");
                cmds.add("undo ddos-zone default enable");
                cmds.add("undo firewall defend fraggle enable");
                cmds.add("undo firewall defend icmp-redirect enable");
                cmds.add("undo firewall defend icmp-unreachable enable");
                cmds.add("undo firewall defend land enable");
                cmds.add("undo firewall defend large-icmp max-length");
                cmds.add("undo firewall defend large-icmp enable");
                cmds.add("undo firewall defend ping-of-death enable");
                cmds.add("undo firewall defend route-record enable");
                cmds.add("undo firewall defend smurf enable");
                cmds.add("undo firewall defend source-route enable");
                cmds.add("undo firewall defend tcp-flag enable");
                cmds.add("undo firewall defend teardrop enable");
                cmds.add("undo firewall defend time-stamp enable");
                cmds.add("undo firewall defend tracert enable");
                cmds.add("undo firewall defend winnuke enable");
                cmds.add("undo anti-ddos large-udp max-length");
                cmds.add("undo anti-ddos large-udp enable");
                cmds.add("undo anti-ddos http-flood host-filter all");
                cmds.add("anti-ddos packet-capture length header");
                cmds.add("anti-ddos automatic-defense enable");
                try {
                    this.execCmd(cmds, moid);
                    cmds.clear();
                    cmds.add("system-view");
                    cmds.add("undo firewall ddos traffic-diversion ip all");
                    cmds.add("y");
                    this.execNoResultCmd(cmds, moid);
                    cmds.clear();
                    cmds.add("system-view");
                    cmds.add("undo firewall ddos traffic-diversion ipv6 all");
                    cmds.add("y");
                    this.execNoResultCmd(cmds, moid);
                    cmds.clear();
                    cmds.add("system-view");
                    cmds.add("undo anti-ddos blacklist-item ip all");
                    cmds.add("y");
                    this.execNoResultCmd(cmds, moid);
                    cmds.clear();
                    cmds.add("system-view");
                    cmds.add("undo anti-ddos blacklist-item ipv6 all");
                    cmds.add("y");
                    this.execNoResultCmd(cmds, moid);
                    cmds.clear();
                    cmds.add("system-view");
                    cmds.add("undo anti-ddos bypass-item ip all");
                    cmds.add("y");
                    this.execNoResultCmd(cmds, moid);
                    cmds.clear();
                    cmds.add("system-view");
                    cmds.add("undo anti-ddos bypass-item ipv6 all");
                    cmds.add("y");
                    this.execNoResultCmd(cmds, moid);
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)("The device is offline or telnet is, deviceMoId =" + moid + ". " + e.getMessage()));
                    if (e.getErrorCode() != 660050L) continue;
                    operation = new BatchOperation();
                    operation.setErrorCode(660085L);
                    operation.setTargetName(device.getName());
                    operation.setTargetId(moid.longValue());
                    operations.add((BatchOperation)operation);
                }
                continue;
            }
            if (device.getDeviceType() != 8 && device.getDeviceType() != 9) continue;
            cmds = new ArrayList();
            cmds.add("system-view");
            cmds.add("undo firewall ddos log-local-ip");
            collectorId = collectorDeviceService.getCollectorIdByDevId(moid);
            if (null != collectorId && (collectorIp = collectorService.getCollectorInfo(collectorId).getIpAddress()) != null) {
                cmds.add("undo firewall ddos log-server-ip " + collectorIp);
                cmds.add("undo info-center loghost " + collectorIp);
            }
            try {
                cmds.add("undo ddos-zone all");
                cmds.add("y");
                cmds.add("undo anti-ddos filter all");
                cmds.add("y");
                cmds.add("undo ddos-zone default enable");
                if (device.getDeviceType() == 9) {
                    List<AticDeviceNfaCluster> deviceCluster = this.clusterService.getBindNfaDevice(device.getMoId());
                    for (AticDeviceNfaCluster aticDeviceNfaCluster : deviceCluster) {
                        this.execCmd(cmds, aticDeviceNfaCluster.getDeviceId());
                    }
                    continue;
                }
                this.execCmd(cmds, moid);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId =" + moid + ". " + e.getMessage()));
                if (e.getErrorCode() == 660050L) {
                    operation = new BatchOperation();
                    operation.setErrorCode(660085L);
                    operation.setTargetName(device.getName());
                    operation.setTargetId(moid.longValue());
                    operations.add((BatchOperation)operation);
                    continue;
                }
                if (e.getErrorCode() != 514L) continue;
                operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(device.getName());
                operation.setTargetId(moid.longValue());
                operations.add((BatchOperation)operation);
            }
        }
        logger.info((Object)"call collectorDeviceService.respondMsgDelDevice()");
        collectorDeviceService.respondMsgDelDevice(moidList);
        logger.info((Object)"leave deleteDevice");
        return operations;
    }

    private void sendMsgDeleteDevices(List<AticDeviceForm> deviceList) {
        logger.info((Object)("will send COMMAND_RES_DEL msg, msg body is : " + deviceList));
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(116L);
        mu.setObj(deviceList);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        this.messageCenter.sendMessage(mu);
    }

    @Override
    public long discoveryDevice(long moid, int deviceType, String version, String sshPublicKey, String logPwd, Map<String, String> params) {
        long errorCode = 0L;
        Node node = this.resourceService.getDeviceDetailInfo(moid);
        if (node == null) {
            return 660045L;
        }
        try {
            if (deviceType == 1) {
                AticDevice device = this.createAticDeviceFromNode(node, 1, version, sshPublicKey, logPwd);
                if (null == this.abnormalDfnService) {
                    this.abnormalDfnService = (IFWDefenceAbnormalParentService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalParentService.class);
                }
                this.abnormalDfnService.createByDeviceId(moid);
                this.syncCpuAndDdosType(device);
                this.syncVpnInfo(device);
                this.syncIfInfo(device);
                this.synSpuSlot(device);
                this.synEsn(device);
                this.syncLicenseAntiDDoS(device, params);
                errorCode = this.configDeviceSyslogHost(device);
            } else if (deviceType == 3) {
                AticDevice device = new AticDevice();
                device.setMoId(moid);
                device.setDeviceType(deviceType);
                device.setDdosType(1);
                device.setIpAddress(node.getIpAddress());
                device.setName(node.getName());
                device.setVersion("");
                device.setDeviceModel("Syslog");
                this.aticDeviceDao.saveOrUpdate(device);
            } else if (deviceType == 6) {
                AticDevice device = new AticDevice();
                device.setMoId(moid);
                device.setDeviceType(deviceType);
                device.setDdosType(3);
                device.setIpAddress(node.getIpAddress());
                device.setName(node.getName());
                device.setVersion("");
                device.setDeviceModel("Router");
                this.aticDeviceDao.saveOrUpdate(device);
                this.syncIfInfo(device);
            } else if (deviceType == 8) {
                AticDevice device = this.createAticDeviceFromNode(node, 8, version, sshPublicKey, logPwd);
                this.syncCpuAndDdosType(device);
                this.syncIfInfo(device);
                this.synSpuSlot(device);
                errorCode = this.configDeviceSyslogHost(device);
            } else if (deviceType == 9) {
                AticDevice device = new AticDevice();
                device.setMoId(moid);
                device.setDeviceType(deviceType);
                device.setDdosType(1);
                device.setIpAddress(node.getIpAddress());
                device.setName(node.getName());
                device.setVersion("");
                device.setDeviceModel("AntiDDoS1820-N Cluster");
                device.setLogPwd(logPwd);
                this.aticDeviceDao.saveOrUpdate(device);
            }
        }
        catch (LegoCheckedException e) {
            errorCode = e.getErrorCode();
        }
        return errorCode;
    }

    private void synEsn(AticDevice device) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display esn");
        List<String> result = this.execCmd(cmdList, device.getMoId());
        if (result != null && !result.isEmpty()) {
            String[] resultArray = result.get(0).split("\r\n");
            String deviceEsn = "";
            for (int i = 0; i < resultArray.length; ++i) {
                if (!resultArray[i].contains("ESN of master:")) continue;
                deviceEsn = resultArray[i].replace("ESN of master:", "").trim();
            }
            device.setDeviceEsn(deviceEsn);
            this.aticDeviceDao.saveOrUpdate(device);
        }
    }

    private AticDevice createAticDeviceFromNode(Node node, int deviceType, String version, String sshPublicKey, String logPwd) {
        AticDevice device = new AticDevice();
        device.setMoId(node.getMoId());
        device.setIpAddress(node.getIpAddress());
        device.setDeviceType(deviceType);
        device.setName(node.getName());
        if (1 == deviceType) {
            String[] deviceInfo = this.analyseSysDesc(node.getSysDescr());
            if (deviceInfo != null) {
                device.setDeviceModel(deviceInfo[0]);
                device.setVersion(deviceInfo[1]);
            }
            if (AticUtil.isNull((String)version)) {
                version = device.getIpAddress();
            }
            device.setLogIp(version);
            if (!AticUtil.isNull((String)sshPublicKey)) {
                device.setSshPublicKey(sshPublicKey);
            }
            if (!AticUtil.isNull((String)logPwd)) {
                device.setLogPwd(logPwd);
            }
            if (CommonUtil.isNewDevice(device)) {
                device.setEncryptType(1);
            } else {
                device.setEncryptType(0);
            }
        } else if (8 == deviceType) {
            String[] deviceInfo = this.analyseSysDesc(node.getSysDescr());
            if (deviceInfo != null) {
                device.setDeviceModel("AntiDDoS1820-N");
                device.setVersion(deviceInfo[1]);
            }
            if (AticUtil.isNull((String)version)) {
                version = device.getIpAddress();
            }
            device.setLogIp(version);
            if (!AticUtil.isNull((String)sshPublicKey)) {
                device.setSshPublicKey(sshPublicKey);
            }
            if (!AticUtil.isNull((String)logPwd)) {
                device.setLogPwd(logPwd);
            }
            if (CommonUtil.isNewDevice(device)) {
                device.setEncryptType(1);
            } else {
                device.setEncryptType(0);
            }
        }
        this.aticDeviceDao.saveOrUpdate(device);
        return device;
    }

    private String[] analyseSysDesc(String sysDesc) {
        String[] result = null;
        String regEx = ".+(AntiDDoS\\d+V?).* (V\\d+R\\d+C\\w+).*";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(sysDesc);
        if (mat.find()) {
            result = new String[]{mat.group(1), mat.group(2)};
        }
        return result;
    }

    private void syncLicenseAntiDDoS(AticDevice device, Map<String, String> params) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display license");
        List<String> result = this.execCmd(cmdList, device.getMoId());
        this.licenseManagementServiceImpl.syncLicenseInfo(device.getMoId(), result, params);
    }

    private void syncCpuAndDdosType(AticDevice device) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display ddos slot");
        List<String> result = this.execCmd(cmdList, device.getMoId());
        if (result != null && !result.isEmpty()) {
            String[] resultArray = result.get(0).split("\r\n");
            int begin = 0;
            int end = 0;
            boolean statisticsByCPU = false;
            int cpuNumberIndex = 1;
            for (int i = 0; i < resultArray.length; ++i) {
                if (cpuNumberIndex == 1 && resultArray[i].toLowerCase(Locale.getDefault()).contains("card")) {
                    cpuNumberIndex = 2;
                }
                if (resultArray[i].toLowerCase(Locale.getDefault()).contains("cpu id")) {
                    statisticsByCPU = true;
                }
                if (!resultArray[i].contains("-------")) continue;
                if (begin == 0) {
                    begin = i + 1;
                    continue;
                }
                end = i - 1;
                break;
            }
            int ddosType = 0;
            int cpuNumber = 0;
            int cpuCleanNum = 0;
            int cpuDetectNum = 0;
            if (statisticsByCPU) {
                for (int i = begin; i <= end; ++i) {
                    ++cpuNumber;
                    if (this.isRegistered(resultArray[i]) && resultArray[i].toLowerCase(Locale.getDefault()).endsWith("clean")) {
                        ++cpuCleanNum;
                        continue;
                    }
                    if (!this.isRegistered(resultArray[i]) || !resultArray[i].toLowerCase(Locale.getDefault()).endsWith("detect")) continue;
                    ++cpuDetectNum;
                }
            } else {
                for (int i = begin; i <= end; ++i) {
                    String[] temp = resultArray[i].trim().split("\\s+");
                    try {
                        cpuNumber += Integer.parseInt(temp[cpuNumberIndex].trim());
                    }
                    catch (NumberFormatException e) {
                        logger.info((Object)("parse integer failed. temp[cpuNumberIndex]:" + temp[cpuNumberIndex].trim()));
                        throw new LegoCheckedException(660078L, (Throwable)e);
                    }
                    if (this.isRegistered(resultArray[i]) && resultArray[i].toLowerCase(Locale.getDefault()).endsWith("clean")) {
                        cpuCleanNum += Integer.parseInt(temp[cpuNumberIndex].trim());
                        continue;
                    }
                    if (!this.isRegistered(resultArray[i]) || !resultArray[i].toLowerCase(Locale.getDefault()).endsWith("detect")) continue;
                    cpuDetectNum += Integer.parseInt(temp[cpuNumberIndex].trim());
                }
            }
            int n = cpuNumber = cpuNumber == 0 ? 1 : cpuNumber;
            ddosType = cpuCleanNum > 0 && cpuDetectNum > 0 ? 2 : (cpuCleanNum > 0 ? 0 : (cpuDetectNum > 0 ? 1 : 3));
            device.setCpuNumber(cpuNumber);
            device.setDdosType(ddosType);
            device.setCleanCpuNumber(cpuCleanNum);
            device.setDetectCpuNumber(cpuDetectNum);
        }
        this.aticDeviceDao.saveOrUpdate(device);
    }

    private boolean isRegistered(String str) {
        if (str.toLowerCase(Locale.getDefault()).contains("registered")) {
            return !str.toLowerCase(Locale.getDefault()).contains("unload");
        }
        return false;
    }

    private void syncVpnInfo(AticDevice device) {
        List<String> nameList = this.getVpnListFromDevice(device.getMoId());
        HashSet<Vpn> set = new HashSet<Vpn>();
        for (String name : nameList) {
            Vpn vpn = new Vpn();
            vpn.setMoid(device.getMoId());
            vpn.setVpnName(name);
            set.add(vpn);
        }
        IZoneDeviceService zoneDeviceService = (IZoneDeviceService)ServiceContext.getInstance().getService("zoneDeviceService", IZoneDeviceService.class);
        List<ZoneDeviceForm> zoneDeviceList = zoneDeviceService.getByDeviceId(device.getMoId());
        this.vpnDao.deleteByMoid(device.getMoId());
        if (!set.isEmpty()) {
            this.vpnDao.saveAll(set);
            for (ZoneDeviceForm form : zoneDeviceList) {
                if (!this.isExist(form.getVpnName(), set)) continue;
                zoneDeviceService.update(form);
            }
        }
    }

    private boolean isExist(String vpnName, Set<Vpn> set) {
        boolean exist = false;
        for (Vpn vpn : set) {
            if (null == vpnName || "".equals(vpnName.trim()) || !vpnName.equals(vpn.getVpnName())) continue;
            return true;
        }
        return exist;
    }

    private void syncVersion(AticDevice device) {
        String sysDescOid = "1.3.6.1.2.1.1.1.0";
        String sysDesc = this.snmpGet(sysDescOid, device.getMoId());
        if (sysDesc == null) {
            throw new LegoCheckedException(1037L);
        }
        String[] deviceInfo = this.analyseSysDesc(sysDesc);
        if (deviceInfo != null) {
            String deviceModel = this.snmpGet("1.3.6.1.2.1.1.2.0", device.getMoId());
            if ("AntiDDoS1800".equals(deviceInfo[0].trim())) {
                if ("1.3.6.1.4.1.2011.2.321.1.185".equals(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS1880";
                } else if ("1.3.6.1.4.1.2011.2.321.1.184".equals(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS1820";
                } else if ("1.3.6.1.4.1.2011.2.321.1.196".equals(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS1820-N";
                } else if ("1.3.6.1.4.1.2011.2.321.1.225".equals(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS1825";
                }
            } else if ("AntiDDoS12000".equals(deviceInfo[0].trim())) {
                if ("1.3.6.1.4.1.2011.2.321.1.249,1.3.6.1.4.1.2011.2.321.1.250".contains(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS12008";
                } else if ("1.3.6.1.4.1.2011.2.321.1.247,1.3.6.1.4.1.2011.2.321.1.248".contains(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS12004";
                }
            }
            device.setDeviceModel(deviceInfo[0]);
            device.setVersion(deviceInfo[1]);
            this.aticDeviceDao.saveOrUpdate(device);
        }
    }

    private void syncIfInfo(AticDevice device) {
        String[] snmpOids = new String[]{"1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.3", "1.3.6.1.2.1.2.2.1.5", "1.3.6.1.2.1.2.2.1.8"};
        SnmpPara snmpPara = this.getDeviceSnmpPara(device.getMoId());
        boolean resultSnmp = this.testSnmp(device.getIpAddress(), snmpPara);
        if (resultSnmp) {
            List<String[]> snmpResult = this.snmpGetTable(snmpOids, device.getMoId());
            if (!snmpResult.isEmpty()) {
                HashSet<Interface> ifSet = new HashSet<Interface>();
                for (String[] row : snmpResult) {
                    int ifType = Integer.parseInt(row[2]);
                    String ifDescr = row[1];
                    if (!IFTYPE_LIST.contains(ifType)) continue;
                    Interface devIf = new Interface();
                    devIf.setDeviceId(device.getMoId());
                    devIf.setIfIndex(Integer.parseInt(row[0]));
                    devIf.setIfDescr(ifDescr);
                    devIf.setIfType(ifType);
                    devIf.setIfSpeed(Long.parseLong(row[3]));
                    devIf.setIfAdminStatus(1);
                    devIf.setIfOperStatus(Integer.parseInt(row[4]));
                    ifSet.add(devIf);
                }
                this.interfaceDao.deleteByDeviceId(device.getMoId());
                this.interfaceDao.saveAll(ifSet);
            }
        } else {
            throw new LegoCheckedException(660079L);
        }
    }

    @Override
    public void syncDeviceList(List<Long> moidList) {
        for (int i = 0; i < moidList.size(); ++i) {
            AticDevice device = this.aticDeviceDao.getDeviceByMoid(moidList.get(i));
            if (device != null && device.getDeviceType() == 1) {
                this.syncAntiDDoSDevice(device);
                continue;
            }
            if (device != null && device.getDeviceType() == 8) {
                this.syncAntiDDoSDevice(device);
                continue;
            }
            if (device == null || device.getDeviceType() != 6) continue;
            this.syncIfInfo(device);
            this.aticDeviceDao.update(device);
        }
    }

    private void syncAntiDDoSDevice(AticDevice device) {
        this.syncVersion(device);
        this.syncCpuAndDdosType(device);
        this.sysnEncryptType(device);
        this.synSpuSlot(device);
        this.syncVpnInfo(device);
        this.syncIfInfo(device);
        this.synEsn(device);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scheme", ServletActionContext.getRequest().getScheme());
        params.put("port", String.valueOf(ServletActionContext.getRequest().getServerPort()));
        this.syncLicenseAntiDDoS(device, params);
        this.configDeviceSyslogHost(device);
    }

    private long configDeviceSyslogHost(AticDevice device) {
        String hostName = System.getProperty("nms.server.host");
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.clear();
        cmdList.add("system");
        if (1 == AticInstallUtil.getInstance().getAticInstallOS()) {
            cmdList.add("info-center loghost " + hostName + " port 3514");
        } else if (0 == AticInstallUtil.getInstance().getAticInstallOS()) {
            cmdList.add("info-center loghost " + hostName);
        }
        logger.info((Object)("cmd = " + cmdList.toString()));
        List<String> resultStr = this.execCmd(cmdList, device.getMoId());
        if (null != resultStr && !resultStr.isEmpty()) {
            for (String result : resultStr) {
                if (!result.contains("Error: Failed to open logging host, the logging host list is full.")) continue;
                return 1L;
            }
        }
        return 0L;
    }

    private void sysnEncryptType(AticDevice device) {
        if (!CommonUtil.isNewDevice(device)) {
            device.setEncryptType(0);
        } else if (0 != device.getEncryptType()) {
            device.setEncryptType(device.getEncryptType());
        } else {
            device.setEncryptType(1);
        }
    }

    private void synSpuSlot(AticDevice device) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display device");
        List<String> result = this.execCmd(cmdList, device.getMoId());
        if (result != null && !result.isEmpty()) {
            String[] resultArray = result.get(0).split("\r\n");
            int begin = 0;
            for (int i = 0; i < resultArray.length; ++i) {
                if (!resultArray[i].contains("- - - - - - - - - - - -") || begin != 0) continue;
                begin = i + 1;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = begin; i < resultArray.length; ++i) {
                String[] temp;
                if (!resultArray[i].contains("SPU") || !"SPU".equals((temp = resultArray[i].trim().split("\\s+"))[1]) && !temp[2].toUpperCase().startsWith("SPUA")) continue;
                sb = sb.append(temp[0]).append(",");
            }
            device.setSpuSlot(sb.toString());
            this.aticDeviceDao.saveOrUpdate(device);
        }
    }

    private SnmpParameter createSnmpParameter(SnmpPara snmpPara) {
        if (snmpPara == null) {
            return null;
        }
        SnmpParameter snmpParameter = new SnmpParameter();
        snmpParameter.setAuthProtocol(snmpPara.getAuthProtocol());
        snmpParameter.setAuthPwd(snmpPara.getAuthPwd());
        snmpParameter.setContextEngineId(snmpPara.getContextEngineId());
        snmpParameter.setContextName(snmpPara.getContextName());
        snmpParameter.setIsSnmpTest(snmpPara.getIsSnmpTest());
        if (snmpPara.getNode() != null) {
            snmpParameter.setDeviceIp(snmpPara.getNode().getIpAddress());
        }
        snmpParameter.setEncryptProtocol(snmpPara.getEncryptProtocol());
        snmpParameter.setEncryptPwd(snmpPara.getEncryptPwd());
        snmpParameter.setPort(snmpPara.getPort());
        snmpParameter.setReadComm(snmpPara.getReadComm());
        snmpParameter.setRetries(snmpPara.getRetries());
        snmpParameter.setSecurityName(snmpPara.getSecurityName());
        snmpParameter.setTimeout(snmpPara.getTimeout());
        snmpParameter.setVersion(snmpPara.getVersion());
        return snmpParameter;
    }

    @Override
    public List<Interface> getIfNeedMonitor(long moid) {
        return this.interfaceDao.getInterfaceList(moid);
    }

    private String snmpGet(String oid, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            return SnmpUtil.snmpGet(snmpParameter, oid);
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public List<String> snmpGet(List<String> oidList, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            List<String> result = SnmpUtil.snmpGetList(snmpParameter, oidList);
            return result;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public List<String[]> snmpGetTable(String[] oids, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            List<String[]> result = SnmpUtil.snmpGetTable(snmpParameter, oids);
            return result;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public List<TableEvent> snmpGetTableOrigial(String[] oids, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            snmpParameter.setRetries(1);
            List<TableEvent> result = SnmpUtil.snmpGetTableOrigial(snmpParameter, oids);
            return result;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public boolean testTelnet(String ipAddress, TelnetPara telnetPara) {
        boolean result = false;
        try {
            result = this.resourceService.isTelnetReachable(ipAddress, telnetPara);
        }
        catch (LegoCheckedException e) {
            logger.info((Object)("SecNeServiceImpl->@testTelnetProtocol:" + e.getMessage()));
            if (e.getErrorCode() == 517L) {
                if (telnetPara.getProtocolType() != 0) {
                    throw new LegoCheckedException(660051L, (Throwable)e);
                }
                throw new LegoCheckedException(660050L, (Throwable)e);
            }
            if (e.getErrorCode() == 527L) {
                throw new LegoCheckedException(660051L, (Throwable)e);
            }
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception ex) {
            logger.info((Object)("SecNeServiceImpl->@testTelnetProtocol:" + ex.getMessage()));
        }
        return result;
    }

    @Override
    public boolean testFtp(AticDevice aticDevice) {
        boolean result;
        block2: {
            result = false;
            FtpPara ftpPara = new FtpPara();
            try {
                ftpPara.setProtocol(aticDevice.getFtpType());
                ftpPara.setPort(aticDevice.getFtpPort());
                ftpPara.setUserName(aticDevice.getFtpUser());
                ftpPara.setFtpPassWord(aticDevice.getFtpPassword());
                ftpPara.setServiceIp(aticDevice.getIpAddress());
                ftpPara.setHostKey(aticDevice.getSshPublicKey());
                result = this.resourceService.isFtpReachable(ftpPara);
            }
            catch (Exception ex) {
                long code;
                logger.info((Object)("SecNeServiceImpl->@testFtpProtocol:" + ex.getMessage()));
                if (!(ex instanceof LegoCheckedException) || (code = ((LegoCheckedException)((Object)ex)).getErrorCode()) != 571904L) break block2;
                throw new LegoCheckedException(571904L);
            }
        }
        return result;
    }

    @Override
    public boolean testSnmp(String ipAddress, SnmpPara snmpPara) {
        try {
            String testOid = "1.3.6.1.2.1.1.3.0";
            SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
            snmpParameter.setDeviceIp(ipAddress);
            String sysUpTime = SnmpUtil.snmpGet(snmpParameter, testOid);
            return sysUpTime != null;
        }
        catch (Exception ex) {
            logger.info((Object)("SecNeServiceImpl->@testSNMPProtocol:" + ex.getMessage()));
            return false;
        }
    }

    @Override
    public String testSnmpOid(String ipAddress, SnmpPara snmpPara, String oid) {
        try {
            SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
            snmpParameter.setDeviceIp(ipAddress);
            return SnmpUtil.snmpGet(snmpParameter, oid);
        }
        catch (Exception ex) {
            logger.error((Object)("SecNeServiceImpl.testSnmpOid()--->>>" + ex.getMessage()));
            return null;
        }
    }

    @Override
    public boolean checkMOName(String name, long moId) {
        return this.aticDeviceDao.checkMoName4Edit(name, moId);
    }

    @Override
    public boolean checkMOName(String name) {
        return this.aticDeviceDao.checkMoName4Add(name);
    }

    @Override
    public boolean checkIpAddress(String devIp) {
        return this.aticDeviceDao.checkMoIPAdd(devIp);
    }

    @Override
    public List<String> getVpnListFromDevice(long moid) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display ip vpn-instance");
        List<String> result = this.execCmd(cmdList, moid);
        if (result != null && !result.isEmpty()) {
            String[] resultArray = result.get(0).split("\r\n");
            int begin = -1;
            for (int i = 0; i < resultArray.length; ++i) {
                if (!resultArray[i].trim().startsWith("VPN-Instance Name")) continue;
                begin = i + 1;
                break;
            }
            if (begin > 0) {
                for (int i = begin; i < resultArray.length - 1; ++i) {
                    String[] temp = resultArray[i].trim().split("\\s+");
                    list.add(temp[0]);
                }
            }
        }
        return list;
    }

    @Override
    public List<String> getVpnListFromDB(long moid) {
        ArrayList<String> list = new ArrayList<String>();
        List<Vpn> vpnList = this.vpnDao.getVpnListByMoId(moid);
        list.add("");
        for (int i = 0; i < vpnList.size(); ++i) {
            list.add(vpnList.get(i).getVpnName());
        }
        return list;
    }

    @Override
    public Paging queryByPageVpnForm(long moid, String vpnName, int start, int pageSize) {
        ArrayList<VpnForm> listForm = new ArrayList<VpnForm>();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        conditionMap.put("moId", String.valueOf(moid));
        conditionMap.put("vpnName", String.valueOf(vpnName));
        Paging page = this.vpnDao.queryByPage(conditionMap, start, pageSize);
        if (page.getData() != null) {
            List listVpn = page.getData();
            for (Vpn vpn : listVpn) {
                VpnForm form = new VpnForm();
                form.setId(vpn.getId());
                form.setTopMoid(vpn.getMoid());
                form.setVname(vpn.getVpnName());
                listForm.add(form);
            }
            page.setData(listForm);
        }
        return page;
    }

    @Override
    public List<String> execCmd(List<String> cmds, long moid) {
        return this.execCmdWithRegex(cmds, moid, 0);
    }

    @Override
    public List<String> execCmdNoTransaction(List<String> cmds, long moid) {
        return this.execCmdWithRegexNoTransaction(cmds, moid, 0);
    }

    private void assembleFlowSrcCmd(List<String> cmdList, boolean isUndo, List<AticDeviceRouter> entityList) {
        for (int j = 0; j < entityList.size(); ++j) {
            String[] split;
            StringBuilder sb = new StringBuilder();
            if (isUndo) {
                sb.append("undo ");
            }
            sb.append("anti-ddos flow-src-info ");
            sb.append(entityList.get(j).getFlowSrcIp());
            if (!isUndo) {
                sb.append(" port ");
                sb.append(entityList.get(j).getFlowDstPort());
                sb.append(" aging-time ");
                sb.append(entityList.get(j).getAgeTime());
                sb.append(" sample-rate ");
                sb.append(entityList.get(j).getSampleRatio());
            }
            cmdList.add(sb.toString());
            if (null != entityList.get(j).getInbound()) {
                StringBuilder sb1 = new StringBuilder();
                if (isUndo) {
                    sb1.append("undo ");
                }
                sb1.append("anti-ddos flow-src-info ");
                sb1.append(entityList.get(j).getFlowSrcIp());
                sb1.append(" inbound-ifindex ");
                String inbound = entityList.get(j).getInbound();
                split = inbound.split(":");
                if (split.length == 2) {
                    sb1.append(split[1]);
                    cmdList.add(sb1.toString());
                }
            }
            if (null == entityList.get(j).getOutbound()) continue;
            StringBuffer sb2 = new StringBuffer();
            if (isUndo) {
                sb2.append("undo ");
            }
            sb2.append("anti-ddos flow-src-info ");
            sb2.append(entityList.get(j).getFlowSrcIp());
            sb2.append(" outbound-ifindex ");
            String outbound = entityList.get(j).getOutbound();
            split = outbound.split(":");
            if (split.length != 2) continue;
            sb2.append(split[1]);
            cmdList.add(sb2.toString());
        }
    }

    @Override
    public List<String> deployFlowSrc(boolean isUndo, Long moid, List<AticDeviceRouter> entityList) {
        List<String> resultStr = new ArrayList<String>();
        if (null != entityList && !entityList.isEmpty()) {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("system");
            this.assembleFlowSrcCmd(cmdList, isUndo, entityList);
            logger.info((Object)("deploy flowSrc cmdList :" + cmdList));
            resultStr = this.execCmd(cmdList, moid);
            logger.info((Object)("deploy flowSrc resultStr :" + resultStr));
        }
        return resultStr;
    }

    @Override
    public List<AticDevice> getAllDeviceWithLicense(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getAllDeviceWithLicense(userId);
        return list;
    }

    @Override
    public List<String> execCmd(List<String> cmds, long moid, int soTimeout) {
        return this.execCmdWithRegex(cmds, moid, soTimeout);
    }

    @Override
    public List<String> execCmdNoTransaction(List<String> cmds, long moid, int soTimeout) {
        return this.execCmdWithRegexNoTransaction(cmds, moid, soTimeout);
    }

    @Override
    public void execNoResultCmd(List<String> cmds, long moid) {
        this.execCmdWithRegex(cmds, moid, -1);
    }

    @Override
    public List<AticDevice> getDeviceByZoneId(long zoneId) {
        return this.aticDeviceDao.getDeviceByZoneId(zoneId);
    }

    @Override
    public List<AticDevice> getDeviceByZoneId(long zoneId, long userId) {
        return this.aticDeviceDao.getDeviceByZoneId(zoneId, userId);
    }

    private List<String> execCmdWithRegex(List<String> cmds, long moid, int soTimeout) {
        logger.warn((Object)"IN execCmdWithRegex");
        List<String> retCmdVal = null;
        ExcmdConnectUtil excmdConnectUtil = null;
        boolean isExeRerurn = true;
        TelnetPara telnetPara = this.getDeviceTelnetPara(moid);
        try {
            if (null != telnetPara) {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                retCmdVal = excmdConnectUtil.execCmdWithRegex(cmds, AticSdkConstants.REGEX_LIST, soTimeout, isExeRerurn);
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execCmdWithRegex,EXE CLI ERROR:" + e.getMessage()));
            throw e;
        }
        finally {
            if (null != telnetPara) {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(moid, excmdConnectUtil);
            }
        }
        logger.warn((Object)"OUT execCmdWithRegex");
        return retCmdVal;
    }

    private List<String> execCmdWithRegexNoTransaction(List<String> cmds, long moid, int soTimeout) {
        logger.warn((Object)"IN execCmdWithRegexNoTransaction");
        List<String> retCmdVal = null;
        ExcmdConnectUtil excmdConnectUtil = null;
        boolean isExeRerurn = true;
        TelnetPara telnetPara = this.getDeviceTelnetPara(moid);
        try {
            if (null != telnetPara) {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                retCmdVal = excmdConnectUtil.execCmdWithRegex(cmds, AticSdkConstants.REGEX_LIST, soTimeout, isExeRerurn);
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execCmdWithRegexNoTransaction,EXE CLI ERROR:" + e.getMessage()));
            throw e;
        }
        finally {
            if (null != telnetPara) {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(moid, excmdConnectUtil);
            }
        }
        logger.warn((Object)"OUT execCmdWithRegexNoTransaction");
        return retCmdVal;
    }

    @Override
    public List<AticDevice> getDeviceIdByDeviceName(String deviceName) {
        List<AticDevice> deviceList = this.aticDeviceDao.getDeviceIdByDeviceName(deviceName);
        if (!deviceList.isEmpty()) {
            return deviceList;
        }
        return null;
    }

    @Override
    public List<AticDevice> getAntiddosDevice(int ddosType, long userId, boolean isAdmin) {
        List<AticDevice> deviceList = this.aticDeviceDao.queryAntiddosDevice(ddosType, userId, isAdmin);
        if (!deviceList.isEmpty()) {
            return deviceList;
        }
        return null;
    }

    @Override
    public void refreshCard(AticDevice device) {
        this.synSpuSlot(device);
        this.syncIfInfo(device);
    }

    @Override
    public List<AticDevice> getNeedMonitorDevice() {
        List<AticDevice> list = this.aticDeviceDao.getNeedMonitDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getClusterAndNfa(long userId) {
        List<AticDevice> clusterList = this.aticDeviceDao.getClusterDevice(userId, this.isAdminFromUserId(userId));
        List<AticDevice> nfaList = this.getNFA2000VDevicePrivilege(userId);
        for (AticDevice temp : nfaList) {
            if (this.clusterService.isBelongCluster(temp.getMoId())) continue;
            clusterList.add(temp);
        }
        return clusterList;
    }

    @Override
    public List<AticDevice> queryCleanAllDevice() {
        return this.aticDeviceDao.queryDevice(0);
    }

    @Override
    public List<AticDevice> getClusterAndNfa() {
        List<AticDevice> clusterList = this.aticDeviceDao.getClusterDevice(0L, true);
        List<AticDevice> nfaList = this.getNFA2000VDevice(0L);
        for (AticDevice temp : nfaList) {
            if (this.clusterService.isBelongCluster(temp.getMoId())) continue;
            clusterList.add(temp);
        }
        return clusterList;
    }

    @Override
    public List<AticDevice> getDeviceListByClusterId(Long id) {
        return this.aticDeviceDao.queryDeviceListByClusterId(id);
    }

    @Override
    public List<AticDevice> getNfaAndRouteByPrivilege(long userId) {
        List<AticDevice> deviceList = this.aticDeviceDao.queryNfaAndRouteByPrivilege(userId, this.isAdminFromUserId(userId));
        List<Long> idList = this.aticDeviceNfaClusterDao.findAllDeviceId();
        ArrayList<AticDevice> clusterList = new ArrayList<AticDevice>();
        if (null != idList && 0 != idList.size()) {
            for (AticDevice aticDevice : deviceList) {
                if (!idList.contains(aticDevice.getMoId())) continue;
                clusterList.add(aticDevice);
            }
        }
        if (0 != clusterList.size()) {
            deviceList.removeAll(clusterList);
        }
        return deviceList;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setVpnDao(VpnDao vpnDao) {
        this.vpnDao = vpnDao;
    }

    public VpnDao getVpnDao() {
        return this.vpnDao;
    }

    public void setInterfaceDao(InterfaceDao interfaceDao) {
        this.interfaceDao = interfaceDao;
    }

    public InterfaceDao getInterfaceDao() {
        return this.interfaceDao;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public AticDeviceNfaRouterDao getAticDeviceNfaRouterDao() {
        return this.aticDeviceNfaRouterDao;
    }

    public void setAticDeviceNfaRouterDao(AticDeviceNfaRouterDao aticDeviceNfaRouterDao) {
        this.aticDeviceNfaRouterDao = aticDeviceNfaRouterDao;
    }

    public AticDeviceRouterDao getAticDeviceRouterDao() {
        return this.aticDeviceRouterDao;
    }

    public void setAticDeviceRouterDao(AticDeviceRouterDao aticDeviceRouterDao) {
        this.aticDeviceRouterDao = aticDeviceRouterDao;
    }

    public AticDeviceNfaClusterDao getAticDeviceNfaClusterDao() {
        return this.aticDeviceNfaClusterDao;
    }

    public void setAticDeviceNfaClusterDao(AticDeviceNfaClusterDao aticDeviceNfaClusterDao) {
        this.aticDeviceNfaClusterDao = aticDeviceNfaClusterDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public void saveNexthopIp(AticDeviceNexthop aticDeviceNexthop) {
        this.aticDeviceDao.saveOrUpdate(aticDeviceNexthop);
        logger.info((Object)"saveOrUpdate nexthopIp success");
    }

    @Override
    public AticDeviceNexthop getNexthopIpByMoid(long moid) {
        return this.aticDeviceDao.getNexthopIpByMoid(moid);
    }

    @Override
    public String getNexthopIpByDeviceIpAndCleanType(String deviceIp, String cleanType, boolean ipv4) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByIp(deviceIp);
        AticDeviceNexthop aticDeviceNexthop = null;
        String nextHop = "";
        if (null != aticDevice) {
            aticDeviceNexthop = this.aticDeviceDao.getNexthopIpByMoid(aticDevice.getMoId());
            nextHop = ipv4 && "JYQX".equals(cleanType) ? aticDeviceNexthop.getJyqxIp() : (ipv4 && "JMDQX".equals(cleanType) ? aticDeviceNexthop.getJmdqxIp() : (!ipv4 && "JYQX".equals(cleanType) ? aticDeviceNexthop.getJyqxIpv6() : aticDeviceNexthop.getJmdqxIpv6()));
        }
        return nextHop;
    }

    @Override
    public AticDeviceNexthop getNexthopIpByDeviceIpAndCleanType(String deviceIp, String cleanType) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByIp(deviceIp);
        AticDeviceNexthop aticDeviceNexthop = null;
        if (null != aticDevice) {
            aticDeviceNexthop = this.aticDeviceDao.getNexthopIpByMoid(aticDevice.getMoId());
        }
        return aticDeviceNexthop;
    }

    @Override
    public List<BatchOperation> undoAntiDDoS1820NClusterInfo(List<AticDevice> aticDeviceList, List<AticDevice> nfaDevs) {
        ArrayList<String> cmds;
        ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
        for (AticDevice device : aticDeviceList) {
            try {
                cmds = new ArrayList<String>();
                cmds.add("system-view");
                if (8 != device.getDeviceType()) continue;
                cmds.addAll(this.getUndoClusterCmd());
                this.execCmd(cmds, device.getMoId());
                logger.info((Object)("undo delete AntiDDoS1820NCluster info : " + ((Object)cmds).toString() + "device IP : " + device.getIpAddress()));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId =" + device.getMoId() + ". " + e.getMessage()));
                if (e.getErrorCode() != 660050L && e.getErrorCode() != 514L) continue;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(device.getName());
                operation.setTargetId(device.getMoId());
                operations.add(operation);
            }
        }
        for (AticDevice aticDevice : nfaDevs) {
            cmds = new ArrayList();
            cmds.add("system-view");
            for (AticDevice device : aticDeviceList) {
                if (aticDevice.getMoId() != device.getMoId()) {
                    if (8 == device.getDeviceType()) {
                        cmds.add("undo anti-ddos cluster member-address " + device.getLogIp());
                        continue;
                    }
                    AticDeviceRouter router = this.aticDeviceRouterDao.findByMoId(device.getMoId());
                    cmds.add("undo anti-ddos flow-src-info " + router.getFlowSrcIp());
                    continue;
                }
                cmds = null;
                break;
            }
            try {
                if (null == cmds) continue;
                this.execCmd(cmds, aticDevice.getMoId());
                logger.info((Object)("undo cluster member-address and flow-src-info info : " + ((Object)cmds).toString() + "device IP : " + aticDevice.getIpAddress()));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId =" + aticDevice.getMoId() + ". " + e.getMessage()));
                if (e.getErrorCode() != 660050L && e.getErrorCode() != 514L) continue;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(aticDevice.getName());
                operation.setTargetId(aticDevice.getMoId());
                operations.add(operation);
            }
        }
        return operations;
    }

    private List<String> getUndoClusterCmd() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("undo anti-ddos cluster all");
        cmds.add("undo anti-ddos cluster key");
        cmds.add("undo anti-ddos flow-src-info all");
        cmds.add("undo ddos-zone all");
        cmds.add("y");
        return cmds;
    }

    @Override
    public List<BatchOperation> deployUndoAntiDDoS1820NClusterInfo(AticDevice device) {
        ArrayList<BatchOperation> operations;
        block3: {
            operations = new ArrayList<BatchOperation>();
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("system-view");
            cmds.addAll(this.getUndoClusterCmd());
            try {
                this.execCmd(cmds, device.getMoId());
                logger.info((Object)("deployUndoAntiDDoS1820NClusterInfo : " + ((Object)cmds).toString() + "device IP : " + device.getIpAddress()));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId =" + device.getMoId() + " " + e.getMessage()));
                if (e.getErrorCode() == 660050L) {
                    BatchOperation operation = new BatchOperation();
                    operation.setErrorCode(660085L);
                    operation.setTargetName(device.getName());
                    operation.setTargetId(device.getMoId());
                    operations.add(operation);
                }
                if (e.getErrorCode() != 514L) break block3;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(device.getName());
                operation.setTargetId(device.getMoId());
                operations.add(operation);
            }
        }
        return operations;
    }

    @Override
    public List<BatchOperation> deployAntiDDoS1820NClusterInfo(List<AticDevice> addDeviceList, List<AticDevice> nfaListExAdd, long moid, String secretKey) {
        Object operation;
        BatchOperation operation2;
        List<String> resultStr;
        AticDeviceRouter router;
        ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
        if (addDeviceList.isEmpty()) {
            return operations;
        }
        AticDevice clusterDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        ArrayList<AticDeviceRouter> entityList = new ArrayList<AticDeviceRouter>();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        for (AticDevice device : addDeviceList) {
            if (8 == device.getDeviceType()) {
                cmds.add("anti-ddos cluster member-address " + device.getLogIp());
                cmds.add(this.getClusterKeyCmd(secretKey));
                continue;
            }
            router = this.aticDeviceRouterDao.findByMoId(device.getMoId());
            entityList.add(router);
        }
        this.assembleFlowSrcCmd(cmds, false, entityList);
        for (AticDevice nfaDevice : nfaListExAdd) {
            try {
                if (8 != nfaDevice.getDeviceType()) continue;
                resultStr = this.execCmd(cmds, nfaDevice.getMoId());
                logger.info((Object)("deploy cluster member-address and flow-src-spc info : " + ((Object)cmds).toString() + "device IP : " + nfaDevice.getIpAddress()));
                if (null == resultStr || resultStr.isEmpty()) continue;
                for (String result : resultStr) {
                    if (!result.contains("Error: ")) continue;
                    operation2 = new BatchOperation();
                    operation2.setOptDetail(result);
                    operation2.setTargetName(nfaDevice.getName());
                    operation2.setTargetId(nfaDevice.getMoId());
                    operations.add(operation2);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId = " + nfaDevice.getMoId() + ". " + e.getMessage()));
                if (e.getErrorCode() != 660050L && e.getErrorCode() != 514L) continue;
                operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(nfaDevice.getName());
                operation.setTargetId(nfaDevice.getMoId());
                operations.add((BatchOperation)operation);
            }
        }
        cmds.add("anti-ddos cluster master-address " + clusterDevice.getIpAddress());
        for (AticDevice device : nfaListExAdd) {
            if (8 == device.getDeviceType()) {
                cmds.add("anti-ddos cluster member-address " + device.getLogIp());
                cmds.add(this.getClusterKeyCmd(secretKey));
                continue;
            }
            router = this.aticDeviceRouterDao.findByMoId(device.getMoId());
            entityList.add(router);
        }
        if (!entityList.isEmpty()) {
            this.assembleFlowSrcCmd(cmds, false, entityList);
        }
        cmds.add(1, "undo anti-ddos cluster all");
        cmds.add(2, "undo anti-ddos cluster key");
        cmds.add(3, "undo anti-ddos flow-src-info all");
        cmds.add(4, "undo ddos-zone all");
        cmds.add(5, "y");
        for (AticDevice nfaDevice : addDeviceList) {
            try {
                if (8 != nfaDevice.getDeviceType()) continue;
                resultStr = this.execCmd(cmds, nfaDevice.getMoId());
                logger.info((Object)("deploy cluster member-address and flow-src-spc new info : " + ((Object)cmds).toString() + "device IP : " + nfaDevice.getIpAddress()));
                if (null == resultStr || resultStr.isEmpty()) continue;
                for (String result : resultStr) {
                    if (!result.contains("Error: ")) continue;
                    operation2 = new BatchOperation();
                    operation2.setOptDetail(result);
                    operation2.setTargetName(nfaDevice.getName());
                    operation2.setTargetId(nfaDevice.getMoId());
                    operations.add(operation2);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId = " + nfaDevice.getMoId() + ". " + e.getMessage()));
                if (e.getErrorCode() != 660050L && e.getErrorCode() != 514L) continue;
                operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(nfaDevice.getName());
                operation.setTargetId(nfaDevice.getMoId());
                operations.add((BatchOperation)operation);
            }
        }
        return operations;
    }

    private String getClusterKeyCmd(String secretKey) {
        if (secretKey == null || secretKey.isEmpty()) {
            return "undo anti-ddos cluster key";
        }
        return "anti-ddos cluster key " + secretKey;
    }

    private void deploy1820NCmds(List<String> cmds, boolean isUndo, List<AticDevice> routerDevList, List<AticDevice> undoNfaDevice, List<AticDevice> aticDeviceList) {
        block6: {
            StringBuilder sb;
            block5: {
                if (null != routerDevList) {
                    ArrayList<AticDeviceRouter> routerList = new ArrayList<AticDeviceRouter>();
                    for (AticDevice routerDevice : routerDevList) {
                        AticDeviceRouter router = this.aticDeviceRouterDao.findByMoId(routerDevice.getMoId());
                        routerList.add(router);
                    }
                    this.assembleFlowSrcCmd(cmds, isUndo, routerList);
                }
                if (!isUndo) break block5;
                if (null == undoNfaDevice) break block6;
                for (AticDevice aticDevice : undoNfaDevice) {
                    sb = new StringBuilder();
                    sb.append("undo ");
                    sb.append("anti-ddos cluster member-address ");
                    sb.append(aticDevice.getLogIp());
                    cmds.add(sb.toString());
                }
                break block6;
            }
            if (null != aticDeviceList) {
                for (AticDevice aticDevice : aticDeviceList) {
                    sb = new StringBuilder();
                    sb.append("anti-ddos cluster member-address ");
                    sb.append(aticDevice.getLogIp());
                    cmds.add(sb.toString());
                }
            }
        }
    }

    @Override
    public List<BatchOperation> undoClusterMemberAddress(List<AticDevice> routerDevList, List<AticDevice> undoNfaDevice, List<AticDevice> aticDeviceList) {
        ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        this.deploy1820NCmds(cmds, true, routerDevList, undoNfaDevice, aticDeviceList);
        for (AticDevice aticDevice : aticDeviceList) {
            try {
                List<String> resultStr = this.execCmd(cmds, aticDevice.getMoId());
                logger.info((Object)("undoClusterMemberAddress : " + ((Object)cmds).toString() + "device IP : " + aticDevice.getIpAddress()));
                if (null == resultStr || resultStr.isEmpty()) continue;
                for (String result : resultStr) {
                    if (!result.contains("Error: ")) continue;
                    BatchOperation operation = new BatchOperation();
                    operation.setOptDetail(result);
                    operation.setTargetName(aticDevice.getName());
                    operation.setTargetId(aticDevice.getMoId());
                    operations.add(operation);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId =" + aticDevice.getMoId() + ". " + e.getMessage()));
                if (e.getErrorCode() != 660050L && e.getErrorCode() != 514L) continue;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(aticDevice.getName());
                operation.setTargetId(aticDevice.getMoId());
                operations.add(operation);
            }
        }
        return operations;
    }

    @Override
    public void notifyDeviceStatusInCluster(int status, long moId) {
        List<AticDeviceNfaCluster> relDevice;
        AticDevice device = this.aticDeviceDao.getDeviceByMoid(moId);
        List<AticDeviceNfaCluster> findClusterByDeviceId = this.aticDeviceNfaClusterDao.findClusterByDeviceId(moId);
        if (null != device && device.getDeviceType() == 8 && null != findClusterByDeviceId && !findClusterByDeviceId.isEmpty() && null != (relDevice = this.aticDeviceNfaClusterDao.findRelNfaDevice(findClusterByDeviceId.get(0).getClusterId())) && !relDevice.isEmpty()) {
            StringBuffer cmd = new StringBuffer();
            if (status == -1) {
                cmd.append("undo anti-ddos cluster member-address ");
            } else {
                cmd.append("anti-ddos cluster member-address ");
            }
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("system");
            cmds.add(cmd.append(device.getIpAddress()).toString());
            for (AticDeviceNfaCluster nfa : relDevice) {
                try {
                    List<String> execCmd = this.execCmd(cmds, nfa.getDeviceId());
                    logger.info((Object)("execCmd : " + execCmd));
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)("undo cluster member failed. deviceIp : " + device.getIpAddress() + ". " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public boolean deployClusterCommuKey(long moid, String secretKey) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system");
        cmds.add(this.getClusterKeyCmd(secretKey));
        try {
            List<String> resultStr = this.execCmd(cmds, moid);
            if (null != resultStr && !resultStr.isEmpty()) {
                for (String result : resultStr) {
                    if (!result.contains("Error: ")) continue;
                    return false;
                }
            }
            return true;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("deploy AntiDDoS1820-N Cluster community key faild , device moid = " + moid + ". " + e.getMessage()));
            return false;
        }
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public ILicenseManagementService getLicenseManagementServiceImpl() {
        return this.licenseManagementServiceImpl;
    }

    public void setLicenseManagementServiceImpl(ILicenseManagementService licenseManagementServiceImpl) {
        this.licenseManagementServiceImpl = licenseManagementServiceImpl;
    }

    static {
        IFTYPE_LIST.add(6);
        IFTYPE_LIST.add(566);
        IFTYPE_LIST.add(117);
        IFTYPE_LIST.add(118);
        IFTYPE_LIST.add(171);
        IFTYPE_LIST.add(136);
        IFTYPE_LIST.add(53);
        IFTYPE_LIST.add(94);
        IFTYPE_LIST.add(135);
        IFTYPE_LIST.add(0xFF0002);
        IFTYPE_LIST.add(0xFF0004);
        IFTYPE_LIST.add(161);
    }
}

