/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.ArrayList;
import java.util.List;

public class ClusterServiceImpl
implements IClusterService {
    private static transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private AticDeviceNfaClusterDao aticDeviceNfaClusterDao;
    private AticDeviceDao aticDeviceDao;
    private IMessageCenter messageCenter = null;

    @Override
    public List<AticDeviceNfaCluster> getBindNfaDevice(Long clusterId) {
        return this.aticDeviceNfaClusterDao.findRelNfaDevice(clusterId);
    }

    @Override
    public boolean isBelongCluster(Long deviceId) {
        List<AticDeviceNfaCluster> nfaClusters = this.aticDeviceNfaClusterDao.findCluster(deviceId);
        return nfaClusters != null && !nfaClusters.isEmpty();
    }

    @Override
    public boolean isRouterAndNfaBelongCluster(Long deviceId) {
        List<AticDeviceNfaCluster> nfaClusters = this.aticDeviceNfaClusterDao.findClusterByDeviceId(deviceId);
        return nfaClusters != null && !nfaClusters.isEmpty();
    }

    @Override
    public void saveCluster(Long clusterId, List<Long> addIds, List<Long> delIds, Boolean clusterOutbound) {
        if (null != addIds && 0 != addIds.size() && null != this.aticDeviceDao && null != this.aticDeviceNfaClusterDao) {
            for (long deviceId : addIds) {
                AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(deviceId);
                AticDeviceForm deviceform = new AticDeviceForm();
                AticUtil.copyProperties((Object)aticDevice, (Object)deviceform);
                if (null == aticDevice) continue;
                AticDeviceNfaCluster aticDeviceNfaCluster = new AticDeviceNfaCluster();
                aticDeviceNfaCluster.setClusterId(clusterId);
                aticDeviceNfaCluster.setDeviceId(deviceId);
                aticDeviceNfaCluster.setDeviceType(Long.valueOf(aticDevice.getDeviceType()));
                aticDeviceNfaCluster.setClusterOutbound(clusterOutbound);
                this.aticDeviceNfaClusterDao.save(aticDeviceNfaCluster);
            }
        }
        logger.info((Object)"save cluster success");
    }

    @Override
    public AticDeviceNfaCluster getClusterByNfaId(Long deviceId) {
        List<AticDeviceNfaCluster> nfaClusters = this.aticDeviceNfaClusterDao.findCluster(deviceId);
        if (null != nfaClusters && !nfaClusters.isEmpty()) {
            return nfaClusters.get(0);
        }
        return null;
    }

    @Override
    public List<AticDevice> getDeviceListByVirtualIp(String ip) {
        AticDevice cluster = this.aticDeviceDao.getDeviceByIp(ip);
        if (null != cluster) {
            return this.aticDeviceDao.queryNfaByClusterId(cluster.getMoId());
        }
        return new ArrayList<AticDevice>();
    }

    @Override
    public List<AticDevice> getDeviceListByVirtualId(Long id) {
        if (null != this.aticDeviceDao) {
            return this.aticDeviceDao.queryNfaByClusterId(id);
        }
        return null;
    }

    @Override
    public AticDeviceNfaCluster findClusterByRouterId(Long routerId) {
        return this.aticDeviceNfaClusterDao.findClusterByRouterId(routerId);
    }

    @Override
    public List<AticDeviceNfaCluster> getBindRouterDevice(Long clusterId) {
        return this.aticDeviceNfaClusterDao.findRouterByClusterId(clusterId);
    }

    @Override
    public void deleteByClusterId(Long clusterId) {
        this.aticDeviceNfaClusterDao.deleteClusterByClusterId(clusterId);
    }

    @Override
    public void updateClusterOutbound(Long clusterId, Boolean clusterOutbound) {
        this.aticDeviceNfaClusterDao.updateClusterOutbound(clusterId, clusterOutbound);
    }

    public AticDeviceNfaClusterDao getAticDeviceNfaClusterDao() {
        return this.aticDeviceNfaClusterDao;
    }

    public void setAticDeviceNfaClusterDao(AticDeviceNfaClusterDao aticDeviceNfaClusterDao) {
        this.aticDeviceNfaClusterDao = aticDeviceNfaClusterDao;
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }
}

