/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secservice.ddos.service.impl;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.frame.service.DevPkgManager;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CommonUtilServiceImpl
implements ICommonUtilService {
    private static final String ATTACK_FILE_PATH = "/conf/attack/confirmAttack.xml";
    private static List<Integer> specialAttackTypes = new ArrayList<Integer>();
    private List<Integer> attackTypes;
    private IAticDeviceService aticDeviceService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    @Override
    public String getDDoSVersion(String deviceIp) {
        if (null != deviceIp && !deviceIp.equals("")) {
            AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
            String devTypeName = "";
            String version = "";
            if (device.getDeviceType() == 1) {
                devTypeName = device.getDeviceModel();
                version = device.getVersion();
            } else if (device.getDeviceType() == 8 || device.getDeviceType() == 9) {
                devTypeName = "AntiDDoS1820-N";
                version = "";
            }
            return this.getDDoSVerByDeviceNameAndVer(devTypeName, version);
        }
        return "";
    }

    @Override
    public String getDDoSVersion(AticDevice device) {
        if (null != device) {
            String devTypeName = "";
            String version = "";
            if (device.getDeviceType() == 1) {
                devTypeName = device.getDeviceModel();
                version = device.getVersion();
            }
            return this.getDDoSVerByDeviceNameAndVer(devTypeName, version);
        }
        return "";
    }

    @Override
    public String getDDosFirewallVersion(AticDevice device) {
        if (device != null) {
            String devTypeName = "";
            String version = "";
            if (device.getDeviceType() == 1) {
                devTypeName = "AntiDDoS8080";
                version = device.getVersion();
            }
            return this.getDDoSVerByDeviceNameAndVer(devTypeName, version);
        }
        return "";
    }

    private String getDDoSVerByDeviceNameAndVer(String devTypeName, String version) {
        String manger = DevPkgManager.getInstance().getDevPkgName(devTypeName, version);
        if (null != manger) {
            if (manger.contains("C00SPC")) {
                manger = manger.split("C00SPC")[0];
            }
            if (manger.contains("C20SPC")) {
                manger = manger.split("C20SPC")[0];
            }
            if (manger.contains("C30SPC")) {
                manger = manger.split("C30SPC")[0];
            }
            if (manger.contains("C50SPC")) {
                manger = manger.split("C50SPC")[0];
            }
            if (manger.contains("C60SPC")) {
                manger = manger.split("C60SPC")[0];
            }
            if (manger.contains("C80SPC")) {
                manger = manger.split("C80SPC")[0];
            }
            if (manger.equalsIgnoreCase("USG5300ADDV100R002")) {
                return "4";
            }
            if (manger.equalsIgnoreCase("USG5300ADDV100R001")) {
                return "2";
            }
            if (manger.equalsIgnoreCase("E8000EV100R002")) {
                return "1";
            }
            if (manger.equalsIgnoreCase("AntiDDoS1000V100R001")) {
                return "4";
            }
            if (manger.equalsIgnoreCase("AntiDDoS8000V100R001")) {
                return "4";
            }
            if (manger.equalsIgnoreCase("AntiDDoS1000V500R001")) {
                return "4";
            }
            if (manger.equalsIgnoreCase("AntiDDoS8000V500R001")) {
                return "4";
            }
            if (manger.contains("V500R005C00")) {
                return "4";
            }
            if (manger.contains("V500R005")) {
                return "4";
            }
            if (manger.contains("V600R007")) {
                return "4";
            }
            if (manger.contains("AntiDDoS1820-N")) {
                return "8";
            }
            if (manger.contains("V600R007C00")) {
                return "4";
            }
            if (manger.contains("V600R020")) {
                return "4";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPropertyValue(InputStream inputStream, String key) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"FileNotFoundException");
        }
        catch (IOException e) {
            this.logger.error((Object)"getPropertyValue load IOException");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"IOException close inputStream error");
                }
            }
        }
        return properties.getProperty(key);
    }

    @Override
    public boolean isSupportSrvLearning(String deviceIp) {
        String devVersion = this.getDDoSVersion(deviceIp);
        return !"".equals(devVersion) && ("4".equals(devVersion) || "3".equals(devVersion));
    }

    @Override
    public boolean isSupportSrvLearning(AticDevice device) {
        if (null == device) {
            return false;
        }
        if (device.getDeviceType() == 8) {
            return false;
        }
        String devVersion = this.getDDoSVersion(device.getIpAddress());
        return !devVersion.equals("") && ("4".equals(devVersion) || "3".equals(devVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAttackTypes() {
        this.attackTypes = new ArrayList<Integer>();
        Document document = null;
        InputStream inputStream = null;
        SAXReader saxReader = new SAXReader();
        try {
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            inputStream = CommonUtilServiceImpl.class.getResourceAsStream(ATTACK_FILE_PATH);
            document = saxReader.read(inputStream);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("langPair");
            while (it.hasNext()) {
                Element node = (Element)it.next();
                Integer type = Integer.parseInt(node.attributeValue("label"));
                this.attackTypes.add(type);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"initAttackTypes failed NumberFormatException.");
        }
        catch (DocumentException e) {
            this.logger.error((Object)"initAttackTypes failed DocumentException.");
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"initAttackTypes failed RuntimeException.");
        }
        catch (SAXException e) {
            this.logger.error((Object)"initAttackTypes failed SAXException.");
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"close fileInputStream in method initAttackTypes failed.");
            }
        }
    }

    @Override
    public boolean isSuportInterActiveAttack(Integer attackType, String devIp) {
        if (null == this.attackTypes) {
            this.initAttackTypes();
        }
        if (this.attackTypes.contains(attackType)) {
            return true;
        }
        return specialAttackTypes.contains(attackType) && this.getDDoSVersion(devIp).equals("1");
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    static {
        specialAttackTypes.add(35);
        specialAttackTypes.add(37);
        specialAttackTypes.add(38);
        specialAttackTypes.add(39);
    }
}

