/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secservice.policyengine.command;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secservice.policyengine.commandbean.Command;
import com.huawei.atic.secservice.policyengine.commandbean.CommandTemplate;
import com.huawei.atic.secservice.policyengine.commandbean.CommandTemplateSet;
import com.huawei.atic.secservice.policyengine.commandengine.CommandParser;
import com.huawei.atic.secservice.policyengine.commandengine.CommandTranslate;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.secservice.policyengine.commandutil.CommandUtil;
import com.huawei.atic.secservice.policyengine.commandutil.ParseException;
import com.huawei.atic.secservice.policyengine.xmlparser.CommandCollection;
import com.huawei.atic.secservice.policyengine.xmlparser.XmlParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandAPI {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private XmlParser xmlParser = new XmlParser();
    private CommandTranslate commandTranslate = new CommandTranslate();
    private CommandParser commandParser = new CommandParser();
    private CommandUtil commandUtil = new CommandUtil();

    public List<CmdParam> doParse(String xmlPath, String cmdTemplateName, String cmdLine) {
        LOGGER.info((Object)"Enter CommandAPI.doParse");
        if (xmlPath == null || cmdTemplateName == null || cmdLine == null) {
            LOGGER.info((Object)"the input param is not illegal or the number of params is not right");
            throw new ParseException(113, "the input param is not illegal or the number of params is not right");
        }
        CommandTemplate commandTemplateBean = this.getCmdTemplate(xmlPath, cmdTemplateName);
        List<CmdParam> paramList = new ArrayList<CmdParam>();
        if (commandTemplateBean != null) {
            paramList = this.commandParser.doParse(cmdLine, commandTemplateBean);
        }
        LOGGER.info((Object)"Leave CommandAPI.doParse");
        return paramList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public List<String> doTranslate(String xmlPath, String cmdTemplateName, List<CmdParam> paramList) {
        if (xmlPath == null || cmdTemplateName == null || paramList == null) {
            LOGGER.info((Object)"the input param is not illegal or the number of params is not right");
            throw new ParseException(113, "the input param is not illegal or the number of params is not right");
        }
        LOGGER.info((Object)("Enter CommandAPI.doTranslate,cmdTemplateName : " + this.getcleanedMessage(cmdTemplateName) + "paramList : " + this.getcleanedMessage(paramList.toString()) + " xmlPath :" + xmlPath));
        CommandTemplate commTemplate = this.getCmdTemplate(xmlPath, cmdTemplateName);
        List<String> cliList = new ArrayList<String>();
        if (commTemplate != null) {
            cliList = this.commandTranslate.translate(commTemplate, paramList);
        }
        LOGGER.info((Object)"Leave CommandAPI.doTranslate");
        return cliList;
    }

    public CommandTemplate getCmdTemplate(String xmlPath, String cmdTemplateName) {
        LOGGER.info((Object)"Enter getCmdTemplate");
        CommandCollection cc = CommandCollection.getInstance();
        Map<String, CommandTemplateSet> commandCollects = cc.getCommandCollection();
        HashMap commandCollection = null;
        if (!(commandCollects instanceof HashMap)) {
            LOGGER.info((Object)"getCmdTemplate() error,commandCollection is not HashMap.");
            return null;
        }
        commandCollection = (HashMap)commandCollects;
        String fileName = CommandUtil.getFileName(xmlPath);
        CommandTemplateSet commandTemplateSet = null;
        CommandTemplate commTemplate = null;
        if (commandCollection.containsKey(fileName)) {
            commandTemplateSet = (CommandTemplateSet)commandCollection.get(fileName);
        } else {
            LOGGER.info((Object)"beforeparse:");
            commandTemplateSet = (CommandTemplateSet)this.xmlParser.parseXml2Bean(xmlPath);
            LOGGER.info((Object)"afterparse");
            cc.addCommandTemplateSet(xmlPath, commandTemplateSet);
        }
        commTemplate = commandTemplateSet.getCommandTemplate(cmdTemplateName);
        if (commTemplate == null) {
            LOGGER.info((Object)("Template ID error\uff0ccan't find " + cmdTemplateName));
        }
        List<Object> commandList = new ArrayList();
        if (null != commTemplate) {
            commandList = commTemplate.getCommandList();
        }
        Command commandBean = null;
        for (int i = 0; i < commandList.size(); ++i) {
            commandBean = (Command)commandList.get(i);
            String commandTplStr = commandBean.getCommandContent();
            if (this.commandUtil.validCommandTplStr(commandTplStr = this.commandUtil.changeTabToSpace(commandTplStr))) continue;
            return null;
        }
        LOGGER.info((Object)"Leave getCmdTemplate");
        return commTemplate;
    }
}

