/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.system.service;

import com.hs.atic.collector.entity.CertInfoEntity;
import com.hs.atic.rmi.CollectorRMIProxy;
import com.hs.atic.rmi.FileTransService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.system.service.CertificateValidity;
import com.huawei.atic.system.service.ICertificateProvider;
import com.huawei.atic.util.SecneVsmUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class CertificateValidityImpl
implements ICertificateProvider {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IDataProtectService dataProtectService;
    private ICollectorService collectorService;
    private CollectorRMIProxy collectorRMIProxy;

    public CollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(CollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    @Override
    public List<CertificateValidity> getKeyStores() {
        ArrayList<CertificateValidity> keyStoreList = new ArrayList<CertificateValidity>();
        CertificateValidity certificateValidity = null;
        Properties properties = SecneVsmUtil.getInstance().loadLegoCertInfoProperties();
        String path = SecneVsmUtil.getInstallPath();
        certificateValidity = new CertificateValidity();
        certificateValidity.setName(properties.getProperty("keystore.lego.name"));
        certificateValidity.setPath(path + properties.getProperty("keystore.lego.path"));
        certificateValidity.setKeyStorePass(this.dataProtectService.sdpDecryptInitData(properties.getProperty("keystore.lego.password")));
        keyStoreList.add(certificateValidity);
        certificateValidity = new CertificateValidity();
        certificateValidity.setName(properties.getProperty("keystore.mc.name"));
        certificateValidity.setPath(path + properties.getProperty("keystore.mc.path"));
        certificateValidity.setKeyStorePass(this.dataProtectService.sdpDecryptInitData(properties.getProperty("keystore.mc.password")));
        keyStoreList.add(certificateValidity);
        certificateValidity = new CertificateValidity();
        certificateValidity.setName(properties.getProperty("truststore.mc.name"));
        certificateValidity.setPath(path + properties.getProperty("truststore.mc.path"));
        certificateValidity.setKeyStorePass(this.dataProtectService.sdpDecryptInitData(properties.getProperty("truststore.mc.password")));
        keyStoreList.add(certificateValidity);
        certificateValidity = new CertificateValidity();
        certificateValidity.setName(properties.getProperty("truststore.third.name"));
        certificateValidity.setPath(path + properties.getProperty("truststore.third.path"));
        certificateValidity.setKeyStorePass(this.dataProtectService.sdpDecryptInitData(properties.getProperty("truststore.third.password")));
        keyStoreList.add(certificateValidity);
        this.getAllCollectorCertFiles();
        keyStoreList.addAll(this.getAllCollectorCertInfos());
        return keyStoreList;
    }

    private void getAllCollectorCertFiles() {
        FileTransService fileTransService = null;
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (!this.checkDirectory(SecneVsmUtil.getInstallPath() + "\\LegoRuntime\\collectorCerts")) {
            this.logger.error((Object)"getAllCollectorCertFiles create or clean directory error");
            return;
        }
        try {
            List<CollectorInfo> collectors = this.collectorService.listCollector(conditions);
            for (CollectorInfo collector : collectors) {
                fileTransService = this.collectorRMIProxy.getFileTransService(collector.getIpAddress());
                if (null == fileTransService) {
                    this.logger.error((Object)"fileTransService is null");
                    return;
                }
                byte[] certBytes = fileTransService.getFile("collector_keystore");
                this.saveFile(certBytes, this.getCollectorCertPath(collector.getIpAddress() + "_collector_keystore"));
                certBytes = fileTransService.getFile("collector_truststore");
                this.saveFile(certBytes, this.getCollectorCertPath(collector.getIpAddress() + "_collector_truststore"));
                certBytes = fileTransService.getFile("third_truststore");
                this.saveFile(certBytes, this.getCollectorCertPath(collector.getIpAddress() + "_third_truststore"));
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"getAllCollectorCertFiles error");
        }
        catch (Exception e) {
            this.logger.error((Object)"getAllCollectorCertFiles error");
        }
    }

    private List<CertificateValidity> getAllCollectorCertInfos() {
        FileTransService fileTransService = null;
        CertificateValidity certificateValidity = null;
        ArrayList<CertificateValidity> collectorKeyStoreList = new ArrayList<CertificateValidity>();
        HashMap<String, String> conditions = new HashMap<String, String>();
        try {
            List<CollectorInfo> collectors = this.collectorService.listCollector(conditions);
            for (CollectorInfo collector : collectors) {
                fileTransService = this.collectorRMIProxy.getFileTransService(collector.getIpAddress());
                if (null == fileTransService) {
                    this.logger.error((Object)(this.getcleanedMessage(collector.getIpAddress()) + "-fileTransService is null"));
                    continue;
                }
                List certInfoEntities = fileTransService.getCertInfos();
                for (CertInfoEntity certInfoEntity : certInfoEntities) {
                    certificateValidity = new CertificateValidity();
                    certificateValidity.setName(collector.getIpAddress() + '_' + certInfoEntity.getName());
                    certificateValidity.setPath(this.getCollectorCertPath(certificateValidity.getName()));
                    certificateValidity.setKeyStorePass(certInfoEntity.getKeyStorePwd());
                    collectorKeyStoreList.add(certificateValidity);
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"getAllCollectorCertInfos error");
        }
        catch (Exception e) {
            this.logger.error((Object)"getAllCollectorCertInfos error");
        }
        return collectorKeyStoreList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public List<CertificateValidity> getCertificates() {
        ArrayList<CertificateValidity> certList = new ArrayList<CertificateValidity>();
        CertificateValidity certificateValidity = new CertificateValidity();
        Properties properties = SecneVsmUtil.getInstance().loadLegoCertInfoProperties();
        certificateValidity.setName(properties.getProperty("cer.nfa.name"));
        certificateValidity.setPath(SecneVsmUtil.getInstallPath() + properties.getProperty("cer.nfa.path"));
        certList.add(certificateValidity);
        return certList;
    }

    private String getCollectorCertPath(String certName) {
        String path = null;
        path = SecneVsmUtil.getInstallPath() + "\\LegoRuntime\\collectorCerts\\" + certName;
        this.logger.error((Object)("getCollectorCertName is: " + certName));
        return path;
    }

    private boolean checkDirectory(String filePath) {
        File[] files;
        boolean ret = false;
        File file = new File(filePath);
        if (!file.exists()) {
            ret = file.mkdir();
            return ret;
        }
        if (file.isDirectory() && null != (files = file.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || (ret = files[i].delete())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveFile(byte[] fileBytes, String saveFilePath) {
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(saveFilePath);
            fileOutput.write(fileBytes);
            fileOutput.flush();
            return;
        }
        catch (IOException e) {
            this.logger.error((Object)"saveFile error");
            return;
        }
        finally {
            if (fileOutput != null) {
                try {
                    try {
                        fileOutput.close();
                        fileOutput = null;
                    }
                    catch (IOException e) {
                        fileOutput = null;
                        fileOutput = null;
                    }
                }
                catch (Throwable throwable) {
                    fileOutput = null;
                    throw throwable;
                }
            }
        }
    }
}

