/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.system.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtector;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.system.service.CertificateValidity;
import com.huawei.atic.system.service.ICertificateProvider;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JRECacertsProvider
implements ICertificateProvider {
    private static final String FILE_PATH = "truststore.jre.path";
    private static final String FILE_PWORD = "truststore.jre.password";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    @Override
    public List<CertificateValidity> getKeyStores() {
        ArrayList<CertificateValidity> certList = new ArrayList<CertificateValidity>();
        Properties prop = this.cacertsProps();
        CertificateValidity cert = new CertificateValidity();
        cert.setPath(prop.getProperty(FILE_PATH));
        cert.setName("jre_truststore");
        String pword = LegoDataProtector.sdpDecrypt((long)0L, (String)prop.getProperty(FILE_PWORD));
        cert.setKeyStorePass(pword);
        certList.add(cert);
        return certList;
    }

    @Override
    public List<CertificateValidity> getCertificates() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties cacertsProps() {
        String propPath = null;
        propPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime" + File.separator + "cert" + File.separator + "cacerts.properties";
        FileInputStream fis = null;
        Properties prop = new Properties();
        try {
            File file = new File(propPath);
            fis = new FileInputStream(file);
            prop.load(fis);
            JRECacertsProvider.closeStream(fis);
        }
        catch (IOException e) {
            LOGGER.error((Object)"NoPropertiesFileFound error!");
        }
        finally {
            JRECacertsProvider.closeStream(fis);
        }
        return prop;
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"SysLogClient-closeStream");
            }
        }
    }
}

