/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.util.AddressUtil;
import com.hs.lego.core.sdk.util.EncryptData;
import com.hs.lego.core.sdk.util.IPUtil;
import com.huawei.atic.device.license.model.LicenseInfoDb;
import com.huawei.atic.device.license.model.LicenseInfoModel;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CapaUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class CommonUtil {
    private static final ArrayList<String> OLD_VERSIONLIST = new ArrayList();

    private CommonUtil() {
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static String convertListToString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        for (String temp : list) {
            sb.append(temp);
        }
        return sb.toString();
    }

    public static void printException(Log logger, Exception e, String preface) {
        StackTraceElement[] stackTraceElements;
        logger.error((Object)(preface + ":" + e));
        for (StackTraceElement stackTraceElement : stackTraceElements = e.getStackTrace()) {
            logger.error((Object)stackTraceElement);
        }
    }

    public static String transformNumber(String number, String unit) {
        if (CommonUtil.isNull(number)) {
            return number;
        }
        DecimalFormat df = new DecimalFormat("###,###");
        String numberBuf = "";
        try {
            numberBuf = df.format(Double.parseDouble(number));
        }
        catch (NumberFormatException e) {
            numberBuf = "";
        }
        if (!CommonUtil.isNull(unit)) {
            numberBuf = numberBuf + unit;
        }
        return numberBuf;
    }

    public static boolean includesV1R1(List<AticDevice> aticDeviceList) {
        boolean flag = false;
        if (null == aticDeviceList || aticDeviceList.isEmpty()) {
            return flag;
        }
        for (AticDevice device : aticDeviceList) {
            if (null == device) continue;
            if (null != device.getVersion() && device.getVersion().contains("V100R001")) {
                flag = true;
                break;
            }
            if (null == device.getVersion() || !device.getVersion().contains("V500R001C00")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isV5R1C20OrAfterVersion(Long deviceId) {
        AticDevice aticDevice = CapaUtil.getAticDeviceService().getDeviceByMoid(deviceId);
        String version = null;
        if (null == aticDevice || null == aticDevice.getVersion()) {
            return false;
        }
        version = aticDevice.getVersion();
        return !version.contains("V100R001") && !version.contains("V500R001C00");
    }

    public static boolean isNewDevice(AticDevice aticDevice) {
        String[] deviceVersion;
        String version = aticDevice.getVersion();
        return aticDevice.getDeviceType() != 1 || !version.contains("SPC") || !OLD_VERSIONLIST.contains((deviceVersion = version.split("SPC"))[0]) && !version.contains("V1");
    }

    public static String getInstallXmlIp() {
        String serverIpAddress = "";
        try {
            String path = AticInstallUtil.getInstance().getLegoPlatInstalledXMLPath();
            SAXReader saxReader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            Document doc = saxReader.read(new File(path));
            Element element = (Element)doc.selectSingleNode("//entry/string[text()='lego.base.serverIpAddress']");
            serverIpAddress = element.getParent().selectSingleNode("com.huawei.elog.base.model.ContextPropVal").selectSingleNode("value").getText();
        }
        catch (DocumentException e) {
            serverIpAddress = "";
        }
        catch (NullPointerException e) {
            serverIpAddress = "";
        }
        catch (SAXException e) {
            serverIpAddress = "";
        }
        if (CommonUtil.isNull(serverIpAddress) || !IPUtil.isIpv4((String)serverIpAddress) && !IPUtil.isIpv6((String)serverIpAddress)) {
            serverIpAddress = AddressUtil.getLocalIP();
        }
        return serverIpAddress;
    }

    public static LicenseInfoModel licenseInfoDbToLicenseInfoModel(LicenseInfoDb db) {
        LicenseInfoModel model = new LicenseInfoModel();
        try {
            model.setLicenseNumber(db.getLicenseNumber());
            model.setDdosDeviceId(db.getDdosDeviceId());
            model.setSwitchCount(db.getSwitchCount());
            model.setConCurDefenseIpLimit(db.getConCurDefenseIpLimit());
            model.setRemainingNumber(Integer.parseInt(EncryptData.getInstanse().decryptdata(db.getRemainingNumber())));
            model.setConfigurableDefenseIpLimit(db.getConfigurableDefenseIpLimit());
            model.setConCurDefenseIpLimit(model.getConCurDefenseIpLimit());
            model.setDefenseBindwidth(Integer.parseInt(EncryptData.getInstanse().decryptdata(db.getDefenseBindwidth())));
            model.setExpirationDate(EncryptData.getInstanse().decryptdata(db.getExpirationDate()));
            model.setUpdatedDateTime(db.getUpdatedDateTime());
        }
        catch (NumberFormatException e) {
            model = new LicenseInfoModel();
        }
        return model;
    }

    public static LicenseInfoDb licenseInfoModelToLicenseInfoDb(LicenseInfoModel model) {
        LicenseInfoDb db = new LicenseInfoDb();
        try {
            db.setLicenseNumber(model.getLicenseNumber());
            db.setDdosDeviceId(model.getDdosDeviceId());
            db.setSwitchCount(model.getSwitchCount());
            db.setRemainingNumber(EncryptData.getInstanse().encryptData(String.valueOf(model.getRemainingNumber())));
            db.setConfigurableDefenseIpLimit(model.getConfigurableDefenseIpLimit());
            db.setConCurDefenseIpLimit(model.getConCurDefenseIpLimit());
            db.setDefenseBindwidth(EncryptData.getInstanse().encryptData(String.valueOf(model.getDefenseBindwidth())));
            db.setExpirationDate(EncryptData.getInstanse().encryptData(model.getExpirationDate()));
            db.setUpdatedDateTime(model.getUpdatedDateTime());
        }
        catch (NumberFormatException e) {
            db = new LicenseInfoDb();
        }
        return db;
    }

    static {
        OLD_VERSIONLIST.add("V500R001C00");
        OLD_VERSIONLIST.add("V500R001C20");
        OLD_VERSIONLIST.add("V500R001C30");
        OLD_VERSIONLIST.add("V500R001C50");
    }
}

