/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.util.CommonUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class DevCpuDescrUtil {
    private static final Map<Integer, String> CPUDESCRX3 = new HashMap<Integer, String>();
    private static final Map<Integer, String> CPUDESCRX8 = new HashMap<Integer, String>();
    private static final Map<Integer, String> CPUDESCRX16 = new HashMap<Integer, String>();
    private static final Map<Integer, String> CPUDESCRX18 = new HashMap<Integer, String>();
    private static final Map<Integer, String> CPUDESCRGX12004 = new HashMap<Integer, String>();
    private static final Map<Integer, String> CPUDESCRGX12008 = new HashMap<Integer, String>();

    public static String getCpuDesc(AticDevice aticDevice, int cpuIndex) {
        int devModelLen = aticDevice.getDeviceModel().trim().length();
        int startIndex = devModelLen - 3;
        int deviceType = aticDevice.getDeviceModel().startsWith("AntiDDoS12") ? Integer.parseInt(aticDevice.getDeviceModel().trim().substring(8, 13)) : Integer.parseInt(aticDevice.getDeviceModel().trim().substring(startIndex, startIndex + 2));
        String cpuDesc = null;
        if (deviceType == 3 ? null != (cpuDesc = CPUDESCRX3.get(cpuIndex)) : (deviceType == 8 ? null != (cpuDesc = CPUDESCRX8.get(cpuIndex)) : (deviceType == 16 ? null != (cpuDesc = CPUDESCRX16.get(cpuIndex)) : (deviceType == 88 || deviceType == 82 ? null != (cpuDesc = CPUDESCRX18.get(cpuIndex)) : (deviceType == 12004 ? null != (cpuDesc = CPUDESCRGX12004.get(cpuIndex)) : deviceType == 12008 && null != (cpuDesc = CPUDESCRGX12008.get(cpuIndex))))))) {
            return cpuDesc;
        }
        return "unknow";
    }

    public static boolean checkSpuSlot(AticDevice device, Integer index) {
        String cpuDescr = DevCpuDescrUtil.getCpuDesc(device, index);
        String spuSlot = device.getSpuSlot();
        String slotString = "slot";
        if (!CommonUtil.isNull(spuSlot)) {
            String[] slots;
            if (!CommonUtil.isNull(cpuDescr)) {
                String[] cupDescrs = cpuDescr.split("/");
                cpuDescr = cupDescrs[0].substring(cupDescrs[0].toLowerCase(Locale.getDefault()).indexOf(slotString) + slotString.length()).trim();
            }
            for (String slot : slots = spuSlot.substring(0, spuSlot.length() - 1).split(",")) {
                if (!slot.equals(cpuDescr)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        CPUDESCRX3.put(1, "Slot 1/CPU 0");
        CPUDESCRX3.put(2, "Slot 2/CPU 0");
        CPUDESCRX3.put(3, "Slot 3/CPU 0");
        CPUDESCRX3.put(4, "Slot 1/CPU 1");
        CPUDESCRX3.put(5, "Slot 2/CPU 1");
        CPUDESCRX3.put(6, "Slot 3/CPU 1");
        CPUDESCRX3.put(7, "Slot 1/CPU 2");
        CPUDESCRX3.put(8, "Slot 2/CPU 2");
        CPUDESCRX3.put(9, "Slot 3/CPU 2");
        CPUDESCRX3.put(10, "Slot 1/CPU 3");
        CPUDESCRX3.put(11, "Slot 2/CPU 3");
        CPUDESCRX3.put(12, "Slot 3/CPU 3");
        CPUDESCRX8.put(1, "Slot 1/CPU 0");
        CPUDESCRX8.put(2, "Slot 2/CPU 0");
        CPUDESCRX8.put(3, "Slot 3/CPU 0");
        CPUDESCRX8.put(4, "Slot 4/CPU 0");
        CPUDESCRX8.put(5, "Slot 5/CPU 0");
        CPUDESCRX8.put(6, "Slot 6/CPU 0");
        CPUDESCRX8.put(7, "Slot 7/CPU 0");
        CPUDESCRX8.put(8, "Slot 8/CPU 0");
        CPUDESCRX8.put(9, "Slot 1/CPU 1");
        CPUDESCRX8.put(10, "Slot 2/CPU 1");
        CPUDESCRX8.put(11, "Slot 3/CPU 1");
        CPUDESCRX8.put(12, "Slot 4/CPU 1");
        CPUDESCRX8.put(13, "Slot 5/CPU 1");
        CPUDESCRX8.put(14, "Slot 6/CPU 1");
        CPUDESCRX8.put(15, "Slot 7/CPU 1");
        CPUDESCRX8.put(16, "Slot 8/CPU 1");
        CPUDESCRX8.put(17, "Slot 1/CPU 2");
        CPUDESCRX8.put(18, "Slot 2/CPU 2");
        CPUDESCRX8.put(19, "Slot 3/CPU 2");
        CPUDESCRX8.put(20, "Slot 4/CPU 2");
        CPUDESCRX8.put(21, "Slot 5/CPU 2");
        CPUDESCRX8.put(22, "Slot 6/CPU 2");
        CPUDESCRX8.put(23, "Slot 7/CPU 2");
        CPUDESCRX8.put(24, "Slot 8/CPU 2");
        CPUDESCRX8.put(25, "Slot 1/CPU 3");
        CPUDESCRX8.put(26, "Slot 2/CPU 3");
        CPUDESCRX8.put(27, "Slot 3/CPU 3");
        CPUDESCRX8.put(28, "Slot 4/CPU 3");
        CPUDESCRX8.put(29, "Slot 5/CPU 3");
        CPUDESCRX8.put(30, "Slot 6/CPU 3");
        CPUDESCRX8.put(31, "Slot 7/CPU 3");
        CPUDESCRX8.put(32, "Slot 8/CPU 3");
        CPUDESCRX16.put(1, "Slot 1/CPU 0");
        CPUDESCRX16.put(2, "Slot 2/CPU 0");
        CPUDESCRX16.put(3, "Slot 3/CPU 0");
        CPUDESCRX16.put(4, "Slot 4/CPU 0");
        CPUDESCRX16.put(5, "Slot 5/CPU 0");
        CPUDESCRX16.put(6, "Slot 6/CPU 0");
        CPUDESCRX16.put(7, "Slot 7/CPU 0");
        CPUDESCRX16.put(8, "Slot 8/CPU 0");
        CPUDESCRX16.put(9, "Slot 9/CPU 0");
        CPUDESCRX16.put(10, "Slot 10/CPU 0");
        CPUDESCRX16.put(11, "Slot 11/CPU 0");
        CPUDESCRX16.put(12, "Slot 12/CPU 0");
        CPUDESCRX16.put(13, "Slot 13/CPU 0");
        CPUDESCRX16.put(14, "Slot 14/CPU 0");
        CPUDESCRX16.put(15, "Slot 15/CPU 0");
        CPUDESCRX16.put(16, "Slot 16/CPU 0");
        CPUDESCRX16.put(17, "Slot 1/CPU 1");
        CPUDESCRX16.put(18, "Slot 2/CPU 1");
        CPUDESCRX16.put(19, "Slot 3/CPU 1");
        CPUDESCRX16.put(20, "Slot 4/CPU 1");
        CPUDESCRX16.put(21, "Slot 5/CPU 1");
        CPUDESCRX16.put(22, "Slot 6/CPU 1");
        CPUDESCRX16.put(23, "Slot 7/CPU 1");
        CPUDESCRX16.put(24, "Slot 8/CPU 1");
        CPUDESCRX16.put(25, "Slot 9/CPU 1");
        CPUDESCRX16.put(26, "Slot 10/CPU 1");
        CPUDESCRX16.put(27, "Slot 11/CPU 1");
        CPUDESCRX16.put(28, "Slot 12/CPU 1");
        CPUDESCRX16.put(29, "Slot 13/CPU 1");
        CPUDESCRX16.put(30, "Slot 14/CPU 1");
        CPUDESCRX16.put(31, "Slot 15/CPU 1");
        CPUDESCRX16.put(32, "Slot 16/CPU 1");
        CPUDESCRX16.put(33, "Slot 1/CPU 2");
        CPUDESCRX16.put(34, "Slot 2/CPU 2");
        CPUDESCRX16.put(35, "Slot 3/CPU 2");
        CPUDESCRX16.put(36, "Slot 4/CPU 2");
        CPUDESCRX16.put(37, "Slot 5/CPU 2");
        CPUDESCRX16.put(38, "Slot 6/CPU 2");
        CPUDESCRX16.put(39, "Slot 7/CPU 2");
        CPUDESCRX16.put(40, "Slot 8/CPU 2");
        CPUDESCRX16.put(41, "Slot 9/CPU 2");
        CPUDESCRX16.put(42, "Slot 10/CPU 2");
        CPUDESCRX16.put(43, "Slot 11/CPU 2");
        CPUDESCRX16.put(44, "Slot 12/CPU 2");
        CPUDESCRX16.put(45, "Slot 13/CPU 2");
        CPUDESCRX16.put(46, "Slot 14/CPU 2");
        CPUDESCRX16.put(47, "Slot 15/CPU 2");
        CPUDESCRX16.put(48, "Slot 16/CPU 2");
        CPUDESCRX16.put(49, "Slot 1/CPU 3");
        CPUDESCRX16.put(50, "Slot 2/CPU 3");
        CPUDESCRX16.put(51, "Slot 3/CPU 3");
        CPUDESCRX16.put(52, "Slot 4/CPU 3");
        CPUDESCRX16.put(53, "Slot 5/CPU 3");
        CPUDESCRX16.put(54, "Slot 6/CPU 3");
        CPUDESCRX16.put(55, "Slot 7/CPU 3");
        CPUDESCRX16.put(56, "Slot 8/CPU 3");
        CPUDESCRX16.put(57, "Slot 9/CPU 3");
        CPUDESCRX16.put(58, "Slot 10/CPU 3");
        CPUDESCRX16.put(59, "Slot 11/CPU 3");
        CPUDESCRX16.put(60, "Slot 12/CPU 3");
        CPUDESCRX16.put(61, "Slot 13/CPU 3");
        CPUDESCRX16.put(62, "Slot 14/CPU 3");
        CPUDESCRX16.put(63, "Slot 15/CPU 3");
        CPUDESCRX16.put(64, "Slot 16/CPU 3");
        CPUDESCRX18.put(603979777, "Slot 11/CPU 0");
        CPUDESCRX18.put(603980545, "Slot 12/CPU 0");
        CPUDESCRGX12004.put(1, "Slot 1/CPU ALL");
        CPUDESCRGX12004.put(2, "Slot 2/CPU ALL");
        CPUDESCRGX12004.put(3, "Slot 3/CPU ALL");
        CPUDESCRGX12004.put(4, "Slot 4/CPU ALL");
        CPUDESCRGX12008.put(1, "Slot 1/CPU ALL");
        CPUDESCRGX12008.put(2, "Slot 2/CPU ALL");
        CPUDESCRGX12008.put(3, "Slot 3/CPU ALL");
        CPUDESCRGX12008.put(4, "Slot 4/CPU ALL");
        CPUDESCRGX12008.put(5, "Slot 5/CPU ALL");
        CPUDESCRGX12008.put(6, "Slot 6/CPU ALL");
        CPUDESCRGX12008.put(7, "Slot 7/CPU ALL");
        CPUDESCRGX12008.put(8, "Slot 8/CPU ALL");
    }
}

