/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.alarm.entity.AlarmObjectBuffer;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import java.util.List;

public class AlarmServiceImpl
implements IAlarmService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private AlarmObjectBuffer alarmObjectBuffer;

    public AlarmObjectBuffer getAlarmObjectBuffer() {
        return this.alarmObjectBuffer;
    }

    public void setAlarmObjectBuffer(AlarmObjectBuffer alarmObjectBuffer) {
        this.alarmObjectBuffer = alarmObjectBuffer;
    }

    @Override
    public void callAlarmQueue(AticAlarmObject alarmObject) {
        try {
            if (null != this.alarmObjectBuffer) {
                this.alarmObjectBuffer.addData(alarmObject);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("AticAlarmObject alarmObject:" + alarmObject + ". " + e.getMessage()));
        }
    }

    @Override
    public void callAlarmQueue(List<AticAlarmObject> alarmObject) {
        try {
            if (null != this.alarmObjectBuffer) {
                this.alarmObjectBuffer.addBatchData(alarmObject);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("aAlarmObject size:" + alarmObject.size() + ". " + e.getMessage()));
        }
    }

    @Override
    public void callinitAlarm(String taskName, String databaseName) {
        String[] alarm = new String[]{taskName, databaseName};
        AticAlarmObject alarmObject = new AticAlarmObject();
        alarmObject.setAlarmId("0x0000000803240809");
        alarmObject.setAlarmParam(alarm);
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
        alarmObject.setAlertTime(System.currentTimeMillis());
        alarmObject.setIsAlarm(true);
        alarmObject.setMoId(0L);
        alarmObject.setMoIp("127.0.0.1");
        alarmObject.setMoName("System");
        this.alarmObjectBuffer.addData(alarmObject);
    }
}

