/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.dao.impl;

import com.hs.lego.cbb.fault.dao.FaultDao;
import com.hs.lego.cbb.fault.dao.FaultStatisticDao;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultDetail;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.base.util.ConverterUtil;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;

public class FaultDaoImpl
extends CommonDaoImpl
implements FaultDao {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final Byte ALARM_DDOS_VALUE = 6;
    private static final Byte ALARM_OTHER_VALUE = -1;
    private static final int CURRENT_FAULT = 1;
    private static final int HISTROY_FAULT = 2;
    private FaultStatisticDao faultStatisticDao;
    private final Object lock = new Object();

    public FaultStatisticDao getFaultStatisticDao() {
        return this.faultStatisticDao;
    }

    public void setFaultStatisticDao(FaultStatisticDao faultStatisticDao) {
        this.faultStatisticDao = faultStatisticDao;
    }

    @Override
    public Paging listFault(FaultQueryCondition condition) {
        StringBuffer hql = new StringBuffer();
        List<Object> list = this.getSql(condition, hql);
        if (condition.getSource() != null) {
            hql.append(" and lower(fault.source) like lower(?" + list.size() + ")");
            String source = ConverterUtil.getInstance().convertString(condition.getSource().trim(), true);
            list.add(source);
        }
        if (condition.getBeginTime() != null) {
            hql.append(" and fault.modTime >= ?" + list.size());
            list.add(condition.getBeginTime());
        }
        if (condition.getEndTime() != null) {
            hql.append(" and fault.modTime <= ?" + list.size());
            list.add(condition.getEndTime());
        }
        String countHql = "select count(fault.id) " + hql.toString();
        if (condition.getSortField() == null && condition.getSortType() == null) {
            hql.append(" order by fault.modTime desc");
        } else if (this.checkParams(condition.getSortField(), condition.getSortType())) {
            hql.append(" order by fault.").append(condition.getSortField()).append(' ').append(condition.getSortType());
            if (!"ID".equals(condition.getSortField().toUpperCase(Locale.US))) {
                hql.append(", fault.id desc");
            }
        }
        Paging paging = new Paging();
        Session session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        Query countQuery = session.createQuery(countHql);
        Query q = session.createQuery(hql.toString());
        for (int i = 0; i < list.size(); ++i) {
            countQuery.setParameter(i, list.get(i));
            q.setParameter(i, list.get(i));
        }
        Long total = (Long)countQuery.uniqueResult();
        q.setFirstResult(condition.getStart().intValue());
        q.setMaxResults(condition.getPageSize().intValue());
        paging.setCount(total.intValue());
        paging.setData(q.list());
        return paging;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return null != name && null != type && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    private List<Object> getSql(FaultQueryCondition condition, StringBuffer hql) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (1L == condition.getUserID()) {
            hql.append("from Fault fault where 1=1 ");
        } else {
            hql.append("from Fault fault where fault.moId in (select id.moId from UserRelMoInfo where id.userId=?" + params.size());
            params.add(condition.getUserID());
            hql.append(") and (extendMoId in (select id.moId from UserRelMoInfo where id.userId=?" + params.size());
            params.add(condition.getUserID());
            hql.append(") or extendMoId = 0 or extendMoId is null)");
        }
        if (condition.getSeverity() != null && condition.getSeverity().length > 0) {
            if (condition.getSeverity().length == 1) {
                hql.append(" and fault.severity= ?" + params.size());
                params.add(condition.getSeverity()[0]);
            } else {
                hql.append(" and fault.severity in ( ?" + params.size());
                params.add(condition.getSeverity()[0]);
                for (int i = 1; i < condition.getSeverity().length; ++i) {
                    hql.append(",?" + params.size());
                    params.add(condition.getSeverity()[i]);
                }
                hql.append(')');
            }
        }
        if (null != condition.getFaultDefineId() && !condition.getFaultDefineId().isEmpty()) {
            hql.append(" and fault.faultDefineId= ?" + params.size());
            params.add(condition.getFaultDefineId());
        }
        if (condition.getSourceType() != null) {
            if (String.valueOf(ALARM_OTHER_VALUE).equals(String.valueOf(condition.getSourceType()))) {
                hql.append(" and fault.sourceType <> ").append(ALARM_DDOS_VALUE);
            } else {
                hql.append(" and fault.sourceType= ?" + params.size());
                params.add(condition.getSourceType());
            }
        }
        if (condition.getZoneId() != 0L) {
            hql.append(" and fault.moId= ?" + params.size());
            params.add(condition.getZoneId());
        }
        if (condition.getConfirmStatus() != null) {
            hql.append(" and fault.confirmStatus= ?" + params.size());
            params.add(condition.getConfirmStatus());
        }
        if (condition.getClearStatus() != null) {
            hql.append(" and fault.clearStatus= ?" + params.size());
            params.add(condition.getClearStatus());
        }
        return params;
    }

    @Override
    public List<Fault> listFault(Long[] ids, String sortField, String sortType) {
        StringBuilder hql = new StringBuilder("from Fault fault where fault.id in(");
        hql.append("?0");
        for (int i = 1; i < ids.length; ++i) {
            hql.append(", ?" + i);
        }
        hql.append(')');
        hql.append(" order by fault.modTime desc");
        return this.getHibernateTemplate().find(hql.toString(), (Object[])ids);
    }

    @Override
    public List<Fault> listAllFault(FaultQueryCondition condition) {
        StringBuffer hql = new StringBuffer();
        List<Object> list = this.getSql(condition, hql);
        this.setSqlAndParams(condition, hql, list);
        if (condition.getSortField() == null && condition.getSortType() == null) {
            hql.append(" order by fault.modTime desc");
        } else if (this.checkParams(condition.getSortField(), condition.getSortType())) {
            hql.append(" order by fault.").append(condition.getSortField()).append(' ').append(condition.getSortType());
            if (!"ID".equals(condition.getSortField().toUpperCase(Locale.US))) {
                hql.append(", fault.id desc");
            }
        }
        if (!list.isEmpty()) {
            return this.getHibernateTemplate().find(hql.toString(), list.toArray());
        }
        return this.getHibernateTemplate().find(hql.toString(), new Object[0]);
    }

    private void setSqlAndParams(FaultQueryCondition condition, StringBuffer hql, List<Object> list) {
        if (null != list) {
            if (condition.getSource() != null) {
                hql.append(" and lower(fault.source) like lower(?" + list.size() + ")");
                list.add(ConverterUtil.getInstance().convertString(condition.getSource().trim(), true));
            }
            if (condition.getBeginTime() != null) {
                hql.append(" and fault.modTime >= ?" + list.size());
                list.add(condition.getBeginTime());
            }
            if (condition.getEndTime() != null) {
                hql.append(" and fault.modTime <= ?" + list.size());
                list.add(condition.getEndTime());
            }
        }
    }

    @Override
    public Paging listFaultDetail(Long faultID, int start, int length) {
        Paging paging = new Paging();
        StringBuilder hql = new StringBuilder("from FaultDetail detail where detail.faultId=");
        StringBuilder countHql = new StringBuilder("select count(detail.id) from FaultDetail detail where detail.faultId=");
        hql.append(faultID).append(" order by detail.id desc");
        countHql.append(faultID);
        Session session = null;
        session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        Query q = session.createQuery(hql.toString());
        Long total = (Long)session.createQuery(countHql.toString()).uniqueResult();
        q.setFirstResult(start);
        q.setMaxResults(length);
        paging.setCount(total.intValue());
        paging.setData(q.list());
        return paging;
    }

    @Override
    public Fault getFault(Long id) {
        return (Fault)this.getHibernateTemplate().get(Fault.class, (Serializable)id);
    }

    @Override
    public boolean queryAndDeleteLog(int total, int limit) {
        String hql = "select count(* ) as rowCount from Fault";
        long count = this.getTotalCount(hql);
        if (count > (long)total) {
            this.deleteByTime(limit);
            return true;
        }
        return false;
    }

    private void deleteByTime(int limit) {
        String hql = "from Fault where (1=1) order by createTime asc";
        List list = this.findPage(hql, limit, 1);
        if (null != list && !list.isEmpty()) {
            String delHql2 = "delete from FaultDetail where faultId <= ?0";
            this.updateByHql(delHql2, new Object[]{((Fault)list.get(0)).getId()});
            String delHql = "delete from Fault where id <= ?0";
            this.updateByHql(delHql, new Object[]{((Fault)list.get(0)).getId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long createFault(Fault fault) {
        Object object = this.lock;
        synchronized (object) {
            Fault entity = this.getFault(fault);
            Long faultID = null;
            if (entity == null) {
                fault.setCount(1);
                faultID = (Long)this.getHibernateTemplate().save((Object)fault);
                fault.setId(faultID);
                this.faultStatisticDao.addFault(fault);
            } else {
                faultID = entity.getId();
                entity.setMoId(fault.getMoId());
                entity.setSource(fault.getSource());
                entity.setExtendMoId(fault.getExtendMoId());
                entity.setModTime(fault.getModTime());
                entity.setFaultParam(fault.getFaultParam());
                entity.setParamShaCode(fault.getParamShaCode());
                entity.setCount(entity.getCount() + 1);
                entity.setSeverity(fault.getSeverity());
                if (Fault.FaultClearStatus.CLEARED.getValue().equals(entity.getClearStatus())) {
                    this.faultStatisticDao.addFault(entity);
                } else {
                    this.faultStatisticDao.updateFault(entity);
                }
                entity.setConfirmStatus(Fault.FaultConfirmStatus.UNCONFIRMED.getValue());
                entity.setConfirmTime(null);
                entity.setConfirmUser(null);
                entity.setClearStatus(Fault.FaultClearStatus.UNCLEARED.getValue());
                entity.setClearTime(null);
                entity.setClearUser(null);
                this.getHibernateTemplate().merge((Object)entity);
                faultID = entity.getId();
            }
            FaultDetail detail = new FaultDetail();
            if (faultID == null) {
                detail.setCreateTime(fault.getCreateTime());
            } else {
                detail.setCreateTime(fault.getModTime());
            }
            detail.setFaultId(faultID);
            detail.setFaultParam(fault.getFaultParam());
            detail.setSeverity(fault.getSeverity().byteValue());
            this.getHibernateTemplate().save((Object)detail);
            return faultID;
        }
    }

    private Fault getFault(Fault fault) {
        List list = null;
        list = fault.getParamShaCode() == null ? this.getHibernateTemplate().find("from Fault fault where fault.faultDefineId=?0 and fault.sourceType=?1 and fault.moId=?2 and fault.paramShaCode is null", new Object[]{fault.getFaultDefineId(), fault.getSourceType(), fault.getMoId()}) : this.getHibernateTemplate().find("from Fault fault where fault.faultDefineId=?0 and fault.sourceType=?1 and fault.moId=?2 and fault.paramShaCode=?3", new Object[]{fault.getFaultDefineId(), fault.getSourceType(), fault.getMoId(), fault.getParamShaCode()});
        if (!list.isEmpty()) {
            return (Fault)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long restoreFault(Fault fault) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("zone Alarm1 restoreFault " + fault.toString()));
            Fault entity = this.getFault(fault);
            if (entity != null && !Fault.FaultClearStatus.CLEARED.getValue().equals(entity.getClearStatus())) {
                FaultDetail detail = this.getFaultDetail(entity.getId(), entity.getModTime());
                if (detail != null) {
                    detail.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
                    detail.setClearTime(fault.getClearTime());
                    detail.setClearUser("system");
                    this.getHibernateTemplate().merge((Object)detail);
                    entity.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
                    entity.setClearTime(fault.getClearTime());
                    entity.setClearUser("system");
                    entity.setFaultParam(fault.getFaultParam());
                    entity.setMoId(fault.getMoId());
                    entity.setSource(fault.getSource());
                    entity.setExtendMoId(fault.getExtendMoId());
                    entity.setSeverity(fault.getSeverity());
                    this.getHibernateTemplate().merge((Object)entity);
                    this.faultStatisticDao.clearFault(entity);
                }
                return entity.getId();
            }
            return null;
        }
    }

    private FaultDetail getFaultDetail(Long id, Date createTime) {
        List details = this.getHibernateTemplate().find("from FaultDetail detail where detail.faultId=?0 and detail.createTime=?1 order by detail.id desc", new Object[]{id, createTime});
        if (!details.isEmpty()) {
            return (FaultDetail)details.get(0);
        }
        return null;
    }

    @Override
    public String confirmFault(Long id, String confirmUser) {
        Fault fault = (Fault)this.getHibernateTemplate().get(Fault.class, (Serializable)id);
        if (fault == null) {
            throw new LegoCheckedException(1L);
        }
        Timestamp time = new Timestamp(System.currentTimeMillis());
        fault.setConfirmStatus(Fault.FaultConfirmStatus.CONFIRMED.getValue());
        fault.setConfirmTime(time);
        fault.setConfirmUser(confirmUser);
        FaultDetail detail = this.getFaultDetail(fault.getId(), fault.getModTime());
        if (detail == null) {
            throw new LegoCheckedException(603L);
        }
        detail.setConfirmStatus(Fault.FaultConfirmStatus.CONFIRMED.getValue());
        detail.setConfirmTime(time);
        detail.setConfirmUser(confirmUser);
        this.getHibernateTemplate().merge((Object)detail);
        this.getHibernateTemplate().merge((Object)fault);
        return fault.getFaultDefineId();
    }

    @Override
    public String cancelConfirmFault(Long id) {
        Fault fault = (Fault)this.getHibernateTemplate().get(Fault.class, (Serializable)id);
        if (fault == null) {
            throw new LegoCheckedException(1L);
        }
        fault.setConfirmStatus(Fault.FaultConfirmStatus.UNCONFIRMED.getValue());
        fault.setConfirmTime(null);
        fault.setConfirmUser(null);
        FaultDetail detail = this.getFaultDetail(fault.getId(), fault.getModTime());
        if (detail == null) {
            throw new LegoCheckedException(603L);
        }
        detail.setConfirmStatus(Fault.FaultConfirmStatus.UNCONFIRMED.getValue());
        detail.setConfirmTime(null);
        detail.setConfirmUser(null);
        this.getHibernateTemplate().merge((Object)detail);
        this.getHibernateTemplate().merge((Object)fault);
        return fault.getFaultDefineId();
    }

    @Override
    public String clearFault(Long id, String clearUser) {
        Fault fault = (Fault)this.getHibernateTemplate().get(Fault.class, (Serializable)id);
        if (fault == null) {
            throw new LegoCheckedException(1L);
        }
        Timestamp time = new Timestamp(System.currentTimeMillis());
        fault.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
        fault.setClearTime(time);
        fault.setClearUser(clearUser);
        FaultDetail detail = this.getFaultDetail(fault.getId(), fault.getModTime());
        if (detail == null) {
            throw new LegoCheckedException(603L);
        }
        detail.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
        detail.setClearTime(time);
        detail.setClearUser(clearUser);
        this.getHibernateTemplate().merge((Object)detail);
        this.getHibernateTemplate().merge((Object)fault);
        if (fault.getConfirmStatus().equals(Fault.FaultConfirmStatus.CONFIRMED.getValue())) {
            this.faultStatisticDao.clearFault(fault);
        }
        return fault.getFaultDefineId();
    }

    @Override
    public String confirmAndClearFault(Long id, String clearUser) {
        Fault fault = (Fault)this.getHibernateTemplate().get(Fault.class, (Serializable)id);
        if (fault == null) {
            throw new LegoCheckedException(1L);
        }
        Timestamp time = new Timestamp(System.currentTimeMillis());
        fault.setConfirmStatus(Fault.FaultConfirmStatus.CONFIRMED.getValue());
        fault.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
        fault.setClearTime(time);
        fault.setClearUser(clearUser);
        FaultDetail detail = this.getFaultDetail(fault.getId(), fault.getModTime());
        if (detail == null) {
            throw new LegoCheckedException(603L);
        }
        detail.setConfirmStatus(Fault.FaultConfirmStatus.CONFIRMED.getValue());
        detail.setConfirmTime(time);
        detail.setConfirmUser(clearUser);
        detail.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
        detail.setClearTime(time);
        detail.setClearUser(clearUser);
        this.getHibernateTemplate().merge((Object)detail);
        this.getHibernateTemplate().merge((Object)fault);
        this.faultStatisticDao.clearFault(fault);
        return fault.getFaultDefineId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllFault(String clearUser) {
        Object object = this.lock;
        synchronized (object) {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String hqlFault = "update Fault set clearStatus = 1, clearUser = ?0, clearTime = ?1 where clearStatus=0";
            String hqlFaultDetail = "update FaultDetail set clearStatus = 1, clearUser = ?0, clearTime = ?1 where clearStatus=0";
            this.getHibernateTemplate().bulkUpdate(hqlFault, new Object[]{clearUser, time});
            this.getHibernateTemplate().bulkUpdate(hqlFaultDetail, new Object[]{clearUser, time});
            this.faultStatisticDao.deleteAllFault();
        }
    }

    @Override
    public long[] getFaultStatistic() {
        long[] result = new long[]{(Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where (fault.clearStatus=0 or fault.confirmStatus=0) and fault.severity=1", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where (fault.clearStatus=0 or fault.confirmStatus=0) and fault.severity=2", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where (fault.clearStatus=0 or fault.confirmStatus=0) and fault.severity=3", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where (fault.clearStatus=0 or fault.confirmStatus=0) and fault.severity=4", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where fault.clearStatus=0 and fault.confirmStatus=0 and fault.severity=1", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where fault.clearStatus=0 and fault.confirmStatus=0 and fault.severity=2", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where fault.clearStatus=0 and fault.confirmStatus=0 and fault.severity=3", new Object[0]).get(0), (Long)this.getHibernateTemplate().find("select count(fault.id) from Fault fault where fault.clearStatus=0 and fault.confirmStatus=0 and fault.severity=4", new Object[0]).get(0)};
        return result;
    }

    @Override
    public void deleteFault(FaultQueryCondition condition) {
        StringBuffer hql = new StringBuffer("delete ");
        List<Object> list = this.getSql(condition, hql);
        this.setSqlAndParams(condition, hql, list);
        if (!list.isEmpty()) {
            this.getHibernateTemplate().bulkUpdate(hql.toString(), list.toArray());
        } else {
            this.getHibernateTemplate().bulkUpdate(hql.toString(), new Object[0]);
        }
    }

    @Override
    public TopoObject getTopoObjectById(long moId) {
        return (TopoObject)this.getHibernateTemplate().get(TopoObject.class, (Serializable)Long.valueOf(moId));
    }

    @Override
    public void deleteAllAlarmsByMoIds(List<Long> moIdList) {
        String moIds = "";
        if (null != moIdList && !moIdList.isEmpty()) {
            for (int i = 0; i < moIdList.size(); ++i) {
                moIds = 0 == i ? "'" + moIdList.get(i) + "'" : moIds + ",'" + moIdList.get(i) + "'";
            }
            String detailHql = "delete from FaultDetail where faultId in ( select id from Fault where (moId in (" + moIds + ")) or (extendMoId in (" + moIds + ")))";
            this.getHibernateTemplate().bulkUpdate(detailHql, new Object[0]);
            this.faultStatisticDao.deleteAllAlarmsByMoIds(moIds);
            String hql = "delete from Fault where (moId in (" + moIds + ")) or (extendMoId in (" + moIds + "))";
            this.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
        } else {
            this.logger.info((Object)"MO names is null or empty, no alarms need to be deleted.");
        }
    }

    @Override
    public Fault getCloudCleanFault(Long moId, String defineId) {
        String hql = "from Fault where moId = " + moId + " and faultDefineId = ?0 and clearStatus = '0'";
        List list = this.getHibernateTemplate().find(hql, new Object[]{defineId});
        if (null != list && !list.isEmpty()) {
            return (Fault)list.get(0);
        }
        return null;
    }

    @Override
    public long getAllFaultCount(FaultQueryCondition condition) {
        StringBuffer hql = new StringBuffer();
        List<Object> list = this.getSql(condition, hql);
        StringBuffer countSql = new StringBuffer("select count(*) " + hql.toString());
        this.setSqlAndParams(condition, countSql, list);
        if (condition.getSortField() == null && condition.getSortType() == null) {
            countSql.append(" order by fault.modTime desc");
        } else if (this.checkParams(condition.getSortField(), condition.getSortType())) {
            countSql.append(" order by fault.").append(condition.getSortField()).append(' ').append(condition.getSortType());
            if (!"ID".equals(condition.getSortField().toUpperCase(Locale.US))) {
                countSql.append(", fault.id desc");
            }
        }
        if (list.size() > 0) {
            return (Long)this.getHibernateTemplate().find(countSql.toString(), list.toArray()).get(0);
        }
        return (Long)this.getHibernateTemplate().find(countSql.toString(), new Object[0]).get(0);
    }

    @Override
    public List<Fault> queryFault(FaultQueryCondition condition, int start, int pageSize) {
        StringBuffer hql = new StringBuffer();
        List<Object> list = this.getSql(condition, hql);
        int listIndex = list.size();
        List<String> param = this.setSqlAndParamMap(condition, hql, listIndex);
        if (condition.getSortField() == null && condition.getSortType() == null) {
            hql.append(" order by fault.modTime desc");
        } else if (this.checkParams(condition.getSortField(), condition.getSortType())) {
            hql.append(" order by fault.").append(condition.getSortField()).append(' ').append(condition.getSortType());
            if (!"ID".equals(condition.getSortField().toUpperCase(Locale.US))) {
                hql.append(", fault.id desc");
            }
        }
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        int index = 0;
        for (Object object : list) {
            queryMap.put(index++, String.valueOf(object));
        }
        for (String string : param) {
            queryMap.put(index++, string);
        }
        if (queryMap.size() > 0) {
            return this.findPage(hql.toString(), start, pageSize, queryMap);
        }
        return this.findPage(hql.toString(), start, pageSize);
    }

    private List<String> setSqlAndParamMap(FaultQueryCondition condition, StringBuffer hql, int listIndex) {
        ArrayList<String> list = new ArrayList<String>();
        if (listIndex >= 0) {
            if (condition.getSource() != null) {
                hql.append(" and lower(fault.source) like lower(?" + listIndex++ + ")");
                list.add(ConverterUtil.getInstance().convertString(condition.getSource().trim(), true));
            }
            if (condition.getBeginTime() != null) {
                hql.append(" and fault.modTime >= ?" + listIndex++);
                list.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(condition.getBeginTime()));
            }
            if (condition.getEndTime() != null) {
                hql.append(" and fault.modTime <= ?" + listIndex++);
                list.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(condition.getEndTime()));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTransferFaultCount(FaultQueryCondition condition) {
        Integer count = 0;
        StringBuffer countSql = new StringBuffer();
        countSql.append("select count(*) ");
        List<Object> param = this.getSql(condition, countSql);
        if (condition.getBeginTime() != null) {
            countSql.append(" and fault.modTime >= ?" + param.size());
            param.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(condition.getBeginTime()));
        }
        if (condition.getEndTime() != null) {
            countSql.append(" and fault.modTime < ?" + param.size());
            param.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(condition.getEndTime()));
        }
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query query = session.createQuery(countSql.toString());
            for (int i = 0; i < param.size(); ++i) {
                query.setParameter(i, param.get(i));
            }
            List list = query.list();
            if (list.size() > 0) {
                count = Integer.valueOf(list.get(0).toString());
            }
        }
        finally {
            if (null != session) {
                session.close();
            }
        }
        return count;
    }

    private void isCurrentOrHistoryFault(FaultQueryCondition condition, StringBuilder hql) {
        if (condition.getFaultStatus() == 1) {
            if (condition.getConfirmStatus() == null) {
                hql.append("and (fault.confirmStatus =" + Fault.FaultConfirmStatus.UNCONFIRMED.getValue() + " or fault.clearStatus =" + Fault.FaultClearStatus.UNCLEARED.getValue() + ")");
            } else if (condition.getConfirmStatus().equals(Fault.FaultConfirmStatus.CONFIRMED.getValue())) {
                hql.append("and (fault.confirmStatus =" + condition.getConfirmStatus() + " and fault.clearStatus =" + Fault.FaultClearStatus.UNCLEARED.getValue() + ")");
            } else {
                hql.append("and fault.confirmStatus =" + condition.getConfirmStatus());
            }
        } else if (condition.getFaultStatus() == 2) {
            if (condition.getConfirmStatus() == null) {
                hql.append("and fault.confirmStatus =" + Fault.FaultConfirmStatus.CONFIRMED.getValue() + " and fault.clearStatus =" + Fault.FaultClearStatus.CLEARED.getValue());
            } else if (condition.getConfirmStatus().equals(Fault.FaultConfirmStatus.CONFIRMED.getValue())) {
                hql.append("and fault.confirmStatus =" + Fault.FaultConfirmStatus.CONFIRMED.getValue() + " and fault.clearStatus =" + Fault.FaultClearStatus.CLEARED.getValue());
            } else {
                int b = 5;
                hql.append("and fault.confirmStatus =" + b + " and fault.clearStatus =" + Fault.FaultClearStatus.CLEARED.getValue());
            }
        } else {
            if (condition.getConfirmStatus() != null) {
                hql.append("and fault.confirmStatus =" + condition.getConfirmStatus());
            }
            if (condition.getClearStatus() != null) {
                hql.append("and fault.clearStatus =" + condition.getClearStatus());
            }
        }
    }

    private void judgeSortFieldAndType(FaultQueryCondition condition, StringBuilder hql) {
        if (condition.getSortField() == null && condition.getSortType() == null) {
            hql.append(" order by fault.id desc");
        } else {
            hql.append(" order by fault.").append(condition.getSortField()).append(' ').append(condition.getSortType());
            if (!"ID".equals(condition.getSortField().toUpperCase(Locale.US))) {
                hql.append(", fault.id desc");
            }
        }
    }

    @Override
    public List<Fault> listTransferFault(FaultQueryCondition condition) {
        String formatted;
        SimpleDateFormat formater;
        StringBuilder hql = new StringBuilder("from Fault fault where 1=1 ");
        this.isCurrentOrHistoryFault(condition, hql);
        if (condition.getBeginTime() != null) {
            formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatted = formater.format(condition.getBeginTime());
            hql.append(" and fault.modTime >= '" + formatted + "' ");
        }
        if (condition.getEndTime() != null) {
            formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatted = formater.format(condition.getEndTime());
            hql.append(" and fault.modTime <'" + formatted + "' ");
        }
        this.judgeSortFieldAndType(condition, hql);
        String querySql = hql.toString();
        int index = condition.getFromIndex();
        int count = condition.getQueryStep();
        List list = (List)this.getHibernateTemplate().execute((HibernateCallback)new FaultHibernateCallback(count, index, querySql));
        return list;
    }

    @Override
    public void dumpCurrentAlarmToHistory(int dumpSum) {
        this.getHibernateTemplate().execute((HibernateCallback)new DumpFaultHibernateCallback(dumpSum));
    }

    @Override
    public long getCurrentAlarmTotalCount() {
        String hql = "SELECT count(*) FROM Fault fault WHERE (fault.confirmStatus =" + Fault.FaultConfirmStatus.UNCONFIRMED.getValue() + " or fault.clearStatus =" + Fault.FaultClearStatus.UNCLEARED.getValue() + ")";
        return super.getTotalCount(hql);
    }

    static class DumpFaultHibernateCallback
    implements HibernateCallback {
        private Integer sum;

        public DumpFaultHibernateCallback(Integer dumpSum) {
            this.sum = dumpSum;
        }

        public Object doInHibernate(Session session) {
            NativeQuery query = session.createSQLQuery("{call lego.currentFaultDump(?0)}");
            query.setInteger(0, this.sum.intValue());
            query.list();
            return null;
        }
    }

    static class FaultHibernateCallback
    implements HibernateCallback {
        private int count = 0;
        private int index = 0;
        private String querySql = "";

        public FaultHibernateCallback(int all, int start, String sql) {
            this.count = all;
            this.index = start;
            this.querySql = sql;
        }

        public Object doInHibernate(Session session) {
            List result = null;
            result = this.count > 0 ? session.createQuery(this.querySql).setFirstResult(this.index).setMaxResults(this.count).list() : session.createQuery(this.querySql).list();
            return result;
        }
    }
}

