/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.dao.impl;

import com.hs.lego.cbb.fault.dao.NotifyDao;
import com.hs.lego.cbb.fault.sdk.model.NotifyRule;
import com.hs.lego.cbb.fault.sdk.model.NotifyRuleDetail;
import com.hs.lego.cbb.fault.sdk.model.NotifyRuleQueryCondition;
import com.hs.lego.core.sdk.comm.Paging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class NotifyDaoImpl
extends HibernateDaoSupport
implements NotifyDao {
    @Override
    public Paging listNotifyRule(NotifyRuleQueryCondition condition) {
        StringBuilder hql = new StringBuilder("from NotifyRule rule");
        String countHql = "select count(rule.id) " + hql.toString();
        if (condition.getSortField() == null && condition.getSortType() == null) {
            hql.append(" order by rule.id desc");
        } else if (this.checkParams(condition.getSortField(), condition.getSortType())) {
            hql.append(" order by rule.").append(condition.getSortField()).append(' ').append(condition.getSortType());
            if (!"ID".equals(condition.getSortField().toUpperCase(Locale.US))) {
                hql.append(", rule.id desc");
            }
        }
        Paging paging = new Paging();
        Session session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        Query countQuery = session.createQuery(countHql);
        Query q = session.createQuery(hql.toString());
        Long total = (Long)countQuery.uniqueResult();
        q.setFirstResult(condition.getStart().intValue());
        q.setMaxResults(condition.getPageSize().intValue());
        paging.setCount(total.intValue());
        paging.setData(q.list());
        return paging;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return null != type && null != name && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    @Override
    public NotifyRule getNotifyRule(Long id) {
        NotifyRule rule = (NotifyRule)this.getHibernateTemplate().get(NotifyRule.class, (Serializable)id);
        List faultIds = this.getHibernateTemplate().find("select detail.faultDefineId from NotifyRuleDetail detail where detail.ruleId=?0", new Object[]{id});
        if (null != rule) {
            rule.setFaultIds(faultIds);
        }
        return rule;
    }

    @Override
    public List<NotifyRule> getEnableNotifyRule() {
        List list = this.getHibernateTemplate().find("from NotifyRule rule where rule.status=" + NotifyRule.NotifyRuleStatus.ENABLED.getValue(), new Object[0]);
        for (NotifyRule rule : list) {
            List faultIds = this.getHibernateTemplate().find("select detail.faultDefineId from NotifyRuleDetail detail where detail.ruleId=?0", new Object[]{rule.getId()});
            rule.setFaultIds(faultIds);
        }
        return list;
    }

    @Override
    public void addNotifyRule(NotifyRule rule) {
        NotifyRule entity = (NotifyRule)this.getHibernateTemplate().merge((Object)rule);
        rule.setId(entity.getId());
        for (String faultId : rule.getFaultIds()) {
            NotifyRuleDetail detail = new NotifyRuleDetail();
            detail.setFaultDefineId(faultId);
            detail.setRuleId(entity.getId());
            this.getHibernateTemplate().save((Object)detail);
        }
    }

    @Override
    public void updateNotifyRule(NotifyRule rule) {
        NotifyRule entity = (NotifyRule)this.getHibernateTemplate().get(NotifyRule.class, (Serializable)rule.getId());
        List details = this.getHibernateTemplate().find("from NotifyRuleDetail detail where detail.ruleId=?0", new Object[]{rule.getId()});
        ArrayList<NotifyRuleDetail> delete = new ArrayList<NotifyRuleDetail>();
        for (NotifyRuleDetail detail : details) {
            if (rule.getFaultIds().contains(detail.getFaultDefineId())) continue;
            delete.add(detail);
        }
        ArrayList<NotifyRuleDetail> add = new ArrayList<NotifyRuleDetail>();
        for (String faultId : rule.getFaultIds()) {
            NotifyRuleDetail detail = new NotifyRuleDetail();
            detail.setFaultDefineId(faultId);
            if (details.contains(detail)) continue;
            detail.setRuleId(rule.getId());
            add.add(detail);
        }
        for (NotifyRuleDetail detail : delete) {
            this.getHibernateTemplate().delete((Object)detail);
        }
        for (NotifyRuleDetail detail : add) {
            this.getHibernateTemplate().save((Object)detail);
        }
        if (null != entity) {
            rule.setStatus(entity.getStatus());
        }
        this.getHibernateTemplate().merge((Object)rule);
    }

    @Override
    public String deleteNotifyRule(Long id) {
        NotifyRule rule = (NotifyRule)this.getHibernateTemplate().get(NotifyRule.class, (Serializable)id);
        if (null == rule) {
            return "";
        }
        String ruleName = rule.getRuleName();
        this.getHibernateTemplate().delete((Object)rule);
        return ruleName;
    }

    @Override
    public String updateStatus(Long id, Byte status) {
        NotifyRule rule = (NotifyRule)this.getHibernateTemplate().get(NotifyRule.class, (Serializable)id);
        if (null == rule) {
            return "";
        }
        rule.setStatus(status);
        this.getHibernateTemplate().merge((Object)rule);
        return rule.getRuleName();
    }
}

