/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.dao.impl;

import com.hs.lego.cbb.fault.dao.IRemoteNotifyRuleDao;
import com.hs.lego.cbb.fault.util.FaultConverter;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtectorWrapper;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.hs.lego.nem.fault.sdk.model.NotifyResItem;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyRule;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class RemoteNotifyRuleDaoImpl
extends HibernateDaoSupport
implements IRemoteNotifyRuleDao {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    @Override
    public String addRule(RemoteNotifyRule remoteNotifyRule) {
        List<RemoteNotifyRule> ruleList = this.getRuleByName(remoteNotifyRule.getRuleName());
        if (null != ruleList && !ruleList.isEmpty()) {
            throw new LegoCheckedException(1556L);
        }
        long ruleId = 0L;
        try {
            for (NotifyResItem notifyResItem : remoteNotifyRule.getNotifyResItems()) {
                notifyResItem.setRemoteNotifyRule(remoteNotifyRule);
                this.getHibernateTemplate().saveOrUpdate((Object)notifyResItem);
            }
            for (NotifyAlarmItem notifyAlarmItem : remoteNotifyRule.getNotifyAlarmItems()) {
                notifyAlarmItem.setRemoteNotifyRule(remoteNotifyRule);
                this.getHibernateTemplate().saveOrUpdate((Object)notifyAlarmItem);
            }
            ruleId = (Long)this.getHibernateTemplate().save((Object)remoteNotifyRule);
        }
        catch (Exception e) {
            this.logger.error((Object)("delete notify rule exception." + e.getMessage()));
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return String.valueOf(ruleId);
    }

    @Override
    public boolean deleteRule(RemoteNotifyRule remoteNotifyRule) {
        try {
            String delHql = "delete from NotifyResItem where remoteNotifyRule.id = ?0";
            this.getHibernateTemplate().bulkUpdate(delHql, new Object[]{remoteNotifyRule.getId()});
            String delHql1 = "delete from NotifyAlarmItem where remoteNotifyRule.id = ?0";
            this.getHibernateTemplate().bulkUpdate(delHql1, new Object[]{remoteNotifyRule.getId()});
            String delHql2 = "delete from RemoteNotifyRule where id = ?0";
            this.getHibernateTemplate().bulkUpdate(delHql2, new Object[]{remoteNotifyRule.getId()});
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("delete notify rule exception.id is " + remoteNotifyRule.getId()));
        }
        return true;
    }

    @Override
    public RemoteNotifyRule getRuleByID(String ruleId) {
        long id = Integer.parseInt(ruleId);
        RemoteNotifyRule remoteNotifyRule = (RemoteNotifyRule)super.getHibernateTemplate().get(RemoteNotifyRule.class, (Serializable)Long.valueOf(id));
        if (remoteNotifyRule == null) {
            throw new LegoCheckedException(1547L);
        }
        long currentTime = System.currentTimeMillis();
        if (remoteNotifyRule.isIsUseEnable() && currentTime >= remoteNotifyRule.getStartTime() && currentTime <= remoteNotifyRule.getEndTime()) {
            remoteNotifyRule.setValidStatus(true);
        } else {
            remoteNotifyRule.setValidStatus(false);
        }
        if (currentTime > remoteNotifyRule.getEndTime()) {
            remoteNotifyRule.setExpiredStatus(true);
        } else {
            remoteNotifyRule.setExpiredStatus(false);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        remoteNotifyRule.setStartTimeStr(sdf.format(remoteNotifyRule.getStartTime()));
        remoteNotifyRule.setEndTimeStr(sdf.format(remoteNotifyRule.getEndTime()));
        String decryptedEmails = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getEmailTo());
        remoteNotifyRule.setEmailTo(decryptedEmails);
        String decryptedPhones = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getSmsPhone());
        remoteNotifyRule.setSmsPhone(decryptedPhones);
        return remoteNotifyRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getRuleAndCountByCondition(Map<String, Object> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Paging roPaging = new Paging();
        Session session = null;
        try {
            List ruleList;
            session = this.getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(RemoteNotifyRule.class);
            Criteria resCriteria = session.createCriteria(NotifyResItem.class);
            this.processCriteria(firstRowIndex, totalRow, orderByField, orderByAscend, criteria);
            if (null == condition || condition.isEmpty()) {
                ruleList = criteria.list();
            } else {
                this.getRuleByCondition(condition, criteria, resCriteria);
                ruleList = criteria.list();
            }
            this.processRuleList(ruleList);
            roPaging.setData(ruleList);
            Criteria criteria2 = session.createCriteria(RemoteNotifyRule.class);
            Criteria resCriteria2 = session.createCriteria(NotifyResItem.class);
            this.getRuleByCondition(condition, criteria2, resCriteria2);
            criteria2.setProjection(Projections.rowCount());
            int size = ((Long)criteria2.list().get(0)).intValue();
            roPaging.setCount(size);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("query notify rule exception,condition is " + condition.toString()));
        }
        finally {
            if (null != session) {
                try {
                    session.close();
                }
                catch (HibernateException e) {
                    this.logger.error((Object)e.getMessage());
                }
            }
        }
        return roPaging;
    }

    private void processCriteria(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, Criteria criteria) {
        String s = "id";
        if (firstRowIndex >= 0) {
            criteria.setFirstResult(firstRowIndex);
        }
        if (totalRow >= 0) {
            criteria.setMaxResults(totalRow);
        }
        if (orderByAscend) {
            criteria.addOrder(Order.asc((String)orderByField));
        } else {
            criteria.addOrder(Order.desc((String)orderByField));
        }
        criteria.addOrder(Order.asc((String)s));
    }

    private void processRuleList(List<RemoteNotifyRule> ruleList) {
        if (null == ruleList) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (RemoteNotifyRule remoteNotifyRule : ruleList) {
            long currentTime = System.currentTimeMillis();
            if (remoteNotifyRule.isIsUseEnable() && currentTime >= remoteNotifyRule.getStartTime() && currentTime <= remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setValidStatus(true);
            } else {
                remoteNotifyRule.setValidStatus(false);
            }
            if (currentTime > remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setExpiredStatus(true);
            } else {
                remoteNotifyRule.setExpiredStatus(false);
            }
            remoteNotifyRule.setStartTimeStr(sdf.format(remoteNotifyRule.getStartTime()));
            remoteNotifyRule.setEndTimeStr(sdf.format(remoteNotifyRule.getEndTime()));
            String decryptedEmails = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getEmailTo());
            remoteNotifyRule.setEmailTo(decryptedEmails);
            String decryptedPhones = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getSmsPhone());
            remoteNotifyRule.setSmsPhone(decryptedPhones);
        }
    }

    private void getRuleByCondition(Map<String, Object> condition, Criteria criteria, Criteria resCriteria) {
        if (condition != null) {
            String userName;
            String resName;
            String ruleName;
            String ruleId = (String)condition.get("id");
            if (null != ruleId && !"".equals(ruleId.trim())) {
                criteria.add((Criterion)Restrictions.eq((String)"id", (Object)Long.valueOf(ruleId)));
            }
            if (null != (ruleName = (String)condition.get("ruleName")) && !"".equals(ruleName.trim())) {
                String destString = FaultConverter.convertString(ruleName.trim());
                criteria.add(Restrictions.ilike((String)"ruleName", (Object)destString));
            }
            if (null != (resName = (String)condition.get("moName")) && !"".equals(resName.trim())) {
                String destString = FaultConverter.convertString(resName.trim());
                resCriteria.add(Restrictions.ilike((String)"moName", (Object)destString));
                List resList = resCriteria.list();
                HashSet<Long> rule = new HashSet<Long>();
                rule.add(0L);
                for (NotifyResItem res : resList) {
                    rule.add(res.getRemoteNotifyRule().getId());
                }
                criteria.add(Restrictions.in((String)"id", rule));
            }
            if (null != (userName = (String)condition.get("userName")) && !"".equals(userName.trim())) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"userName", (Object)userName), (Criterion)Restrictions.isNull((String)"userName")));
            }
        }
    }

    @Override
    public boolean modifyBaseRule(RemoteNotifyRule remoteNotifyRule) {
        super.getHibernateTemplate().saveOrUpdate((Object)remoteNotifyRule);
        return true;
    }

    @Override
    public boolean addAlarm(Set<NotifyAlarmItem> alarmSet) {
        for (NotifyAlarmItem notifyAlarmItem : alarmSet) {
            super.getHibernateTemplate().saveOrUpdate((Object)notifyAlarmItem);
        }
        return true;
    }

    @Override
    public boolean addResource(Set<NotifyResItem> resSet) {
        for (NotifyResItem notifyResItem : resSet) {
            super.getHibernateTemplate().saveOrUpdate((Object)notifyResItem);
        }
        return true;
    }

    @Override
    public boolean deleteAlarmItem(NotifyAlarmItem notifyAlarmItem) {
        super.getHibernateTemplate().delete((Object)notifyAlarmItem);
        return true;
    }

    @Override
    public boolean deleteResourceItem(NotifyResItem notifyResItem) {
        super.getHibernateTemplate().delete((Object)notifyResItem);
        return true;
    }

    @Override
    public List<NotifyResItem> getResourceItem(String alarmSource) {
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(NotifyResItem.class);
            criteria.add((Criterion)Restrictions.eq((String)"alarmSource", (Object)alarmSource));
            return criteria.list();
        }
        catch (Exception e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    @Override
    public boolean deleteResourceItems(List<NotifyResItem> resList) {
        super.getHibernateTemplate().deleteAll(resList);
        return true;
    }

    @Override
    public NotifyAlarmItem getAlarmItem(long id) {
        return (NotifyAlarmItem)super.getHibernateTemplate().get(NotifyAlarmItem.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public NotifyResItem getResourceItem(long id) {
        return (NotifyResItem)super.getHibernateTemplate().get(NotifyResItem.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public Paging queryAlarmItem(String ruleId, String alarmLevel, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Session session = null;
        Paging roPaging = new Paging();
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(NotifyAlarmItem.class);
            Criteria criteria2 = session.createCriteria(NotifyAlarmItem.class);
            this.processCriteria(firstRowIndex, totalRow, orderByField, orderByAscend, criteria);
            if (null != alarmLevel && !"".equals(alarmLevel) && !"0".equals(alarmLevel)) {
                criteria.add((Criterion)Restrictions.eq((String)"alarmLevel", (Object)Integer.parseInt(alarmLevel)));
                criteria2.add((Criterion)Restrictions.eq((String)"alarmLevel", (Object)Integer.parseInt(alarmLevel)));
            }
            criteria.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)Long.valueOf(ruleId)));
            List alarmList = criteria.list();
            roPaging.setData(alarmList);
            criteria2.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)Long.valueOf(ruleId)));
            criteria2.setProjection(Projections.rowCount());
            int size = ((Long)criteria2.list().get(0)).intValue();
            roPaging.setCount(size);
        }
        catch (Exception e) {
            this.logger.error((Object)("query shield alarm exception, alarm level is : " + alarmLevel + ". " + e.getMessage()));
        }
        return roPaging;
    }

    @Override
    public Paging queryResourceItem(String ruleId, String name, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, List<String> moIdList) {
        Session session = null;
        Paging roPaging = new Paging();
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(NotifyResItem.class);
            this.processCriteria(firstRowIndex, totalRow, orderByField, orderByAscend, criteria);
            if (null == name) {
                name = "";
            }
            String destString = FaultConverter.convertString(name.trim());
            criteria.add(Restrictions.ilike((String)"moName", (Object)destString));
            criteria.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)Long.valueOf(ruleId)));
            List alarmList = criteria.list();
            roPaging.setData(alarmList);
            Criteria criteria2 = session.createCriteria(NotifyResItem.class);
            criteria2.add(Restrictions.ilike((String)"moName", (Object)destString));
            criteria2.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)Long.valueOf(ruleId)));
            criteria2.setProjection(Projections.rowCount());
            int size = ((Long)criteria2.list().get(0)).intValue();
            roPaging.setCount(size);
        }
        catch (Exception e) {
            this.logger.error((Object)("query shield alarm exception, alarm name is : " + name + ". " + e.getMessage()));
        }
        return roPaging;
    }

    @Override
    public Paging queryResourceItem(String ruleId, String name, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        Session session = null;
        Paging roPaging = new Paging();
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            StringBuffer order = new StringBuffer();
            if (this.checkParams(orderByField)) {
                if (orderByAscend) {
                    order.append(" order by ");
                    order.append(orderByField);
                    order.append(" asc,res.id asc");
                } else {
                    order.append(" order by ");
                    order.append(orderByField);
                    order.append(" desc,res.id desc");
                }
            }
            StringBuffer buffer = new StringBuffer("from ");
            buffer.append(NotifyResItem.class.getName());
            buffer.append(" as res,");
            buffer.append(CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
            buffer.append(" where (res.alarmSource=");
            buffer.append(CheckChildrenMoUtil.getInstanse().getGrantHql(userId));
            buffer.append(" or res.remoteNotifyRule.moMainType='lego.dic.legosystem.maintype'");
            buffer.append(") and ");
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            if (null == name) {
                name = "";
            }
            String destString = FaultConverter.convertString(name.trim());
            buffer.append("lower(res.moName) like lower(?0) and ");
            param.put(0, destString);
            buffer.append("res.remoteNotifyRule.id= ?1 ");
            param.put(1, ruleId);
            Query queryRes = session.createQuery("select distinct res " + buffer.toString() + order);
            queryRes.setLockMode("res", LockMode.NONE);
            Set entrys = param.entrySet();
            for (Map.Entry entry : entrys) {
                queryRes.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            if (firstRowIndex >= 0) {
                queryRes.setFirstResult(firstRowIndex);
            }
            if (totalRow >= 0) {
                queryRes.setMaxResults(totalRow);
            }
            List alarmList = queryRes.list();
            roPaging.setData(alarmList);
            roPaging.setCount(alarmList.size());
        }
        catch (HibernateException e) {
            this.logger.error((Object)("query shield alarm exception, alarm name is : " + name + ". " + e.getMessage()));
        }
        return roPaging;
    }

    private boolean checkParams(String name) {
        String regular;
        return null != name && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name);
    }

    @Override
    public int updateResourceIp(String ip, long moId) throws Exception {
        Session session = null;
        session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        StringBuffer hql = new StringBuffer();
        hql.append("update NotifyResItem set moIp = ?0 ");
        hql.append(" where alarmSource = '");
        hql.append(moId);
        hql.append("'");
        Query query = session.createQuery(hql.toString());
        query.setString(0, ip);
        return query.executeUpdate();
    }

    @Override
    public boolean isExistRuleName(String ruleName) {
        List<RemoteNotifyRule> ruleList = this.getRuleByName(ruleName);
        return null != ruleList && !ruleList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteNotifyRule getRuleByRuleName(String ruleName) {
        if (null == ruleName) {
            return null;
        }
        try (Session session = null;){
            session = this.getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(RemoteNotifyRule.class);
            criteria.add((Criterion)Restrictions.eq((String)"ruleName", (Object)ruleName));
            List ruleList = criteria.list();
            if (null == ruleList || ruleList.isEmpty()) {
                RemoteNotifyRule remoteNotifyRule = null;
                return remoteNotifyRule;
            }
            RemoteNotifyRule remoteNotifyRule = (RemoteNotifyRule)ruleList.get(0);
            long currentTime = System.currentTimeMillis();
            if (remoteNotifyRule.isIsUseEnable() && currentTime >= remoteNotifyRule.getStartTime() && currentTime <= remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setValidStatus(true);
            } else {
                remoteNotifyRule.setValidStatus(false);
            }
            if (currentTime > remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setExpiredStatus(true);
            } else {
                remoteNotifyRule.setExpiredStatus(false);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            remoteNotifyRule.setStartTimeStr(sdf.format(remoteNotifyRule.getStartTime()));
            remoteNotifyRule.setEndTimeStr(sdf.format(remoteNotifyRule.getEndTime()));
            String decryptedEmails = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getEmailTo());
            remoteNotifyRule.setEmailTo(decryptedEmails);
            String decryptedPhones = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getSmsPhone());
            remoteNotifyRule.setSmsPhone(decryptedPhones);
            RemoteNotifyRule remoteNotifyRule2 = remoteNotifyRule;
            return remoteNotifyRule2;
        }
    }

    private List<RemoteNotifyRule> getRuleByName(String ruleName) {
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(RemoteNotifyRule.class);
            if (null != ruleName && !"".equals(ruleName.trim())) {
                criteria.add((Criterion)Restrictions.eq((String)"ruleName", (Object)ruleName));
            }
            return criteria.list();
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }
}

