/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.dao.FaultDao;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.file.util.FileFactory;
import com.hs.lego.core.sdk.file.util.FileUtil;
import com.hs.lego.core.sdk.file.util.FileZip;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LogStorageUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.nem.fault.sdk.service.IFaultBackupService;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class FaultBackupServiceImpl
implements IFaultBackupService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final int MAX_NUM = 50000;
    private static final int MIN_USE_MEMORY = 50;
    private static final int NUM_1024 = 1024;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
    private static final SimpleDateFormat DATE_FORMAT2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private FaultDao faultDao;
    private I18nMrg i18nMgr;
    private ITaskService taskService;
    private ICommonDao commDao;
    private final Object lock = new Object();

    private void judgingCapacity() {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, "alarm_bk");
        String hql = "FROM Task WHERE taskType=?0";
        List list = this.commDao.findByHql(hql, param);
        if (null == list || list.isEmpty()) {
            return;
        }
        Task task = (Task)list.get(0);
        if (this.commDao.getTotalCount("SELECT COUNT(*) FROM TaskResult WHERE taskId=" + task.getTaskId()) >= 1000L) {
            BatchOperation batchope;
            int i;
            List resultId = this.commDao.findByHql("SELECT t.resultId FROM TaskResult t WHERE taskId=" + task.getTaskId() + " ORDER BY t.resultId ASC");
            List resultLink = this.commDao.findByHql("SELECT t.resultLink FROM TaskResult t WHERE taskId=" + task.getTaskId() + " ORDER BY t.resultLink ASC");
            ArrayList<BatchOperation> bathOprLst = null;
            bathOprLst = new ArrayList<BatchOperation>();
            for (i = 0; i < 100; ++i) {
                batchope = new BatchOperation();
                batchope.setTargetId(((Long)resultId.get(i)).longValue());
                bathOprLst.add(batchope);
            }
            this.taskService.deleteTaskResultList(bathOprLst, 2);
            bathOprLst = new ArrayList();
            for (i = 0; i < 100; ++i) {
                batchope = new BatchOperation();
                batchope.setTargetName((String)resultLink.get(i));
                bathOprLst.add(batchope);
            }
            this.taskService.deleteFile(1, bathOprLst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transferAlarm(String fileType, long endTime, String lang) {
        Object object = this.lock;
        synchronized (object) {
            this.judgingCapacity();
            Locale locale = null;
            String charSet = null;
            if ("en".equals(lang)) {
                locale = new Locale(lang);
                charSet = "UTF-8";
            } else {
                locale = new Locale("zh", "CN");
                charSet = "GBK";
            }
            Date endDate = new Date(endTime);
            LOGGER.info((Object)("start to backup alarm, endTime: " + endDate + ", time value: " + endTime));
            FaultQueryCondition condition = new FaultQueryCondition();
            condition.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
            condition.setEndTime(endDate);
            condition.setUserID(1L);
            long totalNum = this.faultDao.getAllFaultCount(condition);
            LOGGER.info((Object)("alarm data transfer totalNum:" + totalNum));
            if (totalNum <= 0L) {
                this.writeOptLogNoFile();
                return "lego.dic.warningaralm.noexist";
            }
            String pathName = DATE_FORMAT.format(new Date());
            String transferPath = LogStorageUtil.getDumpPathByDateType((String)"alarm_bk");
            File transferFile = new File(transferPath);
            this.mkdirFailed(transferFile);
            LOGGER.info((Object)("transferPath,fileName " + transferFile.getName()));
            List<String> title = this.getColumn(locale);
            File currentDir = new File(transferPath + File.separator + pathName);
            this.mkdirFailed(currentDir);
            String filePathName = null;
            try {
                filePathName = currentDir.getCanonicalPath() + File.separator + "alarm_" + pathName;
            }
            catch (IOException e) {
                LOGGER.error((Object)"getCanonicalPath() throws IOException");
            }
            long totalPageNum = totalNum / 50000L + 1L;
            int i = 0;
            while ((long)i < totalPageNum) {
                condition.setStart(i * 50000);
                condition.setPageSize(50000);
                if (!this.hasEnoughMemory()) {
                    return "";
                }
                Paging pageData = this.faultDao.listFault(condition);
                List tempList = pageData.getData();
                if (tempList == null || tempList.isEmpty()) break;
                ArrayList<List<String>> faultInfo = new ArrayList<List<String>>();
                for (Fault fault : tempList) {
                    faultInfo.add(this.convertFaultContent(fault, locale));
                }
                this.writeFile(fileType, filePathName + i, charSet, title, faultInfo);
                ++i;
            }
            try {
                FileZip.zip((String)(transferPath + File.separator + pathName), (String)(transferPath + File.separator + pathName + ".zip"), (String)pathName);
                FileZip.getInstance().deleteFile(currentDir);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"transferAlarm zip file error");
            }
            this.faultDao.deleteFault(condition);
            Object object2 = this.lock;
            synchronized (object2) {
                String[] para = new String[]{DATE_FORMAT2.format(new Date(endTime)), String.valueOf(totalNum), pathName + ".zip"};
                this.writeOptLog(para);
            }
            LOGGER.info((Object)"fault back up success.");
            return pathName + ".zip";
        }
    }

    private void writeOptLogNoFile() {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.event");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDetail("lego.dic.warningaralm.noexist");
        oOptLog.setDate(new Date());
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.event");
        oOptLog.setResult(1);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        ServiceContext context = ServiceContext.getInstance();
        ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
        if (null != sysOptLog) {
            sysOptLog.writeOptLog(oOptLog);
        }
    }

    private boolean hasEnoughMemory() {
        long usableMemory = this.getUsableMemory();
        if (usableMemory > 50L) {
            LOGGER.info((Object)("alarm transferAlarm has EnoughMemory,usableMemory:" + usableMemory + " M."));
            return true;
        }
        LOGGER.error((Object)("alarm transferAlarm has no EnoughMemory,usableMemory:" + usableMemory + " M."));
        return false;
    }

    private long getUsableMemory() {
        Runtime run = Runtime.getRuntime();
        long max = run.maxMemory();
        long total = run.totalMemory();
        long free = run.freeMemory();
        long usable = max - total + free;
        return usable / 0x100000L;
    }

    private void mkdirFailed(File file) {
        if (!file.isDirectory() && !file.mkdirs()) {
            LOGGER.error((Object)"currentDir.mkdirs() failed.");
        }
    }

    private void writeFile(String fileType, String filePath, String charSet, List<String> title, List<List<String>> faultInfo) {
        try {
            FileUtil fileUtil = FileFactory.getFileUtil((String)fileType);
            if (null != fileUtil) {
                fileUtil.fileSet("", title, filePath);
                fileUtil.setStrChar(charSet);
                fileUtil.writeFile(faultInfo);
                fileUtil.closeFile();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"write file error in transferAlarm");
        }
    }

    private void writeOptLog(String[] para) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.event");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.ver.storage.event");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.event");
        oOptLog.setResult(1);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        oOptLog.setDetailPara(para);
        ServiceContext context = ServiceContext.getInstance();
        ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
        if (null != sysOptLog) {
            sysOptLog.writeOptLog(oOptLog);
        }
    }

    @Override
    public void transferEvent(String fileType, long endTime, String lang, String filePath, File tempFileDir) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> convertFaultContent(Fault fault, Locale locale) {
        ArrayList<String> tempLst = new ArrayList<String>();
        tempLst.add(this.i18nMgr.getString("lego.lab.fault.severity." + fault.getSeverity(), locale));
        tempLst.add(this.i18nMgr.getString("lego.lab.fault.confirmStatus." + fault.getConfirmStatus(), locale));
        tempLst.add(this.i18nMgr.getString(fault.getFaultDefineId() + ".alarm.name", locale));
        tempLst.add(this.i18nMgr.getString("lego.lab.fault.sourceType." + fault.getSourceType(), locale));
        tempLst.add(fault.getCount().toString());
        tempLst.add(fault.getSource());
        Object object = this.lock;
        synchronized (object) {
            tempLst.add(DATE_FORMAT2.format(fault.getCreateTime()));
            tempLst.add(DATE_FORMAT2.format(fault.getModTime()));
            tempLst.add(DATE_FORMAT2.format(fault.getClearTime()));
        }
        Object[] param = fault.getFaultParamArray();
        for (int i = 0; i < param.length; ++i) {
            if (!param[i].contains(".")) continue;
            param[i] = this.i18nMgr.getString(param[i], locale);
        }
        if (param.length > 0) {
            String tmpDesc = this.i18nMgr.getString(fault.getFaultDefineId() + ".alarm.desc", locale);
            tmpDesc = MessageFormat.format(tmpDesc, param);
            if (param.length > 11 && null != param[11] && ("-".equals(param[11]) || ((String)param[11]).matches("\\d*"))) {
                if ((param.length - 8) % 5 == 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(tmpDesc);
                    for (int j = 0; j < (param.length - 8) / 5; ++j) {
                        String attackDesc = this.i18nMgr.getString("0x0000000803240801.alarm.attack.detail.desc", locale);
                        if (AticUtil.getText((String)"com.hs.atic.alart.attack.attackType.67").equals(param[8 + j * 5]) && !"-".equals(param[12 + j * 5])) {
                            param[12 + j * 5] = FaultDefineUtil.getInstance().getLocationName((String)param[12 + j * 5]);
                        }
                        attackDesc = attackDesc.replace("{0}", (CharSequence)param[8 + j * 5]);
                        attackDesc = attackDesc.replace("{1}", (CharSequence)param[9 + j * 5]);
                        attackDesc = attackDesc.replace("{2}", (CharSequence)param[10 + j * 5]);
                        attackDesc = attackDesc.replace("{3}", (CharSequence)param[11 + j * 5]);
                        attackDesc = attackDesc.replace("{4}", (CharSequence)param[12 + j * 5]);
                        buf.append(attackDesc);
                    }
                    tmpDesc = buf.toString();
                }
            } else if ((param.length - 8) % 3 == 0) {
                StringBuffer buf = new StringBuffer();
                buf.append(tmpDesc);
                for (int j = 0; j < (param.length - 8) / 3; ++j) {
                    String attackDesc = this.i18nMgr.getString("0x0000000803240801.alarm.attack.detail.desc", locale);
                    attackDesc = attackDesc.replace("{0}", (CharSequence)param[8 + j * 3]);
                    attackDesc = attackDesc.replace("{1}", (CharSequence)param[9 + j * 3]);
                    attackDesc = attackDesc.replace("{2}", (CharSequence)param[10 + j * 3]);
                    attackDesc = attackDesc.replace("{3}", "--");
                    attackDesc = attackDesc.replace("{4}", "--");
                    buf.append(attackDesc);
                }
                tmpDesc = buf.toString();
            }
            if (tmpDesc.contains("<br>")) {
                tmpDesc = tmpDesc.replaceAll("<br>", "\n");
            }
            tempLst.add(tmpDesc);
        } else {
            tempLst.add(this.i18nMgr.getString(fault.getFaultDefineId() + ".alarm.desc", locale));
        }
        return tempLst;
    }

    private List<String> getColumn(Locale locale) {
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.i18nMgr.getString("lego.lab.fault.alarmLevel", locale));
        column.add(this.i18nMgr.getString("lego.dic.confirmstatus", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.saveAlarm.name", locale));
        column.add(this.i18nMgr.getString("lego.dic.warningtype", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.alarmCount", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.saveAlarm.alarmSource", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.firstTime", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.lastTime", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.clearTime", locale));
        column.add(this.i18nMgr.getString("lego.lab.fault.description", locale));
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFaultDao(FaultDao faultDao) {
        Object object = this.lock;
        synchronized (object) {
            this.faultDao = faultDao;
        }
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    public ICommonDao getCommDao() {
        return this.commDao;
    }

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }
}

