/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocalizedTextUtil;
import com.hs.lego.cbb.fault.dao.FaultDao;
import com.hs.lego.cbb.fault.dao.FaultStatisticDao;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultDefine;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.fault.sdk.model.FaultVO;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.fault.service.FaultListener;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.model.SyslogBean;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaultServiceImpl
implements FaultService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final int FAULT_TOTAL_NUM = 10000000;
    private static final int TEN_THOUSAND = 10000;
    private FaultDao faultDao;
    private FaultStatisticDao faultStatisticDao;
    private ISyslogSendService syslogSendService;
    private IDataProtectService dataProtectService;

    public FaultDao getFaultDao() {
        return this.faultDao;
    }

    public void setFaultDao(FaultDao faultDao) {
        this.faultDao = faultDao;
    }

    public FaultStatisticDao getFaultStatisticDao() {
        return this.faultStatisticDao;
    }

    public void setFaultStatisticDao(FaultStatisticDao faultStatisticDao) {
        this.faultStatisticDao = faultStatisticDao;
    }

    public ISyslogSendService getSyslogSendService() {
        return this.syslogSendService;
    }

    public void setSyslogSendService(ISyslogSendService syslogSendService) {
        this.syslogSendService = syslogSendService;
    }

    @Override
    public Paging listFault(FaultQueryCondition condition) {
        return this.faultDao.listFault(condition);
    }

    @Override
    public List<Fault> listFault(Long[] ids, String sortField, String sortType) {
        return this.faultDao.listFault(ids, sortField, sortType);
    }

    @Override
    public List<Fault> listAllFault(FaultQueryCondition condition) {
        return this.faultDao.listAllFault(condition);
    }

    @Override
    public Paging listFaultDetail(Long faultID, int start, int length) {
        return this.faultDao.listFaultDetail(faultID, start, length);
    }

    @Override
    public Fault getFault(Long id) {
        return this.faultDao.getFault(id);
    }

    @Override
    public void createFault(FaultVO fault) {
        Fault entity = new Fault();
        entity.setFaultDefineId(fault.getFaultDefineId());
        entity.setSeverity(fault.getSeverity());
        entity.setSourceType(fault.getSourceType());
        entity.setSource(fault.getSource());
        entity.setClearStatus(fault.getClearStatus().byteValue());
        entity.setMoId(fault.getMoId());
        entity.setExtendMoId(fault.getExtendMoId());
        this.setParams(fault, entity);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        entity.setCreateTime(time);
        entity.setModTime(time);
        this.sendSyslog("start", entity);
        if (this.faultDao.queryAndDeleteLog(10000000, 10000)) {
            this.writeSyslog();
        }
        LOGGER.info((Object)("------------entity---->" + entity));
        Long faultID = this.faultDao.createFault(entity);
        entity.setId(faultID);
        FaultListener.getInstance().addFault(entity);
    }

    private void writeSyslog() {
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.log.auto.alarm.delete");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp("127.0.0.1");
        sysLog.setTarget("atic.bis.divert.tactics.log.auto.alarm.data");
        sysLog.setOperator("system");
        sysLog.setDetail("atic.bis.divert.tactics.log.auto.alarm.delete.success");
        String[] para = new String[]{String.valueOf(10000)};
        sysLog.setDetailPara(para);
        sysLog.setResult(1);
        ISysOptLog sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysLogService.writeOptLog(sysLog);
    }

    private void sendSyslog(String alarmStatus, Fault entity) {
        Map keysAndValuesMap = this.syslogSendService.getSyslogServerMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        if (null == keys || keys.size() == 0) {
            return;
        }
        HashMap syslogServerMap = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            syslogServerMap.put(keys.get(i), values.get(i));
        }
        if (!syslogServerMap.isEmpty()) {
            String hostName = System.getProperty("nms.server.host");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String logTime = dateFormat.format(new Date(System.currentTimeMillis()));
            for (Map.Entry serverMap : syslogServerMap.entrySet()) {
                List<String> conentList;
                SyslogServerEntity server = (SyslogServerEntity)serverMap.getValue();
                if (server.getAlarmSyslog() != 1 || entity.getSeverity() < server.getAlarmMinLevel() || null == (conentList = this.createConentList(logTime, alarmStatus, entity)) || conentList.isEmpty()) continue;
                String serverIpPort = server.getServerIp() + "," + server.getServerPort();
                SyslogBean syslogBean = new SyslogBean(hostName, "ALARM", conentList);
                this.syslogSendService.sendSyslog(serverIpPort, syslogBean);
            }
        }
    }

    private List<String> createConentList(String logTime, String alarmStatus, Fault entity) {
        ArrayList<String> conentList = new ArrayList<String>();
        if ("0x0000000803240801".equals(entity.getFaultDefineId())) {
            return null;
        }
        if ("0x0000000803240802".equals(entity.getFaultDefineId())) {
            String[] faultParams = entity.getFaultParam().split("###");
            conentList.add("log_type=sysAlarm");
            conentList.add("log_time=\"" + logTime + "\"");
            conentList.add("severity=" + entity.getSeverity());
            conentList.add("alarm_type=collectorOffline");
            conentList.add("alarm_status=" + alarmStatus);
            conentList.add("name=" + faultParams[0]);
            conentList.add("ip=" + faultParams[1]);
        } else if ("0x0000000803240803".equals(entity.getFaultDefineId())) {
            String[] faultParams = entity.getFaultParamArray();
            conentList.add("log_type=sysAlarm");
            conentList.add("log_time=\"" + logTime + "\"");
            conentList.add("severity=" + entity.getSeverity());
            conentList.add("alarm_type=divert");
            conentList.add("alarm_status=" + alarmStatus);
            conentList.add("device_name=" + faultParams[2]);
            conentList.add("zone_name=" + faultParams[0]);
            conentList.add("divert_ip=" + faultParams[1]);
        } else if ("0x0000000803240806".equals(entity.getFaultDefineId())) {
            String[] faultParams = entity.getFaultParamArray();
            conentList.add("log_type=sysAlarm");
            conentList.add("log_time=\"" + logTime + "\"");
            conentList.add("severity=" + entity.getSeverity());
            conentList.add("alarm_type=divertFail");
            conentList.add("alarm_status=" + alarmStatus);
            conentList.add("device_name=" + faultParams[2]);
            conentList.add("zone_name=" + faultParams[0]);
            conentList.add("divert_ip=" + faultParams[1]);
        } else if ("0x0000000803240821".equals(entity.getFaultDefineId())) {
            String[] faultParams = entity.getFaultParamArray();
            conentList.add("log_type=sysAlarm");
            conentList.add("log_time=\"" + logTime + "\"");
            conentList.add("severity=" + entity.getSeverity());
            conentList.add("alarm_type=stopDivertFail");
            conentList.add("alarm_status=" + alarmStatus);
            conentList.add("device_name=" + faultParams[2]);
            conentList.add("zone_name=" + faultParams[0]);
            conentList.add("divert_ip=" + faultParams[1]);
        } else if ("0x0000000803240807".equals(entity.getFaultDefineId())) {
            String[] faultParams = entity.getFaultParam().split("###");
            conentList.add("log_type=sysAlarm");
            conentList.add("log_time=\"" + logTime + "\"");
            conentList.add("severity=" + entity.getSeverity());
            conentList.add("alarm_type=haSwitch");
            conentList.add("alarm_status=" + alarmStatus);
            conentList.add("Current_ip=" + faultParams[0]);
            conentList.add("From_ip=" + faultParams[1]);
        } else if ("0x0000000803240808".equals(entity.getFaultDefineId())) {
            String[] faultParams = entity.getFaultParam().split("###");
            conentList.add("log_type=sysAlarm");
            conentList.add("log_time=\"" + logTime + "\"");
            conentList.add("severity=" + entity.getSeverity());
            conentList.add("alarm_type=haSwitchNotConnectDevice");
            conentList.add("alarm_status=" + alarmStatus);
            conentList.add("collector_ip=" + faultParams[2]);
            conentList.add("device_ip=" + faultParams[1]);
        } else {
            if ("0x0000000803240804".equals(entity.getFaultDefineId())) {
                return null;
            }
            if ("0x0000000803240805".equals(entity.getFaultDefineId())) {
                String[] faultParams = entity.getFaultParam().split("###");
                conentList.add("log_type=sysAlarm");
                conentList.add("log_time=\"" + logTime + "\"");
                conentList.add("severity=" + entity.getSeverity());
                conentList.add("alarm_type=collectorDelCaptureFiles");
                conentList.add("alarm_status=" + alarmStatus);
                conentList.add("collector_ip=" + faultParams[0]);
                conentList.add("disk_name=" + faultParams[1]);
                conentList.add("threshold=" + faultParams[2]);
                conentList.add("delete_file_num=" + faultParams[3]);
            } else {
                if ("0x0000000803240811".equals(entity.getFaultDefineId())) {
                    return null;
                }
                if ("0x0000000803240814".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=blackhole");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[1]);
                    conentList.add("divert_ip=" + faultParams[3]);
                    conentList.add("unblock_time=" + faultParams[5]);
                } else if ("0x0000000803240827".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=blackholeNp");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[2]);
                    conentList.add("unblock_time=" + faultParams[3]);
                } else if ("0x0000000803240828".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=blackholeFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[1]);
                    conentList.add("divert_ip=" + faultParams[3]);
                    conentList.add("unblock_time=" + faultParams[5]);
                } else if ("0x0000000803240829".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=blackholeNpFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[2]);
                    conentList.add("unblock_time=" + faultParams[3]);
                } else if ("0x0000000803240830".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=stopBlackholeFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[1]);
                    conentList.add("divert_ip=" + faultParams[3]);
                    conentList.add("unblock_time=" + faultParams[5]);
                } else if ("0x0000000803240831".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=stopBlackholeNpFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[2]);
                    conentList.add("unblock_time=" + faultParams[3]);
                } else if ("0x0000000803240833".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=cancelCloudCleanFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[1]);
                    conentList.add("sp=\"" + LocalizedTextUtil.findDefaultText((String)faultParams[2], (Locale)Locale.ENGLISH) + "\"");
                } else if ("0x0000000803240855".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=cancelStaticRouterFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[1]);
                } else if ("0x0000000803240866".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=creatStaticRouterFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[1]);
                } else if ("0x0000000803240834".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=blackholeAPIFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[2]);
                    conentList.add("unblock_time=" + faultParams[3]);
                } else if ("0x0000000803240835".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=stopBlackholeAPIFail");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[2]);
                    conentList.add("unblock_time=" + faultParams[3]);
                } else if ("0x0000000803240836".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParam().split("###");
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=blackholeAPI");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("device_name=" + faultParams[0]);
                    conentList.add("divert_ip=" + faultParams[2]);
                    conentList.add("unblock_time=" + faultParams[3]);
                } else if ("0x0000000803240839".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParamArray();
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=missingDefense");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("rule_name=" + faultParams[3]);
                    conentList.add("zone_name=" + faultParams[1]);
                    conentList.add("defend_ip=" + faultParams[0]);
                    conentList.add("device_ip=" + faultParams[2]);
                } else if ("0x0000000803240840".equals(entity.getFaultDefineId())) {
                    String[] faultParams = entity.getFaultParamArray();
                    conentList.add("log_type=sysAlarm");
                    conentList.add("log_time=\"" + logTime + "\"");
                    conentList.add("severity=" + entity.getSeverity());
                    conentList.add("alarm_type=faultDefense");
                    conentList.add("alarm_status=" + alarmStatus);
                    conentList.add("rule_name=" + faultParams[3]);
                    conentList.add("zone_name=" + faultParams[1]);
                    conentList.add("defend_ip=" + faultParams[0]);
                    conentList.add("device_ip=" + faultParams[2]);
                } else {
                    if ("0x0000000803240816".equals(entity.getFaultDefineId())) {
                        return null;
                    }
                    if ("0x0000000803240817".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=collectorDbDamaged");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("collector_ip=" + faultParams[1]);
                        conentList.add("collector_table_name=" + faultParams[2]);
                    } else if ("0x0000000803240818".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=deviceFlowAbnormal");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("device_ip=" + faultParams[1]);
                        conentList.add("device_flow=" + faultParams[2]);
                        conentList.add("threshold=" + faultParams[3]);
                    } else if ("0x0000000803240819".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=atuoStartCloudClean");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("device_name=" + faultParams[0]);
                        conentList.add("ip_mask=" + faultParams[1]);
                        conentList.add("sp=" + AticUtil.getText((String)faultParams[2]));
                    } else if ("0x0000000803240820".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=atuoStartCloudCleanFailed");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("device_name=" + faultParams[0]);
                        conentList.add("ip_mask=" + faultParams[1]);
                        conentList.add("sp=" + AticUtil.getText((String)faultParams[2]));
                    } else if ("0x0000000803240822".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=collectorDiskOverload");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("collector_ip=" + faultParams[1]);
                        conentList.add("collector_disk_name=" + faultParams[2]);
                        conentList.add("threshold=" + faultParams[3] + "G");
                        conentList.add("real_value=" + faultParams[4] + "G");
                    } else if ("0x0000000803240837".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=deviceCycleError");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("collector_ip=" + faultParams[1]);
                        conentList.add("device_ip=" + faultParams[2]);
                        conentList.add("learn_cycle=" + faultParams[3] + "Second");
                        conentList.add("config_cycle=" + faultParams[4] + "Second");
                    } else if ("0x0000000803240838".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=collectorMemoryError");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("collector_ip=" + faultParams[1]);
                        conentList.add("used_memory=" + faultParams[2] + "M");
                        conentList.add("max_memory=" + faultParams[3] + "M");
                        conentList.add("used_flow_event=" + faultParams[4]);
                        conentList.add("max_flow_event=" + faultParams[5]);
                        conentList.add("used_abnormal_event=" + faultParams[6]);
                        conentList.add("max_abnormal_event=" + faultParams[7]);
                        conentList.add("used_src_and_content_event=" + faultParams[8]);
                        conentList.add("max_src_and_content_event=" + faultParams[9]);
                        conentList.add("used_capture_event=" + faultParams[10]);
                        conentList.add("max_capture_event=" + faultParams[11]);
                        conentList.add("used_cache_black_event=" + faultParams[12]);
                        conentList.add("used_parse_black_event=" + faultParams[13]);
                        conentList.add("max_blacklist_event=" + faultParams[14]);
                    } else if ("0x0000000803240841".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=globalLogLimit");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("collector_ip=" + faultParams[1]);
                        conentList.add("log_level=" + faultParams[2]);
                        conentList.add("used_memory=" + faultParams[3] + "M");
                        conentList.add("max_memory=" + faultParams[4] + "M");
                        conentList.add("used_count=" + faultParams[5]);
                        conentList.add("max_count=" + faultParams[6]);
                    } else if ("0x0000000803240842".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=singleLogLimit");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("collector_ip=" + faultParams[1]);
                        conentList.add("log_level=" + faultParams[2]);
                        conentList.add("used_memory=" + faultParams[3] + "M");
                        conentList.add("max_memory=" + faultParams[4] + "M");
                        conentList.add("used_count=" + faultParams[5]);
                        conentList.add("max_count=" + faultParams[6]);
                    } else if ("0x0000000803240843".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=diversionTaskLimit");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("queue_used=" + faultParams[0]);
                        conentList.add("queue_total=" + faultParams[1]);
                    } else if ("0x000803220001".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=sysCpuOverload");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("threshold=" + faultParams[0]);
                        conentList.add("real_value=" + faultParams[1]);
                    } else if ("0x000803220002".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=sysMemOverload");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("threshold=" + faultParams[0]);
                        conentList.add("real_value=" + faultParams[1]);
                    } else if ("0x000803220003".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=sysDbOverload");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("threshold=" + faultParams[1]);
                        conentList.add("real_value=" + faultParams[2]);
                    } else if ("0x000803220004".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=sysDiskOverload");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("threshold=" + faultParams[1]);
                        conentList.add("real_value=" + faultParams[2]);
                    } else if ("0x000803220005".equals(entity.getFaultDefineId())) {
                        String[] faultParams = entity.getFaultParam().split("###");
                        conentList.add("log_type=sysAlarm");
                        conentList.add("log_time=\"" + logTime + "\"");
                        conentList.add("severity=" + entity.getSeverity());
                        conentList.add("alarm_type=deviceOffline");
                        conentList.add("alarm_status=" + alarmStatus);
                        conentList.add("name=" + faultParams[0]);
                        conentList.add("ip=" + faultParams[1]);
                    } else if ("0x0000000803240824".equals(entity.getFaultDefineId())) {
                        this.transOutboundDivertSyslog(entity, logTime, alarmStatus, "outboundDivert", conentList);
                    } else if ("0x0000000803240825".equals(entity.getFaultDefineId())) {
                        this.transOutboundDivertSyslog(entity, logTime, alarmStatus, "outboundDivertFail", conentList);
                    } else if ("0x0000000803240826".equals(entity.getFaultDefineId())) {
                        this.transOutboundDivertSyslog(entity, logTime, alarmStatus, "outboundDivertStopFail", conentList);
                    } else {
                        if ("0x0000000803240877".equals(entity.getFaultDefineId())) {
                            return null;
                        }
                        if ("0x0000000803240878".equals(entity.getFaultDefineId())) {
                            return null;
                        }
                        if ("0x0000000803240879".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=haDBException");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("ip=" + faultParams[0]);
                        } else if ("0x10010011".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=certExpired");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("cert_truststore=" + faultParams[0]);
                            conentList.add("expired_date=\"" + faultParams[1] + "\"");
                        } else if ("0x10010012".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=certWillExpire");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("cert_truststore=" + faultParams[0]);
                            conentList.add("expired_date=\"" + faultParams[1] + "\"");
                            conentList.add("days_left=" + faultParams[2]);
                        } else if ("0x10010013".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=invalidCertifcate");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("cert_truststore=" + faultParams[0]);
                            conentList.add("effective_date=\"" + faultParams[1] + "\"");
                        } else if ("0x10010014".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=blackholeIp");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("ip=" + faultParams[0]);
                        } else if ("0x10010015".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=releaseBlackholeIp");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("ip=" + faultParams[0]);
                        } else if ("0x10010016".equals(entity.getFaultDefineId())) {
                            String[] faultParams = entity.getFaultParam().split("###");
                            conentList.add("log_type=sysAlarm");
                            conentList.add("log_time=\"" + logTime + "\"");
                            conentList.add("severity=" + entity.getSeverity());
                            conentList.add("alarm_type=IPReputationFileOverTime");
                            conentList.add("alarm_status=" + alarmStatus);
                            conentList.add("libFile=" + faultParams[0]);
                        }
                    }
                }
            }
        }
        return conentList;
    }

    private boolean isNullAry(String[] args) {
        if (null == args) {
            return true;
        }
        int len = args.length;
        if (0 == len) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (null != args[i] && !"null".equalsIgnoreCase(args[i])) continue;
            return true;
        }
        return false;
    }

    private void transOutboundDivertSyslog(Fault entity, String logTime, String alarmStatus, String alarmType, List<String> conentList) {
        String[] faultParams = entity.getFaultParamArray();
        conentList.add("log_type=sysAlarm");
        conentList.add("log_time=\"" + logTime + "\"");
        conentList.add("severity=" + entity.getSeverity());
        conentList.add("alarm_type=" + alarmType);
        conentList.add("alarm_status=" + alarmStatus);
        conentList.add("zone_name=" + faultParams[0]);
        conentList.add("divert_ip=" + faultParams[1]);
        conentList.add("protocal=" + faultParams[2]);
        conentList.add("divert_action=" + AticUtil.getText((String)faultParams[3]));
        conentList.add("limit_threshold=" + faultParams[4]);
        conentList.add("next_hop=" + faultParams[5]);
    }

    private void setParams(FaultVO fault, Fault entity) {
        String[] param = fault.getParam();
        if (param != null) {
            FaultDefine faultDefine = null;
            faultDefine = "0x0000000803240801".equals(fault.getFaultDefineId()) ? FaultDefineUtil.getInstance().getFaultDefine(fault.getFaultDefineId() + "_" + fault.getSeverity()) : FaultDefineUtil.getInstance().getFaultDefine(fault.getFaultDefineId());
            int[] paramIdIndex = faultDefine == null || faultDefine.getKeyIndex() == null ? new int[]{} : faultDefine.getKeyIndex();
            StringBuilder sb = new StringBuilder();
            StringBuilder keySB = new StringBuilder();
            block0: for (int i = 0; i < param.length; ++i) {
                if (i >= 1) {
                    sb.append("###");
                }
                sb.append(param[i]);
                for (int index : paramIdIndex) {
                    if (index != i) continue;
                    keySB.append(param[i]).append('-');
                    continue block0;
                }
            }
            entity.setFaultParam(sb.toString());
            if (keySB.length() > 0) {
                entity.setParamShaCode(this.dataProtectService.sdpHmac(keySB.toString()));
            }
            if (null == faultDefine) {
                return;
            }
            if (!"0x0000000803240801".equals(entity.getFaultDefineId()) && !"0x0000000803240822".equals(entity.getFaultDefineId())) {
                entity.setSeverity(faultDefine.getSeverity());
            }
            entity.setSourceType(faultDefine.getSourceType());
        }
    }

    @Override
    public void restoreFault(FaultVO fault) {
        fault.setClearStatus((int)Fault.FaultClearStatus.CLEARED.getValue());
        Fault entity = new Fault();
        entity.setFaultDefineId(fault.getFaultDefineId());
        entity.setSeverity(fault.getSeverity());
        entity.setSourceType(fault.getSourceType());
        entity.setSource(fault.getSource());
        entity.setClearStatus(fault.getClearStatus().byteValue());
        entity.setMoId(fault.getMoId());
        entity.setExtendMoId(fault.getExtendMoId());
        this.setParams(fault, entity);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        entity.setClearTime(time);
        entity.setCreateTime(time);
        this.sendSyslog("end", entity);
        Long faultID = this.faultDao.restoreFault(entity);
        if (faultID != null) {
            entity.setId(faultID);
            FaultListener.getInstance().addFault(entity);
        }
    }

    @Override
    public BatchOperationResult confirmFault(List<BatchOperation> batchOpList, String confirmUser) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : batchOpList) {
            Fault fault = this.faultDao.getFault(bo.getTargetId());
            if (null == fault) continue;
            bo.setTargetName(fault.getSource());
            this.faultDao.confirmFault(bo.getTargetId(), confirmUser);
            bo.setTargetName(fault.getSource());
            bo.setOptDetail("lego.err.operateName.confirmAlarm.success");
            bo.setDetailParam(new String[]{bo.getTargetName()});
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - fail);
        return result;
    }

    @Override
    public BatchOperationResult cancelConfirmFault(List<BatchOperation> batchOpList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : batchOpList) {
            Fault fault = this.faultDao.getFault(bo.getTargetId());
            if (null == fault) continue;
            bo.setTargetName(fault.getSource());
            this.faultDao.cancelConfirmFault(bo.getTargetId());
            bo.setTargetName(fault.getSource());
            bo.setOptDetail("lego.lab.com.unconfirmaction.success");
            bo.setDetailParam(new String[]{bo.getTargetName()});
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - fail);
        return result;
    }

    @Override
    public BatchOperationResult clearFault(List<BatchOperation> batchOpList, String clearUser) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : batchOpList) {
            Fault fault = this.faultDao.getFault(bo.getTargetId());
            if (null == fault) continue;
            bo.setTargetName(fault.getSource());
            this.faultDao.clearFault(bo.getTargetId(), clearUser);
            bo.setTargetName(fault.getSource());
            bo.setOptDetail("lego.err.operateName.clearAlarm.success");
            bo.setDetailParam(new String[]{bo.getTargetName()});
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - fail);
        return result;
    }

    @Override
    public void clearAllFault(String clearUser) {
        this.faultDao.clearAllFault(clearUser);
    }

    @Override
    public long[] getStatistic(Long userid) {
        return this.faultStatisticDao.getStatistic(userid);
    }

    @Override
    public BatchOperationResult confirmAndClearFault(Long[] ids, String clearUser) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setOptDetail(this.faultDao.confirmAndClearFault(id, clearUser) + ".alarm.name");
            resultList.add(batchOperation);
        }
        result.setResult(resultList);
        result.setTotalCount(resultList.size());
        result.setSucceedCount(resultList.size());
        result.setFailCount(0);
        return result;
    }

    @Override
    public TopoObject getTopoObjectById(long moId) {
        return this.faultDao.getTopoObjectById(moId);
    }

    @Override
    public void deleteAllAlarmsByMoIds(List<Long> moIdList) {
        this.faultDao.deleteAllAlarmsByMoIds(moIdList);
    }

    @Override
    public Fault queryByAlarmResult(Long moId, String defineId) {
        return this.faultDao.getCloudCleanFault(moId, defineId);
    }

    @Override
    public long getAllFaultCount(FaultQueryCondition condition) {
        return this.faultDao.getAllFaultCount(condition);
    }

    @Override
    public List<Fault> queryFault(FaultQueryCondition condition, int start, int pageSize) {
        return this.faultDao.queryFault(condition, start, pageSize);
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

