/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.lego.cbb.fault.dao.NotifyDao;
import com.hs.lego.cbb.fault.dao.impl.NotifyDaoImpl;
import com.hs.lego.cbb.fault.sdk.model.NotifyRule;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.service.IAlarmInitService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class NotifyListener {
    private static NotifyListener instance = new NotifyListener();
    private IAlarmInitService alarmService;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private final Object lock = new Object();
    private Map<String, Set<NotifyRule>> data;
    private List<NotifyRule> rules;
    private NotifyDao notifyDao = new NotifyDaoImpl();

    private NotifyListener() {
    }

    public static NotifyListener getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            this.data = new HashMap<String, Set<NotifyRule>>();
            int exceptionTimes = 0;
            while (true) {
                try {
                    this.rules = this.notifyDao.getEnableNotifyRule();
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("notifyDao getEnableNotifyRule with error" + e.getMessage()));
                    if (++exceptionTimes >= 10) {
                        this.alarmService.callinitAlarm("lego.event.notify.message", "T_alarm_notifyrule");
                        break;
                    }
                    try {
                        this.lock.wait(2000L);
                    }
                    catch (InterruptedException ex) {
                        this.log.error((Object)("wait with error." + ex.getMessage()));
                    }
                    continue;
                }
                break;
            }
            for (NotifyRule rule : this.rules) {
                for (String faultId : rule.getFaultIds()) {
                    Set<NotifyRule> set = this.data.get(faultId);
                    if (set == null) {
                        set = new HashSet<NotifyRule>();
                        this.data.put(faultId, set);
                    }
                    set.add(rule);
                }
            }
            this.log.info((Object)"init NotifyListener success");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NotifyRule rule) {
        Object object = this.lock;
        synchronized (object) {
            for (String faultId : rule.getFaultIds()) {
                Set<NotifyRule> set = this.data.get(faultId);
                if (set == null) {
                    set = new HashSet<NotifyRule>();
                    this.data.put(faultId, set);
                }
                set.add(rule);
            }
            this.rules.add(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(NotifyRule rule) {
        Object object = this.lock;
        synchronized (object) {
            NotifyRule tmp = null;
            for (NotifyRule r : this.rules) {
                if (!r.getId().equals(rule.getId())) continue;
                tmp = r;
                break;
            }
            if (tmp != null) {
                Set<NotifyRule> set;
                for (String oldFaultId : tmp.getFaultIds()) {
                    if (!this.data.keySet().contains(oldFaultId) || (set = this.data.get(oldFaultId)) == null || set.isEmpty()) continue;
                    set.remove(tmp);
                }
                for (String faultId : rule.getFaultIds()) {
                    if (this.data.keySet().contains(faultId)) {
                        set = this.data.get(faultId);
                        set.add(rule);
                        continue;
                    }
                    set = new HashSet<NotifyRule>();
                    set.add(rule);
                    this.data.put(faultId, set);
                }
                this.rules.remove(tmp);
                this.rules.add(rule);
            } else {
                Date now = new Date();
                if (now.before(rule.getEndTime())) {
                    this.add(rule);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Long ruleId) {
        Object object = this.lock;
        synchronized (object) {
            NotifyRule tmp = null;
            for (NotifyRule r : this.rules) {
                if (!r.getId().equals(ruleId)) continue;
                tmp = r;
                break;
            }
            if (tmp != null) {
                for (String faultId : tmp.getFaultIds()) {
                    Set<NotifyRule> set = this.data.get(faultId);
                    if (set == null) continue;
                    set.remove(tmp);
                }
                this.rules.remove(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearkExpired() {
        Object object = this.lock;
        synchronized (object) {
            Date now = new Date();
            ArrayList<NotifyRule> expired = new ArrayList<NotifyRule>();
            for (NotifyRule r : this.rules) {
                if (null != r.getEndTime() && !now.after(r.getEndTime())) continue;
                expired.add(r);
            }
            for (NotifyRule r : expired) {
                for (String faultId : r.getFaultIds()) {
                    Set<NotifyRule> set = this.data.get(faultId);
                    if (set == null) continue;
                    set.remove(r);
                }
                this.rules.remove(r);
                this.notifyDao.updateStatus(r.getId(), NotifyRule.NotifyRuleStatus.EXPIRED.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotifyRule> getAvalibleRules() {
        Object object = this.lock;
        synchronized (object) {
            this.rules = this.notifyDao.getEnableNotifyRule();
            ArrayList<NotifyRule> avalibleRules = new ArrayList<NotifyRule>();
            Date now = new Date();
            for (NotifyRule notifyRule : this.rules) {
                if (!notifyRule.getStatus().equals(NotifyRule.NotifyRuleStatus.ENABLED.getValue()) || null == notifyRule.getEndTime() || !now.before(notifyRule.getEndTime())) continue;
                avalibleRules.add(notifyRule);
            }
            return avalibleRules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NotifyRule> getNotifyRule(String faultId) {
        Object object = this.lock;
        synchronized (object) {
            return this.data.get(faultId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyDao(NotifyDao notifyDao) {
        Object object = this.lock;
        synchronized (object) {
            this.notifyDao = notifyDao;
        }
    }

    public void setAlarmService(IAlarmInitService alarmService) {
        this.alarmService = alarmService;
    }
}

