/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.lego.cbb.fault.dao.IRemoteNotifyRuleDao;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtectorWrapper;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.hs.lego.nem.fault.sdk.model.NotifyResItem;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemoteNotifyRuleServiceImpl
implements IRemoteNotifyRuleService {
    private final Object lock = new Object();
    private IRemoteNotifyRuleDao remoteNotifyRuleDao;
    private Map<Long, RemoteNotifyRule> notifyRuleMap = new HashMap<Long, RemoteNotifyRule>();
    private boolean initTag = false;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    @Override
    public BatchOperationResult setSwitchStatus(boolean useStatus, List<BatchOperation> ruleIds) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ruleIds != null) {
            operCount = ruleIds.size();
            for (BatchOperation batchOperation : ruleIds) {
                fail = this.setSingleStatus(useStatus, fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setSingleStatus(boolean useStatus, int fail, BatchOperation batchOperation) {
        Object object = this.lock;
        synchronized (object) {
            if (null == batchOperation) {
                return fail + 1;
            }
            try {
                RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDao.getRuleByID(String.valueOf(batchOperation.getTargetId()));
                this.setRuleStatus(useStatus, remoteNotifyRule);
                this.remoteNotifyRuleDao.modifyBaseRule(remoteNotifyRule);
                this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
            }
            catch (LegoCheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            return fail;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setRuleStatus(boolean useStatus, RemoteNotifyRule remoteNotifyRule) {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= remoteNotifyRule.getEndTime()) {
            throw new LegoCheckedException(1553L);
        }
        if (useStatus) {
            if (remoteNotifyRule.isIsUseEnable()) throw new LegoCheckedException(1537L);
            remoteNotifyRule.setIsUseEnable(useStatus);
            return;
        } else {
            if (!remoteNotifyRule.isIsUseEnable()) throw new LegoCheckedException(1546L);
            remoteNotifyRule.setIsUseEnable(useStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addRule(RemoteNotifyRule remoteNotifyRule, String[] emailToList, String[] smsPhoneList, String[] fields, String[] resources, String[] alarmInfos) {
        Object object = this.lock;
        synchronized (object) {
            this.setEmailAddress(emailToList, remoteNotifyRule);
            this.setPhone(smsPhoneList, remoteNotifyRule);
            this.setContent(fields, remoteNotifyRule);
            this.setTime(remoteNotifyRule, false);
            this.setRuleItem(remoteNotifyRule, resources, alarmInfos);
            String ruleId = this.remoteNotifyRuleDao.addRule(remoteNotifyRule);
            remoteNotifyRule.setId(Long.parseLong(ruleId));
            String decryptedEmails = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getEmailTo());
            remoteNotifyRule.setEmailTo(decryptedEmails);
            String decryptedPhones = LegoDataProtectorWrapper.sdpDecryptLocal((String)remoteNotifyRule.getSmsPhone());
            remoteNotifyRule.setSmsPhone(decryptedPhones);
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
            return ruleId;
        }
    }

    @Override
    public boolean checkRuleEndTime(RemoteNotifyRule remoteNotifyRule) {
        this.setTime(remoteNotifyRule, true);
        return true;
    }

    @Override
    public BatchOperationResult deleteRules(List<BatchOperation> ruleIds) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ruleIds != null) {
            operCount = ruleIds.size();
            for (BatchOperation batchOperation : ruleIds) {
                fail = this.deleteSingleRule(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteSingleRule(int fail, BatchOperation batchOperation) {
        Object object = this.lock;
        synchronized (object) {
            if (null == batchOperation) {
                return fail + 1;
            }
            try {
                RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDao.getRuleByID(String.valueOf(batchOperation.getTargetId()));
                this.remoteNotifyRuleDao.deleteRule(remoteNotifyRule);
                this.notifyRuleMap.remove(remoteNotifyRule.getId());
            }
            catch (LegoCheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            return fail;
        }
    }

    @Override
    public RemoteNotifyRule getRuleByID(String ruleId) {
        return this.remoteNotifyRuleDao.getRuleByID(ruleId);
    }

    @Override
    public RemoteNotifyRule getRuleByName(String ruleName) {
        return this.remoteNotifyRuleDao.getRuleByRuleName(ruleName);
    }

    @Override
    public Paging getRuleAndCountByName(Map<String, Object> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.getRulesAndAllCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    @Override
    public Paging getRuleAndCountByResName(Map<String, Object> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.getRulesAndAllCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    @Override
    public Paging getRulesAndAllCount(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.getRulesAndAllCountByCondition(null, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    @Override
    public List<RemoteNotifyRule> getAllRules() {
        if (!this.initTag) {
            this.init();
            this.initTag = true;
        }
        ArrayList<RemoteNotifyRule> ruleList = new ArrayList<RemoteNotifyRule>();
        Set<Map.Entry<Long, RemoteNotifyRule>> entrys = this.notifyRuleMap.entrySet();
        for (Map.Entry<Long, RemoteNotifyRule> entry : entrys) {
            ruleList.add(entry.getValue());
        }
        return ruleList;
    }

    private void init() {
        this.notifyRuleMap.clear();
        Paging paging = this.getRulesAndAllCountByCondition(null, -1, -1, "ruleName", true);
        List ruleList = paging.getData();
        for (RemoteNotifyRule remoteNotifyRule : ruleList) {
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        }
    }

    @Override
    public Paging getRulesAndAllCountByCondition(Map<String, Object> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.remoteNotifyRuleDao.getRuleAndCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    @Override
    public boolean modifyNotifyBaseInfo(String ruleId, boolean useStatus, String startTime, String endTime, String description, int language, String sendContent) {
        if (null == ruleId) {
            this.logger.error((Object)"modifyNotifyBaseInfo error,ruleId is null.");
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = 0L;
        long end = 0L;
        try {
            start = sdf.parse(startTime).getTime();
            end = sdf.parse(endTime).getTime();
        }
        catch (Exception e) {
            throw new LegoCheckedException(1538L, (Throwable)e);
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= end) {
            throw new LegoCheckedException(1565L);
        }
        RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDao.getRuleByID(ruleId);
        remoteNotifyRule.setIsUseEnable(useStatus);
        remoteNotifyRule.setDescription(description);
        remoteNotifyRule.setStartTime(start);
        remoteNotifyRule.setEndTime(end);
        remoteNotifyRule.setLanguage(language);
        remoteNotifyRule.setSendContent(sendContent);
        boolean result = this.remoteNotifyRuleDao.modifyBaseRule(remoteNotifyRule);
        this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean modifyNotifyObj(String ruleId, int sendMode, String[] phones, String[] emails) {
        void var10_17;
        RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDao.getRuleByID(ruleId);
        remoteNotifyRule.setSmsMode(sendMode);
        StringBuilder phoneBuffer = new StringBuilder();
        for (String string : phones) {
            phoneBuffer.append(string);
            phoneBuffer.append("===");
        }
        String smsPhone = phoneBuffer.toString();
        if ("===".equals(smsPhone)) {
            smsPhone = "";
        } else if (!"".equals(smsPhone) && smsPhone.charAt(smsPhone.length() - 1) == ',') {
            smsPhone = smsPhone.substring(0, smsPhone.length() - 1);
        }
        String encryptedPhones = LegoDataProtectorWrapper.sdpEncryptLocal((String)smsPhone);
        remoteNotifyRule.setSmsPhone(encryptedPhones);
        StringBuilder emailBuffer = new StringBuilder();
        for (String email : emails) {
            emailBuffer.append(email);
            emailBuffer.append("===");
        }
        String string = emailBuffer.toString();
        if ("===".equals(string)) {
            String string2 = "";
        } else if (string.charAt(string.length() - 1) == ',') {
            String string3 = string.substring(0, string.length() - 1);
        }
        String encryptedEmails = LegoDataProtectorWrapper.sdpEncryptLocal((String)var10_17);
        remoteNotifyRule.setEmailTo(encryptedEmails);
        boolean result = this.remoteNotifyRuleDao.modifyBaseRule(remoteNotifyRule);
        remoteNotifyRule.setSmsPhone(smsPhone);
        remoteNotifyRule.setEmailTo((String)var10_17);
        this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAlarm(String ruleId, String[] alarmInfos) {
        Object object = this.lock;
        synchronized (object) {
            if (null == alarmInfos) {
                this.logger.error((Object)"addAlarm error,alarmInfos is null.");
                return false;
            }
            RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDao.getRuleByID(ruleId);
            HashSet<NotifyAlarmItem> alarmSet = new HashSet<NotifyAlarmItem>();
            ArrayList<String> alarmList = new ArrayList<String>();
            for (String alarm : alarmInfos) {
                String[] alarmInfo = alarm.split("###");
                NotifyAlarmItem notifyAlarmItem = new NotifyAlarmItem();
                notifyAlarmItem.setAlarmLevel(Integer.parseInt(alarmInfo[0]));
                notifyAlarmItem.setAlarmId(alarmInfo[1]);
                notifyAlarmItem.setAlarmName(alarmInfo[2]);
                notifyAlarmItem.setRemoteNotifyRule(remoteNotifyRule);
                alarmSet.add(notifyAlarmItem);
                alarmList.add(notifyAlarmItem.getAlarmId() + "_" + notifyAlarmItem.getAlarmLevel());
            }
            if (this.notifyRuleMap.isEmpty()) {
                this.init();
            }
            Set<Map.Entry<Long, RemoteNotifyRule>> ruleSet = this.notifyRuleMap.entrySet();
            for (Map.Entry<Long, RemoteNotifyRule> entry : ruleSet) {
                boolean isExist;
                RemoteNotifyRule rule = entry.getValue();
                if (remoteNotifyRule.getId() != rule.getId() || !(isExist = this.checkAlarm(rule, alarmList))) continue;
                throw new LegoCheckedException(1560L);
            }
            boolean result = this.remoteNotifyRuleDao.addAlarm(alarmSet);
            remoteNotifyRule.getNotifyAlarmItems().addAll(alarmSet);
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addResource(String ruleId, String[] resources) {
        Object object = this.lock;
        synchronized (object) {
            if (null == resources) {
                this.logger.error((Object)"addResource error,resources is null.");
                throw new LegoCheckedException(1797L);
            }
            RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDao.getRuleByID(ruleId);
            HashSet<NotifyResItem> resSet = new HashSet<NotifyResItem>();
            ArrayList<String> resList = new ArrayList<String>();
            for (String res : resources) {
                String[] source = res.split("###");
                NotifyResItem notifyResItem = new NotifyResItem();
                notifyResItem.setAlarmSource(source[0]);
                notifyResItem.setMoName(source[1]);
                notifyResItem.setMoSubType(source[2]);
                notifyResItem.setMoMainType(source[3]);
                if (source.length >= 5) {
                    notifyResItem.setMoIp(source[4]);
                } else {
                    notifyResItem.setMoIp("");
                }
                notifyResItem.setRemoteNotifyRule(remoteNotifyRule);
                resSet.add(notifyResItem);
                resList.add(notifyResItem.getAlarmSource());
            }
            if (this.notifyRuleMap.isEmpty()) {
                this.init();
            }
            Set<Map.Entry<Long, RemoteNotifyRule>> ruleSet = this.notifyRuleMap.entrySet();
            for (Map.Entry<Long, RemoteNotifyRule> entry : ruleSet) {
                boolean isExist;
                RemoteNotifyRule rule = entry.getValue();
                if (remoteNotifyRule.getId() != rule.getId() || !(isExist = this.checkResource(rule, resList))) continue;
                throw new LegoCheckedException(1561L);
            }
            boolean result = this.remoteNotifyRuleDao.addResource(resSet);
            remoteNotifyRule.getNotifyResItems().addAll(resSet);
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
            return result;
        }
    }

    private boolean checkResource(RemoteNotifyRule remoteNotifyRule, List<String> resList) {
        for (NotifyResItem notifyResItem : remoteNotifyRule.getNotifyResItems()) {
            if (!resList.contains(notifyResItem.getAlarmSource())) continue;
            this.writeNotifyAlarmLog(resList, notifyResItem.getAlarmSource());
            return true;
        }
        return false;
    }

    private boolean checkAlarm(RemoteNotifyRule remoteNotifyRule, List<String> alarmList) {
        for (NotifyAlarmItem notifyAlarmItem : remoteNotifyRule.getNotifyAlarmItems()) {
            if (!alarmList.contains(notifyAlarmItem.getAlarmId() + "_" + notifyAlarmItem.getAlarmLevel())) continue;
            this.writeNotifyAlarmLog(alarmList, notifyAlarmItem.getAlarmId());
            return true;
        }
        return false;
    }

    private void writeNotifyAlarmLog(List<String> list, String repeatMoOrAlarm) {
        StringBuilder builder = new StringBuilder();
        builder.append("add shield rule fail,repeatMoOrAlarm:");
        builder.append(repeatMoOrAlarm);
        builder.append(",list:");
        for (String moIdOrAlarmId : list) {
            builder.append(moIdOrAlarmId);
            builder.append(",");
        }
        this.logger.info((Object)builder.toString());
    }

    @Override
    public BatchOperationResult deleteAlarmItem(List<BatchOperation> ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ids != null) {
            operCount = ids.size();
            for (BatchOperation batchOperation : ids) {
                fail = this.deleteSingleAlarm(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteSingleAlarm(int fail, BatchOperation batchOperation) {
        Object object = this.lock;
        synchronized (object) {
            try {
                NotifyAlarmItem notifyAlarmItem = this.remoteNotifyRuleDao.getAlarmItem(batchOperation.getTargetId());
                if (notifyAlarmItem == null) {
                    throw new LegoCheckedException(1554L);
                }
                this.remoteNotifyRuleDao.deleteAlarmItem(notifyAlarmItem);
            }
            catch (LegoCheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            return fail;
        }
    }

    @Override
    public BatchOperationResult deleteResourceItem(List<BatchOperation> ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ids != null) {
            operCount = ids.size();
            for (BatchOperation batchOperation : ids) {
                fail = this.deleteSingleRes(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteSingleRes(int fail, BatchOperation batchOperation) {
        Object object = this.lock;
        synchronized (object) {
            try {
                NotifyResItem notifyResItem = this.remoteNotifyRuleDao.getResourceItem(batchOperation.getTargetId());
                if (notifyResItem == null) {
                    throw new LegoCheckedException(1555L);
                }
                this.remoteNotifyRuleDao.deleteResourceItem(notifyResItem);
            }
            catch (LegoCheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            return fail;
        }
    }

    @Override
    public boolean deleteResourceItem(String alarmSource) {
        List<NotifyResItem> resList = this.remoteNotifyRuleDao.getResourceItem(alarmSource);
        boolean result = this.remoteNotifyRuleDao.deleteResourceItems(resList);
        return result;
    }

    @Override
    public Paging queryAlarmItem(String ruleId, String alarmLevel, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.remoteNotifyRuleDao.queryAlarmItem(ruleId, alarmLevel, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    @Override
    public boolean updateResourceItem(String alarmSource, String moName, String moIp, String moMainType, String moSubType) {
        List<NotifyResItem> resList = this.remoteNotifyRuleDao.getResourceItem(alarmSource);
        HashSet<NotifyResItem> resSet = new HashSet<NotifyResItem>();
        for (NotifyResItem notifyResItem : resList) {
            notifyResItem.setMoIp(moIp);
            notifyResItem.setMoMainType(moMainType);
            notifyResItem.setMoName(moName);
            notifyResItem.setMoSubType(moSubType);
            resSet.add(notifyResItem);
        }
        return this.remoteNotifyRuleDao.addResource(resSet);
    }

    @Override
    public boolean updateNotifyRuleSystemIp(String ip) {
        return true;
    }

    @Override
    public Paging queryResourceItem(String ruleId, String name, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        if (userId >= 0L) {
            return this.remoteNotifyRuleDao.queryResourceItem(ruleId, name, firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        }
        return this.remoteNotifyRuleDao.queryResourceItem(ruleId, name, firstRowIndex, totalRow, orderByField, orderByAscend, null);
    }

    @Override
    public boolean isExistRuleName(String ruleName) {
        return this.remoteNotifyRuleDao.isExistRuleName(ruleName);
    }

    @Override
    public void refreshNotifyRuleMap() {
        this.notifyRuleMap.clear();
        Paging paging = this.getRulesAndAllCountByCondition(null, -1, -1, "ruleName", true);
        List ruleList = paging.getData();
        for (RemoteNotifyRule remoteNotifyRule : ruleList) {
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        }
    }

    private void setEmailAddress(String[] emailToList, RemoteNotifyRule remoteNotifyRule) {
        if (emailToList != null && emailToList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String email : emailToList) {
                sb.append(email);
                sb.append("===");
            }
            String emailTo = sb.toString();
            if (emailTo.endsWith("===")) {
                emailTo = emailTo.substring(0, emailTo.length() - 3);
            }
            String encryptedEmails = LegoDataProtectorWrapper.sdpEncryptLocal((String)emailTo);
            remoteNotifyRule.setEmailTo(encryptedEmails);
        }
    }

    private void setPhone(String[] smsPhoneList, RemoteNotifyRule remoteNotifyRule) {
        if (smsPhoneList != null && smsPhoneList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String phone : smsPhoneList) {
                sb.append(phone);
                sb.append("===");
            }
            String smsPhone = sb.toString();
            if (smsPhone.endsWith("===")) {
                smsPhone = smsPhone.substring(0, smsPhone.length() - 3);
            }
            String encryptedPhones = LegoDataProtectorWrapper.sdpEncryptLocal((String)smsPhone);
            remoteNotifyRule.setSmsPhone(encryptedPhones);
        }
    }

    private void setContent(String[] fields, RemoteNotifyRule remoteNotifyRule) {
        if (fields != null && fields.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String field : fields) {
                sb.append(field);
                sb.append(",");
            }
            String content = sb.toString();
            remoteNotifyRule.setSendContent(content.substring(0, content.length() - 1));
        }
    }

    private void setTime(RemoteNotifyRule remoteNotifyRule, boolean checkEndTime) {
        long currentTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            remoteNotifyRule.setStartTime(sdf.parse(remoteNotifyRule.getStartTimeStr()).getTime());
            remoteNotifyRule.setEndTime(sdf.parse(remoteNotifyRule.getEndTimeStr()).getTime());
        }
        catch (Exception e) {
            throw new LegoCheckedException(1538L, (Throwable)e);
        }
        if (checkEndTime && (currentTime = System.currentTimeMillis()) >= remoteNotifyRule.getEndTime()) {
            throw new LegoCheckedException(1565L);
        }
    }

    private void setRuleItem(RemoteNotifyRule remoteNotifyRule, String[] resources, String[] alarmInfos) {
        if (null == resources || null == alarmInfos) {
            this.logger.error((Object)"setRuleItem error,resources is null,or alarmInfos is null.");
            return;
        }
        for (String res : resources) {
            String[] source = res.split("###");
            NotifyResItem notifyResItem = new NotifyResItem();
            notifyResItem.setAlarmSource(source[0]);
            notifyResItem.setMoName(source[1]);
            notifyResItem.setMoSubType(source[2]);
            notifyResItem.setMoMainType(source[3]);
            if (source.length >= 5) {
                notifyResItem.setMoIp(source[4]);
            } else {
                notifyResItem.setMoIp("");
            }
            remoteNotifyRule.getNotifyResItems().add(notifyResItem);
            remoteNotifyRule.setMoMainType(source[3]);
            remoteNotifyRule.setMoSubType(source[2]);
        }
        for (String alarm : alarmInfos) {
            String[] alarmInfo = alarm.split("###");
            NotifyAlarmItem notifyAlarmItem = new NotifyAlarmItem();
            notifyAlarmItem.setAlarmLevel(Integer.parseInt(alarmInfo[0]));
            notifyAlarmItem.setAlarmId(alarmInfo[1]);
            notifyAlarmItem.setAlarmName(alarmInfo[2]);
            remoteNotifyRule.getNotifyAlarmItems().add(notifyAlarmItem);
        }
    }

    public IRemoteNotifyRuleDao getRemoteNotifyRuleDao() {
        return this.remoteNotifyRuleDao;
    }

    public void setRemoteNotifyRuleDao(IRemoteNotifyRuleDao remoteNotifyRuleDao) {
        this.remoteNotifyRuleDao = remoteNotifyRuleDao;
    }
}

