/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.util;

import com.hs.atic.sdk.bis.parent.service.ILibraryFileParentService;
import com.hs.atic.sdk.bis.parent.service.ILocationCustomParentService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.XmlUtil;
import com.hs.lego.cbb.fault.sdk.model.FaultDefine;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class FaultDefineUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final Byte ZONE_ABNORMAL_TYPE = 6;
    private static final Byte MAGOR_SEVERITY = 3;
    private static final Byte MINOR_SEVERITY = 2;
    private static final Byte WARN_SEVERITY = 1;
    private static final Object LOCK = new Object();
    private static final int IPV4_ADDRESS_LENGTH = 4;
    private static FaultDefineUtil instance = null;
    private List<FaultDefine> defines = null;
    private Map<String, FaultDefine> defineMap = null;

    private FaultDefineUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FaultDefineUtil getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new FaultDefineUtil();
                instance.init();
            }
            return instance;
        }
    }

    public List<FaultDefine> getFaultDefine() {
        return this.defines;
    }

    public List<FaultDefine> getFaultDefine(Byte sourceType) {
        ArrayList<FaultDefine> returnList = new ArrayList<FaultDefine>();
        for (FaultDefine faultDefine : this.defines) {
            if (!faultDefine.getSourceType().equals(sourceType)) continue;
            returnList.add(faultDefine);
        }
        return returnList;
    }

    public FaultDefine getFaultDefine(String faultDefineId) {
        return this.defineMap.get(faultDefineId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        InputStream in = null;
        try {
            in = FaultDefineUtil.class.getResource("/fault-define.xml").openStream();
            SAXReader saxReader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            Document document = saxReader.read(in);
            Element root = document.getRootElement();
            this.defines = new ArrayList<FaultDefine>();
            this.defineMap = new HashMap<String, FaultDefine>();
            int[] zoneKeyIndex = new int[]{1, 2, 4, 7};
            this.initZoneAbnormal("0x0000000803240801", MINOR_SEVERITY, ZONE_ABNORMAL_TYPE, zoneKeyIndex);
            Iterator configIter = root.elementIterator("fault");
            while (configIter.hasNext()) {
                Element configElement = (Element)configIter.next();
                String id = configElement.element("id").getTextTrim();
                String severity = configElement.element("severity").getTextTrim();
                Element keyIndexElement = configElement.element("keyIndex");
                String type = configElement.element("type").getTextTrim();
                FaultDefine d = new FaultDefine();
                d.setFaultDefineId(id);
                d.setSeverity(Byte.valueOf(severity));
                d.setSourceType(Byte.valueOf(type));
                if (keyIndexElement != null) {
                    String[] str = keyIndexElement.getTextTrim().split(",");
                    int[] keyIndex = new int[str.length];
                    for (int i = 0; i < str.length; ++i) {
                        if (str[i].isEmpty()) continue;
                        keyIndex[i] = Integer.parseInt(str[i]);
                    }
                    d.setKeyIndex(keyIndex);
                }
                this.defines.add(d);
                if (id.equals("0x0000000803240801")) {
                    this.defineMap.put(id + "_" + severity, d);
                    continue;
                }
                this.defineMap.put(id, d);
            }
            this.initZoneAbnormal("0x0000000803240801", WARN_SEVERITY, ZONE_ABNORMAL_TYPE, zoneKeyIndex);
            this.initZoneAbnormal("0x0000000803240801", MAGOR_SEVERITY, ZONE_ABNORMAL_TYPE, zoneKeyIndex);
            this.sortAlarmListByseverity();
            document.clearContent();
        }
        catch (IOException e) {
            LOGGER.error((Object)"init FaultDefineUtil IOException.");
        }
        catch (DocumentException e) {
            LOGGER.error((Object)"init FaultDefineUtil DocumentException.");
        }
        catch (SAXException e) {
            LOGGER.error((Object)("setFeature error. " + e.getMessage()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"FaultDefineUtil IOException.");
                }
            }
        }
    }

    private void initZoneAbnormal(String defineId, Byte severity, Byte sourceType, int[] keyIndex) {
        FaultDefine d = new FaultDefine();
        d.setFaultDefineId(defineId);
        d.setSeverity(severity);
        d.setSourceType(sourceType);
        d.setKeyIndex(keyIndex);
        this.defines.add(d);
        this.defineMap.put(defineId + "_" + severity, d);
    }

    private void sortAlarmListByseverity() {
        BeanComparator comparator = new BeanComparator("severity");
        comparator = new ReverseComparator((Comparator)comparator);
        Collections.sort(this.defines, comparator);
    }

    public String getFaultParam(String id, String faultParam, Locale locale) {
        if ("0x0000000803240801".equals(id)) {
            int i;
            String[] faultParams = faultParam.split("###");
            String attackType = "";
            if (faultParams.length > 11 && null != faultParams[11] && ("-".equals(faultParams[11]) || faultParams[11].matches("\\d*"))) {
                for (i = 0; i < (faultParams.length - 8) / 5; ++i) {
                    attackType = 0 == i ? faultParams[8] : attackType + "," + faultParams[8 + i * 5];
                    if (!"com.hs.atic.alart.attack.attackType.67".equals(faultParams[8 + i * 5]) || "-".equals(faultParams[12 + i * 5])) continue;
                    faultParams[12 + i * 5] = FaultDefineUtil.getInstance().getLocationName(faultParams[12 + i * 5]);
                }
            } else {
                for (i = 0; i < (faultParams.length - 8) / 3; ++i) {
                    attackType = 0 == i ? faultParams[8] : attackType + "," + faultParams[8 + i * 3];
                }
            }
            StringBuilder faultParamTemp = new StringBuilder();
            for (int i2 = 0; i2 < faultParams.length; ++i2) {
                faultParamTemp.append(faultParams[i2]);
                if (i2 == faultParams.length - 1) continue;
                faultParamTemp.append("###");
            }
            faultParam = faultParamTemp.toString();
        }
        return faultParam;
    }

    public String getLocationName(String id) {
        StringBuffer locationNames = new StringBuffer();
        String unknownLocStr = AticUtil.getText((String)"atic.bis.location.unknownLoc");
        Set<Long> locationIdFromDevs = this.transStringSet(id, locationNames, unknownLocStr);
        ILibraryFileParentService libraryFileService = (ILibraryFileParentService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileParentService.class);
        ILocationCustomParentService locationCustomService = (ILocationCustomParentService)ServiceContext.getInstance().getService("locationCustomService", ILocationCustomParentService.class);
        for (Long locationId : locationIdFromDevs) {
            String ipLocationName = libraryFileService.getIpLocationNameById(String.valueOf(locationId));
            if (null == ipLocationName) {
                if (locationId >= 3000L) {
                    ipLocationName = locationCustomService.findNameById(String.valueOf(locationId));
                    if (null == ipLocationName) {
                        ipLocationName = unknownLocStr + locationId;
                    }
                } else {
                    ipLocationName = unknownLocStr + locationId;
                }
            }
            locationNames.append(ipLocationName);
            locationNames.append(",");
        }
        return locationNames.substring(0, locationNames.length() - 1);
    }

    private Set<Long> transStringSet(String srcIp, StringBuffer locationNames, String unknownLocStr) {
        String[] ids;
        HashSet<Long> locationIdFromDevs = new HashSet<Long>();
        for (String idTemp : ids = srcIp.split(",")) {
            Long locationIdFromDev = null;
            String id = idTemp.trim();
            if (this.isNumebr(id)) {
                locationIdFromDev = Long.valueOf(id);
            } else {
                String[] idStr = id.split("\\.");
                if (!(4 == idStr.length && this.isNumebr(idStr[0].trim()) && this.isNumebr(idStr[1].trim()) && this.isNumebr(idStr[2].trim()) && this.isNumebr(idStr[3].trim()))) {
                    LOGGER.error((Object)("Location Attack srcIp is wrong. srcIp =  " + id));
                    locationNames.append(AticUtil.getText((String)"atic.bis.location.unknownLoc") + id + ";");
                    continue;
                }
                Long id0 = Long.valueOf(idStr[0].trim());
                Long id1 = Long.valueOf(idStr[1].trim());
                Long id2 = Long.valueOf(idStr[2].trim());
                Long id3 = Long.valueOf(idStr[3].trim());
                locationIdFromDev = id0 * 0x1000000L + id1 * 65536L + id2 * 256L + id3;
            }
            locationIdFromDevs.add(locationIdFromDev);
        }
        return locationIdFromDevs;
    }

    private boolean isNumebr(String str) {
        String regex = "^[0-9]*$";
        return str.matches(regex);
    }
}

