/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.util.ExtendAlert;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import com.hs.lego.nem.fault.sdk.service.ISmsServerService;
import com.hs.lego.nem.fault.sdk.util.FaultSdkUtil;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class RemoteNotifyHelper {
    private static final Object LOCK = new Object();
    private static RemoteNotifyHelper instance = null;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private I18nMrg i18nMgr;
    private IRemoteNotifyRuleService remoteNotifyRuleService = null;
    private IRemoteNotifyServerService remoteNotifyServerService = null;
    private ISmsServerService smsServerService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteNotifyHelper getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new RemoteNotifyHelper();
            }
            return instance;
        }
    }

    public String getText(String key, int language) {
        Locale locale = null;
        locale = language == 1 ? new Locale("zh", "CN") : new Locale("en");
        return this.i18nMgr.getString(key, locale);
    }

    public String getText(String key, int language, String[] parameters) {
        Locale locale = null;
        locale = language == 1 ? new Locale("zh", "CN") : new Locale("en");
        return this.i18nMgr.getString(key, locale, parameters);
    }

    public String getNotifyContext(String sendContent, ExtendAlert alert, int language, StringBuffer upperContent) {
        StringBuilder builder = new StringBuilder();
        String colon = this.getText("lego.lab.fault.notify.colon", language);
        for (String item : sendContent.split(",")) {
            String[] fieldValue = item.split(":");
            if (fieldValue.length != 2) {
                this.logger.info((Object)("The length of sendContent-field-rule is not 2:" + item));
                continue;
            }
            String field = fieldValue[0];
            this.generateContent(alert, language, builder, colon, field, upperContent);
        }
        String content = builder.toString();
        if (content.trim().equals("")) {
            return "";
        }
        return content.substring(0, content.length() - 1);
    }

    private void generateContent(ExtendAlert alert, int language, StringBuilder builder, String colon, String field, StringBuffer upperContent) {
        Locale locale = language == 1 ? new Locale("zh", "CN") : new Locale("en");
        String faultParam = FaultDefineUtil.getInstance().getFaultParam(alert.getAlarmId(), alert.getAlarmParam(), locale);
        String param = this.getAlarmParam(faultParam, language);
        if (null == param) {
            param = "";
        }
        if (field.equalsIgnoreCase("alarmName")) {
            builder.append(this.getText("lego.lab.fault.saveAlarm.name", language));
            builder.append(colon);
            builder.append(this.getText(alert.getAlarmName(), language, FaultSdkUtil.getInstance().convertParam(param)));
            builder.append('\n');
            upperContent.append(field);
            upperContent.append("::");
            upperContent.append(alert.getAlarmName());
            upperContent.append('&');
            upperContent.append(param);
            upperContent.append('@');
        } else if (field.equalsIgnoreCase("source")) {
            builder.append(this.getText("lego.lab.fault.saveAlarm.alarmSource", language));
            builder.append(colon);
            builder.append(alert.getSource());
            if (null != alert.getMoIp() && !"".equals(alert.getMoIp())) {
                builder.append('(');
                builder.append(alert.getMoIp());
                builder.append(')');
            }
            builder.append('\n');
            upperContent.append(field);
            upperContent.append("::");
            upperContent.append(alert.getSource());
            if (null != alert.getMoIp() && !"".equals(alert.getMoIp())) {
                upperContent.append('(');
                upperContent.append(alert.getMoIp());
                upperContent.append(')');
            }
            upperContent.append('@');
        } else if (field.equalsIgnoreCase("severity")) {
            builder.append(this.getText("lego.lab.fault.alarmLevel", language));
            builder.append(colon);
            builder.append(this.getAlarmLevel(alert.getSeverity(), language));
            builder.append('\n');
            upperContent.append(field);
            upperContent.append("::");
            upperContent.append(alert.getSeverity());
            upperContent.append('@');
        } else if (field.equalsIgnoreCase("alarmType")) {
            this.logger.info((Object)"alarmType");
        } else if (field.equalsIgnoreCase("createTime")) {
            builder.append(this.getText("lego.lab.fault.createTime", language));
            builder.append(colon);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (alert.getClearStatus() == 1) {
                builder.append(sdf.format(alert.getClearTime()));
            } else {
                builder.append(sdf.format(alert.getModTime()));
            }
            builder.append('\n');
            upperContent.append(field);
            upperContent.append("::");
            upperContent.append(sdf.format(alert.getModTime()));
            upperContent.append('@');
        } else if (field.equalsIgnoreCase("clearStatus")) {
            builder.append(this.getText("lego.dic.clearstatus", language));
            builder.append(colon);
            builder.append(this.getClearStatus(alert.getClearStatus(), language));
            builder.append('\n');
            upperContent.append(field);
            upperContent.append("::");
            upperContent.append(alert.getClearStatus());
            upperContent.append('@');
        } else if (field.equalsIgnoreCase("alarmDesc")) {
            builder.append(this.getText("lego.lab.com.description", language));
            builder.append(colon);
            String location = this.getText(alert.getAlarmDesc(), language, FaultSdkUtil.getInstance().convertParam(param));
            location = this.replaceAll(location);
            builder.append(location);
            if ("0x0000000803240801".equals(alert.getAlarmId())) {
                String[] faultParams = FaultSdkUtil.getInstance().convertParam(param);
                StringBuffer displayBf = new StringBuffer();
                if ((FaultSdkUtil.getInstance().convertParam(param).length - 8) % 5 == 0) {
                    for (int j = 0; j < (faultParams.length - 8) / 5; ++j) {
                        String attackDesc = this.getText("0x0000000803240801.alarm.attack.detail.desc", language);
                        attackDesc = attackDesc.replace("{0}", faultParams[8 + j * 5]);
                        attackDesc = attackDesc.replace("{1}", faultParams[9 + j * 5]);
                        attackDesc = attackDesc.replace("{2}", faultParams[10 + j * 5]);
                        attackDesc = attackDesc.replace("{3}", faultParams[11 + j * 5]);
                        String detail4 = faultParams[12 + j * 5];
                        if (AticUtil.getText((String)"com.hs.atic.alart.attack.attackType.67").equals(faultParams[8 + j * 5]) && !"-".equals(detail4)) {
                            detail4 = detail4.replace("/", "");
                        }
                        attackDesc = attackDesc.replace("{4}", detail4);
                        displayBf.append(attackDesc);
                    }
                }
                builder.append(this.replaceAll(displayBf.toString()));
            }
            builder.append('\n');
            upperContent.append(field);
            upperContent.append("::");
            upperContent.append(alert.getAlarmDesc());
            upperContent.append('&');
            upperContent.append(param);
            upperContent.append('@');
        }
    }

    private String replaceAll(String str) {
        if (null == str || "".equals(str)) {
            return "";
        }
        str = str.replaceAll("<br>", "\r\n");
        str = str.replaceAll("<Br>", "\r\n");
        str = str.replaceAll("<bR>", "\r\n");
        str = str.replaceAll("<BR>", "\r\n");
        str = str.replaceAll("<br/>", "\r\n");
        str = str.replaceAll("<Br/>", "\r\n");
        str = str.replaceAll("<bR/>", "\r\n");
        str = str.replaceAll("<BR/>", "\r\n");
        str = str.replaceAll("&nbsp;", " ");
        return str;
    }

    public IRemoteNotifyRuleService getRemoteNotifyRuleService() {
        if (null == this.remoteNotifyRuleService) {
            try {
                ServiceContext context = ServiceContext.getInstance();
                this.remoteNotifyRuleService = (IRemoteNotifyRuleService)context.getService("remoteNotifyRuleService", IRemoteNotifyRuleService.class);
            }
            catch (Exception e) {
                this.logger.error((Object)("get remote notify rule service failue. " + e.getMessage()));
            }
            catch (Throwable e) {
                this.logger.error((Object)("get remote notify rule service failue. " + e.getMessage()));
            }
        }
        return this.remoteNotifyRuleService;
    }

    public IRemoteNotifyServerService getRemoteNotifyServerService() {
        if (null == this.remoteNotifyServerService) {
            try {
                ServiceContext context = ServiceContext.getInstance();
                this.remoteNotifyServerService = (IRemoteNotifyServerService)context.getService("remoteNotifyServerService", IRemoteNotifyServerService.class);
            }
            catch (Exception e) {
                this.logger.error((Object)("get remote notify server service failue. " + e.getMessage()));
            }
            catch (Throwable e) {
                this.logger.error((Object)("get remote notify server service failue. " + e.getMessage()));
            }
        }
        return this.remoteNotifyServerService;
    }

    public ISmsServerService getSmsServerService() {
        if (null == this.smsServerService) {
            try {
                ServiceContext context = ServiceContext.getInstance();
                this.smsServerService = (ISmsServerService)context.getService("smsServerService", ISmsServerService.class);
            }
            catch (Exception e) {
                this.logger.error((Object)("get sms service failue. " + e.getMessage()));
            }
        }
        return this.smsServerService;
    }

    private String getAlarmLevel(int level, int language) {
        String levelStr = "";
        switch (level) {
            case 1: {
                levelStr = this.getText("lego.lab.fault.alarmLevel.warning", language);
                break;
            }
            case 2: {
                levelStr = this.getText("lego.lab.fault.alarmLevel.minor", language);
                break;
            }
            case 3: {
                levelStr = this.getText("lego.lab.fault.alarmLevel.major", language);
                break;
            }
            case 4: {
                levelStr = this.getText("lego.lab.fault.alarmLevel.critical", language);
                break;
            }
            default: {
                levelStr = "--";
            }
        }
        return levelStr;
    }

    private String getClearStatus(int status, int language) {
        String statusStr = "";
        switch (status) {
            case 0: {
                statusStr = this.getText("lego.dic.clearstatus.uncleared", language);
                break;
            }
            case 1: {
                statusStr = this.getText("lego.dic.clearstatus.cleared", language);
                break;
            }
            default: {
                statusStr = "--";
            }
        }
        return statusStr;
    }

    private String getAlarmParam(String alarmParam, int language) {
        try {
            String[] params = this.getAlarmParamArray(alarmParam, language);
            return FaultSdkUtil.getInstance().convertParam(params);
        }
        catch (Throwable t) {
            this.logger.error((Object)("getAlarmParam exception. " + t.getMessage()));
            return "";
        }
    }

    private String[] getAlarmParamArray(String alarmParam, int language) {
        if (null == alarmParam) {
            return new String[0];
        }
        String[] param = FaultSdkUtil.getInstance().convertParam(alarmParam);
        if (null == param || param.length <= 0) {
            return new String[0];
        }
        try {
            for (int i = 0; i < param.length; ++i) {
                if (!RemoteNotifyHelper.isValidKey(param[i])) continue;
                param[i] = this.getText(param[i], language);
            }
            return param;
        }
        catch (Throwable t) {
            this.logger.error((Object)("getAlarmParamArray exception. " + t.getMessage()));
            return param;
        }
    }

    private static boolean isValidKey(String key) {
        if (null == key || "".equals(key)) {
            return false;
        }
        int length = key.length();
        for (int i = 0; i < length; ++i) {
            char ch = key.charAt(i);
            if (RemoteNotifyHelper.isCha(ch) || ch >= '0' && ch <= '9' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private static boolean isCha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public I18nMrg getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }
}

