/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.dao;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.dao.IAlertNotifyDAO;
import com.hs.lego.nem.fault.sdk.model.AlertSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class AlertNotifyDAOImpl
extends HibernateDaoSupport
implements IAlertNotifyDAO {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    @Override
    public AlertSetting getAlertSetting(Serializable id, String className) {
        AlertSetting setting = null;
        setting = (AlertSetting)this.getHibernateTemplate().get(className, id);
        return setting;
    }

    @Override
    public List<AlertSetting> getAlertSettingList(String className, Properties prop) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + className + " as setting where ");
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            if (!this.checkParams(String.valueOf(entry.getKey())) || !this.checkParams(String.valueOf(entry.getValue()))) continue;
            queryString.append("setting." + String.valueOf(entry.getKey()) + "=?" + params.size() + " and ");
            params.add(entry.getValue());
        }
        queryString.append("0=?" + params.size());
        params.add(0);
        ArrayList<AlertSetting> settingList = new ArrayList<AlertSetting>();
        List list = this.getHibernateTemplate().find(queryString.toString(), new Object[]{params});
        for (Object obj : list) {
            if (!(obj instanceof AlertSetting)) continue;
            settingList.add((AlertSetting)obj);
        }
        return settingList;
    }

    private boolean checkParams(String name) {
        String regular;
        return null != name && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name);
    }

    @Override
    public boolean addAlertSetting(AlertSetting setting) {
        this.getHibernateTemplate().save((Object)setting);
        return true;
    }

    @Override
    public boolean updateAlertSetting(AlertSetting setting) {
        try {
            this.getHibernateTemplate().update((Object)setting);
        }
        catch (Exception e) {
            LOGGER.error((Object)("--updateAlertSetting--" + e.getMessage()));
        }
        return true;
    }
}

