/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.sdk.model;

import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.nem.fault.sdk.model.FaultDefine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FaultConf {
    private String bundleName;
    private String faultTrapOid;
    private String trapclass;
    private String synchronizeclass;
    private List<FaultDefine> defineList = new ArrayList<FaultDefine>();
    private String[] includeAlarmFile = new String[0];
    private boolean baseCfg = false;
    private Set<String> fileNames = new HashSet<String>();
    private String moMainType = "";
    private String moSubType = "";
    private boolean includeOffLineAlarm = true;

    public FaultConf() {
    }

    public FaultConf(String bundleName, String trapoid, String trapclass, String synchronizeclass) {
        this.bundleName = bundleName;
        this.faultTrapOid = trapoid;
        this.trapclass = trapclass;
        this.synchronizeclass = synchronizeclass;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getFaultTrapOid() {
        return this.faultTrapOid;
    }

    public void setFaultTrapOid(String trapoid) {
        this.faultTrapOid = trapoid;
    }

    public String getTrapclass() {
        return this.trapclass;
    }

    public void setTrapclass(String trapclass) {
        this.trapclass = trapclass;
    }

    public String getSynchronizeclass() {
        return this.synchronizeclass;
    }

    public void setSynchronizeclass(String synchronizeclass) {
        this.synchronizeclass = synchronizeclass;
    }

    public void setDefineList(List<FaultDefine> defineList) {
        this.defineList = defineList;
    }

    public List<FaultDefine> getDefineList() {
        return this.defineList;
    }

    public void addFaultDefine(FaultDefine define) {
        this.defineList.add(define);
    }

    public void addFaultDefine(List<FaultDefine> faultDefineList) {
        this.defineList.addAll(faultDefineList);
    }

    public FaultDefine getFaultDefine(String faultId, String moMainTypeTemp, String moSubTypeTemp) {
        for (FaultDefine faultDefine : this.defineList) {
            if (!this.matchFauleDefine(faultId, faultDefine, moMainTypeTemp, moSubTypeTemp)) continue;
            return faultDefine;
        }
        return null;
    }

    private boolean matchFauleDefine(String faultId, FaultDefine faultDefine, String moMainTypeTemp, String moSubTypeTemp) {
        if (!faultDefine.getFaultId().equals(faultId)) {
            return false;
        }
        if (null == moMainTypeTemp || "".equals(moMainTypeTemp)) {
            return true;
        }
        if (!moMainTypeTemp.equals(faultDefine.getMoMainType())) {
            return false;
        }
        return null == moSubTypeTemp || "".equals(moSubTypeTemp) || moSubTypeTemp.equals(faultDefine.getMoSubType()) || "all".equalsIgnoreCase(faultDefine.getMoSubType());
    }

    public List<FaultDefine> getFaultDefine(String moMainTypeTemp, String moSubTypeTemp) {
        if (null == moMainTypeTemp || "".equals(moMainTypeTemp)) {
            return this.defineList;
        }
        ArrayList<FaultDefine> faultDefineList = new ArrayList<FaultDefine>();
        for (FaultDefine faultDefine : this.defineList) {
            if (!faultDefine.getMoMainType().equals(moMainTypeTemp) || null != moSubTypeTemp && !"".equals(moSubTypeTemp) && !moSubTypeTemp.equals(faultDefine.getMoSubType()) && !"all".equalsIgnoreCase(faultDefine.getMoSubType())) continue;
            faultDefineList.add(faultDefine);
        }
        return faultDefineList;
    }

    public List<FaultDefine> getFaultDefine() {
        return this.defineList;
    }

    public String[] getIncludeAlarmFile() {
        return (String[])ArrayDeepClone.deepClone((Object)this.includeAlarmFile);
    }

    public void setIncludeAlarmFile(String[] includeAlarmFile) {
        this.includeAlarmFile = (String[])ArrayDeepClone.deepClone((Object)includeAlarmFile);
    }

    public boolean isBaseCfg() {
        return this.baseCfg;
    }

    public void setBaseCfg(boolean baseCfg) {
        this.baseCfg = baseCfg;
    }

    public Set<String> getFileNames() {
        return this.fileNames;
    }

    public void addFileNames(String fileName) {
        this.fileNames.add(fileName);
    }

    public String getMoMainType() {
        return this.moMainType;
    }

    public void setMoMainType(String moMainType) {
        this.moMainType = moMainType;
    }

    public String getMoSubType() {
        return this.moSubType;
    }

    public void setMoSubType(String moSubType) {
        this.moSubType = moSubType;
    }

    public boolean isIncludeOffLineAlarm() {
        return this.includeOffLineAlarm;
    }

    public void setIncludeOffLineAlarm(boolean includeOffLineAlarm) {
        this.includeOffLineAlarm = includeOffLineAlarm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleName == null ? 0 : this.bundleName.hashCode());
        result = 31 * result + (this.defineList == null ? 0 : this.defineList.hashCode());
        result = 31 * result + (this.synchronizeclass == null ? 0 : this.synchronizeclass.hashCode());
        result = 31 * result + (this.trapclass == null ? 0 : this.trapclass.hashCode());
        result = 31 * result + (this.faultTrapOid == null ? 0 : this.faultTrapOid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (!(obj instanceof FaultConf)) {
            return false;
        }
        FaultConf other = (FaultConf)obj;
        return other.getBundleName().equals(this.bundleName) && other.getFaultTrapOid().equals(this.faultTrapOid) && other.getTrapclass().equals(this.trapclass) && other.getSynchronizeclass().equals(this.synchronizeclass);
    }
}

