/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.sdk.model;

import com.hs.lego.nem.fault.sdk.model.AlarmStatistic;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OverAllStatistic
implements Serializable {
    private static final long serialVersionUID = -9087609352320137684L;
    private Map<FaultEnum.AlarmSeverity, Integer> unClearedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
    private Map<FaultEnum.AlarmSeverity, Integer> unConfirmedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
    private final Object lock = new Object();

    public OverAllStatistic() {
        this.unClearedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unClearedMap.put(severity, 0);
        }
        this.unConfirmedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unConfirmedMap.put(severity, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnClearedCount(FaultEnum.AlarmSeverity severity) {
        Object object = this.lock;
        synchronized (object) {
            return this.unClearedMap.get(severity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnConfirmedCount(FaultEnum.AlarmSeverity severity) {
        Object object = this.lock;
        synchronized (object) {
            return this.unConfirmedMap.get(severity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(AlarmStatistic statistic) {
        Object object = this.lock;
        synchronized (object) {
            FaultEnum.AlarmSeverity[] severities;
            for (FaultEnum.AlarmSeverity severity : severities = FaultEnum.AlarmSeverity.getAllSeverity()) {
                this.addUnCleared(severity, statistic.getAlarmCount(severity));
                this.addUnConfirmed(severity, statistic.getUnConfirmedCount(severity));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnCleared(FaultEnum.AlarmSeverity severity, Integer count) {
        Object object = this.lock;
        synchronized (object) {
            Integer oldCount = this.unClearedMap.get(severity);
            if (oldCount < 0) {
                oldCount = 0;
            }
            this.unClearedMap.put(severity, oldCount + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnConfirmed(FaultEnum.AlarmSeverity severity, Integer count) {
        Object object = this.lock;
        synchronized (object) {
            int oldCount = this.unConfirmedMap.get(severity);
            if (oldCount < 0) {
                oldCount = 0;
            }
            this.unConfirmedMap.put(severity, oldCount + count);
        }
    }
}

