/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.sdk.model;

import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.hs.lego.nem.fault.sdk.model.NotifyResItem;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RemoteNotifyRule
implements Serializable {
    private static final long serialVersionUID = 4814939727722567457L;
    private long id;
    private int language;
    private String ruleName;
    private boolean isClearEnable;
    private boolean isCriticalEnable;
    private boolean isMajorEnable;
    private boolean isWarningEnable;
    private boolean isInfoEnable;
    private String sendContent;
    private boolean isUseEnable;
    private long startTime;
    private String startTimeStr;
    private long endTime;
    private String endTimeStr;
    private String emailTo;
    private String smsPhone;
    private int smsMode;
    private String description;
    private Set<NotifyResItem> notifyResItems = new HashSet<NotifyResItem>();
    private Set<NotifyAlarmItem> notifyAlarmItems = new HashSet<NotifyAlarmItem>();
    private boolean validStatus;
    private boolean expiredStatus;
    private String moMainType;
    private String moSubType;
    private String userName;

    public boolean contains(String alarmId, String source, int clearStatus, long modTime, long clearTime, long moId, int severity) {
        boolean isContain = false;
        for (NotifyResItem notifyResItem : this.notifyResItems) {
            if (!notifyResItem.getAlarmSource().equalsIgnoreCase(String.valueOf(moId))) continue;
            isContain = true;
            break;
        }
        if (!isContain) {
            return false;
        }
        isContain = false;
        if (!(isContain = this.getAlarmItemContain(alarmId, isContain, severity))) {
            return false;
        }
        if (clearStatus == FaultEnum.ClearState.CLEARED.getValue() && clearTime >= this.startTime && clearTime <= this.endTime) {
            return true;
        }
        return clearStatus == FaultEnum.ClearState.UNCLEARED.getValue() && modTime >= this.startTime && modTime <= this.endTime;
    }

    private boolean getAlarmItemContain(String alarmId, boolean isContain, int severity) {
        for (NotifyAlarmItem notifyAlarmItem : this.notifyAlarmItems) {
            if (!notifyAlarmItem.getAlarmId().equalsIgnoreCase(alarmId) || severity != notifyAlarmItem.getAlarmLevel()) continue;
            isContain = true;
            break;
        }
        return isContain;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int language) {
        this.language = language;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public boolean isIsClearEnable() {
        return this.isClearEnable;
    }

    public void setIsClearEnable(boolean isClearEnable) {
        this.isClearEnable = isClearEnable;
    }

    public boolean isIsCriticalEnable() {
        return this.isCriticalEnable;
    }

    public void setIsCriticalEnable(boolean isCriticalEnable) {
        this.isCriticalEnable = isCriticalEnable;
    }

    public boolean isIsMajorEnable() {
        return this.isMajorEnable;
    }

    public void setIsMajorEnable(boolean isMajorEnable) {
        this.isMajorEnable = isMajorEnable;
    }

    public boolean isIsWarningEnable() {
        return this.isWarningEnable;
    }

    public void setIsWarningEnable(boolean isWarningEnable) {
        this.isWarningEnable = isWarningEnable;
    }

    public boolean isIsInfoEnable() {
        return this.isInfoEnable;
    }

    public void setIsInfoEnable(boolean isInfoEnable) {
        this.isInfoEnable = isInfoEnable;
    }

    public String getEmailTo() {
        return this.emailTo;
    }

    public void setEmailTo(String emailTo) {
        this.emailTo = emailTo;
    }

    public String getSmsPhone() {
        return this.smsPhone;
    }

    public void setSmsPhone(String smsPhone) {
        this.smsPhone = smsPhone;
    }

    public String getSendContent() {
        return this.sendContent;
    }

    public void setSendContent(String sendContent) {
        this.sendContent = sendContent;
    }

    public boolean isIsUseEnable() {
        return this.isUseEnable;
    }

    public void setIsUseEnable(boolean isUseEnable) {
        this.isUseEnable = isUseEnable;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getStartTimeStr() {
        return this.startTimeStr;
    }

    public void setStartTimeStr(String startTimeStr) {
        this.startTimeStr = startTimeStr;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getEndTimeStr() {
        return this.endTimeStr;
    }

    public void setEndTimeStr(String endTimeStr) {
        this.endTimeStr = endTimeStr;
    }

    public int getSmsMode() {
        return this.smsMode;
    }

    public void setSmsMode(int smsMode) {
        this.smsMode = smsMode;
    }

    public Set<NotifyResItem> getNotifyResItems() {
        return this.notifyResItems;
    }

    public void setNotifyResItems(Set<NotifyResItem> notifyResItems) {
        this.notifyResItems = notifyResItems;
    }

    public Set<NotifyAlarmItem> getNotifyAlarmItems() {
        return this.notifyAlarmItems;
    }

    public void setNotifyAlarmItems(Set<NotifyAlarmItem> notifyAlarmItems) {
        this.notifyAlarmItems = notifyAlarmItems;
    }

    public boolean isValidStatus() {
        long currentTime = System.currentTimeMillis();
        this.validStatus = this.isIsUseEnable() && currentTime >= this.getStartTime() && currentTime <= this.getEndTime();
        return this.validStatus;
    }

    public void setValidStatus(boolean validStatus) {
        this.validStatus = validStatus;
    }

    public boolean isExpiredStatus() {
        return this.expiredStatus;
    }

    public void setExpiredStatus(boolean expiredStatus) {
        this.expiredStatus = expiredStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMoMainType() {
        return this.moMainType;
    }

    public void setMoMainType(String moMainType) {
        this.moMainType = moMainType;
    }

    public String getMoSubType() {
        return this.moSubType;
    }

    public void setMoSubType(String moSubType) {
        this.moSubType = moSubType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

