/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.service;

import com.hs.lego.cbb.fault.sdk.service.IAlertNotifyParentService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.dao.IAlertNotifyDAO;
import com.hs.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.hs.lego.nem.fault.sdk.model.AlertSetting;
import com.hs.lego.nem.fault.sdk.service.IAlertNotifyService;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AlertNotifyServiceImpl
implements IAlertNotifyService,
IAlertNotifyParentService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private List<AlertAudioSetting> settingBuffer;
    private IAlertNotifyDAO alertNotifyDAO = null;

    @Override
    public List<AlertAudioSetting> getAllAudioSetting() {
        return this.getAudioSettingList(new Properties());
    }

    public List<AlertAudioSetting> getAudioSettingList(Properties prop) {
        if (null == prop) {
            LOGGER.info((Object)"get alert setting list failed, prop is null.");
            return null;
        }
        if (null == this.settingBuffer || this.settingBuffer.isEmpty()) {
            this.settingBuffer = this.getAlertSettingList(new Properties());
        }
        if (!prop.isEmpty()) {
            return this.getAlertSettingList(prop);
        }
        return this.settingBuffer;
    }

    private List<AlertAudioSetting> getAlertSettingList(Properties prop) {
        ArrayList<AlertAudioSetting> audioSettings = new ArrayList<AlertAudioSetting>();
        List<AlertSetting> settingList = this.alertNotifyDAO.getAlertSettingList(AlertAudioSetting.class.getName(), prop);
        for (AlertSetting setting : settingList) {
            if (!(setting instanceof AlertAudioSetting)) continue;
            audioSettings.add((AlertAudioSetting)setting);
        }
        return audioSettings;
    }

    @Override
    public AlertAudioSetting getAudioSetting(long userId) {
        List<AlertAudioSetting> audioSettings = this.getAllAudioSetting();
        for (AlertAudioSetting setting : audioSettings) {
            if (setting.getAlertUserId() != userId) continue;
            return setting;
        }
        AlertAudioSetting setting = new AlertAudioSetting();
        setting.setAlertUserId(userId);
        setting.setIsEnabled(true);
        setting.setIsEnabledCritical(true);
        setting.setAudioCritical(1);
        this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        this.settingBuffer = this.getAlertSettingList(new Properties());
        List<AlertAudioSetting> settings = this.getAllAudioSetting();
        for (AlertAudioSetting sett : settings) {
            if (sett.getAlertUserId() != userId) continue;
            return sett;
        }
        return null;
    }

    @Override
    public boolean setAudioSetting(AlertAudioSetting setting) {
        boolean result;
        if (null == setting) {
            LOGGER.info((Object)"set AudioSetting failed, setting is null.");
            return false;
        }
        AlertAudioSetting oldSetting = this.getAudioSetting(setting.getAlertUserId());
        if (null == oldSetting) {
            result = this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        } else {
            setting.setIsEnabled(oldSetting.isIsEnabled());
            result = this.alertNotifyDAO.updateAlertSetting((AlertSetting)setting);
        }
        this.settingBuffer = this.getAlertSettingList(new Properties());
        return result;
    }

    @Override
    public boolean modifyAudioStatus(long userId, boolean isEnabled) {
        boolean result;
        AlertAudioSetting setting = this.getAudioSetting(userId);
        if (null == setting) {
            setting = new AlertAudioSetting();
            setting.setIsEnabled(isEnabled);
            setting.setAlertUserId(userId);
            result = this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        } else {
            setting.setIsEnabled(isEnabled);
            result = this.alertNotifyDAO.updateAlertSetting((AlertSetting)setting);
        }
        this.settingBuffer = this.getAlertSettingList(new Properties());
        return result;
    }

    public IAlertNotifyDAO getAlertNotifyDAO() {
        return this.alertNotifyDAO;
    }

    public void setAlertNotifyDAO(IAlertNotifyDAO alertNotifyDAO) {
        this.alertNotifyDAO = alertNotifyDAO;
    }

    public AlertAudioSetting getAudioSettingForm(long userId) {
        List<AlertAudioSetting> audioSettings = this.getAllAudioSetting();
        for (AlertAudioSetting setting : audioSettings) {
            if (setting.getAlertUserId() != userId) continue;
            return setting;
        }
        AlertAudioSetting setting = new AlertAudioSetting();
        setting.setAlertUserId(userId);
        setting.setIsEnabled(true);
        setting.setIsEnabledCritical(true);
        setting.setAudioCritical(1);
        this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        this.settingBuffer = this.getAlertSettingList(new Properties());
        List<AlertAudioSetting> settings = this.getAllAudioSetting();
        for (AlertAudioSetting sett : settings) {
            if (sett.getAlertUserId() != userId) continue;
            return sett;
        }
        return null;
    }
}

