/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.monitor.util.FileFactory;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class ExportUtil {
    private static ExportUtil instance = new ExportUtil();
    private static Map<String, String> resourcesProperties = new HashMap<String, String>();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    private ExportUtil() {
    }

    public static ExportUtil getInstance() {
        return instance;
    }

    public FileUtil export(BaseAction action, HttpSession session, HttpServletResponse response, List<Fault> faultList, boolean isCurrentAlarm) {
        boolean ret;
        String downloadPath = session.getServletContext().getRealPath("") + File.separator + "export";
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            throw new LegoCheckedException(1L);
        }
        SimpleDateFormat dfFileName = new SimpleDateFormat("yyyyMMddHHmmss");
        String downFileName = "";
        downFileName = isCurrentAlarm ? "CurrentAlarms_" + dfFileName.format(System.currentTimeMillis()) + new SecureRandom().nextInt(100) : "HistoryAlarms_" + dfFileName.format(System.currentTimeMillis()) + new SecureRandom().nextInt(100);
        downloadPath = downloadPath + File.separator + downFileName;
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getResourcesValue(action, "lego.lab.fault.alarmLevel"));
        column.add(this.getResourcesValue(action, "lego.dic.confirmstatus"));
        column.add(this.getResourcesValue(action, "lego.dic.clearstatusstr"));
        column.add(this.getResourcesValue(action, "lego.lab.fault.saveAlarm.name"));
        column.add(this.getResourcesValue(action, "lego.lab.fault.alarmCount"));
        column.add(this.getResourcesValue(action, "lego.dic.warningtype"));
        column.add(this.getResourcesValue(action, "lego.lab.fault.saveAlarm.alarmSource"));
        column.add(this.getResourcesValue(action, "lego.lab.fault.firstTime"));
        column.add(this.getResourcesValue(action, "lego.lab.fault.lastTime"));
        column.add(this.getResourcesValue(action, "lego.lab.fault.description"));
        FileUtil fileUtil = FileFactory.getFileUtil("excel");
        if (null != fileUtil) {
            fileUtil.fileSet("", column, downloadPath);
            if (Locale.SIMPLIFIED_CHINESE.equals(session.getAttribute("WW_TRANS_I18N_LOCALE"))) {
                fileUtil.setStrChar("GBK");
            }
            User currentUser = (User)session.getAttribute("currentUser");
            fileUtil.setStrUsrName(currentUser.getUserName());
            fileUtil.setDownFileName(downFileName);
            fileUtil.writeFile(this.alarmToStr(action, faultList));
            try {
                fileUtil.closeFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException error");
            }
        }
        return fileUtil;
    }

    private List<List<String>> alarmToStr(BaseAction action, List<Fault> faultList) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (Fault fault : faultList) {
            if (null == fault) continue;
            ArrayList<String> tempLst = new ArrayList<String>();
            SimpleDateFormat dfDateToStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tempLst.add(this.getResourcesValue(action, "lego.lab.fault.severity." + fault.getSeverity()));
            tempLst.add(this.getResourcesValue(action, "lego.lab.fault.confirmStatus." + fault.getConfirmStatus()));
            tempLst.add(this.getResourcesValue(action, "lego.lab.fault.clearStatus." + fault.getClearStatus()));
            tempLst.add(this.getResourcesValue(action, fault.getFaultDefineId() + ".alarm.name"));
            tempLst.add(fault.getCount().toString());
            tempLst.add(this.getResourcesValue(action, "lego.lab.fault.sourceType." + fault.getSourceType()));
            tempLst.add(fault.getSource());
            tempLst.add(dfDateToStr.format(fault.getCreateTime()));
            tempLst.add(dfDateToStr.format(fault.getModTime()));
            Object[] param = fault.getFaultParamArray();
            for (int i = 0; i < param.length; ++i) {
                if (!param[i].contains(".") || param[i].contains("}") || param[i].contains("{")) continue;
                param[i] = this.getResourcesValue(action, (String)param[i]);
            }
            if (param.length > 0) {
                String attackDesc;
                int j;
                StringBuffer buf;
                String tmpDesc = this.getResourcesValue(action, fault.getFaultDefineId() + ".alarm.desc");
                tmpDesc = MessageFormat.format(tmpDesc, param);
                if (param.length > 11 && null != param[11] && ("-".equals(param[11]) || ((String)param[11]).matches("\\d*"))) {
                    if ((param.length - 8) % 5 == 0) {
                        buf = new StringBuffer();
                        buf.append(tmpDesc);
                        for (j = 0; j < (param.length - 8) / 5; ++j) {
                            if (AticUtil.getText((String)"com.hs.atic.alart.attack.attackType.67").equals(param[8 + j * 5]) && !"-".equals(param[12 + j * 5])) {
                                param[12 + j * 5] = FaultDefineUtil.getInstance().getLocationName((String)param[12 + j * 5]);
                            }
                            attackDesc = action.getText("0x0000000803240801.alarm.attack.detail.desc");
                            attackDesc = attackDesc.replace("{0}", (CharSequence)param[8 + j * 5]);
                            attackDesc = attackDesc.replace("{1}", (CharSequence)param[9 + j * 5]);
                            attackDesc = attackDesc.replace("{2}", (CharSequence)param[10 + j * 5]);
                            attackDesc = attackDesc.replace("{3}", (CharSequence)param[11 + j * 5]);
                            attackDesc = attackDesc.replace("{4}", (CharSequence)param[12 + j * 5]);
                            buf.append(attackDesc);
                        }
                        tmpDesc = buf.toString();
                    }
                } else if ((param.length - 8) % 3 == 0) {
                    buf = new StringBuffer();
                    buf.append(tmpDesc);
                    for (j = 0; j < (param.length - 8) / 3; ++j) {
                        attackDesc = action.getText("0x0000000803240801.alarm.attack.detail.desc");
                        attackDesc = attackDesc.replace("{0}", (CharSequence)param[8 + j * 3]);
                        attackDesc = attackDesc.replace("{1}", (CharSequence)param[9 + j * 3]);
                        attackDesc = attackDesc.replace("{2}", (CharSequence)param[10 + j * 3]);
                        attackDesc = attackDesc.replace("{3}", "--");
                        attackDesc = attackDesc.replace("{4}", "--");
                        buf.append(attackDesc);
                    }
                    tmpDesc = buf.toString();
                }
                if (tmpDesc.contains("<br>")) {
                    tmpDesc = tmpDesc.replaceAll("<br>", "\n");
                }
                tempLst.add(tmpDesc);
            } else {
                tempLst.add(this.getResourcesValue(action, fault.getFaultDefineId() + ".alarm.desc"));
            }
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    public String getResourcesValue(BaseAction action, String key) {
        String keyLocale = key + "_" + action.getLocale();
        String value = resourcesProperties.get(keyLocale);
        if (value != null) {
            return value;
        }
        value = action.getText(key);
        resourcesProperties.put(keyLocale, value);
        return value;
    }
}

