/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.tree.DataElement;
import com.hs.lego.core.sdk.util.tree.DataExchange;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import com.hs.lego.nem.topo.sdk.model.ITreeElements;
import com.hs.lego.nem.topo.sdk.model.UIElement;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceTreeAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final Long TYPE_NODE = 0L;
    private static final Long TYPE_GROUP = 3L;
    private String systemMoShow = null;

    public String produceDeviceTree() {
        LOGGER.info((Object)" produceDeviceTree -----");
        String systemMoTemp = this.getSystemMoShow();
        boolean showCount = false;
        Long userId = null;
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (!"true".equalsIgnoreCase(currentUser.getIsAdmin())) {
            userId = currentUser.getUserID();
        }
        IDeviceTypeMgr deviceTypeMgr = (IDeviceTypeMgr)ServiceContext.getInstance().getService("deviceTypeMgr", IDeviceTypeMgr.class);
        RootDataElement treeRoot = deviceTypeMgr.getDeviceTypeTreeWithoutDev(userId, Boolean.valueOf(true));
        if (systemMoTemp != null && systemMoTemp.equalsIgnoreCase("true")) {
            IDataExplore dataExplore = (IDataExplore)ServiceContext.getInstance().getService("deviceDataExplore", IDataExplore.class);
            TopoObject rootMo = dataExplore.getRootMO();
            MainDeviceTypeState mainType = new MainDeviceTypeState();
            mainType.setDeviceCount(Long.valueOf(1L));
            mainType.setGroupId(0L);
            if (null != rootMo) {
                mainType.setMainDeviceTypeName(rootMo.getMainType());
            }
            DataElement typeGroup = this.createMainTypeNode(mainType, 0, showCount);
            if (null != rootMo) {
                typeGroup.addChildEle((UIElement)this.createSubTypeNode(rootMo.getSubType(), 0));
            }
            treeRoot.addChildEle((UIElement)typeGroup);
        }
        treeRoot.setDisName(this.getText("lego.dic.discoverypolicy.devicetype"));
        treeRoot.setDescription(this.getText("lego.dic.discoverypolicy.devicetype"));
        this.processDeviceType(treeRoot);
        DataExchange convert = new DataExchange();
        String xmlResult = convert.getStringByModel(treeRoot);
        Pattern p = Pattern.compile("\\t|\r|\n");
        Matcher m = p.matcher(xmlResult);
        String after = m.replaceAll("");
        this.fetchRequest().setAttribute("xmlResult", (Object)after);
        return "success";
    }

    private void processDeviceType(RootDataElement root) {
        Set childEles = root.getChildEleUI();
        for (UIElement child : childEles) {
            this.processDeviceTypeBase((ITreeElements)child);
        }
    }

    private void processDeviceTypeBase(ITreeElements parentEle) {
        Long eleType;
        UIElement curEle = (UIElement)parentEle;
        if (curEle != null && (eleType = curEle.getEleType()).equals(3L)) {
            curEle.setDisName(this.getText(curEle.getDisName()));
        }
        if (null != parentEle) {
            Set childEles = parentEle.getChildEleUI();
            for (UIElement child : childEles) {
                this.processDeviceTypeBase((ITreeElements)child);
            }
        }
    }

    private DataElement createMainTypeNode(MainDeviceTypeState mainType, int i, boolean showCount) {
        DataElement typeGroup = new DataElement();
        typeGroup.setId(Long.valueOf(i));
        typeGroup.setEleType(TYPE_GROUP);
        typeGroup.setEntityId(mainType.getMainDeviceTypeName());
        typeGroup.setDisName(this.getText(mainType.getMainDeviceTypeName()));
        typeGroup.setToolTip(this.getText(mainType.getMainDeviceTypeName()));
        return typeGroup;
    }

    private DataElement createSubTypeNode(String subType, int i) {
        DataElement subTypeNode = new DataElement();
        subTypeNode.setId(Long.valueOf(i));
        subTypeNode.setEleType(TYPE_NODE);
        subTypeNode.setEntityId(subType);
        subTypeNode.setDisName(this.getText(subType));
        subTypeNode.setToolTip(this.getText(subType));
        return subTypeNode;
    }

    public String getSystemMoShow() {
        return this.systemMoShow;
    }

    public void setSystemMoShow(String systemMoShow) {
        this.systemMoShow = systemMoShow;
    }
}

