/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.monitor.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;

public class ExcelFileUtil
extends FileUtil {
    public static final int DATA_START_ROW = 2;
    public static final int START_ROW_NUM = 1;
    private static final int NUM_2 = 1;
    private static final int COLUMNWIDTH = 8000;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final String TAB = " ";
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataLst) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"writeFile file not found exception");
            return;
        }
        this.writeExcelString(dataLst);
    }

    private void writeExcelString(List<List<String>> dataLst) {
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowColUsr = sheet.createRow(0);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(TAB + this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(1);
        for (int i = 0; i < num; ++i) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(TAB + this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 2;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); ++cellNumOfRow) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(CellType.STRING);
                sheet.setColumnWidth(cellNumOfRow, 8000);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(TAB + lstStr.get(cellNumOfRow));
                    continue;
                }
                cell.setCellValue("");
            }
            ++rowNumOfSheet;
        }
    }

    @Override
    public void closeFile() throws IOException {
        this.workbook.write((OutputStream)this.getWriteFileOut());
        this.getWriteFileOut().flush();
        this.getWriteFileOut().close();
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailLink) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"writeFile file not found exception");
            return;
        }
        this.writeExcelWithDetail(dataLst, detailLink);
    }

    private void writeExcelWithDetail(List<List<String>> dataLst, String detailLink) {
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowColUsr = sheet.createRow(0);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(TAB + this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(1);
        for (int i = 0; i < num; ++i) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(TAB + this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 2;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size() - 1; ++cellNumOfRow) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(CellType.STRING);
                sheet.setColumnWidth(cellNumOfRow, 8000);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(TAB + lstStr.get(cellNumOfRow));
                } else {
                    cell.setCellValue("");
                }
                String logId = lstStr.get(lstStr.size() - 1);
                if (logId.equals("-1") || cellNumOfRow != lstStr.size() - 2) continue;
                HSSFCellStyle linkStyle = this.workbook.createCellStyle();
                HSSFFont font = this.workbook.createFont();
                font.setFontName("Arial");
                font.setUnderline((byte)1);
                font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
                linkStyle.setFont(font);
                String strVal = "";
                if (null != lstStr.get(cellNumOfRow)) {
                    strVal = lstStr.get(cellNumOfRow);
                }
                cell.setCellStyle(linkStyle);
                cell.setCellFormula("HYPERLINK(\"" + detailLink + logId + ".txt\",\"" + strVal + "\")");
            }
            ++rowNumOfSheet;
        }
    }

    public void writeData2File(Map<String, List<List<String>>> mapData) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"file not found exception");
            return;
        }
        for (int lableNum = 0; lableNum < this.getLabelName().size(); ++lableNum) {
            List<String> colTitle;
            String labelName;
            if (lableNum == 0) {
                labelName = this.getLabelName().get(lableNum);
                colTitle = this.getColTitleList().get(lableNum);
                List<List<String>> usageList = mapData.get("usage");
                this.writeExcelData(labelName, colTitle, usageList);
                continue;
            }
            if (lableNum != 1) continue;
            labelName = this.getLabelName().get(lableNum);
            colTitle = this.getColTitleList().get(lableNum);
            List<List<String>> trafficList = mapData.get("traffic");
            this.writeExcelData(labelName, colTitle, trafficList);
        }
    }

    private void writeExcelData(String labelName, List<String> colTitle, List<List<String>> dataList) {
        HSSFSheet sheet = this.workbook.createSheet(labelName);
        HSSFRow rowColTitle = sheet.createRow(0);
        for (int i = 0; i < colTitle.size(); ++i) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(TAB + colTitle.get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 1;
        for (List<String> lstStr : dataList) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); ++cellNumOfRow) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(CellType.STRING);
                sheet.setColumnWidth(cellNumOfRow, 8000);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(TAB + lstStr.get(cellNumOfRow));
                    continue;
                }
                cell.setCellValue("");
            }
            ++rowNumOfSheet;
        }
    }
}

