/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.neglobal.util;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.XmlUtil;
import com.hs.atic.zone.util.CheckImportXml;
import com.hs.atic.zone.util.PolicyDefaultValueUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.BaseCommonUtil;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpKeyDetectUriForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloDomainWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.ImportForm;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.xml.sax.SAXException;

public final class ImportParserUtil {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String POLICY_PROTOCOL_TCP = "TCP";
    private static final String POLICY_PROTOCOL_UDP = "UDP";
    private static final String POLICY_PROTOCOL_ICMP = "ICMP";
    private static final String POLICY_PROTOCOL_OTHER = "Other";
    private static final String POLICY_PROTOCOL_DNS = "DNS";
    private static final String POLICY_PROTOCOL_SIP = "SIP";
    private static final String POLICY_PROTOCOL_HTTP = "HTTP";
    private static final String POLICY_PROTOCOL_HTTPS = "HTTPS";
    private static final String POLICY_PROTOCOL_TOP_N_STUDY = "Top N Study";
    private static final String POLICY_PROTOCOL_DEFAULT = "DEFAULT";
    private static final String TRUE = "1";
    private static final String TRUE_BOOLEAN = "true";
    private static final String PACKET_CAPTURE_LENGTH_TYPE = "3";
    private static ImportParserUtil zoneImportParser = null;

    private ImportParserUtil() {
    }

    public static ImportParserUtil getInstance() {
        if (null == zoneImportParser) {
            try {
                zoneImportParser = (ImportParserUtil)ImportParserUtil.class.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return zoneImportParser;
    }

    public static ImportForm parseZoneImport(String filePath) {
        File file = null;
        FileInputStream fileInputStream = null;
        ImportForm form = new ImportForm();
        try {
            file = new File(filePath);
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            LOG.error((Object)"file is null");
            throw new LegoCheckedException(571980L, (Throwable)e);
        }
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = XmlUtil.configureSecureInfoForDocumentBuilder((DocumentBuilderFactory)dbf);
            Document document = new DOMReader().read(db.parse(fileInputStream));
            if (null == document) {
                LOG.error((Object)"document is null");
                throw new LegoCheckedException(571982L);
            }
            Element root = document.getRootElement();
            String dimension = root.elementText("dimension");
            String time = root.elementText("time");
            String systemVersion = root.elementText("system-version");
            if (StringUtils.isEmpty((CharSequence)dimension) || StringUtils.isEmpty((CharSequence)time) || StringUtils.isEmpty((CharSequence)systemVersion)) {
                LOG.error((Object)"dimension or time or systemVersion is null");
                throw new LegoCheckedException(571981L);
            }
            if (!AticUtil.getAticVersion().equals(systemVersion) && !"ATIC".equals(systemVersion)) {
                LOG.error((Object)"System Version is incorrect.");
                throw new LegoCheckedException(571981L);
            }
            if (!AticUtil.isValidDate((String)time)) {
                LOG.error((Object)"time format error");
                throw new LegoCheckedException(571981L);
            }
            if (!"device".equals(dimension)) {
                LOG.error((Object)"Dimension is incorrect.");
                throw new LegoCheckedException(571981L);
            }
            form.setDimension(dimension);
            form.setTime(time);
            form.setSystemVersion(systemVersion);
            String needLocation = root.elementText("need-location");
            String needFilter = root.elementText("need-filter");
            String needPolicy = root.elementText("need-policy");
            if (!TRUE_BOOLEAN.equals(needLocation)) {
                form.setNeedLocation(false);
            }
            if (!TRUE_BOOLEAN.equals(needFilter)) {
                form.setNeedFilter(false);
            }
            if (!TRUE_BOOLEAN.equals(needPolicy)) {
                form.setNeedPolicy(false);
            }
            ImportParserUtil.parseByDevice(root, form);
            ArrayList<ZonePolicyApplyForm> zoneFormList = new ArrayList<ZonePolicyApplyForm>();
            ImportParserUtil.parseZoneInfo(root, zoneFormList);
            form.setZoneFormList(zoneFormList);
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)("File format is incorrect:" + le.getMessage()));
            if (571988L == le.getErrorCode()) {
                throw new LegoCheckedException(571988L, (Throwable)le);
            }
            throw new LegoCheckedException(571981L, (Throwable)le);
        }
        catch (SAXException e1) {
            LOG.error((Object)("File format is incorrect:" + e1.getMessage()));
            throw new LegoCheckedException(571981L, (Throwable)e1);
        }
        catch (IOException e2) {
            LOG.error((Object)"File format is incorrect IOException");
            throw new LegoCheckedException(571981L, (Throwable)e2);
        }
        catch (ParserConfigurationException e3) {
            LOG.error((Object)("File format is incorrect:" + e3.getMessage()));
            throw new LegoCheckedException(571981L, (Throwable)e3);
        }
        catch (NumberFormatException e4) {
            LOG.error((Object)("File format is incorrect:" + e4.getMessage()));
            throw new LegoCheckedException(632010L, (Throwable)e4);
        }
        catch (ArrayIndexOutOfBoundsException e5) {
            LOG.error((Object)("File contains incorrent range." + e5.getMessage()));
            throw new LegoCheckedException(632011L, (Throwable)e5);
        }
        catch (IllegalArgumentException e6) {
            LOG.error((Object)("File contains incorrent parameter." + e6.getMessage()));
            throw new LegoCheckedException(632012L, (Throwable)e6);
        }
        catch (RuntimeException e7) {
            LOG.error((Object)("File format is incorrect:" + e7.getMessage()));
            throw new LegoCheckedException(571981L, (Throwable)e7);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    fileInputStream = null;
                }
            }
        }
        return form;
    }

    private static boolean isEmptyString(String s) {
        return AticUtil.isNull((String)s);
    }

    private static DnsDefendPolicyForm dnsParse(Element elementPolicy, String policyProtocol) {
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String sourceRateLimitingEnable = elementPolicy.elementText("source-rate-limiting-enable");
        String requestSourceIpAddressEnable = elementPolicy.elementText("rate-limiting-on-request-packets-of-source-ip-address-enable");
        String requestSourceIpAddressThreshold = elementPolicy.elementText("rate-limiting-on-request-packets-of-source-ip-address-threshold");
        String replytSourceIpAddressEnable = elementPolicy.elementText("rate-limiting-on-reply-packets-of-source-ip-address-enable");
        String replySourceIpAddressThreshold = elementPolicy.elementText("rate-limiting-on-reply-packets-of-source-ip-address-threshold");
        String cacheServerEnable = elementPolicy.elementText("unique-configuration-item-of-the-cache-server-enable");
        String cacheServerRFADefenseEnable = elementPolicy.elementText("cache-server-dns-request-flood-attack-defense-enable");
        String cacheServerRFADefenseMode = elementPolicy.elementText("cache-server-dns-request-flood-attack-defense-mode");
        String cacheServerRFADefenseThreshold = elementPolicy.elementText("cache-server-dns-request-flood-attack-defense-threshold");
        String authorizationServerEnable = elementPolicy.elementText("unique-configuration-item-of-the-authorization-server-enable");
        String authDefenseEnable = elementPolicy.elementText("authorization-server-dns-request-flood-attack-defense-enable");
        String authDefenseMode = elementPolicy.elementText("authorization-server-dns-request-flood-attack-defense-mode");
        String authDefenseThreshold = elementPolicy.elementText("authorization-server-dns-request-flood-attack-defense-threshold");
        String replyRFADefenseEnable = elementPolicy.elementText("dns-reply-flood-attack-defense-enable");
        String replyRFADefenseThreshold = elementPolicy.elementText("dns-reply-flood-attack-defense-threshold");
        String nxdomainEnable = elementPolicy.elementText("detection-of-the-requests-for-nxdomain-enable");
        String nxdomain = elementPolicy.elementText("proportion-taken-by-the-requests-for-nxdomain");
        String malformedEnable = elementPolicy.elementText("packet-malformed-enable");
        String malformedThreshold = elementPolicy.elementText("packet-malformed-threshold");
        String limitingEnable = elementPolicy.elementText("dns-request-packet-length-limiting-enable");
        String limitingThreshold = elementPolicy.elementText("dns-request-packet-length-limiting-threshold");
        String replyLimitingEnable = elementPolicy.elementText("dns-reply-packet-length-limiting-enable");
        String replyLimitingThreshold = elementPolicy.elementText("dns-reply-packet-length-limiting-threshold");
        String dnsFirestPacketCheck = elementPolicy.elementText("dns-first-packet-check-enable");
        String dnsFirestPacketCheckInterval = elementPolicy.elementText("dns-first-packet-check-interval");
        DnsDefendPolicyForm dnsDefendPolicyForm = new DnsDefendPolicyForm();
        dnsDefendPolicyForm.setDirection(1);
        String blockEnable = elementPolicy.elementText("block-enable");
        if (TRUE.equals(blockEnable)) {
            dnsDefendPolicyForm.setDnsBlock(Boolean.valueOf(true));
            dnsDefendPolicyForm.setLimitEnable(Boolean.valueOf(false));
            dnsDefendPolicyForm.setDnsDefendEnable(Boolean.valueOf(false));
        } else {
            dnsDefendPolicyForm.setDnsBlock(Boolean.valueOf(false));
        }
        if (TRUE.equals(sourceRateLimitingEnable)) {
            dnsDefendPolicyForm.setLimitEnable(Boolean.valueOf(true));
            dnsDefendPolicyForm.setDnsLimitRate(Integer.valueOf(200));
            if (TRUE.equals(requestSourceIpAddressEnable)) {
                dnsDefendPolicyForm.setSrcipReqLimitEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(requestSourceIpAddressThreshold)) {
                    dnsDefendPolicyForm.setSrcipReqAlertRate(Integer.valueOf(requestSourceIpAddressThreshold));
                }
            } else {
                dnsDefendPolicyForm.setSrcipReqLimitEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(replytSourceIpAddressEnable)) {
                dnsDefendPolicyForm.setSrcipRespLimitEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(replySourceIpAddressThreshold)) {
                    dnsDefendPolicyForm.setSrcipRespAlertRate(Integer.valueOf(replySourceIpAddressThreshold));
                }
            } else {
                dnsDefendPolicyForm.setSrcipRespLimitEnable(Boolean.valueOf(false));
            }
        } else {
            dnsDefendPolicyForm.setLimitEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(defenseEnable)) {
            dnsDefendPolicyForm.setDnsDefendEnable(Boolean.valueOf(true));
            if (TRUE.equals(cacheServerEnable)) {
                dnsDefendPolicyForm.setDnsCacheServerEnable(Boolean.valueOf(true));
                if (TRUE.equals(cacheServerRFADefenseEnable)) {
                    dnsDefendPolicyForm.setDnsFloodEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(cacheServerRFADefenseMode)) {
                        dnsDefendPolicyForm.setDefendMode(Integer.valueOf(cacheServerRFADefenseMode));
                    }
                    if (!ImportParserUtil.isEmptyString(cacheServerRFADefenseThreshold)) {
                        dnsDefendPolicyForm.setAlertRate(Integer.valueOf(cacheServerRFADefenseThreshold));
                    }
                } else {
                    dnsDefendPolicyForm.setDnsFloodEnable(Boolean.valueOf(false));
                }
            }
            if (TRUE.equals(authorizationServerEnable)) {
                dnsDefendPolicyForm.setDnsAuthServerEnable(Boolean.valueOf(true));
                if (TRUE.equals(authDefenseEnable)) {
                    dnsDefendPolicyForm.setDnsFloodEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(authDefenseMode)) {
                        dnsDefendPolicyForm.setDefendMode(Integer.valueOf(authDefenseMode));
                    }
                    if (!ImportParserUtil.isEmptyString(authDefenseThreshold)) {
                        dnsDefendPolicyForm.setAlertRate(Integer.valueOf(authDefenseThreshold));
                    }
                } else {
                    dnsDefendPolicyForm.setDnsFloodEnable(Boolean.valueOf(false));
                }
            }
            if (TRUE.equals(replyRFADefenseEnable)) {
                dnsDefendPolicyForm.setReplyFloodEnable(Boolean.valueOf(true));
                dnsDefendPolicyForm.setReplyFloodSrcDectectEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(replyRFADefenseThreshold)) {
                    dnsDefendPolicyForm.setReplyFloodAlertRate(Integer.valueOf(replyRFADefenseThreshold));
                }
            } else {
                dnsDefendPolicyForm.setReplyFloodEnable(Boolean.valueOf(false));
                dnsDefendPolicyForm.setReplyFloodSrcDectectEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(nxdomainEnable)) {
                dnsDefendPolicyForm.setNoSuchNameCheckEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(nxdomain)) {
                    dnsDefendPolicyForm.setNoSuchNameCheckAlertRatio(Integer.valueOf(nxdomain));
                }
            } else {
                dnsDefendPolicyForm.setNoSuchNameCheckEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(malformedEnable)) {
                dnsDefendPolicyForm.setFormatCheckEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(malformedThreshold)) {
                    dnsDefendPolicyForm.setFormatCheckRatio(Integer.valueOf(malformedThreshold));
                }
            } else {
                dnsDefendPolicyForm.setFormatCheckEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(limitingEnable)) {
                dnsDefendPolicyForm.setDnsRequestMessageLenLimitEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(limitingThreshold)) {
                    dnsDefendPolicyForm.setDnsRequestMessageLen(Integer.valueOf(limitingThreshold));
                }
            } else {
                dnsDefendPolicyForm.setDnsRequestMessageLenLimitEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(replyLimitingEnable)) {
                dnsDefendPolicyForm.setDnsReponseMessageLenLimitEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(replyLimitingThreshold)) {
                    dnsDefendPolicyForm.setDnsResponseMessageLen(Integer.valueOf(replyLimitingThreshold));
                }
            } else {
                dnsDefendPolicyForm.setDnsReponseMessageLenLimitEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(dnsFirestPacketCheck)) {
                dnsDefendPolicyForm.setDnsEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(dnsFirestPacketCheckInterval)) {
                    String[] synInterVals = dnsFirestPacketCheckInterval.split("-");
                    dnsDefendPolicyForm.setDnsLowerLimit(Integer.valueOf(synInterVals[0]));
                    dnsDefendPolicyForm.setDnsUpperLimit(Integer.valueOf(synInterVals[1]));
                }
            } else {
                dnsDefendPolicyForm.setDnsEnable(Boolean.valueOf(false));
            }
        } else {
            dnsDefendPolicyForm.setDnsDefendEnable(Boolean.valueOf(false));
        }
        return dnsDefendPolicyForm;
    }

    private static TcpDefendPolicyForm tcpParse(Element elementPolicy) {
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        tcpDefendPolicyForm.setDirection(1);
        String blockEnable = elementPolicy.elementText("block-enable");
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String tcpTrafficLimitingEnable = elementPolicy.elementText("tcp-traffic-limiting-enable");
        String tcpTrafficLimitingThreshold = elementPolicy.elementText("tcp-traffic-limiting-threshold");
        String tcpFragmentTrafficLimitingEnable = elementPolicy.elementText("tcp-fragment-traffic-limiting-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("tcp-fragment-traffic-limiting-threshold");
        String tcpNewDestSessionLimitingEnable = elementPolicy.elementText("tcp-new-dest-session-limiting-enable");
        String tcpNewDestSessionLimitingThreshold = elementPolicy.elementText("tcp-new-dest-session-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String tcpDefenseEnable = elementPolicy.elementText("tcp-abnormal-defense-enable");
        String tcpDefenseThreshold = elementPolicy.elementText("tcp-abnormal-defense-threshold");
        String tcpBasicDefenseEnable = elementPolicy.elementText("tcp-basic-defense-enable");
        String synFloodAttackDefenseEnable = elementPolicy.elementText("syn-flood-attack-defense-enable");
        String synFloodAttackDefenseFirstPacketCheckEnable = elementPolicy.elementText("syn-flood-attack-defense-first-packet-check-enable");
        String synFloodAttackDefenseFirstPacketCheckInterval = elementPolicy.elementText("syn-flood-attack-defense-first-packet-check-interval");
        String synFloodAttackDefenseThreshold = elementPolicy.elementText("syn-flood-attack-defense-threshold");
        String synflooddefendmodeEnable = elementPolicy.elementText("syn-flood-attack-defense-auth-enable");
        String synfloodMode = elementPolicy.elementText("syn-flood-attack-defense-auth-mode");
        String synRationLimiteEnable = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-enable");
        String synRationLimiteThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-threshold");
        String synRationLimitecycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-cycle");
        String synRationLimitePacketsThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-threshold");
        String synRationLimitePacketscycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-cycle");
        String synAckFloodEnable = elementPolicy.elementText("synack-flood-attack-defense-enable");
        String synAckFloodAlertRate = elementPolicy.elementText("synack-flood-attack-defense-threshold");
        String synAckSourceEnable = elementPolicy.elementText("synack-flood-attack-defense-source-enable");
        String synAckFirstPacketCheckEnable = elementPolicy.elementText("synack-flood-attack-defense-first-packet-check-enable");
        String synAckLimit = elementPolicy.elementText("synack-flood-attack-defense-first-packet-check-interval");
        String synAckIllegalSessionEnable = elementPolicy.elementText("synack-flood-abnormal-session-check-enable");
        String synAckIllegalConnCount = elementPolicy.elementText("synack-flood-abnormal-session-check-threshold");
        String synAckIllegalConnCountInterval = elementPolicy.elementText("synack-flood-abnormal-session-check-interval");
        String synAckIllegalConnNum = elementPolicy.elementText("synack-flood-minimum-packets-per-connection-num");
        String synAckIllegalConnNumInterval = elementPolicy.elementText("synack-flood--minimum-packets-per-connection-interval");
        String ackDefenseEnable = elementPolicy.elementText("ack-flood-attack-defense-enable");
        String ackDefenseMode = elementPolicy.elementText("ack-flood-attack-defense-mode");
        String ackDefenseThreshold = elementPolicy.elementText("ack-flood-attack-defense-threshold");
        String tcpFragmentAttackDefenseEnable = elementPolicy.elementText("tcp-fragment-attack-defense-enable");
        String tcpFragmentAattackDefenseTthreshold = elementPolicy.elementText("tcp-fragment-attack-defense-threshold");
        String finDefenseEnable = elementPolicy.elementText("fin-flood-attack-defense-enable");
        String finDefenseThreshold = elementPolicy.elementText("fin-flood-attack-defense-threshold");
        String tcpFirestPacketCheck = elementPolicy.elementText("tcp-first-packet-check-enable");
        String tcpFirestPacketCheckInterval = elementPolicy.elementText("tcp-first-packet-check-interval");
        String sourceIpLimitingEnable = elementPolicy.elementText("source-ip-tcp-ratio-anomaly-limiting-enable");
        String sourceIpLimitingThreshold = elementPolicy.elementText("source-ip-tcp-ratio-anomaly-limiting-threshold");
        String tcpConnectionDefenseEnable = elementPolicy.elementText("tcp-connection-flood-attack-defense-enable");
        String destinationIpAddressThreshold = elementPolicy.elementText("concurrent-connection-check-by-destination-ip-address-threshold");
        String newDestinationIpAddressThreshold = elementPolicy.elementText("new-connection-rate-check-by-destination-ip-address-threshold");
        String newSourceIpAddressEnable = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-enable");
        String newSourceIpAddressThreshold = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-threshold");
        String newSourceIpAddressCheckCycle = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-check-cycle");
        String sourceIpAddressEnable = elementPolicy.elementText("connection-number-check-for-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("connection-number-check-for-source-ip-address-threshold");
        String abnormalSessionCheckEnable = elementPolicy.elementText("abnormal-session-check-enable");
        String abnormalSessionCheckThreshold = elementPolicy.elementText("abnormal-session-check-threshold");
        String abnormalSessionCheckCheckCycle = elementPolicy.elementText("abnormal-session-check-check-cycle");
        String connectionCheckEnable = elementPolicy.elementText("null-connection-check-enable");
        String connectionCheckMinimumPacketsPerConnection = elementPolicy.elementText("null-connection-check-minimum-packets-per-connection");
        String connectionCheckCheckCycle = elementPolicy.elementText("null-connection-check-check-cycle");
        String retransmissionSessionCheckEnable = elementPolicy.elementText("retransmission-session-check-enable");
        String packetNumberThreshold = elementPolicy.elementText("retransmission-session-check-retransmission-packet-number-threshold");
        String sockstressEnable = elementPolicy.elementText("sockstress-enable");
        String windowSizeThreshold = elementPolicy.elementText("sockstress-tcp-window-size-threshold");
        String sessionCheckEnable = elementPolicy.elementText("session-check-enable");
        String sessionConnRate = elementPolicy.elementText("session-conn-rate");
        String sessionCheckDuration = elementPolicy.elementText("session-check-duration");
        String ackCheckEnable = elementPolicy.elementText("ack-check-enable");
        String ackMinPacketsNum = elementPolicy.elementText("ack-min-packets-num");
        String bigPacketLength = elementPolicy.elementText("big-packet-length");
        String bigPacketRatio = elementPolicy.elementText("big-packet-ratio");
        String synCheckEnable = elementPolicy.elementText("syn-check-enable");
        String synPacketsNum = elementPolicy.elementText("syn-packets-num");
        String synratioLimitPackets = elementPolicy.elementText("syn-ratio-Limit-packets");
        String synBlackListEnable = elementPolicy.elementText("syn-blackList-enable");
        String synExceptionTimes = elementPolicy.elementText("syn-exception-times");
        String synTotalCheckTimes = elementPolicy.elementText("syn-total-check-times");
        if (TRUE.equals(blockEnable)) {
            tcpDefendPolicyForm.setTcpBlock(Boolean.valueOf(true));
            tcpDefendPolicyForm.setTcpLimitEnable(Boolean.valueOf(false));
            tcpDefendPolicyForm.setTcpDefendEnable(Boolean.valueOf(false));
        } else {
            tcpDefendPolicyForm.setTcpBlock(Boolean.valueOf(false));
            ImportParserUtil.tcpDefendPolicyTrafficLimitingEnable(tcpDefendPolicyForm, trafficLimitingEnable);
            ImportParserUtil.tcpDefendPolicyTcpLimitSubEnable(tcpDefendPolicyForm, tcpTrafficLimitingEnable);
            if (!ImportParserUtil.isEmptyString(tcpTrafficLimitingThreshold)) {
                tcpDefendPolicyForm.setMaxSpeed(Integer.valueOf(tcpTrafficLimitingThreshold));
            }
            ImportParserUtil.tcpDefendPolicyTcpFragLimitEnable(tcpDefendPolicyForm, tcpFragmentTrafficLimitingEnable, trafficLimitingThreshold);
            ImportParserUtil.tcpDefendPolicyTcpNewDestSessionLimitEnable(tcpDefendPolicyForm, tcpNewDestSessionLimitingEnable, tcpNewDestSessionLimitingThreshold);
            ImportParserUtil.tcpDefendPolicyTcpDefendEnable(tcpDefendPolicyForm, defenseEnable);
            if (TRUE.equals(tcpDefenseEnable)) {
                tcpDefendPolicyForm.setTcpAbnormalEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(tcpDefenseThreshold)) {
                    tcpDefendPolicyForm.setTcpAbnormalAlertRate(Integer.valueOf(tcpDefenseThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpAbnormalEnable(Boolean.valueOf(false));
            }
            boolean tcpBasic = false;
            if (TRUE.equals(tcpBasicDefenseEnable)) {
                tcpBasic = true;
                tcpDefendPolicyForm.setTcpBasicEnable(Boolean.valueOf(true));
            } else {
                tcpBasic = false;
                tcpDefendPolicyForm.setTcpBasicEnable(Boolean.valueOf(false));
            }
            ImportParserUtil.tcpDefendPolicySynFloodAttackDefenseEnable(tcpDefendPolicyForm, synFloodAttackDefenseEnable, synFloodAttackDefenseFirstPacketCheckEnable, synFloodAttackDefenseFirstPacketCheckInterval, synFloodAttackDefenseThreshold, synflooddefendmodeEnable, synfloodMode, tcpBasic);
            ImportParserUtil.tcpDefendPolicySynRationLimiteEnable(tcpDefendPolicyForm, synRationLimiteEnable, synRationLimiteThreshold, synRationLimitecycle, synRationLimitePacketsThreshold, synRationLimitePacketscycle, synratioLimitPackets, tcpBasic);
            if (tcpBasic && TRUE.equals(synAckFloodEnable)) {
                ImportParserUtil.tcpDefendPolicySynAckFloodEnable(tcpDefendPolicyForm, synAckFloodAlertRate, synAckSourceEnable, synAckFirstPacketCheckEnable, synAckLimit);
                ImportParserUtil.tcpDefendPolicySynFloodIllegalSession(tcpDefendPolicyForm, synAckIllegalSessionEnable, synAckIllegalConnCount, synAckIllegalConnCountInterval, synAckIllegalConnNum, synAckIllegalConnNumInterval);
            }
            ImportParserUtil.tcpDefendPolicyAckDefenseEnable(tcpDefendPolicyForm, ackDefenseEnable, ackDefenseMode, ackDefenseThreshold, tcpBasic);
            ImportParserUtil.tcpDefendPolicyTcpFragmentAttackDefenseEnable(tcpDefendPolicyForm, tcpFragmentAttackDefenseEnable, tcpFragmentAattackDefenseTthreshold, tcpBasic);
            ImportParserUtil.tcpDefendPolicyFinDefenseEnable(tcpDefendPolicyForm, finDefenseEnable, finDefenseThreshold, tcpBasic);
            ImportParserUtil.tcpDefendPolicyTcpFirestPacketCheck(tcpDefendPolicyForm, tcpFirestPacketCheck, tcpFirestPacketCheckInterval, tcpBasic);
            ImportParserUtil.tcpDefendPolicySourceIpLimitingEnable(tcpDefendPolicyForm, sourceIpLimitingEnable, sourceIpLimitingThreshold, tcpBasic);
            ImportParserUtil.tcpDefendPolicyTcpConnectionDefenseEnable(tcpDefendPolicyForm, tcpConnectionDefenseEnable, destinationIpAddressThreshold, newDestinationIpAddressThreshold);
            ImportParserUtil.tcpDefendPolicyNewSourceIpAddressEnable(tcpDefendPolicyForm, newSourceIpAddressEnable, newSourceIpAddressThreshold, newSourceIpAddressCheckCycle);
            ImportParserUtil.tcpDefendPolicySourceIpAddressEnable(tcpDefendPolicyForm, sourceIpAddressEnable, sourceIpAddressThreshold);
            ImportParserUtil.tcpDefendPolicyAbnormalSessionCheckEnable(tcpDefendPolicyForm, abnormalSessionCheckEnable, abnormalSessionCheckThreshold, abnormalSessionCheckCheckCycle);
            ImportParserUtil.tcpDefendPolicyConnectionCheckEnable(tcpDefendPolicyForm, connectionCheckEnable, connectionCheckMinimumPacketsPerConnection, connectionCheckCheckCycle);
            ImportParserUtil.tcpDefendPolicyRetransmissionSessionCheckEnable(tcpDefendPolicyForm, retransmissionSessionCheckEnable, packetNumberThreshold);
            ImportParserUtil.tcpDefendPolicySockstressEnable(tcpDefendPolicyForm, sockstressEnable, windowSizeThreshold);
            ImportParserUtil.tcpDefendPolicySessionCheckEnable(tcpDefendPolicyForm, sessionCheckEnable, sessionConnRate, sessionCheckDuration);
            ImportParserUtil.tcpDefendPolicyAckCheckEnable(tcpDefendPolicyForm, sessionConnRate, ackCheckEnable, ackMinPacketsNum, bigPacketLength, bigPacketRatio);
            ImportParserUtil.tcpDefendPolicySynCheckEnable(tcpDefendPolicyForm, synCheckEnable, synPacketsNum);
            ImportParserUtil.tcpDefendPolicySynBlackListEnable(tcpDefendPolicyForm, synBlackListEnable, synExceptionTimes, synTotalCheckTimes);
        }
        return tcpDefendPolicyForm;
    }

    private static void tcpDefendPolicySynBlackListEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String synBlackListEnable, String synExceptionTimes, String synTotalCheckTimes) {
        if (TRUE.equals(synBlackListEnable)) {
            tcpDefendPolicyForm.setSynBlackListEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(synExceptionTimes)) {
                tcpDefendPolicyForm.setSynExceptionTimes(Integer.valueOf(synExceptionTimes));
            }
            if (!ImportParserUtil.isEmptyString(synTotalCheckTimes)) {
                tcpDefendPolicyForm.setSynTotalCheckTimes(Integer.valueOf(synTotalCheckTimes));
            }
        } else {
            tcpDefendPolicyForm.setSynBlackListEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySynCheckEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String synCheckEnable, String synPacketsNum) {
        if (TRUE.equals(synCheckEnable)) {
            tcpDefendPolicyForm.setSynCheckEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(synPacketsNum)) {
                tcpDefendPolicyForm.setSynPacketsNum(Integer.valueOf(synPacketsNum));
            }
        } else {
            tcpDefendPolicyForm.setSynCheckEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyAckCheckEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String sessionConnRate, String ackCheckEnable, String ackMinPacketsNum, String bigPacketLength, String bigPacketRatio) {
        if (TRUE.equals(ackCheckEnable)) {
            tcpDefendPolicyForm.setAckCheckEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(sessionConnRate)) {
                tcpDefendPolicyForm.setAckMinPacketsNum(Integer.valueOf(ackMinPacketsNum));
            }
            if (!ImportParserUtil.isEmptyString(bigPacketLength)) {
                tcpDefendPolicyForm.setBigPacketLength(Integer.valueOf(bigPacketLength));
            }
            if (!ImportParserUtil.isEmptyString(bigPacketRatio)) {
                tcpDefendPolicyForm.setBigPacketRatio(Integer.valueOf(bigPacketRatio));
            }
        } else {
            tcpDefendPolicyForm.setAckCheckEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySessionCheckEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String sessionCheckEnable, String sessionConnRate, String sessionCheckDuration) {
        if (TRUE.equals(sessionCheckEnable)) {
            tcpDefendPolicyForm.setSessionCheckEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(sessionConnRate)) {
                tcpDefendPolicyForm.setSessionConnRate(Integer.valueOf(sessionConnRate));
            }
            if (!ImportParserUtil.isEmptyString(sessionCheckDuration)) {
                tcpDefendPolicyForm.setSessionCheckDuration(Integer.valueOf(sessionCheckDuration));
            }
        } else {
            tcpDefendPolicyForm.setSessionCheckEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySockstressEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String sockstressEnable, String windowSizeThreshold) {
        if (TRUE.equals(sockstressEnable)) {
            tcpDefendPolicyForm.setWindowSizeCheckEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(windowSizeThreshold)) {
                tcpDefendPolicyForm.setWindowSize(Integer.valueOf(windowSizeThreshold));
            }
        } else {
            tcpDefendPolicyForm.setWindowSizeCheckEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyRetransmissionSessionCheckEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String retransmissionSessionCheckEnable, String packetNumberThreshold) {
        if (TRUE.equals(retransmissionSessionCheckEnable)) {
            tcpDefendPolicyForm.setSackCheckEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(packetNumberThreshold)) {
                tcpDefendPolicyForm.setSackCheckMaxNumber(Integer.valueOf(packetNumberThreshold));
            }
        } else {
            tcpDefendPolicyForm.setSackCheckEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyConnectionCheckEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String connectionCheckEnable, String connectionCheckMinimumPacketsPerConnection, String connectionCheckCheckCycle) {
        if (TRUE.equals(connectionCheckEnable)) {
            tcpDefendPolicyForm.setIllegalMinConnNumEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(connectionCheckMinimumPacketsPerConnection)) {
                tcpDefendPolicyForm.setIllegalConnNum(Integer.valueOf(connectionCheckMinimumPacketsPerConnection));
            }
            if (!ImportParserUtil.isEmptyString(connectionCheckCheckCycle)) {
                tcpDefendPolicyForm.setIllegalConnNumInterval(Integer.valueOf(connectionCheckCheckCycle));
            }
        } else {
            tcpDefendPolicyForm.setIllegalMinConnNumEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyAbnormalSessionCheckEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String abnormalSessionCheckEnable, String abnormalSessionCheckThreshold, String abnormalSessionCheckCheckCycle) {
        if (TRUE.equals(abnormalSessionCheckEnable)) {
            tcpDefendPolicyForm.setIllegalSessionEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(abnormalSessionCheckThreshold)) {
                tcpDefendPolicyForm.setIllegalConnCount(Integer.valueOf(abnormalSessionCheckThreshold));
            }
            if (!ImportParserUtil.isEmptyString(abnormalSessionCheckCheckCycle)) {
                tcpDefendPolicyForm.setIllegalConnCountInterval(Integer.valueOf(abnormalSessionCheckCheckCycle));
            }
        } else {
            tcpDefendPolicyForm.setIllegalSessionEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySourceIpAddressEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String sourceIpAddressEnable, String sourceIpAddressThreshold) {
        if (TRUE.equals(sourceIpAddressEnable)) {
            tcpDefendPolicyForm.setTcpSrctipEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                tcpDefendPolicyForm.setTcpSrctipNum(Integer.valueOf(sourceIpAddressThreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpSrctipEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyNewSourceIpAddressEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String newSourceIpAddressEnable, String newSourceIpAddressThreshold, String newSourceIpAddressCheckCycle) {
        if (TRUE.equals(newSourceIpAddressEnable)) {
            tcpDefendPolicyForm.setTcpNewSrctipEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(newSourceIpAddressThreshold)) {
                tcpDefendPolicyForm.setTcpNewSrctipRate(Integer.valueOf(newSourceIpAddressThreshold));
            }
            if (!ImportParserUtil.isEmptyString(newSourceIpAddressCheckCycle)) {
                tcpDefendPolicyForm.setTcpNewSrctipInterval(Integer.valueOf(newSourceIpAddressCheckCycle));
            }
        } else {
            tcpDefendPolicyForm.setTcpNewSrctipEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpConnectionDefenseEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String tcpConnectionDefenseEnable, String destinationIpAddressThreshold, String newDestinationIpAddressThreshold) {
        if (TRUE.equals(tcpConnectionDefenseEnable)) {
            tcpDefendPolicyForm.setTcpConnEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(destinationIpAddressThreshold)) {
                tcpDefendPolicyForm.setTcpDesttipNum(Integer.valueOf(destinationIpAddressThreshold));
            }
            if (!ImportParserUtil.isEmptyString(newDestinationIpAddressThreshold)) {
                tcpDefendPolicyForm.setTcpNewDestipRate(Integer.valueOf(newDestinationIpAddressThreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpConnEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySourceIpLimitingEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String sourceIpLimitingEnable, String sourceIpLimitingThreshold, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(sourceIpLimitingEnable)) {
            tcpDefendPolicyForm.setTcpratioEnable(Boolean.valueOf(true));
            tcpDefendPolicyForm.setTcpratioLimitMode(Integer.valueOf(1));
            tcpDefendPolicyForm.setTcpratioProtion(Integer.valueOf(20));
            if (!ImportParserUtil.isEmptyString(sourceIpLimitingThreshold)) {
                tcpDefendPolicyForm.setTcpratioLimitRate(Integer.valueOf(sourceIpLimitingThreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpratioEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpFirestPacketCheck(TcpDefendPolicyForm tcpDefendPolicyForm, String tcpFirestPacketCheck, String tcpFirestPacketCheckInterval, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(tcpFirestPacketCheck)) {
            tcpDefendPolicyForm.setTcpEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(tcpFirestPacketCheckInterval)) {
                String[] synInterVals = tcpFirestPacketCheckInterval.split("-");
                tcpDefendPolicyForm.setTcpLowerLimit(Integer.valueOf(synInterVals[0]));
                tcpDefendPolicyForm.setTcpUpperLimit(Integer.valueOf(synInterVals[1]));
            }
        } else {
            tcpDefendPolicyForm.setTcpEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyFinDefenseEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String finDefenseEnable, String finDefenseThreshold, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(finDefenseEnable)) {
            tcpDefendPolicyForm.setFinRstFloodEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(finDefenseThreshold)) {
                tcpDefendPolicyForm.setFinRstFloodAlertRate(Integer.valueOf(finDefenseThreshold));
            }
        } else {
            tcpDefendPolicyForm.setFinRstFloodEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpFragmentAttackDefenseEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String tcpFragmentAttackDefenseEnable, String tcpFragmentAattackDefenseTthreshold, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(tcpFragmentAttackDefenseEnable)) {
            tcpDefendPolicyForm.setTcpFragEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(tcpFragmentAattackDefenseTthreshold)) {
                tcpDefendPolicyForm.setTcpFragAlertRate(Integer.valueOf(tcpFragmentAattackDefenseTthreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpFragEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyAckDefenseEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String ackDefenseEnable, String ackDefenseMode, String ackDefenseThreshold, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(ackDefenseEnable)) {
            tcpDefendPolicyForm.setAckFloodEnable(Boolean.valueOf(true));
            String string = ackDefenseMode = ImportParserUtil.isEmptyString(ackDefenseMode) ? Constant.ACK_FLOODMODE_BASIC.toString() : ackDefenseMode;
            if (!ImportParserUtil.isEmptyString(ackDefenseThreshold)) {
                tcpDefendPolicyForm.setAckFloodMode(Integer.valueOf(ackDefenseMode));
                tcpDefendPolicyForm.setAckFloodAlertRate(Integer.valueOf(ackDefenseThreshold));
            }
        } else {
            tcpDefendPolicyForm.setAckFloodEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySynAckFloodEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String synAckFloodAlertRate, String synAckSourceEnable, String synAckFirstPacketCheckEnable, String synAckLimit) {
        tcpDefendPolicyForm.setSynAckFloodEnable(Boolean.valueOf(true));
        if (!ImportParserUtil.isEmptyString(synAckFloodAlertRate) && Pattern.matches("^[1-9]\\d{0,7}$", synAckFloodAlertRate)) {
            tcpDefendPolicyForm.setSynAckFloodAlertRate(Integer.valueOf(synAckFloodAlertRate));
        }
        boolean mark = false;
        if (TRUE.equals(synAckSourceEnable)) {
            tcpDefendPolicyForm.setSynAckSourceEnable(Boolean.valueOf(true));
        } else {
            tcpDefendPolicyForm.setSynAckSourceEnable(Boolean.valueOf(false));
            mark = true;
        }
        if (TRUE.equals(synAckFirstPacketCheckEnable)) {
            String[] synAckLimits;
            tcpDefendPolicyForm.setSynAckFirstPacketCheckEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(synAckLimit) && Pattern.matches("^\\d{1,2}\\-[1-9][0-9]?$", synAckLimit) && !"00".equals((synAckLimits = synAckLimit.split("-"))[0])) {
                tcpDefendPolicyForm.setSynAckLowerLimit(Integer.valueOf(synAckLimits[0]));
                tcpDefendPolicyForm.setSynAckUpperLimit(Integer.valueOf(synAckLimits[1]));
            }
        } else {
            tcpDefendPolicyForm.setSynAckFirstPacketCheckEnable(Boolean.valueOf(false));
            mark = true;
        }
        if (mark) {
            tcpDefendPolicyForm.setSynAckSourceEnable(Boolean.valueOf(true));
        }
    }

    private static void tcpDefendPolicySynFloodIllegalSession(TcpDefendPolicyForm tcpDefendPolicyForm, String synAckIllegalSessionEnable, String synAckIllegalConnCount, String synAckIllegalConnCountInterval, String synAckIllegalConnNum, String synAckIllegalConnNumInterval) {
        if (TRUE.equals(synAckIllegalSessionEnable)) {
            tcpDefendPolicyForm.setSynAckIllegalSessionEnable(Boolean.valueOf(true));
        }
        if (!ImportParserUtil.isEmptyString(synAckIllegalConnCount)) {
            tcpDefendPolicyForm.setSynAckIllegalConnCount(Integer.valueOf(synAckIllegalConnCount));
        }
        if (!ImportParserUtil.isEmptyString(synAckIllegalConnCountInterval)) {
            tcpDefendPolicyForm.setSynAckIllegalConnCountInterval(Integer.valueOf(synAckIllegalConnCountInterval));
        }
        if (!ImportParserUtil.isEmptyString(synAckIllegalConnNum)) {
            tcpDefendPolicyForm.setSynAckIllegalConnNum(Integer.valueOf(synAckIllegalConnNum));
        }
        if (!ImportParserUtil.isEmptyString(synAckIllegalConnNumInterval)) {
            tcpDefendPolicyForm.setSynAckIllegalConnNumInterval(Integer.valueOf(synAckIllegalConnNumInterval));
        } else {
            tcpDefendPolicyForm.setSynAckIllegalSessionEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySynRationLimiteEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String synRationLimiteEnable, String synRationLimiteThreshold, String synRationLimitecycle, String synRationLimitePacketsThreshold, String synRationLimitePacketscycle, String synratioLimitPackets, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(synRationLimiteEnable)) {
            tcpDefendPolicyForm.setSynratioEnable(Boolean.valueOf(true));
            if (ImportParserUtil.isEmptyString(synratioLimitPackets)) {
                tcpDefendPolicyForm.setSynratioLimitPackets(PolicyDefaultValueUtil.paraDefault((String)"synratioLimitPackets"));
            } else {
                tcpDefendPolicyForm.setSynratioLimitPackets(Integer.valueOf(synratioLimitPackets));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimiteThreshold)) {
                tcpDefendPolicyForm.setSynratioLimitRate(Integer.valueOf(synRationLimiteThreshold));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimitecycle)) {
                tcpDefendPolicyForm.setSynratioDuration(Integer.valueOf(synRationLimitecycle));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimitePacketsThreshold)) {
                tcpDefendPolicyForm.setSynMaxPackets(Integer.valueOf(synRationLimitePacketsThreshold));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimitePacketscycle)) {
                tcpDefendPolicyForm.setSynMaxPacketsDuration(Integer.valueOf(synRationLimitePacketscycle));
            }
        } else {
            tcpDefendPolicyForm.setSynratioEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicySynFloodAttackDefenseEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String synFloodAttackDefenseEnable, String synFloodAttackDefenseFirstPacketCheckEnable, String synFloodAttackDefenseFirstPacketCheckInterval, String synFloodAttackDefenseThreshold, String synflooddefendmodeEnable, String synfloodMode, boolean tcpBasic) {
        if (tcpBasic && TRUE.equals(synFloodAttackDefenseEnable)) {
            tcpDefendPolicyForm.setSynfloodEnable(Boolean.valueOf(true));
            boolean mark = false;
            if (TRUE.equals(synFloodAttackDefenseFirstPacketCheckEnable)) {
                tcpDefendPolicyForm.setSynFirstPacketCheckEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(synFloodAttackDefenseFirstPacketCheckInterval)) {
                    String[] synFloodAttackDefenseInterval = synFloodAttackDefenseFirstPacketCheckInterval.split("-");
                    tcpDefendPolicyForm.setFirstPacketCheckLowerLimit(Integer.valueOf(synFloodAttackDefenseInterval[0]));
                    tcpDefendPolicyForm.setFirstPacketCheckUpperLimit(Integer.valueOf(synFloodAttackDefenseInterval[1]));
                } else {
                    tcpDefendPolicyForm.setFirstPacketCheckLowerLimit(Integer.valueOf(2));
                    tcpDefendPolicyForm.setFirstPacketCheckUpperLimit(Integer.valueOf(6));
                }
            } else {
                tcpDefendPolicyForm.setSynFirstPacketCheckEnable(Boolean.valueOf(false));
                mark = true;
            }
            tcpDefendPolicyForm.setSynfloodAlertRate(Integer.valueOf(synFloodAttackDefenseThreshold));
            if ("0".equals(synfloodMode) || TRUE.equals(synfloodMode)) {
                tcpDefendPolicyForm.setSynFloodDefendModeEnable(Boolean.valueOf(true));
                tcpDefendPolicyForm.setSynfloodMode(Integer.valueOf(synfloodMode));
            } else if (TRUE.equals(synflooddefendmodeEnable)) {
                tcpDefendPolicyForm.setSynFloodDefendModeEnable(Boolean.valueOf(true));
                tcpDefendPolicyForm.setSynfloodMode(Integer.valueOf(1));
            }
            if (mark && (null == tcpDefendPolicyForm.getSynFloodDefendModeEnable() || !tcpDefendPolicyForm.getSynFloodDefendModeEnable().booleanValue())) {
                tcpDefendPolicyForm.setSynFloodDefendModeEnable(Boolean.valueOf(true));
                tcpDefendPolicyForm.setSynfloodMode(Integer.valueOf(1));
            }
        } else {
            tcpDefendPolicyForm.setSynfloodEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpDefendEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String defenseEnable) {
        if (TRUE.equals(defenseEnable)) {
            tcpDefendPolicyForm.setTcpDefendEnable(Boolean.valueOf(true));
        } else {
            tcpDefendPolicyForm.setTcpDefendEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpNewDestSessionLimitEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String tcpNewDestSessionLimitingEnable, String tcpNewDestSessionLimitingThreshold) {
        if (TRUE.equals(tcpNewDestSessionLimitingEnable)) {
            tcpDefendPolicyForm.setTcpNewDestSessionLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(tcpNewDestSessionLimitingThreshold)) {
                tcpDefendPolicyForm.setTcpNewDestSessionLimit(Long.valueOf(tcpNewDestSessionLimitingThreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpNewDestSessionLimitEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpFragLimitEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String tcpFragmentTrafficLimitingEnable, String trafficLimitingThreshold) {
        if (TRUE.equals(tcpFragmentTrafficLimitingEnable)) {
            tcpDefendPolicyForm.setTcpFragLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                tcpDefendPolicyForm.setFragMaxSpeed(Integer.valueOf(trafficLimitingThreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpFragLimitEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTcpLimitSubEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String tcpTrafficLimitingEnable) {
        if (TRUE.equals(tcpTrafficLimitingEnable)) {
            tcpDefendPolicyForm.setTcpLimitSubEnable(Boolean.valueOf(true));
        } else {
            tcpDefendPolicyForm.setTcpLimitSubEnable(Boolean.valueOf(false));
        }
    }

    private static void tcpDefendPolicyTrafficLimitingEnable(TcpDefendPolicyForm tcpDefendPolicyForm, String trafficLimitingEnable) {
        if (TRUE.equals(trafficLimitingEnable)) {
            tcpDefendPolicyForm.setTcpLimitEnable(Boolean.valueOf(true));
        } else {
            tcpDefendPolicyForm.setTcpLimitEnable(Boolean.valueOf(false));
        }
    }

    private static List<ZonePolicyApplyForm> parseZoneInfo(Element root, List<ZonePolicyApplyForm> zoneFormList) {
        if (null == root) {
            return zoneFormList;
        }
        List elementsList = root.element("zone-list").elements("zone");
        if (null != elementsList && !elementsList.isEmpty()) {
            for (Element element : elementsList) {
                ZonePolicyApplyForm zonePolicyApplyForm = new ZonePolicyApplyForm();
                ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
                ImportParserUtil.parserSetUpZoneInfo(zoneInfoForm, element);
                zonePolicyApplyForm.setZoneInfoForm(zoneInfoForm);
                ImportParserUtil.parserFaultSeverityRule(zonePolicyApplyForm, element, true);
                ImportParserUtil.parserSetUpZoneIPInfo(element, zonePolicyApplyForm, zoneInfoForm);
                ImportParserUtil.parserSetUpZonePortInfo(element, zonePolicyApplyForm, zoneInfoForm);
                ImportParserUtil.parserSetUpZoneDeviceInfo(element, zonePolicyApplyForm);
                Element elementModeInfo = element.element("defense-mode-info");
                ImportParserUtil.parserZoneTrafficDiversionMode(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneDefendMode(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneDynamicBlackListMode(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneBlackhole2(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneLimitRate(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneIpLimit(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneAudit(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneIpReputation(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneDestSessionLimit(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneBlackhole(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneFilterDropThreshold(zonePolicyApplyForm, elementModeInfo);
                ImportParserUtil.parserZoneFilterIdList(element, zonePolicyApplyForm);
                ImportParserUtil.parserZoneIpLocation(element, zonePolicyApplyForm);
                ImportParserUtil.parserZoneBlackList(element, zonePolicyApplyForm);
                ImportParserUtil.parserZoneWhiteList(element, zonePolicyApplyForm);
                ArrayList<ZoneServiceForm> inboundZoneServices = new ArrayList<ZoneServiceForm>();
                List elementDefensePolicyList = element.element("defense-policy-list").elements("defense-policy");
                if (null != elementDefensePolicyList && !elementDefensePolicyList.isEmpty()) {
                    ImportParserUtil.parserInboundZoneServiceForm(inboundZoneServices, elementDefensePolicyList);
                }
                Element elementOutbound = element.element("outbound");
                ArrayList<ZoneServiceForm> outboundZoneServices = new ArrayList<ZoneServiceForm>();
                if (null != elementOutbound) {
                    ImportParserUtil.parserOutboundZoneService(zonePolicyApplyForm, elementOutbound, outboundZoneServices);
                }
                ArrayList<ZoneServiceForm> allZoneServices = new ArrayList<ZoneServiceForm>();
                if (!inboundZoneServices.isEmpty()) {
                    allZoneServices.addAll(inboundZoneServices);
                }
                if (!outboundZoneServices.isEmpty()) {
                    allZoneServices.addAll(outboundZoneServices);
                } else if (null != zoneInfoForm.getZoneType() && 2 == zoneInfoForm.getZoneType()) {
                    for (ZoneDeviceForm form : zonePolicyApplyForm.getZoneDeviceForms()) {
                        ZoneServiceForm zoneServiceFormOutbound = ImportParserUtil.initZoneServiceForm(true);
                        ImportParserUtil.initZoneServicedData(form.getDeviceIp(), zoneServiceFormOutbound);
                        allZoneServices.add(zoneServiceFormOutbound);
                    }
                }
                zonePolicyApplyForm.setZoneServices(allZoneServices);
                zoneFormList.add(zonePolicyApplyForm);
            }
        }
        return zoneFormList;
    }

    private static void parserOutboundZoneService(ZonePolicyApplyForm zonePolicyApplyForm, Element elementOutbound, List<ZoneServiceForm> outboundZoneServices) {
        ImportParserUtil.parserFaultSeverityRule(zonePolicyApplyForm, elementOutbound, false);
        Element elementOutboundDefenseModeInfo = elementOutbound.element("defense-mode-info");
        String outboundFilterDropThreshold = elementOutboundDefenseModeInfo.elementText("filter_drop_thershold");
        String flowspecAction = elementOutboundDefenseModeInfo.elementText("flowspec_action");
        String flowspecLimitThreshold = elementOutboundDefenseModeInfo.elementText("flowspec_limit_threshold");
        String flowspecRedirect = elementOutboundDefenseModeInfo.elementText("flowspec_redirect");
        if (!ImportParserUtil.isEmptyString(outboundFilterDropThreshold)) {
            zonePolicyApplyForm.setOutBoundFilterDropThreshold(Long.valueOf(outboundFilterDropThreshold));
        }
        if (!ImportParserUtil.isEmptyString(flowspecAction)) {
            zonePolicyApplyForm.setOutBoundFilterAction(Integer.valueOf(flowspecAction));
            if (2 == zonePolicyApplyForm.getOutBoundFilterAction() && !ImportParserUtil.isEmptyString(flowspecLimitThreshold)) {
                zonePolicyApplyForm.setOutBoundFilterLimit(Long.valueOf(flowspecLimitThreshold));
            }
            if (3 == zonePolicyApplyForm.getOutBoundFilterAction() && !ImportParserUtil.isEmptyString(flowspecRedirect)) {
                zonePolicyApplyForm.setOutBoundNextHop(flowspecRedirect);
            }
        }
        ImportParserUtil.parserOutboundZoneFilterList(zonePolicyApplyForm, elementOutbound);
        List outboundDefensePolicyList = elementOutbound.element("defense-policy-list").elements("defense-policy");
        if (null != outboundDefensePolicyList && !outboundDefensePolicyList.isEmpty()) {
            ImportParserUtil.parserOutboundZoneDefenseList(outboundZoneServices, outboundDefensePolicyList);
        }
    }

    private static void parserOutboundZoneDefenseList(List<ZoneServiceForm> outboundZoneServices, List<Element> outboundDefensePolicyList) {
        for (Element outboundService : outboundDefensePolicyList) {
            ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
            zoneServiceForm.setDirection(Integer.valueOf(2));
            Element elementBasicInfo = outboundService.element("basic-info");
            String name = elementBasicInfo.elementText("name");
            String deviceIp = elementBasicInfo.elementText("device-ip");
            String protocol = elementBasicInfo.elementText("protocol");
            zoneServiceForm.setServiceName(name);
            zoneServiceForm.setDeviceIp(deviceIp);
            zoneServiceForm.setProtocol(protocol);
            List elementPolicyList = outboundService.element("policy-list").elements("policy");
            if (null == elementPolicyList || elementPolicyList.isEmpty()) continue;
            ImportParserUtil.parserOutboundZonePolicyList(outboundZoneServices, zoneServiceForm, elementPolicyList);
        }
    }

    private static void parserOutboundZonePolicyList(List<ZoneServiceForm> outboundZoneServices, ZoneServiceForm zoneServiceForm, List<Element> elementPolicyList) {
        for (Element elementPolicy : elementPolicyList) {
            String policyProtocol = elementPolicy.elementText("protocol");
            if (POLICY_PROTOCOL_TCP.equals(policyProtocol)) {
                ImportParserUtil.parserOutboundZonePolicyProtocolTcp(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_UDP.equals(policyProtocol)) {
                ImportParserUtil.parserOutboundZonePolicyProtocolUdp(zoneServiceForm, elementPolicy);
                continue;
            }
            if (!POLICY_PROTOCOL_ICMP.equals(policyProtocol)) continue;
            ImportParserUtil.parserOutboundZonePolicyProtocolIcmp(zoneServiceForm, elementPolicy);
        }
        outboundZoneServices.add(zoneServiceForm);
    }

    private static void parserOutboundZonePolicyProtocolIcmp(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
        icmpDefendPolicyForm.setDirection(2);
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
        if (TRUE.equals(trafficLimitingEnable)) {
            icmpDefendPolicyForm.setIcmpLimitSubEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                icmpDefendPolicyForm.setIcmpMaxSpeed(Integer.valueOf(trafficLimitingThreshold));
            }
        } else {
            icmpDefendPolicyForm.setIcmpLimitSubEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
    }

    private static void parserOutboundZonePolicyProtocolUdp(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
        udpDefendPolicyForm.setDirection(2);
        String udpTtrafficLimitingEnable = elementPolicy.elementText("udp-traffic-limiting-enable");
        String udpTrafficLimitingThreshold = elementPolicy.elementText("udp-traffic-limiting-threshold");
        String udpFragmentRateLimitingEnable = elementPolicy.elementText("udp-fragment-rate-limiting-enable");
        String udpFragmentRateLimitingThreshold = elementPolicy.elementText("udp-fragment-rate-limiting-threshold");
        if (TRUE.equals(udpTtrafficLimitingEnable)) {
            udpDefendPolicyForm.setUdpMaxSpeedEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(udpTrafficLimitingThreshold)) {
                udpDefendPolicyForm.setUdpMaxSpeed(Integer.valueOf(udpTrafficLimitingThreshold));
            }
        } else {
            udpDefendPolicyForm.setUdpMaxSpeedEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(udpFragmentRateLimitingEnable)) {
            udpDefendPolicyForm.setUdpFragMaxSpeedEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(udpFragmentRateLimitingThreshold)) {
                udpDefendPolicyForm.setUdpFragMaxSpeed(Integer.valueOf(udpFragmentRateLimitingThreshold));
            }
        } else {
            udpDefendPolicyForm.setUdpFragMaxSpeedEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
    }

    private static void parserOutboundZonePolicyProtocolTcp(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        tcpDefendPolicyForm.setDirection(2);
        String synFloodAttackDefenseEnable = elementPolicy.elementText("syn-flood-attack-defense-enable");
        String synFloodAttackDefenseThreshold = elementPolicy.elementText("syn-flood-attack-defense-threshold");
        String synFloodAttackDefenseInterval = elementPolicy.elementText("syn-flood-attack-defense-interval");
        String tcpFragmentAttackDefenseEnable = elementPolicy.elementText("tcp-fragment-attack-defense-enable");
        String tcpFragmentAattackDefenseTthreshold = elementPolicy.elementText("tcp-fragment-attack-defense-threshold");
        if (TRUE.equals(synFloodAttackDefenseEnable)) {
            tcpDefendPolicyForm.setSynfloodEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(synFloodAttackDefenseThreshold)) {
                tcpDefendPolicyForm.setSynfloodAlertRate(Integer.valueOf(synFloodAttackDefenseThreshold));
            }
            if (!ImportParserUtil.isEmptyString(synFloodAttackDefenseInterval)) {
                String[] synInterVals = synFloodAttackDefenseInterval.split("-");
                tcpDefendPolicyForm.setFirstPacketCheckLowerLimit(Integer.valueOf(synInterVals[0]));
                tcpDefendPolicyForm.setFirstPacketCheckUpperLimit(Integer.valueOf(synInterVals[1]));
            }
        } else {
            tcpDefendPolicyForm.setSynfloodEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(tcpFragmentAttackDefenseEnable)) {
            tcpDefendPolicyForm.setTcpFragEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(tcpFragmentAattackDefenseTthreshold)) {
                tcpDefendPolicyForm.setTcpFragAlertRate(Integer.valueOf(tcpFragmentAattackDefenseTthreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpFragEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setTcpDefendPolicyForm(tcpDefendPolicyForm);
    }

    private static void parserOutboundZoneFilterList(ZonePolicyApplyForm zonePolicyApplyForm, Element elementOutbound) {
        List outboundfilterList = elementOutbound.element("filter-list").elements("filter-name");
        if (null != outboundfilterList && !outboundfilterList.isEmpty()) {
            ArrayList filterIdList = new ArrayList();
            ArrayList<String> filterNameList = new ArrayList<String>();
            for (Element elementFilter : outboundfilterList) {
                String filterName = elementFilter.getText();
                filterNameList.add(filterName);
            }
            zonePolicyApplyForm.setOutboundFilterIdList(filterIdList);
            zonePolicyApplyForm.setOutboundFilterNameList(filterNameList);
        }
    }

    private static void parserInboundZoneServiceForm(List<ZoneServiceForm> inboundZoneServices, List<Element> elementDefensePolicyList) {
        for (Element elementlocation : elementDefensePolicyList) {
            ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
            zoneServiceForm.setDirection(Integer.valueOf(1));
            Element elementBasicInfo = elementlocation.element("basic-info");
            String name = elementBasicInfo.elementText("name");
            String deviceIp = elementBasicInfo.elementText("device-ip");
            String protocol = elementBasicInfo.elementText("protocol");
            String protocolId = elementBasicInfo.elementText("protocol-id");
            String ipAddressList = elementBasicInfo.elementText("ip-address-list");
            String portType = elementBasicInfo.elementText("port-type").trim();
            String destinationPortList = elementBasicInfo.elementText("destination-port-list");
            String description = elementBasicInfo.elementText("description");
            zoneServiceForm.setServiceName(name);
            zoneServiceForm.setDeviceIp(deviceIp);
            if (POLICY_PROTOCOL_OTHER.equals(protocol) && !ImportParserUtil.isEmptyString(protocolId)) {
                zoneServiceForm.setProtocolNum(Integer.valueOf(protocolId));
            }
            zoneServiceForm.setProtocol(protocol);
            zoneServiceForm.setIpList(ipAddressList);
            if (!ImportParserUtil.isEmptyString(portType) && (portType.equals("0") || portType.equals(TRUE) || portType.equals("2"))) {
                zoneServiceForm.setPortType(Integer.valueOf(portType));
            }
            zoneServiceForm.setPortList(destinationPortList);
            zoneServiceForm.setDescription(description);
            List elementPolicyList = elementlocation.element("policy-list").elements("policy");
            if (null != elementPolicyList && !elementPolicyList.isEmpty()) {
                ImportParserUtil.parserInboundZonePolicyList(zoneServiceForm, protocol, elementPolicyList);
            }
            inboundZoneServices.add(zoneServiceForm);
        }
    }

    private static void parserInboundZonePolicyList(ZoneServiceForm zoneServiceForm, String protocol, List<Element> elementPolicyList) {
        for (Element elementPolicy : elementPolicyList) {
            if (POLICY_PROTOCOL_TCP.equals(protocol)) {
                zoneServiceForm.setTcpDefendPolicyForm(ImportParserUtil.portBizParse(elementPolicy));
                continue;
            }
            if (!POLICY_PROTOCOL_DEFAULT.equals(protocol)) continue;
            String policyProtocol = elementPolicy.elementText("protocol");
            if (POLICY_PROTOCOL_TCP.equals(policyProtocol)) {
                zoneServiceForm.setTcpDefendPolicyForm(ImportParserUtil.tcpParse(elementPolicy));
                continue;
            }
            if (POLICY_PROTOCOL_UDP.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolUdp(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_ICMP.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolIcmp(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_OTHER.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolOther(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_DNS.equals(policyProtocol)) {
                zoneServiceForm.setDnsDefendPolicyForm(ImportParserUtil.dnsParse(elementPolicy, policyProtocol));
                continue;
            }
            if (POLICY_PROTOCOL_SIP.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolSip(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_HTTP.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolHttp(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_HTTPS.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolHttps(zoneServiceForm, elementPolicy);
                continue;
            }
            if (POLICY_PROTOCOL_TOP_N_STUDY.equals(policyProtocol)) {
                ImportParserUtil.parserInboundZonePolicyProtocolTopnStudy(zoneServiceForm, elementPolicy);
                continue;
            }
            if ("None-Zone".equals(policyProtocol) || "First Packet Check".equals(policyProtocol)) continue;
            LOG.error((Object)("the protocol error : zoneserviceName is  " + ImportParserUtil.getcleanedMessage(zoneServiceForm.getServiceName()) + ",protocol is " + ImportParserUtil.getcleanedMessage(policyProtocol)));
            throw new LegoCheckedException(571988L);
        }
    }

    private static void parserInboundZonePolicyProtocolTopnStudy(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        String hostEnable = elementPolicy.elementText("http-host-enable");
        String hostSamplingRatio = elementPolicy.elementText("http-host-sampling-ratio");
        String uriEnable = elementPolicy.elementText("http-uri-enable");
        String defenseEnable = elementPolicy.elementText("http-uri-sampling-ratio");
        String uriSamplingRatio = elementPolicy.elementText("top-n-http-source-ip-addresses-enable");
        String samplingRatio = elementPolicy.elementText("top-n-http-source-ip-addresses-sampling-ratio");
        String domainNamesEnable = elementPolicy.elementText("top-n-requested-domain-names-enable");
        String dynamicCacheEnable = elementPolicy.elementText("top-n-requested-domain-names-dynamic-cache-enable");
        String dynamicCacheValue = elementPolicy.elementText("top-n-requested-domain-names-dynamic-cache-value");
        String requestedSamplingRatio = elementPolicy.elementText("top-n-requested-domain-names-sampling-ratio");
        String ipAddressesEnable = elementPolicy.elementText("top-n-dns-request-source-ip-addresses-enable");
        String ipAddressesSamplingRatio = elementPolicy.elementText("top-n-dns-request-source-ip-addresses-sampling-ratio");
        String responseIpAddressesEnable = elementPolicy.elementText("top-n-dns-response-source-ip-addresses-enable");
        String responseIpAddressesSamplingRatio = elementPolicy.elementText("top-n-dns-response-source-ip-addresses-sampling-ratio");
        String httpsIpAddressesEnable = elementPolicy.elementText("top-n-https-source-ip-addresses-enable");
        String httpsIpAddressesSamplingRatio = elementPolicy.elementText("top-n-https-source-ip-addresses-sampling-ratio");
        String tcpIpAddressesEnable = elementPolicy.elementText("top-n-tcp-source-ip-addresses-enable");
        String tcpIpAddressesSamplingRatio = elementPolicy.elementText("top-n-tcp-source-ip-addresses-sampling-ratio");
        TopNStudyForm topNStudyForm = new TopNStudyForm();
        if (TRUE.equals(hostEnable)) {
            topNStudyForm.setHttpHostEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(hostSamplingRatio)) {
                topNStudyForm.setHttpHostSimple(Integer.valueOf(Integer.parseInt(hostSamplingRatio)));
            }
        } else {
            topNStudyForm.setHttpHostEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(uriEnable)) {
            topNStudyForm.setHttpUriEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(defenseEnable)) {
                topNStudyForm.setHttpUriSimple(Integer.valueOf(Integer.parseInt(defenseEnable)));
            }
        } else {
            topNStudyForm.setHttpUriEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(uriSamplingRatio)) {
            topNStudyForm.setHttpSrcIpEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(samplingRatio)) {
                topNStudyForm.setHttpSrcIpSimple(Integer.valueOf(Integer.parseInt(samplingRatio)));
            }
        } else {
            topNStudyForm.setHttpSrcIpEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(domainNamesEnable)) {
            topNStudyForm.setDnsQueryDomainEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(requestedSamplingRatio)) {
                topNStudyForm.setDnsQueryDomainSimple(Integer.valueOf(Integer.parseInt(requestedSamplingRatio)));
            }
            if (TRUE.equals(dynamicCacheEnable)) {
                topNStudyForm.setTopnCacheEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(dynamicCacheValue)) {
                    topNStudyForm.setTopnCacheNum(Integer.valueOf(Integer.parseInt(dynamicCacheValue)));
                }
            } else {
                topNStudyForm.setTopnCacheEnable(Boolean.valueOf(false));
            }
        } else {
            topNStudyForm.setDnsQueryDomainEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(ipAddressesEnable)) {
            topNStudyForm.setDnsQuerySrcIpEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(ipAddressesSamplingRatio)) {
                topNStudyForm.setDnsQuerySrcIpSimple(Integer.valueOf(Integer.parseInt(ipAddressesSamplingRatio)));
            }
        } else {
            topNStudyForm.setDnsQuerySrcIpEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(responseIpAddressesEnable)) {
            topNStudyForm.setDnsReqSrcIpEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(responseIpAddressesSamplingRatio)) {
                topNStudyForm.setDnsReqSrcIpSimple(Integer.valueOf(Integer.parseInt(responseIpAddressesSamplingRatio)));
            }
        } else {
            topNStudyForm.setDnsReqSrcIpEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(httpsIpAddressesEnable)) {
            topNStudyForm.setHttpsEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(httpsIpAddressesSamplingRatio)) {
                topNStudyForm.setHttpsSimple(Integer.valueOf(Integer.parseInt(httpsIpAddressesSamplingRatio)));
            }
        } else {
            topNStudyForm.setHttpsEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(tcpIpAddressesEnable)) {
            topNStudyForm.setTcpNewConnEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(tcpIpAddressesSamplingRatio)) {
                topNStudyForm.setTcpNewConnSimple(Integer.valueOf(Integer.parseInt(tcpIpAddressesSamplingRatio)));
            }
        } else {
            topNStudyForm.setTcpNewConnEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setTopNStudyForm(topNStudyForm);
    }

    private static void parserInboundZonePolicyProtocolHttps(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String sourceDefenseEnable = elementPolicy.elementText("https-source-authentication-defense-enable");
        String packetThreshold = elementPolicy.elementText("statistics-based-on-destination-ip-address-packet-threshold");
        String srcIpAddEnable = elementPolicy.elementText("statistics-based-on-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("statistics-based-on-source-ip-address-threshold");
        String sslDefenseEnable = elementPolicy.elementText("ssl-defense-enable");
        String maximumRenegotiationTimes = elementPolicy.elementText("ssl-defense-maximum-renegotiation-times");
        String renegotiationInterval = elementPolicy.elementText("ssl-defense-renegotiation-interval");
        String abnormalSessions = elementPolicy.elementText("ssl-defense-maximum-number-of-abnormal-sessions");
        String checkInterva = elementPolicy.elementText("ssl-defense-abnormal-session-check-interva");
        String httpsNegoCheckEnable = elementPolicy.elementText("ssl-defense-renegotiation-times-check-enable");
        String httpsSessionCheckEnable = elementPolicy.elementText("ssl-defense-session-check-enable");
        String httpsDecryptEnable = elementPolicy.elementText("ssl-decrypt-defense-httpsdecryptenable");
        String httpsDecryptAlertRate = elementPolicy.elementText("ssl-decrypt-defense-httpsdecryptalertrate");
        String serverCodeEnable = elementPolicy.elementText("ssl-decrypt-defense-servercodeenable");
        String serverCodePeriod = elementPolicy.elementText("ssl-decrypt-defense-servercodeperiod");
        String serverCodeTimes = elementPolicy.elementText("ssl-decrypt-defense-servercodetimes");
        String httpsFingerLearnEnable = elementPolicy.elementText("ssl-decrypt-defense-httpsfingerlearnenable");
        String learnPeriod = elementPolicy.elementText("ssl-decrypt-defense-learnperiod");
        String matchTimes = elementPolicy.elementText("ssl-decrypt-defense-matchtimes");
        HttpsDefendPolicyForm httpsDefendPolicyForm = new HttpsDefendPolicyForm();
        httpsDefendPolicyForm.setHttpsBlock(Boolean.valueOf(false));
        if (TRUE.equals(trafficLimitingEnable)) {
            httpsDefendPolicyForm.setLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                httpsDefendPolicyForm.setLimitRate(Integer.valueOf(trafficLimitingThreshold));
            }
        } else {
            httpsDefendPolicyForm.setLimitEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(defenseEnable)) {
            httpsDefendPolicyForm.setHttpsDefendEnable(Boolean.valueOf(true));
            if (TRUE.equals(sourceDefenseEnable)) {
                httpsDefendPolicyForm.setHttpsSrcEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(packetThreshold)) {
                    httpsDefendPolicyForm.setHttpsAlertRate(Integer.valueOf(Integer.parseInt(packetThreshold)));
                }
                if (TRUE.equals(srcIpAddEnable)) {
                    httpsDefendPolicyForm.setHttpsSrcStaticEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                        httpsDefendPolicyForm.setHttpsSrcStaticRate(Integer.valueOf(Integer.parseInt(sourceIpAddressThreshold)));
                    }
                    httpsDefendPolicyForm.setHttpsSrcMode(Integer.valueOf(1));
                } else {
                    httpsDefendPolicyForm.setHttpsSrcStaticEnable(Boolean.valueOf(false));
                }
                String httpsSrcAdvanceEnable = elementPolicy.elementText("https-src-advance-enable");
                httpsDefendPolicyForm.setHttpsSrcAdvanceEnable(Boolean.valueOf(TRUE.equals(httpsSrcAdvanceEnable)));
                String httpsHighFreqDetectEnable = elementPolicy.elementText("https-high-freq-detect-enable");
                String httpsHighFreqDetectThreshold = elementPolicy.elementText("https-high-freq-detect-threshold");
                String httpsHighFreqDetectInterval = elementPolicy.elementText("https-high-freq-detect-interval");
                if (TRUE.equals(httpsHighFreqDetectEnable)) {
                    httpsDefendPolicyForm.setHttpsHighFreqDetectEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(httpsHighFreqDetectThreshold)) {
                        httpsDefendPolicyForm.setHttpsHighFreqDetectThreshold(Integer.valueOf(Integer.parseInt(httpsHighFreqDetectThreshold)));
                    }
                    if (!ImportParserUtil.isEmptyString(httpsHighFreqDetectInterval)) {
                        httpsDefendPolicyForm.setHttpsHighFreqDetectInterval(Integer.valueOf(Integer.parseInt(httpsHighFreqDetectInterval)));
                    }
                } else {
                    httpsDefendPolicyForm.setHttpsHighFreqDetectEnable(Boolean.valueOf(false));
                }
                String httpsFixResEnable = elementPolicy.elementText("https-fix-res-enable");
                String httpsFixResRatioNumber = elementPolicy.elementText("https-fix-res-ratio-number");
                String httpsFixResThreshold = elementPolicy.elementText("https-fix-res-threshold");
                String httpsFixResInterval = elementPolicy.elementText("https-fix-res-interval");
                if (TRUE.equals(httpsFixResEnable)) {
                    httpsDefendPolicyForm.setHttpsFixResEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(httpsFixResRatioNumber)) {
                        httpsDefendPolicyForm.setHttpsFixResRatioNumber(Integer.valueOf(Integer.parseInt(httpsFixResRatioNumber)));
                    }
                    if (!ImportParserUtil.isEmptyString(httpsFixResThreshold)) {
                        httpsDefendPolicyForm.setHttpsFixResThreshold(Integer.valueOf(Integer.parseInt(httpsFixResThreshold)));
                    }
                    if (!ImportParserUtil.isEmptyString(httpsFixResInterval)) {
                        httpsDefendPolicyForm.setHttpsFixResInterval(Integer.valueOf(Integer.parseInt(httpsFixResInterval)));
                    }
                } else {
                    httpsDefendPolicyForm.setHttpsFixResEnable(Boolean.valueOf(false));
                }
                String httpsLargeResDetectEnable = elementPolicy.elementText("https-large-res-detect-enable");
                String httpsLargeResSize = elementPolicy.elementText("https-large-res-size");
                String httpsLargeResDetectRatio = elementPolicy.elementText("https-large-res-detect-ratio");
                String httpsLargeResDetectThreshold = elementPolicy.elementText("https-large-res-detect-threshold");
                String httpsLargeResDetectInterval = elementPolicy.elementText("https-large-res-detect-interval");
                if (TRUE.equals(httpsLargeResDetectEnable)) {
                    httpsDefendPolicyForm.setHttpsLargeResDetectEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(httpsLargeResSize)) {
                        httpsDefendPolicyForm.setHttpsLargeResSize(Integer.valueOf(Integer.parseInt(httpsLargeResSize)));
                    }
                    if (!ImportParserUtil.isEmptyString(httpsLargeResDetectRatio)) {
                        httpsDefendPolicyForm.setHttpsLargeResDetectRatio(Integer.valueOf(Integer.parseInt(httpsLargeResDetectRatio)));
                    }
                    if (!ImportParserUtil.isEmptyString(httpsLargeResDetectThreshold)) {
                        httpsDefendPolicyForm.setHttpsLargeResDetectThreshold(Integer.valueOf(Integer.parseInt(httpsLargeResDetectThreshold)));
                    }
                    if (!ImportParserUtil.isEmptyString(httpsLargeResDetectInterval)) {
                        httpsDefendPolicyForm.setHttpsLargeResDetectInterval(Integer.valueOf(Integer.parseInt(httpsLargeResDetectInterval)));
                    }
                } else {
                    httpsDefendPolicyForm.setHttpsLargeResDetectEnable(Boolean.valueOf(false));
                }
            } else {
                httpsDefendPolicyForm.setHttpsSrcEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(sslDefenseEnable)) {
                httpsDefendPolicyForm.setHttpsSslEnable(Boolean.valueOf(true));
                if (TRUE.equals(httpsNegoCheckEnable)) {
                    httpsDefendPolicyForm.setHttpsNegoCheckEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(maximumRenegotiationTimes)) {
                        httpsDefendPolicyForm.setHttpsNegonum(Integer.valueOf(Integer.parseInt(maximumRenegotiationTimes)));
                    }
                    if (!ImportParserUtil.isEmptyString(renegotiationInterval)) {
                        httpsDefendPolicyForm.setHttpsNegointerval(Integer.valueOf(Integer.parseInt(renegotiationInterval)));
                    }
                    if (!ImportParserUtil.isEmptyString(abnormalSessions)) {
                        httpsDefendPolicyForm.setHttpsIllegalnum(Integer.valueOf(Integer.parseInt(abnormalSessions)));
                    }
                    if (!ImportParserUtil.isEmptyString(checkInterva)) {
                        httpsDefendPolicyForm.setHttpsIllegalinterval(Integer.valueOf(Integer.parseInt(checkInterva)));
                    }
                    if (!ImportParserUtil.isEmptyString(maximumRenegotiationTimes)) {
                        httpsDefendPolicyForm.setHttpsNegonum(Integer.valueOf(Integer.parseInt(maximumRenegotiationTimes)));
                    }
                    if (!ImportParserUtil.isEmptyString(renegotiationInterval)) {
                        httpsDefendPolicyForm.setHttpsNegointerval(Integer.valueOf(Integer.parseInt(renegotiationInterval)));
                    }
                } else {
                    httpsDefendPolicyForm.setHttpsNegoCheckEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(httpsSessionCheckEnable)) {
                    httpsDefendPolicyForm.setHttpsSessionCheckEnable(Boolean.valueOf(true));
                } else {
                    httpsDefendPolicyForm.setHttpsSessionCheckEnable(Boolean.valueOf(false));
                }
                String httpsDestIpConnNumEnable = elementPolicy.elementText("https-dest-ip-conn-num-enable");
                String httpsDestIpConnNum = elementPolicy.elementText("https-dest-ip-conn-num");
                if (TRUE.equals(httpsDestIpConnNumEnable)) {
                    httpsDefendPolicyForm.setHttpsDestIpConnNumEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(httpsDestIpConnNum)) {
                        httpsDefendPolicyForm.setHttpsDestIpConnNum(Integer.valueOf(Integer.parseInt(httpsDestIpConnNum)));
                    }
                } else {
                    httpsDefendPolicyForm.setHttpsDestIpConnNumEnable(Boolean.valueOf(false));
                }
            } else {
                httpsDefendPolicyForm.setHttpsSslEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(httpsDecryptEnable)) {
                httpsDefendPolicyForm.setHttpsDecryptEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(httpsDecryptAlertRate) && CheckImportXml.isRange80000000((String)httpsDecryptAlertRate)) {
                    httpsDefendPolicyForm.setHttpsDecryptAlertRate(Integer.valueOf(httpsDecryptAlertRate));
                }
                if (TRUE.equals(serverCodeEnable)) {
                    httpsDefendPolicyForm.setServerCodeEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(serverCodePeriod) && CheckImportXml.isRange120((String)serverCodePeriod)) {
                        httpsDefendPolicyForm.setServerCodePeriod(Integer.valueOf(serverCodePeriod));
                    }
                    if (!ImportParserUtil.isEmptyString(serverCodeTimes) && CheckImportXml.isRange80000000((String)serverCodeTimes)) {
                        httpsDefendPolicyForm.setServerCodeTimes(Integer.valueOf(serverCodeTimes));
                    }
                } else {
                    httpsDefendPolicyForm.setServerCodeEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(httpsFingerLearnEnable)) {
                    httpsDefendPolicyForm.setHttpsFingerLearnEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(learnPeriod) && CheckImportXml.isRange60((String)learnPeriod)) {
                        httpsDefendPolicyForm.setLearnPeriod(Integer.valueOf(learnPeriod));
                    }
                    if (!ImportParserUtil.isEmptyString(matchTimes) && CheckImportXml.isRange80000000((String)matchTimes)) {
                        httpsDefendPolicyForm.setMatchTimes(Integer.valueOf(matchTimes));
                    }
                } else {
                    httpsDefendPolicyForm.setHttpsFingerLearnEnable(Boolean.valueOf(false));
                }
            } else {
                httpsDefendPolicyForm.setHttpsDecryptEnable(Boolean.valueOf(false));
            }
        } else {
            httpsDefendPolicyForm.setHttpsDefendEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setHttpsDefendPolicyForm(httpsDefendPolicyForm);
    }

    private static void parserInboundZonePolicyProtocolHttp(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String packetThreshold = elementPolicy.elementText("statistics-based-on-destination-ip-address-packet-threshold");
        String requestThreshold = elementPolicy.elementText("statistics-based-on-destination-ip-address-request-threshold");
        String sourceIpAddressEnable = elementPolicy.elementText("statistics-based-on-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("statistics-based-on-source-ip-address-threshold");
        String sourceIpAddressRequestThreshold = elementPolicy.elementText("statistics-based-on-source-ip-address-request-threshold");
        String sourceDefenseEnable = elementPolicy.elementText("http-source-authentication-defense-enable");
        String sourceDefenseMode = elementPolicy.elementText("http-source-authentication-defense-mode");
        String srcDefenseEnable = elementPolicy.elementText("http-source-authentication-defense-verification-code-caption-enable");
        String sourceDefenseSettings = elementPolicy.elementText("http-source-authentication-defense-verification-code-caption-settings");
        String sourceDefenseDetectionEnable = elementPolicy.elementText("http-source-authentication-defense-proxy-detection-enable");
        String sourceDefenseHeaderEnable = elementPolicy.elementText("http-source-authentication-defense-proxy-header-enable");
        String sourceDefenseHeader = elementPolicy.elementText("http-source-authentication-defense-proxy-header");
        String sourceDefenseTerminationEnable = elementPolicy.elementText("http-source-authentication-defense-termination-enable");
        String sourceDefenseTerminationMaxNumAttempt = elementPolicy.elementText("http-source-authentication-defense-termination-maxnum-attempt");
        String sourceDefenseTerminationAttemptTime = elementPolicy.elementText("http-source-authentication-defense-termination-attempt-time");
        String sourceDefenseSynEnable = elementPolicy.elementText("http-source-authentication-defense-syn-rate-limiting-enable");
        String sourceDefenseSynThreshold = elementPolicy.elementText("http-source-authentication-defense-syn-rate-limiting-threshold");
        String sourceDefenseAckEnable = elementPolicy.elementText("http-source-authentication-defense-ack-rate-limiting-enable");
        String sourceDefenseAckThreshold = elementPolicy.elementText("http-source-authentication-defense-ack-rate-limiting-threshold");
        String firstPacketCheckEnable = elementPolicy.elementText("http-first-packet-check-enable");
        String fiestPacketCheckInterval = elementPolicy.elementText("http-first-packet-check-interval");
        String learningEnable = elementPolicy.elementText("http-fingerprint-learning-enable");
        String learningCycle = elementPolicy.elementText("http-fingerprint-learning-cycle");
        String learningMatchingCounts = elementPolicy.elementText("http-fingerprint-learning-matching-counts");
        String slowAttackDefenseEnable = elementPolicy.elementText("http-slow-attack-defense-enable");
        String concurrentConnectionNumber = elementPolicy.elementText("http-slow-attack-defense-concurrent-connection-number");
        String totalPacketLength = elementPolicy.elementText("http-slow-attack-defense-total-packet-length");
        String checkPacketNumber = elementPolicy.elementText("http-slow-attack-defense-check-packet-number");
        String payloadLength = elementPolicy.elementText("http-slow-attack-defense-payload-length");
        String monitoringDetectionThreshold = elementPolicy.elementText("destination-ip-based-uri-behavior-monitoring-detection-threshold");
        String monitoringEnable = elementPolicy.elementText("source-ip-based-uri-behavior-monitoring-enable");
        String monitoringDefenseThreshold = elementPolicy.elementText("source-ip-based-uri-behavior-monitoring-defense-threshold");
        List elementUriList = elementPolicy.element("closely-monitored-uri-list").elements("closely-monitored-uri");
        ArrayList<HttpKeyDetectUriForm> httpKeyDetectUriFormList = new ArrayList<HttpKeyDetectUriForm>();
        for (Element uriElement : elementUriList) {
            String monitoredUri = uriElement.elementText("monitored-uri");
            String uriMatchMode = uriElement.elementText("uri-match-mode");
            if (ImportParserUtil.isEmptyString(monitoredUri)) continue;
            HttpKeyDetectUriForm detectUriForm = new HttpKeyDetectUriForm();
            detectUriForm.setHttpUri(monitoredUri);
            if (ImportParserUtil.isEmptyString(uriMatchMode)) {
                detectUriForm.setMatchMode(Integer.valueOf(1));
            } else {
                detectUriForm.setMatchMode(Integer.valueOf(Integer.parseInt(uriMatchMode)));
            }
            httpKeyDetectUriFormList.add(detectUriForm);
        }
        HttpDefendPolicyForm httpDefendPolicyForm = new HttpDefendPolicyForm();
        httpDefendPolicyForm.setHttpBlock(Boolean.valueOf(false));
        if (TRUE.equals(trafficLimitingEnable)) {
            httpDefendPolicyForm.setLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                httpDefendPolicyForm.setLimitRate(Integer.valueOf(trafficLimitingThreshold));
            }
        } else {
            httpDefendPolicyForm.setLimitEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(defenseEnable)) {
            httpDefendPolicyForm.setHttpDefendEnable(Boolean.valueOf(true));
            if (TRUE.equals(sourceDefenseEnable)) {
                httpDefendPolicyForm.setHttpSourceAuthEnable(Boolean.valueOf(true));
                if (TRUE.equals(sourceIpAddressEnable)) {
                    httpDefendPolicyForm.setHttpSrcStaticEnable(Boolean.valueOf(true));
                    httpDefendPolicyForm.setHttpSrcMode(Integer.valueOf(1));
                    if (!ImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                        httpDefendPolicyForm.setHttpSrcStaticRate(Integer.valueOf(Integer.parseInt(sourceIpAddressThreshold)));
                    }
                    if (!ImportParserUtil.isEmptyString(sourceIpAddressRequestThreshold)) {
                        httpDefendPolicyForm.setHttpSrcQpsRate(Integer.valueOf(Integer.parseInt(sourceIpAddressRequestThreshold)));
                    }
                } else {
                    httpDefendPolicyForm.setHttpSrcStaticEnable(Boolean.valueOf(false));
                }
                if (!ImportParserUtil.isEmptyString(sourceDefenseMode)) {
                    httpDefendPolicyForm.setDefendMode(Integer.valueOf(Integer.parseInt(sourceDefenseMode)));
                    if (Integer.parseInt(sourceDefenseMode) == 1 && TRUE.equals(srcDefenseEnable)) {
                        httpDefendPolicyForm.setHttpWebDetectEnable(Boolean.valueOf(true));
                        if (!ImportParserUtil.isEmptyString(sourceDefenseSettings)) {
                            httpDefendPolicyForm.setWebTitle(sourceDefenseSettings);
                        }
                    } else {
                        httpDefendPolicyForm.setHttpWebDetectEnable(Boolean.valueOf(false));
                    }
                } else {
                    httpDefendPolicyForm.setHttpWebDetectEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(sourceDefenseDetectionEnable)) {
                    httpDefendPolicyForm.setHttpProxyEnable(Boolean.valueOf(true));
                    if (TRUE.equals(sourceDefenseHeaderEnable)) {
                        httpDefendPolicyForm.setHttpProxyHeaderEnable(Boolean.valueOf(true));
                        httpDefendPolicyForm.setHttpProxyHeader(sourceDefenseHeader);
                    } else {
                        httpDefendPolicyForm.setHttpProxyHeaderEnable(Boolean.valueOf(false));
                        httpDefendPolicyForm.setHttpProxyHeader(sourceDefenseHeader);
                    }
                } else {
                    httpDefendPolicyForm.setHttpProxyEnable(Boolean.valueOf(false));
                    httpDefendPolicyForm.setHttpProxyHeaderEnable(Boolean.valueOf(false));
                    httpDefendPolicyForm.setHttpProxyHeader(sourceDefenseHeader);
                }
                if (TRUE.equals(sourceDefenseTerminationEnable)) {
                    httpDefendPolicyForm.setDetectUriEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(sourceDefenseTerminationMaxNumAttempt)) {
                        httpDefendPolicyForm.setMaxTimes(Integer.valueOf(Integer.parseInt(sourceDefenseTerminationMaxNumAttempt)));
                    }
                    if (!ImportParserUtil.isEmptyString(sourceDefenseTerminationAttemptTime)) {
                        httpDefendPolicyForm.setTimeout(Integer.valueOf(Integer.parseInt(sourceDefenseTerminationAttemptTime)));
                    }
                } else {
                    httpDefendPolicyForm.setDetectUriEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(sourceDefenseSynEnable)) {
                    httpDefendPolicyForm.setHttpAfterAuthSynEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(sourceDefenseSynThreshold)) {
                        httpDefendPolicyForm.setAfterAuthSynRate(Integer.valueOf(Integer.parseInt(sourceDefenseSynThreshold)));
                        httpDefendPolicyForm.setAfterAuthSynAction(Integer.valueOf(0));
                    }
                } else {
                    httpDefendPolicyForm.setHttpAfterAuthSynEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(sourceDefenseAckEnable)) {
                    httpDefendPolicyForm.setHttpAfterAuthAckEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(sourceDefenseAckThreshold)) {
                        httpDefendPolicyForm.setAfterAuthAckRate(Integer.valueOf(Integer.parseInt(sourceDefenseAckThreshold)));
                        httpDefendPolicyForm.setAfterAuthAckAction(Integer.valueOf(0));
                    }
                } else {
                    httpDefendPolicyForm.setHttpAfterAuthAckEnable(Boolean.valueOf(false));
                }
            } else {
                httpDefendPolicyForm.setHttpSourceAuthEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(firstPacketCheckEnable)) {
                httpDefendPolicyForm.setHttpFirstPacketEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(fiestPacketCheckInterval)) {
                    String[] httpInterVals = fiestPacketCheckInterval.split("-");
                    httpDefendPolicyForm.setHttpLowerLimit(Integer.valueOf(Integer.parseInt(httpInterVals[0])));
                    httpDefendPolicyForm.setHttpUpperLimit(Integer.valueOf(Integer.parseInt(httpInterVals[1])));
                }
            }
            if (TRUE.equals(learningEnable)) {
                httpDefendPolicyForm.setFingerLearnEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(learningCycle)) {
                    httpDefendPolicyForm.setLearnPeriod(Integer.valueOf(Integer.parseInt(learningCycle)));
                }
                if (!ImportParserUtil.isEmptyString(learningMatchingCounts)) {
                    httpDefendPolicyForm.setMatchTimes(Integer.valueOf(Integer.parseInt(learningMatchingCounts)));
                }
            } else {
                httpDefendPolicyForm.setFingerLearnEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(learningEnable) || TRUE.equals(sourceDefenseEnable)) {
                if (!ImportParserUtil.isEmptyString(packetThreshold)) {
                    httpDefendPolicyForm.setHttpAlertRate(Integer.valueOf(Integer.parseInt(packetThreshold)));
                }
                if (!ImportParserUtil.isEmptyString(requestThreshold)) {
                    httpDefendPolicyForm.setHttpDestQpsAlertRate(Integer.valueOf(Integer.parseInt(requestThreshold)));
                }
            }
            if (TRUE.equals(slowAttackDefenseEnable)) {
                httpDefendPolicyForm.setHttpSlowAttackEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(concurrentConnectionNumber)) {
                    httpDefendPolicyForm.setHttpSlowConnNum(Integer.valueOf(Integer.parseInt(concurrentConnectionNumber)));
                }
                if (!ImportParserUtil.isEmptyString(totalPacketLength)) {
                    httpDefendPolicyForm.setHttpSlowContentLength(Integer.valueOf(Integer.parseInt(totalPacketLength)));
                }
                if (!ImportParserUtil.isEmptyString(checkPacketNumber)) {
                    httpDefendPolicyForm.setHttpSlowCheckPacketNum(Integer.valueOf(Integer.parseInt(checkPacketNumber)));
                }
                if (!ImportParserUtil.isEmptyString(payloadLength)) {
                    httpDefendPolicyForm.setHttpSlowPayloadLength(Integer.valueOf(Integer.parseInt(payloadLength)));
                }
            } else {
                httpDefendPolicyForm.setHttpSlowAttackEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(monitoringEnable)) {
                httpDefendPolicyForm.setHttpUriEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(monitoringDetectionThreshold)) {
                    httpDefendPolicyForm.setHttpDetectNumber(Integer.valueOf(Integer.parseInt(monitoringDetectionThreshold)));
                    httpDefendPolicyForm.setHttpDetectInterval(Integer.valueOf(30));
                    httpDefendPolicyForm.setDetectMinNum(Integer.valueOf(10));
                }
                if (!ImportParserUtil.isEmptyString(monitoringDefenseThreshold)) {
                    httpDefendPolicyForm.setIllegalRatioNumber(Integer.valueOf(Integer.parseInt(monitoringDefenseThreshold)));
                    httpDefendPolicyForm.setIllegalRatioInterval(Integer.valueOf(30));
                    httpDefendPolicyForm.setIllegalMinNum(Integer.valueOf(10));
                }
                if (!httpKeyDetectUriFormList.isEmpty()) {
                    httpDefendPolicyForm.setKeyDetectUriForms(httpKeyDetectUriFormList);
                }
            } else {
                httpDefendPolicyForm.setHttpUriEnable(Boolean.valueOf(false));
            }
            String highFreqDetectEnable = elementPolicy.elementText("http-high-freq-detect-enable");
            String highFreqDetectThreshold = elementPolicy.elementText("http-high-freq-detect-threshold");
            String highFreqDetectInterval = elementPolicy.elementText("http-high-freq-detect-interval");
            if (TRUE.equals(highFreqDetectEnable)) {
                httpDefendPolicyForm.setHighFreqDetectEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(highFreqDetectThreshold)) {
                    httpDefendPolicyForm.setHighFreqDetectThreshold(Integer.valueOf(Integer.parseInt(highFreqDetectThreshold)));
                }
                if (!ImportParserUtil.isEmptyString(highFreqDetectInterval)) {
                    httpDefendPolicyForm.setHighFreqDetectInterval(Integer.valueOf(Integer.parseInt(highFreqDetectInterval)));
                }
            } else {
                httpDefendPolicyForm.setHighFreqDetectEnable(Boolean.valueOf(false));
            }
            String httpFixUriEnable = elementPolicy.elementText("http-fix-uri-enable");
            String httpFixUriRatioNumber = elementPolicy.elementText("http-fix-uri-ratio-number");
            String httpFixUriThreshold = elementPolicy.elementText("http-fix-uri-threshold");
            String httpFixUriInterval = elementPolicy.elementText("http-fix-uri-interval");
            if (TRUE.equals(httpFixUriEnable)) {
                httpDefendPolicyForm.setHttpFixUriEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(httpFixUriRatioNumber)) {
                    httpDefendPolicyForm.setHttpFixUriRatioNumber(Integer.valueOf(Integer.parseInt(httpFixUriRatioNumber)));
                }
                if (!ImportParserUtil.isEmptyString(httpFixUriThreshold)) {
                    httpDefendPolicyForm.setHttpFixUriThreshold(Integer.valueOf(Integer.parseInt(httpFixUriThreshold)));
                }
                if (!ImportParserUtil.isEmptyString(httpFixUriInterval)) {
                    httpDefendPolicyForm.setHttpFixUriInterval(Integer.valueOf(Integer.parseInt(httpFixUriInterval)));
                }
                if (!httpKeyDetectUriFormList.isEmpty()) {
                    httpDefendPolicyForm.setKeyDetectUriForms(httpKeyDetectUriFormList);
                }
            } else {
                httpDefendPolicyForm.setHttpFixUriEnable(Boolean.valueOf(false));
            }
            String largeResDetectEnable = elementPolicy.elementText("http-large-res-detect-enable");
            String largeResSize = elementPolicy.elementText("http-large-res-size");
            String largeResDetectRatio = elementPolicy.elementText("http-large-res-detect-ratio");
            String largeResDetectThreshold = elementPolicy.elementText("http-large-res-detect-threshold");
            String largeResDetectInterval = elementPolicy.elementText("http-large-res-detect-interval");
            if (TRUE.equals(largeResDetectEnable)) {
                httpDefendPolicyForm.setLargeResDetectEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(largeResSize)) {
                    httpDefendPolicyForm.setLargeResSize(Integer.valueOf(Integer.parseInt(largeResSize)));
                }
                if (!ImportParserUtil.isEmptyString(largeResDetectRatio)) {
                    httpDefendPolicyForm.setLargeResDetectRatio(Integer.valueOf(Integer.parseInt(largeResDetectRatio)));
                }
                if (!ImportParserUtil.isEmptyString(largeResDetectThreshold)) {
                    httpDefendPolicyForm.setLargeResDetectThreshold(Integer.valueOf(Integer.parseInt(largeResDetectThreshold)));
                }
                if (!ImportParserUtil.isEmptyString(largeResDetectInterval)) {
                    httpDefendPolicyForm.setLargeResDetectInterval(Integer.valueOf(Integer.parseInt(largeResDetectInterval)));
                }
            } else {
                httpDefendPolicyForm.setLargeResDetectEnable(Boolean.valueOf(false));
            }
            String httpIllegalSessionCheckEnable = elementPolicy.elementText("http-illegal-session-check-enable");
            String nullMethodCheck = elementPolicy.elementText("http-null-method-check");
            String rangeHeaderCheck = elementPolicy.elementText("http-range-header-check");
            String multiGetCheck = elementPolicy.elementText("http-multi-get-check");
            if (TRUE.equals(httpIllegalSessionCheckEnable)) {
                String httpIllegalSessionInterval;
                String httpIllegalSessionNum;
                httpDefendPolicyForm.setHttpIllegalSessionCheckEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(nullMethodCheck)) {
                    httpDefendPolicyForm.setNullMethodCheck(Boolean.valueOf(TRUE.equals(nullMethodCheck)));
                }
                if (!ImportParserUtil.isEmptyString(rangeHeaderCheck)) {
                    httpDefendPolicyForm.setRangeHeaderCheck(Boolean.valueOf(TRUE.equals(rangeHeaderCheck)));
                }
                if (!ImportParserUtil.isEmptyString(multiGetCheck)) {
                    httpDefendPolicyForm.setMultiGetCheck(Boolean.valueOf(TRUE.equals(multiGetCheck)));
                }
                if (!ImportParserUtil.isEmptyString(httpIllegalSessionNum = elementPolicy.elementText("http-illegal-session-num"))) {
                    httpDefendPolicyForm.setHttpIllegalSessionNum(Integer.valueOf(Integer.parseInt(httpIllegalSessionNum)));
                }
                if (!ImportParserUtil.isEmptyString(httpIllegalSessionInterval = elementPolicy.elementText("http-illegal-session-interval"))) {
                    httpDefendPolicyForm.setHttpIllegalSessionInterval(Integer.valueOf(Integer.parseInt(httpIllegalSessionInterval)));
                }
            } else {
                httpDefendPolicyForm.setHttpIllegalSessionCheckEnable(Boolean.valueOf(false));
            }
            String destIpConnNumEnable = elementPolicy.elementText("dest-ip-conn-num-enable");
            String destIpConnNum = elementPolicy.elementText("dest-ip-conn-num");
            if (TRUE.equals(destIpConnNumEnable)) {
                httpDefendPolicyForm.setDestIpConnNumEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(destIpConnNum)) {
                    httpDefendPolicyForm.setDestIpConnNum(Integer.valueOf(Integer.parseInt(destIpConnNum)));
                }
            } else {
                httpDefendPolicyForm.setDestIpConnNumEnable(Boolean.valueOf(false));
            }
        } else {
            httpDefendPolicyForm.setHttpDefendEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setHttpDefendPolicyForm(httpDefendPolicyForm);
    }

    private static void parserInboundZonePolicyProtocolSip(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String sourceDetectionEnable = elementPolicy.elementText("source-detection-enable");
        String sourceDetectionThreshold = elementPolicy.elementText("source-detection-threshold");
        String sourceIpAddressEnable = elementPolicy.elementText("rate-limiting-of-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("rate-limiting-of-source-ip-address-threshold");
        SipDefendPolicyForm sipDefendPolicyForm = new SipDefendPolicyForm();
        sipDefendPolicyForm.setSipBlock(Boolean.valueOf(false));
        if (TRUE.equals(trafficLimitingEnable)) {
            sipDefendPolicyForm.setLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                sipDefendPolicyForm.setLimitRate(Integer.valueOf(trafficLimitingThreshold));
            }
        } else {
            sipDefendPolicyForm.setLimitEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(defenseEnable)) {
            sipDefendPolicyForm.setSipDefendEnable(Boolean.valueOf(true));
            if (TRUE.equals(sourceDetectionEnable)) {
                sipDefendPolicyForm.setSipSrcDetectEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(sourceDetectionThreshold)) {
                    sipDefendPolicyForm.setSipAlertRate(Integer.valueOf(Integer.parseInt(sourceDetectionThreshold)));
                }
            } else {
                sipDefendPolicyForm.setSipSrcDetectEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(sourceIpAddressEnable)) {
                sipDefendPolicyForm.setSipSrcOtherLimitEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                    sipDefendPolicyForm.setSipSrcOtherAlertRate(Integer.valueOf(Integer.parseInt(sourceIpAddressThreshold)));
                    sipDefendPolicyForm.setSipSrcOtherLimitMode(Integer.valueOf(1));
                }
            } else {
                sipDefendPolicyForm.setSipSrcOtherLimitEnable(Boolean.valueOf(false));
            }
        } else {
            sipDefendPolicyForm.setSipDefendEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setSipDefendPolicyForm(sipDefendPolicyForm);
    }

    private static void parserInboundZonePolicyProtocolOther(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        String blockEnable = elementPolicy.elementText("block-enable");
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String trafficLimitingSubEnable = elementPolicy.elementText("traffic-limiting-sub-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
        String otherNewDestSessionLimitingEnable = elementPolicy.elementText("other-new-dest-session-limiting-enable");
        String otherNewDestSessionLimitingThreshold = elementPolicy.elementText("other-new-dest-session-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String defenseThreshold = elementPolicy.elementText("defense-threshold");
        OtherDefendPolicyForm otherDefendPolicyForm = new OtherDefendPolicyForm();
        otherDefendPolicyForm.setDirection(1);
        if (TRUE.equals(blockEnable)) {
            otherDefendPolicyForm.setOtherBlock(Boolean.valueOf(true));
            otherDefendPolicyForm.setOtherDefendEnable(Boolean.valueOf(false));
            otherDefendPolicyForm.setOtherDefenseEnable(Boolean.valueOf(false));
        } else {
            otherDefendPolicyForm.setOtherBlock(Boolean.valueOf(false));
            if (TRUE.equals(trafficLimitingEnable)) {
                otherDefendPolicyForm.setOtherDefendEnable(Boolean.valueOf(true));
                if (TRUE.equals(trafficLimitingSubEnable)) {
                    otherDefendPolicyForm.setOtherLimitSubEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                        otherDefendPolicyForm.setOtherAlertRate(Integer.valueOf(trafficLimitingThreshold));
                    }
                } else {
                    otherDefendPolicyForm.setOtherLimitSubEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(otherNewDestSessionLimitingEnable)) {
                    otherDefendPolicyForm.setOtherNewDestSessionLimitEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(otherNewDestSessionLimitingThreshold)) {
                        otherDefendPolicyForm.setOtherNewDestSessionLimit(Long.valueOf(otherNewDestSessionLimitingThreshold));
                    }
                } else {
                    otherDefendPolicyForm.setOtherNewDestSessionLimitEnable(Boolean.valueOf(false));
                }
            } else {
                otherDefendPolicyForm.setOtherDefendEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(defenseEnable)) {
                otherDefendPolicyForm.setOtherDefenseEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(defenseThreshold)) {
                    otherDefendPolicyForm.setFingerAlert(Integer.valueOf(defenseThreshold));
                }
            } else {
                otherDefendPolicyForm.setOtherDefenseEnable(Boolean.valueOf(false));
            }
        }
        zoneServiceForm.setOtherDefendPolicyForm(otherDefendPolicyForm);
    }

    private static void parserInboundZonePolicyProtocolIcmp(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
        icmpDefendPolicyForm.setDirection(1);
        String blockEnable = elementPolicy.elementText("block-enable");
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String trafficLimitingSubEnable = elementPolicy.elementText("traffic-limiting-sub-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
        String icmpNewDestSessionLimitingEnable = elementPolicy.elementText("icmp-new-dest-session-limiting-enable");
        String icmpNewDestSessionLimitingThreshold = elementPolicy.elementText("icmp-new-dest-session-limiting-threshold");
        if (TRUE.equals(blockEnable)) {
            icmpDefendPolicyForm.setIcmpBlockEnable(Boolean.valueOf(true));
            icmpDefendPolicyForm.setIcmpMaxSpeedEnable(Boolean.valueOf(false));
        } else {
            icmpDefendPolicyForm.setIcmpBlockEnable(Boolean.valueOf(false));
            if (TRUE.equals(trafficLimitingEnable)) {
                icmpDefendPolicyForm.setIcmpMaxSpeedEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                    icmpDefendPolicyForm.setIcmpMaxSpeed(Integer.valueOf(trafficLimitingThreshold));
                }
                if (TRUE.equals(trafficLimitingSubEnable)) {
                    icmpDefendPolicyForm.setIcmpLimitSubEnable(Boolean.valueOf(true));
                } else {
                    icmpDefendPolicyForm.setIcmpLimitSubEnable(Boolean.valueOf(false));
                }
                if (TRUE.equals(icmpNewDestSessionLimitingEnable)) {
                    icmpDefendPolicyForm.setIcmpNewDestSessionLimitEnable(Boolean.valueOf(true));
                    if (!ImportParserUtil.isEmptyString(icmpNewDestSessionLimitingThreshold)) {
                        icmpDefendPolicyForm.setIcmpNewDestSessionLimit(Long.valueOf(icmpNewDestSessionLimitingThreshold));
                    }
                } else {
                    icmpDefendPolicyForm.setIcmpNewDestSessionLimitEnable(Boolean.valueOf(false));
                }
            } else {
                icmpDefendPolicyForm.setIcmpMaxSpeedEnable(Boolean.valueOf(false));
            }
        }
        zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
    }

    private static void parserInboundZonePolicyProtocolUdp(ZoneServiceForm zoneServiceForm, Element elementPolicy) {
        UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
        udpDefendPolicyForm.setDirection(1);
        String blockEnable = elementPolicy.elementText("block-enable");
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String udpTtrafficLimitingEnable = elementPolicy.elementText("udp-traffic-limiting-enable");
        String udpTrafficLimitingThreshold = elementPolicy.elementText("udp-traffic-limiting-threshold");
        String udpFragmentRateLimitingEnable = elementPolicy.elementText("udp-fragment-rate-limiting-enable");
        String udpFragmentRateLimitingThreshold = elementPolicy.elementText("udp-fragment-rate-limiting-threshold");
        String udpNewDestSessionLimitingEnable = elementPolicy.elementText("udp-new-dest-session-limiting-enable");
        String udpNewDestSessionLimitingThreshold = elementPolicy.elementText("udp-new-dest-session-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String udpAbnormalDefenseEnable = elementPolicy.elementText("udp-abnormal-defense-enable");
        String udpAbnormalDefenseThreshold = elementPolicy.elementText("udp-abnormal-defense-threshold");
        String udpFloodFingerprintDefenseEnable = elementPolicy.elementText("udp-flood-fingerprint-defense-enable");
        String udpFloodFingerprintDefenseThreshold = elementPolicy.elementText("udp-flood-fingerprint-defense-threshold");
        String udpFragmentAttackDefenseEnable = elementPolicy.elementText("udp-fragment-attack-defense-enable");
        String udpFragmentAttackDefenseThreshold = elementPolicy.elementText("udp-fragment-attack-defense-threshold");
        String udpFirstPacketCheckEnable = elementPolicy.elementText("udp-first-packet-check-enable");
        String udpUpperLimit = elementPolicy.elementText("udp-first-packet-check-upper-limit");
        if (TRUE.equals(blockEnable)) {
            udpDefendPolicyForm.setUdpBlock(Boolean.valueOf(true));
        }
        if (TRUE.equals(trafficLimitingEnable)) {
            udpDefendPolicyForm.setUdpLimitEnable(Boolean.valueOf(true));
            if (TRUE.equals(udpTtrafficLimitingEnable)) {
                udpDefendPolicyForm.setUdpMaxSpeedEnable(Boolean.valueOf(true));
            } else {
                udpDefendPolicyForm.setUdpMaxSpeedEnable(Boolean.valueOf(false));
            }
            if (!ImportParserUtil.isEmptyString(udpTrafficLimitingThreshold)) {
                udpDefendPolicyForm.setUdpMaxSpeed(Integer.valueOf(udpTrafficLimitingThreshold));
            }
            if (TRUE.equals(udpFragmentRateLimitingEnable)) {
                udpDefendPolicyForm.setUdpFragMaxSpeedEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(udpFragmentRateLimitingThreshold)) {
                    udpDefendPolicyForm.setUdpFragMaxSpeed(Integer.valueOf(udpFragmentRateLimitingThreshold));
                }
            } else {
                udpDefendPolicyForm.setUdpFragMaxSpeedEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(udpNewDestSessionLimitingEnable)) {
                udpDefendPolicyForm.setUdpNewDestSessionLimitEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(udpNewDestSessionLimitingThreshold)) {
                    udpDefendPolicyForm.setUdpNewDestSessionLimit(Long.valueOf(udpNewDestSessionLimitingThreshold));
                }
            } else {
                udpDefendPolicyForm.setUdpNewDestSessionLimitEnable(Boolean.valueOf(false));
            }
        } else {
            udpDefendPolicyForm.setUdpLimitEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(defenseEnable)) {
            udpDefendPolicyForm.setUdpDefendEnable(Boolean.valueOf(true));
            if (TRUE.equals(udpAbnormalDefenseEnable)) {
                udpDefendPolicyForm.setUdpAbnormalEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(udpAbnormalDefenseThreshold)) {
                    udpDefendPolicyForm.setUdpAbnormalAlertRate(Integer.valueOf(udpAbnormalDefenseThreshold));
                }
            } else {
                udpDefendPolicyForm.setUdpAbnormalEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(udpFloodFingerprintDefenseEnable)) {
                udpDefendPolicyForm.setAlertSpeedEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(udpFloodFingerprintDefenseThreshold)) {
                    udpDefendPolicyForm.setAlertSpeed(Integer.valueOf(udpFloodFingerprintDefenseThreshold));
                }
            } else {
                udpDefendPolicyForm.setAlertSpeedEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(udpFragmentAttackDefenseEnable)) {
                udpDefendPolicyForm.setFragAlertSpeedEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(udpFragmentAttackDefenseThreshold)) {
                    udpDefendPolicyForm.setFragAlertSpeed(Integer.valueOf(udpFragmentAttackDefenseThreshold));
                }
            } else {
                udpDefendPolicyForm.setFragAlertSpeedEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(udpFirstPacketCheckEnable)) {
                udpDefendPolicyForm.setUdpFirstPacketCheckEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(udpUpperLimit)) {
                    udpDefendPolicyForm.setUdpUpperLimit(Integer.valueOf(udpUpperLimit));
                }
            } else {
                udpDefendPolicyForm.setUdpFirstPacketCheckEnable(Boolean.valueOf(false));
            }
        } else {
            udpDefendPolicyForm.setUdpDefendEnable(Boolean.valueOf(false));
        }
        zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
    }

    private static void parserZoneWhiteList(Element element, ZonePolicyApplyForm zonePolicyApplyForm) {
        List elementZonWhiteList;
        Element elementWhitePolicyList = element.element("white-policy-list");
        if (null != elementWhitePolicyList && null != (elementZonWhiteList = element.element("white-policy-list").elements("white-list")) && !elementZonWhiteList.isEmpty()) {
            ArrayList<ZoneWhiteForm> zoneWhiteFormList = new ArrayList<ZoneWhiteForm>();
            for (Element elementZoneWhite : elementZonWhiteList) {
                String whiteListIp = elementZoneWhite.elementText("white-list-ip");
                String whiteListMask = elementZoneWhite.elementText("white-list-mask");
                ZoneWhiteForm zoneWhiteForm = null;
                if (ImportParserUtil.isEmptyString(whiteListIp) || ImportParserUtil.isEmptyString(whiteListMask)) continue;
                zoneWhiteForm = new ZoneWhiteForm();
                zoneWhiteForm.setIpAddress(whiteListIp);
                zoneWhiteForm.setMask(Integer.valueOf(whiteListMask));
                zoneWhiteForm.setBlackWhiteType(Integer.valueOf(2));
                zoneWhiteForm.setDeleteFlag(Integer.valueOf(0));
                zoneWhiteFormList.add(zoneWhiteForm);
            }
            zonePolicyApplyForm.setZoneWhiteFormList(zoneWhiteFormList);
        }
    }

    private static void parserZoneBlackList(Element element, ZonePolicyApplyForm zonePolicyApplyForm) {
        List elementZoneBlackList;
        Element elementBlackPolicyList = element.element("black-policy-list");
        if (null != elementBlackPolicyList && null != (elementZoneBlackList = element.element("black-policy-list").elements("black-list")) && !elementZoneBlackList.isEmpty()) {
            ArrayList<ZoneBlackWhiteForm> zoneBlackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
            for (Element elementZoneBlack : elementZoneBlackList) {
                String blackListIp = elementZoneBlack.elementText("black-list-ip");
                String blackListMask = elementZoneBlack.elementText("black-list-mask");
                ZoneBlackWhiteForm zoneBlackWhiteForm = null;
                if (ImportParserUtil.isEmptyString(blackListIp) || ImportParserUtil.isEmptyString(blackListMask)) continue;
                zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                zoneBlackWhiteForm.setIpAddress(blackListIp);
                zoneBlackWhiteForm.setMask(Integer.valueOf(blackListMask));
                zoneBlackWhiteForm.setBlackWhiteType(Integer.valueOf(1));
                zoneBlackWhiteForm.setDeleteFlag(Integer.valueOf(0));
                zoneBlackWhiteFormList.add(zoneBlackWhiteForm);
            }
            zonePolicyApplyForm.setZoneBlackWhiteFormList(zoneBlackWhiteFormList);
        }
    }

    private static void parserZoneIpLocation(Element element, ZonePolicyApplyForm zonePolicyApplyForm) {
        List elementfLocationList = element.element("location-policy-list").elements("location-policy");
        if (null != elementfLocationList && !elementfLocationList.isEmpty()) {
            ArrayList<ZoneIpLocationForm> zoneIpLocationList = new ArrayList<ZoneIpLocationForm>();
            for (Element elementlocation : elementfLocationList) {
                String locationNameEn = elementlocation.elementText("location-name");
                String locationAction = elementlocation.elementText("location-action");
                String locationLimit = elementlocation.elementText("location-limit");
                ZoneIpLocationForm zoneIpLocationForm = new ZoneIpLocationForm();
                if (!ImportParserUtil.isEmptyString(locationNameEn)) {
                    zoneIpLocationForm.setLocationNameEn(locationNameEn);
                }
                if (!ImportParserUtil.isEmptyString(locationAction)) {
                    zoneIpLocationForm.setLocationAction(Integer.valueOf(locationAction));
                }
                if (!ImportParserUtil.isEmptyString(locationLimit)) {
                    zoneIpLocationForm.setLocationLimit(Integer.valueOf(locationLimit));
                }
                zoneIpLocationList.add(zoneIpLocationForm);
            }
            zonePolicyApplyForm.setZoneIpLocationList(zoneIpLocationList);
        }
    }

    private static void parserZoneFilterIdList(Element element, ZonePolicyApplyForm zonePolicyApplyForm) {
        List inboundElementfilterList = element.element("filter-list").elements("filter-name");
        if (null != inboundElementfilterList && !inboundElementfilterList.isEmpty()) {
            ArrayList filterIdList = new ArrayList();
            ArrayList<String> filterNameList = new ArrayList<String>();
            for (Element elementFilter : inboundElementfilterList) {
                String filterName = elementFilter.getText();
                filterNameList.add(filterName);
            }
            zonePolicyApplyForm.setFilterIdList(filterIdList);
            zonePolicyApplyForm.setFilterNameList(filterNameList);
        }
    }

    private static void parserZoneFilterDropThreshold(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String filterDropThreshold = elementModeInfo.elementText("filter_drop_thershold");
        if (!ImportParserUtil.isEmptyString(filterDropThreshold)) {
            zonePolicyApplyForm.setFilterDropThreshold(Long.valueOf(filterDropThreshold));
        }
    }

    private static void parserZoneBlackhole(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String blackholeEnable = elementModeInfo.elementText("blackhole_enable");
        String blackholeThreshold = elementModeInfo.elementText("blackhole_threshold");
        String blackholeType = elementModeInfo.elementText("blackhole_type");
        if (TRUE.equals(blackholeEnable)) {
            zonePolicyApplyForm.setBlackholeEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(blackholeThreshold)) {
                zonePolicyApplyForm.setBlackholeThreshold(Long.valueOf(blackholeThreshold));
            }
            if (!ImportParserUtil.isEmptyString(blackholeType)) {
                if (Integer.parseInt(blackholeType) != ZoneConstants.BLACKHOLE_TYPE_ROUTE && Integer.parseInt(blackholeType) != ZoneConstants.BLACKHOLE_TYPE_INTERFACEBOARD && Integer.parseInt(blackholeType) != ZoneConstants.BLACKHOLE_TYPE_API) {
                    LOG.error((Object)"blackhole type error : BLACKHOLE_TYPE_ROUTE = 0; BLACKHOLE_TYPE_INTERFACEBOARD = 1; BLACKHOLE_TYPE_API = 2");
                    throw new LegoCheckedException(571981L);
                }
                zonePolicyApplyForm.setBlackholeType(Integer.valueOf(blackholeType));
            } else {
                zonePolicyApplyForm.setBlackholeType(ZoneConstants.BLACKHOLE_TYPE_ROUTE);
            }
        } else {
            zonePolicyApplyForm.setBlackholeEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneDestSessionLimit(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String newDestSessionLimitEnable = elementModeInfo.elementText("new_dest_session_limit_enable");
        String newDestSessionLimitThreshold = elementModeInfo.elementText("new_dest_session_limit_threshold");
        if (TRUE.equals(newDestSessionLimitEnable)) {
            zonePolicyApplyForm.setNewDestSessionLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(newDestSessionLimitThreshold)) {
                zonePolicyApplyForm.setDestSessionLimit(Long.valueOf(newDestSessionLimitThreshold));
            }
        } else {
            zonePolicyApplyForm.setNewDestSessionLimitEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneIpReputation(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String ipReputationEnable = elementModeInfo.elementText("ipreputation_enable");
        String ipReputationServiceType = elementModeInfo.elementText("ipreputation_service_type");
        if (TRUE.equals(ipReputationEnable)) {
            zonePolicyApplyForm.setIpReputationEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(ipReputationServiceType)) {
                zonePolicyApplyForm.setIpReputationServiceType(Integer.valueOf(Integer.parseInt(ipReputationServiceType)));
            }
        } else {
            zonePolicyApplyForm.setIpReputationEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneAudit(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String antiDomainAudit = elementModeInfo.elementText("anti-domain-audit");
        if (TRUE.equals(antiDomainAudit)) {
            zonePolicyApplyForm.setAuditEnable(Boolean.valueOf(true));
        } else {
            zonePolicyApplyForm.setAuditEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneDos(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String antiMalwareDos = elementModeInfo.elementText("anti-malware-dos");
        if (TRUE.equals(antiMalwareDos)) {
            zonePolicyApplyForm.setDosEnable(Boolean.valueOf(true));
        } else {
            zonePolicyApplyForm.setDosEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneIpLimit(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String singleIpAddressEnable = elementModeInfo.elementText("traffic-limiting-for-single-ip-address-enable");
        String singleIpAddressThreshold = elementModeInfo.elementText("traffic-limiting-for-single-ip-address-threshold");
        if (TRUE.equals(singleIpAddressEnable)) {
            zonePolicyApplyForm.setIpLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(singleIpAddressThreshold)) {
                zonePolicyApplyForm.setIpLimit(Integer.valueOf(singleIpAddressThreshold));
            }
        } else {
            zonePolicyApplyForm.setIpLimitEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneLimitRate(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String cleaningBandwidthEnable = elementModeInfo.elementText("cleaning-bandwidth-enable");
        String cleaningBandwidthThreshold = elementModeInfo.elementText("cleaning-bandwidth-threshold");
        if (TRUE.equals(cleaningBandwidthEnable)) {
            zonePolicyApplyForm.setZoneLimitEnable(Boolean.valueOf(true));
            if (!ImportParserUtil.isEmptyString(cleaningBandwidthThreshold)) {
                zonePolicyApplyForm.setZoneLimitRate(Integer.valueOf(cleaningBandwidthThreshold));
            }
        } else {
            zonePolicyApplyForm.setZoneLimitEnable(Boolean.valueOf(false));
        }
    }

    private static void parserZoneDynamicBlackListMode(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String dynamicBlacklistMode = elementModeInfo.elementText("dynamic-blacklist-mode");
        if (!ImportParserUtil.isEmptyString(dynamicBlacklistMode)) {
            zonePolicyApplyForm.setDynamicBlackMode(Integer.valueOf(dynamicBlacklistMode));
        }
    }

    private static void parserZoneBlackhole2(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String blackholeMode = elementModeInfo.elementText("blackhole-mode");
        String blackholeNotify = elementModeInfo.elementText("blackhole-notify-enable");
        if (!ImportParserUtil.isEmptyString(blackholeMode)) {
            zonePolicyApplyForm.setBlackholeMode(Integer.valueOf(blackholeMode));
        }
        if (!ImportParserUtil.isEmptyString(blackholeNotify)) {
            zonePolicyApplyForm.setBlackholeNotifyEnable(Integer.valueOf(blackholeNotify));
        }
    }

    private static void parserZoneDefendMode(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String defenseMode = elementModeInfo.elementText("defense-mode");
        if (!ImportParserUtil.isEmptyString(defenseMode)) {
            zonePolicyApplyForm.setDefendMode(Integer.valueOf(defenseMode));
        }
    }

    private static void parserZoneTrafficDiversionMode(ZonePolicyApplyForm zonePolicyApplyForm, Element elementModeInfo) {
        String trafficDiversionMode = elementModeInfo.elementText("traffic-diversion-mode");
        if (!ImportParserUtil.isEmptyString(trafficDiversionMode)) {
            zonePolicyApplyForm.setDivertMode(Integer.valueOf(trafficDiversionMode));
        }
    }

    private static void parserSetUpZoneDeviceInfo(Element element, ZonePolicyApplyForm zonePolicyApplyForm) {
        List elementZoneDeviceList = element.element("zone-device-list").elements("zone-device");
        ArrayList<ZoneDeviceForm> zoneDeviceForms = new ArrayList<ZoneDeviceForm>();
        if (null != elementZoneDeviceList && !elementZoneDeviceList.isEmpty()) {
            for (Element elementDevice : elementZoneDeviceList) {
                ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
                String deviceIp = elementDevice.elementText("device-ip");
                String vpnName = elementDevice.elementText("vpn-name");
                zoneDeviceForm.setDeviceIp(deviceIp);
                zoneDeviceForm.setVpnName(vpnName);
                zoneDeviceForms.add(zoneDeviceForm);
            }
        }
        zonePolicyApplyForm.setZoneDeviceForms(zoneDeviceForms);
    }

    private static void parserSetUpZonePortInfo(Element element, ZonePolicyApplyForm zonePolicyApplyForm, ZoneInfoForm zoneInfoForm) {
        List elementZonePortMapList;
        if (null != element.element("zone-port-map-list") && null != (elementZonePortMapList = element.element("zone-port-map-list").elements("zone-port-map")) && !elementZonePortMapList.isEmpty()) {
            ArrayList<ZonePortMapForm> zoneListPortMapFormList = new ArrayList<ZonePortMapForm>();
            for (Element elementPortMap : elementZonePortMapList) {
                String ipAddress = elementPortMap.elementText("ip-address");
                String ipPort = elementPortMap.elementText("ip-port");
                String protocol = elementPortMap.elementText("protocol");
                ZonePortMapForm zonePortMapForm = new ZonePortMapForm();
                if (ImportParserUtil.isEmptyString(ipAddress) || ImportParserUtil.isEmptyString(ipPort) || ImportParserUtil.isEmptyString(protocol) || !POLICY_PROTOCOL_HTTP.equals(protocol) || !IPUtil.isIpv4((String)ipAddress) && !IPUtil.isIpv6((String)ipAddress)) continue;
                zonePortMapForm.setIpAddress(ipAddress);
                zonePortMapForm.setIpPort(Integer.valueOf(Integer.parseInt(ipPort)));
                zonePortMapForm.setProtocol(protocol);
                zonePortMapForm.setDeleteFlag(Integer.valueOf(0));
                zoneListPortMapFormList.add(zonePortMapForm);
            }
            zoneInfoForm.setZonePortMapFormList(zoneListPortMapFormList);
            zonePolicyApplyForm.setZoneInfoForm(zoneInfoForm);
        }
    }

    private static void parserSetUpZoneIPInfo(Element element, ZonePolicyApplyForm zonePolicyApplyForm, ZoneInfoForm zoneInfoForm) {
        List elementZoneIpList = element.element("zone-ip-list").elements("zone-ip");
        ArrayList<ZoneListIpForm> zoneListIpFormList = new ArrayList<ZoneListIpForm>();
        if (null != elementZoneIpList && !elementZoneIpList.isEmpty()) {
            for (Element elementIp : elementZoneIpList) {
                String ipType = elementIp.elementText("ip-type");
                String maskType = elementIp.elementText("mask-type");
                String ipAddress = elementIp.elementText("ip-address");
                String subnetMask = elementIp.elementText("subnet-mask");
                String startIp = elementIp.elementText("start-ip");
                String endIp = elementIp.elementText("end-ip");
                ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
                zoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                if (!ImportParserUtil.isEmptyString(ipType)) {
                    zoneListIpForm.setIpType(Integer.parseInt(ipType));
                }
                if (!ImportParserUtil.isEmptyString(maskType)) {
                    zoneListIpForm.setMaskType(Integer.parseInt(maskType));
                }
                if (!ImportParserUtil.isEmptyString(subnetMask)) {
                    zoneListIpForm.setIntMask(Integer.parseInt(subnetMask));
                }
                if (ImportParserUtil.isEmptyString(ipType) || ImportParserUtil.isEmptyString(maskType)) continue;
                zoneListIpForm.setZoneIp(ipAddress);
                zoneListIpForm.setStartIp(startIp);
                zoneListIpForm.setEndIp(endIp);
                zoneListIpFormList.add(zoneListIpForm);
            }
        }
        zoneInfoForm.setZoneListIpFormList(zoneListIpFormList);
        zonePolicyApplyForm.setZoneInfoForm(zoneInfoForm);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parserSetUpZoneInfo(ZoneInfoForm zoneInfoForm, Element element) {
        Element elementZoneInfo = element.element("zone-info");
        String zoneInfoAccount = elementZoneInfo.elementText("account");
        String zoneInfoType = elementZoneInfo.elementText("type");
        String zoneInfoName = elementZoneInfo.elementText("name");
        String zoneInfoContact = elementZoneInfo.elementText("contact");
        String zoneInfoPhone = elementZoneInfo.elementText("phone");
        String zoneInfoMobilePhone = elementZoneInfo.elementText("mobile-phone");
        String zoneInfoIndustry = elementZoneInfo.elementText("industry");
        String zoneInfoPostCode = elementZoneInfo.elementText("post-code");
        String zoneInfoEmail = elementZoneInfo.elementText("email");
        String zoneInfoAddress = elementZoneInfo.elementText("address");
        String zoneInfoDescription = elementZoneInfo.elementText("description");
        zoneInfoForm.setZoneName(zoneInfoAccount);
        if (!ImportParserUtil.isEmptyString(zoneInfoType)) {
            zoneInfoForm.setZoneType(Integer.valueOf(zoneInfoType));
        }
        String regName = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
        if (!StringUtils.isBlank((CharSequence)zoneInfoName)) {
            if (!zoneInfoName.matches(regName)) {
                LOG.error((Object)"zoneInfoName format error");
                throw new LegoCheckedException(571981L);
            }
            zoneInfoForm.setZoneDesc(zoneInfoName);
        } else {
            zoneInfoForm.setZoneDesc(zoneInfoName);
        }
        zoneInfoForm.setContact(zoneInfoContact);
        zoneInfoForm.setTelephone(zoneInfoPhone);
        zoneInfoForm.setMobile(zoneInfoMobilePhone);
        if (!ImportParserUtil.isEmptyString(zoneInfoIndustry)) {
            zoneInfoForm.setIndustry(zoneInfoIndustry);
        }
        zoneInfoForm.setPost(zoneInfoPostCode);
        zoneInfoForm.setEmail(zoneInfoEmail);
        zoneInfoForm.setAddress(zoneInfoAddress);
        zoneInfoForm.setRemark(zoneInfoDescription);
    }

    private static TcpDefendPolicyForm portBizParse(Element elementPolicy) {
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        tcpDefendPolicyForm.setDirection(1);
        String sourceLimiteEnable = elementPolicy.elementText("source-ip-limiting-enable");
        String sourceLimitBandwidthEnable = elementPolicy.elementText("source-ip-band-width-limiting-enable");
        String sourceLimitBandwidthThreshold = elementPolicy.elementText("source-ip-band-width-limiting-threshold");
        String sourceLimitPacketEnable = elementPolicy.elementText("source-ip-limiting-packet-enable");
        String sourceLimitPacketThreshold = elementPolicy.elementText("source-ip-limiting-packet-threshold");
        String sourceLimitIllegalTimes = elementPolicy.elementText("source-ip-limiting-anomaly-times");
        String sourceLimitTotalTimes = elementPolicy.elementText("source-ip-limiting-total-check-times");
        String sourceLimitInterval = elementPolicy.elementText("source-ip-limiting-cycle");
        String synRationLimiteEnable = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-enable");
        String synRationLimiteThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-threshold");
        String synratioLimitPackets = elementPolicy.elementText("syn-ratio-Limit-packets");
        String synRationLimitecycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-cycle");
        String synRationLimitePacketsThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-threshold");
        String synRationLimitePacketscycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-cycle");
        String synBlackListEnable = elementPolicy.elementText("syn-blackList-enable");
        String synExceptionTimes = elementPolicy.elementText("syn-exception-times");
        String synTotalCheckTimes = elementPolicy.elementText("syn-total-check-times");
        String tcpConnectionDefenseEnable = elementPolicy.elementText("tcp-connection-flood-attack-defense-enable");
        String newSourceIpAddressEnable = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-enable");
        String newSourceIpAddressThreshold = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-threshold");
        String newSourceIpAddressCheckCycle = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-check-cycle");
        String sourceIpAddressEnable = elementPolicy.elementText("connection-number-check-for-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("connection-number-check-for-source-ip-address-threshold");
        if (TRUE.equals(sourceLimiteEnable)) {
            tcpDefendPolicyForm.setSourceLimitEnable(Boolean.valueOf(true));
            if (TRUE.equals(sourceLimitBandwidthEnable)) {
                tcpDefendPolicyForm.setSourceLimitBandwidthEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(sourceLimitBandwidthThreshold)) {
                    tcpDefendPolicyForm.setSourceLimitBandwidthRate(Integer.valueOf(sourceLimitBandwidthThreshold));
                }
            } else {
                tcpDefendPolicyForm.setSourceLimitBandwidthEnable(Boolean.valueOf(false));
            }
            if (TRUE.equals(sourceLimitPacketEnable)) {
                tcpDefendPolicyForm.setSourceLimitPacketsEnable(Boolean.valueOf(true));
                if (!ImportParserUtil.isEmptyString(sourceLimitPacketThreshold)) {
                    tcpDefendPolicyForm.setSourceLimitPacketsRate(Integer.valueOf(sourceLimitPacketThreshold));
                }
            } else {
                tcpDefendPolicyForm.setSourceLimitPacketsEnable(Boolean.valueOf(false));
            }
            if (!ImportParserUtil.isEmptyString(sourceLimitIllegalTimes)) {
                tcpDefendPolicyForm.setSourceLimitIllegalTimes(Integer.valueOf(sourceLimitIllegalTimes));
            }
            if (!ImportParserUtil.isEmptyString(sourceLimitTotalTimes)) {
                tcpDefendPolicyForm.setSourceLimitTotalTimes(Integer.valueOf(sourceLimitTotalTimes));
            }
            if (!ImportParserUtil.isEmptyString(sourceLimitInterval)) {
                tcpDefendPolicyForm.setSourceLimitInterval(Integer.valueOf(sourceLimitInterval));
            }
        } else {
            tcpDefendPolicyForm.setSourceLimitEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(synRationLimiteEnable)) {
            tcpDefendPolicyForm.setSynratioEnable(Boolean.valueOf(true));
            if (ImportParserUtil.isEmptyString(synratioLimitPackets)) {
                tcpDefendPolicyForm.setSynratioLimitPackets(PolicyDefaultValueUtil.paraDefault((String)"synratioLimitPackets"));
            } else {
                tcpDefendPolicyForm.setSynratioLimitPackets(Integer.valueOf(synratioLimitPackets));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimiteThreshold)) {
                tcpDefendPolicyForm.setSynratioLimitRate(Integer.valueOf(synRationLimiteThreshold));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimitecycle)) {
                tcpDefendPolicyForm.setSynratioDuration(Integer.valueOf(synRationLimitecycle));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimitePacketsThreshold)) {
                tcpDefendPolicyForm.setSynMaxPackets(Integer.valueOf(synRationLimitePacketsThreshold));
            }
            if (!ImportParserUtil.isEmptyString(synRationLimitePacketscycle)) {
                tcpDefendPolicyForm.setSynMaxPacketsDuration(Integer.valueOf(synRationLimitePacketscycle));
            }
            ImportParserUtil.tcpDefendPolicySynBlackListEnable(tcpDefendPolicyForm, synBlackListEnable, synExceptionTimes, synTotalCheckTimes);
        } else {
            tcpDefendPolicyForm.setSynratioEnable(Boolean.valueOf(false));
        }
        if (TRUE.equals(tcpConnectionDefenseEnable)) {
            tcpDefendPolicyForm.setTcpConnEnable(Boolean.valueOf(true));
        } else {
            tcpDefendPolicyForm.setTcpConnEnable(Boolean.valueOf(false));
        }
        ImportParserUtil.tcpDefendPolicyNewSourceIpAddressEnable(tcpDefendPolicyForm, newSourceIpAddressEnable, newSourceIpAddressThreshold, newSourceIpAddressCheckCycle);
        ImportParserUtil.tcpDefendPolicySourceIpAddressEnable(tcpDefendPolicyForm, sourceIpAddressEnable, sourceIpAddressThreshold);
        return tcpDefendPolicyForm;
    }

    private static void initZoneServicedData(String deviceIp, ZoneServiceForm zoneServiceForm) {
        zoneServiceForm.setDirection(Integer.valueOf(2));
        zoneServiceForm.setServiceName("Basic_Outbound_" + deviceIp.replace(".", "_"));
        zoneServiceForm.setDeviceIp(deviceIp);
        zoneServiceForm.setProtocol(POLICY_PROTOCOL_DEFAULT);
    }

    private static ZoneServiceForm initZoneServiceForm(boolean isSupportOutbound) {
        ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
        zoneServiceForm.setDirection(Integer.valueOf(2));
        NfaPolicyEditForm nfaPolicyEditForm = new NfaPolicyEditForm();
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
        IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
        if (isSupportOutbound) {
            tcpDefendPolicyForm.setDirection(2);
            udpDefendPolicyForm.setDirection(2);
            icmpDefendPolicyForm.setDirection(2);
            nfaPolicyEditForm.setDirection(2);
        }
        HttpDefendPolicyForm httpDefendPolicyForm = new HttpDefendPolicyForm();
        HttpsDefendPolicyForm httpsDefendPolicyForm = new HttpsDefendPolicyForm();
        DnsDefendPolicyForm dnsDefendPolicyForm = new DnsDefendPolicyForm();
        SipDefendPolicyForm sipDefendPolicyForm = new SipDefendPolicyForm();
        OtherDefendPolicyForm otherDefendPolicyForm = new OtherDefendPolicyForm();
        zoneServiceForm.setTcpDefendPolicyForm(tcpDefendPolicyForm);
        zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
        zoneServiceForm.setHttpDefendPolicyForm(httpDefendPolicyForm);
        zoneServiceForm.setHttpsDefendPolicyForm(httpsDefendPolicyForm);
        zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
        zoneServiceForm.setDnsDefendPolicyForm(dnsDefendPolicyForm);
        zoneServiceForm.setSipDefendPolicyForm(sipDefendPolicyForm);
        zoneServiceForm.setOtherDefendPolicyForm(otherDefendPolicyForm);
        zoneServiceForm.setNfaPolicyEditForm(nfaPolicyEditForm);
        return zoneServiceForm;
    }

    private static void parserFaultSeverityRule(ZonePolicyApplyForm zonePolicyApplyForm, Element element, boolean isInbound) {
        Element ruleTemp = element.element("fault-severity-rule-list");
        if (null == ruleTemp) {
            return;
        }
        List elementRuleList = ruleTemp.elements("fault-severity-rule");
        if (null != elementRuleList && !elementRuleList.isEmpty()) {
            FaultSeverityRuleForm faultSeverityRuleForm = new FaultSeverityRuleForm();
            FaultSeverityRule faultSeverityRule = null;
            for (Element elementRule : elementRuleList) {
                String severity = elementRule.elementText("severity");
                String inTrafficMbpsStatus = elementRule.elementText("in-traffic-mbps-status");
                String inTrafficMbps = TRUE;
                if (TRUE.equals(inTrafficMbpsStatus) && CheckImportXml.isGreaterThan0((String)elementRule.elementText("in-traffic-mbps"))) {
                    inTrafficMbps = elementRule.elementText("in-traffic-mbps");
                }
                String inTrafficppsStatus = elementRule.elementText("in-traffic-pps-status");
                String inTrafficpps = TRUE;
                if (TRUE.equals(inTrafficppsStatus) && CheckImportXml.isGreaterThan0((String)elementRule.elementText("in-traffic-pps"))) {
                    inTrafficpps = elementRule.elementText("in-traffic-pps");
                }
                String currentConnStatus = "";
                String currentConn = TRUE;
                String newConnStatus = "";
                String newConn = TRUE;
                if (isInbound) {
                    currentConnStatus = elementRule.elementText("current-conn-status");
                    if (TRUE.equals(currentConnStatus) && CheckImportXml.isGreaterThan0((String)elementRule.elementText("current-conn"))) {
                        currentConn = elementRule.elementText("current-conn");
                    }
                    if (TRUE.equals(newConnStatus = elementRule.elementText("new-conn-status")) && CheckImportXml.isGreaterThan0((String)elementRule.elementText("new-conn"))) {
                        newConn = elementRule.elementText("new-conn");
                    }
                }
                String durationStatus = elementRule.elementText("duration-status");
                String duration = TRUE;
                if (TRUE.equals(durationStatus) && CheckImportXml.isGreaterThan0((String)elementRule.elementText("duration"))) {
                    duration = elementRule.elementText("duration");
                }
                String diversionAction = elementRule.elementText("diversion-action");
                if (ImportParserUtil.isEmptyString(severity)) continue;
                faultSeverityRule = new FaultSeverityRule();
                faultSeverityRule.setSeverity(Integer.parseInt(severity));
                if (!ImportParserUtil.isEmptyString(inTrafficMbpsStatus)) {
                    faultSeverityRule.setInTrafficMbpsStatus(Integer.parseInt(inTrafficMbpsStatus));
                }
                if (!ImportParserUtil.isEmptyString(inTrafficMbps)) {
                    faultSeverityRule.setInTrafficMbps(Integer.parseInt(inTrafficMbps));
                }
                if (!ImportParserUtil.isEmptyString(inTrafficppsStatus)) {
                    faultSeverityRule.setInTrafficppsStatus(Integer.parseInt(inTrafficppsStatus));
                }
                if (!ImportParserUtil.isEmptyString(inTrafficpps)) {
                    faultSeverityRule.setInTrafficpps(Integer.parseInt(inTrafficpps));
                }
                if (!ImportParserUtil.isEmptyString(currentConnStatus)) {
                    faultSeverityRule.setCurrentConnStatus(Integer.parseInt(currentConnStatus));
                }
                if (!ImportParserUtil.isEmptyString(currentConn)) {
                    faultSeverityRule.setCurrentConn(Integer.parseInt(currentConn));
                }
                if (!ImportParserUtil.isEmptyString(newConnStatus)) {
                    faultSeverityRule.setNewConnStatus(Integer.parseInt(newConnStatus));
                }
                if (!ImportParserUtil.isEmptyString(newConn)) {
                    faultSeverityRule.setNewConn(Integer.parseInt(newConn));
                }
                if (!ImportParserUtil.isEmptyString(durationStatus)) {
                    faultSeverityRule.setDurationStatus(Integer.parseInt(durationStatus));
                }
                if (!ImportParserUtil.isEmptyString(duration)) {
                    faultSeverityRule.setDuration(Integer.parseInt(duration));
                }
                if (!ImportParserUtil.isEmptyString(diversionAction)) {
                    faultSeverityRule.setDiversionAction(Integer.parseInt(diversionAction));
                }
                if (isInbound) {
                    faultSeverityRule.setDirection(1);
                } else {
                    faultSeverityRule.setDirection(2);
                }
                if ("4".equals(severity)) {
                    faultSeverityRuleForm.setCriticalRule(faultSeverityRule);
                    continue;
                }
                if (PACKET_CAPTURE_LENGTH_TYPE.equals(severity)) {
                    faultSeverityRuleForm.setMajorRule(faultSeverityRule);
                    continue;
                }
                if ("2".equals(severity)) {
                    faultSeverityRuleForm.setMinorRule(faultSeverityRule);
                    continue;
                }
                if (!TRUE.equals(severity)) continue;
                faultSeverityRuleForm.setWarningRule(faultSeverityRule);
            }
            if (isInbound) {
                zonePolicyApplyForm.setFaultSeverityRuleForm(faultSeverityRuleForm);
            } else {
                zonePolicyApplyForm.setOutboundFaultSeverityRuleForm(faultSeverityRuleForm);
            }
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private static void parseByDevice(Element root, ImportForm form) {
        List elementFilterlist;
        String name;
        List elementIpLocationlist;
        Element globalPolicy;
        Element device = root.element("device-info");
        if (null != device) {
            String deviceName = device.elementText("device-name");
            String deviceIp = device.elementText("device-ip");
            if (AticUtil.validateSpecialStr((String)deviceName)) {
                form.setDeviceName(deviceName);
            }
            form.setDeviceIp(deviceIp);
        }
        if (null != (globalPolicy = root.element("global-policy")) && null != form) {
            List elementDomainWhitelist;
            List elementWhitelist;
            List elementBlacklist;
            String endIp;
            String startIp;
            String subnetMask;
            String ipAddress;
            String maskType;
            List elementProxyIplist;
            Element elementProxyIp;
            FWDefenceAbnormalForm abnormalForm = new FWDefenceAbnormalForm();
            String locationSwitch = globalPolicy.elementText("location_switch");
            String fraggleEnable = globalPolicy.elementText("fraggle-enable");
            String winnukeEnable = globalPolicy.elementText("winnuke-enable");
            String routeRecordOptionEnable = globalPolicy.elementText("ip-packet-with-route-record-option-enable");
            String tcpFlagBitEnable = globalPolicy.elementText("tcp-flag-bit-enable");
            String timestampOptionEnable = globalPolicy.elementText("ip-packet-with-timestamp-option-enable");
            String icmpRedirectionPacketEnable = globalPolicy.elementText("icmp-redirection-packet-enable");
            String landEnable = globalPolicy.elementText("land-enable");
            String smurfEnable = globalPolicy.elementText("smurf-enable");
            String teardropEnable = globalPolicy.elementText("teardrop-enable");
            String tracertEnable = globalPolicy.elementText("tracert-enable");
            String icmpUnreachablePacketEnable = globalPolicy.elementText("icmp-unreachable-packet-enable");
            String deathEnable = globalPolicy.elementText("ping-of-death-enable");
            String sourceRouteOptionEnable = globalPolicy.elementText("ip-packet-with-source-route-option-enable");
            String icmpPacketEnable = globalPolicy.elementText("large-icmp-packet-enable");
            String icmpPacketValue = globalPolicy.elementText("large-icmp-packet-value");
            String udpPacketEnable = globalPolicy.elementText("large-udp-packet-enable");
            String udpPacketValue = globalPolicy.elementText("large-udp-packet-value");
            String lengthType = globalPolicy.elementText("packet-capture-length-type");
            String lengthValue = globalPolicy.elementText("packet-capture-length-value");
            String blackholeMode = globalPolicy.elementText("blackhole_mode");
            String ipRepuationEnable = globalPolicy.elementText("ip_reputation_enable");
            String grayThreshold = globalPolicy.elementText("gray_threshold");
            String blackThreshold = globalPolicy.elementText("black_threshold");
            String statisticsFeedback = globalPolicy.elementText("statistics_feedback");
            String sampleRate = globalPolicy.elementText("sample_rate");
            if (!ImportParserUtil.isEmptyString(locationSwitch)) {
                abnormalForm.setLocationSwitch(Integer.valueOf(locationSwitch));
            } else {
                abnormalForm.setLocationSwitch(0);
            }
            String str = ":-:-:-:-,";
            StringBuffer param = new StringBuffer();
            param.append("FRAGGLE:").append(fraggleEnable).append(str);
            param.append("ICMP_REDIRECT:").append(icmpRedirectionPacketEnable).append(str);
            param.append("ICMP_UNREACHABLE:").append(icmpUnreachablePacketEnable).append(str);
            param.append("WINNUKE:").append(winnukeEnable).append(str);
            param.append("LAND:").append(landEnable).append(str);
            param.append("PING_OF_DEATH:").append(deathEnable).append(str);
            param.append("ROUTE_RECORD:").append(routeRecordOptionEnable).append(str);
            param.append("SMURF:").append(smurfEnable).append(str);
            param.append("SOURCE_ROUTE:").append(sourceRouteOptionEnable).append(str);
            param.append("TCP_FLAG:").append(tcpFlagBitEnable).append(str);
            param.append("TEARDROP:").append(teardropEnable).append(str);
            param.append("LARGE_ICMP:").append(icmpPacketEnable).append(':').append(icmpPacketValue).append(":Bytes:28:65535,");
            param.append("TIME_STAMP:").append(timestampOptionEnable).append(str);
            param.append("TRACERT:").append(tracertEnable).append(str);
            param.append("LARGE_UDP:").append(udpPacketEnable).append(':').append(udpPacketValue).append(":Bytes:28:65535");
            abnormalForm.setParams(param.toString());
            if (!ImportParserUtil.isEmptyString(lengthType)) {
                abnormalForm.setPcapMode(Integer.valueOf(lengthType));
                if (!ImportParserUtil.isEmptyString(lengthValue) && PACKET_CAPTURE_LENGTH_TYPE.equals(lengthType)) {
                    abnormalForm.setPcapLength(Integer.valueOf(lengthValue));
                }
            }
            if (!ImportParserUtil.isEmptyString(blackholeMode)) {
                abnormalForm.setBlackholeMode(Integer.valueOf(blackholeMode));
            }
            if (!ImportParserUtil.isEmptyString(ipRepuationEnable)) {
                abnormalForm.setIpRepuationEnable(Integer.parseInt(ipRepuationEnable));
            }
            if (!ImportParserUtil.isEmptyString(grayThreshold)) {
                abnormalForm.setGrayThreshold(Integer.parseInt(grayThreshold));
            }
            if (!ImportParserUtil.isEmptyString(blackThreshold)) {
                abnormalForm.setBlackThreshold(Integer.parseInt(blackThreshold));
            }
            if (!ImportParserUtil.isEmptyString(statisticsFeedback)) {
                abnormalForm.setStatisticsFeedback(Integer.parseInt(statisticsFeedback));
            }
            if (!ImportParserUtil.isEmptyString(sampleRate)) {
                abnormalForm.setSampleRate(Integer.parseInt(sampleRate));
            }
            if (null != (elementProxyIp = globalPolicy.element("proxy-ip-list")) && null != (elementProxyIplist = elementProxyIp.elements("proxy-ip-item")) && !elementProxyIplist.isEmpty()) {
                ArrayList<GloCdnIpListForm> gloProxyIplist = new ArrayList<GloCdnIpListForm>();
                for (Object element : elementProxyIplist) {
                    GloCdnIpListForm gloCdnIpListForm = new GloCdnIpListForm();
                    gloCdnIpListForm.setDeleteFlag(false);
                    gloCdnIpListForm.setDeployState("UNDEPLOY");
                    maskType = element.elementText("mask-type");
                    ipAddress = element.elementText("ip-address");
                    subnetMask = element.elementText("subnet-mask");
                    startIp = element.elementText("start-ip");
                    endIp = element.elementText("end-ip");
                    if (!ImportParserUtil.isEmptyString(maskType)) {
                        gloCdnIpListForm.setMaskType(Integer.valueOf(maskType));
                    }
                    gloCdnIpListForm.setIpAddress(ipAddress);
                    if (!ImportParserUtil.isEmptyString(subnetMask)) {
                        gloCdnIpListForm.setMask(Integer.valueOf(subnetMask));
                    }
                    gloCdnIpListForm.setStartIp(startIp);
                    gloCdnIpListForm.setEndIp(endIp);
                    gloProxyIplist.add(gloCdnIpListForm);
                }
                form.setProxyIpFormList(gloProxyIplist);
            }
            if (null != (elementBlacklist = globalPolicy.element("blacklist").elements("blacklist-item")) && !elementBlacklist.isEmpty()) {
                ArrayList<GloBlackListIpForm> gloBlacklist = new ArrayList<GloBlackListIpForm>();
                for (Object element : elementBlacklist) {
                    GloBlackListIpForm gloBlackListForm = new GloBlackListIpForm();
                    maskType = element.elementText("mask-type");
                    ipAddress = element.elementText("ip-address");
                    subnetMask = element.elementText("subnet-mask");
                    startIp = element.elementText("start-ip");
                    endIp = element.elementText("end-ip");
                    if (!ImportParserUtil.isEmptyString(maskType)) {
                        gloBlackListForm.setMaskType(Integer.valueOf(maskType));
                    }
                    gloBlackListForm.setBlacklistIp(ipAddress);
                    if (!ImportParserUtil.isEmptyString(subnetMask)) {
                        gloBlackListForm.setIntMask(Integer.valueOf(subnetMask));
                    }
                    gloBlackListForm.setStartIp(startIp);
                    gloBlackListForm.setEndIp(endIp);
                    gloBlacklist.add(gloBlackListForm);
                }
                form.setBlackListIpFormList(gloBlacklist);
            }
            if (null != (elementWhitelist = globalPolicy.element("whitelist").elements("whitelist-item")) && !elementWhitelist.isEmpty()) {
                ArrayList<GloWhiteListIpForm> gloWhitelist = new ArrayList<GloWhiteListIpForm>();
                for (Object element : elementWhitelist) {
                    GloWhiteListIpForm gloWhiteListForm = new GloWhiteListIpForm();
                    String maskType2 = element.elementText("mask-type");
                    String ipAddress2 = element.elementText("ip-address");
                    String subnetMask2 = element.elementText("subnet-mask");
                    String startIp2 = element.elementText("start-ip");
                    String endIp2 = element.elementText("end-ip");
                    if (!ImportParserUtil.isEmptyString(maskType2)) {
                        gloWhiteListForm.setMaskType(Integer.valueOf(maskType2));
                    }
                    gloWhiteListForm.setWhitelistIp(ipAddress2);
                    if (!ImportParserUtil.isEmptyString(subnetMask2)) {
                        gloWhiteListForm.setIntMask(Integer.valueOf(subnetMask2));
                    }
                    gloWhiteListForm.setStartIp(startIp2);
                    gloWhiteListForm.setEndIp(endIp2);
                    gloWhitelist.add(gloWhiteListForm);
                }
                form.setWhiteListIpFormList(gloWhitelist);
            }
            if (null != (elementDomainWhitelist = globalPolicy.element("domainwhiteList").elements("domainwhite-item")) && !elementDomainWhitelist.isEmpty()) {
                LinkedHashMap<String, GloDomainWhiteListForm> map = new LinkedHashMap<String, GloDomainWhiteListForm>();
                for (Element element : elementDomainWhitelist) {
                    if (map.size() == 10000) break;
                    GloDomainWhiteListForm gloDomainWhiteForm = new GloDomainWhiteListForm();
                    String domainwhite = element.elementText("domainwhite");
                    if (!BaseCommonUtil.isDomain((String)domainwhite)) continue;
                    domainwhite = domainwhite.trim().toLowerCase(Locale.ENGLISH);
                    gloDomainWhiteForm.setDomainWhite(domainwhite);
                    map.put(domainwhite, gloDomainWhiteForm);
                }
                ArrayList<GloDomainWhiteListForm> dwf = new ArrayList<GloDomainWhiteListForm>();
                dwf.addAll(map.values());
                form.setDomainWhiteListFormList(dwf);
            }
            form.setAbnormalForm(abnormalForm);
        }
        if (null != (elementIpLocationlist = root.element("ip-location-list").elements("ip-location")) && !elementIpLocationlist.isEmpty()) {
            ArrayList<LocationCustomForm> locationFormList = new ArrayList<LocationCustomForm>();
            for (Element element : elementIpLocationlist) {
                LocationCustomForm locationCustomForm = new LocationCustomForm();
                name = element.elementText("name");
                String description = element.elementText("description");
                List ipAddressList = element.element("ip-address-list").elements("ip-address");
                ArrayList<Object> locationIpList = new ArrayList<Object>();
                for (Element ele : ipAddressList) {
                    String ipAddress = ele.getText();
                    LocationIpForm locationIpForm = new LocationIpForm();
                    locationIpForm.setIpString(ipAddress);
                    locationIpList.add(locationIpForm);
                }
                locationCustomForm.setLocationName(name);
                locationCustomForm.setDescription(description);
                locationCustomForm.setLocationIpList(locationIpList);
                locationFormList.add(locationCustomForm);
                form.setLocationFormList(locationFormList);
            }
        }
        if (null != (elementFilterlist = root.element("filter-list").elements("filter")) && !elementFilterlist.isEmpty()) {
            ArrayList<FilterForm> filterFormList = new ArrayList<FilterForm>();
            for (Element element : elementFilterlist) {
                name = element.elementText("name");
                String filterDeviceType = element.elementText("device-type");
                String protocol = element.elementText("protocol");
                String action = element.elementText("action");
                String threshold = element.elementText("threshold");
                List elementKeywordList = element.element("keyword-list").elements("keyword");
                ArrayList<HttpFilterForm> httpFilterFormList = new ArrayList<HttpFilterForm>();
                for (Element keyword : elementKeywordList) {
                    String key = keyword.elementText("keyword-key");
                    String content = keyword.elementText("keyword-content");
                    HttpFilterForm httpFilterForm = new HttpFilterForm();
                    httpFilterForm.setFilterKey(key);
                    content = content.replace("&nbsp;", " ");
                    httpFilterForm.setFilterContent(content);
                    httpFilterFormList.add(httpFilterForm);
                }
                FilterForm filterForm = new FilterForm();
                filterForm.setFilterName(name);
                if (ImportParserUtil.isEmptyString(filterDeviceType)) {
                    filterDeviceType = "AntiDDoS";
                }
                filterForm.setDeviceType(filterDeviceType);
                Integer tag = 0;
                if (!ImportParserUtil.isEmptyString(action)) {
                    tag = Integer.valueOf(action);
                    filterForm.setFilterAction(Integer.valueOf(action));
                }
                filterForm.setFilterType(protocol);
                if (!(ImportParserUtil.isEmptyString(threshold) || tag != 5 && tag != 7)) {
                    filterForm.setFilterAlert(Integer.valueOf(threshold));
                }
                filterForm.setHttpFilterFormList(httpFilterFormList);
                filterFormList.add(filterForm);
            }
            form.setFilterFormList(filterFormList);
        }
    }
}

