/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.neglobal.util;

import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.bis.service.ILocationIpService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.CheckImportXml;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.neglobal.util.ImportConstant;
import com.hs.vsm.secservice.ddos.policy.util.DevCapUtil;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.neglobal.model.GloBlackListInfo;
import com.hs.vsm.secservice.neglobal.model.GloBlackListIpInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListIpInfo;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.ImportData;
import com.hs.vsm.secservice.sdk.module.neglobal.form.ImportForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloDomainWhiteListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class ImportUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private static ImportUtil instance = null;
    private static ReentrantLock lock = new ReentrantLock();

    private ImportUtil() {
    }

    public static ImportUtil getinstance() {
        lock.lock();
        try {
            ImportUtil importUtil = instance == null ? (ImportUtil)ImportUtil.class.newInstance() : instance;
            return importUtil;
        }
        catch (InstantiationException e) {
            ImportUtil importUtil = null;
            return importUtil;
        }
        catch (IllegalAccessException e) {
            ImportUtil importUtil = null;
            return importUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public static List<LocationCustomForm> getSameNameIpLocation(List<LocationCustomForm> xmlLocationCusFormList, String tartget, List<BatchOperation> frontOperationList) {
        ArrayList<LocationCustomForm> sameNameLocationList = new ArrayList<LocationCustomForm>();
        if (null != xmlLocationCusFormList && !xmlLocationCusFormList.isEmpty()) {
            HashSet<String> locationNameSet = new HashSet<String>();
            for (LocationCustomForm cusForm : xmlLocationCusFormList) {
                if (locationNameSet.contains(cusForm.getLocationName().toLowerCase(Locale.getDefault()))) {
                    sameNameLocationList.add(cusForm);
                    ImportUtil.recordErrorMessg(tartget + cusForm.getLocationName(), 572067L, frontOperationList);
                    continue;
                }
                locationNameSet.add(cusForm.getLocationName().toLowerCase(Locale.getDefault()));
            }
        }
        return sameNameLocationList;
    }

    public static List<FilterForm> getSameNameFilter(List<FilterForm> xmlFilterFormList, String tartget, List<BatchOperation> frontOperationList) {
        ArrayList<FilterForm> sameNameFilterFormList = new ArrayList<FilterForm>();
        if (null != xmlFilterFormList && !xmlFilterFormList.isEmpty()) {
            HashSet<String> filterNameSet = new HashSet<String>();
            for (FilterForm filterForm : xmlFilterFormList) {
                if (null == filterForm.getFilterName() || filterForm.getFilterName().isEmpty()) {
                    sameNameFilterFormList.add(filterForm);
                    continue;
                }
                if (filterNameSet.contains(filterForm.getFilterName().toLowerCase(Locale.getDefault()))) {
                    sameNameFilterFormList.add(filterForm);
                    ImportUtil.recordErrorMessg(tartget + filterForm.getFilterName(), 572066L, frontOperationList);
                    continue;
                }
                filterNameSet.add(filterForm.getFilterName().toLowerCase(Locale.getDefault()));
            }
        }
        return sameNameFilterFormList;
    }

    public static Map<String, ZoneDeviceForm> getZoneDeviceMap(List<ZoneDeviceForm> zoneDeviceList) {
        HashMap<String, ZoneDeviceForm> zoneDevMap = new HashMap<String, ZoneDeviceForm>();
        if (null != zoneDeviceList && !zoneDeviceList.isEmpty()) {
            for (ZoneDeviceForm zdForm : zoneDeviceList) {
                zoneDevMap.put(zdForm.getDeviceIp(), zdForm);
            }
        }
        return zoneDevMap;
    }

    public static boolean checkZoneInfoBasicInformation(ZoneInfoForm zoneInfoForm, ZonePolicyApplyForm zonePolicyApplyForm, List<BatchOperation> frontOperationList, ImportData importData) {
        boolean zoneInfoBasicFlag = CheckImportXml.checkZoneBasicInfo((ZoneInfoForm)zoneInfoForm, frontOperationList, (String)importData.getZoneString());
        boolean faultSeverityRuleFlag = ZoneUtil.checkFaultSeverityRuleParameter4Import((ZoneInfoForm)zoneInfoForm, (FaultSeverityRuleForm)zonePolicyApplyForm.getFaultSeverityRuleForm(), frontOperationList, (String)importData.getZoneString());
        boolean outboundfaultSeverityRuleFlag = ZoneUtil.checkFaultSeverityRuleParameter4Import((ZoneInfoForm)zoneInfoForm, (FaultSeverityRuleForm)zonePolicyApplyForm.getOutboundFaultSeverityRuleForm(), frontOperationList, (String)importData.getZoneString());
        Object[] params = new Object[]{zoneInfoForm.getZoneId(), zoneInfoForm.getZoneListIpFormList(), zoneInfoForm, frontOperationList, logger, importData.getZoneString()};
        boolean ipAddrFlag = ZoneUtil.validateIpAddress((Object[])params);
        return zoneInfoBasicFlag && faultSeverityRuleFlag && outboundfaultSeverityRuleFlag && ipAddrFlag;
    }

    public static Map<String, IpLocation> ipLocationMap(boolean needLocation) {
        ILibraryFileService service = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        Map map = service.getIpLocationMap();
        ILocationCustomService locationCustomService = (ILocationCustomService)ServiceContext.getInstance().getService("locationCustomService", ILocationCustomService.class);
        List list = locationCustomService.queryByDeployStatus("undeployed");
        if (null != list && !list.isEmpty()) {
            for (LocationCustom locationCustom : list) {
                IpLocation iplocation = new IpLocation();
                iplocation.setLocationId(locationCustom.getPkId().longValue());
                iplocation.setLocationNameZh(locationCustom.getLocationName());
                iplocation.setLocationNameEn(locationCustom.getLocationName());
                map.put(locationCustom.getPkId(), iplocation);
            }
        }
        ArrayList ipLocationAlList = new ArrayList(map.values());
        HashMap<String, IpLocation> locationMap = new HashMap<String, IpLocation>();
        if (needLocation) {
            for (IpLocation ipLocation : ipLocationAlList) {
                if (ipLocation.getLocationNameEn().contains("/")) {
                    int index = ipLocation.getLocationNameEn().indexOf("/");
                    int len = ipLocation.getLocationNameEn().length();
                    locationMap.put(ipLocation.getLocationNameEn().substring(index + 1, len), ipLocation);
                    continue;
                }
                locationMap.put(ipLocation.getLocationNameEn(), ipLocation);
            }
        }
        return locationMap;
    }

    public static void removeAllSameNameService(List<ZoneServiceForm> serviceFormList, String zoneNameTarget, List<BatchOperation> frontOperationList) {
        if (null == serviceFormList || serviceFormList.isEmpty()) {
            return;
        }
        Map<String, List<ZoneServiceForm>> zoneDevIdServiceMap = ImportUtil.getZoneDeviceServiceMap(serviceFormList);
        if (!zoneDevIdServiceMap.isEmpty()) {
            ArrayList<ZoneServiceForm> tempServiceFormList = new ArrayList<ZoneServiceForm>();
            List<ZoneServiceForm> serviceFormByDeviceList = null;
            String deviceIpString = "";
            for (Map.Entry<String, List<ZoneServiceForm>> entry : zoneDevIdServiceMap.entrySet()) {
                serviceFormByDeviceList = entry.getValue();
                deviceIpString = entry.getKey();
                if (null == serviceFormByDeviceList || serviceFormByDeviceList.isEmpty()) continue;
                for (int i = 0; i < serviceFormByDeviceList.size(); ++i) {
                    for (int j = serviceFormByDeviceList.size() - 1; j > i; --j) {
                        if (j > serviceFormByDeviceList.size() - 1 || !serviceFormByDeviceList.get(i).getServiceName().equals(serviceFormByDeviceList.get(j).getServiceName())) continue;
                        ImportUtil.recordErrorMessg(zoneNameTarget + "/" + deviceIpString + "/" + serviceFormByDeviceList.get(j).getServiceName(), 572062L, frontOperationList);
                        tempServiceFormList.add(serviceFormByDeviceList.get(j));
                        serviceFormByDeviceList.remove(serviceFormByDeviceList.get(j));
                    }
                }
            }
            serviceFormList.removeAll(tempServiceFormList);
        }
    }

    private static Map<String, List<ZoneServiceForm>> getZoneDeviceServiceMap(List<ZoneServiceForm> serviceFormList) {
        HashMap<String, List<ZoneServiceForm>> zoneDevIdServiceMap = new HashMap<String, List<ZoneServiceForm>>();
        ArrayList<ZoneServiceForm> zServiceList = null;
        for (ZoneServiceForm serviceForm : serviceFormList) {
            zServiceList = (ArrayList<ZoneServiceForm>)zoneDevIdServiceMap.get(serviceForm.getDeviceIp());
            if (null == zServiceList) {
                zServiceList = new ArrayList<ZoneServiceForm>();
            }
            zServiceList.add(serviceForm);
            zoneDevIdServiceMap.put(serviceForm.getDeviceIp(), zServiceList);
        }
        return zoneDevIdServiceMap;
    }

    public static boolean validateAbnormalConAndCyle(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportUtil.validatePolicyItem(ImportConstant.TCP_POLICY_MAP.get("illegalConnCount"), String.valueOf(tcpDefendPolicyForm.getIllegalConnCount()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error abnormal-session-check-threshold is : " + tcpDefendPolicyForm.getIllegalConnCount()));
            ImportUtil.recordErrorMessg(zoneString + zoneName + "/" + policyString + serviceForm.getServiceName(), 731074L, frontOperationList);
            return false;
        }
        if (!ImportUtil.validatePolicyItem(ImportConstant.TCP_POLICY_MAP.get("illegalConnCountInterval"), String.valueOf(tcpDefendPolicyForm.getIllegalConnCountInterval()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error abnormal-session-check-check-cycle is : " + tcpDefendPolicyForm.getIllegalConnCountInterval()));
            ImportUtil.recordErrorMessg(zoneString + zoneName + "/" + policyString + serviceForm.getServiceName(), 731075L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean validateDestinationConNumAndRate(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportUtil.validatePolicyItem(ImportConstant.TCP_POLICY_MAP.get("tcpDesttipNum"), String.valueOf(tcpDefendPolicyForm.getTcpDesttipNum()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error concurrent-connection-check-by-destination-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpDesttipNum()));
            ImportUtil.recordErrorMessg(zoneString + zoneName + "/" + policyString + serviceForm.getServiceName(), 731070L, frontOperationList);
            return false;
        }
        if (!ImportUtil.validatePolicyItem(ImportConstant.TCP_POLICY_MAP.get("tcpNewDestipRate"), String.valueOf(tcpDefendPolicyForm.getTcpNewDestipRate()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error new-connection-rate-check-by-destination-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpNewDestipRate()));
            ImportUtil.recordErrorMessg(zoneString + zoneName + "/" + policyString + serviceForm.getServiceName() + "/" + tcpDefendPolicyForm.getTcpNewDestipRate(), 731071L, frontOperationList);
            return false;
        }
        return true;
    }

    private static ParaBean hasParasDiff(String id, ZoneServiceForm zoneService) {
        if (null == zoneService || null == zoneService.getDeviceId()) {
            return new ParaBean();
        }
        Long moId = zoneService.getDeviceId();
        DevCapUtil devCapUtil = DevCapUtil.getInstance();
        devCapUtil.initContext(zoneService.getDeviceId(), zoneService.getProtocol());
        ParaBean paraBean = devCapUtil.hasParasDiff(id, moId, zoneService.getProtocol());
        if (null == paraBean) {
            paraBean = new ParaBean();
        }
        return paraBean;
    }

    private static boolean validateParaBean(ParaBean paraBean, String nowValue) {
        Long nowValueNum = null;
        if (null == paraBean || !ImportUtil.isNumber(nowValue)) {
            return false;
        }
        nowValueNum = Long.parseLong(nowValue);
        return nowValueNum <= (long)paraBean.getMaxVal() && nowValueNum >= (long)paraBean.getMinVal();
    }

    public static boolean validatePolicyItem(String key, String nowValue, ZoneServiceForm serviceForm) {
        ParaBean paraBean = ImportUtil.hasParasDiff(key, serviceForm);
        boolean result = true;
        result = ImportUtil.validateParaBean(paraBean, nowValue);
        return result;
    }

    public static boolean isNumber(String str) {
        String regex = "^[0-9]*$";
        return !AticUtil.isNull((String)str) && str.matches(regex);
    }

    public static boolean isTrue(Boolean booleanStr) {
        return null != booleanStr && booleanStr != false;
    }

    public static boolean isCheckPolicyItemTcp(boolean protocolDefaultFlag, String protocol) {
        return protocolDefaultFlag || "TCP".equals(protocol) || "HTTP".equals(protocol) || "HTTPS".equals(protocol);
    }

    public static List<String> ipLocationNameList(List<ZoneIpLocationForm> zoneIpLocationFormList) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (null != zoneIpLocationFormList && !zoneIpLocationFormList.isEmpty()) {
            for (ZoneIpLocationForm ipForm : zoneIpLocationFormList) {
                nameList.add(ipForm.getLocationNameEn().toLowerCase(Locale.getDefault()));
            }
        }
        return nameList;
    }

    private static boolean checkWhiteListIpIsExistWhiteListIp(List<GloWhiteListIpInfo> wIpList, GloWhiteListIpForm whiteListIpForm, List<BatchOperation> frontOperationList, String whiteLiString) {
        logger.info((Object)"In the checkWhiteListIpIsExistWhiteListIp");
        ArrayList<GloWhiteListForm> subList = null;
        GloWhiteListForm gloWhiteListForm = null;
        long startTime = System.currentTimeMillis();
        if (whiteListIpForm.getMaskType() == 0) {
            String[] subNetRange = IPUtil.getSubnetRange((String)whiteListIpForm.getWhitelistIp(), (int)whiteListIpForm.getIntMask());
            if (null != wIpList && !wIpList.isEmpty()) {
                for (GloWhiteListIpInfo gloListIpInfo : wIpList) {
                    String[] destNetRange;
                    if (gloListIpInfo.getMaskType() != 0 || !IPUtil4Atic.isCrossIpRange((String[])(destNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getWhitelistIp(), (int)gloListIpInfo.getIntMask())), (String[])subNetRange)) continue;
                    logger.error((Object)("To add the list already exists in the white list.The blackListIp = " + whiteListIpForm.getWhitelistIp() + "/" + whiteListIpForm.getIntMask()));
                    ImportUtil.recordErrorMessg(whiteLiString + whiteListIpForm.getWhitelistIp() + "/" + whiteListIpForm.getIntMask(), 572030L, frontOperationList);
                    return false;
                }
            }
            subList = new ArrayList<GloWhiteListForm>();
            gloWhiteListForm = new GloWhiteListForm();
            gloWhiteListForm.setWhitelistIp(subNetRange[0]);
            gloWhiteListForm.setStartIp(subNetRange[0]);
            gloWhiteListForm.setEndIp(subNetRange[1]);
            gloWhiteListForm.setMask(whiteListIpForm.getIntMask());
            gloWhiteListForm.setDeployState("UNDEPLOY");
            gloWhiteListForm.setDeviceId(String.valueOf(whiteListIpForm.getDeviceId()));
            subList.add(gloWhiteListForm);
            whiteListIpForm.setGloWhiteListForms(subList);
        } else if (whiteListIpForm.getMaskType() == 1) {
            try {
                Object[] networkSegment = IPUtil.getNetworkSegment((String)whiteListIpForm.getStartIp(), (String)whiteListIpForm.getEndIp());
                if (null != wIpList && !wIpList.isEmpty()) {
                    for (GloWhiteListIpInfo gloListIpInfo : wIpList) {
                        Object[] subNetRange;
                        if (gloListIpInfo.getMaskType() != 1 || !IPUtil4Atic.isCrossIpRange((String[])(subNetRange = IPUtil.getNetworkSegment((String)gloListIpInfo.getStartIp(), (String)gloListIpInfo.getEndIp())), (String[])networkSegment) && !Arrays.equals(subNetRange, networkSegment)) continue;
                        logger.error((Object)("To add the list already exists in the white list.The blackListIp = " + whiteListIpForm.getStartIp() + "-" + whiteListIpForm.getEndIp()));
                        ImportUtil.recordErrorMessg(whiteLiString + whiteListIpForm.getStartIp() + "-" + whiteListIpForm.getEndIp(), 572030L, frontOperationList);
                        return false;
                    }
                }
                subList = new ArrayList();
                for (int i = 0; i < networkSegment.length; ++i) {
                    gloWhiteListForm = new GloWhiteListForm();
                    String ipAndMask = networkSegment[i];
                    String[] ipMask = ipAndMask.split("/");
                    gloWhiteListForm.setWhitelistIp(ipMask[0]);
                    gloWhiteListForm.setMask(Integer.valueOf(ipMask[1]));
                    gloWhiteListForm.setDeployState("UNDEPLOY");
                    gloWhiteListForm.setDeviceId(String.valueOf(whiteListIpForm.getDeviceId()));
                    subList.add(gloWhiteListForm);
                }
                whiteListIpForm.setGloWhiteListForms(subList);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        logger.info((Object)("checkWhiteListIpIsExistWhiteListIp take times to " + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        return true;
    }

    private static boolean checkWhiteListIpIsExistBlackIpList(List<GloBlackListIpInfo> bIpList, GloWhiteListIpForm whiteListIpForm, List<BatchOperation> frontOperationList, String whiteLiString) {
        ArrayList<GloWhiteListForm> subList = null;
        GloWhiteListForm gloWhiteListForm = null;
        long startTime = System.currentTimeMillis();
        if (whiteListIpForm.getMaskType() == 0) {
            String[] subNetRange = IPUtil.getSubnetRange((String)whiteListIpForm.getWhitelistIp(), (int)whiteListIpForm.getIntMask());
            if (null != bIpList && !bIpList.isEmpty()) {
                for (GloBlackListIpInfo gloListIpInfo : bIpList) {
                    String[] destNetRange;
                    if (gloListIpInfo.getMaskType() != 0 || !IPUtil4Atic.isCrossIpRange((String[])(destNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getBlacklistIp(), (int)gloListIpInfo.getIntMask())), (String[])subNetRange)) continue;
                    logger.error((Object)("To add the list already exists in the white list.The blackListIp = " + whiteListIpForm.getWhitelistIp() + "/" + whiteListIpForm.getIntMask()));
                    ImportUtil.recordErrorMessg(whiteLiString + whiteListIpForm.getWhitelistIp() + "/" + whiteListIpForm.getIntMask(), 572030L, frontOperationList);
                    return false;
                }
            }
            subList = new ArrayList<GloWhiteListForm>();
            gloWhiteListForm = new GloWhiteListForm();
            gloWhiteListForm.setWhitelistIp(subNetRange[0]);
            gloWhiteListForm.setStartIp(subNetRange[0]);
            gloWhiteListForm.setEndIp(subNetRange[1]);
            gloWhiteListForm.setMask(whiteListIpForm.getIntMask());
            gloWhiteListForm.setDeployState("UNDEPLOY");
            gloWhiteListForm.setDeviceId(String.valueOf(whiteListIpForm.getDeviceId()));
            subList.add(gloWhiteListForm);
            whiteListIpForm.setGloWhiteListForms(subList);
        } else if (whiteListIpForm.getMaskType() == 1) {
            try {
                Object[] networkSegment = IPUtil.getNetworkSegment((String)whiteListIpForm.getStartIp(), (String)whiteListIpForm.getEndIp());
                if (null != bIpList && !bIpList.isEmpty()) {
                    for (GloBlackListIpInfo gloListIpInfo : bIpList) {
                        Object[] subNetRange;
                        if (gloListIpInfo.getMaskType() != 1 || !IPUtil4Atic.isCrossIpRange((String[])(subNetRange = IPUtil.getNetworkSegment((String)gloListIpInfo.getStartIp(), (String)gloListIpInfo.getEndIp())), (String[])networkSegment) && !Arrays.equals(subNetRange, networkSegment)) continue;
                        logger.error((Object)("To add the list already exists in the white list.The blackListIp = " + whiteListIpForm.getStartIp() + "-" + whiteListIpForm.getEndIp()));
                        ImportUtil.recordErrorMessg(whiteLiString + whiteListIpForm.getStartIp() + "-" + whiteListIpForm.getEndIp(), 572030L, frontOperationList);
                        return false;
                    }
                }
                subList = new ArrayList();
                for (int i = 0; i < networkSegment.length; ++i) {
                    gloWhiteListForm = new GloWhiteListForm();
                    String ipAndMask = networkSegment[i];
                    String[] ipMask = ipAndMask.split("/");
                    gloWhiteListForm.setWhitelistIp(ipMask[0]);
                    gloWhiteListForm.setMask(Integer.valueOf(ipMask[1]));
                    gloWhiteListForm.setDeployState("UNDEPLOY");
                    gloWhiteListForm.setDeviceId(String.valueOf(whiteListIpForm.getDeviceId()));
                    subList.add(gloWhiteListForm);
                }
                whiteListIpForm.setGloWhiteListForms(subList);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        logger.info((Object)("checkWhiteListIpIsExistBlackIpList take times to " + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        return true;
    }

    private static boolean checkBlackListIpIsExistBlackListIp(List<GloBlackListIpInfo> bIpList, GloBlackListIpForm blackListIpForm, List<BatchOperation> frontOperationList, String blackLiString) {
        ArrayList<GloBlackListForm> zifList = new ArrayList<GloBlackListForm>();
        GloBlackListForm gloBlackListForm = new GloBlackListForm();
        long startTime = System.currentTimeMillis();
        if (blackListIpForm.getMaskType() == 0) {
            Object[] srcIpRange = IPUtil.getSubnetRange((String)blackListIpForm.getBlacklistIp(), (int)blackListIpForm.getIntMask());
            Object[] subNetRange = null;
            if (null != bIpList && !bIpList.isEmpty()) {
                for (GloBlackListIpInfo gloListIpInfo : bIpList) {
                    if (gloListIpInfo.getMaskType() != 0) continue;
                    subNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getBlacklistIp(), (int)gloListIpInfo.getIntMask());
                    Arrays.sort(srcIpRange);
                    Arrays.sort(subNetRange);
                    if (!IPUtil4Atic.isCrossIpRange((String[])subNetRange, (String[])srcIpRange) && !Arrays.equals(srcIpRange, subNetRange)) continue;
                    logger.error((Object)("To add the list already exists in the white list.The blackListIp = " + blackListIpForm.getBlacklistIp() + "/" + blackListIpForm.getIntMask()));
                    ImportUtil.recordErrorMessg(blackLiString + blackListIpForm.getBlacklistIp() + "/" + blackListIpForm.getIntMask(), 732041L, frontOperationList);
                    return false;
                }
            }
            zifList = new ArrayList();
            gloBlackListForm.setBlacklistIp(srcIpRange[0]);
            gloBlackListForm.setStartIp(srcIpRange[0]);
            gloBlackListForm.setEndIp(srcIpRange[1]);
            gloBlackListForm.setMask(blackListIpForm.getIntMask());
            gloBlackListForm.setDeviceId(String.valueOf(blackListIpForm.getDeviceId()));
            gloBlackListForm.setDeployState("UNDEPLOY");
            zifList.add(gloBlackListForm);
            blackListIpForm.setGloBlackListForms(zifList);
            return true;
        }
        if (blackListIpForm.getMaskType() == 1) {
            try {
                Object[] networkSegment = IPUtil.getNetworkSegment((String)blackListIpForm.getStartIp(), (String)blackListIpForm.getEndIp());
                if (null != bIpList && !bIpList.isEmpty()) {
                    for (GloBlackListIpInfo gloListIpInfo : bIpList) {
                        if (gloListIpInfo.getMaskType() != 1) continue;
                        Object[] subNetRange = IPUtil.getNetworkSegment((String)gloListIpInfo.getStartIp(), (String)gloListIpInfo.getEndIp());
                        Arrays.sort(networkSegment);
                        Arrays.sort(subNetRange);
                        if (!IPUtil4Atic.isCrossIpRange((String[])subNetRange, (String[])networkSegment) && !Arrays.equals(networkSegment, subNetRange)) continue;
                        logger.error((Object)("To add the list already exists in the white list.The balckLIstIp = " + blackListIpForm.getStartIp() + "-" + blackListIpForm.getEndIp()));
                        ImportUtil.recordErrorMessg(blackLiString + blackListIpForm.getStartIp() + "-" + blackListIpForm.getEndIp(), 732041L, frontOperationList);
                        return false;
                    }
                }
                for (int i = 0; i < networkSegment.length; ++i) {
                    String ipAndMask = networkSegment[i];
                    String[] ipMask = ipAndMask.split("/");
                    gloBlackListForm.setBlacklistIp(ipMask[0]);
                    gloBlackListForm.setMask(Integer.valueOf(ipMask[1]));
                    gloBlackListForm.setDeviceId(String.valueOf(blackListIpForm.getDeviceId()));
                    gloBlackListForm.setDeployState("UNDEPLOY");
                    zifList.add(gloBlackListForm);
                }
                blackListIpForm.setGloBlackListForms(zifList);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        logger.info((Object)("checkBlackListIpIsExistBlackListIp take times to " + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        return true;
    }

    private static boolean checkBlackListIpIsExistWhiteListIp(List<GloWhiteListIpInfo> wIpList, GloBlackListIpForm blackListIpForm, List<BatchOperation> frontOperationList, String blackLiString) {
        ArrayList<GloBlackListForm> zifList = new ArrayList<GloBlackListForm>();
        GloBlackListForm gloBlackListForm = null;
        long startTime = System.currentTimeMillis();
        if (blackListIpForm.getMaskType() == 0) {
            Object[] srcIpRange = IPUtil.getSubnetRange((String)blackListIpForm.getBlacklistIp(), (int)blackListIpForm.getIntMask());
            Object[] subNetRange = null;
            if (null != wIpList && !wIpList.isEmpty()) {
                for (GloWhiteListIpInfo gloListIpInfo : wIpList) {
                    if (gloListIpInfo.getMaskType() != 0) continue;
                    subNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getWhitelistIp(), (int)gloListIpInfo.getIntMask());
                    Arrays.sort(srcIpRange);
                    Arrays.sort(subNetRange);
                    if (!IPUtil4Atic.isCrossIpRange((String[])subNetRange, (String[])srcIpRange) && !Arrays.equals(srcIpRange, subNetRange)) continue;
                    logger.error((Object)("To add the list already exists in the white list.The blackListIp = " + blackListIpForm.getBlacklistIp() + "/" + blackListIpForm.getIntMask()));
                    ImportUtil.recordErrorMessg(blackLiString + blackListIpForm.getBlacklistIp() + "/" + blackListIpForm.getIntMask(), 732042L, frontOperationList);
                    return false;
                }
            }
            zifList = new ArrayList();
            gloBlackListForm = new GloBlackListForm();
            gloBlackListForm.setBlacklistIp(srcIpRange[0]);
            gloBlackListForm.setStartIp(srcIpRange[0]);
            gloBlackListForm.setEndIp(srcIpRange[1]);
            gloBlackListForm.setMask(blackListIpForm.getIntMask());
            gloBlackListForm.setDeviceId(String.valueOf(blackListIpForm.getDeviceId()));
            gloBlackListForm.setDeployState("UNDEPLOY");
            zifList.add(gloBlackListForm);
            blackListIpForm.setGloBlackListForms(zifList);
            return true;
        }
        if (blackListIpForm.getMaskType() == 1) {
            try {
                Object[] networkSegment = IPUtil.getNetworkSegment((String)blackListIpForm.getStartIp(), (String)blackListIpForm.getEndIp());
                if (null != wIpList && !wIpList.isEmpty()) {
                    for (GloWhiteListIpInfo gloListIpInfo : wIpList) {
                        if (gloListIpInfo.getMaskType() != 1) continue;
                        Object[] subNetRange = IPUtil.getNetworkSegment((String)gloListIpInfo.getStartIp(), (String)gloListIpInfo.getEndIp());
                        Arrays.sort(networkSegment);
                        Arrays.sort(subNetRange);
                        if (!IPUtil4Atic.isCrossIpRange((String[])subNetRange, (String[])networkSegment) && !Arrays.equals(networkSegment, subNetRange)) continue;
                        logger.error((Object)("To add the list already exists in the white list.The balckLIstIp = " + blackListIpForm.getStartIp() + "-" + blackListIpForm.getEndIp()));
                        ImportUtil.recordErrorMessg(blackLiString + blackListIpForm.getStartIp() + "-" + blackListIpForm.getEndIp(), 732042L, frontOperationList);
                        return false;
                    }
                }
                for (int i = 0; i < networkSegment.length; ++i) {
                    gloBlackListForm = new GloBlackListForm();
                    String ipAndMask = networkSegment[i];
                    String[] ipMask = ipAndMask.split("/");
                    gloBlackListForm.setBlacklistIp(ipMask[0]);
                    gloBlackListForm.setMask(Integer.valueOf(ipMask[1]));
                    gloBlackListForm.setDeviceId(String.valueOf(blackListIpForm.getDeviceId()));
                    gloBlackListForm.setDeployState("UNDEPLOY");
                    zifList.add(gloBlackListForm);
                }
                blackListIpForm.setGloBlackListForms(zifList);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        logger.info((Object)("checkBlackListIpIsExistWhiteListIp take times to " + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        return true;
    }

    public static Long validateContentLengthIs3(String[] fingerContentOne) {
        if (fingerContentOne.length != 3) {
            return null;
        }
        String offset = fingerContentOne[0];
        String contentLength = fingerContentOne[1];
        String depth = fingerContentOne[2];
        String tag = FilterUtil.validateContent((String)contentLength);
        if ("670717".equals(tag)) {
            return 670717L;
        }
        if ("670725".equals(tag)) {
            return 670725L;
        }
        if ("670724".equals(tag)) {
            return 670724L;
        }
        if (!(FilterUtil.isPacketLengthRange((String)offset) && FilterUtil.isPacketLengthRange((String)depth) || FilterUtil.isFingerprintPacketLengthRange((String)offset) && FilterUtil.isPacketLengthRange((String)depth))) {
            return 670717L;
        }
        return null;
    }

    public static Long validateContentLengthIs2(String[] fingerContentOne) {
        if (fingerContentOne.length != 2) {
            return null;
        }
        String offset = fingerContentOne[0];
        String contentLength = fingerContentOne[1];
        String tag = FilterUtil.validateContent((String)contentLength);
        if ("670717".equals(tag)) {
            return 670717L;
        }
        if ("670725".equals(tag)) {
            return 670725L;
        }
        if ("670724".equals(tag)) {
            return 670724L;
        }
        if (!FilterUtil.isPacketLengthRange((String)offset) && !FilterUtil.isFingerprintPacketLengthRange((String)offset)) {
            return 670717L;
        }
        return null;
    }

    public static boolean checkCallAndDomain(String filterKey, String filterContent) {
        if ("caller".equals(filterKey) || "callee".equals(filterKey) || "domain".equals(filterKey)) {
            String[] httpContent = filterContent.split("    ");
            if (httpContent.length != 2) {
                return false;
            }
            if (!("include".equals(httpContent[0]) || "equal".equals(httpContent[0]) && FilterUtil.isAnyCharacter((String)httpContent[1]))) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkHostAndSoOn(String filterKey, String filterContent) {
        if ("cookie".equals(filterKey) || "host".equals(filterKey) || "referer".equals(filterKey) || "uri".equals(filterKey) || "user-agent".equals(filterKey)) {
            String[] httpContent = filterContent.split("    ");
            if (httpContent.length != 2) {
                return false;
            }
            if (!"include".equals(httpContent[0]) || !FilterUtil.isAnyCharacter((String)httpContent[1])) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkPortFormat(String[] portLength) {
        if (portLength.length == 1 && !FilterUtil.isPortRange((String)portLength[0])) {
            return false;
        }
        return portLength.length != 2 || FilterUtil.isPortRange((String)portLength[0]) && FilterUtil.isPortRange((String)portLength[1]);
    }

    public static Long checkPacketLen(String[] packetLength) {
        int length = packetLength.length;
        if (length == 2) {
            if (!FilterUtil.isPacketLengthRange((String)packetLength[0]) || !FilterUtil.isPacketLengthRange((String)packetLength[1])) {
                return 670715L;
            }
            if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                return 670719L;
            }
        } else {
            return 670717L;
        }
        return null;
    }

    private static String[] getIpRange(String content) {
        String[] ipRange = new String[]{};
        if (AticUtil.isNull((String)content)) {
            return ipRange;
        }
        String[] contentExist = content.split("/");
        if (contentExist.length == 2) {
            ipRange = IPUtil.getSubnetRange((String)contentExist[0], (int)Integer.parseInt(contentExist[1]));
        } else if (contentExist.length == 1) {
            ipRange = contentExist;
        }
        return ipRange;
    }

    public static boolean checkFilterIpConflict(HttpFilterForm httpFilterForm, List<HttpFilterForm> httpFilterFormList, String validateIp) {
        String content = "";
        int tag = 1;
        for (HttpFilterForm filterForm : httpFilterFormList) {
            String[] ipRange;
            if (filterForm.getFilterContent().equals(httpFilterForm.getFilterContent()) && tag == 1) {
                ++tag;
                continue;
            }
            if ("source-ip".equals(filterForm.getFilterKey()) || "destination-ip".equals(filterForm.getFilterKey())) {
                content = filterForm.getFilterContent();
            }
            if ((ipRange = ImportUtil.getIpRange(content)).length == 0) continue;
            if (ipRange.length == 2 && IPUtil.isInIpRange((String[])ipRange, (String)validateIp)) {
                return false;
            }
            if (ipRange.length != 1 || !validateIp.equals(ipRange[0])) continue;
            return false;
        }
        return true;
    }

    public static String checkFilterContentIp(String filterContent) {
        String[] currContent = filterContent.split("/");
        if (currContent.length != 2) {
            return "ipAddrError";
        }
        Map<String, Boolean> ipResultMap = ImportUtil.getIpResultMap();
        if (!ImportUtil.validateIpMask(currContent, ipResultMap, true)) {
            if (ipResultMap.get("isZero").booleanValue() || ipResultMap.get("ipAddrError").booleanValue()) {
                return "ipAddrError";
            }
            if (ipResultMap.get("maskError").booleanValue()) {
                return "maskError";
            }
        }
        return null;
    }

    public static boolean checkFilterAction(FilterForm filterForm) {
        if (filterForm.getFilterAction() < 1 || filterForm.getFilterAction() > 7) {
            return false;
        }
        return filterForm.getFilterAction() != 6 || "http".equals(filterForm.getFilterType());
    }

    private static boolean validateIpRange(String[] ipAddress, Map<String, Boolean> ipResultMap) {
        if (ipAddress.length != 2) {
            ipResultMap.put("rangeError", true);
            return false;
        }
        if (AticUtil.isNull((String)ipAddress[0]) || AticUtil.isNull((String)ipAddress[1])) {
            ipResultMap.put("rangeError", true);
            return false;
        }
        if ("0.0.0.0".equals(ipAddress[0]) || "0.0.0.0".equals(ipAddress[1])) {
            ipResultMap.put("isZero", true);
            return false;
        }
        if (!IPUtil4Atic.checkStartEndIpArray((String[])ipAddress)) {
            ipResultMap.put("rangeError", true);
            return false;
        }
        return true;
    }

    public static boolean validateIpMask(String[] ipAddress, Map<String, Boolean> ipResultMap, boolean isNotValidateBlackAndWhiteIp) {
        if (null == ipAddress || !ImportUtil.preIpAddrError(ipAddress)) {
            ipResultMap.put("ipAddrError", true);
            logger.info((Object)("ipAddress is error.The ipAddress : " + (null == ipAddress ? "" : ipAddress)));
            return false;
        }
        if (isNotValidateBlackAndWhiteIp && "0.0.0.0".equals(ipAddress[0])) {
            ipResultMap.put("isZero", true);
            logger.info((Object)"The ipAddr is 0.0.0");
            return false;
        }
        if (!ImportUtil.checkMask(ipAddress[0], ipAddress[1])) {
            ipResultMap.put("maskError", true);
            logger.info((Object)("The mask is error.The mask is " + ipAddress[1] + ". The ip is " + ipAddress[0]));
            return false;
        }
        return true;
    }

    private static boolean preIpAddrError(String[] ipAddress) {
        if (ipAddress.length != 2) {
            return false;
        }
        if (AticUtil.isNull((String)ipAddress[0]) || AticUtil.isNull((String)ipAddress[1])) {
            return false;
        }
        return ImportUtil.checkIpAddr(ipAddress[0]);
    }

    private static boolean checkIpAddr(String ipAddr) {
        return IPUtil.isIpv4((String)ipAddr) || IPUtil.isIpv6((String)ipAddr);
    }

    private static boolean checkMask(String ipAddr, String mask) {
        if (IPUtil.isIpv4((String)ipAddr) && !ImportUtil.isIpv4Mask(mask)) {
            return false;
        }
        return !IPUtil.isIpv6((String)ipAddr) || ImportUtil.isIpv6Mask(mask);
    }

    public static boolean validateIpAddr(String ipAddrs, Map<String, Boolean> ipResultMap, boolean isNotValidateBlackAndWhiteIp) {
        if (AticUtil.isNull((String)ipAddrs)) {
            ipResultMap.put("ipAddrError", true);
            return false;
        }
        String ipSplitRange = "-";
        String ipSplitMask = "/";
        if (ipAddrs.contains(ipSplitRange)) {
            String[] ipAddress = ipAddrs.split(ipSplitRange);
            return ImportUtil.validateIpRange(ipAddress, ipResultMap);
        }
        if (ipAddrs.contains(ipSplitMask)) {
            String[] ipAddress = ipAddrs.split(ipSplitMask);
            return ImportUtil.validateIpMask(ipAddress, ipResultMap, isNotValidateBlackAndWhiteIp);
        }
        ipResultMap.put("ipAddrError", true);
        return false;
    }

    private static boolean isIpv4Mask(String mask) {
        String regex = "^1[0-9]|2[0-9]|3[0-2]|[1-9]$";
        return !AticUtil.isNull((String)mask) && mask.matches(regex);
    }

    private static boolean isIpv6Mask(String mask) {
        String regex = "^1[0-2][0-8]|[1-9][0-9]|[1-9]$";
        return !AticUtil.isNull((String)mask) && mask.matches(regex);
    }

    public static boolean findExistIpByBlackList(String ipAddr, String deviceId, String targetName, long errorCode, List<BatchOperation> frontOperationList) {
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        List<GloBlackListForm> forms = gloBlackListService.findExistIp(ipAddr, deviceId);
        if (null != forms && !forms.isEmpty()) {
            logger.info((Object)("import findExistIpByBlackList failed, input wrong :" + ipAddr));
            ImportUtil.recordErrorMessg(targetName, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean findExistIpByWhiteList(String ipAddr, String deviceId, String targetName, long errorCode, List<BatchOperation> frontOperationList) {
        logger.info((Object)("import findExistIpByWhiteList failed, input wrong :" + ipAddr));
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        List<GloWhiteListForm> wforms = gloWhiteListService.findExistIp(ipAddr, deviceId);
        if (null != wforms && !wforms.isEmpty()) {
            ImportUtil.recordErrorMessg(targetName, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    public static void deleteBlackList(boolean isV5R1C00Version, List<BatchOperation> boBlackList) {
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        if (isV5R1C00Version) {
            gloBlackListService.batchDelGloBlackList(boBlackList);
        } else {
            gloBlackListService.batchDelGloBlackList2(boBlackList);
        }
    }

    public static void deleteWhiteList(boolean isV5R1C00Version, List<BatchOperation> boWhiteList) {
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        if (isV5R1C00Version) {
            gloWhiteListService.batchDelGloWhiteList(boWhiteList);
        } else {
            gloWhiteListService.batchDelGloWhiteList2(boWhiteList);
        }
    }

    public static void deletedomainWhiteList(String deviceid) {
        IGloDomainWhiteListService gervice = (IGloDomainWhiteListService)ServiceContext.getInstance().getService("gloDomainWhiteListService", IGloDomainWhiteListService.class);
        gervice.delAllGloWhiteList(deviceid);
    }

    public static boolean checkIsTaskCancled(ImportData importData) {
        boolean isTaskCancled = false;
        ProgressState pState = ProgressManage.getInstance().getProgressState(importData.getProgressBarId());
        if (null != pState && pState.getIsStop().booleanValue()) {
            isTaskCancled = true;
            Locker.getInstance().setImportFlag(false);
        }
        logger.info((Object)("Progress bar state is " + isTaskCancled + ". The time is" + new Date(System.currentTimeMillis()) + ", The  importData.getProgressBarId() is " + importData.getProgressBarId()));
        return isTaskCancled;
    }

    public static void updateFilterForm(FilterForm dbForm, FilterForm filterForm) {
        IHttpFilterService httpFilterService = (IHttpFilterService)ServiceContext.getInstance().getService("httpFilterService", IHttpFilterService.class);
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        dbForm.setFilterAction(filterForm.getFilterAction());
        dbForm.setFilterAlert(filterForm.getFilterAlert());
        dbForm.setHttpFilterFormList(filterForm.getHttpFilterFormList());
        dbForm.setDeviceIdList(filterForm.getDeviceIdList());
        dbForm.setDirection(1);
        filterForm.setFilterId(dbForm.getFilterId());
        httpFilterService.queryAndDeleteByFilterId(dbForm.getPkid());
        filterService.update((Object)dbForm);
    }

    public static Map<String, FilterForm> getFilterFormMap() {
        HashMap<String, FilterForm> filterFormMap = new HashMap<String, FilterForm>();
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        List filterFormDbList = filterService.findAll();
        if (null != filterFormDbList && !filterFormDbList.isEmpty()) {
            for (FilterForm filterForm : filterFormDbList) {
                filterFormMap.put(filterForm.getFilterName(), filterForm);
            }
        }
        return filterFormMap;
    }

    public static LocationCustomForm prepareLocationCusForm(LocationCustomForm locationForm, List<LocationIpForm> ipList, ImportData importData, List<BatchOperation> frontOperationList) {
        ILocationCustomService locationCustomService = (ILocationCustomService)ServiceContext.getInstance().getService("locationCustomService", ILocationCustomService.class);
        boolean isExist = locationCustomService.isExists(locationForm.getLocationName());
        if (isExist) {
            LocationCustomForm cusForm = locationCustomService.findByName(locationForm.getLocationName());
            cusForm.setLocationIpList(ipList);
            cusForm.setDescription(locationForm.getDescription());
            if (!"undeployed".equals(cusForm.getDeployStatus())) {
                cusForm.setDeployStatus("part_suc");
            }
            return cusForm;
        }
        locationForm.setDeployStatus("undeployed");
        return locationForm;
    }

    public static void prepareLocationIpList(List<LocationIpForm> ipLoactionList, ImportData importData, List<BatchOperation> frontOperationList) {
        if (null != ipLoactionList && !ipLoactionList.isEmpty()) {
            int maskInteger = 0;
            String startIp = "";
            String endIp = "";
            for (LocationIpForm ipForm : ipLoactionList) {
                if (!ImportUtil.checkLocationIp(ipForm, importData, frontOperationList)) continue;
                String ipString = ipForm.getIpString();
                if (ipString.contains("-")) {
                    startIp = IPUtil4Atic.convert2CompleteIp((String)ipString.split("-")[0]);
                    endIp = IPUtil4Atic.convert2CompleteIp((String)ipString.split("-")[1]);
                }
                if (ipString.contains("/")) {
                    String ipSplitMask = "/";
                    String ipAddress = ipString.split(ipSplitMask)[0];
                    String maskInput = ipString.split(ipSplitMask)[1];
                    if (AticUtil.isNum((String)maskInput).booleanValue()) {
                        maskInteger = Integer.parseInt(maskInput);
                    }
                    String maskStr = AticUtil.getMask((Integer)maskInteger);
                    startIp = IPUtil4Atic.convert2CompleteIp((String)AticUtil.getMaskStartIp((String)ipAddress, (String)maskStr));
                    endIp = IPUtil4Atic.convert2CompleteIp((String)AticUtil.getMaskEndIp((String)ipAddress, (String)maskStr));
                }
                ipForm.setStartIp(startIp);
                ipForm.setEndIp(endIp);
            }
        }
    }

    private static boolean checkLocationIp(LocationIpForm ipForm, ImportData importData, List<BatchOperation> frontOperationList) {
        String ipString = ipForm.getIpString();
        if (!ipString.contains("-") && !ipString.contains("/")) {
            logger.info((Object)("saveLoctionIpForm error,ipString=" + ipString + ". Wrong IP address."));
            ImportUtil.recordErrorMessg(importData.getIplocationString() + ipString, 572010L, frontOperationList);
            return false;
        }
        if (ipString.contains("/")) {
            String ipSplitMask = "/";
            String ipAddress = ipString.split(ipSplitMask)[0];
            String maskInput = ipString.split(ipSplitMask)[1];
            int maskInteger = 0;
            if (AticUtil.isNum((String)maskInput).booleanValue()) {
                maskInteger = Integer.parseInt(maskInput);
            }
            if (IPUtil.isIpv4((String)ipAddress)) {
                if (maskInteger > 32 || maskInteger < 1) {
                    logger.info((Object)("saveLoctionIpForm error,ipString=" + ipString + ". Mask over range,mask=" + maskInteger));
                    ImportUtil.recordErrorMessg(importData.getIplocationString() + ipString, 572009L, frontOperationList);
                    return false;
                }
            } else {
                logger.info((Object)("saveLoctionIpForm error,ipString=" + ipString + ". Wrong IP address."));
                ImportUtil.recordErrorMessg(importData.getIplocationString() + ipString, 572010L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    public static boolean checkLocationIpList(LocationCustomForm locationForm, ImportData importData, List<BatchOperation> frontOperationList) {
        if (null != locationForm.getLocationIpList() && !locationForm.getLocationIpList().isEmpty()) {
            if (locationForm.getLocationIpList().size() > 50) {
                logger.info((Object)(" Custom IP location information can not be more than 50\uff0cipLocation.size= " + locationForm.getLocationIpList().size()));
                ImportUtil.recordErrorMessg(locationForm.getLocationName(), 572007L, frontOperationList);
                return false;
            }
        } else {
            logger.info((Object)("saveLoctionCustom error,locationCustom'name=" + locationForm.getLocationName() + ". Custom IP location can not be empty."));
            ImportUtil.recordErrorMessg(locationForm.getLocationName(), 572011L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkLocationIpValid(LocationCustomForm locationForm, List<BatchOperation> frontOperationList, String iplocationString) {
        List ipList = locationForm.getLocationIpList();
        Map<String, Boolean> ipResultMap = ImportUtil.getIpResultMap();
        for (LocationIpForm ipLocation : ipList) {
            if (ImportUtil.validateIpAddr(ipLocation.getIpString().trim(), ipResultMap, true)) continue;
            if (ipResultMap.get("isZero").booleanValue()) {
                logger.error((Object)("import iplocation  failed.The IP is zero.IP =" + ipLocation.getIpString().trim()));
                ImportUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + "/" + ipLocation.getIpString(), 571986L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("rangeError").booleanValue()) {
                logger.error((Object)("The ip range error.The ipRange=" + ipLocation.getIpString().trim()));
                ImportUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + "/" + ipLocation.getIpString(), 572021L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("ipAddrError").booleanValue()) {
                logger.error((Object)("import iplocation  failed, ip format wrong.IP= " + ipLocation.getIpString().trim()));
                ImportUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + "/" + ipLocation.getIpString(), 571986L, frontOperationList);
                return false;
            }
            if (!ipResultMap.get("maskError").booleanValue()) continue;
            logger.error((Object)("IP mask error.The ip=" + ipLocation.getIpString().trim()));
            ImportUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + "/" + ipLocation.getIpString(), 571987L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean checkIpLocationNameAndIpAddr(LocationCustomForm locationForm, ImportData importData, List<BatchOperation> frontOperationList) {
        if (!ImportUtil.checkIpLocationName(locationForm)) {
            logger.info((Object)"import iplocation  failed, the error  is : name is null");
            ImportUtil.recordErrorMessg(importData.getIplocationString() + locationForm.getLocationName(), 572037L, frontOperationList);
            return false;
        }
        return ImportUtil.checkLocationIpValid(locationForm, frontOperationList, importData.getIplocationString());
    }

    private static boolean checkIpLocationName(LocationCustomForm locationForm) {
        return locationForm.getLocationName().matches("^[a-zA-Z]\\w{0,62}$");
    }

    public static boolean checkIpLocationNum(ImportForm zonePolicyForm, ImportData importData) {
        ILocationCustomService locationCustomService = (ILocationCustomService)ServiceContext.getInstance().getService("locationCustomService", ILocationCustomService.class);
        ILocationIpService locationIpService = (ILocationIpService)ServiceContext.getInstance().getService("locationIpService", ILocationIpService.class);
        int allIpNum = locationIpService.getAllLocationIp().size();
        int tempNum = 0;
        int xmlIpListSize = 0;
        for (LocationCustomForm customForm : zonePolicyForm.getLocationFormList()) {
            if (locationCustomService.isExists(customForm.getLocationName())) {
                List locationIpFormList = locationIpService.getLocationIpByLocId(locationCustomService.findByName(customForm.getLocationName()).getPkId());
                tempNum += locationIpFormList.size();
            }
            xmlIpListSize += customForm.getLocationIpList().size();
        }
        logger.info((Object)("Custom IP location of the total number of IP can not exceed 500.size=" + (allIpNum - tempNum + xmlIpListSize)));
        return allIpNum - tempNum + xmlIpListSize <= 500;
    }

    public static void setBlackListDeployState(FWDefenceAbnormalForm abnormalForm) {
        if (!"UNDEPLOY".equals(abnormalForm.getBlistDeployState())) {
            abnormalForm.setBlistDeployState("PART_DEPLOY");
        } else {
            abnormalForm.setBlistDeployState("UNDEPLOY");
        }
    }

    public static void setProxyIpListDeployState(FWDefenceAbnormalForm abnormalForm) {
        if (!"UNDEPLOY".equals(abnormalForm.getProxyIpDeployState())) {
            abnormalForm.setProxyIpDeployState("PART_DEPLOY");
        } else {
            abnormalForm.setProxyIpDeployState("UNDEPLOY");
        }
    }

    public static void setDomainWhiteListDeployState(FWDefenceAbnormalForm abnormalForm) {
        if (!"UNDEPLOY".equals(abnormalForm.getDomainDeployState())) {
            abnormalForm.setDomainDeployState("PART_DEPLOY");
        } else {
            abnormalForm.setDomainDeployState("UNDEPLOY");
        }
    }

    public static void setWhiteListDeployState(FWDefenceAbnormalForm abnormalForm) {
        if (!"UNDEPLOY".equals(abnormalForm.getBypassDeployState())) {
            abnormalForm.setBypassDeployState("PART_DEPLOY");
        } else {
            abnormalForm.setBypassDeployState("UNDEPLOY");
        }
    }

    private static boolean validateIpBlackListIpAndWhiteListIp(String ipAddrs, String targetName, List<BatchOperation> frontOperationList, Map<String, Boolean> ipResultMap) {
        if (!ImportUtil.validateIpAddr(ipAddrs, ipResultMap, false)) {
            if (ipResultMap.get("isZero").booleanValue()) {
                logger.error((Object)("The IP is zero.IP =" + AticUtil.getcleanedMessage((String)ipAddrs)));
                ImportUtil.recordErrorMessg(targetName + ipAddrs, 571986L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("rangeError").booleanValue()) {
                logger.error((Object)("The ip range error.The ipRange=" + AticUtil.getcleanedMessage((String)ipAddrs)));
                ImportUtil.recordErrorMessg(targetName + ipAddrs, 572021L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("ipAddrError").booleanValue()) {
                logger.error((Object)("Iip format wrong.IP= " + AticUtil.getcleanedMessage((String)ipAddrs)));
                ImportUtil.recordErrorMessg(targetName + ipAddrs, 571986L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("maskError").booleanValue()) {
                logger.error((Object)("IP mask error. The mak =  " + AticUtil.getcleanedMessage((String)ipAddrs)));
                ImportUtil.recordErrorMessg(targetName + ipAddrs, 571987L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    public static boolean isOkWhiteListIpForm(ImportData importData, List<BatchOperation> frontOperationList, AticDevice aDevice, GloWhiteListIpForm whiteListIpForm) {
        List<GloBlackListIpInfo> bIpList;
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        if (IPUtil.isIpv4((String)whiteListIpForm.getWhitelistIp()) && IPUtil.isIpv6((String)whiteListIpForm.getWhitelistIp())) {
            ImportUtil.recordErrorMessg(importData.getWhiteLiString() + whiteListIpForm.getWhitelistIp(), 572010L, frontOperationList);
            return false;
        }
        if (null == whiteListIpForm.getMaskType() || whiteListIpForm.getMaskType() != 0 && whiteListIpForm.getMaskType() != 1) {
            logger.info((Object)("IP address creation way out of range.maskType=" + whiteListIpForm.getMaskType()));
            ImportUtil.recordErrorMessg(importData.getWhiteLiString() + whiteListIpForm.getMaskType(), 572027L, frontOperationList);
            return false;
        }
        String ipAddr = ImportUtil.getIpAddrWhiteList(whiteListIpForm);
        if (!ImportUtil.validateIpBlackListIpAndWhiteListIp(ipAddr, importData.getWhiteLiString(), frontOperationList, ImportUtil.getIpResultMap())) {
            return false;
        }
        if (whiteListIpForm.getMaskType() == 0) {
            ImportUtil.fillGloWhiteListIpForm(whiteListIpForm, null, null);
        }
        if (!ImportUtil.checkWhiteListIpIsExistBlackIpList(bIpList = gloBlackListService.queryAllBlacklist(aDevice.getMoId()), whiteListIpForm, frontOperationList, importData.getWhiteLiString())) {
            return false;
        }
        List<GloWhiteListIpInfo> wIpList = gloWhiteListService.queryAllWhitelist(aDevice.getMoId());
        return ImportUtil.checkWhiteListIpIsExistWhiteListIp(wIpList, whiteListIpForm, frontOperationList, importData.getWhiteLiString());
    }

    public static boolean isOkProxyIpForm(ImportData importData, List<BatchOperation> frontOperationList, AticDevice aDevice, GloCdnIpListForm proxyIpForm) {
        if (!AticUtil.isNull((String)proxyIpForm.getIpAddress()) && !IPUtil.isIpv4((String)proxyIpForm.getIpAddress())) {
            ImportUtil.recordErrorMessg(importData.getProxyIpString() + proxyIpForm.getIpAddress(), 570811L, frontOperationList);
            return false;
        }
        if (null == proxyIpForm.getMaskType() || proxyIpForm.getMaskType() != 0 && proxyIpForm.getMaskType() != 1) {
            logger.info((Object)("IP address creation way out of range.maskType=" + proxyIpForm.getMaskType()));
            ImportUtil.recordErrorMessg(importData.getProxyIpString() + proxyIpForm.getMaskType(), 570812L, frontOperationList);
            return false;
        }
        String ipAddr = ImportUtil.getProxyIpAddr(proxyIpForm);
        if (!ImportUtil.validateIpBlackListIpAndWhiteListIp(ipAddr, importData.getProxyIpString(), frontOperationList, ImportUtil.getIpResultMap())) {
            return false;
        }
        if (proxyIpForm.getMaskType() == 0) {
            ImportUtil.fillGloWhiteListIpForm(null, null, proxyIpForm);
        }
        return true;
    }

    private static String getProxyIpAddr(GloCdnIpListForm proxyIpForm) {
        String ipAddr = proxyIpForm.getStartIp() + "-" + proxyIpForm.getEndIp();
        if (proxyIpForm.getMaskType() == 0) {
            ipAddr = proxyIpForm.getIpAddress() + "/" + proxyIpForm.getMask();
        }
        return ipAddr;
    }

    private static String getIpAddrWhiteList(GloWhiteListIpForm whiteListIpForm) {
        String ipAddr = whiteListIpForm.getStartIp() + "-" + whiteListIpForm.getEndIp();
        if (whiteListIpForm.getMaskType() == 0) {
            ipAddr = whiteListIpForm.getWhitelistIp() + "/" + whiteListIpForm.getIntMask();
        }
        return ipAddr;
    }

    private static void fillGloWhiteListIpForm(GloWhiteListIpForm whiteListIpForm, GloBlackListIpForm blackListIpForm, GloCdnIpListForm proxyIpForm) {
        String endIp;
        String startIp;
        int mask;
        if (null != whiteListIpForm) {
            if (whiteListIpForm.getMaskType() == 0) {
                mask = whiteListIpForm.getIntMask();
                startIp = AticUtil.getMaskStartIp((String)whiteListIpForm.getWhitelistIp(), (String)AticUtil.getMask((Integer)mask));
                endIp = AticUtil.getMaskEndIp((String)whiteListIpForm.getWhitelistIp(), (String)AticUtil.getMask((Integer)mask));
                whiteListIpForm.setStartIp(startIp);
                whiteListIpForm.setEndIp(endIp);
            } else {
                whiteListIpForm.setMaskType(1);
            }
        }
        if (null != blackListIpForm) {
            if (blackListIpForm.getMaskType() == 0) {
                mask = blackListIpForm.getIntMask();
                startIp = AticUtil.getMaskStartIp((String)blackListIpForm.getBlacklistIp(), (String)AticUtil.getMask((Integer)mask));
                endIp = AticUtil.getMaskEndIp((String)blackListIpForm.getBlacklistIp(), (String)AticUtil.getMask((Integer)mask));
                blackListIpForm.setStartIp(startIp);
                blackListIpForm.setEndIp(endIp);
            } else {
                blackListIpForm.setMaskType(1);
            }
        }
        if (null != proxyIpForm) {
            if (proxyIpForm.getMaskType() == 0) {
                mask = proxyIpForm.getMask();
                startIp = null;
                endIp = null;
                startIp = AticUtil.getMaskStartIp((String)proxyIpForm.getIpAddress(), (String)AticUtil.getMask((Integer)mask));
                endIp = AticUtil.getMaskEndIp((String)proxyIpForm.getIpAddress(), (String)AticUtil.getMask((Integer)mask));
                proxyIpForm.setStartIp(startIp);
                proxyIpForm.setEndIp(endIp);
            } else {
                proxyIpForm.setMaskType(1);
            }
        }
    }

    public static boolean isOkBlackListIpForm(GloBlackListIpForm blackListIpForm, ImportData importData, List<BatchOperation> frontOperationList, AticDevice aDevice) {
        List<GloWhiteListIpInfo> wIpList;
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        if (IPUtil.isIpv4((String)blackListIpForm.getBlacklistIp()) && IPUtil.isIpv6((String)blackListIpForm.getBlacklistIp())) {
            logger.info((Object)("import isOkBlackListIpForm failed, formart wrong :" + blackListIpForm.getBlacklistIp()));
            ImportUtil.recordErrorMessg(importData.getBlackLiString() + blackListIpForm.getBlacklistIp(), 572010L, frontOperationList);
        }
        if (null == blackListIpForm.getMaskType() || blackListIpForm.getMaskType() != 0 && blackListIpForm.getMaskType() != 1) {
            logger.info((Object)("IP address creation way out of range.maskType=" + blackListIpForm.getMaskType()));
            ImportUtil.recordErrorMessg(importData.getBlackLiString() + blackListIpForm.getMaskType(), 572027L, frontOperationList);
            return false;
        }
        String ipAddrs = ImportUtil.getIpAddrBlackList(blackListIpForm);
        if (!ImportUtil.validateIpBlackListIpAndWhiteListIp(ipAddrs, importData.getBlackLiString(), frontOperationList, ImportUtil.getIpResultMap())) {
            return false;
        }
        if (blackListIpForm.getMaskType() == 0) {
            ImportUtil.fillGloWhiteListIpForm(null, blackListIpForm, null);
        }
        if (!ImportUtil.checkBlackListIpIsExistWhiteListIp(wIpList = gloWhiteListService.queryAllWhitelist(aDevice.getMoId()), blackListIpForm, frontOperationList, importData.getBlackLiString())) {
            return false;
        }
        List<GloBlackListIpInfo> bIpList = gloBlackListService.queryAllBlacklist(aDevice.getMoId());
        return ImportUtil.checkBlackListIpIsExistBlackListIp(bIpList, blackListIpForm, frontOperationList, importData.getBlackLiString());
    }

    private static String getIpAddrBlackList(GloBlackListIpForm blackListIpForm) {
        String ipAddr = blackListIpForm.getStartIp() + "-" + blackListIpForm.getEndIp();
        if (blackListIpForm.getMaskType() == 0) {
            ipAddr = blackListIpForm.getBlacklistIp() + "/" + blackListIpForm.getIntMask();
        }
        return ipAddr;
    }

    public static void recordErrorMessg(String targetName, long errorCode, List<BatchOperation> frontOperationList) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        frontOperationList.add(batchOperation);
    }

    public static boolean isNullBlackListIp(GloBlackListIpForm blackListIpForm) {
        return AticUtil.isNull((String)blackListIpForm.getBlacklistIp()) && null == blackListIpForm.getMaskType() && null == blackListIpForm.getIntMask() && AticUtil.isNull((String)blackListIpForm.getStartIp()) && AticUtil.isNull((String)blackListIpForm.getEndIp());
    }

    public static boolean isNullProxyIp(GloCdnIpListForm proxyIpForm) {
        return AticUtil.isNull((String)proxyIpForm.getIpAddress()) && null == proxyIpForm.getMaskType() && null == proxyIpForm.getMask() && AticUtil.isNull((String)proxyIpForm.getStartIp()) && AticUtil.isNull((String)proxyIpForm.getEndIp());
    }

    public static boolean isNullWhiteListIp(GloWhiteListIpForm whiteListIpForm) {
        return AticUtil.isNull((String)whiteListIpForm.getWhitelistIp()) && null == whiteListIpForm.getMaskType() && null == whiteListIpForm.getIntMask() && AticUtil.isNull((String)whiteListIpForm.getStartIp()) && AticUtil.isNull((String)whiteListIpForm.getEndIp());
    }

    public static Map<String, Boolean> getIpResultMap() {
        HashMap<String, Boolean> ipResultMap = new HashMap<String, Boolean>();
        ipResultMap.put("ipAddrError", false);
        ipResultMap.put("rangeError", false);
        ipResultMap.put("maskError", false);
        ipResultMap.put("isZero", false);
        return ipResultMap;
    }

    public static List<BatchOperation> prepareDeleWhite(AticDevice aDevice, boolean isV5R1C00Version) {
        List<BatchOperation> batchOpList = null;
        batchOpList = isV5R1C00Version ? ImportUtil.prepareDeleWhiteByC00(aDevice) : ImportUtil.prepareDeleWhiteByNotC00(aDevice);
        return batchOpList;
    }

    private static List<BatchOperation> prepareDeleWhiteByC00(AticDevice aDevice) {
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        List<GloWhiteListInfo> whiteListInfoList = gloWhiteListService.queryByDeviceId(aDevice.getMoId());
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        if (null != whiteListInfoList && !whiteListInfoList.isEmpty()) {
            for (GloWhiteListInfo whiteListInfo : whiteListInfoList) {
                if (String.valueOf(1).equals(whiteListInfo.getDeleteFlag())) continue;
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(whiteListInfo.getWid().longValue());
                bo.setOptDetail(whiteListInfo.getWhitelistIp());
                boList.add(bo);
            }
        }
        return boList;
    }

    private static List<BatchOperation> prepareDeleWhiteByNotC00(AticDevice aDevice) {
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        List<GloWhiteListIpInfo> whiteListIpInfoList = gloWhiteListService.queryAllWhitelist(aDevice.getMoId());
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (null != whiteListIpInfoList && !whiteListIpInfoList.isEmpty()) {
            ArrayList<Long> pkidList = new ArrayList<Long>();
            for (GloWhiteListIpInfo whiteListIpInfo : whiteListIpInfoList) {
                if (1 == whiteListIpInfo.getDeleteFlag()) continue;
                pkidList.add(whiteListIpInfo.getPkid());
            }
            for (Long pkId : pkidList) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(pkId.longValue());
                batchOpList.add(bo);
            }
        }
        return batchOpList;
    }

    public static List<BatchOperation> prepareDeleBlackList(AticDevice aDevice, boolean onlySupportIp) {
        List<BatchOperation> batchOpList = null;
        batchOpList = onlySupportIp ? ImportUtil.prepareDeleBlackListByC00(aDevice) : ImportUtil.prepareDeleBlackListByNotC00(aDevice);
        return batchOpList;
    }

    private static List<BatchOperation> prepareDeleBlackListByC00(AticDevice aDevice) {
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        List<GloBlackListInfo> blackListInfoList = gloBlackListService.queryByDeviceId(aDevice.getMoId());
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        if (null != blackListInfoList && !blackListInfoList.isEmpty()) {
            for (GloBlackListInfo blackListInfo : blackListInfoList) {
                if (String.valueOf(1).endsWith(blackListInfo.getDeleteFlag())) continue;
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(blackListInfo.getPkid().longValue());
                bo.setOptDetail(blackListInfo.getBlacklistIp());
                boList.add(bo);
            }
        }
        return boList;
    }

    private static List<BatchOperation> prepareDeleBlackListByNotC00(AticDevice aDevice) {
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        List<GloBlackListIpInfo> blackListIpInfoList = gloBlackListService.queryAllBlacklist(aDevice.getMoId());
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (null != blackListIpInfoList && !blackListIpInfoList.isEmpty()) {
            ArrayList<Long> pkidList = new ArrayList<Long>();
            for (GloBlackListIpInfo bListIpInfo : blackListIpInfoList) {
                if (1 == bListIpInfo.getDeleteFlag()) continue;
                pkidList.add(bListIpInfo.getPkid());
            }
            for (Long pkId : pkidList) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(pkId.longValue());
                batchOpList.add(bo);
            }
        }
        return batchOpList;
    }

    public static FWDefenceAbnormalForm prepareAbnormal(ImportForm zonePolicyForm, AticDevice aDevice) {
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        FWDefenceAbnormalForm abnormalForm = null;
        if (null != iFWDefenceAbnormalService) {
            abnormalForm = iFWDefenceAbnormalService.queryByDeviceId(aDevice.getMoId());
        }
        if (null != abnormalForm) {
            abnormalForm.setDeviceName(aDevice.getName());
            abnormalForm.setParams(zonePolicyForm.getAbnormalForm().getParams());
            abnormalForm.setPcapMode(zonePolicyForm.getAbnormalForm().getPcapMode());
            abnormalForm.setPcapLength(zonePolicyForm.getAbnormalForm().getPcapLength());
            if (zonePolicyForm.getAbnormalForm().getBlackholeMode() != null && (zonePolicyForm.getAbnormalForm().getBlackholeMode() == 0 || zonePolicyForm.getAbnormalForm().getBlackholeMode() == 1)) {
                abnormalForm.setBlackholeMode(zonePolicyForm.getAbnormalForm().getBlackholeMode());
            }
            abnormalForm.setIpRepuationEnable(zonePolicyForm.getAbnormalForm().getIpRepuationEnable());
            abnormalForm.setGrayThreshold(zonePolicyForm.getAbnormalForm().getGrayThreshold());
            abnormalForm.setBlackThreshold(zonePolicyForm.getAbnormalForm().getBlackThreshold());
            abnormalForm.setStatisticsFeedback(zonePolicyForm.getAbnormalForm().getStatisticsFeedback());
            abnormalForm.setSampleRate(zonePolicyForm.getAbnormalForm().getSampleRate());
            abnormalForm.setDeviceId(aDevice.getMoId());
            if (!"UNDEPLOY".equals(abnormalForm.getDeployState())) {
                abnormalForm.setDeployState("PART_DEPLOY");
            } else {
                abnormalForm.setDeployState("UNDEPLOY");
            }
            abnormalForm.setParams(zonePolicyForm.getAbnormalForm().getParams());
            return abnormalForm;
        }
        return zonePolicyForm.getAbnormalForm();
    }

    public static int calTotalSetp(ImportForm zonePolicyForm) {
        int totalStep = 0;
        if (zonePolicyForm.isNeedPolicy() && null != zonePolicyForm.getZoneFormList() && !zonePolicyForm.getZoneFormList().isEmpty()) {
            totalStep += zonePolicyForm.getZoneFormList().size() + 1;
        }
        if (zonePolicyForm.isNeedLocation() && null != zonePolicyForm.getLocationFormList() && !zonePolicyForm.getLocationFormList().isEmpty()) {
            totalStep += zonePolicyForm.getLocationFormList().size();
        }
        if (zonePolicyForm.isNeedFilter() && null != zonePolicyForm.getFilterFormList() && !zonePolicyForm.getFilterFormList().isEmpty()) {
            totalStep += zonePolicyForm.getFilterFormList().size();
        }
        if (null != zonePolicyForm.getAbnormalForm()) {
            ++totalStep;
        }
        if (null != zonePolicyForm.getProxyIpFormList() && !zonePolicyForm.getProxyIpFormList().isEmpty()) {
            List<GloCdnIpListForm> proxyIpList = zonePolicyForm.getProxyIpFormList();
            totalStep += ImportUtil.calProxyIpTotalSetp(proxyIpList);
            zonePolicyForm.setProxyIpFormList(proxyIpList);
        }
        if (null != zonePolicyForm.getWhiteListIpFormList() && !zonePolicyForm.getWhiteListIpFormList().isEmpty()) {
            List<GloWhiteListIpForm> whiteList = zonePolicyForm.getWhiteListIpFormList();
            totalStep += ImportUtil.calWhiteListTotalSetp(whiteList);
            zonePolicyForm.setWhiteListIpFormList(whiteList);
        }
        if (null != zonePolicyForm.getBlackListIpFormList() && !zonePolicyForm.getBlackListIpFormList().isEmpty()) {
            List<GloBlackListIpForm> blackList = zonePolicyForm.getBlackListIpFormList();
            totalStep += ImportUtil.calBlackListTotalSetp(blackList);
            zonePolicyForm.setBlackListIpFormList(blackList);
        }
        logger.info((Object)("importZone totalStep:=" + totalStep));
        return totalStep;
    }

    private static int calProxyIpTotalSetp(List<GloCdnIpListForm> proxyIpList) {
        int totalStep = 0;
        ArrayList<GloCdnIpListForm> tempWhiteList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListForm wForm : proxyIpList) {
            if (!ImportUtil.checkProxyIpForm(wForm)) continue;
            tempWhiteList.add(wForm);
        }
        proxyIpList.removeAll(tempWhiteList);
        if (!proxyIpList.isEmpty()) {
            totalStep += proxyIpList.size();
        }
        return totalStep;
    }

    private static boolean checkProxyIpForm(GloCdnIpListForm wForm) {
        return AticUtil.isNull((String)wForm.getIpAddress()) && null == wForm.getMaskType() && null == wForm.getMask() && null == wForm.getStartIp() && null == wForm.getEndIp();
    }

    private static int calWhiteListTotalSetp(List<GloWhiteListIpForm> whiteList) {
        int totalStep = 0;
        ArrayList<GloWhiteListIpForm> tempWhiteList = new ArrayList<GloWhiteListIpForm>();
        for (GloWhiteListIpForm wForm : whiteList) {
            if (!ImportUtil.checkWhiteIpForm(wForm)) continue;
            tempWhiteList.add(wForm);
        }
        whiteList.removeAll(tempWhiteList);
        if (!whiteList.isEmpty()) {
            totalStep += whiteList.size();
        }
        return totalStep;
    }

    private static boolean checkWhiteIpForm(GloWhiteListIpForm wForm) {
        return AticUtil.isNull((String)wForm.getWhitelistIp()) && null == wForm.getMaskType() && null == wForm.getIntMask() && null == wForm.getStartIp() && null == wForm.getEndIp();
    }

    private static int calBlackListTotalSetp(List<GloBlackListIpForm> blackList) {
        int totalStep = 0;
        ArrayList<GloBlackListIpForm> tempBlackList = new ArrayList<GloBlackListIpForm>();
        for (GloBlackListIpForm bForm : blackList) {
            if (!ImportUtil.checkBlackListIpForm(bForm)) continue;
            tempBlackList.add(bForm);
        }
        blackList.removeAll(tempBlackList);
        if (!blackList.isEmpty()) {
            totalStep += blackList.size();
        }
        return totalStep;
    }

    private static boolean checkBlackListIpForm(GloBlackListIpForm bForm) {
        return AticUtil.isNull((String)bForm.getBlacklistIp()) && bForm.getMaskType() == null && bForm.getIntMask() == null && bForm.getStartIp() == null && bForm.getEndIp() == null;
    }
}

