/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.neglobal.model.GloBlackListInfo;
import com.hs.vsm.secservice.neglobal.model.GloBlackListIpInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GloBlackListDAO
extends CommonDaoImpl {
    private int ipMaxSizeOneQuery = 1000;

    public void remove(long id) {
        String hql = "update GloBlackListInfo set deleteFlag='1' where pkid = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public GloBlackListInfo get(Long id) {
        if (id == null) {
            return null;
        }
        String hql = "from GloBlackListInfo where pkid = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List blackList = this.findByHql(hql, param);
        if (blackList == null || blackList.isEmpty()) {
            return null;
        }
        return (GloBlackListInfo)blackList.get(0);
    }

    public List<GloBlackListInfo> getByIp(String blacklistIp, String deviceId) {
        if (AticUtil.isNull((String)blacklistIp)) {
            return new ArrayList<GloBlackListInfo>();
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        String hql = "from GloBlackListInfo where deviceId = ?0  and blacklistIp = ?1 and deleteFlag= '0' ";
        params.put(0, deviceId);
        params.put(1, blacklistIp);
        this.logger.info((Object)("query blacklist data,deviceId:" + deviceId + ",blacklistIp:" + blacklistIp));
        List result = this.findByHql(hql, params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloBlackListInfo>();
        }
        return result;
    }

    public List<GloBlackListInfo> getByIds(String id) {
        if (AticUtil.isNull((String)id)) {
            return new ArrayList<GloBlackListInfo>();
        }
        String[] idStrings = id.split(",");
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> pararms = new HashMap<Integer, String>();
        hql.append("from GloBlackListInfo where pkid in ( ");
        for (int i = 0; i < idStrings.length; ++i) {
            pararms.put(i, idStrings[i]);
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(')');
        List result = this.findByHql(hql.toString(), pararms);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloBlackListInfo>();
        }
        return result;
    }

    public void save(List<GloBlackListInfo> glListInfos) {
        for (GloBlackListInfo gloBlackListInfo : glListInfos) {
            gloBlackListInfo.setBlacklistIp(IPUtil4Atic.convert2CompleteIp((String)gloBlackListInfo.getBlacklistIp()));
            this.saveOrUpdate(gloBlackListInfo);
        }
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String blacklistIp;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from GloBlackListInfo where (1=1) and deleteFlag='0'";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String deviceId = conditionMap.get("deviceId");
        if (deviceId == null) {
            return null;
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        if (null != deviceId && !"".equals(deviceId)) {
            hql = hql + " and deviceId = ?" + index;
            queryMap.put(index++, deviceId);
        }
        if (!AticUtil.isNull((String)(blacklistIp = conditionMap.get("blacklistIp")))) {
            hql = hql + " and blacklistIp = ?" + index;
            queryMap.put(index, blacklistIp.trim());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            if (sortName.equalsIgnoreCase("blacklistIp")) {
                sortName = "blacklistIp";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public List<GloBlackListInfo> getByIpAndId(String blacklistIp, Long id) {
        if (AticUtil.isNull((String)blacklistIp)) {
            return new ArrayList<GloBlackListInfo>();
        }
        String hql = "from GloBlackListInfo where pkid<>?0 and blacklistIp in( ?1 )";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        param.put(1, blacklistIp);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloBlackListInfo>();
        }
        return result;
    }

    public List<GloBlackListInfo> queryByDeviceId(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListInfo where deviceId = ?0 order by id asc";
        this.logger.info((Object)("query need deploy blacklist ip,deviceId :" + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloBlackListInfo> queryByDelDeviceId(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListInfo where deviceId = ?0 and deleteFlag ='1' ";
        this.logger.info((Object)("query need delete deleteflag = 1 blacklist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloBlackListInfo> queryByDelDeviceIdAndDelFlag(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListInfo where deviceId = ?0 and deleteFlag ='0' ";
        this.logger.info((Object)("query need delete deleteflag = 0 blacklist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloBlackListIpInfo> findByDelDeviceIdAndDelFlag(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListIpInfo where deviceId = ?0 and deleteFlag ='0' ";
        this.logger.info((Object)("query need delete deleteflag = 0 blacklist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void updateFlag(long id) {
        String hql = "update GloBlackListInfo set deleteFlag = '1' where pkid = ?0  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void updateNewFlag(long id) {
        String hql = "update GloBlackListInfo set deleteFlag = '1' where id = ?0  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void updateFlagByDeviceId(String deviceid) {
        String hql = "update GloBlackListInfo set deleteFlag = '1' where deviceId = ?0 and deployState = 'SUCCESS' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void updateIpListFlag(long id) {
        String hql = "update GloBlackListIpInfo set deleteFlag = '1' where pkid = ?0  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteFlagData(long id) {
        String hql = "delete from GloBlackListInfo where pkid = ?0 and deleteFlag = '1' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteNewFlagData(long id) {
        String hql = "delete from GloBlackListInfo where id = ?0 and deleteFlag = '1' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public List<GloBlackListInfo> getByIps(String blacklistIps, String deviceId) {
        ArrayList<GloBlackListInfo> result = new ArrayList<GloBlackListInfo>();
        if (AticUtil.isNull((String)blacklistIps)) {
            return result;
        }
        String[] blacklistIp = blacklistIps.split(",");
        StringBuffer ipSet = new StringBuffer();
        int queryIndex = this.ipMaxSizeOneQuery - 1;
        for (int i = 0; i < blacklistIp.length; ++i) {
            if (0 == i) {
                ipSet.append(blacklistIp[i]);
            } else {
                ipSet.append("," + blacklistIp[i]);
            }
            if (i != blacklistIp.length - 1 && i != queryIndex) continue;
            StringBuffer hql = new StringBuffer("from GloBlackListInfo where blacklistIp in (");
            Map<Integer, String> params = this.conHqlByParam(hql, ipSet.toString(), deviceId);
            int index = ipSet.toString().split(",").length;
            hql.append(") and deleteFlag <> 1 and deviceId = ?" + index);
            result.addAll(this.findByHql(hql.toString(), params));
            ipSet = new StringBuffer();
            queryIndex += this.ipMaxSizeOneQuery;
        }
        return result;
    }

    private Map<Integer, String> conHqlByParam(StringBuffer hql, String ips, String deviceId) {
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String[] ipList = ips.split(",");
        for (int i = 0; i < ipList.length; ++i) {
            if (0 == i) {
                hql.append("?" + i);
            } else {
                hql.append(",?" + i);
            }
            queryMap.put(i, ipList[i]);
        }
        queryMap.put(ipList.length, deviceId);
        return queryMap;
    }

    public List<GloBlackListInfo> queryAllBlacklists(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListInfo where deviceId = ?0 and deleteFlag ='0' order by pkid asc";
        this.logger.info((Object)("query need deploy blacklist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public int queryAllBlackCount(String deviceId) {
        if (deviceId == null) {
            return 0;
        }
        String hql = "select count(*) as rowCount from GloBlackListInfo where deviceId = ?0 and deleteFlag ='0'";
        this.logger.info((Object)("query need deploy blacklist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        Long count = this.getTotalCount(hql, param);
        return count.intValue();
    }

    public Paging queryByPageNew(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String blacklistIp;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        HashMap<Integer, String> queryMap2 = new HashMap<Integer, String>();
        String hql = "from GloBlackListIpInfo where (1=1) and deleteFlag='0'";
        String hql2 = "select id from GloBlackListInfo where (1=1) and deleteFlag = '0'";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        int index1 = 0;
        String deviceId = conditionMap.get("deviceId");
        if (deviceId == null) {
            return null;
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        if (null != deviceId && !"".equals(deviceId)) {
            hql = hql + " and deviceId = ?" + index;
            hql2 = hql2 + " and deviceId = ?" + index1;
            queryMap.put(index++, deviceId);
            queryMap2.put(index1++, deviceId);
        }
        if (!AticUtil.isNull((String)(blacklistIp = conditionMap.get("blacklistIp")))) {
            String newBlackIp = IPUtil4Atic.convert2CompleteIp((String)blacklistIp);
            hql2 = hql2 + " and startIp <=  ?" + index1;
            queryMap2.put(index1++, newBlackIp);
            hql2 = hql2 + " and  endIp >= ?" + index1;
            queryMap2.put(index1++, newBlackIp);
            List ids = this.findByHql(hql2, queryMap2);
            Long newId = -1L;
            if (null != ids && !ids.isEmpty()) {
                newId = (Long)ids.get(0);
            }
            hql = hql + " and pkid = ?" + index;
            queryMap.put(index, newId.toString());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            if (sortName.equalsIgnoreCase("blacklistIp")) {
                sortName = "blacklistIp";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public void clearIpListData(Long id) {
        String hql = "delete from GloBlackListIpInfo where pkid =  ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void clearAllIpListData(String deviceid) {
        String hql = "delete from GloBlackListIpInfo where deviceId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void clearAllListData(String deviceid) {
        String hql = "delete from GloBlackListInfo where deviceId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void clearIpsubListData(Long id) {
        String hql = "delete from GloBlackListInfo where id= ?0 and deployState != 'SUCCESS'";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void clearAllIpsubListData(String deviceid) {
        String hql = "delete from GloBlackListInfo where deviceId= ?0 and deployState != 'SUCCESS'";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public List<GloBlackListInfo> findUndeploy(Long id) {
        String hql = " from GloBlackListInfo where id = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloBlackListIpInfo> getByIpLists(String id) {
        if (null == id) {
            return new ArrayList<GloBlackListIpInfo>();
        }
        String[] ids = id.split(",");
        StringBuffer hql = new StringBuffer();
        hql.append("from GloBlackListIpInfo where pkid in (");
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        for (int i = 0; i < ids.length; ++i) {
            params.put(i, ids[i]);
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(")");
        List result = this.findByHql(hql.toString(), params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloBlackListIpInfo>();
        }
        return result;
    }

    public List<GloBlackListIpInfo> queryAllIpList(Long deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListIpInfo where deviceId = ?0 and deleteFlag = ?1 order by pkid asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, "0");
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public GloBlackListIpInfo getIpList(Long id) {
        if (id == null) {
            return null;
        }
        String hql = "from GloBlackListIpInfo where pkid = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List blackList = this.findByHql(hql, param);
        if (blackList == null || blackList.isEmpty()) {
            return null;
        }
        return (GloBlackListIpInfo)blackList.get(0);
    }

    public List<GloBlackListIpForm> queryAllIp(Long deviceId) {
        ArrayList<GloBlackListIpForm> gloListIpFormList = new ArrayList<GloBlackListIpForm>();
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloBlackListIpInfo where deviceId = ?0 order by startIp asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        for (GloBlackListIpInfo gIpInfo : result) {
            GloBlackListIpForm gloIpForm = new GloBlackListIpForm();
            gloIpForm.setMaskType(gIpInfo.getMaskType());
            gloIpForm.setBlacklistIp(gIpInfo.getBlacklistIp());
            gloIpForm.setIntMask(gIpInfo.getIntMask());
            gloIpForm.setStartIp(gIpInfo.getStartIp());
            gloIpForm.setEndIp(gIpInfo.getEndIp());
            gloListIpFormList.add(gloIpForm);
        }
        return gloListIpFormList;
    }
}

