/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListIpInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GloWhiteListDAO
extends CommonDaoImpl {
    private int ipMaxSizeOneQuery = 1000;

    public void remove(long id) {
        String hql = "delete from GloWhiteListInfo where wid = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public GloWhiteListInfo get(Long id) {
        if (id == null) {
            return null;
        }
        String hql = "from GloWhiteListInfo where wid = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List blackList = this.findByHql(hql, param);
        if (blackList == null || blackList.isEmpty()) {
            return null;
        }
        return (GloWhiteListInfo)blackList.get(0);
    }

    public List<GloWhiteListInfo> getByIp(String whitelistIp, String deviceId) {
        if (AticUtil.isNull((String)whitelistIp)) {
            return new ArrayList<GloWhiteListInfo>();
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String hql = "from GloWhiteListInfo where deviceId = ?0 and whitelistIp = ?1 and deleteFlag = '0' ";
        param.put(0, deviceId);
        param.put(1, whitelistIp);
        this.logger.info((Object)("query whitelist ip and deviceId = " + deviceId + ",whitelistIp = " + whitelistIp));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloWhiteListInfo>();
        }
        return result;
    }

    public List<GloWhiteListInfo> getByIds(String id) {
        if (AticUtil.isNull((String)id)) {
            return new ArrayList<GloWhiteListInfo>();
        }
        String[] ids = id.split(",");
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        hql.append("from GloWhiteListInfo where wid in (");
        for (int i = 0; i < ids.length; ++i) {
            param.put(i, ids[i]);
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(")");
        List result = this.findByHql(hql.toString(), param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloWhiteListInfo>();
        }
        return result;
    }

    public void save(List<GloWhiteListInfo> glListInfos) {
        for (GloWhiteListInfo gloBlackListInfo : glListInfos) {
            gloBlackListInfo.setWhitelistIp(IPUtil4Atic.convert2CompleteIp((String)gloBlackListInfo.getWhitelistIp()));
            this.saveOrUpdate(gloBlackListInfo);
        }
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String whitelistIp;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from GloWhiteListInfo where (1=1) and deleteFlag = '0' ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String deviceId = conditionMap.get("deviceId");
        if (null != deviceId && !"".equals(deviceId)) {
            hql = hql + " and deviceId = ?" + index;
            queryMap.put(index++, deviceId);
        }
        if (!AticUtil.isNull((String)(whitelistIp = conditionMap.get("whitelistIp")))) {
            hql = hql + " and whitelistIp = ?" + index;
            queryMap.put(index, whitelistIp.trim());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            if (sortName.equalsIgnoreCase("whitelistIp")) {
                sortName = "whitelistIp";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public List<GloWhiteListInfo> getByIpAndId(String whitelistIp, Long id) {
        if (AticUtil.isNull((String)whitelistIp)) {
            return new ArrayList<GloWhiteListInfo>();
        }
        String hql = "from GloWhiteListInfo where id<>?0 and whitelistIp in( ?1 )";
        String idString = id == null ? "-1" : id.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, idString);
        param.put(1, whitelistIp);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloWhiteListInfo>();
        }
        return result;
    }

    public List<GloWhiteListInfo> queryByDeviceId(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListInfo where deviceId = ?0 order by wid asc ";
        this.logger.info((Object)("query need deploy whitelist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloWhiteListInfo> queryByDelDeviceId(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListInfo where deviceId = ?0 and deleteFlag ='1' ";
        this.logger.info((Object)("query need delete deleteFlag=1 whitelist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloWhiteListInfo> queryByDeviceIdAndDeleteFlag(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListInfo where deviceId = ?0 and deleteFlag ='0' ";
        this.logger.info((Object)("query need delete deleteFlag=0 whitelist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloWhiteListIpInfo> findByDeviceIdAndDeleteFlag(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListIpInfo where deviceId = ?0 and deleteFlag ='0' ";
        this.logger.info((Object)("query need delete deleteFlag=0 whitelist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void updateFlag(long id) {
        String hql = "update GloWhiteListInfo set deleteFlag = '1' where wid = ?0  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void updateNewFlag(long id) {
        String hql = "update GloWhiteListInfo set deleteFlag = '1' where id = ?0  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void updateFlagByDeviceId(String deviceid) {
        String hql = "update GloWhiteListInfo set deleteFlag = '1' where deviceId = ?0 and deployState = 'SUCCESS' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void updateIpListFlag(long id) {
        String hql = "update GloWhiteListIpInfo set deleteFlag = '1' where pkid = ?0  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteFlagData(long id) {
        String hql = "delete from GloWhiteListInfo where wid = ?0 and deleteFlag = '1' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteNewFlagData(long id) {
        String hql = "delete from GloWhiteListInfo where id = ?0 and deleteFlag = '1' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public List<GloWhiteListInfo> getByIps(String whitelistIps, String deviceId) {
        ArrayList<GloWhiteListInfo> result = new ArrayList<GloWhiteListInfo>();
        if (AticUtil.isNull((String)whitelistIps)) {
            return result;
        }
        String[] whitelistIp = whitelistIps.split(",");
        StringBuffer ipSet = new StringBuffer();
        int queryIndex = this.ipMaxSizeOneQuery - 1;
        for (int i = 0; i < whitelistIp.length; ++i) {
            if (0 == i) {
                ipSet.append(whitelistIp[i]);
            } else {
                ipSet.append("," + whitelistIp[i]);
            }
            if (i != whitelistIp.length - 1 && i != queryIndex) continue;
            StringBuffer hql = new StringBuffer("from GloWhiteListInfo where whitelistIp in (");
            Map<Integer, String> queryMap = this.conHqlByParam(hql, ipSet.toString(), deviceId);
            int index = ipSet.toString().split(",").length;
            hql.append(") and deleteFlag <> 1 and deviceId = ?" + index);
            result.addAll(this.findByHql(hql.toString(), queryMap));
            ipSet = new StringBuffer();
            queryIndex += this.ipMaxSizeOneQuery;
        }
        return result;
    }

    private Map<Integer, String> conHqlByParam(StringBuffer hql, String ips, String deviceId) {
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String[] ipList = ips.split(",");
        for (int i = 0; i < ipList.length; ++i) {
            if (0 == i) {
                hql.append("?" + i);
            } else {
                hql.append(",?" + i);
            }
            queryMap.put(i, ipList[i]);
        }
        queryMap.put(ipList.length, deviceId);
        return queryMap;
    }

    public List<GloWhiteListInfo> queryAllWhitelists(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListInfo where deviceId = ?0 and deleteFlag ='0' order by wid asc";
        this.logger.info((Object)("query need delete deleteFlag=0 whitelist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public int queryAllWhiteCount(String deviceId) {
        if (deviceId == null) {
            return 0;
        }
        String hql = "select count(*) as rowCount from GloWhiteListInfo where deviceId = ?0 and deleteFlag ='0'";
        this.logger.info((Object)("query need delete deleteFlag=0 whitelist ip and deviceId = " + deviceId));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        Long count = this.getTotalCount(hql, param);
        return count.intValue();
    }

    public void clearIpListData(Long id) {
        String hql = "delete from GloWhiteListIpInfo where pkid = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void clearAllIpListData(String deviceid) {
        String hql = "delete from GloWhiteListIpInfo where deviceId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void clearAllListData(String deviceid) {
        String hql = "delete from GloWhiteListInfo where deviceId= ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void clearIpsubListData(Long id) {
        String hql = "delete from GloWhiteListInfo where id= ?0 and deployState != 'SUCCESS'";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void clearAllIpsubListData(String deviceid) {
        String hql = "delete from GloWhiteListInfo where deviceId= ?0 and deployState != 'SUCCESS'";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public List<GloWhiteListInfo> findUndeploy(Long id) {
        String hql = "from GloWhiteListInfo where id = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<GloWhiteListIpInfo> getByIpLists(String id) {
        if (null == id) {
            return new ArrayList<GloWhiteListIpInfo>();
        }
        String[] idStrings = id.split(",");
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        hql.append("from GloWhiteListIpInfo where pkid in (");
        for (int i = 0; i < idStrings.length; ++i) {
            param.put(i, idStrings[i]);
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(")");
        List result = this.findByHql(hql.toString(), param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloWhiteListIpInfo>();
        }
        return result;
    }

    public List<GloWhiteListIpInfo> queryAllIpList(Long deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListIpInfo where deviceId = ?0 and deleteFlag = ?1 order by pkid asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, "0");
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public Paging queryByPageNew(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String whitelistIp;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        HashMap<Integer, String> queryMap2 = new HashMap<Integer, String>();
        String hql = "from GloWhiteListIpInfo where (1=1) and deleteFlag = '0'";
        String hql2 = "select id from GloWhiteListInfo where (1=1) and deleteFlag = '0'";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        int index1 = 0;
        String deviceId = conditionMap.get("deviceId");
        if (deviceId == null) {
            return null;
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        if (null != deviceId && !"".equals(deviceId)) {
            hql = hql + " and deviceId = ?" + index;
            hql2 = hql2 + " and deviceId = ?" + index1;
            queryMap.put(index++, deviceId);
            queryMap2.put(index1++, deviceId);
        }
        if (!AticUtil.isNull((String)(whitelistIp = conditionMap.get("whitelistIp")))) {
            String newWhiteIp = IPUtil4Atic.convert2CompleteIp((String)whitelistIp);
            hql2 = hql2 + " and startIp <=  ?" + index1;
            queryMap2.put(index1++, newWhiteIp);
            hql2 = hql2 + " and  endIp >= ?" + index1;
            queryMap2.put(index1++, newWhiteIp);
            List ids = this.findByHql(hql2, queryMap2);
            Long newId = -1L;
            if (null != ids && !ids.isEmpty()) {
                newId = (Long)ids.get(0);
            }
            hql = hql + " and pkid = ?" + index;
            queryMap.put(index, newId.toString());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            if (sortName.equalsIgnoreCase("blacklistIp")) {
                sortName = "whitelistIp";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public GloWhiteListIpInfo getIpList(Long id) {
        if (id == null) {
            return null;
        }
        String hql = "from GloWhiteListIpInfo where pkid = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List whiteList = this.findByHql(hql, param);
        if (whiteList == null || whiteList.isEmpty()) {
            return null;
        }
        return (GloWhiteListIpInfo)whiteList.get(0);
    }

    public List<GloWhiteListIpForm> queryAllIp(Long deviceId) {
        ArrayList<GloWhiteListIpForm> gloListIpForms = new ArrayList<GloWhiteListIpForm>();
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloWhiteListIpInfo where deviceId = ?0 order by startIp asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        for (GloWhiteListIpInfo gloIpInfo : result) {
            GloWhiteListIpForm gloIpForm = new GloWhiteListIpForm();
            gloIpForm.setMaskType(gloIpInfo.getMaskType());
            gloIpForm.setWhitelistIp(gloIpInfo.getWhitelistIp());
            gloIpForm.setIntMask(gloIpInfo.getIntMask());
            gloIpForm.setStartIp(gloIpInfo.getStartIp());
            gloIpForm.setEndIp(gloIpInfo.getEndIp());
            gloListIpForms.add(gloIpForm);
        }
        return gloListIpForms;
    }
}

