/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.neglobal.dao.GloBlackListDAO;
import com.hs.vsm.secservice.neglobal.dao.GloWhiteListDAO;
import com.hs.vsm.secservice.neglobal.model.GloBlackListInfo;
import com.hs.vsm.secservice.neglobal.model.GloBlackListIpInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GloBlackListServiceImpl
implements IGloBlackListService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private GloBlackListDAO gBlackListDAO;
    private GloWhiteListDAO gWhiteListDAO;
    private AticDeviceDao aticDeviceDao;

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public GloBlackListDAO getgBlackListDAO() {
        return this.gBlackListDAO;
    }

    public void setgBlackListDAO(GloBlackListDAO gBlackListDAOs) {
        this.gBlackListDAO = gBlackListDAOs;
    }

    public GloWhiteListDAO getgWhiteListDAO() {
        return this.gWhiteListDAO;
    }

    public void setgWhiteListDAO(GloWhiteListDAO gWhiteListDAOs) {
        this.gWhiteListDAO = gWhiteListDAOs;
    }

    @Override
    public BatchOperationResult batchDelGloBlackList(List<BatchOperation> gloList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == gloList) {
            return result;
        }
        if (!gloList.isEmpty()) {
            for (BatchOperation bo : gloList) {
                try {
                    GloBlackListForm gloBlackListIpForm = this.findById(bo.getTargetId());
                    if (null == gloBlackListIpForm) {
                        this.logger.error((Object)("dmake deltetFlag IpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(570699L);
                        continue;
                    }
                    String[] detailPara = null;
                    detailPara = new String[]{gloBlackListIpForm.getBlacklistIp()};
                    this.updateFlagById(bo.getTargetId());
                    bo.setOptDetail("com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.del");
                    bo.setDetailParam(detailPara);
                    this.logger.info((Object)("dmake deltetFlag IpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570700L);
                    this.logger.error((Object)("dmake deltetFlag IpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + " failed. " + e.getMessage()));
                }
            }
        }
        result.setResult(gloList);
        result.setFailCount(fail);
        result.setTotalCount(gloList.size());
        result.setSucceedCount(gloList.size() - fail);
        this.logger.info((Object)("batch delete IpBlacklist result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public void updateFlagById(Long id) {
        this.gBlackListDAO.updateFlag(id);
    }

    @Override
    public GloBlackListForm findById(Long id) {
        GloBlackListInfo gloInfo = this.gBlackListDAO.get(id);
        GloBlackListForm form = (GloBlackListForm)AticUtil.copyProperties((Object)gloInfo, (Object)new GloBlackListForm());
        this.logger.info((Object)("find IpBlacklist by id : " + id));
        return form;
    }

    @Override
    public List<GloBlackListForm> findEditExistIp(String blacklistIp, Long id) {
        List<GloBlackListInfo> gloBlackListInfos = this.gBlackListDAO.getByIpAndId(blacklistIp, id);
        if (gloBlackListInfos.isEmpty()) {
            return null;
        }
        ArrayList<GloBlackListForm> formList = new ArrayList<GloBlackListForm>();
        for (GloBlackListInfo gloBlackListInfo : gloBlackListInfos) {
            GloBlackListForm form = new GloBlackListForm();
            AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloBlackListForm> findExistIp(String blacklistIp, String deviceId) {
        List<GloBlackListInfo> blacklistips = this.gBlackListDAO.getByIp(blacklistIp, deviceId);
        if (blacklistips.isEmpty()) {
            return null;
        }
        ArrayList<GloBlackListForm> formList = new ArrayList<GloBlackListForm>();
        for (GloBlackListInfo gloBlackListInfo : blacklistips) {
            GloBlackListForm form = new GloBlackListForm();
            AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloBlackListForm> getByIds(String ids) {
        List<GloBlackListInfo> gloBlackListInfos = this.gBlackListDAO.getByIds(ids);
        ArrayList<GloBlackListForm> formList = new ArrayList<GloBlackListForm>();
        for (GloBlackListInfo gloBlackListInfo : gloBlackListInfos) {
            GloBlackListForm form = new GloBlackListForm();
            AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"blacklist enter queryByPage");
        Paging page = this.gBlackListDAO.queryByPage(queryMap, start, pageSize);
        if (page != null) {
            List list = page.getData();
            ArrayList<GloBlackListForm> formList = new ArrayList<GloBlackListForm>();
            for (GloBlackListInfo gloBlackListInfo : list) {
                GloBlackListForm form = new GloBlackListForm();
                AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
                formList.add(form);
            }
            page.setData(formList);
            this.logger.info((Object)"blacklist leave queryByPage");
            return page;
        }
        return new Paging();
    }

    @Override
    public void saveGloBlackList(GloBlackListForm gBlackListForm) {
        GloBlackListInfo gloBlackListInfo = (GloBlackListInfo)AticUtil.copyProperties((Object)gBlackListForm, (Object)new GloBlackListInfo());
        this.gBlackListDAO.saveOrUpdate(gloBlackListInfo);
    }

    @Override
    public void editGloBlackList(GloBlackListForm gBlackListForm) {
        GloBlackListInfo gloBlackListInfo = new GloBlackListInfo();
        Long id = gBlackListForm.getId();
        if (null != id) {
            gloBlackListInfo = this.gBlackListDAO.get(id);
        }
        if (gloBlackListInfo != null) {
            gloBlackListInfo.setBlacklistIp(gBlackListForm.getBlacklistIp());
            this.gBlackListDAO.saveOrUpdate(gloBlackListInfo);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> deployBlackList(Long deviceId) {
        GloBlackListServiceImpl gloBlackListServiceImpl = this;
        synchronized (gloBlackListServiceImpl) {
            this.logger.info((Object)"enter blacklist deploy ");
            HashMap<Long, String> result = new HashMap<Long, String>();
            ArrayList<String> cmds = new ArrayList<String>();
            List<GloBlackListForm> listForms = this.initDeployData(deviceId);
            for (GloBlackListForm form : listForms) {
                try {
                    List cmdResult;
                    if (!"SUCCESS".equals(form.getDeployState())) {
                        cmds.add("system");
                        if ("0".equals(form.getDeleteFlag())) {
                            if (IPUtil.isIpv4((String)form.getBlacklistIp())) {
                                cmds.add("anti-ddos blacklist-item ip " + form.getBlacklistIp());
                            }
                            if (IPUtil.isIpv6((String)form.getBlacklistIp())) {
                                cmds.add("anti-ddos blacklist-item ipv6 " + form.getBlacklistIp());
                            }
                            this.logger.info((Object)("cmds result :" + cmds));
                            cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                            this.logger.info((Object)("cmdResult result :" + this.getcleanedMessage(cmdResult.toString())));
                            cmds = new ArrayList();
                            if (AticUtil.isCmdSucess((List)cmdResult)) {
                                result.put(deviceId, "SUCCESS");
                                form.setDeployState("SUCCESS");
                                this.updateDeployStatus(form);
                            } else {
                                result.put(deviceId, "FAIL");
                                form.setDeployState("FAIL");
                                this.updateDeployStatus(form);
                                this.logger.info((Object)("blacklistip deploy failure , failure blacklist ip :" + form.getBlacklistIp()));
                                continue;
                            }
                        }
                        if (!"1".equals(form.getDeleteFlag())) continue;
                        if (IPUtil.isIpv4((String)form.getBlacklistIp())) {
                            cmds.add("undo anti-ddos blacklist-item ip " + form.getBlacklistIp());
                        }
                        if (IPUtil.isIpv6((String)form.getBlacklistIp())) {
                            cmds.add("undo anti-ddos blacklist-item ipv6 " + form.getBlacklistIp());
                        }
                        this.logger.info((Object)("cmds result :" + cmds));
                        cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                        this.logger.info((Object)("cmdResult result :" + this.getcleanedMessage(cmdResult.toString())));
                        if (AticUtil.isCmdSucess((List)cmdResult)) {
                            this.deleteUndoDeployData(form);
                        } else {
                            form.setDeployState("FAIL");
                            this.updateDeployStatus(form);
                        }
                        cmds = new ArrayList();
                        continue;
                    }
                    if (!"1".equals(form.getDeleteFlag())) continue;
                    cmds.add("system");
                    if (IPUtil.isIpv4((String)form.getBlacklistIp())) {
                        cmds.add("undo anti-ddos blacklist-item ip " + form.getBlacklistIp());
                    }
                    if (IPUtil.isIpv6((String)form.getBlacklistIp())) {
                        cmds.add("undo anti-ddos blacklist-item ipv6 " + form.getBlacklistIp());
                    }
                    cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                    cmds = new ArrayList();
                    this.logger.info((Object)("cmdResult result :" + this.getcleanedMessage(cmdResult.toString())));
                    if (!AticUtil.isCmdSucess((List)cmdResult)) continue;
                    this.deleteUndoDeployData(form);
                }
                catch (LegoCheckedException legoExcp) {
                    result.put(deviceId, "FAIL");
                    form.setDeployState("FAIL");
                    this.updateDeployStatus(form);
                    throw legoExcp;
                }
            }
            this.logger.info((Object)"leave blacklist deploy ");
            return result;
        }
    }

    @Override
    public List<GloBlackListForm> initDeployData(Long deviceId) {
        this.logger.info((Object)"enter initDeployData");
        List<GloBlackListInfo> infos = this.queryByDeviceId(deviceId);
        if (infos == null) {
            infos = new ArrayList<GloBlackListInfo>();
        }
        ArrayList<GloBlackListForm> formList = new ArrayList<GloBlackListForm>();
        for (GloBlackListInfo gloBlackListInfo : infos) {
            GloBlackListForm form = new GloBlackListForm();
            AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
            formList.add(form);
        }
        this.logger.info((Object)"leave initDeployData");
        return formList;
    }

    @Override
    public List<GloBlackListInfo> queryByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloBlackListInfo> list = this.gBlackListDAO.queryByDeviceId(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloBlackListInfo> queryByDelDeviceIdAndDelFlag(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloBlackListInfo> list = this.gBlackListDAO.queryByDelDeviceIdAndDelFlag(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloBlackListIpInfo> findByDelDeviceIdAndDelFlag(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloBlackListIpInfo> list = this.gBlackListDAO.findByDelDeviceIdAndDelFlag(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloBlackListInfo> queryDelFlag(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloBlackListInfo> list = this.gBlackListDAO.queryByDelDeviceId(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public void updateDeployStatus(GloBlackListForm form) {
        this.logger.info((Object)"enter update");
        GloBlackListInfo info = new GloBlackListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gBlackListDAO.update(info);
        this.logger.info((Object)"leave update");
    }

    @Override
    public void deleteUndoDeployData(GloBlackListForm form) {
        this.logger.info((Object)"enter update");
        GloBlackListInfo info = new GloBlackListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gBlackListDAO.deleteFlagData(form.getPkid());
        this.logger.info((Object)"leave update");
    }

    @Override
    public BatchOperationResult saveBlackList(List<BatchOperation> batchOpList, String deviceId) {
        this.logger.info((Object)"entry saveImportBlackList()");
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<GloBlackListInfo> needSaveDataList = new ArrayList<GloBlackListInfo>();
        List<GloBlackListInfo> bList = this.gBlackListDAO.queryAllBlacklists(deviceId);
        List<GloWhiteListInfo> wList = this.gWhiteListDAO.queryAllWhitelists(deviceId);
        boolean isCheckStandard = this.isStandard(bList, wList, batchOpList.size(), deviceId);
        int fail = 0;
        for (BatchOperation bo : batchOpList) {
            String[] datas = bo.getOptDetail().split(",");
            if (!IPUtil.isIpv4((String)datas[0].trim()) && !IPUtil.isIpv6((String)datas[0].trim())) {
                ++fail;
                bo.setErrorCode(570701L);
                bo.setTargetName(datas[0].trim());
                this.logger.error((Object)("ipBlacklist data ipformat error:" + datas[0]));
                continue;
            }
            if (this.isExistBlackList(bList, datas[0])) {
                ++fail;
                bo.setTargetName(datas[0].trim());
                bo.setErrorCode(570703L);
                continue;
            }
            if (this.isExistWhiteList(wList, datas[0])) {
                ++fail;
                bo.setTargetName(datas[0].trim());
                bo.setErrorCode(570702L);
                continue;
            }
            if (needSaveDataList.isEmpty() && this.isExistBlackList(needSaveDataList, datas[0])) {
                ++fail;
                bo.setTargetName(datas[0].trim());
                bo.setErrorCode(570710L);
                continue;
            }
            if (isCheckStandard && this.isStandard(bList, wList, needSaveDataList.size(), deviceId)) {
                ++fail;
                bo.setTargetName("com.hs.vsm.secservice.neglobal.import.bwlist.excced");
                bo.setErrorCode(731043L);
                break;
            }
            GloBlackListInfo gloInfo = new GloBlackListInfo();
            try {
                gloInfo.setDeviceId(deviceId);
                gloInfo.setBlacklistIp(datas[0].trim());
                gloInfo.setDeployState("UNDEPLOY");
                gloInfo.setDeleteFlag("0");
                needSaveDataList.add(gloInfo);
            }
            catch (RuntimeException e) {
                ++fail;
                bo.setTargetName(gloInfo.getBlacklistIp());
                bo.setErrorCode(570703L);
            }
        }
        for (GloBlackListInfo gloInfo : needSaveDataList) {
            this.gBlackListDAO.saveOrUpdate(gloInfo);
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - fail);
        this.logger.info((Object)"leave saveImportBlackList()");
        return result;
    }

    private boolean isExistBlackList(List<GloBlackListInfo> bList, String ip) {
        if (null != bList && !bList.isEmpty()) {
            for (GloBlackListInfo bInfo : bList) {
                if (!ip.trim().equals(bInfo.getBlacklistIp())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExistWhiteList(List<GloWhiteListInfo> wList, String ip) {
        if (null != wList && !wList.isEmpty()) {
            for (GloWhiteListInfo wInfo : wList) {
                if (!ip.trim().equals(wInfo.getWhitelistIp())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStandard(List<GloBlackListInfo> bList, List<GloWhiteListInfo> wList, int num, String deviceId) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(Long.parseLong(deviceId));
        boolean flag = false;
        if (aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc500") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc600") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc700") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc800") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc900")) {
            if (null != bList || null != wList) {
                if (null != bList && null == wList) {
                    if (bList.size() >= 20000 - num) {
                        flag = true;
                    }
                } else if (null == bList && null != wList) {
                    if (wList.size() >= 20000 - num) {
                        flag = true;
                    }
                } else if (null != bList && null != wList && bList.size() + wList.size() >= 20000 - num) {
                    flag = true;
                }
            }
        } else if (null != bList || null != wList) {
            if (null != bList && null == wList) {
                if (bList.size() >= 40960 - num) {
                    flag = true;
                }
            } else if (null == bList && null != wList) {
                if (wList.size() >= 40960 - num) {
                    flag = true;
                }
            } else if (null != wList && null != bList && bList.size() + wList.size() >= 40960 - num) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public List<GloBlackListInfo> queryAllBlacklists(Long deviceId) {
        this.logger.info((Object)"enter queryByAllBlacklists");
        List<GloBlackListInfo> list = this.gBlackListDAO.queryAllBlacklists(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByAllBlacklists");
        return list;
    }

    @Override
    public int queryAllBlackCount(Long deviceId) {
        this.logger.info((Object)("enter queryAllBlackCount by deviceId :" + deviceId));
        return this.gBlackListDAO.queryAllBlackCount(String.valueOf(deviceId));
    }

    @Override
    public void saveBlackListIp(GloBlackListIpForm gloListIpForm) {
        Long pkid = this.saveBlackIpLists(gloListIpForm);
        this.saveBlackListIpAdds(gloListIpForm.getGloBlackListForms(), gloListIpForm, pkid);
    }

    private Long saveBlackIpLists(GloBlackListIpForm gloListIpForm) {
        GloBlackListIpInfo gloBlackListIpInfo = new GloBlackListIpInfo();
        gloBlackListIpInfo.setDeviceId(String.valueOf(gloListIpForm.getDeviceId()));
        gloBlackListIpInfo.setBlacklistIp(gloListIpForm.getBlacklistIp());
        gloBlackListIpInfo.setIntMask(gloListIpForm.getIntMask());
        gloBlackListIpInfo.setStartIp(gloListIpForm.getStartIp());
        gloBlackListIpInfo.setEndIp(gloListIpForm.getEndIp());
        gloBlackListIpInfo.setMaskType(gloListIpForm.getMaskType());
        gloBlackListIpInfo.setDeleteFlag(gloListIpForm.getDeleteFlag());
        return (Long)this.gBlackListDAO.save(gloBlackListIpInfo);
    }

    private void saveBlackListIpAdds(List<GloBlackListForm> gloForms, GloBlackListIpForm gloListIpForm, Long pkid) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)gloListIpForm.getStartIp());
        String endIp = IPUtil4Atic.convert2CompleteIp((String)gloListIpForm.getEndIp());
        if (null != gloForms && !gloForms.isEmpty()) {
            for (GloBlackListForm gloBlackListForm : gloForms) {
                GloBlackListInfo gloBlackListInfo = new GloBlackListInfo();
                gloBlackListForm.setId(pkid);
                gloBlackListForm.setDeviceId(String.valueOf(gloListIpForm.getDeviceId()));
                gloBlackListForm.setStartIp(startIp);
                gloBlackListForm.setEndIp(endIp);
                AticUtil.copyProperties((Object)gloBlackListForm, (Object)gloBlackListInfo);
                this.gBlackListDAO.saveOrUpdate(gloBlackListInfo);
            }
        }
    }

    @Override
    public Paging queryByPageNew(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"newBlackIplist enter queryByPage");
        Paging page = this.gBlackListDAO.queryByPageNew(queryMap, start, pageSize);
        if (page != null) {
            List ipList = page.getData();
            ArrayList<GloBlackListIpForm> formList = new ArrayList<GloBlackListIpForm>();
            for (GloBlackListIpInfo gloBlackListInfo : ipList) {
                GloBlackListIpForm form = new GloBlackListIpForm();
                form.setDeviceId(Long.valueOf(gloBlackListInfo.getDeviceId()));
                form.setPkid(gloBlackListInfo.getPkid());
                form.setStartIp(gloBlackListInfo.getStartIp());
                form.setEndIp(gloBlackListInfo.getEndIp());
                form.setBlacklistIp(gloBlackListInfo.getBlacklistIp());
                form.setIntMask(gloBlackListInfo.getIntMask());
                form.setMaskType(gloBlackListInfo.getMaskType());
                formList.add(form);
            }
            page.setData(formList);
            return page;
        }
        return new Paging();
    }

    @Override
    public void deleteBlackListIp(Long pkid) {
        this.deleteIpAdd(pkid);
    }

    private void deleteIpAdd(Long pkid) {
        List<GloBlackListInfo> gloListInfos = this.gBlackListDAO.findUndeploy(pkid);
        int count = 0;
        if (null != gloListInfos && !gloListInfos.isEmpty()) {
            for (GloBlackListInfo gloInfo : gloListInfos) {
                if (!"SUCCESS".equals(gloInfo.getDeployState())) {
                    this.gBlackListDAO.clearIpsubListData(pkid);
                    if (++count != gloListInfos.size()) continue;
                    this.gBlackListDAO.clearIpListData(pkid);
                    continue;
                }
                this.gBlackListDAO.updateNewFlag(pkid);
                this.gBlackListDAO.updateIpListFlag(pkid);
            }
        }
    }

    @Override
    public BatchOperationResult batchDelGloBlackList2(List<BatchOperation> gloList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == gloList) {
            return result;
        }
        if (!gloList.isEmpty()) {
            for (BatchOperation bo : gloList) {
                try {
                    GloBlackListIpForm gloBlackListIpForm = this.findByIpListId(bo.getTargetId());
                    String[] detailPara = null;
                    detailPara = gloBlackListIpForm.getMaskType() == 1 ? new String[]{gloBlackListIpForm.getStartIp() + "-" + gloBlackListIpForm.getEndIp()} : new String[]{gloBlackListIpForm.getBlacklistIp() + "/" + gloBlackListIpForm.getIntMask()};
                    this.deleteIpAdd(bo.getTargetId());
                    bo.setOptDetail("com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.del");
                    bo.setDetailParam(detailPara);
                    this.logger.info((Object)("make deltetFlag newIpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570700L);
                    this.logger.error((Object)("make deltetFlag newIpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + " failed. " + e.getMessage()));
                }
            }
        }
        result.setResult(gloList);
        result.setFailCount(fail);
        result.setTotalCount(gloList.size());
        result.setSucceedCount(gloList.size() - fail);
        this.logger.info((Object)("batch delete newIpBlacklist result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public List<GloBlackListIpForm> getByIdList(String ids) {
        List<GloBlackListIpInfo> gloBlackListInfos = this.gBlackListDAO.getByIpLists(ids);
        ArrayList<GloBlackListIpForm> formList = new ArrayList<GloBlackListIpForm>();
        for (GloBlackListIpInfo gloBlackListInfo : gloBlackListInfos) {
            GloBlackListIpForm form = new GloBlackListIpForm();
            form.setMaskType(gloBlackListInfo.getMaskType());
            form.setBlacklistIp(gloBlackListInfo.getBlacklistIp());
            form.setIntMask(gloBlackListInfo.getIntMask());
            form.setStartIp(gloBlackListInfo.getStartIp());
            form.setEndIp(gloBlackListInfo.getEndIp());
            formList.add(form);
        }
        return formList;
    }

    @Override
    public BatchOperationResult importSaveNewBlackList(List<BatchOperation> batchOpList, String deviceId) {
        this.logger.info((Object)"entry importSaveNewBlackList()");
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
        ArrayList<GloBlackListIpForm> baseCheckDataListIpv4 = new ArrayList<GloBlackListIpForm>();
        ArrayList<GloBlackListIpForm> baseCheckDataListIpv6 = new ArrayList<GloBlackListIpForm>();
        this.importBaseCheck(batchOpList, frontOperationList, deviceId, baseCheckDataListIpv4, baseCheckDataListIpv6);
        ArrayList<GloBlackListIpForm> selfCheckDataListIpv4 = new ArrayList<GloBlackListIpForm>();
        ArrayList<GloBlackListIpForm> selfCheckDataListIpv6 = new ArrayList<GloBlackListIpForm>();
        this.selfCheckIpV4(selfCheckDataListIpv4, baseCheckDataListIpv4, frontOperationList);
        this.selfCheckIpV6(selfCheckDataListIpv6, baseCheckDataListIpv6, frontOperationList);
        List<GloBlackListIpForm> bListIp = this.gBlackListDAO.queryAllIp(Long.valueOf(deviceId));
        ArrayList<GloBlackListIpForm> bListIpV4 = new ArrayList<GloBlackListIpForm>();
        ArrayList<GloBlackListIpForm> bListIpV6 = new ArrayList<GloBlackListIpForm>();
        this.ipBlackTypeGroup(bListIp, bListIpV4, bListIpV6);
        ArrayList<GloBlackListIpForm> errorIpV4List = new ArrayList<GloBlackListIpForm>();
        ArrayList<GloBlackListIpForm> errorIpV6List = new ArrayList<GloBlackListIpForm>();
        this.bListIpV4Compar(bListIpV4, selfCheckDataListIpv4, errorIpV4List, frontOperationList);
        ArrayList<GloBlackListIpForm> needRemoveIpV4List = new ArrayList<GloBlackListIpForm>();
        if (!selfCheckDataListIpv4.isEmpty()) {
            for (GloBlackListIpForm gloBlackListIpForm : selfCheckDataListIpv4) {
                for (GloBlackListIpForm gloBlackListIpForm2 : errorIpV4List) {
                    if (null == gloBlackListIpForm || null == gloBlackListIpForm2 || !gloBlackListIpForm.getStartIp().equals(gloBlackListIpForm2.getStartIp())) continue;
                    needRemoveIpV4List.add(gloBlackListIpForm);
                }
            }
            if (!needRemoveIpV4List.isEmpty()) {
                selfCheckDataListIpv4.removeAll(needRemoveIpV4List);
            }
        }
        this.bListIpV6Compar(bListIpV6, selfCheckDataListIpv6, errorIpV6List, frontOperationList);
        ArrayList<GloBlackListIpForm> needRemoveIpV6List = new ArrayList<GloBlackListIpForm>();
        if (!selfCheckDataListIpv6.isEmpty()) {
            for (GloBlackListIpForm gloIpForm : selfCheckDataListIpv6) {
                for (GloBlackListIpForm gloIpForm2 : errorIpV6List) {
                    if (null == gloIpForm || null == gloIpForm2 || !gloIpForm.getStartIp().equals(gloIpForm2.getStartIp())) continue;
                    needRemoveIpV6List.add(gloIpForm);
                }
            }
            if (!needRemoveIpV6List.isEmpty()) {
                selfCheckDataListIpv6.removeAll(needRemoveIpV6List);
            }
        }
        List<GloWhiteListIpForm> list = this.gWhiteListDAO.queryAllIp(Long.valueOf(deviceId));
        ArrayList<GloWhiteListIpForm> wListIpV4 = new ArrayList<GloWhiteListIpForm>();
        ArrayList<GloWhiteListIpForm> arrayList = new ArrayList<GloWhiteListIpForm>();
        this.ipWhilteTypeGroup(list, wListIpV4, arrayList);
        ArrayList<GloBlackListIpForm> errorBypassIpV4List = new ArrayList<GloBlackListIpForm>();
        this.wListIpV4Compar(wListIpV4, selfCheckDataListIpv4, errorBypassIpV4List, frontOperationList);
        ArrayList<GloBlackListIpForm> needRemoveBypassIpV4List = new ArrayList<GloBlackListIpForm>();
        if (!selfCheckDataListIpv4.isEmpty()) {
            for (GloBlackListIpForm gloIpForm : selfCheckDataListIpv4) {
                for (GloBlackListIpForm gloIpForm2 : errorBypassIpV4List) {
                    if (null == gloIpForm || null == gloIpForm2 || !gloIpForm.getStartIp().equals(gloIpForm2.getStartIp())) continue;
                    needRemoveBypassIpV4List.add(gloIpForm);
                }
            }
            if (!needRemoveBypassIpV4List.isEmpty()) {
                selfCheckDataListIpv4.removeAll(needRemoveBypassIpV4List);
            }
        }
        ArrayList<GloBlackListIpForm> errorBypassIpV6List = new ArrayList<GloBlackListIpForm>();
        this.wListIpV6Compar(arrayList, selfCheckDataListIpv6, errorBypassIpV6List, frontOperationList);
        ArrayList<GloBlackListIpForm> bneedRemoveBypassIpV6List = new ArrayList<GloBlackListIpForm>();
        if (!selfCheckDataListIpv6.isEmpty()) {
            for (GloBlackListIpForm gloIpForm : selfCheckDataListIpv6) {
                for (GloBlackListIpForm gloIpForm2 : errorBypassIpV6List) {
                    if (null == gloIpForm || null == gloIpForm2 || !gloIpForm.getStartIp().equals(gloIpForm2.getStartIp())) continue;
                    bneedRemoveBypassIpV6List.add(gloIpForm);
                }
            }
            if (!bneedRemoveBypassIpV6List.isEmpty()) {
                selfCheckDataListIpv6.removeAll(bneedRemoveBypassIpV6List);
            }
        }
        if (!selfCheckDataListIpv4.isEmpty()) {
            this.saveImportData(selfCheckDataListIpv4, deviceId);
        }
        if (!selfCheckDataListIpv6.isEmpty()) {
            this.saveImportData(selfCheckDataListIpv6, deviceId);
        }
        ArrayList<BatchOperation> batList = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : frontOperationList) {
            batList.add(batchOperation);
        }
        result.setResult(batList);
        result.setFailCount(batList.size());
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - batList.size());
        return result;
    }

    private void ipBlackTypeGroup(List<GloBlackListIpForm> list, List<GloBlackListIpForm> listIpV4, List<GloBlackListIpForm> listIpV6) {
        if (null != list && !list.isEmpty()) {
            for (GloBlackListIpForm gloBlackListIpForm : list) {
                if (gloBlackListIpForm.getMaskType() == 0) {
                    if (IPUtil.isIpv4((String)gloBlackListIpForm.getBlacklistIp())) {
                        listIpV4.add(gloBlackListIpForm);
                        continue;
                    }
                    if (!IPUtil.isIpv6((String)gloBlackListIpForm.getBlacklistIp())) continue;
                    listIpV6.add(gloBlackListIpForm);
                    continue;
                }
                if (IPUtil.isIpv4((String)gloBlackListIpForm.getStartIp())) {
                    listIpV4.add(gloBlackListIpForm);
                    continue;
                }
                if (!IPUtil.isIpv6((String)gloBlackListIpForm.getStartIp())) continue;
                listIpV6.add(gloBlackListIpForm);
            }
        }
    }

    private void ipWhilteTypeGroup(List<GloWhiteListIpForm> list, List<GloWhiteListIpForm> listIpV4, List<GloWhiteListIpForm> listIpV6) {
        if (null != list && !list.isEmpty()) {
            for (GloWhiteListIpForm gloWhiteListIpForm : list) {
                if (gloWhiteListIpForm.getMaskType() == 0) {
                    if (IPUtil.isIpv4((String)gloWhiteListIpForm.getWhitelistIp())) {
                        listIpV4.add(gloWhiteListIpForm);
                        continue;
                    }
                    if (!IPUtil.isIpv6((String)gloWhiteListIpForm.getWhitelistIp())) continue;
                    listIpV6.add(gloWhiteListIpForm);
                    continue;
                }
                if (IPUtil.isIpv4((String)gloWhiteListIpForm.getStartIp())) {
                    listIpV4.add(gloWhiteListIpForm);
                    continue;
                }
                if (!IPUtil.isIpv6((String)gloWhiteListIpForm.getStartIp())) continue;
                listIpV6.add(gloWhiteListIpForm);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void importBaseCheck(List<BatchOperation> batchOpList, List<BatchOperation> frontOperationList, String deviceId, List<GloBlackListIpForm> baseCheckDataListIpv4, List<GloBlackListIpForm> baseCheckDataListIpv6) {
        Iterator<BatchOperation> iterator = batchOpList.iterator();
        while (iterator.hasNext()) {
            String[] ipString;
            BatchOperation bo = iterator.next();
            GloBlackListIpForm gloIpForm = new GloBlackListIpForm();
            String[] datas = bo.getOptDetail().split(",");
            String ipStr = datas[0];
            if (ipStr.contains("/")) {
                String[] subNetRange;
                ipString = ipStr.split("/");
                String ipAddress = ipString[0].trim();
                String intMask = ipString[1].trim();
                if (!IPUtil.isIpv4((String)ipAddress) && !IPUtil.isIpv6((String)ipAddress)) {
                    bo.setErrorCode(570701L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    this.logger.error((Object)"ipNewBlacklist data ipformat error");
                    continue;
                }
                if (IPUtil.isIpv4((String)ipAddress)) {
                    if (Long.parseLong(intMask) < 8L || Long.parseLong(intMask) > 32L) {
                        bo.setErrorCode(570708L);
                        bo.setTargetName(ipStr);
                        frontOperationList.add(bo);
                        continue;
                    }
                    gloIpForm.setMaskType(0);
                    gloIpForm.setDeviceId(Long.valueOf(deviceId));
                    gloIpForm.setBlacklistIp(ipAddress);
                    gloIpForm.setIntMask(Integer.valueOf(intMask));
                    subNetRange = IPUtil.getSubnetRange((String)gloIpForm.getBlacklistIp(), (int)gloIpForm.getIntMask());
                    gloIpForm.setStartIp(subNetRange[0]);
                    gloIpForm.setEndIp(subNetRange[1]);
                    gloIpForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[0]));
                    gloIpForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[1]));
                    baseCheckDataListIpv4.add(gloIpForm);
                }
                if (!IPUtil.isIpv6((String)ipAddress)) continue;
                if (Long.parseLong(intMask) < 8L || Long.parseLong(intMask) > 128L) {
                    bo.setErrorCode(570709L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    continue;
                }
                gloIpForm.setMaskType(0);
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setBlacklistIp(ipAddress);
                gloIpForm.setIntMask(Integer.valueOf(intMask));
                subNetRange = IPUtil.getSubnetRange((String)gloIpForm.getBlacklistIp(), (int)gloIpForm.getIntMask());
                gloIpForm.setStartIp(subNetRange[0]);
                gloIpForm.setEndIp(subNetRange[1]);
                gloIpForm.setStartIpLong(1L);
                gloIpForm.setEndIpLong(1L);
                gloIpForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[0]));
                gloIpForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[1]));
                baseCheckDataListIpv6.add(gloIpForm);
                continue;
            }
            if (ipStr.contains("-")) {
                String endIp;
                String startIp;
                block14: {
                    ipString = ipStr.split("-");
                    startIp = ipString[0].trim();
                    endIp = ipString[1].trim();
                    if (IPUtil.isIpv4((String)startIp) && IPUtil.isIpv4((String)endIp)) {
                        if (IPUtil.compareTo((String)startIp, (String)endIp) == -1 || IPUtil.compareTo((String)startIp, (String)endIp) == 0) {
                            gloIpForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)startIp));
                            gloIpForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)endIp));
                            baseCheckDataListIpv4.add(gloIpForm);
                            break block14;
                        } else {
                            bo.setErrorCode(570711L);
                            bo.setTargetName(ipStr);
                            frontOperationList.add(bo);
                            continue;
                        }
                    }
                    if (IPUtil.isIpv6((String)startIp) && IPUtil.isIpv6((String)endIp)) {
                        if (IPUtil.compareTo((String)startIp, (String)endIp) == -1 || IPUtil.compareTo((String)startIp, (String)endIp) == 0) {
                            gloIpForm.setStartIpLong(1L);
                            gloIpForm.setEndIpLong(1L);
                            gloIpForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)startIp));
                            gloIpForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)endIp));
                            baseCheckDataListIpv6.add(gloIpForm);
                            break block14;
                        } else {
                            bo.setErrorCode(570711L);
                            bo.setTargetName(ipStr);
                            frontOperationList.add(bo);
                            continue;
                        }
                    }
                    bo.setErrorCode(570701L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    continue;
                }
                gloIpForm.setMaskType(1);
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setStartIp(startIp);
                gloIpForm.setEndIp(endIp);
                continue;
            }
            bo.setErrorCode(570701L);
            bo.setTargetName(ipStr);
            frontOperationList.add(bo);
        }
        return;
    }

    private void selfCheckIpV4(List<GloBlackListIpForm> selfCheckDataListIpv4, List<GloBlackListIpForm> baseCheckDataListIpv4, List<BatchOperation> frontOperationList) {
        if (null != baseCheckDataListIpv4 && !baseCheckDataListIpv4.isEmpty() && baseCheckDataListIpv4.size() == 1) {
            selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(0));
        }
        if (null != baseCheckDataListIpv4 && !baseCheckDataListIpv4.isEmpty() && baseCheckDataListIpv4.size() != 1) {
            Collections.sort(baseCheckDataListIpv4);
            for (int i = 0; i < baseCheckDataListIpv4.size(); ++i) {
                if (i == 0) {
                    selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(0));
                    continue;
                }
                if (baseCheckDataListIpv4.get(i).getStartIpLong() <= selfCheckDataListIpv4.get(selfCheckDataListIpv4.size() - 1).getEndIpLong()) {
                    BatchOperation bo = new BatchOperation();
                    bo.setErrorCode(570710L);
                    if (baseCheckDataListIpv4.get(i).getMaskType() == 0) {
                        bo.setTargetName(baseCheckDataListIpv4.get(i).getBlacklistIp() + "/" + baseCheckDataListIpv4.get(i).getIntMask());
                    } else {
                        bo.setTargetName(baseCheckDataListIpv4.get(i).getStartIp() + "-" + baseCheckDataListIpv4.get(i).getEndIp());
                    }
                    frontOperationList.add(bo);
                    continue;
                }
                selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(i));
            }
        }
    }

    private void selfCheckIpV6(List<GloBlackListIpForm> selfCheckDataListIpv6, List<GloBlackListIpForm> baseCheckDataListIpv6, List<BatchOperation> frontOperationList) {
        if (null != baseCheckDataListIpv6 && !baseCheckDataListIpv6.isEmpty() && baseCheckDataListIpv6.size() == 1) {
            selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(0));
        }
        if (null != baseCheckDataListIpv6 && !baseCheckDataListIpv6.isEmpty() && baseCheckDataListIpv6.size() != 1) {
            Collections.sort(baseCheckDataListIpv6);
            for (int i = 0; i < baseCheckDataListIpv6.size(); ++i) {
                if (i == 0) {
                    selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(0));
                    continue;
                }
                if (IPUtil.compareTo((String)baseCheckDataListIpv6.get(i).getStartIp(), (String)selfCheckDataListIpv6.get(selfCheckDataListIpv6.size() - 1).getEndIp()) != 1) {
                    BatchOperation bo = new BatchOperation();
                    bo.setErrorCode(570710L);
                    if (baseCheckDataListIpv6.get(i).getMaskType() == 0) {
                        bo.setTargetName(baseCheckDataListIpv6.get(i).getBlacklistIp() + "/" + baseCheckDataListIpv6.get(i).getIntMask());
                    } else {
                        bo.setTargetName(baseCheckDataListIpv6.get(i).getStartIp() + "-" + baseCheckDataListIpv6.get(i).getEndIp());
                    }
                    frontOperationList.add(bo);
                    continue;
                }
                selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(i));
            }
        }
    }

    private void bListIpV4Compar(List<GloBlackListIpForm> bListIpV4, List<GloBlackListIpForm> selfCheckDataListIpv4, List<GloBlackListIpForm> errorIpV4List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != bListIpV4 && !bListIpV4.isEmpty()) {
            for (GloBlackListIpForm gLOForm : bListIpV4) {
                gLOForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getStartIp()));
                gLOForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getEndIp()));
            }
            Collections.sort(bListIpV4);
            block1: for (int i = 0; i < selfCheckDataListIpv4.size(); ++i) {
                for (int j = confilctNumber; j < bListIpV4.size(); ++j) {
                    if (selfCheckDataListIpv4.get(i).getStartIpLong() > bListIpV4.get(j).getEndIpLong() || bListIpV4.get(j).getStartIpLong() > selfCheckDataListIpv4.get(i).getEndIpLong() || bListIpV4.get(j).getEndIpLong() < selfCheckDataListIpv4.get(i).getStartIpLong()) continue;
                    errorIpV4List.add(selfCheckDataListIpv4.get(i));
                    confilctNumber = j;
                    continue block1;
                }
            }
            for (GloBlackListIpForm gloForm : errorIpV4List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570703L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getBlacklistIp() + "/" + gloForm.getIntMask());
                    continue;
                }
                bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
            }
        }
    }

    private void bListIpV6Compar(List<GloBlackListIpForm> bListIpV6, List<GloBlackListIpForm> selfCheckDataListIpv6, List<GloBlackListIpForm> errorIpV6List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != bListIpV6 && !bListIpV6.isEmpty()) {
            for (GloBlackListIpForm gLOForm : bListIpV6) {
                gLOForm.setStartIpLong(1L);
                gLOForm.setEndIpLong(1L);
                gLOForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getStartIp()));
                gLOForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getEndIp()));
            }
            Collections.sort(bListIpV6);
            block1: for (int i = 0; i < selfCheckDataListIpv6.size(); ++i) {
                for (int j = confilctNumber; j < bListIpV6.size(); ++j) {
                    if (IPUtil.compareTo((String)selfCheckDataListIpv6.get(i).getStartIp(), (String)bListIpV6.get(j).getEndIp()) == 1 || IPUtil.compareTo((String)bListIpV6.get(j).getStartIp(), (String)selfCheckDataListIpv6.get(i).getEndIp()) == 1 || IPUtil.compareTo((String)bListIpV6.get(j).getEndIp(), (String)selfCheckDataListIpv6.get(i).getStartIp()) == -1) continue;
                    errorIpV6List.add(selfCheckDataListIpv6.get(i));
                    confilctNumber = j;
                    continue block1;
                }
            }
            for (GloBlackListIpForm gloForm : errorIpV6List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570703L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getBlacklistIp() + "/" + gloForm.getIntMask());
                    continue;
                }
                bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
            }
        }
    }

    private void wListIpV4Compar(List<GloWhiteListIpForm> wListIpV4, List<GloBlackListIpForm> selfCheckDataListIpv4, List<GloBlackListIpForm> errorIpV4List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != wListIpV4 && !wListIpV4.isEmpty()) {
            for (GloWhiteListIpForm gLOForm : wListIpV4) {
                gLOForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getStartIp()));
                gLOForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getEndIp()));
            }
            Collections.sort(wListIpV4);
            for (int i = 0; i < selfCheckDataListIpv4.size() && confilctNumber < wListIpV4.size(); ++i) {
                for (int j = confilctNumber; j < wListIpV4.size(); ++j) {
                    if (selfCheckDataListIpv4.get(i).getStartIpLong() > wListIpV4.get(j).getEndIpLong() || wListIpV4.get(j).getStartIpLong() > selfCheckDataListIpv4.get(i).getEndIpLong() || wListIpV4.get(j).getEndIpLong() < selfCheckDataListIpv4.get(i).getStartIpLong()) continue;
                    errorIpV4List.add(selfCheckDataListIpv4.get(i));
                    confilctNumber = j;
                }
            }
            for (GloBlackListIpForm gloForm : errorIpV4List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570702L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getBlacklistIp() + "/" + gloForm.getIntMask());
                } else {
                    bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
                }
                frontOperationList.add(bo);
            }
        }
    }

    private void wListIpV6Compar(List<GloWhiteListIpForm> wListIpV6, List<GloBlackListIpForm> selfCheckDataListIpv6, List<GloBlackListIpForm> errorIpV6List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != wListIpV6 && !wListIpV6.isEmpty()) {
            for (GloWhiteListIpForm gLOForm : wListIpV6) {
                gLOForm.setStartIpLong(1L);
                gLOForm.setEndIpLong(1L);
                gLOForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getStartIp()));
                gLOForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getEndIp()));
            }
            Collections.sort(wListIpV6);
            for (int i = 0; i < selfCheckDataListIpv6.size() && confilctNumber < wListIpV6.size(); ++i) {
                for (int j = confilctNumber; j < wListIpV6.size(); ++j) {
                    if (IPUtil.compareTo((String)selfCheckDataListIpv6.get(i).getStartIp(), (String)wListIpV6.get(j).getEndIp()) == 1 || IPUtil.compareTo((String)wListIpV6.get(j).getStartIp(), (String)selfCheckDataListIpv6.get(i).getEndIp()) == 1 || IPUtil.compareTo((String)wListIpV6.get(j).getEndIp(), (String)selfCheckDataListIpv6.get(i).getStartIp()) == -1) continue;
                    errorIpV6List.add(selfCheckDataListIpv6.get(i));
                    confilctNumber = j;
                }
            }
            for (GloBlackListIpForm gloForm : errorIpV6List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570702L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getBlacklistIp() + "/" + gloForm.getIntMask());
                } else {
                    bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
                }
                frontOperationList.add(bo);
            }
        }
    }

    @Override
    public List<GloBlackListIpInfo> queryAllBlacklist(Long deviceId) {
        List<GloBlackListIpInfo> list = this.gBlackListDAO.queryAllIpList(deviceId);
        if (null == list) {
            return null;
        }
        return list;
    }

    private void saveImportData(List<GloBlackListIpForm> gloIpForms, String deviceId) {
        for (GloBlackListIpForm gloIpForm : gloIpForms) {
            ArrayList<GloBlackListForm> subList = new ArrayList<GloBlackListForm>();
            if (gloIpForm.getMaskType() == 0) {
                GloBlackListForm gloForm = new GloBlackListForm();
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setStartIp(IPUtil.getSubnetRange((String)gloIpForm.getBlacklistIp(), (int)gloIpForm.getIntMask())[0]);
                gloIpForm.setEndIp(IPUtil.getSubnetRange((String)gloIpForm.getBlacklistIp(), (int)gloIpForm.getIntMask())[1]);
                gloIpForm.setDeleteFlag(0);
                gloForm.setBlacklistIp(gloIpForm.getBlacklistIp());
                gloForm.setMask(gloIpForm.getIntMask());
                gloForm.setStartIp(IPUtil.getSubnetRange((String)gloIpForm.getBlacklistIp(), (int)gloIpForm.getIntMask())[0]);
                gloForm.setEndIp(IPUtil.getSubnetRange((String)gloIpForm.getBlacklistIp(), (int)gloIpForm.getIntMask())[1]);
                gloForm.setDeviceId(String.valueOf(deviceId));
                subList.add(gloForm);
                gloIpForm.setGloBlackListForms(subList);
            } else if (gloIpForm.getMaskType() == 1) {
                String[] networkSegment;
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setStartIp(gloIpForm.getStartIp());
                gloIpForm.setEndIp(gloIpForm.getEndIp());
                gloIpForm.setDeleteFlag(0);
                try {
                    networkSegment = IPUtil.getNetworkSegment((String)gloIpForm.getStartIp(), (String)gloIpForm.getEndIp());
                }
                catch (Exception e) {
                    networkSegment = new String[]{};
                }
                for (int i = 0; i < networkSegment.length; ++i) {
                    GloBlackListForm gloForm = new GloBlackListForm();
                    String ipAndMask = networkSegment[i];
                    String[] ipMask = ipAndMask.split("/");
                    gloForm.setBlacklistIp(ipMask[0]);
                    gloForm.setMask(Integer.valueOf(ipMask[1]));
                    gloForm.setDeviceId(String.valueOf(deviceId));
                    subList.add(gloForm);
                }
                gloIpForm.setGloBlackListForms(subList);
            }
            this.saveBlackListIp(gloIpForm);
        }
    }

    @Override
    public GloBlackListIpForm findByIpListId(Long id) {
        GloBlackListIpInfo gloInfo = this.gBlackListDAO.getIpList(id);
        GloBlackListIpForm form = new GloBlackListIpForm();
        if (gloInfo != null) {
            form.setBlacklistIp(gloInfo.getBlacklistIp());
            form.setDeviceId(Long.valueOf(gloInfo.getDeviceId()));
            form.setIntMask(gloInfo.getIntMask());
            form.setMaskType(gloInfo.getMaskType());
            form.setDeleteFlag(gloInfo.getDeleteFlag());
            form.setStartIp(gloInfo.getStartIp());
            form.setEndIp(gloInfo.getEndIp());
            form.setPkid(gloInfo.getPkid());
            this.logger.info((Object)("find IpBlacklist by id : " + id));
        } else {
            this.logger.error((Object)"findByIpListId : gloInfo is null");
        }
        return form;
    }

    @Override
    public void deleteUndoData(GloBlackListForm form) {
        GloBlackListInfo info = new GloBlackListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gBlackListDAO.deleteNewFlagData(form.getId());
        this.gBlackListDAO.clearIpListData(form.getId());
    }

    @Override
    public BatchOperationResult batchDelAllGloBlackList2(String deviceid) {
        this.gBlackListDAO.clearAllIpsubListData(deviceid);
        this.gBlackListDAO.clearAllIpListData(deviceid);
        this.gBlackListDAO.updateFlagByDeviceId(deviceid);
        return null;
    }

    @Override
    public void respondMsgDelDevice(List<Long> deviceIds) {
        for (Long deviceId : deviceIds) {
            this.gWhiteListDAO.clearAllIpListData(String.valueOf(deviceId));
            this.gWhiteListDAO.clearAllListData(String.valueOf(deviceId));
        }
    }
}

