/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.neglobal.dao.GloCdnIpListDao;
import com.hs.vsm.secservice.neglobal.model.GloCdnIpListInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloCdnIpListService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GloCdnIpListServiceImpl
implements IGloCdnIpListService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private GloCdnIpListDao gloCdnIpListDao;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"cdnipList enter queryByPage");
        String ipAddress = queryMap.get("ipAddress");
        String deviceId = queryMap.get("deviceId");
        List list = null;
        Paging page = new Paging();
        if (!AticUtil.isNull((String)ipAddress) && !AticUtil.isNull((String)deviceId)) {
            list = this.gloCdnIpListDao.getByIp(deviceId);
        } else {
            page = this.gloCdnIpListDao.queryByPage(queryMap, start, pageSize);
            list = page.getData();
        }
        ArrayList<GloCdnIpListForm> formList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListInfo gloCdnIpListInfo : list) {
            GloCdnIpListForm form = new GloCdnIpListForm();
            AticUtil.copyProperties((Object)gloCdnIpListInfo, (Object)form);
            if (AticUtil.isNull((String)ipAddress)) {
                formList.add(form);
                continue;
            }
            String[] ipRange = new String[]{form.getStartIp(), form.getEndIp()};
            if (!IPUtil.isInIpRange((String[])ipRange, (String)ipAddress)) continue;
            formList.add(form);
            page.setCount(1);
        }
        page.setData(formList);
        this.logger.info((Object)("cdnipList leave queryByPage" + formList.size()));
        return page;
    }

    @Override
    public void saveGloCdnIpList(GloCdnIpListForm gloCdnIpListForm) {
        GloCdnIpListInfo gloCdnIpListInfo = (GloCdnIpListInfo)AticUtil.copyProperties((Object)gloCdnIpListForm, (Object)new GloCdnIpListInfo());
        this.gloCdnIpListDao.saveOrUpdate(gloCdnIpListInfo);
    }

    @Override
    public List<GloCdnIpListForm> findExistIp(String ip, String deviceId) {
        List<GloCdnIpListInfo> cdnIpListInfos = this.gloCdnIpListDao.getByIp(ip, deviceId);
        if (cdnIpListInfos.isEmpty()) {
            return null;
        }
        ArrayList<GloCdnIpListForm> formList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListInfo gloCdnIpListInfo : cdnIpListInfos) {
            GloCdnIpListForm form = new GloCdnIpListForm();
            AticUtil.copyProperties((Object)gloCdnIpListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloCdnIpListForm> findExistIp(String startIp, String endIp, String deviceId) {
        List<GloCdnIpListInfo> cdnIpListInfos = this.gloCdnIpListDao.getByIp(deviceId);
        if (cdnIpListInfos.isEmpty()) {
            return null;
        }
        ArrayList<GloCdnIpListForm> formList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListInfo gloCdnIpListInfo : cdnIpListInfos) {
            GloCdnIpListForm form = new GloCdnIpListForm();
            AticUtil.copyProperties((Object)gloCdnIpListInfo, (Object)form);
            String[] ipRange1 = new String[]{form.getStartIp(), form.getEndIp()};
            String[] ipRange2 = new String[]{startIp, endIp};
            if (!IPUtil.isInIpRange((String[])ipRange1, (String)startIp) && !IPUtil.isInIpRange((String[])ipRange1, (String)endIp) && !IPUtil.isInIpRange((String[])ipRange2, (String)form.getStartIp()) && !IPUtil.isInIpRange((String[])ipRange2, (String)form.getEndIp())) continue;
            formList.add(form);
        }
        return formList;
    }

    @Override
    public int queryCountCdnIpByDeviceId(Long deviceId) {
        return this.gloCdnIpListDao.queryCountByDeviceId(deviceId);
    }

    @Override
    public BatchOperationResult batchDelGloCdnIpList(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            return result;
        }
        if (!boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                try {
                    GloCdnIpListForm gloCdnIpListForm = this.findById(bo.getTargetId());
                    if (null == gloCdnIpListForm) {
                        this.logger.error((Object)("dmake deltetFlag IpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(570699L);
                        continue;
                    }
                    String para = "";
                    para = 0 == gloCdnIpListForm.getMaskType() ? gloCdnIpListForm.getIpAddress() + "/" + gloCdnIpListForm.getMask() : gloCdnIpListForm.getStartIp() + "-" + gloCdnIpListForm.getEndIp();
                    if ("SUCCESS".equals(gloCdnIpListForm.getDeployState())) {
                        this.updateFlagById(bo.getTargetId());
                    } else {
                        this.gloCdnIpListDao.deleteCdnIpById(bo.getTargetId());
                    }
                    bo.setOptDetail("com.hs.vsm.secservice.neglobal.proxyIpList.ip.oplog.del");
                    bo.setDetailParam(new String[]{para});
                    this.logger.info((Object)("dmake deltetFlag CdnIplist : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570700L);
                    this.logger.error((Object)("dmake deltetFlag IpBlacklist : " + this.getcleanedMessage(bo.getTargetName()) + " failed. " + e.getMessage()));
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete cdnIpList result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public void updateFlagById(Long id) {
        this.gloCdnIpListDao.updateFlag(id);
    }

    @Override
    public GloCdnIpListForm findById(Long id) {
        GloCdnIpListInfo gloInfo = this.gloCdnIpListDao.get(id);
        GloCdnIpListForm form = (GloCdnIpListForm)AticUtil.copyProperties((Object)gloInfo, (Object)new GloCdnIpListForm());
        this.logger.info((Object)("find cdnIp by id : " + id));
        return form;
    }

    @Override
    public BatchOperationResult delAllGloCdnIpList(String deviceId) {
        this.gloCdnIpListDao.clearAllIpListData(Long.valueOf(deviceId));
        this.gloCdnIpListDao.updateFlagByDeviceId(Long.valueOf(deviceId));
        return null;
    }

    @Override
    public List<GloCdnIpListForm> initDeployData(Long deviceId) {
        this.logger.info((Object)"enter initDeployData");
        List<GloCdnIpListInfo> infos = this.gloCdnIpListDao.initDeployData(String.valueOf(deviceId));
        ArrayList<GloCdnIpListForm> formList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListInfo gloCdnIpListInfo : infos) {
            GloCdnIpListForm form = new GloCdnIpListForm();
            AticUtil.copyProperties((Object)gloCdnIpListInfo, (Object)form);
            formList.add(form);
        }
        this.logger.info((Object)"leave initDeployData");
        return formList;
    }

    @Override
    public List<GloCdnIpListForm> initUndoDeployData(Long deviceId) {
        this.logger.info((Object)"enter initDeployData");
        List<GloCdnIpListInfo> infos = this.gloCdnIpListDao.initUndoDeployData(String.valueOf(deviceId));
        ArrayList<GloCdnIpListForm> formList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListInfo gloBlackListInfo : infos) {
            GloCdnIpListForm form = new GloCdnIpListForm();
            AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
            formList.add(form);
        }
        this.logger.info((Object)"leave initDeployData");
        return formList;
    }

    @Override
    public void updateDeployStatus(GloCdnIpListForm form) {
        this.logger.info((Object)"enter update");
        GloCdnIpListInfo info = new GloCdnIpListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gloCdnIpListDao.update(info);
        this.logger.info((Object)"leave update");
    }

    @Override
    public void deleteUndoDeployData(GloCdnIpListForm form) {
        this.logger.info((Object)"enter update");
        this.gloCdnIpListDao.deleteFlagData(form.getPkid());
        this.logger.info((Object)"leave update");
    }

    @Override
    public List<GloCdnIpListInfo> queryByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloCdnIpListInfo> list = this.gloCdnIpListDao.queryByDeviceId(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloCdnIpListForm> getByIdList(String ids) {
        List<GloCdnIpListInfo> gloCdnIpListInfos = this.gloCdnIpListDao.getByIpLists(ids);
        ArrayList<GloCdnIpListForm> formList = new ArrayList<GloCdnIpListForm>();
        for (GloCdnIpListInfo gloCdnIpListInfo : gloCdnIpListInfos) {
            GloCdnIpListForm form = new GloCdnIpListForm();
            AticUtil.copyProperties((Object)gloCdnIpListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public BatchOperationResult importSaveCdnIpList(List<BatchOperation> batchOpList, String deviceId) {
        this.logger.info((Object)"entry importSaveCdnIpList()");
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
        this.importBaseCheck(batchOpList, frontOperationList, deviceId);
        result.setResult(frontOperationList);
        result.setFailCount(frontOperationList.size());
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - frontOperationList.size());
        return result;
    }

    private void importBaseCheck(List<BatchOperation> batchOpList, List<BatchOperation> frontOperationList, String deviceId) {
        int count = this.gloCdnIpListDao.queryCountByDeviceId(Long.valueOf(deviceId));
        List<GloCdnIpListInfo> gloCdnIpListInfos = this.gloCdnIpListDao.getByIp(deviceId);
        for (BatchOperation bo : batchOpList) {
            GloCdnIpListInfo gloCdnIpListInfo = new GloCdnIpListInfo();
            String[] datas = bo.getOptDetail().split(",");
            String ipStr = datas[0];
            if (ipStr.contains("/")) {
                String[] ipString = ipStr.split("/");
                String ipAddress = ipString[0];
                String intMask = ipString[1];
                if (!IPUtil.isIpv4((String)ipAddress)) {
                    bo.setErrorCode(570811L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    this.logger.error((Object)"ipNewBlacklist data ipformat error:IP format error.");
                    continue;
                }
                if (!IPUtil.isIpv4((String)ipAddress)) continue;
                if (Long.parseLong(intMask) < 8L || Long.parseLong(intMask) > 32L) {
                    bo.setErrorCode(570812L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    continue;
                }
                gloCdnIpListInfo.setMaskType(0);
                gloCdnIpListInfo.setDeviceId(Long.valueOf(deviceId));
                gloCdnIpListInfo.setIpAddress(ipAddress);
                gloCdnIpListInfo.setMask(Integer.valueOf(intMask));
                String[] subNetRange = IPUtil.getSubnetRange((String)gloCdnIpListInfo.getIpAddress(), (int)gloCdnIpListInfo.getMask());
                gloCdnIpListInfo.setStartIp(subNetRange[0]);
                gloCdnIpListInfo.setEndIp(subNetRange[1]);
                gloCdnIpListInfo.setDeleteFlag(false);
                gloCdnIpListInfo.setDeployState("UNDEPLOY");
                if (count >= 256) {
                    bo.setErrorCode(570815L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    continue;
                }
                ArrayList<GloCdnIpListInfo> infos = new ArrayList<GloCdnIpListInfo>();
                for (GloCdnIpListInfo info : gloCdnIpListInfos) {
                    String[] ipRange = new String[]{info.getStartIp(), info.getEndIp()};
                    if (!IPUtil.isInIpRange((String[])ipRange, (String)gloCdnIpListInfo.getStartIp()) && !IPUtil.isInIpRange((String[])ipRange, (String)gloCdnIpListInfo.getEndIp())) continue;
                    infos.add(info);
                }
                if (infos.isEmpty()) {
                    this.gloCdnIpListDao.saveOrUpdate(gloCdnIpListInfo);
                    gloCdnIpListInfos.add(gloCdnIpListInfo);
                    ++count;
                    continue;
                }
                bo.setErrorCode(570813L);
                bo.setTargetName(ipStr);
                frontOperationList.add(bo);
                continue;
            }
            bo.setErrorCode(570811L);
            bo.setTargetName(ipStr);
            frontOperationList.add(bo);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public GloCdnIpListDao getGloCdnIpListDao() {
        return this.gloCdnIpListDao;
    }

    public void setGloCdnIpListDao(GloCdnIpListDao gloCdnIpListDao) {
        this.gloCdnIpListDao = gloCdnIpListDao;
    }
}

