/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.neglobal.dao.GloBlackListDAO;
import com.hs.vsm.secservice.neglobal.dao.GloWhiteListDAO;
import com.hs.vsm.secservice.neglobal.model.GloBlackListInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListIpInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GloWhiteListServiceImpl
implements IGloWhiteListService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private GloWhiteListDAO gWhiteListDAO;
    private GloBlackListDAO gBlackListDAO;
    private AticDeviceDao aticDeviceDao;

    public GloWhiteListDAO getgWhiteListDAO() {
        return this.gWhiteListDAO;
    }

    public void setgWhiteListDAO(GloWhiteListDAO gWhiteListDAOs) {
        this.gWhiteListDAO = gWhiteListDAOs;
    }

    public GloBlackListDAO getgBlackListDAO() {
        return this.gBlackListDAO;
    }

    public void setgBlackListDAO(GloBlackListDAO gBlackListDAOs) {
        this.gBlackListDAO = gBlackListDAOs;
    }

    @Override
    public BatchOperationResult batchDelGloWhiteList(List<BatchOperation> gloList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == gloList) {
            return result;
        }
        if (!gloList.isEmpty()) {
            for (BatchOperation bo : gloList) {
                try {
                    GloWhiteListForm gloWhiteListIpForm = this.findById(bo.getTargetId());
                    if (null == gloWhiteListIpForm) {
                        this.logger.error((Object)(" make deltetFlag IpWhitelist : " + GloWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(570704L);
                        continue;
                    }
                    String[] detailPara = null;
                    detailPara = new String[]{gloWhiteListIpForm.getWhitelistIp()};
                    this.updateFlag(bo.getTargetId());
                    bo.setOptDetail("com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.del");
                    bo.setDetailParam(detailPara);
                    this.logger.info((Object)("make deltetFlag IpWhitelist : " + GloWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570700L);
                    this.logger.error((Object)("make deltetFlag IpWhitelist : " + GloWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed. " + e.getMessage()));
                }
            }
        }
        result.setResult(gloList);
        result.setFailCount(fail);
        result.setTotalCount(gloList.size());
        result.setSucceedCount(gloList.size() - fail);
        this.logger.info((Object)("batch make deltetFlag IpWhitelist result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public void delById(Long id) {
        this.gWhiteListDAO.remove(id);
    }

    @Override
    public void updateFlag(Long id) {
        this.gWhiteListDAO.updateFlag(id);
    }

    @Override
    public GloWhiteListForm findById(Long id) {
        GloWhiteListInfo gloInfo = this.gWhiteListDAO.get(id);
        GloWhiteListForm form = (GloWhiteListForm)AticUtil.copyProperties((Object)gloInfo, (Object)new GloWhiteListForm());
        this.logger.info((Object)("find IpWhitelist by id : " + id));
        return form;
    }

    @Override
    public List<GloWhiteListForm> findEditExistIp(String whitelistIp, Long id) {
        List<GloWhiteListInfo> gloWhiteListInfos = this.gWhiteListDAO.getByIpAndId(whitelistIp, id);
        if (gloWhiteListInfos.isEmpty()) {
            return null;
        }
        ArrayList<GloWhiteListForm> formList = new ArrayList<GloWhiteListForm>();
        for (GloWhiteListInfo gloWhiteListInfo : gloWhiteListInfos) {
            GloWhiteListForm form = new GloWhiteListForm();
            AticUtil.copyProperties((Object)gloWhiteListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloWhiteListForm> findExistIp(String whitelistIp, String deviceId) {
        List<GloWhiteListInfo> whitelistips = this.gWhiteListDAO.getByIp(whitelistIp, deviceId);
        if (whitelistips.isEmpty()) {
            return null;
        }
        ArrayList<GloWhiteListForm> formList = new ArrayList<GloWhiteListForm>();
        for (GloWhiteListInfo gloWhiteListInfo : whitelistips) {
            GloWhiteListForm form = new GloWhiteListForm();
            AticUtil.copyProperties((Object)gloWhiteListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloWhiteListForm> getByIds(String ids) {
        List<GloWhiteListInfo> gloWhiteListInfos = this.gWhiteListDAO.getByIds(ids);
        ArrayList<GloWhiteListForm> formList = new ArrayList<GloWhiteListForm>();
        for (GloWhiteListInfo gloWhiteListInfo : gloWhiteListInfos) {
            GloWhiteListForm form = new GloWhiteListForm();
            AticUtil.copyProperties((Object)gloWhiteListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"whitelist enter queryByPage");
        Paging page = this.gWhiteListDAO.queryByPage(queryMap, start, pageSize);
        List list = page.getData();
        ArrayList<GloWhiteListForm> formList = new ArrayList<GloWhiteListForm>();
        for (GloWhiteListInfo gloBlackListInfo : list) {
            GloWhiteListForm form = new GloWhiteListForm();
            AticUtil.copyProperties((Object)gloBlackListInfo, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        this.logger.info((Object)"whitelist leave queryByPage");
        return page;
    }

    @Override
    public void saveGloWhiteList(GloWhiteListForm gWhiteListForm) {
        GloWhiteListInfo gloWhiteListInfo = (GloWhiteListInfo)AticUtil.copyProperties((Object)gWhiteListForm, (Object)new GloWhiteListInfo());
        this.gWhiteListDAO.saveOrUpdate(gloWhiteListInfo);
    }

    @Override
    public void editGloWhiteList(GloWhiteListForm gWhiteListForm) {
        Long wid = gWhiteListForm.getWid();
        GloWhiteListInfo gloWhiteListInfo = new GloWhiteListInfo();
        if (null != wid) {
            gloWhiteListInfo = this.gWhiteListDAO.get(wid);
        }
        if (gloWhiteListInfo != null) {
            gloWhiteListInfo.setWhitelistIp(gWhiteListForm.getWhitelistIp());
            this.gWhiteListDAO.saveOrUpdate(gloWhiteListInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> deployWhiteList(Long deviceId) {
        GloWhiteListServiceImpl gloWhiteListServiceImpl = this;
        synchronized (gloWhiteListServiceImpl) {
            this.logger.info((Object)"enter whitelist deploy ");
            HashMap<Long, String> result = new HashMap<Long, String>();
            ArrayList<String> cmds = new ArrayList<String>();
            List<GloWhiteListForm> listForms = this.initDeployData(deviceId);
            for (GloWhiteListForm form : listForms) {
                try {
                    if (!"SUCCESS".equals(form.getDeployState())) {
                        List cmdResult;
                        cmds.add("system");
                        if ("0".equals(form.getDeleteFlag())) {
                            if (IPUtil.isIpv4((String)form.getWhitelistIp())) {
                                cmds.add("anti-ddos bypass-item ip " + form.getWhitelistIp());
                            }
                            if (IPUtil.isIpv6((String)form.getWhitelistIp())) {
                                cmds.add("anti-ddos bypass-item ipv6 " + form.getWhitelistIp());
                            }
                            cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                            cmds = new ArrayList();
                            if (AticUtil.isCmdSucess((List)cmdResult)) {
                                result.put(deviceId, "SUCCESS");
                                form.setDeployState("SUCCESS");
                                this.updateDeployStatus(form);
                            } else {
                                result.put(Long.valueOf(form.getDeviceId()), "FAIL");
                                this.logger.info((Object)("whitelistip deploy failure , failure whitelist ip :" + form.getWhitelistIp()));
                                continue;
                            }
                        }
                        if (!"1".equals(form.getDeleteFlag())) continue;
                        if (IPUtil.isIpv4((String)form.getWhitelistIp())) {
                            cmds.add("undo anti-ddos bypass-item ip " + form.getWhitelistIp());
                        }
                        if (IPUtil.isIpv6((String)form.getWhitelistIp())) {
                            cmds.add("undo anti-ddos bypass-item ipv6 " + form.getWhitelistIp());
                        }
                        cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                        cmds = new ArrayList();
                        if (!AticUtil.isCmdSucess((List)cmdResult)) continue;
                        this.deleteUndoDeployData(form);
                        continue;
                    }
                    if (!"1".equals(form.getDeleteFlag())) continue;
                    cmds.add("system");
                    if (IPUtil.isIpv4((String)form.getWhitelistIp())) {
                        cmds.add("undo anti-ddos bypass-item ip " + form.getWhitelistIp());
                    }
                    if (IPUtil.isIpv6((String)form.getWhitelistIp())) {
                        cmds.add("undo anti-ddos bypass-item ipv6 " + form.getWhitelistIp());
                    }
                    cmds = new ArrayList();
                    this.deleteUndoDeployData(form);
                }
                catch (LegoCheckedException legoExcp) {
                    result.put(deviceId, "FAIL");
                    form.setDeployState("FAIL");
                    this.updateDeployStatus(form);
                    throw legoExcp;
                }
            }
            this.logger.info((Object)"leave whitelist deploy ");
            return result;
        }
    }

    @Override
    public List<GloWhiteListForm> initDeployData(Long deviceId) {
        this.logger.info((Object)"enter initDeployData");
        List<GloWhiteListInfo> infos = this.queryByDeviceId(deviceId);
        if (infos == null) {
            infos = new ArrayList<GloWhiteListInfo>();
        }
        ArrayList<GloWhiteListForm> formList = new ArrayList<GloWhiteListForm>();
        for (GloWhiteListInfo gloWhiteListInfo : infos) {
            GloWhiteListForm form = new GloWhiteListForm();
            AticUtil.copyProperties((Object)gloWhiteListInfo, (Object)form);
            formList.add(form);
        }
        this.logger.info((Object)"leave initDeployData");
        return formList;
    }

    @Override
    public List<GloWhiteListInfo> queryByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloWhiteListInfo> list = this.gWhiteListDAO.queryByDeviceId(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloWhiteListInfo> queryByDeviceIdAndDelFlag(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloWhiteListInfo> list = this.gWhiteListDAO.queryByDeviceIdAndDeleteFlag(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloWhiteListIpInfo> findByDeviceIdAndDelFlag(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloWhiteListIpInfo> list = this.gWhiteListDAO.findByDeviceIdAndDeleteFlag(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public List<GloWhiteListInfo> queryDelFlag(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        List<GloWhiteListInfo> list = this.gWhiteListDAO.queryByDelDeviceId(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryByDeviceId");
        return list;
    }

    @Override
    public void updateDeployStatus(GloWhiteListForm form) {
        this.logger.info((Object)"enter update");
        GloWhiteListInfo info = new GloWhiteListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gWhiteListDAO.update(info);
        this.logger.info((Object)"leave update");
    }

    @Override
    public void deleteUndoDeployData(GloWhiteListForm form) {
        this.logger.info((Object)"enter update");
        GloBlackListInfo info = new GloBlackListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gWhiteListDAO.deleteFlagData(form.getWid());
        this.logger.info((Object)"leave update");
    }

    @Override
    public BatchOperationResult saveWhiteList(List<BatchOperation> batchOpList, String deviceId) {
        this.logger.info((Object)"entry saveImportWhiteList()");
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<GloWhiteListInfo> needSaveDataList = new ArrayList<GloWhiteListInfo>();
        List<GloBlackListInfo> bList = this.gBlackListDAO.queryAllBlacklists(deviceId);
        List<GloWhiteListInfo> wList = this.gWhiteListDAO.queryAllWhitelists(deviceId);
        boolean isCheckStandard = this.isStandard(bList, wList, batchOpList.size(), deviceId);
        int fail = 0;
        for (BatchOperation bo : batchOpList) {
            String[] datas = bo.getOptDetail().split(",");
            if (!IPUtil.isIpv4((String)datas[0].trim()) && !IPUtil.isIpv6((String)datas[0].trim())) {
                ++fail;
                bo.setErrorCode(570705L);
                bo.setTargetName(datas[0].trim());
                this.logger.error((Object)("ipWhitelist data ipformat error:" + datas[0]));
                continue;
            }
            if (this.isExistWhiteList(wList, datas[0])) {
                ++fail;
                bo.setTargetName(datas[0].trim());
                bo.setErrorCode(570707L);
                continue;
            }
            if (this.isExistBlackList(bList, datas[0])) {
                ++fail;
                bo.setTargetName(datas[0].trim());
                bo.setErrorCode(570706L);
                continue;
            }
            if (needSaveDataList.isEmpty() && this.isExistWhiteList(needSaveDataList, datas[0])) {
                ++fail;
                bo.setTargetName(datas[0].trim());
                bo.setErrorCode(570710L);
                continue;
            }
            if (isCheckStandard && this.isStandard(bList, wList, needSaveDataList.size(), deviceId)) {
                ++fail;
                bo.setTargetName("com.hs.vsm.secservice.neglobal.import.bwlist.excced");
                bo.setErrorCode(731043L);
                break;
            }
            GloWhiteListInfo gloInfo = new GloWhiteListInfo();
            try {
                gloInfo.setDeviceId(deviceId);
                gloInfo.setWhitelistIp(datas[0].trim());
                gloInfo.setDeployState("UNDEPLOY");
                gloInfo.setDeleteFlag("0");
                needSaveDataList.add(gloInfo);
            }
            catch (RuntimeException e) {
                ++fail;
                bo.setTargetName(gloInfo.getWhitelistIp());
                bo.setErrorCode(570707L);
            }
        }
        for (GloWhiteListInfo gloInfo : needSaveDataList) {
            this.gWhiteListDAO.saveOrUpdate(gloInfo);
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - fail);
        this.logger.info((Object)"leave saveImportWhiteList()");
        return result;
    }

    private boolean isExistBlackList(List<GloBlackListInfo> bList, String ip) {
        if (null != bList && !bList.isEmpty()) {
            for (GloBlackListInfo bInfo : bList) {
                if (!ip.trim().equals(bInfo.getBlacklistIp())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExistWhiteList(List<GloWhiteListInfo> wList, String ip) {
        if (null != wList && !wList.isEmpty()) {
            for (GloWhiteListInfo wInfo : wList) {
                if (!ip.trim().equals(wInfo.getWhitelistIp())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStandard(List<GloBlackListInfo> bList, List<GloWhiteListInfo> wList, int num, String deviceId) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(Long.parseLong(deviceId));
        boolean flag = false;
        if (aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc500") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc600") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc700") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc800") || aticDevice.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc900")) {
            if (null != bList || null != wList) {
                if (null != bList && null == wList) {
                    if (bList.size() >= 20000 - num) {
                        flag = true;
                    }
                } else if (null == bList && null != wList) {
                    if (wList.size() >= 20000 - num) {
                        flag = true;
                    }
                } else if (null != bList && null != wList && bList.size() + wList.size() >= 20000 - num) {
                    flag = true;
                }
            }
        } else if (null != bList || null != wList) {
            if (null != bList && null == wList) {
                if (bList.size() >= 40960 - num) {
                    flag = true;
                }
            } else if (null == bList && null != wList) {
                if (wList.size() >= 40960 - num) {
                    flag = true;
                }
            } else if (null != bList && null != wList && bList.size() + wList.size() >= 40960 - num) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public List<GloWhiteListInfo> queryAllWhiteLists(Long deviceId) {
        this.logger.info((Object)"enter queryAllWhiteLists");
        List<GloWhiteListInfo> list = this.gWhiteListDAO.queryAllWhitelists(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave queryAllWhiteLists");
        return list;
    }

    @Override
    public int queryAllWhiteCount(Long deviceId) {
        this.logger.info((Object)("enter queryAllWhiteCount by deviceId :" + deviceId));
        return this.gWhiteListDAO.queryAllWhiteCount(String.valueOf(deviceId));
    }

    @Override
    public BatchOperationResult batchDelGloWhiteList2(List<BatchOperation> gloList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == gloList) {
            return result;
        }
        if (!gloList.isEmpty()) {
            for (BatchOperation bo : gloList) {
                try {
                    GloWhiteListIpForm gloWhiteListIpForm = this.findByIpListId(bo.getTargetId());
                    String[] detailPara = null;
                    detailPara = gloWhiteListIpForm.getMaskType() == 1 ? new String[]{gloWhiteListIpForm.getStartIp() + "-" + gloWhiteListIpForm.getEndIp()} : new String[]{gloWhiteListIpForm.getWhitelistIp() + "/" + gloWhiteListIpForm.getIntMask()};
                    this.deleteIpAdd(bo.getTargetId());
                    bo.setOptDetail("com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.del");
                    bo.setDetailParam(detailPara);
                    this.logger.info((Object)("make deltetFlag newIpWhitelist : " + GloWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570700L);
                    this.logger.error((Object)("make deltetFlag newIpWhitelist : " + GloWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed. " + e.getMessage()));
                }
            }
        }
        result.setResult(gloList);
        result.setFailCount(fail);
        result.setTotalCount(gloList.size());
        result.setSucceedCount(gloList.size() - fail);
        this.logger.info((Object)("batch delete newIpWhitelist result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    public List<GloWhiteListIpForm> getByWIpId(String ids) {
        List<GloWhiteListIpInfo> gloWhiteListInfos = this.gWhiteListDAO.getByIpLists(ids);
        ArrayList<GloWhiteListIpForm> formList = new ArrayList<GloWhiteListIpForm>();
        for (GloWhiteListIpInfo gloWhiteListInfo : gloWhiteListInfos) {
            GloWhiteListIpForm form = new GloWhiteListIpForm();
            form.setMaskType(gloWhiteListInfo.getMaskType());
            form.setWhitelistIp(gloWhiteListInfo.getWhitelistIp());
            form.setIntMask(gloWhiteListInfo.getIntMask());
            form.setStartIp(gloWhiteListInfo.getStartIp());
            form.setEndIp(gloWhiteListInfo.getEndIp());
            formList.add(form);
        }
        return formList;
    }

    @Override
    public void deleteWhiteListIp(Long pkid) {
        this.deleteIpAdd(pkid);
    }

    private void deleteIpAdd(Long pkid) {
        List<GloWhiteListInfo> gloListInfos = this.gWhiteListDAO.findUndeploy(pkid);
        int count = 0;
        if (null != gloListInfos && !gloListInfos.isEmpty()) {
            for (GloWhiteListInfo gloInfo : gloListInfos) {
                if (!"SUCCESS".equals(gloInfo.getDeployState())) {
                    this.gWhiteListDAO.clearIpsubListData(pkid);
                    if (++count != gloListInfos.size()) continue;
                    this.gWhiteListDAO.clearIpListData(pkid);
                    continue;
                }
                this.gWhiteListDAO.updateNewFlag(pkid);
                this.gWhiteListDAO.updateIpListFlag(pkid);
            }
        }
    }

    @Override
    public List<GloWhiteListIpForm> getByIdList(String ids) {
        List<GloWhiteListIpInfo> gloWhiteListIpInfos = this.gWhiteListDAO.getByIpLists(ids);
        ArrayList<GloWhiteListIpForm> formList = new ArrayList<GloWhiteListIpForm>();
        for (GloWhiteListIpInfo gloBlackListInfo : gloWhiteListIpInfos) {
            GloWhiteListIpForm form = new GloWhiteListIpForm();
            form.setMaskType(gloBlackListInfo.getMaskType());
            form.setWhitelistIp(gloBlackListInfo.getWhitelistIp());
            form.setIntMask(gloBlackListInfo.getIntMask());
            form.setStartIp(gloBlackListInfo.getStartIp());
            form.setEndIp(gloBlackListInfo.getEndIp());
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloWhiteListIpInfo> queryAllWhitelist(Long deviceId) {
        List<GloWhiteListIpInfo> list = this.gWhiteListDAO.queryAllIpList(deviceId);
        if (null == list) {
            return null;
        }
        return list;
    }

    @Override
    public Paging queryByPageNew(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"newWhiteIplist enter queryByPage");
        Paging page = this.gWhiteListDAO.queryByPageNew(queryMap, start, pageSize);
        if (null != page) {
            List ipList = page.getData();
            ArrayList<GloWhiteListIpForm> formList = new ArrayList<GloWhiteListIpForm>();
            for (GloWhiteListIpInfo gloIpInfo : ipList) {
                GloWhiteListIpForm form = new GloWhiteListIpForm();
                form.setDeviceId(Long.valueOf(gloIpInfo.getDeviceId()));
                form.setPkid(gloIpInfo.getPkid());
                form.setStartIp(gloIpInfo.getStartIp());
                form.setEndIp(gloIpInfo.getEndIp());
                form.setWhitelistIp(gloIpInfo.getWhitelistIp());
                form.setIntMask(gloIpInfo.getIntMask());
                form.setMaskType(gloIpInfo.getMaskType());
                formList.add(form);
            }
            page.setData(formList);
        } else {
            page = new Paging();
            this.logger.error((Object)"page is null");
        }
        return page;
    }

    @Override
    public void saveWhiteListIp(GloWhiteListIpForm gloIpForm) {
        Long pkid = this.saveWhiteIpLists(gloIpForm);
        this.saveWhiteListIpAdds(gloIpForm.getGloWhiteListForms(), gloIpForm, pkid);
    }

    private Long saveWhiteIpLists(GloWhiteListIpForm gloIpForm) {
        GloWhiteListIpInfo gloIpInfo = new GloWhiteListIpInfo();
        gloIpInfo.setDeviceId(String.valueOf(gloIpForm.getDeviceId()));
        gloIpInfo.setWhitelistIp(gloIpForm.getWhitelistIp());
        gloIpInfo.setIntMask(gloIpForm.getIntMask());
        gloIpInfo.setStartIp(gloIpForm.getStartIp());
        gloIpInfo.setEndIp(gloIpForm.getEndIp());
        gloIpInfo.setMaskType(gloIpForm.getMaskType());
        gloIpInfo.setDeleteFlag(gloIpForm.getDeleteFlag());
        return (Long)this.gWhiteListDAO.save(gloIpInfo);
    }

    private void saveWhiteListIpAdds(List<GloWhiteListForm> gloListForms, GloWhiteListIpForm gloListIpForm, Long pkid) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)gloListIpForm.getStartIp());
        String endIp = IPUtil4Atic.convert2CompleteIp((String)gloListIpForm.getEndIp());
        if (null != gloListForms && !gloListForms.isEmpty()) {
            for (GloWhiteListForm gloForm : gloListForms) {
                GloWhiteListInfo gloWhiteListInfo = new GloWhiteListInfo();
                gloForm.setId(pkid);
                gloForm.setDeviceId(String.valueOf(gloListIpForm.getDeviceId()));
                gloForm.setStartIp(startIp);
                gloForm.setEndIp(endIp);
                AticUtil.copyProperties((Object)gloForm, (Object)gloWhiteListInfo);
                this.gWhiteListDAO.saveOrUpdate(gloWhiteListInfo);
            }
        }
    }

    @Override
    public BatchOperationResult importSaveNewWhiteList(List<BatchOperation> batchOpList, String deviceId) {
        this.logger.info((Object)"entry importSaveNewWhitekList()");
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
        ArrayList<GloWhiteListIpForm> baseCheckDataListIpv4 = new ArrayList<GloWhiteListIpForm>();
        ArrayList<GloWhiteListIpForm> baseCheckDataListIpv6 = new ArrayList<GloWhiteListIpForm>();
        this.importBaseCheck(batchOpList, frontOperationList, deviceId, baseCheckDataListIpv4, baseCheckDataListIpv6);
        ArrayList<GloWhiteListIpForm> selfCheckDataListIpv4 = new ArrayList<GloWhiteListIpForm>();
        ArrayList<GloWhiteListIpForm> selfCheckDataListIpv6 = new ArrayList<GloWhiteListIpForm>();
        this.selfCheckIpV4(selfCheckDataListIpv4, baseCheckDataListIpv4, frontOperationList);
        this.selfCheckIpV6(selfCheckDataListIpv6, baseCheckDataListIpv6, frontOperationList);
        List<GloWhiteListIpForm> wListIp = this.gWhiteListDAO.queryAllIp(Long.valueOf(deviceId));
        ArrayList<GloWhiteListIpForm> wListIpV4 = new ArrayList<GloWhiteListIpForm>();
        ArrayList<GloWhiteListIpForm> wListIpV6 = new ArrayList<GloWhiteListIpForm>();
        this.ipWhilteTypeGroup(wListIp, wListIpV4, wListIpV6);
        ArrayList<GloWhiteListIpForm> errorIpV4List = new ArrayList<GloWhiteListIpForm>();
        ArrayList<GloWhiteListIpForm> errorIpV6List = new ArrayList<GloWhiteListIpForm>();
        this.wListIpV4Compar(wListIpV4, selfCheckDataListIpv4, errorIpV4List, frontOperationList);
        ArrayList<GloWhiteListIpForm> needRemoveIpV4List = new ArrayList<GloWhiteListIpForm>();
        if (!selfCheckDataListIpv4.isEmpty()) {
            for (GloWhiteListIpForm gloWhiteListIpForm : selfCheckDataListIpv4) {
                for (GloWhiteListIpForm gloWhiteListIpForm2 : errorIpV4List) {
                    if (null == gloWhiteListIpForm || null == gloWhiteListIpForm2 || !gloWhiteListIpForm.getStartIp().equals(gloWhiteListIpForm2.getStartIp())) continue;
                    needRemoveIpV4List.add(gloWhiteListIpForm);
                }
            }
            if (!needRemoveIpV4List.isEmpty()) {
                selfCheckDataListIpv4.removeAll(needRemoveIpV4List);
            }
        }
        this.wListIpV6Compar(wListIpV6, selfCheckDataListIpv6, errorIpV6List, frontOperationList);
        ArrayList<GloWhiteListIpForm> needRemoveIpV6List = new ArrayList<GloWhiteListIpForm>();
        if (!selfCheckDataListIpv6.isEmpty()) {
            for (GloWhiteListIpForm gloIpForm : selfCheckDataListIpv6) {
                for (GloWhiteListIpForm gloIpForm2 : errorIpV6List) {
                    if (null == gloIpForm || null == gloIpForm2 || !gloIpForm.getStartIp().equals(gloIpForm2.getStartIp())) continue;
                    needRemoveIpV6List.add(gloIpForm);
                }
            }
            if (!needRemoveIpV6List.isEmpty()) {
                selfCheckDataListIpv6.removeAll(needRemoveIpV6List);
            }
        }
        List<GloBlackListIpForm> list = this.gBlackListDAO.queryAllIp(Long.valueOf(deviceId));
        ArrayList<GloBlackListIpForm> bListIpV4 = new ArrayList<GloBlackListIpForm>();
        ArrayList<GloBlackListIpForm> arrayList = new ArrayList<GloBlackListIpForm>();
        this.ipBlackTypeGroup(list, bListIpV4, arrayList);
        ArrayList<GloWhiteListIpForm> errorBlacklistIpV4List = new ArrayList<GloWhiteListIpForm>();
        ArrayList<GloWhiteListIpForm> errorBlacklistIpV6List = new ArrayList<GloWhiteListIpForm>();
        this.bListIpV4Compar(bListIpV4, selfCheckDataListIpv4, errorBlacklistIpV4List, frontOperationList);
        ArrayList<GloWhiteListIpForm> needRemoveBlacklistIpV4List = new ArrayList<GloWhiteListIpForm>();
        if (!selfCheckDataListIpv4.isEmpty()) {
            for (GloWhiteListIpForm gloWhiteListIpForm : selfCheckDataListIpv4) {
                for (GloWhiteListIpForm gloWhiteListIpForm3 : errorBlacklistIpV4List) {
                    if (null == gloWhiteListIpForm || null == gloWhiteListIpForm3 || !gloWhiteListIpForm.getStartIp().equals(gloWhiteListIpForm3.getStartIp())) continue;
                    needRemoveBlacklistIpV4List.add(gloWhiteListIpForm);
                }
            }
            if (!needRemoveBlacklistIpV4List.isEmpty()) {
                selfCheckDataListIpv4.removeAll(needRemoveBlacklistIpV4List);
            }
        }
        this.bListIpV6Compar(arrayList, selfCheckDataListIpv6, errorBlacklistIpV6List, frontOperationList);
        ArrayList<GloWhiteListIpForm> needRemoveBlacklistIpV6List = new ArrayList<GloWhiteListIpForm>();
        if (!selfCheckDataListIpv6.isEmpty()) {
            for (GloWhiteListIpForm gloIpForm : selfCheckDataListIpv6) {
                for (GloWhiteListIpForm gloIpForm2 : errorBlacklistIpV6List) {
                    if (null == gloIpForm || null == gloIpForm2 || !gloIpForm.getStartIp().equals(gloIpForm2.getStartIp())) continue;
                    needRemoveBlacklistIpV6List.add(gloIpForm);
                }
            }
            if (!needRemoveBlacklistIpV6List.isEmpty()) {
                selfCheckDataListIpv6.removeAll(needRemoveBlacklistIpV6List);
            }
        }
        if (!selfCheckDataListIpv4.isEmpty()) {
            this.saveImportData(selfCheckDataListIpv4, deviceId);
        }
        if (!selfCheckDataListIpv6.isEmpty()) {
            this.saveImportData(selfCheckDataListIpv6, deviceId);
        }
        ArrayList<BatchOperation> arrayList2 = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : frontOperationList) {
            arrayList2.add(batchOperation);
        }
        result.setResult(arrayList2);
        result.setFailCount(arrayList2.size());
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - arrayList2.size());
        this.logger.info((Object)"leave importSaveNewWhiteList()");
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void importBaseCheck(List<BatchOperation> batchOpList, List<BatchOperation> frontOperationList, String deviceId, List<GloWhiteListIpForm> baseCheckDataListIpv4, List<GloWhiteListIpForm> baseCheckDataListIpv6) {
        Iterator<BatchOperation> iterator = batchOpList.iterator();
        while (iterator.hasNext()) {
            String[] ipString;
            BatchOperation bo = iterator.next();
            GloWhiteListIpForm gloIpForm = new GloWhiteListIpForm();
            String[] datas = bo.getOptDetail().split(",");
            String ipStr = datas[0];
            if (ipStr.contains("/")) {
                String[] subNetRange;
                ipString = ipStr.split("/");
                String ipAddress = ipString[0].trim();
                String intMask = ipString[1].trim();
                if (!IPUtil.isIpv4((String)ipAddress) && !IPUtil.isIpv6((String)ipAddress)) {
                    bo.setErrorCode(570705L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    this.logger.error((Object)"ipNewWhitelist data ipformat error : ipv4 or ipv6 format error");
                    continue;
                }
                if (IPUtil.isIpv4((String)ipAddress)) {
                    if (Long.parseLong(intMask) < 8L || Long.parseLong(intMask) > 32L) {
                        bo.setErrorCode(570708L);
                        bo.setTargetName(ipStr);
                        frontOperationList.add(bo);
                        this.logger.error((Object)"ipNewWhitelist data ipformat error : ipv4 mask format error");
                        continue;
                    }
                    gloIpForm.setMaskType(0);
                    gloIpForm.setDeviceId(Long.valueOf(deviceId));
                    gloIpForm.setWhitelistIp(ipAddress);
                    gloIpForm.setIntMask(Integer.valueOf(intMask));
                    subNetRange = IPUtil.getSubnetRange((String)gloIpForm.getWhitelistIp(), (int)gloIpForm.getIntMask());
                    gloIpForm.setStartIp(subNetRange[0]);
                    gloIpForm.setEndIp(subNetRange[1]);
                    gloIpForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[0]));
                    gloIpForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[1]));
                    baseCheckDataListIpv4.add(gloIpForm);
                }
                if (!IPUtil.isIpv6((String)ipAddress)) continue;
                if (Long.parseLong(intMask) < 8L || Long.parseLong(intMask) > 128L) {
                    bo.setErrorCode(570709L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    this.logger.error((Object)"ipNewWhitelist data ipformat error : ipv6 mask format error");
                    continue;
                }
                gloIpForm.setMaskType(0);
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setWhitelistIp(ipAddress);
                gloIpForm.setIntMask(Integer.valueOf(intMask));
                subNetRange = IPUtil.getSubnetRange((String)gloIpForm.getWhitelistIp(), (int)gloIpForm.getIntMask());
                gloIpForm.setStartIp(subNetRange[0]);
                gloIpForm.setEndIp(subNetRange[1]);
                gloIpForm.setStartIpLong(1L);
                gloIpForm.setEndIpLong(1L);
                gloIpForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[0]));
                gloIpForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[1]));
                baseCheckDataListIpv6.add(gloIpForm);
                continue;
            }
            if (ipStr.contains("-")) {
                String endIp;
                String startIp;
                block14: {
                    ipString = ipStr.split("-");
                    startIp = ipString[0].trim();
                    endIp = ipString[1].trim();
                    if (IPUtil.isIpv4((String)startIp) && IPUtil.isIpv4((String)endIp)) {
                        if (IPUtil.compareTo((String)startIp, (String)endIp) == -1 || IPUtil.compareTo((String)startIp, (String)endIp) == 0) {
                            gloIpForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)startIp));
                            gloIpForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)endIp));
                            baseCheckDataListIpv4.add(gloIpForm);
                            break block14;
                        } else {
                            bo.setErrorCode(570711L);
                            bo.setTargetName(ipStr);
                            frontOperationList.add(bo);
                            continue;
                        }
                    }
                    if (IPUtil.isIpv6((String)startIp) && IPUtil.isIpv6((String)endIp)) {
                        if (IPUtil.compareTo((String)startIp, (String)endIp) == -1 || IPUtil.compareTo((String)startIp, (String)endIp) == 0) {
                            gloIpForm.setStartIpLong(1L);
                            gloIpForm.setEndIpLong(1L);
                            gloIpForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)startIp));
                            gloIpForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)endIp));
                            baseCheckDataListIpv6.add(gloIpForm);
                            break block14;
                        } else {
                            bo.setErrorCode(570711L);
                            bo.setTargetName(ipStr);
                            frontOperationList.add(bo);
                            continue;
                        }
                    }
                    bo.setErrorCode(570705L);
                    bo.setTargetName(ipStr);
                    frontOperationList.add(bo);
                    this.logger.error((Object)"ipNewWhitelist data ipformat error");
                    continue;
                }
                gloIpForm.setMaskType(1);
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setStartIp(startIp);
                gloIpForm.setEndIp(endIp);
                continue;
            }
            bo.setErrorCode(570705L);
            bo.setTargetName(ipStr);
            frontOperationList.add(bo);
        }
        return;
    }

    private void selfCheckIpV4(List<GloWhiteListIpForm> selfCheckDataListIpv4, List<GloWhiteListIpForm> baseCheckDataListIpv4, List<BatchOperation> frontOperationList) {
        if (null != baseCheckDataListIpv4 && !baseCheckDataListIpv4.isEmpty() && baseCheckDataListIpv4.size() == 1) {
            selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(0));
        }
        if (null != baseCheckDataListIpv4 && !baseCheckDataListIpv4.isEmpty() && baseCheckDataListIpv4.size() != 1) {
            Collections.sort(baseCheckDataListIpv4);
            for (int i = 0; i < baseCheckDataListIpv4.size(); ++i) {
                if (i == 0) {
                    selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(0));
                    continue;
                }
                if (baseCheckDataListIpv4.get(i).getStartIpLong() <= selfCheckDataListIpv4.get(selfCheckDataListIpv4.size() - 1).getEndIpLong()) {
                    BatchOperation bo = new BatchOperation();
                    bo.setErrorCode(570710L);
                    if (baseCheckDataListIpv4.get(i).getMaskType() == 0) {
                        bo.setTargetName(baseCheckDataListIpv4.get(i).getWhitelistIp() + "/" + baseCheckDataListIpv4.get(i).getIntMask());
                    } else {
                        bo.setTargetName(baseCheckDataListIpv4.get(i).getStartIp() + "-" + baseCheckDataListIpv4.get(i).getEndIp());
                    }
                    frontOperationList.add(bo);
                    continue;
                }
                selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(i));
            }
        }
    }

    private void selfCheckIpV6(List<GloWhiteListIpForm> selfCheckDataListIpv6, List<GloWhiteListIpForm> baseCheckDataListIpv6, List<BatchOperation> frontOperationList) {
        if (null != baseCheckDataListIpv6 && !baseCheckDataListIpv6.isEmpty() && baseCheckDataListIpv6.size() == 1) {
            selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(0));
        }
        if (null != baseCheckDataListIpv6 && !baseCheckDataListIpv6.isEmpty() && baseCheckDataListIpv6.size() != 1) {
            Collections.sort(baseCheckDataListIpv6);
            for (int i = 0; i < baseCheckDataListIpv6.size(); ++i) {
                if (i == 0) {
                    selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(0));
                    continue;
                }
                if (IPUtil.compareTo((String)baseCheckDataListIpv6.get(i).getStartIp(), (String)selfCheckDataListIpv6.get(selfCheckDataListIpv6.size() - 1).getEndIp()) != 1) {
                    BatchOperation bo = new BatchOperation();
                    bo.setErrorCode(570710L);
                    if (baseCheckDataListIpv6.get(i).getMaskType() == 0) {
                        bo.setTargetName(baseCheckDataListIpv6.get(i).getWhitelistIp() + "/" + baseCheckDataListIpv6.get(i).getIntMask());
                    } else {
                        bo.setTargetName(baseCheckDataListIpv6.get(i).getStartIp() + "-" + baseCheckDataListIpv6.get(i).getEndIp());
                    }
                    frontOperationList.add(bo);
                    continue;
                }
                selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(i));
            }
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void ipBlackTypeGroup(List<GloBlackListIpForm> list, List<GloBlackListIpForm> listIpV4, List<GloBlackListIpForm> listIpV6) {
        if (null != list && !list.isEmpty()) {
            for (GloBlackListIpForm gloBlackListIpForm : list) {
                if (gloBlackListIpForm.getMaskType() == 0) {
                    if (IPUtil.isIpv4((String)gloBlackListIpForm.getBlacklistIp())) {
                        listIpV4.add(gloBlackListIpForm);
                        continue;
                    }
                    if (!IPUtil.isIpv6((String)gloBlackListIpForm.getBlacklistIp())) continue;
                    listIpV6.add(gloBlackListIpForm);
                    continue;
                }
                if (IPUtil.isIpv4((String)gloBlackListIpForm.getStartIp())) {
                    listIpV4.add(gloBlackListIpForm);
                    continue;
                }
                if (!IPUtil.isIpv6((String)gloBlackListIpForm.getStartIp())) continue;
                listIpV6.add(gloBlackListIpForm);
            }
        }
    }

    private void ipWhilteTypeGroup(List<GloWhiteListIpForm> list, List<GloWhiteListIpForm> listIpV4, List<GloWhiteListIpForm> listIpV6) {
        if (null != list && !list.isEmpty()) {
            for (GloWhiteListIpForm gloWhiteListIpForm : list) {
                if (gloWhiteListIpForm.getMaskType() == 0) {
                    if (IPUtil.isIpv4((String)gloWhiteListIpForm.getWhitelistIp())) {
                        listIpV4.add(gloWhiteListIpForm);
                        continue;
                    }
                    if (!IPUtil.isIpv6((String)gloWhiteListIpForm.getWhitelistIp())) continue;
                    listIpV6.add(gloWhiteListIpForm);
                    continue;
                }
                if (IPUtil.isIpv4((String)gloWhiteListIpForm.getStartIp())) {
                    listIpV4.add(gloWhiteListIpForm);
                    continue;
                }
                if (!IPUtil.isIpv6((String)gloWhiteListIpForm.getStartIp())) continue;
                listIpV6.add(gloWhiteListIpForm);
            }
        }
    }

    private void wListIpV4Compar(List<GloWhiteListIpForm> wListIpV4, List<GloWhiteListIpForm> selfCheckDataListIpv4, List<GloWhiteListIpForm> errorIpV4List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != wListIpV4 && !wListIpV4.isEmpty()) {
            for (GloWhiteListIpForm gLOForm : wListIpV4) {
                gLOForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getStartIp()));
                gLOForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getEndIp()));
            }
            Collections.sort(wListIpV4);
            for (int i = 0; i < selfCheckDataListIpv4.size() && confilctNumber < wListIpV4.size(); ++i) {
                for (int j = confilctNumber; j < wListIpV4.size(); ++j) {
                    if (selfCheckDataListIpv4.get(i).getStartIpLong() > wListIpV4.get(j).getEndIpLong() || wListIpV4.get(j).getStartIpLong() > selfCheckDataListIpv4.get(i).getEndIpLong() || wListIpV4.get(j).getEndIpLong() < selfCheckDataListIpv4.get(i).getStartIpLong()) continue;
                    errorIpV4List.add(selfCheckDataListIpv4.get(i));
                    confilctNumber = j;
                }
            }
            for (GloWhiteListIpForm gloForm : errorIpV4List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570707L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getWhitelistIp() + "/" + gloForm.getIntMask());
                    continue;
                }
                bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
            }
        }
    }

    private void wListIpV6Compar(List<GloWhiteListIpForm> wListIpV6, List<GloWhiteListIpForm> selfCheckDataListIpv6, List<GloWhiteListIpForm> errorIpV6List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != wListIpV6 && !wListIpV6.isEmpty()) {
            for (GloWhiteListIpForm gLOForm : wListIpV6) {
                gLOForm.setStartIpLong(1L);
                gLOForm.setEndIpLong(1L);
                gLOForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getStartIp()));
                gLOForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getEndIp()));
            }
            Collections.sort(wListIpV6);
            for (int i = 0; i < selfCheckDataListIpv6.size() && confilctNumber < wListIpV6.size(); ++i) {
                for (int j = confilctNumber; j < wListIpV6.size(); ++j) {
                    if (IPUtil.compareTo((String)selfCheckDataListIpv6.get(i).getStartIp(), (String)wListIpV6.get(j).getEndIp()) == 1 || IPUtil.compareTo((String)wListIpV6.get(j).getStartIp(), (String)selfCheckDataListIpv6.get(i).getEndIp()) == 1 || IPUtil.compareTo((String)wListIpV6.get(j).getEndIp(), (String)selfCheckDataListIpv6.get(i).getStartIp()) == -1) continue;
                    errorIpV6List.add(selfCheckDataListIpv6.get(i));
                    confilctNumber = j;
                }
            }
            for (GloWhiteListIpForm gloForm : errorIpV6List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570707L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getWhitelistIp() + "/" + gloForm.getIntMask());
                    continue;
                }
                bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
            }
        }
    }

    private void bListIpV4Compar(List<GloBlackListIpForm> bListIpV4, List<GloWhiteListIpForm> selfCheckDataListIpv4, List<GloWhiteListIpForm> errorIpV4List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != bListIpV4 && !bListIpV4.isEmpty()) {
            for (GloBlackListIpForm gLOForm : bListIpV4) {
                gLOForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getStartIp()));
                gLOForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)gLOForm.getEndIp()));
            }
            Collections.sort(bListIpV4);
            block1: for (int i = 0; i < selfCheckDataListIpv4.size(); ++i) {
                for (int j = confilctNumber; j < bListIpV4.size(); ++j) {
                    if (selfCheckDataListIpv4.get(i).getStartIpLong() > bListIpV4.get(j).getEndIpLong() || bListIpV4.get(j).getStartIpLong() > selfCheckDataListIpv4.get(i).getEndIpLong() || bListIpV4.get(j).getEndIpLong() < selfCheckDataListIpv4.get(i).getStartIpLong()) continue;
                    errorIpV4List.add(selfCheckDataListIpv4.get(i));
                    confilctNumber = j;
                    continue block1;
                }
            }
            for (GloWhiteListIpForm gloForm : errorIpV4List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570706L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getWhitelistIp() + "/" + gloForm.getIntMask());
                } else {
                    bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
                }
                frontOperationList.add(bo);
            }
        }
    }

    private void bListIpV6Compar(List<GloBlackListIpForm> bListIpV6, List<GloWhiteListIpForm> selfCheckDataListIpv6, List<GloWhiteListIpForm> errorIpV6List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != bListIpV6 && !bListIpV6.isEmpty()) {
            for (GloBlackListIpForm gLOForm : bListIpV6) {
                gLOForm.setStartIpLong(1L);
                gLOForm.setEndIpLong(1L);
                gLOForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getStartIp()));
                gLOForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)gLOForm.getEndIp()));
            }
            Collections.sort(bListIpV6);
            block1: for (int i = 0; i < selfCheckDataListIpv6.size(); ++i) {
                for (int j = confilctNumber; j < bListIpV6.size(); ++j) {
                    if (IPUtil.compareTo((String)selfCheckDataListIpv6.get(i).getStartIp(), (String)bListIpV6.get(j).getEndIp()) == 1 || IPUtil.compareTo((String)bListIpV6.get(j).getStartIp(), (String)selfCheckDataListIpv6.get(i).getEndIp()) == 1 || IPUtil.compareTo((String)bListIpV6.get(j).getEndIp(), (String)selfCheckDataListIpv6.get(i).getStartIp()) == -1) continue;
                    errorIpV6List.add(selfCheckDataListIpv6.get(i));
                    confilctNumber = j;
                    continue block1;
                }
            }
            for (GloWhiteListIpForm gloForm : errorIpV6List) {
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570706L);
                if (gloForm.getMaskType() == 0) {
                    bo.setTargetName(gloForm.getWhitelistIp() + "/" + gloForm.getIntMask());
                } else {
                    bo.setTargetName(gloForm.getStartIp() + "-" + gloForm.getEndIp());
                }
                frontOperationList.add(bo);
            }
        }
    }

    private void saveImportData(List<GloWhiteListIpForm> gloIpForms, String deviceId) {
        for (GloWhiteListIpForm gloIpForm : gloIpForms) {
            ArrayList<GloWhiteListForm> subList = new ArrayList<GloWhiteListForm>();
            if (gloIpForm.getMaskType() == 0) {
                GloWhiteListForm gloForm = new GloWhiteListForm();
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setStartIp(IPUtil.getSubnetRange((String)gloIpForm.getWhitelistIp(), (int)gloIpForm.getIntMask())[0]);
                gloIpForm.setEndIp(IPUtil.getSubnetRange((String)gloIpForm.getWhitelistIp(), (int)gloIpForm.getIntMask())[1]);
                gloIpForm.setDeleteFlag(0);
                gloForm.setWhitelistIp(gloIpForm.getWhitelistIp());
                gloForm.setMask(gloIpForm.getIntMask());
                gloForm.setStartIp(IPUtil.getSubnetRange((String)gloIpForm.getWhitelistIp(), (int)gloIpForm.getIntMask())[0]);
                gloForm.setEndIp(IPUtil.getSubnetRange((String)gloIpForm.getWhitelistIp(), (int)gloIpForm.getIntMask())[1]);
                gloForm.setDeviceId(String.valueOf(deviceId));
                subList.add(gloForm);
                gloIpForm.setGloWhiteListForms(subList);
            } else if (gloIpForm.getMaskType() == 1) {
                gloIpForm.setDeviceId(Long.valueOf(deviceId));
                gloIpForm.setStartIp(gloIpForm.getStartIp());
                gloIpForm.setEndIp(gloIpForm.getEndIp());
                gloIpForm.setDeleteFlag(0);
                String[] networkSegment = null;
                try {
                    networkSegment = IPUtil.getNetworkSegment((String)gloIpForm.getStartIp(), (String)gloIpForm.getEndIp());
                }
                catch (Exception e) {
                    networkSegment = new String[]{};
                }
                for (int i = 0; i < networkSegment.length; ++i) {
                    GloWhiteListForm gloForm = new GloWhiteListForm();
                    String ipAndMask = networkSegment[i];
                    String[] ipMask = ipAndMask.split("/");
                    gloForm.setWhitelistIp(ipMask[0]);
                    gloForm.setMask(Integer.valueOf(ipMask[1]));
                    gloForm.setDeviceId(String.valueOf(deviceId));
                    subList.add(gloForm);
                }
                gloIpForm.setGloWhiteListForms(subList);
            }
            this.saveWhiteListIp(gloIpForm);
        }
    }

    @Override
    public GloWhiteListIpForm findByIpListId(Long id) {
        GloWhiteListIpInfo gloInfo = this.gWhiteListDAO.getIpList(id);
        GloWhiteListIpForm form = new GloWhiteListIpForm();
        if (gloInfo != null) {
            form.setWhitelistIp(gloInfo.getWhitelistIp());
            form.setDeviceId(Long.valueOf(gloInfo.getDeviceId()));
            form.setIntMask(gloInfo.getIntMask());
            form.setMaskType(gloInfo.getMaskType());
            form.setDeleteFlag(gloInfo.getDeleteFlag());
            form.setStartIp(gloInfo.getStartIp());
            form.setEndIp(gloInfo.getEndIp());
            form.setPkid(gloInfo.getPkid());
        } else {
            this.logger.error((Object)"findByIpListId : gloInfo is null");
        }
        return form;
    }

    @Override
    public void deleteUndoData(GloWhiteListForm form) {
        GloWhiteListInfo info = new GloWhiteListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gWhiteListDAO.deleteNewFlagData(form.getId());
        this.gWhiteListDAO.clearIpListData(form.getId());
    }

    @Override
    public BatchOperationResult batchDelAllGloWhiteList2(String deviceid) {
        this.gWhiteListDAO.clearAllIpsubListData(deviceid);
        this.gWhiteListDAO.clearAllIpListData(deviceid);
        this.gWhiteListDAO.updateFlagByDeviceId(deviceid);
        return null;
    }

    @Override
    public void respondMsgDelDevice(List<Long> deviceIds) {
        for (Long deviceId : deviceIds) {
            this.gBlackListDAO.clearAllIpListData(String.valueOf(deviceId));
            this.gBlackListDAO.clearAllListData(String.valueOf(deviceId));
        }
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }
}

