/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service;

import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.neglobal.service.GloDomainWhiteListServiceImpl;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.device.model.AticDeviceForm;
import java.util.ArrayList;
import org.springframework.beans.factory.InitializingBean;

public class NeglobalReceiveMessageForDelDevice
extends MessageTaskManager
implements InitializingBean {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private IGloBlackListService gloBlackListService;
    private IGloWhiteListService gloWhiteListService;
    private GloDomainWhiteListServiceImpl gloDomainWhiteListService;
    private IFWDefenceAbnormalService abnormalDfnService;
    private IMessageCenter messageCenter = null;

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(116L);
        return mrs;
    }

    public void onMessage(MessageUnit message) {
        if (null == message) {
            return;
        }
        int messageCode = (int)message.getCmdcode();
        if (116L == (long)messageCode) {
            ArrayList deviceList = (ArrayList)message.getObj();
            ArrayList<Long> moidList = new ArrayList<Long>();
            for (AticDeviceForm aticDeviceForm : deviceList) {
                moidList.add(aticDeviceForm.getMoId());
            }
            try {
                this.logger.info((Object)"call abnormalDfnService.deleteByDeviceId");
                this.abnormalDfnService.deleteByDeviceId(moidList);
                this.gloBlackListService.respondMsgDelDevice(moidList);
                this.gloWhiteListService.respondMsgDelDevice(moidList);
                this.gloDomainWhiteListService.deleteAllDomainWhite(moidList);
            }
            catch (Exception ex) {
                this.logger.error((Object)("delete device relation mo is error. " + ex.getMessage()));
            }
        }
    }

    public IGloBlackListService getGloBlackListService() {
        return this.gloBlackListService;
    }

    public void setGloBlackListService(IGloBlackListService gloBlackListService) {
        this.gloBlackListService = gloBlackListService;
    }

    public IGloWhiteListService getGloWhiteListService() {
        return this.gloWhiteListService;
    }

    public void setGloWhiteListService(IGloWhiteListService gloWhiteListService) {
        this.gloWhiteListService = gloWhiteListService;
    }

    public IFWDefenceAbnormalService getAbnormalDfnService() {
        return this.abnormalDfnService;
    }

    public void setAbnormalDfnService(IFWDefenceAbnormalService abnormalDfnService) {
        this.abnormalDfnService = abnormalDfnService;
    }

    public void afterPropertiesSet() throws Exception {
        this.messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public GloDomainWhiteListServiceImpl getGloDomainWhiteListService() {
        return this.gloDomainWhiteListService;
    }

    public void setGloDomainWhiteListService(GloDomainWhiteListServiceImpl gloDomainWhiteListService) {
        this.gloDomainWhiteListService = gloDomainWhiteListService;
    }
}

