/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service.deploy;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.neglobal.common.CommonUtil;
import com.hs.vsm.secservice.neglobal.model.GloBlackListInfo;
import com.hs.vsm.secservice.neglobal.model.GloCdnIpListInfo;
import com.hs.vsm.secservice.neglobal.model.GloDomainWhiteListInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListInfo;
import com.hs.vsm.secservice.neglobal.service.deploy.CreateGlobalDeployParam;
import com.hs.vsm.secservice.neglobal.service.deploy.DomainHostFilterCmdResult;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloDomainWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloCdnIpListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloDomainWhiteListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GlobalDeployThread
extends Thread {
    private static boolean bThreadrun = true;
    private static final String ZONE_HOST_REACHES_FIXED_LIMIT = "The number of this zone host reaches fixed limit already. No more hosts could be added";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private Long deviceId;
    private ProgressBar progressBar;
    private Long progressBarId;
    private Boolean isDeviceConnectedOK = true;
    private Map<Long, String> result = new HashMap<Long, String>();
    private Map<Long, String> errorDetail = new HashMap<Long, String>();
    private List<String> blackErrorDetail = new ArrayList<String>();
    private List<String> whiteErrorDetail = new ArrayList<String>();
    private List<String> domainWhiteErrorDetail = new ArrayList<String>();
    private List<String> cdnIpErrorDetail = new ArrayList<String>();
    private FWDefenceAbnormalForm form;
    private List<GloBlackListForm> listBlackForms;
    private List<GloWhiteListForm> listWhiteForms;
    private List<GloCdnIpListForm> cdnIpListForms;
    private List<GloCdnIpListForm> undoCdnIpListForms;
    private IFWDefenceAbnormalService abnormalService;
    private IGloBlackListService blackListService;
    private IGloWhiteListService gloWhiteListService;
    private IGloDomainWhiteListService gloDomainWhiteListService;
    private IGloCdnIpListService gloCdnIpListService;
    private IAticDeviceService aticDeviceService;
    private int currentStep = 0;
    private int totalStep;
    private Map<String, List<GloDomainWhiteListForm>> map;
    private List<FilterForm> listFilterForms;
    private IFilterService filterService;
    private IFilterDeviceZoneInfoService filterDeviceZoneInfoService;

    public GlobalDeployThread(CreateGlobalDeployParam createGlobalDeployParam) {
        this.deviceId = createGlobalDeployParam.getDeviceId();
        this.progressBar = createGlobalDeployParam.getProgressBar();
        this.result = createGlobalDeployParam.getResult();
        this.errorDetail = createGlobalDeployParam.getErrorDetail();
        this.form = createGlobalDeployParam.getForm();
        this.listBlackForms = createGlobalDeployParam.getListBlackForms();
        this.listWhiteForms = createGlobalDeployParam.getListWhiteForms();
        this.cdnIpListForms = createGlobalDeployParam.getCdnIpListForms();
        this.undoCdnIpListForms = createGlobalDeployParam.getUndoCdnIpListForms();
        this.abnormalService = createGlobalDeployParam.getAbnormalService();
        this.gloCdnIpListService = createGlobalDeployParam.getGloCdnIpListService();
        this.blackListService = createGlobalDeployParam.getBlackListService();
        this.gloWhiteListService = createGlobalDeployParam.getGloWhiteListService();
        this.aticDeviceService = createGlobalDeployParam.getAticDeviceService();
        this.progressBarId = createGlobalDeployParam.getProgressBarId();
        this.gloDomainWhiteListService = createGlobalDeployParam.getGloDomainWhiteListService();
        this.listFilterForms = createGlobalDeployParam.getListFilterForms();
        this.filterService = createGlobalDeployParam.getFilterService();
        this.filterDeviceZoneInfoService = createGlobalDeployParam.getFilterDeviceZoneInfoService();
    }

    public Long getProgressBarId() {
        return this.progressBarId;
    }

    public void setProgressBarId(Long progressBarId) {
        this.progressBarId = progressBarId;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public int getTotalStep() {
        return this.totalStep;
    }

    public void setTotalStep(int totalStep) {
        this.totalStep = totalStep;
    }

    public FWDefenceAbnormalForm getForm() {
        return this.form;
    }

    public void setForm(FWDefenceAbnormalForm form) {
        this.form = form;
    }

    public List<GloBlackListForm> getListBlackForms() {
        return this.listBlackForms;
    }

    public void setListBlackForms(List<GloBlackListForm> listBlackForms) {
        this.listBlackForms = listBlackForms;
    }

    public List<GloWhiteListForm> getListWhiteForms() {
        return this.listWhiteForms;
    }

    public void setListWhiteForms(List<GloWhiteListForm> listWhiteForms) {
        this.listWhiteForms = listWhiteForms;
    }

    public Map<Long, String> getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorDetail(Map<Long, String> errorDetail) {
        this.errorDetail = errorDetail;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public Boolean getIsDeviceConnectedOK() {
        return this.isDeviceConnectedOK;
    }

    public void setIsDeviceConnectedOK(Boolean isDeviceConnectedOK) {
        this.isDeviceConnectedOK = isDeviceConnectedOK;
    }

    public Map<Long, String> getResult() {
        return this.result;
    }

    public void setResult(Map<Long, String> result) {
        this.result = result;
    }

    public static boolean isbThreadrun() {
        return bThreadrun;
    }

    public static void setbThreadrun(boolean bThreadruns) {
        bThreadrun = bThreadruns;
    }

    public IFWDefenceAbnormalService getAbnormalService() {
        return this.abnormalService;
    }

    public void setAbnormalService(IFWDefenceAbnormalService abnormalService) {
        this.abnormalService = abnormalService;
    }

    public IGloBlackListService getBlackListService() {
        return this.blackListService;
    }

    public void setBlackListService(IGloBlackListService blackListService) {
        this.blackListService = blackListService;
    }

    public IGloWhiteListService getGloWhiteListService() {
        return this.gloWhiteListService;
    }

    public void setGloWhiteListService(IGloWhiteListService gloWhiteListService) {
        this.gloWhiteListService = gloWhiteListService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public List<FilterForm> getListFilterForms() {
        return this.listFilterForms;
    }

    public void setListFilterForms(List<FilterForm> listFilterForms) {
        this.listFilterForms = listFilterForms;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    private int calcTotalStep() {
        int totalSteps = 0;
        if (null != this.form) {
            ++totalSteps;
        }
        if (null != this.listBlackForms && !this.listBlackForms.isEmpty()) {
            totalSteps += this.listBlackForms.size();
        }
        if (null != this.listWhiteForms && !this.listWhiteForms.isEmpty()) {
            totalSteps += this.listWhiteForms.size();
        }
        if (null != this.undoCdnIpListForms && !this.undoCdnIpListForms.isEmpty()) {
            totalSteps += this.undoCdnIpListForms.size();
        }
        if (null != this.cdnIpListForms && !this.cdnIpListForms.isEmpty()) {
            totalSteps += this.cdnIpListForms.size();
        }
        if (null != this.listFilterForms && !this.listFilterForms.isEmpty()) {
            totalSteps += this.listFilterForms.size();
        }
        return totalSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block37: {
            block36: {
                this.logger.info((Object)("begin a thread deploy for progressbar:" + this.progressBar.toString()));
                this.totalStep = this.calcTotalStep() + 1;
                boolean isLockOK = false;
                if (null == this.aticDeviceService) {
                    this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
                }
                ExcmdConnectUtil excmdConnectUtil = null;
                try {
                    this.logger.info((Object)("before lock device,device id:" + this.deviceId));
                    isLockOK = CommonUtil.lock(this.deviceId);
                    this.logger.info((Object)("after lock device,device id:" + this.deviceId + "lock result:" + isLockOK));
                    this.gloDomainWhiteChangStep();
                    if (isLockOK) {
                        this.logger.info((Object)("lock device succeed,device id:" + this.deviceId));
                        if (this.checkDeploy()) {
                            this.errorDetail = this.abnormalService.deploy(this.form);
                            if (!this.errorDetail.isEmpty() && !"SUCCESS".equals(this.errorDetail.get(this.deviceId))) {
                                return;
                            }
                            ++this.currentStep;
                            this.progressBar.next();
                        }
                        this.form.setErrorMsgKey("--");
                        this.form.setFilterErrorMsgKey("--");
                        if (!this.listBlackForms.isEmpty()) {
                            if (com.huawei.atic.util.CommonUtil.isV5R1C20OrAfterVersion((Long)this.deviceId)) {
                                this.deployNewBlackList(this.listBlackForms);
                            } else {
                                this.deployBlackList(this.listBlackForms);
                            }
                        }
                        if (!this.listWhiteForms.isEmpty()) {
                            if (com.huawei.atic.util.CommonUtil.isV5R1C20OrAfterVersion((Long)this.deviceId)) {
                                this.deployNewWhiteList(this.listWhiteForms);
                            } else {
                                this.deployWhiteList(this.listWhiteForms);
                            }
                        }
                        if (!this.undoCdnIpListForms.isEmpty()) {
                            this.undoDeployCdnIpList(this.undoCdnIpListForms);
                        }
                        if (!this.cdnIpListForms.isEmpty()) {
                            this.deployCdnIpList(this.cdnIpListForms);
                        }
                        TelnetPara telnetPara = this.aticDeviceService.getDeviceTelnetPara(this.deviceId.longValue());
                        excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                        this.deploydomainWhiteList(excmdConnectUtil);
                        if (!this.listFilterForms.isEmpty()) {
                            Map doDeployResultList = this.filterService.doDeployFilter(this.progressBar, this.deviceId, this.listFilterForms);
                            String filterDeployState = "SUCCESS";
                            StringBuffer filterErrorMsgKey = new StringBuffer();
                            for (Map.Entry entry : doDeployResultList.entrySet()) {
                                List deployResult = (List)entry.getValue();
                                if (null != deployResult && !deployResult.isEmpty()) {
                                    String msg;
                                    Iterator iterator = deployResult.iterator();
                                    while (iterator.hasNext() && !(msg = (String)iterator.next()).startsWith("SUCCESS".concat("::"))) {
                                        if (msg.startsWith("FAIL".concat("::"))) {
                                            filterDeployState = msg.split("::")[1];
                                            continue;
                                        }
                                        if (msg.startsWith("ERRORCODE".concat("::"))) {
                                            filterErrorMsgKey.append(msg.split("::")[1]);
                                            continue;
                                        }
                                        filterErrorMsgKey.append(",");
                                        filterErrorMsgKey.append(msg.split("::")[1]);
                                    }
                                }
                                if (filterErrorMsgKey.length() == 0) continue;
                                filterErrorMsgKey.append("###");
                            }
                            this.form.setFilterDeployState(filterDeployState);
                            this.form.setFilterErrorParam(filterErrorMsgKey.toString());
                            this.currentStep += this.listFilterForms.size();
                        }
                        this.form.setErrorMsgKey("--");
                        this.form.setBlistErrorMsgKey("--");
                        this.form.setBypassErrorMsgKey("--");
                        this.form.setProxyIpErrorMsgKey("--");
                        if (!this.blackErrorDetail.isEmpty()) {
                            this.form.setBlistDeployState("FAIL");
                            StringBuffer blackError = new StringBuffer();
                            for (String error : this.blackErrorDetail) {
                                blackError.append(error);
                                blackError.append('/');
                            }
                            this.form.setBlistErrorMsgKey(blackError.toString());
                        }
                        if (!this.whiteErrorDetail.isEmpty()) {
                            this.form.setBypassDeployState("FAIL");
                            StringBuffer whiteError = new StringBuffer();
                            for (String error : this.whiteErrorDetail) {
                                whiteError.append(error);
                                whiteError.append('/');
                            }
                            this.form.setBypassErrorMsgKey(whiteError.toString());
                        }
                        if (!this.domainWhiteErrorDetail.isEmpty()) {
                            this.form.setDomainDeployState("FAIL");
                            StringBuffer domainWhiteError = new StringBuffer();
                            for (String error : this.domainWhiteErrorDetail) {
                                domainWhiteError.append(error);
                                domainWhiteError.append('/');
                            }
                            this.form.setDomainErrorMsgKey(domainWhiteError.toString());
                        }
                        if (!this.cdnIpErrorDetail.isEmpty()) {
                            this.form.setProxyIpDeployState("FAIL");
                            StringBuffer cdnIpError = new StringBuffer();
                            for (String error : this.cdnIpErrorDetail) {
                                cdnIpError.append(error);
                                cdnIpError.append('/');
                            }
                            this.form.setProxyIpErrorMsgKey(cdnIpError.toString());
                        }
                        this.abnormalService.update(this.form);
                    } else {
                        this.logger.error((Object)("lock device failed,deviceId:" + this.deviceId));
                        this.result.put(this.deviceId, "UNDEPLOY");
                        String errorMsgKey = "lego.err.630007";
                        this.errorDetail.put(this.deviceId, errorMsgKey);
                        this.form.setErrorMsgKey(this.errorDetail.get(this.deviceId));
                        this.abnormalService.update(this.form);
                    }
                    this.updateDeployState();
                    ExcmdConnectionPool.getInstance().excmdConnectionRelease(this.deviceId.longValue(), excmdConnectUtil);
                    if (!isLockOK) break block36;
                }
                catch (RuntimeException e) {
                    this.updateDeployState();
                    this.logger.error((Object)("deploy error: " + e.getMessage()));
                    break block37;
                }
                finally {
                    ExcmdConnectionPool.getInstance().excmdConnectionRelease(this.deviceId.longValue(), excmdConnectUtil);
                    if (isLockOK) {
                        Locker.getInstance().unlock(this.deviceId, 1);
                    }
                    if (this.totalStep > this.currentStep) {
                        this.progressBar.next(this.totalStep - this.currentStep);
                    }
                }
                Locker.getInstance().unlock(this.deviceId, 1);
            }
            if (this.totalStep > this.currentStep) {
                this.progressBar.next(this.totalStep - this.currentStep);
            }
        }
        this.logger.info((Object)("end a thread deploy for progressbar:" + this.progressBar.toString()));
    }

    private void gloDomainWhiteChangStep() {
        this.map = this.gloDomainWhiteListService.getdomainWhiteMap(this.deviceId);
        if (null == this.map || this.map.isEmpty()) {
            return;
        }
        if (null != this.map.get("AllDel")) {
            ++this.totalStep;
        }
        if (null != this.map.get("delList")) {
            this.totalStep += this.map.get("delList").size();
        }
        if (null != this.map.get("formList")) {
            this.totalStep += this.map.get("formList").size();
        }
        this.progressBar.setTotalStep(this.totalStep);
    }

    private void deploydomainWhiteList(ExcmdConnectUtil excmdConnectUtil) {
        if (null == this.map || this.map.isEmpty()) {
            this.logger.error((Object)"domainwhitelist deploy,but domain is Empty! ");
            return;
        }
        if (null != this.map.get("AllDel")) {
            this.undoAllDomainWhiteList();
            return;
        }
        List<GloDomainWhiteListForm> delList = this.map.get("delList");
        List<GloDomainWhiteListForm> formList = this.map.get("formList");
        try {
            if (null != delList && !delList.isEmpty()) {
                this.undoDomainWhiteList(delList, excmdConnectUtil);
            }
            if (null != formList && !formList.isEmpty()) {
                this.doDomainWhiteList(formList, excmdConnectUtil);
            }
            this.commitCmd(excmdConnectUtil);
        }
        catch (LegoCheckedException e) {
            this.result.put(this.deviceId, "FAIL");
            this.logger.error((Object)("domainWhite  ExcmdConnectUtil :" + e.getMessage()));
            throw e;
        }
        finally {
            ExcmdConnectionPool.getInstance().excmdConnectionRelease(this.deviceId.longValue(), excmdConnectUtil);
            TelnetPara telnetPara = this.aticDeviceService.getDeviceTelnetPara(this.deviceId.longValue());
            this.commitCmd(ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara));
        }
    }

    private boolean commitCmd(ExcmdConnectUtil excmdConnectUtil) {
        this.logger.info((Object)"commitCmd begin!");
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("anti-ddos http-flood host-filter commit");
        return this.doCommitCmd(excmdConnectUtil, cmds, 1);
    }

    private boolean doCommitCmd(ExcmdConnectUtil excmdConnectUtil, List<String> cmds, int num) {
        if (3 < num) {
            return false;
        }
        boolean mark = false;
        try {
            ++num;
            List listCommit = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmds, (boolean)false);
            this.logger.info((Object)("Commit: " + listCommit));
            if (null != listCommit && (listCommit.toString().contains("Error") || AticUtil.judgmentEcho((String)listCommit.toString()))) {
                mark = true;
            }
        }
        catch (LegoCheckedException e) {
            mark = true;
            this.logger.error((Object)("anti-ddos http-flood host-filter commit:" + e.getMessage()));
            this.logger.error((Object)("Number of attempts: " + num));
        }
        if (mark) {
            this.doCommitCmd(excmdConnectUtil, cmds, num);
        }
        return true;
    }

    private void undoAllDomainWhiteList() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system");
        cmds.add("undo anti-ddos http-flood host-filter all");
        try {
            List cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
            this.logger.info((Object)("domainwhitelist deploy all cmdResult : " + cmdResult));
            if (null != cmdResult && !cmdResult.toString().contains("Error") && !AticUtil.judgmentEcho((String)cmdResult.toString())) {
                this.gloDomainWhiteListService.removeAllDomainWhite(this.deviceId);
            } else if (null != cmdResult) {
                this.domainWhiteErrorDetail.add("undo anti-ddos http-flood host-filter all");
                this.logger.info((Object)"domainwhitelist deploy failure , failure whitelist domain : all");
            }
        }
        catch (LegoCheckedException legoExcp) {
            this.logger.error((Object)"undo anti-ddos http-flood host-filter all error!");
            this.result.put(this.deviceId, "FAIL");
            ++this.currentStep;
            this.progressBar.next();
            throw legoExcp;
        }
        ++this.currentStep;
        this.progressBar.next();
    }

    private void undoDomainWhiteList(List<GloDomainWhiteListForm> delList, final ExcmdConnectUtil excmdConnectUtil) {
        List<List<GloDomainWhiteListForm>> partDelList = GlobalDeployThread.partList(delList, 66);
        final CountDownLatch startCount = new CountDownLatch(1);
        final CountDownLatch endCount = new CountDownLatch(partDelList.size());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        this.exeSysCmd(excmdConnectUtil);
        int partIndex = 0;
        for (final List<GloDomainWhiteListForm> eachPart : partDelList) {
            final int finalPartIndex = partIndex + 1;
            Callable<String> callable = new Callable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws Exception {
                    try {
                        startCount.await();
                        ArrayList<String> cmds = new ArrayList<String>();
                        for (GloDomainWhiteListForm eachForm : eachPart) {
                            cmds.add("undo anti-ddos http-flood host-filter name  " + eachForm.getDomainWhite().trim());
                        }
                        List resultCmds = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmds, (boolean)false);
                        int index = 0;
                        ArrayList<GloDomainWhiteListForm> successDelList = new ArrayList<GloDomainWhiteListForm>();
                        for (GloDomainWhiteListForm formx : eachPart) {
                            String cmdResult = (String)resultCmds.get(index);
                            ++index;
                            if (null == cmdResult) continue;
                            if (!cmdResult.contains("Error")) {
                                successDelList.add(formx);
                                continue;
                            }
                            String str = cmdResult.substring(cmdResult.indexOf("Error:") + "Error:".length(), cmdResult.length()).replaceAll("\\[[^\\[\\]\\?\\s].*[^\\[\\]\\?\\s]\\]", "");
                            GlobalDeployThread.this.domainWhiteErrorDetail.add("undo " + formx.getDomainWhite() + " failure : " + str);
                        }
                        GlobalDeployThread.this.gloDomainWhiteListService.deleteBatchUndoDeployData(successDelList);
                        successDelList.clear();
                    }
                    catch (LegoCheckedException e) {
                        GlobalDeployThread.this.result.put(GlobalDeployThread.this.deviceId, "FAIL");
                        GlobalDeployThread.this.logger.error((Object)e.getMessage());
                    }
                    finally {
                        GlobalDeployThread.this.currentStep = GlobalDeployThread.this.currentStep + eachPart.size();
                        GlobalDeployThread.this.progressBar.next(eachPart.size());
                        GlobalDeployThread.this.logger.error((Object)("undo PART : [" + finalPartIndex + "] execute over!"));
                        endCount.countDown();
                    }
                    return "success";
                }
            };
            Future<String> futrue = executor.submit(callable);
            futures.add(futrue);
            ++partIndex;
        }
        try {
            startCount.countDown();
            endCount.await();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            this.result.put(this.deviceId, "FAIL");
            this.logger.error((Object)e.getMessage());
        }
        int count = 0;
        count = this.checkResult(futures, count);
        this.logger.info((Object)("undo GloDomainWhiteListForm the all success part count :" + count));
        this.logger.info((Object)("undo GloDomainWhiteListForm the all part count :" + futures.size()));
        this.logger.info((Object)"undo over!");
    }

    private void doDomainWhiteList(List<GloDomainWhiteListForm> formList, ExcmdConnectUtil excmdConnectUtil) {
        List<List<GloDomainWhiteListForm>> partLists = GlobalDeployThread.partList(formList, 66);
        CountDownLatch startCount = new CountDownLatch(1);
        CountDownLatch endCount = new CountDownLatch(partLists.size());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        long uniqueKey = System.currentTimeMillis();
        this.exeSysCmd(excmdConnectUtil);
        int partIndex = 0;
        for (List<GloDomainWhiteListForm> eachPart : partLists) {
            int finalPartIndex = partIndex + 1;
            DomainWhiteCallable callable = new DomainWhiteCallable(eachPart, uniqueKey, finalPartIndex, endCount, startCount, excmdConnectUtil);
            Future<String> futrue = executor.submit(callable);
            futures.add(futrue);
            ++partIndex;
        }
        try {
            startCount.countDown();
            endCount.await();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage());
        }
        int count = 0;
        count = this.checkResult(futures, count);
        this.logger.info((Object)("GloDomainWhiteListForm the all success part count :" + count));
        this.logger.info((Object)("GloDomainWhiteListForm the all part count :" + futures.size()));
        this.logger.info((Object)"over!");
    }

    private int checkResult(List<Future<String>> futures, int count) {
        for (Future<String> future : futures) {
            try {
                String resultx = future.get();
                if (!resultx.equals("success")) continue;
                ++count;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)e.getMessage());
            }
            catch (ExecutionException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return count;
    }

    private void exeSysCmd(ExcmdConnectUtil excmdConnectUtil) {
        try {
            List sysResult = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, Collections.singletonList("system"), (boolean)true);
            this.logger.info((Object)sysResult);
        }
        catch (Exception e) {
            try {
                List sysResult = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, Collections.singletonList("system"), (boolean)true);
                this.logger.error((Object)("exception : " + sysResult));
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage());
            }
        }
    }

    private static <T> List<List<T>> partList(List<T> list, int separation) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int index = 0;
        ArrayList<T> each = null;
        for (T t : list) {
            if (index % separation == 0) {
                each = new ArrayList<T>();
                result.add(each);
            }
            each.add(t);
            ++index;
        }
        list.clear();
        return result;
    }

    private void updateDeployState() {
        if (null != this.form.getErrorMsgKey() && !"lego.err.630007".equals(this.form.getErrorMsgKey())) {
            ArrayList filterDeviceZoneInfos;
            List<GloCdnIpListInfo> gloCdnIpListInfos;
            List<GloDomainWhiteListInfo> gloDomainList;
            List<GloWhiteListInfo> gloList2;
            List<GloBlackListInfo> gloList = this.blackListService.queryByDeviceId(this.deviceId);
            if (gloList == null) {
                gloList = new ArrayList<GloBlackListInfo>();
            }
            String bdeployState = "";
            int count = 0;
            for (GloBlackListInfo blackListInfo : gloList) {
                bdeployState = blackListInfo.getDeployState();
                this.logger.info((Object)("blackList state: " + bdeployState + " blackListInfo: " + blackListInfo.getBlacklistIp()));
                ++count;
                if (null != bdeployState && !"".equals(bdeployState) && bdeployState.equals("SUCCESS")) {
                    if (count != gloList.size()) continue;
                    bdeployState = "SUCCESS";
                    break;
                }
                if (null != bdeployState && !"".equals(bdeployState) && bdeployState.equals("UNDEPLOY")) {
                    if (count != gloList.size()) continue;
                    bdeployState = "UNDEPLOY";
                    break;
                }
                if (null == bdeployState || "".equals(bdeployState) || !bdeployState.equals("FAIL")) continue;
                bdeployState = "PART_SUCCESS";
                break;
            }
            if ((gloList2 = this.gloWhiteListService.queryByDeviceId(this.deviceId)) == null) {
                gloList2 = new ArrayList<GloWhiteListInfo>();
            }
            String wdeployState = "";
            int count2 = 0;
            for (GloWhiteListInfo whiteListInfo : gloList2) {
                wdeployState = whiteListInfo.getDeployState();
                this.logger.info((Object)("whiteList state: " + wdeployState + " whiteListInfo: " + whiteListInfo.getWhitelistIp()));
                ++count2;
                if (null != wdeployState && !"".equals(wdeployState) && wdeployState.equals("SUCCESS")) {
                    if (count2 != gloList2.size()) continue;
                    wdeployState = "SUCCESS";
                    break;
                }
                if (null != wdeployState && !"".equals(wdeployState) && wdeployState.equals("UNDEPLOY")) {
                    if (count2 != gloList2.size()) continue;
                    wdeployState = "UNDEPLOY";
                    break;
                }
                if (null == wdeployState || "".equals(wdeployState) || !wdeployState.equals("FAIL")) continue;
                wdeployState = "PART_SUCCESS";
                break;
            }
            if ((gloDomainList = this.gloDomainWhiteListService.queryByDeviceId(this.deviceId)) == null) {
                gloDomainList = new ArrayList<GloDomainWhiteListInfo>();
            }
            String dwdeployState = "";
            int count3 = 0;
            for (GloDomainWhiteListInfo info : gloDomainList) {
                dwdeployState = info.getDeployState();
                ++count3;
                if (null != dwdeployState && !"".equals(dwdeployState) && dwdeployState.equals("SUCCESS")) {
                    if (count3 != gloDomainList.size()) continue;
                    dwdeployState = "SUCCESS";
                    break;
                }
                if (null != dwdeployState && !"".equals(dwdeployState) && dwdeployState.equals("UNDEPLOY")) {
                    if (count3 != gloDomainList.size()) continue;
                    dwdeployState = "UNDEPLOY";
                    break;
                }
                if (null == dwdeployState || "".equals(dwdeployState) || !dwdeployState.equals("FAIL")) continue;
                dwdeployState = "PART_SUCCESS";
                break;
            }
            if ((gloCdnIpListInfos = this.gloCdnIpListService.queryByDeviceId(this.deviceId)) == null) {
                gloCdnIpListInfos = new ArrayList<GloCdnIpListInfo>();
            }
            String cdnDeployState = "";
            int cdnCount = 0;
            for (GloCdnIpListInfo ipListInfo : gloCdnIpListInfos) {
                cdnDeployState = ipListInfo.getDeployState();
                this.logger.info((Object)("GloCdnIpList state: " + cdnDeployState + " GloCdnIpList: " + ipListInfo.getStartIp()));
                ++cdnCount;
                if (null != cdnDeployState && !"".equals(cdnDeployState) && cdnDeployState.equals("SUCCESS")) {
                    if (cdnCount != gloCdnIpListInfos.size()) continue;
                    cdnDeployState = "SUCCESS";
                    break;
                }
                if (null != cdnDeployState && !"".equals(cdnDeployState) && cdnDeployState.equals("UNDEPLOY")) {
                    if (cdnCount != gloCdnIpListInfos.size()) continue;
                    cdnDeployState = "UNDEPLOY";
                    break;
                }
                if (null == cdnDeployState || "".equals(cdnDeployState) || !cdnDeployState.equals("FAIL")) continue;
                cdnDeployState = "PART_SUCCESS";
                break;
            }
            if ((filterDeviceZoneInfos = this.filterDeviceZoneInfoService.queryGloFilter(Long.valueOf(0L), this.deviceId, 1)) == null) {
                filterDeviceZoneInfos = new ArrayList();
            }
            String filterDeployState = "";
            boolean filterDefineDeployState = false;
            int filterCount = 0;
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                filterDeployState = filterDeviceZoneInfo.getDeployState();
                filterDefineDeployState = filterDeviceZoneInfo.getFilterDefineState();
                this.logger.info((Object)("filterDeviceZoneInfo state: " + filterDeployState + "filterId is: " + filterDeviceZoneInfo.getFilterId()));
                ++filterCount;
                if (!filterDefineDeployState) {
                    filterDeployState = "PART_SUCCESS";
                    break;
                }
                if (null != filterDeployState && !"".equals(filterDeployState) && filterDeployState.equals("SUCCESS")) {
                    if (filterCount != filterDeviceZoneInfos.size()) continue;
                    filterDeployState = "SUCCESS";
                    break;
                }
                if (null != filterDeployState && !"".equals(filterDeployState) && filterDeployState.equals("UNDEPLOY")) {
                    if (filterCount != filterDeviceZoneInfos.size()) continue;
                    filterDeployState = "UNDEPLOY";
                    break;
                }
                if (null == filterDeployState || "".equals(filterDeployState) || !filterDeployState.equals("FAIL")) continue;
                filterDeployState = "PART_SUCCESS";
                break;
            }
            if (!"".equals(dwdeployState)) {
                this.form.setDomainDeployState(dwdeployState);
            } else {
                this.form.setDomainDeployState("SUCCESS");
            }
            if (null != bdeployState && !bdeployState.equals("")) {
                this.form.setBlistDeployState(bdeployState);
            } else {
                this.form.setBlistDeployState("SUCCESS");
            }
            if (!"".equals(wdeployState)) {
                this.form.setBypassDeployState(wdeployState);
            } else {
                this.form.setBypassDeployState("SUCCESS");
            }
            if (null != cdnDeployState && !cdnDeployState.equals("")) {
                this.form.setProxyIpDeployState(cdnDeployState);
            } else {
                this.form.setProxyIpDeployState("SUCCESS");
            }
            if (null != filterDeployState && !filterDeployState.equals("")) {
                this.form.setFilterDeployState(filterDeployState);
            } else {
                this.form.setFilterDeployState("SUCCESS");
            }
            this.abnormalService.saveDeployState(this.form);
        }
    }

    private boolean checkDeploy() {
        Boolean isTaskCancled = false;
        if (ProgressMgr.getInstance().getProgressBar(this.progressBarId).isCancled()) {
            isTaskCancled = true;
            this.progressBar.next();
            this.logger.info((Object)("progress id in canceled branch:" + this.progressBar.getProgressBarID() + ":info:" + this.progressBar.toString()));
        }
        if (!this.getIsDeviceConnectedOK().booleanValue()) {
            this.logger.info((Object)"isDeviceConnectedOK is false");
            this.progressBar.next();
            String errorMsgKey = "lego.err.630005";
            this.errorDetail.put(this.deviceId, errorMsgKey);
            return false;
        }
        if (isTaskCancled.booleanValue()) {
            this.result.put(this.deviceId, "SUCCESS");
            String errorMsgKey = "lego.err.630008";
            this.errorDetail.put(this.deviceId, errorMsgKey);
            return false;
        }
        return true;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void undoDeployCdnIpList(List<GloCdnIpListForm> gloCdnIpListForms) {
        for (GloCdnIpListForm forms : gloCdnIpListForms) {
            ArrayList<String> cmds = new ArrayList<String>();
            if (!this.checkDeploy()) break;
            cmds.add("system");
            if (0 == forms.getMaskType()) {
                cmds.add("undo anti-ddos http-flood proxy-ip " + forms.getIpAddress() + " " + forms.getMask());
            } else {
                cmds.add("undo anti-ddos http-flood proxy-ip " + forms.getStartIp() + " " + forms.getEndIp());
            }
            this.logger.info((Object)("cmds result :" + cmds));
            List cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
            int flag = 0;
            for (String cmd : cmdResult) {
                if (this.isResultError(cmd)) {
                    flag = 1;
                }
                if (!cmd.contains("Error: Invalid IP address.")) continue;
                flag = 2;
                break;
            }
            if (flag == 0) {
                this.result.put(this.deviceId, "SUCCESS");
                this.gloCdnIpListService.deleteUndoDeployData(forms);
            }
            ++this.currentStep;
            this.progressBar.next();
        }
        this.logger.info((Object)"leave undo deploy cdnIPlist ");
    }

    private void deployCdnIpList(List<GloCdnIpListForm> gloCdnIpListForms) {
        for (GloCdnIpListForm forms : gloCdnIpListForms) {
            block13: {
                ArrayList<String> cmds = new ArrayList<String>();
                try {
                    StringBuffer error;
                    if (!this.checkDeploy()) break;
                    cmds.add("system");
                    if (0 == forms.getMaskType()) {
                        cmds.add("anti-ddos http-flood proxy-ip " + forms.getIpAddress() + " " + forms.getMask());
                    } else {
                        cmds.add("anti-ddos http-flood proxy-ip " + forms.getStartIp() + " " + forms.getEndIp());
                    }
                    this.logger.info((Object)("cmds result :" + cmds));
                    List cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                    int flag = 0;
                    for (String cmd : cmdResult) {
                        if (this.isResultError(cmd)) {
                            flag = 1;
                        }
                        if (cmd.contains("Error: The number of proxy IP reaches fixed limit already. ")) {
                            flag = 2;
                            break;
                        }
                        if (!cmd.contains("Error: IP address conflict .")) continue;
                        flag = 3;
                        break;
                    }
                    if (flag == 0) {
                        this.result.put(this.deviceId, "SUCCESS");
                        forms.setDeployState("SUCCESS");
                        this.gloCdnIpListService.updateDeployStatus(forms);
                        break block13;
                    }
                    this.result.put(this.deviceId, "FAIL");
                    forms.setDeployState("FAIL");
                    this.gloCdnIpListService.updateDeployStatus(forms);
                    if (flag == 2) {
                        error = new StringBuffer();
                        for (int i = 1; i < cmds.size(); ++i) {
                            error.append((String)cmds.get(i) + "proxy IP reaches fixed limit");
                        }
                        this.cdnIpErrorDetail.add(error.toString());
                    }
                    if (flag == 3) {
                        error = new StringBuffer();
                        for (int i = 1; i < cmds.size(); ++i) {
                            error.append((String)cmds.get(i));
                        }
                        this.cdnIpErrorDetail.add(error.toString());
                    }
                    this.logger.info((Object)("cdnip deploy failure , failure cdn ip :" + forms.getStartIp() + "," + forms.getEndIp()));
                    continue;
                }
                catch (LegoCheckedException legoExcp) {
                    this.result.put(this.deviceId, "FAIL");
                    forms.setDeployState("FAIL");
                    this.gloCdnIpListService.updateDeployStatus(forms);
                    throw legoExcp;
                }
            }
            ++this.currentStep;
            this.progressBar.next();
        }
        this.logger.info((Object)"leave cndIpList deploy ");
    }

    private void deployBlackList(List<GloBlackListForm> listForms) {
        for (GloBlackListForm forms : listForms) {
            ArrayList<String> cmds = new ArrayList<String>();
            try {
                List cmdResult;
                if (!this.checkDeploy()) break;
                if (!"SUCCESS".equals(forms.getDeployState())) {
                    cmds.add("system");
                    if ("0".equals(forms.getDeleteFlag())) {
                        if (IPUtil.isIpv4((String)forms.getBlacklistIp())) {
                            cmds.add("anti-ddos blacklist-item ip " + forms.getBlacklistIp());
                        }
                        if (IPUtil.isIpv6((String)forms.getBlacklistIp())) {
                            cmds.add("anti-ddos blacklist-item ipv6 " + forms.getBlacklistIp());
                        }
                        this.logger.info((Object)("cmds result :" + cmds));
                        cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                        int flag = 0;
                        for (String cmd : cmdResult) {
                            if (this.isResultError(cmd)) {
                                flag = 1;
                            }
                            if (cmd.contains("Error: The type of specified item has already conflicted.")) {
                                flag = 2;
                                break;
                            }
                            if (!cmd.contains("Error: The specified item has already existed.")) continue;
                            flag = 0;
                            break;
                        }
                        if (flag == 0) {
                            this.result.put(this.deviceId, "SUCCESS");
                            forms.setDeployState("SUCCESS");
                            this.blackListService.updateDeployStatus(forms);
                        } else {
                            this.result.put(this.deviceId, "FAIL");
                            forms.setDeployState("FAIL");
                            this.blackListService.updateDeployStatus(forms);
                            if (flag == 2) {
                                StringBuffer error = new StringBuffer();
                                for (int i = 1; i < cmds.size(); ++i) {
                                    error.append((String)cmds.get(i));
                                }
                                this.blackErrorDetail.add(error.toString());
                            }
                            this.logger.info((Object)("blacklistip deploy failure , failure blacklist ip :" + forms.getBlacklistIp()));
                            continue;
                        }
                    }
                    if ("1".equals(forms.getDeleteFlag())) {
                        this.blackListService.deleteUndoDeployData(forms);
                    }
                } else if ("1".equals(forms.getDeleteFlag())) {
                    cmds.add("system");
                    if (IPUtil.isIpv4((String)forms.getBlacklistIp())) {
                        cmds.add("undo anti-ddos blacklist-item ip " + forms.getBlacklistIp());
                    }
                    if (IPUtil.isIpv6((String)forms.getBlacklistIp())) {
                        cmds.add("undo anti-ddos blacklist-item ipv6 " + forms.getBlacklistIp());
                    }
                    if (AticUtil.isCmdSucess((List)(cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds)))) {
                        this.blackListService.deleteUndoDeployData(forms);
                    }
                }
            }
            catch (LegoCheckedException legoExcp) {
                this.result.put(this.deviceId, "FAIL");
                forms.setDeployState("FAIL");
                this.blackListService.updateDeployStatus(forms);
                throw legoExcp;
            }
            ++this.currentStep;
            this.progressBar.next();
        }
        this.logger.info((Object)"leave blacklist deploy ");
    }

    private void deployWhiteList(List<GloWhiteListForm> listForms) {
        for (GloWhiteListForm forms : listForms) {
            ArrayList<String> cmds = new ArrayList<String>();
            try {
                if (!this.checkDeploy()) break;
                if (!"SUCCESS".equals(forms.getDeployState())) {
                    cmds.add("system");
                    if ("0".equals(forms.getDeleteFlag())) {
                        if (IPUtil.isIpv4((String)forms.getWhitelistIp())) {
                            cmds.add("anti-ddos bypass-item ip " + forms.getWhitelistIp());
                        }
                        if (IPUtil.isIpv6((String)forms.getWhitelistIp())) {
                            cmds.add("anti-ddos bypass-item ipv6 " + forms.getWhitelistIp());
                        }
                        List cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                        int flag = 0;
                        for (String cmd : cmdResult) {
                            if (this.isResultError(cmd)) {
                                flag = 1;
                            }
                            if (cmd.contains("Error: The type of specified item has already conflicted.")) {
                                flag = 2;
                                break;
                            }
                            if (!cmd.contains("Error: The specified item has already existed.")) continue;
                            flag = 0;
                            break;
                        }
                        if (flag == 0) {
                            this.result.put(this.deviceId, "SUCCESS");
                            forms.setDeployState("SUCCESS");
                            this.gloWhiteListService.updateDeployStatus(forms);
                        } else {
                            this.result.put(this.deviceId, "FAIL");
                            forms.setDeployState("FAIL");
                            this.gloWhiteListService.updateDeployStatus(forms);
                            if (flag == 2) {
                                StringBuffer error = new StringBuffer();
                                for (int i = 1; i < cmds.size(); ++i) {
                                    error.append((String)cmds.get(i));
                                }
                                this.whiteErrorDetail.add(error.toString());
                            }
                            this.logger.info((Object)("whitelistip deploy failure , failure whitelist ip :" + forms.getWhitelistIp()));
                            continue;
                        }
                    }
                    if ("1".equals(forms.getDeleteFlag())) {
                        this.gloWhiteListService.deleteUndoDeployData(forms);
                    }
                } else if ("1".equals(forms.getDeleteFlag())) {
                    cmds.add("system");
                    if (IPUtil.isIpv4((String)forms.getWhitelistIp())) {
                        cmds.add("undo anti-ddos bypass-item ip " + forms.getWhitelistIp());
                    }
                    if (IPUtil.isIpv6((String)forms.getWhitelistIp())) {
                        cmds.add("undo anti-ddos bypass-item ipv6 " + forms.getWhitelistIp());
                    }
                    this.gloWhiteListService.deleteUndoDeployData(forms);
                }
            }
            catch (LegoCheckedException legoExcp) {
                this.result.put(this.deviceId, "FAIL");
                forms.setDeployState("FAIL");
                this.gloWhiteListService.updateDeployStatus(forms);
                throw legoExcp;
            }
            ++this.currentStep;
            this.progressBar.next();
        }
        this.logger.info((Object)"leave whitelist deploy ");
    }

    private void deployNewBlackList(List<GloBlackListForm> listForms) {
        for (GloBlackListForm forms : listForms) {
            ArrayList<String> cmds = new ArrayList<String>();
            try {
                List cmdResult;
                if (!this.checkDeploy()) break;
                if (!"SUCCESS".equals(forms.getDeployState())) {
                    cmds.add("system");
                    if ("0".equals(forms.getDeleteFlag())) {
                        if (IPUtil.isIpv4((String)forms.getBlacklistIp())) {
                            cmds.add("anti-ddos blacklist-item ip " + forms.getBlacklistIp() + " " + forms.getMask());
                        }
                        if (IPUtil.isIpv6((String)forms.getBlacklistIp())) {
                            cmds.add("anti-ddos blacklist-item ipv6 " + forms.getBlacklistIp() + " " + forms.getMask());
                        }
                        this.logger.info((Object)("cmds result :" + cmds));
                        cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                        int flag = 0;
                        for (String cmd : cmdResult) {
                            if (cmd.contains("system")) continue;
                            if (this.isResultError(cmd)) {
                                flag = 1;
                            }
                            flag = cmd.contains("Error: The type of specified item has already conflicted.") ? 2 : (cmd.contains("Error: The specified item has already existed.") ? 3 : 0);
                            break;
                        }
                        if (flag == 0) {
                            this.result.put(this.deviceId, "SUCCESS");
                            forms.setDeployState("SUCCESS");
                            this.blackListService.updateDeployStatus(forms);
                        } else {
                            this.result.put(this.deviceId, "FAIL");
                            forms.setDeployState("FAIL");
                            this.blackListService.updateDeployStatus(forms);
                            StringBuffer error = new StringBuffer();
                            if (flag == 2) {
                                for (int i = 1; i < cmds.size(); ++i) {
                                    error.append((String)cmds.get(i));
                                }
                                this.blackErrorDetail.add(error.toString());
                            }
                            if (flag == 3) {
                                for (int i = 1; i < cmds.size(); ++i) {
                                    error.append((String)cmds.get(i) + "self");
                                }
                                this.blackErrorDetail.add(error.toString());
                            }
                            this.logger.info((Object)("blacklistip deploy failure , failure blacklist ip :" + forms.getBlacklistIp()));
                            continue;
                        }
                    }
                    if ("1".equals(forms.getDeleteFlag())) {
                        if (IPUtil.isIpv4((String)forms.getBlacklistIp())) {
                            cmds.add("undo anti-ddos blacklist-item ip " + forms.getBlacklistIp() + " " + forms.getMask());
                        }
                        if (IPUtil.isIpv6((String)forms.getBlacklistIp())) {
                            cmds.add("undo anti-ddos blacklist-item ipv6 " + forms.getBlacklistIp() + " " + forms.getMask());
                        }
                        this.logger.info((Object)("cmds result :" + cmds));
                        cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                        if (AticUtil.isCmdSucess((List)cmdResult)) {
                            this.blackListService.deleteUndoData(forms);
                        } else {
                            forms.setDeployState("FAIL");
                            this.blackListService.updateDeployStatus(forms);
                        }
                    }
                } else if ("1".equals(forms.getDeleteFlag())) {
                    cmds.add("system");
                    if (IPUtil.isIpv4((String)forms.getBlacklistIp())) {
                        cmds.add("undo anti-ddos blacklist-item ip " + forms.getBlacklistIp() + " " + forms.getMask());
                    }
                    if (IPUtil.isIpv6((String)forms.getBlacklistIp())) {
                        cmds.add("undo anti-ddos blacklist-item ipv6 " + forms.getBlacklistIp() + " " + forms.getMask());
                    }
                    if (AticUtil.isCmdSucess((List)(cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds)))) {
                        this.blackListService.deleteUndoData(forms);
                    }
                }
            }
            catch (LegoCheckedException legoExcp) {
                this.result.put(this.deviceId, "FAIL");
                forms.setDeployState("FAIL");
                this.blackListService.updateDeployStatus(forms);
                throw legoExcp;
            }
            ++this.currentStep;
            this.progressBar.next();
        }
        this.logger.info((Object)"leave blacklist deploy ");
    }

    private void deployNewWhiteList(List<GloWhiteListForm> listForms) {
        for (GloWhiteListForm forms : listForms) {
            ArrayList<String> cmds = new ArrayList<String>();
            try {
                List cmdResult;
                if (!this.checkDeploy()) break;
                if (!"SUCCESS".equals(forms.getDeployState())) {
                    cmds.add("system");
                    if ("0".equals(forms.getDeleteFlag())) {
                        if (IPUtil.isIpv4((String)forms.getWhitelistIp())) {
                            cmds.add("anti-ddos bypass-item ip " + forms.getWhitelistIp() + " " + forms.getMask());
                        }
                        if (IPUtil.isIpv6((String)forms.getWhitelistIp())) {
                            cmds.add("anti-ddos bypass-item ipv6 " + forms.getWhitelistIp() + " " + forms.getMask());
                        }
                        cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                        int flag = 0;
                        for (String cmd : cmdResult) {
                            if (cmd.contains("system")) continue;
                            if (this.isResultError(cmd)) {
                                flag = 1;
                            }
                            flag = cmd.contains("Error: The type of specified item has already conflicted.") ? 2 : (cmd.contains("Error: The specified item has already existed.") ? 3 : 0);
                            break;
                        }
                        if (flag == 0) {
                            this.result.put(this.deviceId, "SUCCESS");
                            forms.setDeployState("SUCCESS");
                            this.gloWhiteListService.updateDeployStatus(forms);
                        } else {
                            this.result.put(this.deviceId, "FAIL");
                            forms.setDeployState("FAIL");
                            this.gloWhiteListService.updateDeployStatus(forms);
                            StringBuffer error = new StringBuffer();
                            if (flag == 2) {
                                for (int i = 1; i < cmds.size(); ++i) {
                                    error.append((String)cmds.get(i));
                                }
                                this.whiteErrorDetail.add(error.toString());
                            }
                            if (flag == 3) {
                                for (int i = 1; i < cmds.size(); ++i) {
                                    error.append((String)cmds.get(i) + "self");
                                }
                                this.whiteErrorDetail.add(error.toString());
                            }
                            this.logger.info((Object)("whitelistip deploy failure , failure whitelist ip :" + forms.getWhitelistIp()));
                            continue;
                        }
                    }
                    if ("1".equals(forms.getDeleteFlag())) {
                        if (IPUtil.isIpv4((String)forms.getWhitelistIp())) {
                            cmds.add("undo anti-ddos bypass-item ip " + forms.getWhitelistIp() + " " + forms.getMask());
                        }
                        if (IPUtil.isIpv6((String)forms.getWhitelistIp())) {
                            cmds.add("undo anti-ddos bypass-item ipv6 " + forms.getWhitelistIp() + " " + forms.getMask());
                        }
                        if (AticUtil.isCmdSucess((List)(cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds)))) {
                            this.gloWhiteListService.deleteUndoData(forms);
                        }
                    }
                } else if ("1".equals(forms.getDeleteFlag())) {
                    cmds.add("system");
                    if (IPUtil.isIpv4((String)forms.getWhitelistIp())) {
                        cmds.add("undo anti-ddos bypass-item ip " + forms.getWhitelistIp() + " " + forms.getMask());
                    }
                    if (IPUtil.isIpv6((String)forms.getWhitelistIp())) {
                        cmds.add("undo anti-ddos bypass-item ipv6 " + forms.getWhitelistIp() + " " + forms.getMask());
                    }
                    cmdResult = CmdUtil.execCmds((long)this.deviceId, cmds);
                    this.logger.info((Object)("cmdResult result :" + this.getcleanedMessage(cmdResult.toString())));
                    this.gloWhiteListService.deleteUndoData(forms);
                }
            }
            catch (LegoCheckedException legoExcp) {
                this.result.put(this.deviceId, "FAIL");
                forms.setDeployState("FAIL");
                this.gloWhiteListService.updateDeployStatus(forms);
                throw legoExcp;
            }
            ++this.currentStep;
            this.progressBar.next();
        }
        this.logger.info((Object)"leave whitelist deploy ");
    }

    private boolean isResultError(String cmd) {
        return cmd.contains("Error") || AticUtil.judgmentEcho((String)cmd);
    }

    public List<String> getCdnIpErrorDetail() {
        return this.cdnIpErrorDetail;
    }

    public void setCdnIpErrorDetail(List<String> cdnIpErrorDetail) {
        this.cdnIpErrorDetail = cdnIpErrorDetail;
    }

    public List<GloCdnIpListForm> getCdnIpListForms() {
        return this.cdnIpListForms;
    }

    public void setCdnIpListForms(List<GloCdnIpListForm> cdnIpListForms) {
        this.cdnIpListForms = cdnIpListForms;
    }

    public List<GloCdnIpListForm> getUndoCdnIpListForms() {
        return this.undoCdnIpListForms;
    }

    public void setUndoCdnIpListForms(List<GloCdnIpListForm> undoCdnIpListForms) {
        this.undoCdnIpListForms = undoCdnIpListForms;
    }

    public IGloCdnIpListService getGloCdnIpListService() {
        return this.gloCdnIpListService;
    }

    public void setGloCdnIpListService(IGloCdnIpListService gloCdnIpListService) {
        this.gloCdnIpListService = gloCdnIpListService;
    }

    public IFilterDeviceZoneInfoService getFilterDeviceZoneInfoService() {
        return this.filterDeviceZoneInfoService;
    }

    public void setFilterDeviceZoneInfoService(IFilterDeviceZoneInfoService filterDeviceZoneInfoService) {
        this.filterDeviceZoneInfoService = filterDeviceZoneInfoService;
    }

    class DomainWhiteCallable
    implements Callable<String> {
        private List<GloDomainWhiteListForm> eachPart;
        private long uniqueKey;
        private int finalPartIndex;
        private CountDownLatch endCount;
        private CountDownLatch startCount;
        private ExcmdConnectUtil excmdConnectUtil;

        public DomainWhiteCallable(List<GloDomainWhiteListForm> eachPart, long uniqueKey, int finalPartIndex, CountDownLatch endCount, CountDownLatch startCount, ExcmdConnectUtil excmdConnectUtil) {
            this.eachPart = eachPart;
            this.uniqueKey = uniqueKey;
            this.finalPartIndex = finalPartIndex;
            this.endCount = endCount;
            this.startCount = startCount;
            this.excmdConnectUtil = excmdConnectUtil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            int eachPartSize = this.eachPart.size();
            int fixedNum = DomainHostFilterCmdResult.getInstance().get(this.uniqueKey, 1);
            if (fixedNum == 1) {
                GlobalDeployThread.this.currentStep = GlobalDeployThread.this.currentStep + eachPartSize;
                GlobalDeployThread.this.progressBar.next(eachPartSize);
                GlobalDeployThread.this.logger.info((Object)("PART : [" + this.finalPartIndex + "] execute over cause of the device host-filter reach fixed number!"));
                for (GloDomainWhiteListForm domainForm : this.eachPart) {
                    GlobalDeployThread.this.domainWhiteErrorDetail.add(domainForm.getDomainWhite() + " deploy failure : " + GlobalDeployThread.ZONE_HOST_REACHES_FIXED_LIMIT);
                    GlobalDeployThread.this.logger.error((Object)("domainwhitelist deploy failure , failure whitelist domain :" + domainForm.getDomainWhite() + " ," + GlobalDeployThread.ZONE_HOST_REACHES_FIXED_LIMIT));
                    domainForm.setDeployState("FAIL");
                }
                GlobalDeployThread.this.gloDomainWhiteListService.updateBatchDeployStatus(this.eachPart, "FAIL");
                this.endCount.countDown();
                return "success";
            }
            ArrayList<String> eachPartCmds = new ArrayList<String>();
            try {
                this.startCount.await();
                this.executeCmd4LimitCount(this.eachPart, eachPartCmds);
            }
            catch (LegoCheckedException e) {
                boolean tryResult = this.tryThreeTimes(this.eachPart, e, 1, eachPartCmds);
                if (!tryResult) {
                    GlobalDeployThread.this.logger.error((Object)"try again eachPartCmds error !");
                    GlobalDeployThread.this.logger.error((Object)("tryThreeTimes: " + e.getMessage()));
                    for (GloDomainWhiteListForm domainForm : this.eachPart) {
                        GlobalDeployThread.this.domainWhiteErrorDetail.add(domainForm.getDomainWhite() + " deploy failure : ERROR CODE = " + e.getErrorCode());
                        GlobalDeployThread.this.logger.error((Object)("domainwhitelist deploy failure , failure whitelist domain :" + domainForm.getDomainWhite() + ". " + e.getMessage()));
                        domainForm.setDeployState("FAIL");
                    }
                    GlobalDeployThread.this.gloDomainWhiteListService.updateBatchDeployStatus(this.eachPart, "FAIL");
                    String string = "error";
                    return string;
                }
                GlobalDeployThread.this.logger.info((Object)"try again eachPartCmds success !");
                String string = "success";
                return string;
            }
            catch (InterruptedException e) {
                GlobalDeployThread.this.logger.error((Object)e.getMessage());
            }
            finally {
                GlobalDeployThread.this.currentStep = GlobalDeployThread.this.currentStep + eachPartSize;
                GlobalDeployThread.this.progressBar.next(eachPartSize);
                GlobalDeployThread.this.logger.info((Object)("PART : [" + this.finalPartIndex + "] execute over!"));
                this.endCount.countDown();
            }
            return "success";
        }

        private boolean tryThreeTimes(List<GloDomainWhiteListForm> eachPartx, LegoCheckedException e, int times, List<String> eachPartCmds) {
            if (times > 3) {
                return false;
            }
            ++times;
            if (null != e && (e.getErrorCode() == 660050L || e.getErrorCode() == 630005L)) {
                TelnetPara telnetPara = GlobalDeployThread.this.aticDeviceService.getDeviceTelnetPara(GlobalDeployThread.this.deviceId.longValue());
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(GlobalDeployThread.this.deviceId.longValue(), this.excmdConnectUtil);
                this.excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                try {
                    this.executeCmd4LimitCount(eachPartx, eachPartCmds);
                    GlobalDeployThread.this.logger.info((Object)("tryThreeTimes times : [" + times + "] success!"));
                    return true;
                }
                catch (LegoCheckedException esub) {
                    GlobalDeployThread.this.logger.error((Object)("tryThreeTimes times : [" + times + "] error!" + esub.getMessage()));
                    this.tryThreeTimes(eachPartx, esub, times, eachPartCmds);
                }
            }
            return false;
        }

        private void executeCmd4LimitCount(List<GloDomainWhiteListForm> eachPartx, List<String> eachPartCmds) {
            eachPartCmds.clear();
            for (GloDomainWhiteListForm domainForm : eachPartx) {
                eachPartCmds.add("anti-ddos http-flood host-filter name  " + domainForm.getDomainWhite().trim());
            }
            List cmdResult = CmdUtil.execCmds((ExcmdConnectUtil)this.excmdConnectUtil, eachPartCmds, (boolean)false);
            GlobalDeployThread.this.logger.info((Object)("----------- eachPartCmds size : " + eachPartCmds.size() + " -----------------"));
            GlobalDeployThread.this.logger.info((Object)("----------- cmdResult size : " + cmdResult.size() + " -----------------"));
            GlobalDeployThread.this.logger.info((Object)("----------- cmdResult size is same with eachPartCmds : " + (cmdResult.size() == eachPartCmds.size()) + " -----------------"));
            DomainHostFilterCmdResult.getInstance().putData(this.uniqueKey, cmdResult);
            ArrayList<GloDomainWhiteListForm> successedList = new ArrayList<GloDomainWhiteListForm>();
            ArrayList<GloDomainWhiteListForm> failedList = new ArrayList<GloDomainWhiteListForm>();
            int index = 0;
            for (GloDomainWhiteListForm domainForm : eachPartx) {
                String singleCmdResultStr = (String)cmdResult.get(index);
                ++index;
                if (null == singleCmdResultStr) continue;
                if (!singleCmdResultStr.contains("Error") && !AticUtil.judgmentEcho((String)singleCmdResultStr)) {
                    domainForm.setDeployState("SUCCESS");
                    successedList.add(domainForm);
                    continue;
                }
                String str = singleCmdResultStr.substring(singleCmdResultStr.indexOf("Error:") + "Error:".length(), singleCmdResultStr.length()).replaceAll("\\[[^\\[\\]\\?\\s].*[^\\[\\]\\?\\s]\\]", "");
                GlobalDeployThread.this.domainWhiteErrorDetail.add(domainForm.getDomainWhite() + " deploy failure : " + str);
                GlobalDeployThread.this.logger.info((Object)("domainwhitelist deploy failure , failure whitelist domain :" + domainForm.getDomainWhite() + " \n " + singleCmdResultStr));
                domainForm.setDeployState("FAIL");
                failedList.add(domainForm);
            }
            GlobalDeployThread.this.gloDomainWhiteListService.updateBatchDeployStatus(successedList, "SUCCESS");
            GlobalDeployThread.this.gloDomainWhiteListService.updateBatchDeployStatus(failedList, "FAIL");
        }
    }
}

