/*
 * Decompiled with CFR 0.152.
 */
package com.restful.service.impl;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.permission.service.IPermissionService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.StringUtils;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.neglobal.util.UpdateDeployState;
import com.hs.vsm.secservice.neglobal.model.GloBlackListInfo;
import com.hs.vsm.secservice.neglobal.model.GloBlackListIpInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListIpInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGlobalDeployService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.JSONUtil;
import com.restful.model.RestGlobalBlackWhiteInfo;
import com.restful.service.RestGlobalBlackWhiteListService;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;

@Path(value="aticmgmt/policymgmt/v1/neglobal")
public class RestGlobalBlackWhiteListServiceImpl
implements RestGlobalBlackWhiteListService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private static final int DELETE_ALL = 1;
    private static final int DELETE_IPS = 2;
    private IGloBlackListService gloBlackListService;
    private IGloWhiteListService gloWhiteListService;
    private IAticDeviceService aticDeviceService;
    private IGlobalDeployService globalDeployService;
    private IPermissionService permissionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/blackwhitelist")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addGlobalBlackWhiteList(String json) {
        LOGGER.info((Object)("in addGlobalBlackWhiteList, json=" + json));
        int responseCode = 200;
        String responseMsg = "Add global blackWhiteList succeed.";
        String requestMsg = "addGlobalBlackWhiteList. restful request is json: " + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"aticmgmt/policymgmt/v1/neglobal/blackwhitelist");
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"aticmgmt/policymgmt/v1/neglobal/blackwhitelist");
            requestMsg = "addGlobalBlackWhiteList. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        if (AticUtil.isNull((String)userName)) {
            return this.handleResponse(requestMsg, 412, "illegal token.");
        }
        String apiName = "addGlobalBlackWhiteList";
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            return this.handleResponse(requestMsg, 423, "exceed concurrent api call limit.");
        }
        try {
            RestGlobalBlackWhiteInfo globalBlackWhiteInfo = this.checkGlobalBalckWhiteInfo(json);
            IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
            UserInfo userInfo = userService.getUserInfoByName(userName, false);
            this.checkPoerationPermission(userName, true);
            List<AticDevice> aticDeviceList = this.checkPermissionAndGetDevices(userInfo, globalBlackWhiteInfo, true);
            int type = this.getAndCheckType(globalBlackWhiteInfo.getBlackWhiteType());
            List<String> ipAddressList = this.checkAndTransIps(globalBlackWhiteInfo.getIps(), true);
            this.checkIPsExistAndNum(aticDeviceList, ipAddressList);
            if (1 == type) {
                this.processAddGolbalBlackList(aticDeviceList, ipAddressList, userInfo);
            } else {
                this.processAddGlobalWhiteList(aticDeviceList, ipAddressList, userInfo);
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            boolean result = this.checkDeployResult(aticDeviceList, type, resultMap);
            if (!result) {
                responseCode = 500;
                responseMsg = this.getDeployFailedResponseMsg(resultMap);
            }
        }
        catch (LegoCheckedException exception) {
            LOGGER.error((Object)("LegoCheckedException:" + exception.getMessage()));
            try {
                responseCode = Integer.parseInt(exception.getMessage());
                responseMsg = "add Global BlackWhiteList error";
            }
            catch (NumberFormatException numEx) {
                responseCode = 500;
                responseMsg = "add Global BlackWhiteList error";
            }
        }
        finally {
            VsmUtil.getInstance().releaseApiInvoke(apiName);
        }
        LOGGER.info((Object)("end addGlobalBlackWhiteList, responseCode=" + responseCode + ", responseMsg=" + responseMsg));
        this.writeAddOptLog(url, json, responseCode, terminalIp, userName);
        return this.handleResponse(requestMsg, responseCode, responseMsg);
    }

    private void writeAddOptLog(String url, String json, int responseCode, String terminalIp, String userName) {
        String[] detailPara = new String[]{url, json.replace("\r", "").replace("\n", ""), responseCode + ""};
        String[] params = new String[]{terminalIp, userName, "atic.restful.global.blackwhite.add", "atic.restful.global.blackwhite"};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
    }

    private void writeDeleteOptLog(String url, String json, int responseCode, String terminalIp, String userName) {
        String[] detailPara = new String[]{url, json.replace("\r", "").replace("\n", ""), responseCode + ""};
        String[] params = new String[]{terminalIp, userName, "atic.restful.global.blackwhite.delete", "atic.restful.global.blackwhite"};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
    }

    private RestGlobalBlackWhiteInfo checkGlobalBalckWhiteInfo(String json) {
        RestGlobalBlackWhiteInfo globalBlackWhiteInfo = (RestGlobalBlackWhiteInfo)JSONUtil.getInstance().fromJSON(json, RestGlobalBlackWhiteInfo.class);
        if (globalBlackWhiteInfo == null) {
            LOGGER.error((Object)"Input  globalBlackWhiteInfo is Null");
            throw new LegoCheckedException(String.valueOf(412));
        }
        return globalBlackWhiteInfo;
    }

    private Response handleResponse(String requestMsg, int responseCode, String responseMsg) {
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(responseCode);
        responseBuilder.entity((Object)responseMsg);
        return responseBuilder.build();
    }

    private String getDeployFailedResponseMsg(Map<String, String> resultMap) {
        StringBuffer resultBuffer = new StringBuffer();
        int index = 0;
        int size = resultMap.size();
        resultBuffer.append("{deployResult:[");
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            resultBuffer.append("\"device_ip: ").append(entry.getKey()).append(", deploy_result: ").append(entry.getValue()).append("\"");
            if (++index >= size) continue;
            resultBuffer.append(", ");
        }
        resultBuffer.append("]}");
        return resultBuffer.toString();
    }

    private void processAddGlobalWhiteList(List<AticDevice> aticDeviceList, List<String> ipAddressList, UserInfo userInfo) {
        for (AticDevice aticDevice : aticDeviceList) {
            long deviceId = aticDevice.getMoId();
            for (String ipAddress : ipAddressList) {
                String[] zoneIpDetails = ipAddress.split("/");
                String ip = zoneIpDetails[0].trim();
                int mask = Integer.parseInt(zoneIpDetails[1].trim());
                String[] srcIpRange = IPUtil.getSubnetRange((String)ip, (int)mask);
                GloWhiteListForm gloWhiteListForm = new GloWhiteListForm();
                gloWhiteListForm.setWhitelistIp(srcIpRange[0]);
                gloWhiteListForm.setStartIp(srcIpRange[0]);
                gloWhiteListForm.setEndIp(srcIpRange[1]);
                gloWhiteListForm.setMask(mask);
                gloWhiteListForm.setDeviceId(String.valueOf(deviceId));
                ArrayList<GloWhiteListForm> zifList = new ArrayList<GloWhiteListForm>();
                zifList.add(gloWhiteListForm);
                GloWhiteListIpForm gloWhiteListIpForm = new GloWhiteListIpForm();
                gloWhiteListIpForm.setWhitelistIp(ip);
                gloWhiteListIpForm.setMaskType(0);
                gloWhiteListIpForm.setIntMask(mask);
                gloWhiteListIpForm.setStartIp(srcIpRange[0]);
                gloWhiteListIpForm.setEndIp(srcIpRange[1]);
                gloWhiteListIpForm.setDeviceId(deviceId);
                gloWhiteListIpForm.setDeleteFlag(0);
                gloWhiteListIpForm.setGloWhiteListForms(zifList);
                this.gloWhiteListService.saveWhiteListIp(gloWhiteListIpForm);
                UpdateDeployState.setDeployBypassStateByRest(String.valueOf(deviceId));
            }
        }
        this.deployGlobalBlackWhiteList(aticDeviceList, userInfo.getId());
    }

    private boolean checkDeployResult(List<AticDevice> aticDeviceList, int type, Map<String, String> resultMap) {
        boolean result = true;
        for (AticDevice aticDevice : aticDeviceList) {
            long deviceId = aticDevice.getMoId();
            String deviceIp = aticDevice.getIpAddress();
            FWDefenceAbnormalForm form = UpdateDeployState.getFWDefenceAbnByDeviceId(deviceId).get();
            if (form == null) {
                LOGGER.error((Object)("get FWDefenceAbnormalForm is null by deviceIp=" + deviceIp));
                throw new LegoCheckedException("get FWDefenceAbnormalForm is null by deviceIp=" + deviceIp);
            }
            String bwlistState = "";
            String errorMsg = "";
            if (1 == type) {
                bwlistState = form.getBlistDeployState();
                errorMsg = form.getBlistErrorMsgKey();
            } else {
                bwlistState = form.getBypassDeployState();
                errorMsg = form.getBypassErrorMsgKey();
            }
            if ("SUCCESS".equals(bwlistState) && "SUCCESS".equals(form.getDeployState())) {
                resultMap.put(deviceIp, "SUCCESS");
                continue;
            }
            result = false;
            String msg = "GlobalNePolicy state: " + form.getDeployState() + ", error message is: " + form.getErrorMsgKey();
            msg = msg + ". BlackWhiteList state: " + bwlistState + ", error message is: " + errorMsg;
            resultMap.put(deviceIp, msg);
        }
        return result;
    }

    private void processAddGolbalBlackList(List<AticDevice> aticDeviceList, List<String> ipAddressList, UserInfo userInfo) {
        for (AticDevice aticDevice : aticDeviceList) {
            long deviceId = aticDevice.getMoId();
            for (String ipAddress : ipAddressList) {
                String[] zoneIpDetails = ipAddress.split("/");
                String ip = zoneIpDetails[0].trim();
                int mask = Integer.parseInt(zoneIpDetails[1].trim());
                String[] srcIpRange = IPUtil.getSubnetRange((String)ip, (int)mask);
                GloBlackListForm gloBlackListForm = new GloBlackListForm();
                gloBlackListForm.setBlacklistIp(srcIpRange[0]);
                gloBlackListForm.setStartIp(srcIpRange[0]);
                gloBlackListForm.setEndIp(srcIpRange[1]);
                gloBlackListForm.setMask(mask);
                gloBlackListForm.setDeviceId(String.valueOf(deviceId));
                ArrayList<GloBlackListForm> zifList = new ArrayList<GloBlackListForm>();
                zifList.add(gloBlackListForm);
                GloBlackListIpForm gloBlackListIpForm = new GloBlackListIpForm();
                gloBlackListIpForm.setBlacklistIp(ip);
                gloBlackListIpForm.setMaskType(0);
                gloBlackListIpForm.setIntMask(mask);
                gloBlackListIpForm.setStartIp(srcIpRange[0]);
                gloBlackListIpForm.setEndIp(srcIpRange[1]);
                gloBlackListIpForm.setDeviceId(deviceId);
                gloBlackListIpForm.setDeleteFlag(0);
                gloBlackListIpForm.setGloBlackListForms(zifList);
                this.gloBlackListService.saveBlackListIp(gloBlackListIpForm);
                UpdateDeployState.setDeployBlistStateByRest(String.valueOf(deviceId));
            }
        }
        this.deployGlobalBlackWhiteList(aticDeviceList, userInfo.getId());
    }

    private void checkPoerationPermission(String userName, boolean isConfig) {
        boolean isAdmin = "admin".equals(userName);
        if (!isAdmin) {
            if (isConfig) {
                this.checkGlobalPolicyConfigOperation(userName);
            } else {
                this.checkGlobalPolicyQueryOperation(userName);
            }
        }
    }

    private List<AticDevice> checkPermissionAndGetDevices(UserInfo userInfo, RestGlobalBlackWhiteInfo globalBlackWhiteInfo, boolean isAdd) {
        List aticDeviceList = new ArrayList();
        String deviceIp = globalBlackWhiteInfo.getDeviceIp();
        if (StringUtils.isEmpty((String)deviceIp)) {
            aticDeviceList = isAdd ? this.aticDeviceService.getCleanDevice(userInfo.getId().longValue()) : this.aticDeviceService.getAntiDDoSDevice(userInfo.getId().longValue());
            if (CollectionUtils.isEmpty(aticDeviceList)) {
                LOGGER.error((Object)"Input devieIp is Null and the current user has no clean device.");
                throw new LegoCheckedException(String.valueOf(400));
            }
        } else {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(deviceIp);
            if (null == aticDevice) {
                LOGGER.error((Object)("device is not exsit of " + deviceIp));
                throw new LegoCheckedException(String.valueOf(470));
            }
            LOGGER.info((Object)("get device= " + aticDevice.toString()));
            String userName = userInfo.getUserName();
            boolean isAdmin = "admin".equals(userName);
            if (!isAdmin) {
                this.checkDevicePermission(deviceIp, aticDevice.getMoId(), userInfo);
            }
            aticDeviceList.add((AticDevice)aticDevice);
        }
        return aticDeviceList;
    }

    private void checkIPsExistAndNum(List<AticDevice> aticDeviceList, List<String> ipAddressList) {
        for (AticDevice aticDevice : aticDeviceList) {
            int wlistNums;
            long deviceId = aticDevice.getMoId();
            String deviceIp = aticDevice.getIpAddress();
            List<GloWhiteListIpInfo> wIpList = this.gloWhiteListService.queryAllWhitelist(deviceId);
            List<GloBlackListIpInfo> bIpList = this.gloBlackListService.queryAllBlacklist(deviceId);
            for (String ipAddress : ipAddressList) {
                String[] zoneIpDetails = ipAddress.split("/");
                String ip = zoneIpDetails[0].trim();
                int mask = Integer.parseInt(zoneIpDetails[1].trim());
                String[] srcIpRange = IPUtil.getSubnetRange((String)ip, (int)mask);
                if (!CollectionUtils.isEmpty(wIpList) && this.checkIpInWhiteList(wIpList, srcIpRange)) {
                    LOGGER.error((Object)("ip is exist in whiteList. deviceIp=" + deviceIp + ", whiteBlackIp=" + ipAddress));
                    throw new LegoCheckedException(String.valueOf(448));
                }
                if (CollectionUtils.isEmpty(bIpList) || !this.checkIpInBlackList(bIpList, srcIpRange)) continue;
                LOGGER.error((Object)("ip is exist in blackList. deviceIp=" + deviceIp + ", whiteBlackIp=" + ipAddress));
                throw new LegoCheckedException(String.valueOf(448));
            }
            int blistNums = this.gloBlackListService.queryAllBlackCount(deviceId);
            if (blistNums + (wlistNums = this.gloWhiteListService.queryAllWhiteCount(deviceId)) + ipAddressList.size() < 40960) continue;
            LOGGER.error((Object)"new blackWhite IP list is over than 40960");
            throw new LegoCheckedException(String.valueOf(449));
        }
    }

    private boolean checkIpInWhiteList(List<GloWhiteListIpInfo> wIpList, String[] subNetRange) {
        for (GloWhiteListIpInfo gloListIpInfo : wIpList) {
            String[] subNetRange2;
            String[] destNetRange;
            if (!(gloListIpInfo.getMaskType() == 0 ? IPUtil4Atic.isCrossIpRange((String[])(destNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getWhitelistIp(), (int)gloListIpInfo.getIntMask())), (String[])subNetRange) : IPUtil4Atic.isCrossIpRange((String[])(subNetRange2 = new String[]{gloListIpInfo.getStartIp(), gloListIpInfo.getEndIp()}), (String[])subNetRange))) continue;
            return true;
        }
        return false;
    }

    private boolean checkIpInBlackList(List<GloBlackListIpInfo> bIpList, String[] subNetRange) {
        for (GloBlackListIpInfo gloListIpInfo : bIpList) {
            String[] subNetRange2;
            String[] destNetRange;
            if (!(gloListIpInfo.getMaskType() == 0 ? IPUtil4Atic.isCrossIpRange((String[])(destNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getBlacklistIp(), (int)gloListIpInfo.getIntMask())), (String[])subNetRange) : IPUtil4Atic.isCrossIpRange((String[])(subNetRange2 = new String[]{gloListIpInfo.getStartIp(), gloListIpInfo.getEndIp()}), (String[])subNetRange))) continue;
            return true;
        }
        return false;
    }

    private List<String> checkAndTransIps(List<String> ips, boolean isNeedCheck) {
        ArrayList<String> ipAddressList = new ArrayList<String>();
        if (!isNeedCheck) {
            return ipAddressList;
        }
        if (CollectionUtils.isEmpty(ips)) {
            LOGGER.error((Object)"illegal parameter of ips is empty.");
            throw new LegoCheckedException(String.valueOf(412));
        }
        for (String ip : ips) {
            ipAddressList.add(this.checkIpAndSalt(ip));
        }
        return ipAddressList;
    }

    private String checkIpAndSalt(String checkIp) {
        if (StringUtils.isEmpty((String)checkIp)) {
            LOGGER.error((Object)"illegal parameter of ips has empty ip.");
            throw new LegoCheckedException(String.valueOf(400));
        }
        String ip = "";
        int mask = Integer.MIN_VALUE;
        if (checkIp.contains("/")) {
            String[] zoneIpDetails = checkIp.split("/");
            ip = zoneIpDetails[0].trim();
            try {
                mask = Integer.parseInt(zoneIpDetails[1].trim());
            }
            catch (NumberFormatException numEx) {
                throw new LegoCheckedException(String.valueOf(400));
            }
        } else {
            ip = checkIp.trim();
        }
        if (IPUtil.isIpv4((String)ip) && (mask == Integer.MIN_VALUE || mask >= 8 && mask <= 32)) {
            if (mask == Integer.MIN_VALUE) {
                mask = 32;
            }
            ip = ip + "/" + mask;
        } else if (IPUtil.isIpv6((String)ip) && (mask == Integer.MIN_VALUE || mask >= 8 && mask <= 128)) {
            if (mask == Integer.MIN_VALUE) {
                mask = 128;
            }
            ip = ip + "/" + mask;
        } else {
            LOGGER.error((Object)("input ips error: " + checkIp));
            throw new LegoCheckedException(String.valueOf(400));
        }
        return ip;
    }

    private int getAndCheckType(int type) {
        if (type != 1 && type != 2) {
            LOGGER.error((Object)("input blackwhite type is error:" + type));
            throw new LegoCheckedException(String.valueOf(412));
        }
        return type;
    }

    private void checkGlobalPolicyConfigOperation(String userName) {
        List operationIds = this.permissionService.queryUserOperationId(userName);
        if (!(null != operationIds && operationIds.contains(2321L) && operationIds.contains(2323L) && operationIds.contains(2325L))) {
            LOGGER.error((Object)("The current user does not have operation to config global blackwhite list. userName=" + userName));
            throw new LegoCheckedException(String.valueOf(455));
        }
    }

    private void checkGlobalPolicyQueryOperation(String userName) {
        List operationIds = this.permissionService.queryUserOperationId(userName);
        if (null == operationIds || !operationIds.contains(2321L)) {
            LOGGER.error((Object)("The current user does not have operation to query global blackwhite list. userName=" + userName));
            throw new LegoCheckedException(String.valueOf(455));
        }
    }

    private void checkDevicePermission(String deviceIp, Long deviceId, UserInfo userInfo) {
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(deviceId);
            BisUtil.checkRestfulUserSecurity(moIdList, (long)userInfo.getId(), (boolean)userInfo.isIsAdmin());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("The current user does not have the resources for this device " + deviceIp));
            throw new LegoCheckedException(String.valueOf(455));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/blackwhitelist/batch-delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteGlobalBlackWhiteList(String json) {
        LOGGER.info((Object)("in deleteGlobalBlackWhiteList, json=" + json));
        int responseCode = 200;
        String responseMsg = "Delete global blackWhiteList succeed";
        String requestMsg = "deleteGlobalBlackWhiteList. restful request is json: " + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"aticmgmt/policymgmt/v1/neglobal/blackwhitelist/batch-delete");
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"aticmgmt/policymgmt/v1/neglobal/blackwhitelist/batch-delete");
            requestMsg = "deleteGlobalBlackWhiteList. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        if (AticUtil.isNull((String)userName)) {
            return this.handleResponse(requestMsg, 412, "illegal token.");
        }
        String apiName = "deleteGlobalBlackWhiteList";
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            return this.handleResponse(requestMsg, 423, "exceed concurrent api call limit.");
        }
        try {
            RestGlobalBlackWhiteInfo globalBlackWhiteInfo = this.checkGlobalBalckWhiteInfo(json);
            IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
            UserInfo userInfo = userService.getUserInfoByName(userName, false);
            this.checkPoerationPermission(userName, true);
            List<AticDevice> aticDeviceList = this.checkPermissionAndGetDevices(userInfo, globalBlackWhiteInfo, false);
            int type = this.getAndCheckType(globalBlackWhiteInfo.getBlackWhiteType());
            int deleteAll = this.checkAndGetDeleteAll(globalBlackWhiteInfo.getDeleteAll());
            List<String> ipAddressList = this.checkAndTransIps(globalBlackWhiteInfo.getIps(), 2 == deleteAll);
            if (1 == type) {
                this.processDeleteGolbalBlackList(aticDeviceList, ipAddressList, userInfo);
            } else {
                this.processDeleteGlobalWhiteList(aticDeviceList, ipAddressList, userInfo);
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            boolean result = this.checkDeployResult(aticDeviceList, type, resultMap);
            if (!result) {
                responseCode = 500;
                responseMsg = this.getDeployFailedResponseMsg(resultMap);
            }
        }
        catch (LegoCheckedException e1) {
            LOGGER.error((Object)"LegoCheckedException ", (Throwable)e1);
            try {
                responseCode = Integer.parseInt(e1.getMessage());
                responseMsg = "Delete Global BlackWhiteList error";
            }
            catch (NumberFormatException e2) {
                responseCode = 500;
                responseMsg = "Delete Global BlackWhiteList error";
            }
        }
        finally {
            VsmUtil.getInstance().releaseApiInvoke(apiName);
        }
        LOGGER.info((Object)("end deleteGlobalBlackWhiteList, responseCode=" + responseCode + ", responseMsg=" + responseMsg));
        this.writeDeleteOptLog(url, json, responseCode, terminalIp, userName);
        return this.handleResponse(requestMsg, responseCode, responseMsg);
    }

    private int checkAndGetDeleteAll(int deleteAll) {
        if (deleteAll != 1 && deleteAll != 2) {
            LOGGER.error((Object)("illegal parameter of delete_all:" + deleteAll));
            throw new LegoCheckedException(String.valueOf(412));
        }
        return deleteAll;
    }

    private void processDeleteGolbalBlackList(List<AticDevice> aticDeviceList, List<String> ipAddressList, UserInfo userInfo) {
        if (CollectionUtils.isEmpty(ipAddressList)) {
            for (AticDevice aticDevice : aticDeviceList) {
                Long deviceId = aticDevice.getMoId();
                String deviceIp = aticDevice.getIpAddress();
                try {
                    this.gloBlackListService.batchDelAllGloBlackList2(String.valueOf(deviceId));
                    LOGGER.info((Object)("delete AllIpBlackList sucess by Device: " + deviceIp));
                }
                catch (LegoCheckedException e) {
                    LOGGER.error((Object)("delete all blacklist is failed of device=" + deviceIp + ". error=" + e.getMessage()));
                    throw new LegoCheckedException(String.valueOf(500));
                }
            }
        } else {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (AticDevice aticDevice : aticDeviceList) {
                String deviceIp = aticDevice.getIpAddress();
                List<GloBlackListIpInfo> bIpList = this.gloBlackListService.queryAllBlacklist(aticDevice.getMoId());
                if (CollectionUtils.isEmpty(bIpList)) {
                    LOGGER.error((Object)("device " + deviceIp + " doesnot have globalBlackList "));
                    throw new LegoCheckedException(String.valueOf(446));
                }
                for (String ipAddress : ipAddressList) {
                    boolean isExist = false;
                    String[] zoneIpDetails = ipAddress.split("/");
                    String ip = zoneIpDetails[0].trim();
                    int mask = Integer.parseInt(zoneIpDetails[1].trim());
                    for (GloBlackListIpInfo blackIpInfo : bIpList) {
                        if (!ip.equals(blackIpInfo.getBlacklistIp()) || mask != blackIpInfo.getIntMask()) continue;
                        BatchOperation bo = new BatchOperation();
                        bo.setTargetId(blackIpInfo.getPkid().longValue());
                        bo.setTargetName(aticDevice.getName());
                        batchOpList.add(bo);
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    LOGGER.error((Object)("device " + deviceIp + " doesnot have ip " + ipAddress));
                    throw new LegoCheckedException(String.valueOf(446));
                }
            }
            try {
                this.gloBlackListService.batchDelGloBlackList2(batchOpList);
                LOGGER.info((Object)"delete IpBlackList sucess: ");
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("delete IpBlackList is failed. error=" + e.getMessage()));
                throw new LegoCheckedException(String.valueOf(500));
            }
        }
        this.deployGlobalBlackWhiteList(aticDeviceList, userInfo.getId());
    }

    private void processDeleteGlobalWhiteList(List<AticDevice> aticDeviceList, List<String> ipAddressList, UserInfo userInfo) {
        if (CollectionUtils.isEmpty(ipAddressList)) {
            for (AticDevice aticDevice : aticDeviceList) {
                Long deviceId = aticDevice.getMoId();
                String deviceIp = aticDevice.getIpAddress();
                try {
                    this.gloWhiteListService.batchDelAllGloWhiteList2(String.valueOf(deviceId));
                    LOGGER.info((Object)("delete AllIpWhiteList sucess by Device: " + deviceIp));
                }
                catch (LegoCheckedException e) {
                    LOGGER.error((Object)("delete all Whitelist is failed of device=" + deviceIp + ". error=" + e.getMessage()));
                    throw new LegoCheckedException(String.valueOf(500));
                }
            }
        } else {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (AticDevice aticDevice : aticDeviceList) {
                String deviceIp = aticDevice.getIpAddress();
                List<GloWhiteListIpInfo> bIpList = this.gloWhiteListService.queryAllWhitelist(aticDevice.getMoId());
                if (CollectionUtils.isEmpty(bIpList)) {
                    LOGGER.error((Object)("device " + deviceIp + " doesnot have globalWhiteList "));
                    throw new LegoCheckedException(String.valueOf(446));
                }
                for (String ipAddress : ipAddressList) {
                    boolean isExist = false;
                    String[] zoneIpDetails = ipAddress.split("/");
                    String ip = zoneIpDetails[0].trim();
                    int mask = Integer.parseInt(zoneIpDetails[1].trim());
                    for (GloWhiteListIpInfo whiteListIpInfo : bIpList) {
                        if (!ip.equals(whiteListIpInfo.getWhitelistIp()) || mask != whiteListIpInfo.getIntMask()) continue;
                        BatchOperation bo = new BatchOperation();
                        bo.setTargetId(whiteListIpInfo.getPkid().longValue());
                        bo.setTargetName(aticDevice.getName());
                        batchOpList.add(bo);
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    LOGGER.error((Object)("device " + deviceIp + " doesnot have ip " + ipAddress));
                    throw new LegoCheckedException(String.valueOf(446));
                }
            }
            try {
                this.gloWhiteListService.batchDelGloWhiteList2(batchOpList);
                LOGGER.info((Object)"delete IpWhiteList sucess.");
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("delete IpWhiteList is failed. error=" + e.getMessage()));
                throw new LegoCheckedException(String.valueOf(500));
            }
            this.deployGlobalBlackWhiteList(aticDeviceList, userInfo.getId());
        }
    }

    private void deployGlobalBlackWhiteList(List<AticDevice> aticDeviceList, Long userId) {
        for (AticDevice aticDevice : aticDeviceList) {
            long deviceId = aticDevice.getMoId();
            String deviceIp = aticDevice.getIpAddress();
            HashMap<Long, String> deployResult = new HashMap<Long, String>();
            HashMap<Long, String> errorDetail = new HashMap<Long, String>();
            this.globalDeployService.deploy(deviceId, userId, deployResult, errorDetail);
            LOGGER.info((Object)("doDeploy is success,Object is " + aticDevice.getIpAddress() + ". deployResult=" + ((Object)deployResult).toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/blackwhitelist/query")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryGlobalBlackWhiteList(String json) {
        LOGGER.info((Object)("in queryGlobalBlackWhiteList, json=" + json));
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"aticmgmt/policymgmt/v1/neglobal/blackwhitelist/query");
        String requestMsg = "queryGlobalBlackWhiteList. restful request is json: " + json;
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"aticmgmt/policymgmt/v1/neglobal/blackwhitelist/query");
            requestMsg = "queryGlobalBlackWhiteList. restful request url : " + url + ". json :" + json;
        }
        int responseCode = 200;
        String responseMsg = "query global blackWhiteList succeed";
        if (AticUtil.isNull((String)userName)) {
            return this.handleResponse(requestMsg, 412, "illegal token.");
        }
        String apiName = "queryGlobalBlackWhiteList";
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            return this.handleResponse(requestMsg, 423, "exceed concurrent api call limit.");
        }
        try {
            RestGlobalBlackWhiteInfo globalBlackWhiteInfo = this.checkGlobalBalckWhiteInfo(json);
            IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
            UserInfo userInfo = userService.getUserInfoByName(userName, false);
            this.checkPoerationPermission(userName, false);
            List<AticDevice> aticDeviceList = this.checkPermissionAndGetDevices(userInfo, globalBlackWhiteInfo, false);
            int type = this.getAndCheckType(globalBlackWhiteInfo.getBlackWhiteType());
            StringBuilder resultStr = null;
            resultStr = 1 == type ? this.queryGlobalBlackList(aticDeviceList) : this.queryGlobalWhiteList(aticDeviceList);
            LOGGER.info((Object)("queryGlobalBlackWhiteList end, resultStr=" + resultStr.toString()));
            responseMsg = resultStr.toString();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("LegoCheckedException" + e.getMessage()));
            try {
                responseCode = Integer.parseInt(e.getMessage());
                responseMsg = "query Global BlackWhite List error";
            }
            catch (NumberFormatException e2) {
                responseCode = 500;
                responseMsg = e2.getMessage();
            }
        }
        finally {
            VsmUtil.getInstance().releaseApiInvoke(apiName);
        }
        return this.handleResponse(requestMsg, responseCode, responseMsg);
    }

    private StringBuilder queryGlobalWhiteList(List<AticDevice> aticDeviceList) {
        StringBuilder resultStr = new StringBuilder();
        resultStr.append("{\"device_ips\":[");
        boolean isStart = true;
        for (AticDevice aticDevice : aticDeviceList) {
            long deviceId = aticDevice.getMoId();
            List<GloWhiteListInfo> wIpList = this.gloWhiteListService.queryByDeviceId(deviceId);
            if (!CollectionUtils.isEmpty(wIpList)) {
                LOGGER.info((Object)("get global whitelist sucess by deviceIp=" + aticDevice.getIpAddress() + ", wIpList.size=" + wIpList.size()));
                if (!isStart) {
                    resultStr.append(',');
                }
                resultStr.append("{\"device_ip\": \"").append(aticDevice.getIpAddress()).append("\",\"ips\":[");
                int index = 0;
                for (GloWhiteListInfo whiteIpInfo : wIpList) {
                    LOGGER.info((Object)("get global whitelist index " + index + " whiteIpInfo=" + whiteIpInfo.toString()));
                    resultStr.append('\"').append(whiteIpInfo.getWhitelistIp()).append("/").append(whiteIpInfo.getMask()).append('\"');
                    if (++index >= wIpList.size()) continue;
                    resultStr.append(',');
                }
                resultStr.append("]}");
                isStart = false;
                continue;
            }
            LOGGER.info((Object)("get global whitelist is empty by deviceIp=" + aticDevice.getIpAddress() + ", deviceId=" + deviceId));
        }
        resultStr.append("]}");
        return resultStr;
    }

    private StringBuilder queryGlobalBlackList(List<AticDevice> aticDeviceList) {
        StringBuilder resultStr = new StringBuilder();
        resultStr.append("{\"device_ips\":[");
        boolean isStart = true;
        for (AticDevice aticDevice : aticDeviceList) {
            long deviceId = aticDevice.getMoId();
            List<GloBlackListInfo> bIpList = this.gloBlackListService.queryByDeviceId(deviceId);
            if (!CollectionUtils.isEmpty(bIpList)) {
                LOGGER.info((Object)("get global blacklist sucess by deviceIp=" + aticDevice.getIpAddress() + ", bIpList.size=" + bIpList.size()));
                if (!isStart) {
                    resultStr.append(',');
                }
                resultStr.append("{\"device_ip\": \"").append(aticDevice.getIpAddress()).append("\",\"ips\":[");
                int index = 0;
                for (GloBlackListInfo blackIpInfo : bIpList) {
                    LOGGER.info((Object)("get global blacklist index " + index + " blackIpInfo=" + blackIpInfo.toString()));
                    resultStr.append('\"').append(blackIpInfo.getBlacklistIp()).append("/").append(blackIpInfo.getMask()).append('\"');
                    if (++index >= bIpList.size()) continue;
                    resultStr.append(',');
                }
                resultStr.append("]}");
                isStart = false;
                continue;
            }
            LOGGER.info((Object)("get global blacklist is empty by deviceIp=" + aticDevice.getIpAddress() + ", deviceId=" + deviceId));
        }
        resultStr.append("]}");
        return resultStr;
    }

    public IGloBlackListService getGloBlackListService() {
        return this.gloBlackListService;
    }

    public void setGloBlackListService(IGloBlackListService gloBlackListService) {
        this.gloBlackListService = gloBlackListService;
    }

    public IGloWhiteListService getGloWhiteListService() {
        return this.gloWhiteListService;
    }

    public void setGloWhiteListService(IGloWhiteListService gloWhiteListService) {
        this.gloWhiteListService = gloWhiteListService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IGlobalDeployService getGlobalDeployService() {
        return this.globalDeployService;
    }

    public void setGlobalDeployService(IGlobalDeployService globalDeployService) {
        this.globalDeployService = globalDeployService;
    }

    public IPermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(IPermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

