/*
 * Decompiled with CFR 0.152.
 */
package com.restful.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.permission.service.IPermissionService;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneIpLocationInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.ddos.service.data.ZoneUdpBlockInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneIpLocationService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IDivertForPolicy;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import com.restful.model.CommonResult;
import com.restful.model.DefenseModeParamsInfo;
import com.restful.model.IpLocationInfo;
import com.restful.model.LocationPolicyInfo;
import com.restful.model.LocationPolicyResult;
import com.restful.model.PolicyParamsInfo;
import com.restful.model.RestFaultSeverityRuleInfo;
import com.restful.model.RestPolicyFilterInfo;
import com.restful.model.RestPolicyParamsInfo;
import com.restful.model.RestUdpPolicyInfo;
import com.restful.model.RestZoneInfo;
import com.restful.model.RestZoneInfoForMss;
import com.restful.model.RestZoneIpInfo;
import com.restful.model.RestfuResult;
import com.restful.model.ZoneLocationInfo;
import com.restful.model.ZoneLocationInfos;
import com.restful.service.RestZoneService;
import com.restful.util.IpLocationUtil;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestLogInfo;
import com.restful.util.RestUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

@Path(value="ddos")
public class RestZoneServiceImpl
implements RestZoneService {
    private static final int DEVICE_NAME_LENGTH = 32;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    private Map<String, List<String>> featureMap = new ConcurrentHashMap<String, List<String>>();
    private IPermissionService permissionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/zone")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createZone(String json) {
        ZoneDeviceForm form;
        IUserService userService;
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        int responseCode = 500;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone");
        String requestMsg = "createZone. restful request is null. json string is :" + json + ". ";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone");
            requestMsg = "restful request url : " + url + ". json string is :" + json + ". ";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.create.zone");
        logInfo.setTargetLocal(false);
        RestZoneInfo restZoneInfo = null;
        String apiName = "createZone";
        logInfo.setApiName(apiName);
        try {
            this.checkJson(json);
            restZoneInfo = (RestZoneInfo)JSONUtil.getInstance().fromJSON(json, RestZoneInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            this.logger.error((Object)("Exception :" + e.getMessage()));
            return responseBuilder.build();
        }
        String zoneName = restZoneInfo.getZoneName();
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token " + requestMsg));
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            return response;
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2421L) && operationIds.contains(2423L) && operationIds.contains(2202L))) {
            responseMsg = "current user can not create zone.";
            responseCode = 455;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        ZoneInfoForm zoneForm = new ZoneInfoForm();
        if (zoneName == null || "".equals(zoneName.trim()) || "null".equals(zoneName)) {
            responseCode = 400;
            responseMsg = "zoneName cannot be empty";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (32 < zoneName.length()) {
            responseCode = 400;
            responseMsg = "zoneName's length is more than 32. zoneName is:" + zoneName;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        String zoneDescRegex = "^(?!null$)[^, \\'\\<\\>\\\\\\|\\&%/;:\\*\\?\"=][^, \\'\\<\\>\\\\\\|\\&%/;:\\*\\?\"=]*?$";
        String zoneNameRegex = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (!zoneName.matches(zoneDescRegex) || !zoneName.matches(zoneNameRegex)) {
            responseCode = 400;
            responseMsg = "illegal parameter.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        zoneForm.setZoneName(restZoneInfo.getZoneName());
        zoneForm.setZoneDesc(restZoneInfo.getZoneName());
        zoneForm.setZoneType(Integer.valueOf(2));
        zoneForm.setRemark("");
        ArrayList<ZoneIpForm> zoneIpForms = new ArrayList<ZoneIpForm>();
        List<Object> zoneListIpFormList = new ArrayList<ZoneListIpForm>();
        ArrayList<String> zoneIpsTemp = new ArrayList<String>();
        List zoneIps = restZoneInfo.getZoneIp();
        if (zoneIps.size() > 50) {
            this.logger.error((Object)"zoneIps length exceeds the 50 limit.");
            responseMsg = "zoneIps length exceeds the 50 limit.";
            responseCode = 413;
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            return builder.build();
        }
        for (String zoneIp : zoneIps) {
            if (zoneIp.contains("/")) {
                ZoneIpForm iptemp = new ZoneIpForm();
                String[] zoneIpDetails = zoneIp.split("/");
                String[] rangeIps = null;
                try {
                    rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
                }
                catch (RuntimeException e) {
                    responseCode = 400;
                    responseMsg = "illegal parameter.";
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    return responseBuilder.build();
                }
                iptemp.setZoneIp(zoneIpDetails[0]);
                iptemp.setMask(Integer.valueOf(zoneIpDetails[1]));
                iptemp.setStartIp(rangeIps[0]);
                iptemp.setEndIp(rangeIps[1]);
                zoneIpForms.add(iptemp);
                ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
                zoneListIpForm.setEndIp(rangeIps[1]);
                zoneListIpForm.setStartIp(rangeIps[0]);
                zoneListIpForm.setIntMask(Integer.parseInt(zoneIpDetails[1]));
                zoneListIpForm.setIpType(0);
                zoneListIpForm.setMaskType(0);
                zoneListIpForm.setZoneIp(zoneIpDetails[0]);
                zoneListIpForm.setDeployState(false);
                zoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                zoneListIpFormList.add(zoneListIpForm);
                zoneIpsTemp.add(IPUtil4Atic.convert2CompleteIp((String)zoneIpDetails[0]) + "/" + zoneIpDetails[1]);
                continue;
            }
            responseCode = 409;
            responseMsg = "the zone ip format is not correct. zoneIp is " + zoneIp;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        boolean isSameZone = false;
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        List zoneInfoFormList = zoneService.getZoneByNameOrDesc(zoneForm.getZoneName(), zoneForm.getZoneName());
        if (null != zoneInfoFormList && !zoneInfoFormList.isEmpty()) {
            ZoneInfoForm zoneInfoForm;
            if (1 == zoneInfoFormList.size() && null != (zoneInfoForm = (ZoneInfoForm)zoneInfoFormList.get(0)).getZoneType() && 2 == zoneInfoForm.getZoneType() && zoneName.equalsIgnoreCase(zoneInfoForm.getZoneName()) && zoneName.equalsIgnoreCase(zoneInfoForm.getZoneDesc())) {
                block56: {
                    if (!isAdmin) {
                        ArrayList<Long> moIdList = new ArrayList<Long>();
                        moIdList.add(zoneInfoForm.getMoId());
                        try {
                            BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                        }
                        catch (LegoCheckedException e) {
                            if (630114L == e.getErrorCode()) {
                                responseCode = 455;
                                responseMsg = "The current user does not have the resources for this zone.";
                                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                                responseBuilder = responseBuilder.status(responseCode);
                                responseBuilder.entity((Object)responseMsg);
                                this.logger.error((Object)("Exception :" + e.getMessage()));
                                return responseBuilder.build();
                            }
                            if (570506L != e.getErrorCode()) break block56;
                            responseCode = 500;
                            responseMsg = "Unable to get the service published in the background.";
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            this.logger.error((Object)("Exception :" + e.getMessage()));
                            return responseBuilder.build();
                        }
                    }
                }
                zoneForm = zoneInfoForm;
                List zoneListIpForms = zoneService.getListIpByZoneId(zoneInfoForm.getZoneId());
                if (null != zoneListIpForms && zoneListIpForms.size() == zoneIps.size()) {
                    ZoneListIpForm zoneListIpForm;
                    ArrayList<String> zoneListIpFormTemp = new ArrayList<String>();
                    Iterator iterator = zoneListIpForms.iterator();
                    while (iterator.hasNext() && 1 != (zoneListIpForm = (ZoneListIpForm)iterator.next()).getIpType()) {
                        zoneListIpFormTemp.add(IPUtil4Atic.convert2CompleteIp((String)zoneListIpForm.getZoneIp()) + "/" + zoneListIpForm.getIntMask());
                    }
                    if (zoneListIpFormTemp.size() == zoneIps.size() && zoneListIpFormTemp.equals(zoneIpsTemp)) {
                        isSameZone = true;
                        zoneListIpFormList = zoneListIpForms;
                    }
                }
            }
            if (!isSameZone) {
                responseCode = 409;
                responseMsg = "createZone. zone is exist already.";
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
        } else {
            for (ZoneIpForm zoneIpForm : zoneIpForms) {
                List existForms = zoneService.findExistIp(zoneIpForm);
                if (null == existForms || existForms.isEmpty()) continue;
                responseCode = 409;
                responseMsg = "createZone. zone ip address is exist already. start ip : " + zoneIpForm.getStartIp() + ", end ip: " + zoneIpForm.getEndIp();
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
        }
        zoneForm.setZoneIpFormList(zoneIpForms);
        zoneForm.setZoneListIpFormList(zoneListIpFormList);
        zoneForm.setIndustry("Gaming");
        Long zoneId = 0L;
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        if (isSameZone) {
            ZoneInfoForm zoneInfoForm = zoneService.getZoneByName(zoneName);
            zoneId = zoneInfoForm == null ? Long.valueOf(0L) : zoneInfoForm.getZoneId();
            zoneIdList.add(zoneId);
            try {
                VsmUtil.getInstance().lockSet(zoneIdList, "createZone");
            }
            catch (LegoCheckedException ex) {
                responseCode = 500;
                responseMsg = String.format("Zone %s is Locked", zoneName);
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setTarget(zoneName);
                this.logger.error((Object)("Exception :" + ex.getMessage()));
                return this.logExit(logInfo);
            }
        }
        if (null != (userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class))) {
            try {
                UserInfo userInfoByName = userService.getUserInfoByName(userName, false);
                if (null != userInfoByName) {
                    zoneId = zoneService.saveZone(zoneForm, userInfoByName.getId(), !isSameZone);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("save zone failed. " + e.getMessage()));
            }
        }
        if (null == zoneId || zoneId == 0L) {
            responseCode = 500;
            responseMsg = "createZone. saveZone failed.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            logInfo.setTarget(zoneName);
            return this.logExit(logInfo);
        }
        if (!isSameZone) {
            zoneForm.setZoneId(zoneId);
            zoneIdList.add(zoneId);
        }
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = zonePolicyApplyService.queryByZoneId(zoneId);
        IZoneDeviceService zoneDeviceService = ZoneBisUtil.getIZoneDeviceService();
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        ArrayList<ZoneDeviceForm> zoneDeviceForms = zoneDeviceService.queryZoneDeviceFormsByZoneID(zonePolicyApplyForm.getZoneId());
        List ddosNeList = aticDeviceService.getAntiDDoSDevice(userId);
        if (zoneDeviceForms == null || zoneDeviceForms.isEmpty()) {
            zoneDeviceForms = new ArrayList<ZoneDeviceForm>();
            for (AticDevice ne : ddosNeList) {
                form = new ZoneDeviceForm();
                form.setDeviceId(Long.valueOf(ne.getMoId()));
                form.setZoneId(zonePolicyApplyForm.getZoneId());
                zoneDeviceForms.add(form);
            }
        }
        zonePolicyApplyForm.setZoneDeviceForms(zoneDeviceForms);
        zonePolicyApplyForm.setDefendMode(Integer.valueOf(0));
        zonePolicyApplyForm.setDirection(1);
        boolean isError = false;
        try {
            zonePolicyApplyService.savePolicy(zonePolicyApplyForm, false);
        }
        catch (LegoCheckedException e) {
            isError = true;
            if (630154L == e.getErrorCode()) {
                responseCode = 423;
                responseMsg = String.format("Zone %s is Locked", zoneName);
            } else {
                responseCode = 500;
                responseMsg = String.format("createZone. save zonePolicyApplyForm happen exception ,Zone %s .", zoneName);
            }
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            this.logger.error((Object)("Exception :" + e.getMessage()));
            form = this.logExit(logInfo);
            return form;
        }
        catch (Exception e) {
            isError = true;
            responseCode = 500;
            responseMsg = String.format("createZone. save zonePolicyApplyForm happen exception ,Zone is %s .", zoneName);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            this.logger.error((Object)("Exception :" + e.getMessage()));
            form = this.logExit(logInfo);
            return form;
        }
        finally {
            if (isError && isSameZone) {
                VsmUtil.getInstance().unLockSet(zoneIdList, "createZone");
            }
        }
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        try {
            zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("createZone"), null);
        }
        catch (LegoCheckedException e) {
            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            responseMsg = "createZone. deploy failed. zoneName is " + zoneForm.getZoneDesc() + "; error message is : " + errorMsg;
            responseCode = 507;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            this.logger.error((Object)("Exception :" + e.getMessage()));
            Response response = this.logExit(logInfo);
            return response;
        }
        catch (Exception e) {
            responseMsg = "ATIC inner error occurred while deploy zone. zoneName is " + zoneForm.getZoneDesc();
            responseCode = 507;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            this.logger.error((Object)("deploy inner error,Exception: " + e.getMessage()));
            Response response = this.logExit(logInfo);
            return response;
        }
        finally {
            if (isSameZone) {
                VsmUtil.getInstance().unLockSet(zoneIdList, "createZone");
            }
        }
        List listResult = zonePolicyMgrService.queryDeployResultByZoneId(zoneId);
        for (ZoneDeviceDeployStatusForm form2 : listResult) {
            if (1 != form2.getDeployType() || form2.getDeployState().booleanValue()) continue;
            String errorMsgKey = form2.getErrorMsgKey();
            Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
            if (this.isInvalidErrorMsgKey(errorMsgKey = AticUtil.getText((String)errorMsgKey, (Locale)locale))) continue;
            String errorParam = form2.getErrorParam();
            errorMsgKey = errorMsgKey.replaceFirst("\\$0", errorParam == null ? "" : errorParam);
            responseMsg = "createZone. deploy failed. zoneName is " + zoneForm.getZoneDesc() + "; error message is : " + errorMsgKey;
            responseCode = 507;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            return this.logExit(logInfo);
        }
        responseCode = 201;
        responseMsg = "createZone succeed.";
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(String.valueOf(responseCode));
        logInfo.setTarget(zoneName);
        return this.logExit(logInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DELETE
    @Path(value="/zone/{zone_name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteZone(@PathParam(value="zone_name") String zoneName) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone/{zone_name}");
        String requestMsg = "deleteZone. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String json = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone/" + zoneName));
            requestMsg = "restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        int responseCode = 500;
        String responseMsg = "";
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.delete.zone");
        logInfo.setTargetLocal(false);
        logInfo.setRequestMsg(requestMsg);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token" + requestMsg + " ,zoneName : " + zoneName));
        String apiName = "deleteZone";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            return response;
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2422L))) {
            responseMsg = "current user can not delete zone.";
            responseCode = 455;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        String zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (null == zoneName || zoneName.length() > 32 || !zoneName.matches(zoneNameRegexS)) {
            responseCode = 400;
            responseMsg = "illegal parameter.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (!zoneService.isZoneNameExists(zoneName, Long.valueOf(0L))) {
            responseCode = 404;
            responseMsg = "deleteZone. zone is not exist.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        ZoneInfoForm zoneInfoForm = zoneService.getZoneByName(zoneName);
        Long zoneId = zoneInfoForm == null ? Long.valueOf(0L) : zoneInfoForm.getZoneId();
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        if (!isAdmin) {
            block20: {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneInfoForm == null ? Long.valueOf(0L) : zoneInfoForm.getMoId());
                try {
                    IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                    long userId = userMgr.getUserInfoByName(userName).getId();
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                    if (570506L != e.getErrorCode()) break block20;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
            }
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(responseBuilder, logInfo, e);
            }
        }
        try {
            VsmUtil.getInstance().lockZones(zoneIdList, "lockZone");
        }
        catch (LegoCheckedException ex) {
            responseCode = 500;
            responseMsg = String.format("Zone %s is Locked", zoneName);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            this.logger.error((Object)("Exception :" + ex.getMessage()));
            return this.logExit(logInfo);
        }
        String result = null;
        try {
            result = zoneService.delZoneByName(zoneName);
        }
        catch (Exception ex) {
            responseCode = 500;
            responseMsg = String.format("delete zone %s is failed", zoneName);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            this.logger.error((Object)("Exception :" + ex.getMessage()));
            Response response = this.logExit(logInfo);
            return response;
        }
        finally {
            VsmUtil.getInstance().unlockZones(zoneIdList);
        }
        if (!"success".equals(result)) {
            responseCode = 500;
            responseMsg = result;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            return this.logExit(logInfo);
        }
        responseCode = 200;
        responseMsg = "deleteZone succeed.";
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(String.valueOf(responseCode));
        logInfo.setTarget(zoneName);
        return this.logExit(logInfo);
    }

    private Response buildErrorResponse(Response.ResponseBuilder responseBuilder, RestLogInfo logInfo, LegoCheckedException e) {
        if (630114L == e.getErrorCode()) {
            int responseCode = 455;
            String responseMsg = "The current user does not have the device resource permissions associated with the this zone.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (570506L == e.getErrorCode()) {
            int responseCode = 500;
            String responseMsg = "Unable to get the service published in the background.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        return responseBuilder.build();
    }

    private Response buildErrorResponse(RestLogInfo logInfo, LegoCheckedException e) {
        if (630114L == e.getErrorCode()) {
            int responseCode = 455;
            String responseMsg = "The current user does not have the device resource permissions associated with the this zone.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogExit(logInfo);
        }
        if (570506L == e.getErrorCode()) {
            int responseCode = 500;
            String responseMsg = "Unable to get the service published in the background.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogExit(logInfo);
        }
        return this.noOpeLogExit(logInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PUT
    @Path(value="/zone/{zone_name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateZone(@PathParam(value="zone_name") String zoneName, String json) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone/{zone_name}");
        String requestMsg = "updateZone. restful request is null. json is :" + json + ". ";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone/" + zoneName));
            requestMsg = "restful request url : " + url + ". json is :" + json + ". ";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.update.zone");
        logInfo.setTargetLocal(false);
        logInfo.setRequestMsg(requestMsg);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        String apiName = "updateZone";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            return response;
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2423L) && operationIds.contains(2202L))) {
            responseMsg = "current user can not update zone.";
            responseCode = 455;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        String zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (null == zoneName || zoneName.length() > 32 || !zoneName.matches(zoneNameRegexS)) {
            responseCode = 400;
            responseMsg = "illegal parameter.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token " + requestMsg));
        RestZoneIpInfo restZoneIpInfo = null;
        try {
            this.checkJson(json);
            restZoneIpInfo = (RestZoneIpInfo)JSONUtil.getInstance().fromJSON(json, RestZoneIpInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error, convert the format from java to pojo ip bean failed.";
            responseCode = 422;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            this.logger.error((Object)("Exception :" + e.getMessage()));
            return responseBuilder.build();
        }
        ArrayList<ZoneIpForm> zoneIpForms = new ArrayList<ZoneIpForm>();
        ArrayList<ZoneListIpForm> zoneListIpFormList = new ArrayList<ZoneListIpForm>();
        List zoneIps = restZoneIpInfo.getZoneIp();
        if (zoneIps.size() > 50) {
            this.logger.error((Object)"zoneIps length exceeds the 50 limit.");
            responseMsg = "zoneIps length exceeds the 50 limit.";
            responseCode = 413;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        for (String zoneIp : zoneIps) {
            if (zoneIp.contains("/")) {
                ZoneIpForm iptemp = new ZoneIpForm();
                String[] zoneIpDetails = zoneIp.split("/");
                String[] rangeIps = null;
                try {
                    rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
                }
                catch (Exception e) {
                    responseMsg = "illegal parameter.";
                    responseCode = 400;
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    return responseBuilder.build();
                }
                iptemp.setZoneIp(zoneIpDetails[0]);
                iptemp.setMask(Integer.valueOf(zoneIpDetails[1]));
                iptemp.setStartIp(rangeIps[0]);
                iptemp.setEndIp(rangeIps[1]);
                zoneIpForms.add(iptemp);
                ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
                zoneListIpForm.setEndIp(rangeIps[1]);
                zoneListIpForm.setStartIp(rangeIps[0]);
                zoneListIpForm.setIntMask(Integer.parseInt(zoneIpDetails[1]));
                zoneListIpForm.setIpType(0);
                zoneListIpForm.setMaskType(0);
                zoneListIpForm.setZoneIp(zoneIpDetails[0]);
                zoneListIpForm.setDeployState(false);
                zoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                zoneListIpFormList.add(zoneListIpForm);
                continue;
            }
            responseCode = 400;
            responseMsg = "the zone ip format is not correct. zoneIp is " + zoneIp;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        ZoneInfoForm zoneForm = null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        zoneForm = zoneService.getCustomZoneByName(zoneName);
        if (null != zoneForm) {
            String errorMsg;
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            zoneIdList.add(zoneForm.getZoneId());
            if (!isAdmin) {
                block31: {
                    ArrayList moIdList = new ArrayList();
                    moIdList.add(zoneForm.getMoId());
                    try {
                        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                        long userId = userMgr.getUserInfoByName(userName).getId();
                        BisUtil.checkRestfulUserSecurity((List)moIdList, (long)userId, (boolean)isAdmin);
                    }
                    catch (LegoCheckedException e) {
                        if (630114L == e.getErrorCode()) {
                            responseCode = 455;
                            responseMsg = "The current user does not have the resources for this zone.";
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            return responseBuilder.build();
                        }
                        if (570506L != e.getErrorCode()) break block31;
                        responseCode = 500;
                        responseMsg = "Unable to get the service published in the background.";
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                }
                try {
                    this.checkDevicePermissionByUserName(userName, zoneIdList);
                }
                catch (LegoCheckedException e) {
                    return this.buildErrorResponse(responseBuilder, logInfo, e);
                }
            }
            for (ZoneIpForm zoneIpForm : zoneIpForms) {
                List existForms = zoneService.findExistIp(zoneIpForm);
                if (null == existForms || existForms.isEmpty()) continue;
                for (ZoneIpForm zif : existForms) {
                    if (zif.getZoneId().longValue() == zoneForm.getZoneId().longValue()) continue;
                    responseCode = 409;
                    responseMsg = "updateZone. zone ip already exist. start ip : " + zoneIpForm.getStartIp() + ", end ip: " + zoneIpForm.getEndIp();
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
            }
            try {
                VsmUtil.getInstance().lockZones(zoneIdList, "lockZone");
            }
            catch (LegoCheckedException ex) {
                responseCode = 500;
                responseMsg = String.format("Zone %s is Locked", zoneName);
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setTarget(zoneName);
                this.logger.error((Object)("Exception :" + ex.getMessage()));
                return this.logExit(logInfo);
            }
            try {
                zoneService.deleteZoneIps(zoneForm.getZoneId());
                zoneService.updateFlagByRestful(zoneForm.getZoneId());
                this.saveZoneIps(zoneService, zoneForm.getZoneId(), zoneIpForms, zoneListIpFormList);
                zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("updateZone"), null);
            }
            catch (LegoCheckedException e) {
                errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                responseMsg = "updateZone. deploy failed. zoneName is " + zoneName + "; error message is : " + errorMsg;
                responseCode = 507;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setTarget(zoneName);
                this.logger.error((Object)("Exception :" + e.getMessage()));
                Response existForms = this.logExit(logInfo);
                return existForms;
            }
            catch (Exception e) {
                responseMsg = "ATIC inner error occurred while deploy zone. zoneName is " + zoneName;
                responseCode = 507;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setTarget(zoneName);
                this.logger.error((Object)("inner error,Exception: " + e.getMessage()));
                errorMsg = this.logExit(logInfo);
                return errorMsg;
            }
            finally {
                VsmUtil.getInstance().unlockZones(zoneIdList);
            }
        }
        responseCode = 404;
        responseMsg = "updateZone. zoneForm is not existing.";
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        responseBuilder = responseBuilder.status(responseCode);
        responseBuilder.entity((Object)responseMsg);
        return responseBuilder.build();
        List listResult = zonePolicyMgrService.queryDeployResultByZoneId(zoneForm.getZoneId());
        for (ZoneDeviceDeployStatusForm form : listResult) {
            String errorMsgKey;
            if (form.getDeployState().booleanValue() || this.isInvalidErrorMsgKey(errorMsgKey = form.getErrorMsgKey())) continue;
            String errorMsg = AticUtil.getText((String)errorMsgKey, (Locale)new Locale("en"));
            String errorParam = form.getErrorParam();
            errorMsg = errorMsg.replaceFirst("\\$0", errorParam == null ? "" : errorParam);
            responseMsg = "updateZone. deploy failed. zoneName is " + zoneForm.getZoneDesc() + "; error message is : " + errorMsg;
            responseCode = 507;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setTarget(zoneName);
            return this.logExit(logInfo);
        }
        responseCode = 200;
        responseMsg = "updateZone succeed.";
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(String.valueOf(responseCode));
        logInfo.setTarget(zoneName);
        return this.logExit(logInfo);
    }

    private void checkDevicePermissionByUserName(String userName, List<Long> zoneIdList) {
        IZoneDeviceService zoneDeviceService = ZoneBisUtil.getIZoneDeviceService();
        HashSet<Long> associatedDeviceIds = new HashSet<Long>();
        for (Long zoneId : zoneIdList) {
            List zoneDeviceForms = zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
            for (ZoneDeviceForm zoneDevice : zoneDeviceForms) {
                associatedDeviceIds.add(zoneDevice.getDeviceId());
            }
        }
        IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
        UserInfo userInfo = userService.getUserInfoByName(userName, false);
        if (!userInfo.isIsAdmin()) {
            BisUtil.checkRestfulUserSecurity(new ArrayList(associatedDeviceIds), (long)userInfo.getId(), (boolean)userInfo.isIsAdmin());
        }
    }

    @Override
    @GET
    @Path(value="/allzone")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryZone() {
        this.logger.info((Object)"start queryAllZone");
        return this.queryAllZone(false);
    }

    private Response queryAllZone(boolean isMss) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/allzone4portal");
        String requestMsg = "query all Zone. restful request is null.";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/allzone4portal");
            requestMsg = "restful request url : " + url + ".";
        }
        String responseMsg = "";
        int responseCode = 500;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token " + requestMsg));
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
            responseMsg = "current user can not query all zone.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        List zoneInfoForms = null;
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        zoneInfoForms = zoneService.getAll(Long.valueOf(userId), Boolean.valueOf(isAdmin));
        if (null == zoneInfoForms) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"zoneService.getAll() failed.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"get all zone failed");
            return responseBuilder.build();
        }
        if (zoneInfoForms.isEmpty()) {
            responseMsg = "No zone exists";
            responseCode = 200;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            return Response.ok((Object)responseMsg).build();
        }
        if (isMss) {
            ArrayList<RestZoneInfoForMss> zones = new ArrayList<RestZoneInfoForMss>();
            for (ZoneInfoForm zoneInfoForm : zoneInfoForms) {
                if (2 != zoneInfoForm.getZoneType()) continue;
                zones.add(this.copyZone(zoneInfoForm, zoneService));
            }
            responseMsg = "{\"zones\":" + JSONUtil.getInstance().toJSONString(zones) + "}";
        } else {
            StringBuilder json = new StringBuilder("{\"zones\":[");
            for (int i = 0; i < zoneInfoForms.size(); ++i) {
                json.append("{\"zone_id\": \"" + ((ZoneInfoForm)zoneInfoForms.get(i)).getZoneId() + "\" ,\"zone_name\": \"" + ((ZoneInfoForm)zoneInfoForms.get(i)).getZoneName() + "\" ,\"zone_desc\": \"" + ((ZoneInfoForm)zoneInfoForms.get(i)).getZoneDesc() + "\" ,\"zone_ip\":[\"");
                List zoneIpFormList = zoneService.findIpByZoneId(((ZoneInfoForm)zoneInfoForms.get(i)).getZoneId());
                String zongIp = "";
                for (int j = 0; j < zoneIpFormList.size(); ++j) {
                    zongIp = ((ZoneIpForm)zoneIpFormList.get(j)).getZoneIp() + "/" + ((ZoneIpForm)zoneIpFormList.get(j)).getMask();
                    json.append(zongIp);
                    if (j == zoneIpFormList.size() - 1) continue;
                    json.append("\",\"");
                }
                json.append("\"]}");
                if (i == zoneInfoForms.size() - 1) continue;
                json.append(',');
            }
            json.append("]}");
            responseMsg = json.toString();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        return Response.ok((Object)responseMsg).build();
    }

    private RestZoneInfoForMss copyZone(ZoneInfoForm zoneInfoForm, IZoneService zoneService) {
        RestZoneInfoForMss zone = new RestZoneInfoForMss();
        if (null != zoneInfoForm.getZoneId()) {
            zone.setZoneId(zoneInfoForm.getZoneId().toString());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getZoneName())) {
            zone.setZoneName(zoneInfoForm.getZoneName());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getZoneDesc())) {
            zone.setZoneDesc(zoneInfoForm.getZoneDesc());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getContact())) {
            zone.setContact(zoneInfoForm.getContact());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getTelephone())) {
            zone.setTelephone(zoneInfoForm.getTelephone());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getMobile())) {
            zone.setMobile(zoneInfoForm.getMobile());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getEmail())) {
            zone.setEmail(zoneInfoForm.getEmail());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getPost())) {
            zone.setPost(zoneInfoForm.getPost());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getAddress())) {
            zone.setAddress(zoneInfoForm.getAddress());
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getIndustry())) {
            zone.setIndustry(AticUtil.getText((String)("com.hs.vsm.secservice.ddos.policy.industry.mode." + zoneInfoForm.getIndustry()), (Locale)new Locale("en")));
        }
        if (!AticUtil.isNull((String)zoneInfoForm.getRemark())) {
            zone.setRemark(zoneInfoForm.getRemark());
        }
        ArrayList<String> zoneIp = new ArrayList<String>();
        List zoneIpFormList = zoneService.findIpByZoneId(zoneInfoForm.getZoneId());
        if (null != zoneIpFormList) {
            for (ZoneIpForm zoneIpForm : zoneIpFormList) {
                String zongIp = "";
                zongIp = zoneIpForm.getZoneIp() + "/" + zoneIpForm.getMask();
                zoneIp.add(zongIp);
            }
        }
        zone.setZoneIp(zoneIp);
        return zone;
    }

    @Override
    @GET
    @Path(value="/zone")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryZone(@QueryParam(value="Mbps") String mbps, @QueryParam(value="pps") String pps, @QueryParam(value="new_conn") String newConn, @QueryParam(value="curr_conn") String currConn, @QueryParam(value="http_qps") String httpQps, @QueryParam(value="zone_ip") String zoneIp) {
        ZoneInfoForm zoneForm;
        int responseCode;
        String responseMsg;
        String requestMsg;
        block15: {
            List operationIds;
            Response.ResponseBuilder responseBuilder = Response.ok();
            HttpServletRequest request = ServletActionContext.getRequest();
            String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone");
            requestMsg = "queryZone by defense policy. restful request is null.";
            if (null != request) {
                String url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone");
                requestMsg = "restful request url : " + url + ".";
            }
            responseMsg = "";
            responseCode = 500;
            if (AticUtil.isNull((String)userName)) {
                responseCode = 412;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)"illegal token.");
                return responseBuilder.build();
            }
            this.logger.info((Object)("is Legal Token " + requestMsg));
            boolean isAdmin = "admin".equals(userName);
            if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
                responseMsg = "current user can not query zone";
                responseCode = 455;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                Response.ResponseBuilder builder = Response.status((int)responseCode);
                builder.entity((Object)responseMsg);
                return builder.build();
            }
            IUserMgr userMgr = ZoneReferUtil.getUserMgr();
            long userId = userMgr.getUserInfoByName(userName).getId();
            if (!AticUtil.isNull((String)zoneIp)) {
                if (!IPUtil.isIpv4((String)zoneIp) && !IPUtil.isIpv6((String)zoneIp)) {
                    responseMsg = "zone_ip format error";
                    responseCode = 400;
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    Response.ResponseBuilder builder = Response.status((int)responseCode);
                    builder.entity((Object)responseMsg);
                    return builder.build();
                }
                responseMsg = this.queryZoneByIp(zoneIp, userId, isAdmin);
                if ("404".equals(responseMsg)) {
                    responseCode = 404;
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"queryZoneByIp. zoneForm is not exist.");
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)"queryZoneByIp. zoneForm is not exist.");
                    return responseBuilder.build();
                }
                if (String.valueOf(455).equals(responseMsg)) {
                    responseCode = 455;
                    responseMsg = "The current user does not have the resources for this zone.";
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
                if (String.valueOf(500).equals(responseMsg)) {
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
                responseCode = 200;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                return Response.ok((Object)responseMsg).build();
            }
            if (null == mbps || null == pps || null == newConn || null == currConn || null == httpQps) {
                responseCode = 400;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"Parameters are wrong. Have null parameter.");
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)"Parameters are wrong. Have null parameter.");
                return responseBuilder.build();
            }
            if (!this.checkParametersIsIllegal(mbps, pps, newConn, currConn, httpQps)) {
                responseCode = 400;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"Parameters are wrong.Have illegal parameter.");
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)"Parameters are wrong.Have illegal parameter.");
                return responseBuilder.build();
            }
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            zoneForm = null;
            zoneForm = zoneService.getZoneByDefPol(mbps, pps, newConn, currConn, httpQps);
            if (null == zoneForm) {
                responseCode = 404;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"zoneForm is not exist.");
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)"zoneForm is not exist.");
                return responseBuilder.build();
            }
            if (!isAdmin) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneForm.getMoId());
                try {
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                    if (570506L != e.getErrorCode()) break block15;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
            }
        }
        StringBuilder json = new StringBuilder("{\"zone_id\": \"");
        json.append(zoneForm.getZoneId() + "\" ,\"zone_name\": \"" + zoneForm.getZoneName() + "\" ,\"zone_desc\": \"" + zoneForm.getZoneDesc() + "\"}");
        responseMsg = json.toString();
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        return Response.ok((Object)responseMsg).build();
    }

    private boolean checkParametersIsIllegal(String mbps, String pps, String newConn, String currConn, String httpQps) {
        int queryMbps = -1;
        int queryPps = -1;
        int queryNewConn = -1;
        int queryCurrConn = -1;
        int queryHttpQps = -1;
        try {
            queryMbps = Integer.parseInt(mbps);
            queryPps = Integer.parseInt(pps);
            queryNewConn = Integer.parseInt(newConn);
            queryCurrConn = Integer.parseInt(currConn);
            queryHttpQps = Integer.parseInt(httpQps);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"Parameters are wrong.Have illegal parameter.");
            return false;
        }
        if (queryMbps < 1 || queryMbps > 2000000 || queryPps < 1 || queryPps > 80000000) {
            this.logger.error((Object)"Parameters are wrong.Have parameter out of range.");
            return false;
        }
        if (queryNewConn < 1 || queryNewConn > 80000000 || queryCurrConn < 1 || queryCurrConn > 80000000) {
            this.logger.error((Object)"Parameters are wrong.Have parameter out of range.");
            return false;
        }
        if (queryHttpQps < 1 || queryHttpQps > 80000000) {
            this.logger.error((Object)"Parameters are wrong.Have parameter out of range.");
            return false;
        }
        return true;
    }

    private String queryZoneByIp(String zoneIp, long userId, boolean isAdmin) {
        ZoneInfoForm zoneInfoForm;
        block5: {
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("startIp", zoneIp);
            queryMap.put("endIp", zoneIp);
            Paging page = zoneService.queryByPage(queryMap, 0, 10);
            List zoneInfoFormList = page.getData();
            if (null == zoneInfoFormList || zoneInfoFormList.isEmpty()) {
                return "404";
            }
            zoneInfoForm = (ZoneInfoForm)zoneInfoFormList.get(0);
            if (!isAdmin) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneInfoForm.getMoId());
                try {
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        return String.valueOf(455);
                    }
                    if (570506L != e.getErrorCode()) break block5;
                    return String.valueOf(500);
                }
            }
        }
        StringBuilder json = new StringBuilder("{\"zone_id\": \"");
        json.append(zoneInfoForm.getZoneId() + "\" ,\"zone_name\": \"" + zoneInfoForm.getZoneName() + "\" ,\"zone_desc\": \"" + zoneInfoForm.getZoneDesc() + "\"}");
        return json.toString();
    }

    @Override
    @GET
    @Path(value="/zone/{zone_name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryZone(@PathParam(value="zone_name") String zoneName) {
        return this.queryZoneByName(zoneName, false);
    }

    private Response queryZoneByName(String zoneName, boolean isMss) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone4portal/{zone_name}");
        String requestMsg = "queryZone by zonename. restful request is null.";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone4portal/" + zoneName));
            requestMsg = "restful request url : " + url + ".";
        }
        String responseMsg = "";
        int responseCode = 500;
        String zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (null == zoneName || zoneName.length() > 32 || !zoneName.matches(zoneNameRegexS)) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal parameter.");
            return responseBuilder.build();
        }
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token " + requestMsg));
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
            responseMsg = "current user can not query zone";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        ZoneInfoForm zoneForm = null;
        zoneForm = zoneService.getZoneByName(zoneName);
        if (null == zoneForm) {
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"zoneForm is not exist.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"zoneForm is not exist.");
            return responseBuilder.build();
        }
        if (isMss) {
            RestZoneInfoForMss zone = this.copyZone(zoneForm, zoneService);
            responseMsg = JSONUtil.getInstance().toJSONString((Object)zone);
        } else {
            block12: {
                if (!isAdmin) {
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    moIdList.add(zoneForm.getMoId());
                    try {
                        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                        long userId = userMgr.getUserInfoByName(userName).getId();
                        BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                    }
                    catch (LegoCheckedException e) {
                        if (630114L == e.getErrorCode()) {
                            responseCode = 455;
                            responseMsg = "The current user does not have the resources for this zone.";
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            return responseBuilder.build();
                        }
                        if (570506L != e.getErrorCode()) break block12;
                        responseCode = 500;
                        responseMsg = "Unable to get the service published in the background.";
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                }
            }
            StringBuilder json = new StringBuilder("{\"zone_id\": \"");
            json.append(zoneForm.getZoneId() + "\" ,\"zone_name\": \"" + zoneForm.getZoneName() + "\" ,\"zone_desc\": \"" + zoneForm.getZoneDesc() + "\" ,\"zone_ip\":[\"");
            List zoneIpFormList = zoneService.findIpByZoneId(zoneForm.getZoneId());
            String zongIp = "";
            for (int i = 0; i < zoneIpFormList.size(); ++i) {
                zongIp = ((ZoneIpForm)zoneIpFormList.get(i)).getZoneIp() + "/" + ((ZoneIpForm)zoneIpFormList.get(i)).getMask();
                json.append(zongIp);
                if (i == zoneIpFormList.size() - 1) continue;
                json.append("\",\"");
            }
            json.append("\"]}");
            responseMsg = json.toString();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        return Response.ok((Object)responseMsg).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/zone_ip")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addZoneIp(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone_ip");
        String requestMsg = "addZoneIp. restful request is null. json string is :" + json + ". ";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone_ip");
            requestMsg = "restful request url : " + url + ". json string is :" + json + ". ";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.add.zoneip");
        logInfo.setRequestMsg(requestMsg);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token " + requestMsg));
        try {
            List operationIds;
            String apiName = "addZoneIp";
            logInfo.setApiName(apiName);
            if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
                Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
                return response;
            }
            RestZoneInfo restZoneInfo = null;
            try {
                this.checkJson(json);
                restZoneInfo = (RestZoneInfo)JSONUtil.getInstance().fromJSON(json, RestZoneInfo.class);
            }
            catch (Exception e) {
                responseMsg = "json format error, convert the format from java to pojo ip bean failed.";
                responseCode = 400;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                this.logger.error((Object)("Exception :" + e.getMessage()));
                return responseBuilder.build();
            }
            boolean isAdmin = "admin".equals(userName);
            if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2423L) && operationIds.contains(2202L))) {
                responseMsg = "current user can not add zone ip";
                responseCode = 455;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            ArrayList<ZoneIpForm> zoneIpForms = new ArrayList<ZoneIpForm>();
            ArrayList<String> restIps = new ArrayList<String>();
            String zoneName = restZoneInfo.getZoneName();
            List zoneIps = restZoneInfo.getZoneIp();
            logInfo.setTarget(zoneName);
            logInfo.setTargetLocal(false);
            String zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
            if (null == zoneName || zoneName.length() > 32 || !zoneName.matches(zoneNameRegexS)) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            if (zoneIps.size() > 50) {
                this.logger.error((Object)"zoneIps length exceeds the 50 limit.");
                responseMsg = "zoneIps length exceeds the 50 limit.";
                responseCode = 413;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                Response.ResponseBuilder builder = Response.status((int)responseCode);
                builder.entity((Object)responseMsg);
                return builder.build();
            }
            for (String zoneIp : zoneIps) {
                if (zoneIp.contains("/")) {
                    ZoneIpForm iptemp = new ZoneIpForm();
                    String[] zoneIpDetails = zoneIp.split("/");
                    String[] rangeIps = null;
                    try {
                        rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
                    }
                    catch (IllegalArgumentException e) {
                        responseCode = 400;
                        responseMsg = "illegal parameter.";
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        this.logger.error((Object)("Exception :" + e.getMessage()));
                        return responseBuilder.build();
                    }
                    catch (RuntimeException e) {
                        responseCode = 400;
                        responseMsg = "illegal parameter.";
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        this.logger.error((Object)("Exception :" + e.getMessage()));
                        return responseBuilder.build();
                    }
                    iptemp.setZoneIp(zoneIpDetails[0]);
                    iptemp.setMask(Integer.valueOf(zoneIpDetails[1]));
                    iptemp.setStartIp(rangeIps[0]);
                    iptemp.setEndIp(rangeIps[1]);
                    zoneIpForms.add(iptemp);
                    restIps.add(zoneIpDetails[0]);
                    continue;
                }
                responseMsg = "zone ip format error.zoneIp is " + zoneIp;
                responseCode = 400;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            ZoneInfoForm zoneForm = null;
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            ArrayList<ZoneListIpForm> zoneListIpFormList = new ArrayList<ZoneListIpForm>();
            IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
            zoneForm = zoneService.getCustomZoneByName(zoneName);
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            if (null != zoneForm) {
                Object moIdList;
                long currentZoneId = zoneForm.getZoneId();
                zoneIdList.add(currentZoneId);
                if (!isAdmin) {
                    block34: {
                        moIdList = new ArrayList();
                        moIdList.add(zoneForm.getMoId());
                        try {
                            IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                            long userId = userMgr.getUserInfoByName(userName).getId();
                            BisUtil.checkRestfulUserSecurity((List)moIdList, (long)userId, (boolean)isAdmin);
                        }
                        catch (LegoCheckedException e) {
                            if (630114L == e.getErrorCode()) {
                                responseCode = 455;
                                responseMsg = "The current user does not have the resources for this zone.";
                                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                                responseBuilder = responseBuilder.status(responseCode);
                                responseBuilder.entity((Object)responseMsg);
                                return responseBuilder.build();
                            }
                            if (570506L != e.getErrorCode()) break block34;
                            responseCode = 500;
                            responseMsg = "Unable to get the service published in the background.";
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            return responseBuilder.build();
                        }
                    }
                    try {
                        this.checkDevicePermissionByUserName(userName, zoneIdList);
                    }
                    catch (LegoCheckedException e) {
                        return this.buildErrorResponse(responseBuilder, logInfo, e);
                    }
                }
                moIdList = RestZoneServiceImpl.class;
                synchronized (RestZoneServiceImpl.class) {
                    for (ZoneIpForm zoneIpForm : zoneIpForms) {
                        List existForms = zoneService.findExistIp(zoneIpForm);
                        if (null != existForms && !existForms.isEmpty()) {
                            long zoneId = ((ZoneIpForm)existForms.get(0)).getZoneId();
                            this.logger.info((Object)("existIPForms zoneId is " + zoneId + ";zoneForm.getZoneId() is " + zoneForm.getZoneId()));
                            if (1 == existForms.size() && zoneId == zoneForm.getZoneId() && IPUtil4Atic.convert2CompleteIp((String)zoneIpForm.getStartIp()).equals(((ZoneIpForm)existForms.get(0)).getStartIp()) && IPUtil4Atic.convert2CompleteIp((String)zoneIpForm.getEndIp()).equals(((ZoneIpForm)existForms.get(0)).getEndIp())) continue;
                            responseCode = 409;
                            responseMsg = "zone ip address is exist already. start ip : " + zoneIpForm.getStartIp() + ", end ip: " + zoneIpForm.getEndIp();
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            // ** MonitorExit[moIdList] (shouldn't be in output)
                            return responseBuilder.build();
                        }
                        ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
                        zoneListIpForm.setEndIp(zoneIpForm.getEndIp());
                        zoneListIpForm.setStartIp(zoneIpForm.getStartIp());
                        zoneListIpForm.setIntMask(zoneIpForm.getMask().intValue());
                        zoneListIpForm.setIpType(0);
                        zoneListIpForm.setMaskType(0);
                        zoneListIpForm.setZoneIp(zoneIpForm.getZoneIp());
                        zoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                        zoneListIpFormList.add(zoneListIpForm);
                    }
                    if (VsmUtil.getInstance().isLockedZones(zoneIdList).booleanValue()) {
                        responseCode = 423;
                        responseMsg = String.format("Zone %s is Locked by other request.", zoneName);
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[moIdList] (shouldn't be in output)
                        return this.logExit(logInfo);
                    }
                    if (!zoneListIpFormList.isEmpty()) {
                        this.saveZoneIps(zoneService, zoneForm.getZoneId(), zoneIpForms, zoneListIpFormList);
                    }
                    // ** MonitorExit[moIdList] (shouldn't be in output)
                    try {
                        zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("addZoneIp"), restZoneInfo.getZoneIp());
                    }
                    catch (LegoCheckedException e) {
                        String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                        responseMsg = "addZoneIp. deploy failed. zoneName is " + zoneName + "; error message is : " + errorMsg;
                        responseCode = 507;
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        return this.logExit(logInfo);
                    }
                    catch (Exception e) {
                        responseMsg = "ATIC inner error occurred while deploy zone. zoneName is " + zoneName;
                        responseCode = 507;
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        this.logger.error((Object)("Exception :" + e.getMessage()));
                        return this.logExit(logInfo);
                    }
                }
            }
            responseCode = 404;
            responseMsg = "zoneForm is not exist.";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
            {
                List newDbZoneListIps = zoneService.getListIpByZoneId(zoneForm.getZoneId());
                if (newDbZoneListIps.isEmpty()) {
                    responseMsg = "addZoneIp. deploy failed. zoneName is " + zoneName + "; zone_ip is : " + restZoneInfo.getZoneIp();
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    return this.logExit(logInfo);
                }
                for (ZoneListIpForm zoneListIpForm : newDbZoneListIps) {
                    if (zoneListIpForm.isDeployState() || !restIps.contains(zoneListIpForm.getZoneIp())) continue;
                    responseMsg = "addZoneIp. deploy failed. zoneName is " + zoneName + "; zone_ip is : " + restZoneInfo.getZoneIp();
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    return this.logExit(logInfo);
                }
                responseCode = 200;
                responseMsg = "addZoneIp succeed.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.logExit(logInfo);
            }
        }
        catch (RuntimeException e) {
            responseCode = 500;
            responseMsg = "addZoneIp failed.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            this.logger.error((Object)("Exception :" + e.getMessage()));
            return this.logExit(logInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @DELETE
    @Path(value="/zone_ip/{zone_ip}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteZoneIp(@PathParam(value="zone_ip") String zoneIp) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone_ip/{zone_ip}");
        String requestMsg = "deleteZoneIp. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String json = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone_ip/" + zoneIp));
            requestMsg = "restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.delete.zoneip");
        logInfo.setTargetLocal(false);
        logInfo.setRequestMsg(requestMsg);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token " + requestMsg));
        String zoneNameInfo = null;
        try {
            List operationIds;
            String apiName = "deleteZoneIp";
            logInfo.setApiName(apiName);
            if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
                return this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            }
            boolean isAdmin = "admin".equals(userName);
            if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2423L) && operationIds.contains(2202L) && operationIds.contains(2226L) && operationIds.contains(2223L))) {
                responseMsg = "current user can not delete zone ip";
                responseCode = 455;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            ZoneInfoForm zoneForm = null;
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
            if (!IPUtil.isIpv4((String)zoneIp) && !IPUtil.isIpv6((String)zoneIp)) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            ZoneIpForm iptemp = new ZoneIpForm();
            iptemp.setZoneIp(zoneIp);
            boolean isIpv4 = IPUtil.isIpv4((String)zoneIp);
            if (isIpv4) {
                iptemp.setMask(Integer.valueOf(32));
            } else {
                iptemp.setMask(Integer.valueOf(128));
            }
            iptemp.setStartIp(zoneIp);
            iptemp.setEndIp(zoneIp);
            ArrayList<String> restIps = new ArrayList<String>();
            restIps.add(zoneIp);
            ArrayList<ZoneIpForm> oldZoneIpFormList = new ArrayList<ZoneIpForm>();
            List existForms = zoneService.findExistIp(iptemp);
            this.logger.warn((Object)("zoneService.findExistIp(zoneIpForm).existForms is " + existForms + "; " + requestMsg));
            if (null != existForms && !existForms.isEmpty()) {
                Object moIdList;
                oldZoneIpFormList.add((ZoneIpForm)existForms.get(0));
                ((ZoneIpForm)existForms.get(0)).setId(null);
                Long zoneId = ((ZoneIpForm)existForms.get(0)).getZoneId();
                this.logger.warn((Object)("zoneService.findExistIp(zoneIpForm).existForms is exist zoneId: " + zoneId + "; " + requestMsg));
                zoneForm = zoneService.getZoneNOIpById(zoneId);
                if (null == zoneForm) {
                    responseCode = 500;
                    responseMsg = "deleteZoneIp. zoneForm is not exist.";
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
                zoneNameInfo = zoneForm.getZoneName();
                ArrayList<Long> zoneIdList = new ArrayList<Long>();
                zoneIdList.add(zoneId);
                if (!isAdmin) {
                    block32: {
                        moIdList = new ArrayList();
                        moIdList.add(zoneForm.getMoId());
                        try {
                            IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                            long userId = userMgr.getUserInfoByName(userName).getId();
                            BisUtil.checkRestfulUserSecurity((List)moIdList, (long)userId, (boolean)isAdmin);
                        }
                        catch (LegoCheckedException e) {
                            if (630114L == e.getErrorCode()) {
                                responseCode = 455;
                                responseMsg = "The current user does not have the resources for this zone.";
                                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                                responseBuilder = responseBuilder.status(responseCode);
                                responseBuilder.entity((Object)responseMsg);
                                return responseBuilder.build();
                            }
                            if (570506L != e.getErrorCode()) break block32;
                            responseCode = 500;
                            responseMsg = "Unable to get the service published in the background.";
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            return responseBuilder.build();
                        }
                    }
                    try {
                        this.checkDevicePermissionByUserName(userName, zoneIdList);
                    }
                    catch (LegoCheckedException e) {
                        return this.buildErrorResponse(responseBuilder, logInfo, e);
                    }
                }
                moIdList = RestZoneServiceImpl.class;
                synchronized (RestZoneServiceImpl.class) {
                    IDivertForPolicy divertTacticsService;
                    List divertTacticsForms;
                    List zoneListIpSigForms = zoneService.findExistSigIp(zoneIp, isIpv4);
                    if (null != zoneListIpSigForms && !zoneListIpSigForms.isEmpty()) {
                        String zoneName = zoneForm.getZoneName();
                        if (VsmUtil.getInstance().isLockedZones(zoneIdList).booleanValue()) {
                            responseCode = 423;
                            responseMsg = String.format("Zone %s is Locked by other request.", zoneName);
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(String.valueOf(responseCode));
                            logInfo.setTarget(zoneName);
                            // ** MonitorExit[moIdList] (shouldn't be in output)
                            return this.logExit(logInfo);
                        }
                        zoneService.delZoneIpByIp(zoneIp);
                        zoneService.updateZoneIpFlag(zoneIp);
                        // ** MonitorExit[moIdList] (shouldn't be in output)
                        try {
                            zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("deleteZoneIp"), restIps);
                        }
                        catch (LegoCheckedException e) {
                            this.saveZoneIps(zoneService, zoneForm.getZoneId(), oldZoneIpFormList, null);
                            zoneService.updateZoneIpFlag(zoneIp, 0);
                            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                            responseMsg = "deleteZoneIp. deploy failed. zoneName is " + zoneForm.getZoneName() + "; zone_ip is :" + zoneIp + "; error message is : " + (String)errorMsg;
                            responseCode = 507;
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(responseCode + "," + responseMsg);
                            logInfo.setTarget(zoneForm.getZoneName());
                            this.logger.error((Object)("Exception :" + e.getMessage()));
                            return this.logExit(logInfo);
                        }
                        catch (Exception e) {
                            this.saveZoneIps(zoneService, zoneForm.getZoneId(), oldZoneIpFormList, null);
                            zoneService.updateZoneIpFlag(zoneIp, 0);
                            responseMsg = "ATIC inner error occurred while deploy zone. zoneName is " + zoneForm.getZoneName() + "; zone_ip is : " + zoneIp;
                            responseCode = 507;
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(responseCode + "," + responseMsg);
                            logInfo.setTarget(zoneForm.getZoneName());
                            this.logger.error((Object)("Exception :" + e.getMessage()));
                            return this.logExit(logInfo);
                        }
                    } else {
                        responseCode = 404;
                        responseMsg = "deleteZoneIp. zone ip address is not exist.";
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        // ** MonitorExit[moIdList] (shouldn't be in output)
                        return responseBuilder.build();
                    }
                    List newDbZoneListIps = zoneService.getListIpByZoneId(zoneForm.getZoneId());
                    if (!newDbZoneListIps.isEmpty()) {
                        for (ZoneListIpForm zoneListIpForm : newDbZoneListIps) {
                            if (!restIps.contains(zoneListIpForm.getZoneIp())) continue;
                            this.logger.error((Object)("deleteZoneIp fail. zone_ip is : " + zoneIp + "-------"));
                            this.saveZoneIps(zoneService, zoneForm.getZoneId(), oldZoneIpFormList, null);
                            zoneService.updateZoneIpFlag(zoneIp, 0);
                            responseMsg = "deleteZoneIp. deploy failed. zoneName is " + zoneForm.getZoneName() + "; zone_ip is :" + zoneIp;
                            responseCode = 507;
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(responseCode + "," + responseMsg);
                            logInfo.setTarget(zoneForm.getZoneName());
                            return this.logExit(logInfo);
                        }
                    }
                    if (!(divertTacticsForms = (divertTacticsService = ZoneReferUtil.getDivertForPolicyService()).getDivertTacticsByIp(zoneIp, zoneIp)).isEmpty()) {
                        String[] params;
                        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
                        for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                            BatchOperation bo = new BatchOperation();
                            bo.setTargetId(divertTacticsForm.getId().longValue());
                            bo.setTargetName("(" + divertTacticsForm.getDeviceName() + ", IP :" + zoneIp + ")");
                            boList.add(bo);
                        }
                        BatchOperationResult boResult = divertTacticsService.deleteDivertTactics(boList, true, userName, terminalIp + "(restful)");
                        if (boResult.getFailCount() > 0) {
                            responseCode = 500;
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed.");
                            detailPara[2] = responseCode + "";
                            params = new String[]{terminalIp, userName, "atic.bis.divert.tactics.operate.type.delete", zoneForm.getZoneName()};
                            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)false);
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)"deleteZoneIp succeed,but delete divert failed.");
                            return responseBuilder.build();
                        }
                        responseCode = 200;
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion succeed.");
                        detailPara[2] = responseCode + "";
                        params = new String[]{terminalIp, userName, "atic.bis.divert.tactics.operate.type.delete", zoneForm.getZoneName()};
                        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)false);
                    }
                }
            } else {
                responseCode = 404;
                responseMsg = "deleteZoneIp. zone ip address is not existing.";
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            {
                responseCode = 200;
                responseMsg = "deleteZoneIp succeed.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                logInfo.setTarget(zoneForm.getZoneName());
                return this.logExit(logInfo);
            }
        }
        catch (RuntimeException e) {
            responseCode = 500;
            responseMsg = "deleteZoneIp failed.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            if (zoneNameInfo == null) {
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            logInfo.setTarget(zoneNameInfo);
            this.logger.error((Object)("Exception :" + e.getMessage()));
            return this.logExit(logInfo);
        }
    }

    private void saveZoneIps(IZoneService zoneService, Long zoneId, List<ZoneIpForm> zoneIpFormList, List<ZoneListIpForm> zoneListIpFormList) {
        if (null != zoneListIpFormList) {
            zoneService.saveZoneListIps(zoneListIpFormList, zoneId);
        }
        if (null != zoneIpFormList) {
            zoneService.saveZoneIps(zoneIpFormList, zoneId);
        }
    }

    private void checkJson(String json) {
        if (null != json && json.trim().length() > 5000) {
            throw new IllegalArgumentException("the parameters of json is more than 5000.");
        }
    }

    @Override
    @PUT
    @Path(value="/policy_v1/{zone_name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updatePolicy(@PathParam(value="zone_name") String zoneName, String json) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        int responseCode = 500;
        HttpServletRequest request = ServletActionContext.getRequest();
        String requestMsg = "updatePolicy. restful request is null. json string is :" + json + ". ";
        String terminalIp = "127.0.0.1";
        if (null == request) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"updatePolicy. restful request is null.");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)"param is out of range");
            return builder.build();
        }
        String url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/policy_v1/" + zoneName));
        requestMsg = "restful request url : " + url + ". json string is :" + json + ". ";
        terminalIp = request.getRemoteAddr();
        String responseMsg = "";
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/policy_v1/{zone_name}");
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.update.policy");
        logInfo.setTarget(zoneName);
        logInfo.setTargetLocal(false);
        logInfo.setRequestMsg(requestMsg);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            this.logger.error((Object)("updatePolicy. illegal token. clientIp: " + request.getRemoteAddr() + "; json string is :" + json));
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("updatePolicy. clientIp: " + request.getRemoteAddr()));
        RestPolicyParamsInfo restPolicyParamsInfo = null;
        String apiName = "updatePolicy";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            return response;
        }
        try {
            this.checkJson(json);
            restPolicyParamsInfo = (RestPolicyParamsInfo)JSONUtil.getInstance().fromJSON(json, RestPolicyParamsInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            this.logger.error((Object)("convert the json to java object failed. json string is " + json + " " + e.getMessage()));
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2206L) && operationIds.contains(2202L))) {
            responseMsg = "current user can not update policy";
            responseCode = 455;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (!this.checkParams(restPolicyParamsInfo)) {
            responseCode = 400;
            responseMsg = "zoneName is null. param is out of range";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (!ZoneUtil.isValidZoneName((String)zoneName)) {
            responseCode = 400;
            responseMsg = "zoneName is illegal";
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        ZoneInfoForm zoneForm = null;
        ZoneServiceForm zoneServiceForm = null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        IZonePolicyApplyServiceSimple zonePolicyService = (IZonePolicyApplyServiceSimple)ServiceContext.getInstance().getService("policyApplyServiceSimple", IZonePolicyApplyServiceSimple.class);
        zoneForm = zoneService.getZoneByName(zoneName);
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        if (null != zoneForm) {
            zoneIdList.add(zoneForm.getZoneId());
            if (!isAdmin) {
                block35: {
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    moIdList.add(zoneForm.getMoId());
                    try {
                        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                        long userId = userMgr.getUserInfoByName(userName).getId();
                        BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                    }
                    catch (LegoCheckedException e) {
                        if (630114L == e.getErrorCode()) {
                            responseCode = 455;
                            responseMsg = "The current user does not have the resources for this zone.";
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)responseMsg);
                            return responseBuilder.build();
                        }
                        if (570506L != e.getErrorCode()) break block35;
                        responseCode = 500;
                        responseMsg = "Unable to get the service published in the background.";
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                }
                try {
                    this.checkDevicePermissionByUserName(userName, zoneIdList);
                }
                catch (LegoCheckedException e) {
                    return this.buildErrorResponse(responseBuilder, logInfo, e);
                }
            }
            List beforeZoneApplys = zonePolicyService.queryByZoneIds(zoneIdList);
            Map beforeZoneDeviceStatus = zonePolicyMgrService.queryByZoneIds(zoneIdList);
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("zoneId", String.valueOf(zoneForm.getZoneId()));
            queryMap.put("protocol", "DEFAULT");
            Paging result = serviceService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
            List defaultServices = result.getData();
            if (!defaultServices.isEmpty()) {
                for (ZoneServiceForm service : defaultServices) {
                    IcmpDefendPolicyForm icmp;
                    UdpDefendPolicyForm udp;
                    zoneServiceForm = (ZoneServiceForm)serviceService.query((Object)service.getPkid());
                    TcpDefendPolicyForm tcp = zoneServiceForm.getTcpDefendPolicyForm();
                    if (null != tcp) {
                        if (restPolicyParamsInfo.getTcpAbnormalPps() != 0) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpAbnormalEnable(Boolean.valueOf(true));
                            tcp.setTcpAbnormalAlertRate(Integer.valueOf(restPolicyParamsInfo.getTcpAbnormalPps()));
                        }
                        if (restPolicyParamsInfo.getTcpFinRstPps() != 0) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpBasicEnable(Boolean.valueOf(true));
                            tcp.setFinRstFloodEnable(Boolean.valueOf(true));
                            tcp.setFinRstFloodAlertRate(Integer.valueOf(restPolicyParamsInfo.getTcpFinRstPps()));
                        }
                        if (restPolicyParamsInfo.getTcpFragmentPps() != 0) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpBasicEnable(Boolean.valueOf(true));
                            tcp.setTcpFragEnable(Boolean.valueOf(true));
                            tcp.setTcpFragAlertRate(Integer.valueOf(restPolicyParamsInfo.getTcpFragmentPps()));
                        }
                        if (restPolicyParamsInfo.getTcpSynPps() != 0) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpBasicEnable(Boolean.valueOf(true));
                            tcp.setSynfloodEnable(Boolean.valueOf(true));
                            tcp.setSynfloodAlertRate(Integer.valueOf(restPolicyParamsInfo.getTcpSynPps()));
                        }
                    }
                    if (null != (udp = zoneServiceForm.getUdpDefendPolicyForm())) {
                        if (restPolicyParamsInfo.getUdpFragmentLimitMbps() != 0) {
                            udp.setUdpBlock(Boolean.valueOf(false));
                            udp.setUdpLimitEnable(Boolean.valueOf(true));
                            udp.setUdpFragMaxSpeedEnable(Boolean.valueOf(true));
                            udp.setUdpFragMaxSpeed(Integer.valueOf(restPolicyParamsInfo.getUdpFragmentLimitMbps()));
                        }
                        if (restPolicyParamsInfo.getUdpLimitMbps() != 0) {
                            udp.setUdpBlock(Boolean.valueOf(false));
                            udp.setUdpLimitEnable(Boolean.valueOf(true));
                            udp.setUdpMaxSpeedEnable(Boolean.valueOf(true));
                            udp.setUdpMaxSpeed(Integer.valueOf(restPolicyParamsInfo.getUdpLimitMbps()));
                        }
                    }
                    if (null != (icmp = zoneServiceForm.getIcmpDefendPolicyForm()) && restPolicyParamsInfo.getIcmpLimitPps() != 0) {
                        icmp.setIcmpBlockEnable(Boolean.valueOf(false));
                        icmp.setIcmpMaxSpeedEnable(Boolean.valueOf(true));
                        icmp.setIcmpLimitSubEnable(Boolean.valueOf(true));
                        icmp.setIcmpMaxSpeed(Integer.valueOf(restPolicyParamsInfo.getIcmpLimitPps()));
                    }
                    try {
                        serviceService.create((Object)zoneServiceForm);
                    }
                    catch (LegoCheckedException e) {
                        if (e.getErrorCode() == 630154L) {
                            responseCode = 423;
                            responseMsg = "Another administrator is operating this Zone.";
                        } else {
                            responseCode = 500;
                            responseMsg = "update policy fail.";
                        }
                        this.logger.error((Object)(responseMsg + "; json string is :" + json + " " + e.getMessage()));
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        this.logger.error((Object)("Exception :" + e.getMessage()));
                        return this.logExit(logInfo);
                    }
                    catch (Exception e) {
                        responseCode = 500;
                        responseMsg = "update policy fail.";
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        this.logger.error((Object)("Exception :" + e.getMessage()));
                        return this.logExit(logInfo);
                    }
                }
            }
            try {
                zonePolicyMgrService.deployRestZone(zoneIdList, this.initFeatures("updatePolicy"), beforeZoneApplys, beforeZoneDeviceStatus);
            }
            catch (LegoCheckedException e) {
                String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                responseMsg = "updatePolicy. deploy failed. zoneName is " + zoneName + "; error message is : " + errorMsg;
                responseCode = 507;
                this.logger.error((Object)(responseMsg + "; json string is :" + json + " " + e.getMessage()));
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                this.logger.error((Object)("Exception :" + e.getMessage()));
                return this.logExit(logInfo);
            }
            catch (Exception e) {
                responseMsg = "updatePolicy. ATIC inner error occurred while deploy zone. zoneName is " + zoneName + "; json string is :" + json;
                responseCode = 507;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                this.logger.error((Object)("Exception :" + e.getMessage()));
                return this.logExit(logInfo);
            }
        }
        responseMsg = "updatePolicy. zoneForm is not exist. zone json string:  " + json;
        responseCode = 404;
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        responseBuilder = responseBuilder.status(responseCode);
        responseBuilder.entity((Object)responseMsg);
        return responseBuilder.build();
        List listResult = zonePolicyMgrService.queryDeployResultByZoneId(zoneForm.getZoneId());
        for (ZoneDeviceDeployStatusForm form : listResult) {
            if (form.getDeployState().booleanValue()) continue;
            responseCode = 507;
            String errorMsgKey = form.getErrorMsgKey();
            if (this.isInvalidErrorMsgKey(errorMsgKey)) continue;
            String errorMsg = AticUtil.getText((String)errorMsgKey, (Locale)new Locale("en"));
            String errorParam = form.getErrorParam();
            errorMsg = errorMsg.replaceFirst("\\$0", errorParam == null ? "" : errorParam);
            responseMsg = "updatePolicy. deploy failed. zoneName is " + zoneForm.getZoneDesc() + "; error message is : " + errorMsg;
            this.logger.error((Object)(responseMsg + "; json string is :" + json));
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExit(logInfo);
        }
        responseCode = 200;
        this.logger.info((Object)("updatePolicy succeed. zone json string:  " + json));
        responseMsg = "updatePolicy succeed.";
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(String.valueOf(responseCode));
        return this.logExit(logInfo);
    }

    private boolean checkParams(RestPolicyParamsInfo params) {
        if (params.getIcmpLimitPps() < 0 || params.getIcmpLimitPps() > 2000000) {
            return false;
        }
        if (params.getTcpAbnormalPps() < 0 || params.getTcpAbnormalPps() > 80000000) {
            return false;
        }
        if (params.getTcpFinRstPps() < 0 || params.getTcpFinRstPps() > 80000000) {
            return false;
        }
        if (params.getTcpFragmentPps() < 0 || params.getTcpFragmentPps() > 80000000) {
            return false;
        }
        if (params.getTcpSynPps() < 0 || params.getTcpSynPps() > 80000000) {
            return false;
        }
        if (params.getUdpFragmentLimitMbps() < 0 || params.getUdpFragmentLimitMbps() > 2000000) {
            return false;
        }
        return params.getUdpLimitMbps() >= 0 && params.getUdpLimitMbps() <= 2000000;
    }

    @Override
    @PUT
    @Path(value="/zone/updateZonePolicy")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateZonePolicy(String json) {
        IZonePolicyMgrService zonePolicyMgrService;
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        RestfuResult result = null;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone/updateZonePolicy");
        String responseMsg = "";
        String requestMsg = "updateZonePolicy. restful request is null. json is :" + json + ". ";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone/updateZonePolicy");
            requestMsg = "restful request url : " + url + ". json is :" + json + ". ";
            terminalIp = request.getRemoteAddr();
        }
        int responseCode = 500;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.update.zone");
        logInfo.setRequestMsg(requestMsg);
        if (null == userName) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            this.logger.error((Object)("updateZonePolicy. illegal token. clientIp: " + terminalIp + "; json string is :" + json));
            responseBuilder = responseBuilder.status(412);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("updateZonePolicy. clientIp: " + terminalIp + "; isLegalToken :" + userName + " ; requestMsg : " + requestMsg));
        RestPolicyFilterInfo restPolicyFilterInfo = null;
        String apiName = "updateZonePolicy";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            return response;
        }
        try {
            this.checkJson(json);
            restPolicyFilterInfo = (RestPolicyFilterInfo)JSONUtil.getInstance().fromJSON(json, RestPolicyFilterInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error, convert the json to java object failed";
            responseCode = 400;
            this.logger.error((Object)("updateZonePolicy. convert the json to java object failed. json string is " + json + " " + e.getMessage()));
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2206L) && operationIds.contains(2202L))) {
            responseMsg = "current user can not update zone policy";
            responseCode = 455;
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        result = this.checkPolicyFilterInfo(restPolicyFilterInfo);
        if (200 != result.getCode()) {
            this.logger.error((Object)("updateZonePolicy. " + result.getMessage()));
            responseMsg = result.getMessage();
            responseCode = result.getCode();
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        String zoneAccount = restPolicyFilterInfo.getZoneAccount();
        ZoneInfoForm zoneForm = null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        zoneForm = zoneService.getZoneByName(zoneAccount);
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneForm == null ? Long.valueOf(0L) : zoneForm.getZoneId());
        logInfo.setTarget(zoneAccount);
        logInfo.setTargetLocal(false);
        if (!isAdmin) {
            block35: {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneForm == null ? Long.valueOf(0L) : zoneForm.getMoId());
                try {
                    IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                    long userId = userMgr.getUserInfoByName(userName).getId();
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                    if (570506L != e.getErrorCode()) break block35;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
            }
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(responseBuilder, logInfo, e);
            }
        }
        String isPolicyEnable = restPolicyFilterInfo.getPolicyInEnable();
        PolicyParamsInfo[] policyParams = restPolicyFilterInfo.getPolicyParams();
        if ("1".equals(isPolicyEnable) && policyParams.length > 0) {
            boolean updateFlag = false;
            this.logger.info((Object)"to update policy. ");
            try {
                updateFlag = this.handlePolicy(restPolicyFilterInfo.getPolicyParams(), zoneForm);
                if (!updateFlag) {
                    responseCode = 500;
                    responseMsg = "update policy fail.";
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("Exception :" + e.getMessage()));
                if (e.getErrorCode() == 630154L) {
                    responseCode = 423;
                    responseMsg = "Another administrator is operating this Zone.";
                }
                responseCode = 500;
                responseMsg = "update policy fail.";
            }
            this.logger.info((Object)"update policy over. ");
            if (!updateFlag) {
                this.logger.error((Object)"update policy fail.");
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.logExit(logInfo);
            }
        }
        String isFilterEnable = restPolicyFilterInfo.getFilterInEnable();
        String[] filterNames = restPolicyFilterInfo.getFilterNames();
        if ("1".equals(isFilterEnable)) {
            boolean updateFlag = false;
            this.logger.info((Object)"to update filter. ");
            updateFlag = this.updateZoneFilter(filterNames, zoneAccount);
            this.logger.info((Object)"update filter over. ");
            if (!updateFlag) {
                this.logger.error((Object)"update filter fail.");
                responseCode = 500;
                responseMsg = "update filter fail.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.logExit(logInfo);
            }
        }
        String isDefenseModeEnable = restPolicyFilterInfo.getDefenseModeInEnable();
        DefenseModeParamsInfo[] defenseModeParams = restPolicyFilterInfo.getDefenseModeParams();
        if ("1".equals(isDefenseModeEnable) && defenseModeParams.length > 0) {
            boolean updateFlag = false;
            this.logger.info((Object)"to update defenseMode. ");
            updateFlag = this.updateDefenseMode(defenseModeParams, zoneForm);
            this.logger.info((Object)"update defenseMode over. ");
            if (!updateFlag) {
                this.logger.error((Object)"update defenseMode fail.");
                responseCode = 500;
                responseMsg = "update defenseMode fail.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.logExit(logInfo);
            }
        }
        if (200 != (result = this.deployZone(zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService(), zoneIdList, zoneAccount)).getCode()) {
            this.logger.error((Object)("updateZonePolicy. " + result.getMessage()));
            responseCode = result.getCode();
            responseMsg = "updateZonePolicy. " + result.getMessage();
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + " " + responseMsg);
            return this.logExit(logInfo);
        }
        List listResult = zonePolicyMgrService.queryAllDeployResultByZoneId(zoneForm.getZoneId());
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        StringBuilder resopnseMsg = new StringBuilder();
        boolean flag = true;
        try {
            for (ZoneDeviceDeployStatusForm form : listResult) {
                Long deviceId = form.getDeviceId();
                AticDevice device = aticDeviceService.getDeviceByMoid(deviceId.longValue());
                if (1 != device.getDeviceType()) continue;
                if (!form.getDeployState().booleanValue()) {
                    String errorMsgKey = form.getErrorMsgKey();
                    if (this.isInvalidErrorMsgKey(errorMsgKey)) continue;
                    String errorMsg = AticUtil.getText((String)errorMsgKey, (Locale)new Locale("en"));
                    String errorParam = form.getErrorParam();
                    errorMsg = errorMsg.replaceFirst("\\$0", errorParam == null ? "" : errorParam);
                    responseMsg = "updateZonePolicy. deploy failed. zoneAccount is " + zoneAccount + "; error message is : " + errorMsg;
                    this.logger.error((Object)responseMsg);
                    if (1 == form.getDeployType()) {
                        resopnseMsg.append("ddos device name:" + device.getName() + " deploy policy result:" + errorMsg + ";");
                    } else if (2 == form.getDeployType()) {
                        resopnseMsg.append("ddos device name:" + device.getName() + " deploy filter result:" + errorMsg + ";");
                    }
                    flag = false;
                    continue;
                }
                if (1 == form.getDeployType()) {
                    resopnseMsg.append("ddos device name:" + device.getName() + " deploy policy result: deploy success;");
                    continue;
                }
                if (2 != form.getDeployType()) continue;
                resopnseMsg.append("ddos device name:" + device.getName() + " deploy filter result: deploy success;");
            }
        }
        catch (LegoCheckedException e) {
            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            responseMsg = "updateZonePolicy. happened exception, error message is : " + errorMsg;
            this.logger.error((Object)(responseMsg + " " + e.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)("updateZonePolicy. happened exception. zoneAccount is " + zoneAccount + " " + e.getMessage()));
        }
        if (!flag) {
            result.setCode(507);
            result.setMessage(resopnseMsg.toString());
        } else {
            result.setMessage("every device deploy zone success!");
        }
        this.logger.info((Object)("updateZonePolicy. " + result.getMessage()));
        responseCode = result.getCode();
        responseMsg = result.getMessage();
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(responseCode + " " + result.getMessage());
        return this.logExit(logInfo);
    }

    private RestfuResult checkPolicyFilterInfo(RestPolicyFilterInfo policyFilterInfo) {
        DefenseModeParamsInfo[] defenseModeParams;
        String[] filterNames;
        PolicyParamsInfo[] policyParams;
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        String zoneAccount = policyFilterInfo.getZoneAccount();
        ZoneInfoForm zoneForm = null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        String zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (null == zoneAccount || "".equals(zoneAccount.trim())) {
            result.setCode(400);
            result.setMessage("zone_account:[" + zoneAccount + "] is null!");
            return result;
        }
        if (!zoneAccount.matches(zoneNameRegexS) || zoneAccount.length() > 32) {
            result.setCode(404);
            result.setMessage("zone_account:[" + zoneAccount + "] format is error!");
            return result;
        }
        zoneForm = zoneService.getZoneByName(zoneAccount);
        if (null == zoneForm) {
            result.setCode(404);
            result.setMessage("zone_account:[" + zoneAccount + "] not exist!");
            return result;
        }
        if (!ZoneConstants.ZONE_TYPE_CUSTOME.equals(zoneForm.getZoneType())) {
            result.setCode(406);
            result.setMessage("zone_account:[" + zoneAccount + "] type is error!");
            return result;
        }
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        if (0 >= defaultServices.size()) {
            result.setCode(404);
            result.setMessage("zone_account:[" + zoneAccount + "] not include default service binding ddos device!");
            return result;
        }
        String isPolicyEnable = policyFilterInfo.getPolicyInEnable();
        if (!"0".equals(isPolicyEnable) && !"1".equals(isPolicyEnable)) {
            result.setCode(400);
            result.setMessage("policy_in_enable:[" + isPolicyEnable + "] is error, the value can only be 0 or 1 !");
            return result;
        }
        if ("1".equals(isPolicyEnable) && (policyParams = policyFilterInfo.getPolicyParams()).length > 0 && 200 != (result = this.checkPolicyParamsInfo(policyParams, zoneForm)).getCode()) {
            return result;
        }
        String isFilterEnable = policyFilterInfo.getFilterInEnable();
        if (!"0".equals(isFilterEnable) && !"1".equals(isFilterEnable)) {
            result.setCode(400);
            result.setMessage("filter_in_enable:[" + isFilterEnable + "] is error, the value can only be 0 or 1 !");
            return result;
        }
        if ("1".equals(isFilterEnable) && (filterNames = policyFilterInfo.getFilterNames()).length > 0 && 200 != (result = this.checkFilter(filterNames)).getCode()) {
            return result;
        }
        String isDefenseModeEnable = policyFilterInfo.getDefenseModeInEnable();
        if (!"0".equals(isDefenseModeEnable) && !"1".equals(isDefenseModeEnable)) {
            result.setCode(400);
            result.setMessage("defense_mode_in_enable:[" + isDefenseModeEnable + "] is error, the value can only be 0 or 1 !");
            return result;
        }
        if ("1".equals(isDefenseModeEnable) && (defenseModeParams = policyFilterInfo.getDefenseModeParams()).length > 0 && 200 != (result = this.checkDefenseModeParams(defenseModeParams)).getCode()) {
            return result;
        }
        return result;
    }

    private RestfuResult checkPolicyParamsInfo(PolicyParamsInfo[] policyParams, ZoneInfoForm zoneForm) {
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        ArrayList<String> attackTypeTemp = new ArrayList<String>();
        ArrayList<String> policyItems = new ArrayList<String>();
        policyItems.add("Tcp_Syn_Flood");
        policyItems.add("Tcp_Fin_Flood");
        policyItems.add("Udp_Traffic_Limiting");
        policyItems.add("Udp_Fragment_Rate_Limiting");
        policyItems.add("Icmp_Traffic_Limiting");
        policyItems.add("Tcp_Abnormal");
        policyItems.add("Tcp_Syn_First_Packet_Check");
        policyItems.add("Tcp_Ack_Flood_Attack");
        policyItems.add("Statistics_Based_On_Destination_Ip");
        policyItems.add("Http_Source_Authentication_Defense");
        int length = policyParams.length;
        for (int i = 0; i < length; ++i) {
            int secondNumber;
            String rex;
            PolicyParamsInfo policyParamsInfo = policyParams[i];
            String attackType = policyParamsInfo.getAttackType();
            String thresholdStr = policyParamsInfo.getThreshold();
            String enable = policyParamsInfo.getEnable();
            String mode = policyParamsInfo.getMode();
            if (null == attackType || "".equals(attackType.trim())) {
                result.setCode(400);
                result.setMessage("attack_type cannot null !");
                return result;
            }
            if (!policyItems.contains(attackType)) {
                result.setCode(441);
                result.setMessage("attack_type:[" + attackType + "] is not exist!");
                return result;
            }
            if (attackTypeTemp.contains(attackType)) {
                result.setCode(442);
                result.setMessage("attack_type:[" + attackType + "] is duplicate!");
                return result;
            }
            attackTypeTemp.add(attackType);
            if (!("Statistics_Based_On_Destination_Ip".equals(attackType) || "0".equals(enable) || "1".equals(enable))) {
                result.setCode(463);
                result.setMessage("attack_type:[" + attackType + "] enable_status is error, the value can only be 0 or 1!");
                return result;
            }
            if ("Tcp_Ack_Flood_Attack".equals(attackType) && !"0".equals(mode) && !"1".equals(mode)) {
                result.setCode(462);
                result.setMessage("attack_type:[" + attackType + "] mode_type is error, the value can only be 0 or 1!");
                return result;
            }
            if ("Http_Source_Authentication_Defense".equals(attackType) && !"1".equals(mode) && !"2".equals(mode) && !"4".equals(mode)) {
                result.setCode(462);
                result.setMessage("attack_type:[" + attackType + "] mode_type is error, the value can only be 1 , 2 or 4!");
                return result;
            }
            boolean flag = true;
            String errorMsg = "";
            if ("Tcp_Syn_Flood".equals(attackType) || "Tcp_Fin_Flood".equals(attackType) || "Tcp_Abnormal".equals(attackType) || "Tcp_Ack_Flood_Attack".equals(attackType)) {
                rex = "^[1-9]+\\d*$";
                if (StringUtils.isEmpty((CharSequence)thresholdStr) || !thresholdStr.matches(rex) || thresholdStr.length() > 9) {
                    flag = false;
                } else {
                    int threshold = Integer.parseInt(thresholdStr);
                    if (threshold < 1 || threshold > 80000000) {
                        flag = false;
                    }
                }
                if (!flag) {
                    errorMsg = "attack_type:[" + attackType + "] threshold is error,it is null or not a number or below 1 or above 80000000!";
                }
            } else if ("Udp_Traffic_Limiting".equals(attackType) || "Udp_Fragment_Rate_Limiting".equals(attackType) || "Icmp_Traffic_Limiting".equals(attackType)) {
                rex = "^[1-9]+\\d*$";
                if (StringUtils.isEmpty((CharSequence)thresholdStr) || !thresholdStr.matches(rex) || thresholdStr.length() > 9) {
                    flag = false;
                } else {
                    int threshold = Integer.parseInt(thresholdStr);
                    if (threshold < 1 || threshold > 2000000) {
                        flag = false;
                    }
                }
                if (!flag) {
                    errorMsg = "attack_type:[" + attackType + "] threshold is error,it is null or not a number or below 1 or above 2000000!";
                }
            } else if ("Tcp_Syn_First_Packet_Check".equals(attackType)) {
                if (!this.synFloodIsActived(policyParams, zoneForm) && "1".equals(enable)) {
                    result.setCode(464);
                    result.setMessage("attack_type:[" + attackType + "] enable_status is error, because attack_type:[Tcp_Syn_Flood] enable_status is 0 !");
                    return result;
                }
                rex = "([0-9]|[1]\\d|[2][0])[-]([1-9]|[1]\\d|[2][0])";
                if (StringUtils.isEmpty((CharSequence)thresholdStr) || !thresholdStr.matches(rex)) {
                    flag = false;
                } else {
                    String[] numbers = thresholdStr.split("-");
                    int firstNumber = Integer.parseInt(numbers[0]);
                    if (firstNumber >= (secondNumber = Integer.parseInt(numbers[1]))) {
                        flag = false;
                    }
                }
                if (!flag) {
                    errorMsg = "attack_type:[" + attackType + "] threshold is error,it is null or not correct format or the minimum value is equal or greater than the maximum value !";
                }
            } else if ("Statistics_Based_On_Destination_Ip".equals(attackType)) {
                rex = "([1-9]\\d*)[,]([1-9]\\d*)";
                if (StringUtils.isEmpty((CharSequence)thresholdStr) || !thresholdStr.matches(rex)) {
                    flag = false;
                } else {
                    String[] numbers = thresholdStr.split(",");
                    String rex1 = "^[1-9]+\\d*$";
                    if (StringUtils.isEmpty((CharSequence)numbers[0]) || !numbers[0].matches(rex1) || numbers[0].length() > 9) {
                        flag = false;
                    } else {
                        int firstNumber = Integer.parseInt(numbers[0]);
                        if (firstNumber < 1 || firstNumber > 80000000) {
                            flag = false;
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)numbers[1]) || !numbers[1].matches(rex1) || numbers[1].length() > 9) {
                        flag = false;
                    } else {
                        secondNumber = Integer.parseInt(numbers[1]);
                        if (secondNumber < 1 || secondNumber > 80000000) {
                            flag = false;
                        }
                    }
                    if (flag && !this.isEnableOfSourceAuth(policyParams, zoneForm)) {
                        result.setCode(464);
                        result.setMessage("attack_type:[" + attackType + "] Cannot assign value, because attack_type:[HTTP_SOURCE_AUTHENTICATION_DEFENSE] not activated !");
                        return result;
                    }
                }
                if (!flag) {
                    errorMsg = "attack_type:[" + attackType + "] threshold is error, it is null or format error or below 1 or above 80000000!";
                }
            } else if ("Http_Source_Authentication_Defense".equals(attackType) && "1".equals(enable) && !this.isHasVaulueOfDestinationIp(policyParams, zoneForm)) {
                result.setCode(465);
                result.setMessage("attack_type:[" + attackType + "] value is null !");
                return result;
            }
            if (flag) continue;
            result.setCode(443);
            result.setMessage(errorMsg);
            return result;
        }
        return result;
    }

    private boolean synFloodIsActived(PolicyParamsInfo[] policyParams, ZoneInfoForm zoneForm) {
        boolean isActived = true;
        int size = policyParams.length;
        for (int i = 0; i < size; ++i) {
            if (!"Tcp_Syn_Flood".equals(policyParams[i].getAttackType())) continue;
            return "1".equals(policyParams[i].getEnable());
        }
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        if (!defaultServices.isEmpty()) {
            ZoneServiceForm zoneServiceForm = null;
            IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
            for (ZoneServiceForm service : defaultServices) {
                zoneServiceForm = (ZoneServiceForm)serviceService.query((Object)service.getPkid());
                if (null != zoneServiceForm.getTcpDefendPolicyForm().getSynfloodEnable()) continue;
                isActived = false;
                break;
            }
        } else {
            isActived = false;
        }
        return isActived;
    }

    private boolean isHasVaulueOfDestinationIp(PolicyParamsInfo[] policyParams, ZoneInfoForm zoneForm) {
        boolean isActived = true;
        int size = policyParams.length;
        for (int i = 0; i < size; ++i) {
            if (!"Statistics_Based_On_Destination_Ip".equals(policyParams[i].getAttackType())) continue;
            return true;
        }
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        if (!defaultServices.isEmpty()) {
            ZoneServiceForm zoneServiceForm = null;
            IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
            for (ZoneServiceForm service : defaultServices) {
                zoneServiceForm = (ZoneServiceForm)serviceService.query((Object)service.getPkid());
                if (null != zoneServiceForm.getHttpDefendPolicyForm().getHttpAlertRate() && null != zoneServiceForm.getHttpDefendPolicyForm().getHttpDestQpsAlertRate()) continue;
                isActived = false;
                break;
            }
        }
        return isActived;
    }

    private boolean isEnableOfSourceAuth(PolicyParamsInfo[] policyParams, ZoneInfoForm zoneForm) {
        boolean isActived = true;
        int size = policyParams.length;
        for (int i = 0; i < size; ++i) {
            if (!"Http_Source_Authentication_Defense".equals(policyParams[i].getAttackType())) continue;
            return "1".equals(policyParams[i].getEnable());
        }
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        if (!defaultServices.isEmpty()) {
            ZoneServiceForm zoneServiceForm = null;
            IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
            for (ZoneServiceForm service : defaultServices) {
                zoneServiceForm = (ZoneServiceForm)serviceService.query((Object)service.getPkid());
                if (null != zoneServiceForm.getHttpDefendPolicyForm().getHttpSourceAuthEnable()) continue;
                isActived = false;
                break;
            }
        } else {
            isActived = false;
        }
        return isActived;
    }

    private RestfuResult checkFilter(String[] filterNames) {
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        if (20 < filterNames.length) {
            result.setCode(452);
            result.setMessage("filter number over max limit(20)!");
            return result;
        }
        IFilterService filterService = ZoneReferUtil.getFilterService();
        FilterForm filterForm = null;
        ArrayList<String> filterNameTemp = new ArrayList<String>();
        String filterNameRegex = "^(?!\\s*null$)[a-zA-Z][a-zA-Z0-9_]{0,62}$";
        for (String filterName : filterNames) {
            if (null == filterName || "".equals(filterName.trim()) || !filterName.matches(filterNameRegex)) {
                result.setCode(400);
                result.setMessage("filter_in is error");
                return result;
            }
            filterForm = filterService.queryByName(filterName);
            if (null == filterForm) {
                result.setCode(450);
                result.setMessage("filter_in:[" + filterName + "] not exist !");
                return result;
            }
            if (filterNameTemp.contains(filterName)) {
                result.setCode(451);
                result.setMessage("filter_in:[" + filterName + "] duplicate!");
                return result;
            }
            filterNameTemp.add(filterName);
        }
        return result;
    }

    private RestfuResult checkDefenseModeParams(DefenseModeParamsInfo[] defenseModeParams) {
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        ArrayList<String> attackTypeTemp = new ArrayList<String>();
        ArrayList<String> policyItems = new ArrayList<String>();
        policyItems.add("Traffic_Limiting_For_Single_Ip");
        policyItems.add("Blackhole");
        policyItems.add("Blackhole_Notify");
        for (DefenseModeParamsInfo policyParamsInfo : defenseModeParams) {
            int threshold;
            String rex;
            String defenseType = policyParamsInfo.getDefenseType();
            String thresholdStr = policyParamsInfo.getThreshold();
            String enable = policyParamsInfo.getEnable();
            if (null == defenseType || "".equals(defenseType.trim())) {
                result.setCode(400);
                result.setMessage("defense_type is null !");
                return result;
            }
            if (!policyItems.contains(defenseType)) {
                result.setCode(460);
                result.setMessage("defense_type:[" + defenseType + "] is not exist!");
                return result;
            }
            if (attackTypeTemp.contains(defenseType)) {
                result.setCode(461);
                result.setMessage("defense_type:[" + defenseType + "] is duplicate!");
                return result;
            }
            attackTypeTemp.add(defenseType);
            if (!"0".equals(enable) && !"1".equals(enable)) {
                result.setCode(463);
                result.setMessage("defense_type:[" + defenseType + "] enable_status is error, the value can only be 0 or 1!");
                return result;
            }
            boolean flag = true;
            String errorMsg = "";
            if ("Blackhole".equals(defenseType)) {
                rex = "^[1-9]+\\d*$";
                if (StringUtils.isEmpty((CharSequence)thresholdStr) || !thresholdStr.matches(rex) || thresholdStr.length() > 9) {
                    flag = false;
                } else {
                    threshold = Integer.parseInt(thresholdStr);
                    if (threshold < 1 || threshold > 10000000) {
                        flag = false;
                    }
                }
                if (!flag) {
                    errorMsg = "defense_type:[" + defenseType + "] threshold is error,it is null or not a number or below 1 or above 10000000!";
                }
            } else if ("Traffic_Limiting_For_Single_Ip".equals(defenseType)) {
                rex = "^[1-9]+\\d*$";
                if (StringUtils.isEmpty((CharSequence)thresholdStr) || !thresholdStr.matches(rex) || thresholdStr.length() > 9) {
                    flag = false;
                } else {
                    threshold = Integer.parseInt(thresholdStr);
                    if (threshold < 1 || threshold > 2000000) {
                        flag = false;
                    }
                }
                if (!flag) {
                    errorMsg = "defense_type:[" + defenseType + "] threshold is error,it is null or not a number or below 1 or above 2000000!";
                }
            }
            if (flag) continue;
            result.setCode(443);
            result.setMessage(errorMsg);
            return result;
        }
        return result;
    }

    private boolean handlePolicy(PolicyParamsInfo[] policyParams, ZoneInfoForm zoneForm) {
        ZoneServiceForm zoneServiceForm = null;
        IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        if (!defaultServices.isEmpty()) {
            for (ZoneServiceForm service : defaultServices) {
                zoneServiceForm = (ZoneServiceForm)serviceService.query((Object)service.getPkid());
                for (PolicyParamsInfo policyParamsInfo : policyParams) {
                    HttpDefendPolicyForm http;
                    UdpDefendPolicyForm udp;
                    TcpDefendPolicyForm tcp;
                    String attackType = policyParamsInfo.getAttackType();
                    String enalbe = policyParamsInfo.getEnable();
                    String thresholdStr = policyParamsInfo.getThreshold();
                    Integer threshold = null;
                    String[] thresholds = new String[2];
                    String modeStr = policyParamsInfo.getMode();
                    Integer mode = null;
                    if (!StringUtils.isEmpty((CharSequence)modeStr)) {
                        mode = Integer.parseInt(modeStr);
                    }
                    if ("Tcp_Syn_First_Packet_Check".equals(attackType)) {
                        thresholds = thresholdStr.split("-");
                    } else if ("Statistics_Based_On_Destination_Ip".equals(attackType)) {
                        thresholds = thresholdStr.split(",");
                    } else if (null != thresholdStr) {
                        threshold = Integer.parseInt(thresholdStr);
                    }
                    if ("Tcp_Syn_Flood".equals(attackType)) {
                        tcp = zoneServiceForm.getTcpDefendPolicyForm();
                        if (null == tcp) continue;
                        if ("1".equals(enalbe)) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpBasicEnable(Boolean.valueOf(true));
                            tcp.setSynfloodEnable(Boolean.valueOf(true));
                            tcp.setSynFloodDefendModeEnable(Boolean.valueOf(true));
                            tcp.setSynfloodMode(Integer.valueOf(1));
                            tcp.setSynfloodAlertRate(threshold);
                            continue;
                        }
                        tcp.setSynfloodEnable(Boolean.valueOf(false));
                        tcp.setSynFloodDefendModeEnable(Boolean.valueOf(false));
                        tcp.setSynfloodMode(null);
                        tcp.setSynfloodAlertRate(null);
                        tcp.setSynFirstPacketCheckEnable(Boolean.valueOf(false));
                        tcp.setFirstPacketCheckLowerLimit(null);
                        tcp.setFirstPacketCheckLowerLimit(null);
                        tcp.setFirstPacketCheckUpperLimit(null);
                        continue;
                    }
                    if ("Tcp_Fin_Flood".equals(attackType)) {
                        tcp = zoneServiceForm.getTcpDefendPolicyForm();
                        if (null == tcp) continue;
                        if ("1".equals(enalbe)) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpBasicEnable(Boolean.valueOf(true));
                            tcp.setFinRstFloodEnable(Boolean.valueOf(true));
                            tcp.setFinRstFloodAlertRate(threshold);
                            continue;
                        }
                        tcp.setFinRstFloodEnable(Boolean.valueOf(false));
                        tcp.setFinRstFloodAlertRate(null);
                        continue;
                    }
                    if ("Udp_Traffic_Limiting".equals(attackType)) {
                        udp = zoneServiceForm.getUdpDefendPolicyForm();
                        if (null == udp) continue;
                        if ("1".equals(enalbe)) {
                            udp.setUdpBlock(Boolean.valueOf(false));
                            udp.setUdpLimitEnable(Boolean.valueOf(true));
                            udp.setUdpMaxSpeedEnable(Boolean.valueOf(true));
                            udp.setUdpMaxSpeed(threshold);
                            continue;
                        }
                        udp.setUdpMaxSpeedEnable(Boolean.valueOf(false));
                        udp.setUdpMaxSpeed(null);
                        continue;
                    }
                    if ("Udp_Fragment_Rate_Limiting".equals(attackType)) {
                        udp = zoneServiceForm.getUdpDefendPolicyForm();
                        if (null == udp) continue;
                        if ("1".equals(enalbe)) {
                            udp.setUdpBlock(Boolean.valueOf(false));
                            udp.setUdpLimitEnable(Boolean.valueOf(true));
                            udp.setUdpFragMaxSpeedEnable(Boolean.valueOf(true));
                            udp.setUdpFragMaxSpeed(threshold);
                            continue;
                        }
                        udp.setUdpFragMaxSpeedEnable(Boolean.valueOf(false));
                        udp.setUdpFragMaxSpeed(null);
                        continue;
                    }
                    if ("Icmp_Traffic_Limiting".equals(attackType)) {
                        IcmpDefendPolicyForm icmp = zoneServiceForm.getIcmpDefendPolicyForm();
                        if (null == icmp) continue;
                        if ("1".equals(enalbe)) {
                            icmp.setIcmpBlockEnable(Boolean.valueOf(false));
                            icmp.setIcmpMaxSpeedEnable(Boolean.valueOf(true));
                            icmp.setIcmpLimitSubEnable(Boolean.valueOf(true));
                            icmp.setIcmpMaxSpeed(threshold);
                            continue;
                        }
                        icmp.setIcmpLimitSubEnable(Boolean.valueOf(false));
                        icmp.setIcmpMaxSpeed(null);
                        continue;
                    }
                    if ("Tcp_Syn_First_Packet_Check".equals(attackType)) {
                        tcp = zoneServiceForm.getTcpDefendPolicyForm();
                        if (null == tcp) continue;
                        if ("1".equals(enalbe)) {
                            tcp.setSynFirstPacketCheckEnable(Boolean.valueOf(true));
                            tcp.setFirstPacketCheckLowerLimit(Integer.valueOf(Integer.parseInt(thresholds[0])));
                            tcp.setFirstPacketCheckUpperLimit(Integer.valueOf(Integer.parseInt(thresholds[1])));
                            continue;
                        }
                        tcp.setSynFirstPacketCheckEnable(Boolean.valueOf(false));
                        tcp.setFirstPacketCheckLowerLimit(null);
                        tcp.setFirstPacketCheckUpperLimit(null);
                        continue;
                    }
                    if ("Tcp_Abnormal".equals(attackType)) {
                        tcp = zoneServiceForm.getTcpDefendPolicyForm();
                        if (null == tcp) continue;
                        if ("1".equals(enalbe)) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpAbnormalEnable(Boolean.valueOf(true));
                            tcp.setTcpAbnormalAlertRate(threshold);
                            continue;
                        }
                        tcp.setTcpAbnormalEnable(Boolean.valueOf(false));
                        tcp.setTcpAbnormalAlertRate(null);
                        continue;
                    }
                    if ("Tcp_Ack_Flood_Attack".equals(attackType)) {
                        tcp = zoneServiceForm.getTcpDefendPolicyForm();
                        if (null == tcp) continue;
                        if ("1".equals(enalbe)) {
                            tcp.setTcpBlock(Boolean.valueOf(false));
                            tcp.setTcpDefendEnable(Boolean.valueOf(true));
                            tcp.setTcpBasicEnable(Boolean.valueOf(true));
                            tcp.setAckFloodEnable(Boolean.valueOf(true));
                            tcp.setAckSessionCheckEnable(Boolean.valueOf(true));
                            tcp.setAckFloodAlertRate(threshold);
                            tcp.setAckFloodMode(mode);
                            continue;
                        }
                        tcp.setAckFloodEnable(Boolean.valueOf(false));
                        tcp.setAckFloodAlertRate(null);
                        tcp.setAckFloodMode(null);
                        continue;
                    }
                    if ("Statistics_Based_On_Destination_Ip".equals(attackType)) {
                        http = zoneServiceForm.getHttpDefendPolicyForm();
                        if (null == http) continue;
                        http.setHttpDestAlertRateEnable(Boolean.valueOf(false));
                        http.setHttpAlertRate(null);
                        http.setHttpDestQpsEnable(Boolean.valueOf(true));
                        http.setHttpDestQpsAlertRate(Integer.valueOf(Integer.parseInt(thresholds[1])));
                        continue;
                    }
                    if (!"Http_Source_Authentication_Defense".equals(attackType) || null == (http = zoneServiceForm.getHttpDefendPolicyForm())) continue;
                    if ("1".equals(enalbe)) {
                        http.setHttpDefendEnable(Boolean.valueOf(true));
                        http.setHttpSourceAuthEnable(Boolean.valueOf(true));
                        http.setDefendMode(mode);
                        continue;
                    }
                    http.setHttpSourceAuthEnable(Boolean.valueOf(false));
                    http.setDefendMode(null);
                    http.setHttpDestAlertRateEnable(Boolean.valueOf(false));
                    http.setHttpDestQpsEnable(Boolean.valueOf(false));
                    http.setHttpAlertRate(null);
                    http.setHttpDestQpsAlertRate(null);
                }
                serviceService.create((Object)zoneServiceForm);
            }
            return true;
        }
        return false;
    }

    private boolean updateDefenseMode(DefenseModeParamsInfo[] defenseModeParams, ZoneInfoForm zoneForm) {
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = zonePolicyApplyService.queryByZoneId(zoneForm.getZoneId());
        zonePolicyApplyForm.setDefendMode(Integer.valueOf(0));
        for (DefenseModeParamsInfo defenseModeParamInfo : defenseModeParams) {
            String defenseType = defenseModeParamInfo.getDefenseType();
            String enalbe = defenseModeParamInfo.getEnable();
            String threshold = defenseModeParamInfo.getThreshold();
            if ("Traffic_Limiting_For_Single_Ip".equals(defenseType)) {
                if ("1".equals(enalbe)) {
                    zonePolicyApplyForm.setIpLimitEnable(Boolean.valueOf(true));
                    zonePolicyApplyForm.setIpLimit(Integer.valueOf(Integer.parseInt(threshold)));
                    continue;
                }
                zonePolicyApplyForm.setIpLimitEnable(Boolean.valueOf(false));
                zonePolicyApplyForm.setIpLimit(null);
                continue;
            }
            if ("Blackhole".equals(defenseType)) {
                if ("1".equals(enalbe)) {
                    zonePolicyApplyForm.setBlackholeEnable(Boolean.valueOf(true));
                    zonePolicyApplyForm.setBlackholeThreshold(Long.valueOf(Long.parseLong(threshold)));
                    continue;
                }
                zonePolicyApplyForm.setBlackholeEnable(Boolean.valueOf(false));
                zonePolicyApplyForm.setBlackholeThreshold(null);
                continue;
            }
            if (!"Blackhole_Notify".equals(defenseType)) continue;
            if ("1".equals(enalbe)) {
                zonePolicyApplyForm.setBlackholeNotifyEnable(Integer.valueOf(1));
                continue;
            }
            zonePolicyApplyForm.setBlackholeNotifyEnable(Integer.valueOf(2));
        }
        try {
            zonePolicyApplyService.update(zonePolicyApplyForm);
        }
        catch (LegoCheckedException e) {
            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            String responseMsg = "updateDefenseMode. save zonePolicyApplyForm fail. error message is : " + errorMsg;
            this.logger.error((Object)(responseMsg + " " + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            this.logger.error((Object)("updateDefenseMode. save zonePolicyApplyForm fail. error message is : " + e.getMessage()));
            return false;
        }
        return true;
    }

    private RestfuResult deployZone(IZonePolicyMgrService zonePolicyMgrService, List<Long> zoneIdList, String zoneAccount) {
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        try {
            zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("updateZonePolicy"), null);
        }
        catch (LegoCheckedException e) {
            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            String responseMsg = "deployZone. deploy failed. zoneAccount is " + zoneAccount + "; error message is : " + errorMsg;
            this.logger.error((Object)(responseMsg + " " + e.getMessage()));
            result.setCode(507);
            result.setMessage(errorMsg);
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)("deployZone. deploy failed. zoneAccount is " + zoneAccount + " " + e.getMessage()));
            result.setCode(507);
            result.setMessage("ATIC inner error occurred while deploy zone.");
            return result;
        }
        return result;
    }

    private List<ZoneServiceForm> getDDOSDefaultZoneServiceForms(ZoneInfoForm zoneForm) {
        ArrayList<ZoneServiceForm> zoneServiceForms = new ArrayList<ZoneServiceForm>();
        IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", String.valueOf(zoneForm.getZoneId()));
        queryMap.put("protocol", "DEFAULT");
        queryMap.put("direction", "1");
        Paging result = serviceService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List defaultServices = result.getData();
        if (!defaultServices.isEmpty()) {
            for (ZoneServiceForm service : defaultServices) {
                Long deviceId = service.getDeviceId();
                AticDevice device = aticDeviceService.getDeviceByMoid(deviceId.longValue());
                if (null == device || 1 != device.getDeviceType()) continue;
                zoneServiceForms.add(service);
            }
        }
        return zoneServiceForms;
    }

    private boolean updateZoneFilter(String[] filterNames, String zoneName) {
        List<ZoneDeviceForm> zoneDeviceForms = this.getZoneDdosDevice(zoneName);
        List<FilterForm> filterForms = this.getFiltersByName(filterNames);
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = ZoneReferUtil.getFilterDeviceZoneInfoService();
        filterDeviceZoneInfoService.delFilterRelationByZoneId(zoneDeviceForms.get(0).getZoneId());
        if (CollectionUtils.isNotEmpty(filterForms) && CollectionUtils.isNotEmpty(zoneDeviceForms)) {
            for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
                AticDevice aticDevice = aticDeviceService.getDeviceByMoid(zoneDeviceForm.getDeviceId().longValue());
                if (aticDevice.getDeviceType() != 1) continue;
                Long preference = 0L;
                ArrayList<FilterDeviceZoneForm> filterDeviceZoneForms = new ArrayList<FilterDeviceZoneForm>();
                for (FilterForm filterForm : filterForms) {
                    FilterDeviceZoneForm filterDeviceZoneForm = new FilterDeviceZoneForm();
                    preference = preference + 10L;
                    filterDeviceZoneForm.setFilterId(filterForm.getPkid());
                    filterDeviceZoneForm.setZoneId(zoneDeviceForm.getZoneId());
                    filterDeviceZoneForm.setDeviceId(zoneDeviceForm.getDeviceId());
                    filterDeviceZoneForm.setPreference(preference);
                    filterDeviceZoneForm.setDirection(1);
                    filterDeviceZoneForms.add(filterDeviceZoneForm);
                }
                try {
                    filterDeviceZoneInfoService.saveAll(filterDeviceZoneForms);
                }
                catch (LegoCheckedException e) {
                    String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                    String responseMsg = "updateZoneFilter. save filter fail. error message is : " + errorMsg;
                    this.logger.error((Object)(responseMsg + " " + e.getMessage()));
                    return false;
                }
                catch (Exception e) {
                    this.logger.error((Object)("updateZoneFilter. save filter fail. error message is : " + e.getMessage()));
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private List<ZoneDeviceForm> getZoneDdosDevice(String zoneName) {
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        IZoneDeviceService zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
        ZoneInfoForm zoneInfoForm = zoneService.getZoneByName(zoneName);
        List<Object> zoneDeviceForms = new ArrayList<ZoneDeviceForm>();
        if (null != zoneDeviceService && null != zoneInfoForm) {
            zoneDeviceForms = zoneDeviceService.getByZoneId(zoneInfoForm.getZoneId());
        }
        return zoneDeviceForms;
    }

    private List<FilterForm> getFiltersByName(String[] filterNames) {
        ArrayList<FilterForm> filterForms = new ArrayList<FilterForm>();
        IFilterService filterService = ZoneReferUtil.getFilterService();
        for (String filterName : filterNames) {
            FilterForm filterForm = filterService.queryByName(filterName);
            if (null == filterForm || filterForm.getDeviceType().equals("NFA")) continue;
            filterForms.add(filterForm);
        }
        return filterForms;
    }

    private boolean isInvalidErrorMsgKey(String errorMsgKey) {
        return null == errorMsgKey || "".equals(errorMsgKey) || "--".equals(errorMsgKey) || "lego.err.--".equals(errorMsgKey);
    }

    @Override
    @PUT
    @Path(value="/policy/severity")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateFaultSeverityRule(String json) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        int responseCode = 412;
        String requestMsg = "";
        String terminalIp = "127.0.0.1";
        String url = "null";
        json = json.replace('\n', ' ').replace('\r', ' ');
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/policy/severity");
            requestMsg = "restful request url : " + url + ". json string is :" + json + ".";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/policy/severity");
        if (null == userName) {
            responseCode = 412;
            responseMsg = "illegal token.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        this.logger.info((Object)("updateFaultSeverityRule:clientIp: " + terminalIp));
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2207L))) {
            responseMsg = "current user can not update fault severity rule.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        RestFaultSeverityRuleInfo ruleInfo = null;
        try {
            this.checkJson(json);
            ruleInfo = (RestFaultSeverityRuleInfo)JSONUtil.getInstance().fromJSON(json, RestFaultSeverityRuleInfo.class);
        }
        catch (Exception e) {
            responseCode = 418;
            responseMsg = "json format error.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "." + e.getMessage()));
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        String zoneName = ruleInfo.getAccount();
        String[] paramsUser = new String[]{terminalIp, userName, "lego.fault.severity.rule", zoneName};
        Map<String, String> checkResult = this.checkFaultSeverityRule(ruleInfo);
        if (!"200".equals(checkResult.get("code"))) {
            responseCode = Integer.parseInt(checkResult.get("code"));
            responseMsg = checkResult.get("codeInfo");
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        long zoneId = 1L;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        if (ZoneUtil.isValidZoneName((String)ruleInfo.getAccount())) {
            ZoneInfoForm zoneInfoForm = zoneService.getZoneByName(ruleInfo.getAccount());
            if (null == zoneInfoForm) {
                responseCode = 404;
                responseMsg = "account is not exist in a zone.";
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
            zoneId = zoneInfoForm.getZoneId();
            if ((IPUtil.isIpv4((String)ruleInfo.getProtectIp()) || IPUtil.isIpv6((String)ruleInfo.getProtectIp())) && !this.isIpExistedInPolicy(zoneId, ruleInfo.getProtectIp())) {
                responseCode = 409;
                responseMsg = "protect_ip is not in the account protect range.";
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
                Response.ResponseBuilder builder = Response.status((int)responseCode);
                builder.entity((Object)responseMsg);
                return builder.build();
            }
        } else if (IPUtil.isIpv4((String)ruleInfo.getProtectIp()) || IPUtil.isIpv6((String)ruleInfo.getProtectIp())) {
            zoneId = zoneService.getZoneIdByIp(ruleInfo.getProtectIp());
            if (1L == zoneId) {
                responseCode = 404;
                responseMsg = "protect_ip is not exist in a zone.";
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)responseMsg);
                return responseBuilder.build();
            }
        } else {
            responseCode = 418;
            responseMsg = "format is error.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (!isAdmin) {
            ZoneInfoForm zoneInfo;
            block20: {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                zoneInfo = zoneService.getById(Long.valueOf(zoneId));
                moIdList.add(zoneInfo.getMoId());
                try {
                    IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                    long userId = userMgr.getUserInfoByName(userName).getId();
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                    if (570506L != e.getErrorCode()) break block20;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    this.logger.error((Object)("updateFaultSeverityRule:" + responseMsg + ". clientIp: " + terminalIp + "."));
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
            }
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            zoneIdList.add(zoneInfo.getZoneId());
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(responseBuilder, requestMsg, e);
            }
        }
        Response response = this.saveSeverityRule(zoneId, ruleInfo, json);
        responseCode = response.getStatus();
        responseMsg = "";
        if (null != response.getEntity()) {
            responseMsg = response.getEntity().toString();
        }
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])paramsUser, (boolean)false);
        return response;
    }

    private Response buildErrorResponse(Response.ResponseBuilder responseBuilder, String requestMsg, LegoCheckedException e) {
        if (630114L == e.getErrorCode()) {
            int responseCode = 455;
            String responseMsg = "The current user does not have the device resource permissions associated with the this zone.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        if (570506L == e.getErrorCode()) {
            int responseCode = 500;
            String responseMsg = "Unable to get the service published in the background.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        return responseBuilder.build();
    }

    private Map<String, String> checkFaultSeverityRule(RestFaultSeverityRuleInfo ruleInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != ruleInfo) {
            if (StringUtils.isEmpty((CharSequence)ruleInfo.getInTrafficMbps()) || !ruleInfo.getInTrafficMbps().matches("^[0-9]+$") || ruleInfo.getInTrafficMbps().length() > 8 || 1 > Integer.parseInt(ruleInfo.getInTrafficMbps()) || Integer.parseInt(ruleInfo.getInTrafficMbps()) > 99999999) {
                map.put("code", "418");
                map.put("codeInfo", "traffic_mbps format is error,it is null or not a number or below 1 or above 99999999.");
                return map;
            }
            if (StringUtils.isEmpty((CharSequence)ruleInfo.getAccount()) && StringUtils.isEmpty((CharSequence)ruleInfo.getProtectIp())) {
                map.put("code", "418");
                map.put("codeInfo", "account and protect_ip can not be null at the same time.");
                return map;
            }
            if (StringUtils.isNotEmpty((CharSequence)ruleInfo.getAccount())) {
                if (ZoneUtil.isValidZoneName((String)ruleInfo.getAccount())) {
                    if (StringUtils.isEmpty((CharSequence)ruleInfo.getProtectIp()) || StringUtils.isNotEmpty((CharSequence)ruleInfo.getProtectIp()) && (IPUtil.isIpv4((String)ruleInfo.getProtectIp()) || IPUtil.isIpv6((String)ruleInfo.getProtectIp()))) {
                        map.put("code", "200");
                        map.put("codeInfo", "");
                    } else {
                        map.put("code", "418");
                        map.put("codeInfo", "protect_ip format error,it is null or not a ip which format is 'x.x.x.x' .");
                    }
                } else {
                    map.put("code", "418");
                    map.put("codeInfo", "account format error.");
                }
                return map;
            }
            if (StringUtils.isNotEmpty((CharSequence)ruleInfo.getProtectIp()) && (IPUtil.isIpv4((String)ruleInfo.getProtectIp()) || IPUtil.isIpv6((String)ruleInfo.getProtectIp()))) {
                map.put("code", "200");
                map.put("codeInfo", "");
            } else {
                map.put("code", "418");
                map.put("codeInfo", "protect_ip format error,it is null or not a ip which format is 'x.x.x.x' .");
            }
            return map;
        }
        map.put("code", "418");
        map.put("codeInfo", "format is error.");
        return map;
    }

    private boolean isIpExistedInPolicy(Long zoneId, String sourceIp) {
        if (null == sourceIp || null == zoneId) {
            return false;
        }
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        long id = zoneService.getZoneIdByIp(sourceIp);
        return 1L != zoneId && zoneId == id;
    }

    private Response saveSeverityRule(Long zoneId, RestFaultSeverityRuleInfo ruleInfo, String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        FaultSeverityRuleService faultSeverityRuleService = ZoneReferUtil.getFaultSeverityRuleService();
        FaultSeverityRuleForm faultSeverityRule = faultSeverityRuleService.getZoneSeverityRuleByZoneId(zoneId, Integer.valueOf(1));
        if (null == faultSeverityRule) {
            faultSeverityRule = new FaultSeverityRuleForm();
            faultSeverityRule.getCriticalRule().setZoneId(zoneId);
            faultSeverityRule.getMajorRule().setZoneId(zoneId);
            faultSeverityRule.getMinorRule().setZoneId(zoneId);
            faultSeverityRule.getWarningRule().setZoneId(zoneId);
            faultSeverityRule.getCriticalRule().setDirection(1);
            faultSeverityRule.getMajorRule().setDirection(1);
            faultSeverityRule.getMinorRule().setDirection(1);
            faultSeverityRule.getWarningRule().setDirection(1);
            faultSeverityRule.setNewRule(true);
        }
        faultSeverityRule.getCriticalRule().setDirection(1);
        faultSeverityRule.getCriticalRule().setInTrafficMbps(Integer.parseInt(ruleInfo.getInTrafficMbps()));
        faultSeverityRule.getCriticalRule().setDiversionAction(3);
        faultSeverityRule.getCriticalRule().setInTrafficMbpsStatus(1);
        faultSeverityRule.getCriticalRule().setInTrafficppsStatus(0);
        faultSeverityRule.getCriticalRule().setCurrentConnStatus(0);
        faultSeverityRule.getCriticalRule().setNewConnStatus(0);
        faultSeverityRule.getCriticalRule().setDurationStatus(0);
        try {
            String[] result = faultSeverityRuleService.saveRuleForRestful(faultSeverityRule);
            int collectCount = Integer.parseInt(result[0]);
            int successCount = Integer.parseInt(result[1]);
            int failedCount = Integer.parseInt(result[2]);
            String collectStateInfo = result[3];
            if (collectCount > 0 && successCount > 0) {
                if (collectCount == successCount + failedCount && !collectStateInfo.contains(",0")) {
                    this.logger.info((Object)("updateFaultSeverityRule succeed. json string is " + json));
                    responseBuilder = responseBuilder.status(200);
                } else {
                    this.logger.info((Object)("updateFaultSeverityRule:part of collects save successfully. json string is " + json));
                    responseBuilder.entity((Object)("part of collects save successfully." + collectStateInfo));
                    responseBuilder = responseBuilder.status(508);
                }
                return responseBuilder.build();
            }
            this.logger.info((Object)("updateFaultSeverityRule:all collects save failed. json string is " + json));
            responseBuilder = responseBuilder.status(509);
            responseBuilder.entity((Object)("all collects save failed." + collectStateInfo));
            return responseBuilder.build();
        }
        catch (RemoteException e) {
            this.logger.error((Object)("updateFaultSeverityRule:save failed. json string is " + json + " " + e.getMessage()));
            responseBuilder = responseBuilder.status(509);
            responseBuilder.entity((Object)"save failed.");
            return responseBuilder.build();
        }
    }

    private Response handleOverAPInvokeLimit(RestLogInfo logInfo, Response.ResponseBuilder responseBuilder) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        int responseCode = 423;
        String responseMsg = "exceed concurrent api call limit.";
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)responseCode, (String)responseMsg);
        responseBuilder.status(responseCode);
        responseBuilder.entity((Object)responseMsg);
        return responseBuilder.build();
    }

    private List<String> initFeatures(String methodName) {
        if (!this.featureMap.containsKey(methodName)) {
            ArrayList<String> features = new ArrayList<String>();
            switch (methodName) {
                case "createZone": 
                case "updateZone": {
                    features.add(Constant.Feature.ZoneDefineInfo.toString());
                    features.add(Constant.Feature.ZoneIpInfo.toString());
                    features.add(Constant.Feature.ZoneDefendModeData.toString());
                    features.add(Constant.Feature.ZoneBasicPolicyInfo.toString());
                    break;
                }
                case "addZoneIp": 
                case "deleteZoneIp": {
                    features.add(Constant.Feature.ZoneDefineInfo.toString());
                    features.add(Constant.Feature.ZoneIpInfo.toString());
                    break;
                }
                case "deployPolicy": {
                    break;
                }
                case "updatePolicy": {
                    features.add(Constant.Feature.ZoneDefineInfo.toString());
                    features.add(Constant.Feature.ZoneBasicPolicyInfo.toString());
                    features.add(Constant.Feature.ServiceTcpDefendData.toString());
                    features.add(Constant.Feature.ServiceUdpDefendData.toString());
                    features.add(Constant.Feature.ServiceIcmpDefendData.toString());
                    break;
                }
                case "updateZonePolicy": {
                    features.add(Constant.Feature.ZoneDefineInfo.toString());
                    features.add(Constant.Feature.ZoneBasicPolicyInfo.toString());
                    features.add(Constant.Feature.ServiceTcpDefendData.toString());
                    features.add(Constant.Feature.ServiceUdpDefendData.toString());
                    features.add(Constant.Feature.ServiceIcmpDefendData.toString());
                    features.add(Constant.Feature.ServiceHttpDefendData.toString());
                    features.add(Constant.Feature.FilterZoneData.toString());
                    break;
                }
                case "updateLocationPolicy": {
                    features.add(Constant.Feature.ZoneIpLocationData.toString());
                    break;
                }
                case "updateZoneUDPPolicy": {
                    features.add(Constant.Feature.ServiceUdpDefendData.toString());
                    break;
                }
            }
            if (!features.isEmpty()) {
                this.featureMap.put(methodName, features);
            }
        }
        return this.featureMap.get(methodName);
    }

    private Response logExit(RestLogInfo logInfo) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        String[] params = new String[]{logInfo.getTerminalIp(), logInfo.getUserName(), logInfo.getOperation(), logInfo.getTarget()};
        String[] detailPara = new String[]{logInfo.getUrl(), logInfo.getJson(), logInfo.getResponseDetail()};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)logInfo.getResponseCode(), (String[])params, (boolean)logInfo.isTargetLocal());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        responseBuilder.entity((Object)logInfo.getResponseMsg());
        return responseBuilder.build();
    }

    private Response logExitThird(RestLogInfo logInfo) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        String[] params = new String[]{logInfo.getTerminalIp(), logInfo.getUserName(), logInfo.getOperation(), logInfo.getTarget()};
        String[] detailPara = new String[]{logInfo.getUrl(), logInfo.getJson(), logInfo.getResponseDetail()};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)logInfo.getResponseCode(), (String[])params, (boolean)logInfo.isTargetLocal());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        HashMap<String, String> responseObj = new HashMap<String, String>();
        responseObj.put("errorCode", logInfo.getResponseCode() + "");
        responseObj.put("errorMsg", logInfo.getResponseMsg());
        try {
            responseBuilder.entity((Object)JSONUtil.getInstance().toJSON(responseObj));
        }
        catch (IOException e) {
            this.logger.error((Object)("logExitThird obj to json error obj : " + responseObj));
        }
        return responseBuilder.build();
    }

    private Response noOpeLogExit(RestLogInfo logInfo) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        HashMap<String, String> responseObj = new HashMap<String, String>();
        responseObj.put("errorCode", logInfo.getResponseCode() + "");
        responseObj.put("errorMsg", logInfo.getResponseMsg());
        try {
            responseBuilder.entity((Object)JSONUtil.getInstance().toJSON(responseObj));
        }
        catch (IOException e) {
            this.logger.error((Object)("logExitThird obj to json error obj : " + responseObj));
        }
        return responseBuilder.build();
    }

    private static boolean isNumeric(String str) {
        if (null == str || str.trim().length() == 0) {
            throw new IllegalArgumentException("the mask is not number.");
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            throw new IllegalArgumentException("the mask is not number.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @POST
    @Path(value="/zone_ip/ipmask")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteZoneIpWithMask(String zoneIpWithMaskJson) {
        this.logger.info((Object)("--------deleteZoneIpWithMask-------- start : " + System.currentTimeMillis()));
        responseBuilder = Response.ok();
        logInfo = new RestLogInfo();
        request = ServletActionContext.getRequest();
        userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone_ip/ipmask");
        requestMsg = "deleteZoneIpWithMask. restful request is null.";
        terminalIp = "127.0.0.1";
        url = "null";
        json = zoneIpWithMaskJson;
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone_ip/ipmask");
            requestMsg = "restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        responseMsg = "";
        responseCode = 500;
        detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.delete.zoneip");
        logInfo.setTargetLocal(false);
        apiName = "deleteZoneIpWithMask";
        logInfo.setApiName(apiName);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            this.generateResponseJson(responseBuilder, responseCode, "illegal token.");
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            return responseBuilder.build();
        }
        this.logger.info((Object)("deleteZoneIpWithMask : is Legal Token" + requestMsg));
        zoneNameInfo = null;
        try {
            if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
                response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
                return response;
            }
            zoneForm = null;
            zoneService = ZoneReferUtil.getZoneService();
            zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
            paramsMap = null;
            try {
                this.checkJson(zoneIpWithMaskJson);
                paramsMap = (Map)JSONUtil.getInstance().fromJSON(zoneIpWithMaskJson, new MyTypeReference<T>());
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("deleteZoneIpWithMask : delete zoneIp with mask error , json : " + json + " " + e.getMessage()));
                responseMsg = e.getMessage();
                responseCode = 400;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            catch (Exception e) {
                this.logger.error((Object)("deleteZoneIpWithMask : delete zoneIp with mask error , json : " + json + " " + e.getMessage()));
                responseMsg = "json format error.";
                responseCode = 400;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            isAdmin = "admin".equals(userName);
            if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2423L) && operationIds.contains(2202L) && operationIds.contains(2226L) && operationIds.contains(2223L))) {
                responseMsg = "current user can not delete zone ip with mask.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            v0 = zoneIpWithMask = null == paramsMap ? null : (String)paramsMap.get("zone_ip");
            if (null == zoneIpWithMask || zoneIpWithMask.trim().length() == 0 || !zoneIpWithMask.contains("/")) {
                this.logger.error((Object)("deleteZoneIpWithMask : delete zoneIp with mask error , zoneIp is null , zoneIpWithMask : " + zoneIpWithMask));
                responseMsg = "illegal parameter.";
                responseCode = 400;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            ipWithMask = zoneIpWithMask.split("/");
            zoneIp = ipWithMask[0];
            if (!IPUtil.isIpv4((String)zoneIp) && !IPUtil.isIpv6((String)zoneIp)) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            maskStr = ipWithMask[1];
            try {
                RestZoneServiceImpl.isNumeric(maskStr);
                mask = Integer.parseInt(maskStr);
                type = IPUtil.isIpv4((String)zoneIp) != false ? "ipv4" : "ipv6";
                RestZoneServiceImpl.checkMask(mask, type);
            }
            catch (Exception e) {
                this.logger.error((Object)("RestConstants.REQUEST_ERROR:" + e.getMessage()));
                responseCode = 400;
                responseMsg = e.getMessage();
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            iptemp = new ZoneIpForm();
            rangeIps = null;
            try {
                rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(maskStr));
            }
            catch (IllegalArgumentException e) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                this.logger.error((Object)("exception : " + e.getMessage()));
                return this.noOpeLogExit(logInfo);
            }
            catch (RuntimeException e) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                this.logger.error((Object)("exception : " + e.getMessage()));
                return this.noOpeLogExit(logInfo);
            }
            this.logger.info((Object)("deleteZoneIpWithMask : hhhhis Legal Token" + requestMsg));
            isIpv4 = IPUtil.isIpv4((String)zoneIp);
            iptemp.setZoneIp(zoneIp);
            iptemp.setMask(Integer.valueOf(Integer.parseInt(maskStr)));
            iptemp.setStartIp(rangeIps[0]);
            iptemp.setEndIp(rangeIps[1]);
            restIps = new ArrayList<String>();
            restIps.add(zoneIp + "/" + maskStr);
            oldZoneIpForm = null;
            existForms = zoneService.findExistIp(iptemp);
            this.logger.warn((Object)("deleteZoneIpWithMask : zoneService.findExistIp(zoneIpForm).existForms is " + existForms + "; " + requestMsg));
            if (null == existForms || existForms.isEmpty()) ** GOTO lbl288
            oldZoneIpForm = (ZoneIpForm)existForms.get(0);
            zoneId = oldZoneIpForm.getZoneId();
            this.logger.warn((Object)("deleteZoneIpWithMask : zoneService.findExistIp(zoneIpForm).existForms is exist zoneId: " + zoneId + "; " + requestMsg));
            zoneForm = zoneService.getZoneNOIpById(zoneId);
            if (null != zoneForm) {
                zoneIdList = new ArrayList<Long>();
                zoneIdList.add(zoneId);
                zoneNameInfo = zoneForm.getZoneName();
                if (!isAdmin) {
                    block41: {
                        moIdList = new ArrayList<E>();
                        moIdList.add(zoneForm.getMoId());
                        try {
                            userMgr = ZoneReferUtil.getUserMgr();
                            userId = userMgr.getUserInfoByName(userName).getId();
                            BisUtil.checkRestfulUserSecurity((List)moIdList, (long)userId, (boolean)isAdmin);
                        }
                        catch (LegoCheckedException e) {
                            if (630114L == e.getErrorCode()) {
                                responseCode = 455;
                                responseMsg = "The current user does not have the resources for this zone.";
                                logInfo.setResponseMsg(responseMsg);
                                logInfo.setResponseCode(responseCode);
                                return this.noOpeLogExit(logInfo);
                            }
                            if (570506L != e.getErrorCode()) break block41;
                            responseCode = 500;
                            responseMsg = "Unable to get the service published in the background.";
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            return this.noOpeLogExit(logInfo);
                        }
                    }
                    try {
                        this.checkDevicePermissionByUserName(userName, zoneIdList);
                    }
                    catch (LegoCheckedException e) {
                        return this.buildErrorResponse(logInfo, e);
                    }
                }
                moIdList = RestZoneServiceImpl.class;
                synchronized (RestZoneServiceImpl.class) {
                    zoneListIpSigForms = zoneService.findExistByIpMask(zoneIp, isIpv4, Integer.parseInt(maskStr));
                    if (null != zoneListIpSigForms && !zoneListIpSigForms.isEmpty()) {
                        zoneName = zoneForm.getZoneName();
                        if (VsmUtil.getInstance().isLockedZones(zoneIdList).booleanValue()) {
                            responseCode = 423;
                            responseMsg = String.format("Zone %s is Locked by other request.", new Object[]{zoneName});
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(String.valueOf(responseCode));
                            logInfo.setTarget(zoneName);
                            // ** MonitorExit[moIdList] (shouldn't be in output)
                            return this.logExitThird(logInfo);
                        }
                    } else {
                        responseCode = 404;
                        responseMsg = "zone ip address is not exist.";
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[moIdList] (shouldn't be in output)
                        return this.noOpeLogExit(logInfo);
                    }
                    zoneService.deleteZoneIpAndZoneIpList(oldZoneIpForm, zoneId.longValue(), zoneIp);
                    // ** MonitorExit[moIdList] (shouldn't be in output)
                    try {
                        zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("deleteZoneIp"), restIps);
                    }
                    catch (LegoCheckedException e) {
                        zoneService.saveOrUpdateZoneIpAndZoneIpList(oldZoneIpForm, zoneId.longValue(), zoneIp);
                        errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                        responseMsg = "deploy failed. zoneName is " + zoneForm.getZoneDesc() + "; zone_ip is :" + zoneIp + "; error message is : " + (String)errorMsg;
                        responseCode = 507;
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        logInfo.setTarget(zoneForm.getZoneName());
                        this.logger.error((Object)("exception : " + e.getMessage()));
                        return this.logExitThird(logInfo);
                    }
                    catch (Exception e) {
                        zoneService.saveOrUpdateZoneIpAndZoneIpList(oldZoneIpForm, zoneId.longValue(), zoneIp);
                        responseMsg = "ATIC inner error occurred while deploy zone. zoneName is " + zoneForm.getZoneDesc() + "; zone_ip is : " + zoneIp;
                        responseCode = 507;
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        logInfo.setTarget(zoneForm.getZoneName());
                        this.logger.error((Object)("exception : " + e.getMessage()));
                        return this.logExitThird(logInfo);
                    }
                    newDbZoneListIps = zoneService.getListIpByZoneId(zoneForm.getZoneId());
                    if (!newDbZoneListIps.isEmpty()) {
                        for (ZoneListIpForm zoneListIpForm : newDbZoneListIps) {
                            if (!restIps.contains(zoneListIpForm.getZoneIp())) continue;
                            this.logger.error((Object)("deleteZoneIpWithMask fail. zone_ip is : " + zoneIp + "-------"));
                            zoneService.saveOrUpdateZoneIpAndZoneIpList(oldZoneIpForm, zoneId.longValue(), zoneIp);
                            responseMsg = "deploy failed. zoneName is " + zoneForm.getZoneName() + "; zone_ip is :" + zoneIp;
                            responseCode = 507;
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(responseCode + "," + responseMsg);
                            logInfo.setTarget(zoneForm.getZoneName());
                            return this.logExitThird(logInfo);
                        }
                    }
                    if (!(divertTacticsForms = (divertTacticsService = ZoneReferUtil.getDivertForPolicyService()).getDivertTacticsByIp(iptemp.getStartIp(), iptemp.getEndIp())).isEmpty()) {
                        boList = new ArrayList<BatchOperation>();
                        for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                            bo = new BatchOperation();
                            bo.setTargetId(divertTacticsForm.getId().longValue());
                            bo.setTargetName("(" + divertTacticsForm.getDeviceName() + ", IP :" + zoneIp + ")");
                            boList.add(bo);
                        }
                        boResult = divertTacticsService.deleteDivertTactics(boList, true, userName, terminalIp + "(restful)");
                        if (boResult.getFailCount() > 0) {
                            responseCode = 500;
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed.");
                            detailPara[2] = responseCode + "";
                            params = new String[]{terminalIp, userName, "atic.bis.divert.tactics.operate.type.delete", zoneForm.getZoneName()};
                            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)false);
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)"delete Zone Ip succeed, but delete divert failed.");
                            responseObj = new HashMap<String, String>();
                            responseObj.put("errorCode", responseCode + "");
                            responseObj.put("errorMsg", "delete Zone Ip succeed ,but delete divert failed.");
                            try {
                                responseBuilder.entity((Object)JSONUtil.getInstance().toJSON(responseObj));
                            }
                            catch (IOException e) {
                                this.logger.error((Object)("logExitThird obj to json error obj : " + responseObj + " " + e.getMessage()));
                            }
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            return responseBuilder.build();
                        }
                        responseCode = 200;
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion succeed.");
                        detailPara[2] = responseCode + "";
                        params = new String[]{terminalIp, userName, "atic.bis.divert.tactics.operate.type.delete", zoneForm.getZoneName()};
                        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)false);
                    }
                }
            } else {
                responseCode = 500;
                responseMsg = "zoneForm is not exist.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
lbl288:
                // 1 sources

                responseCode = 404;
                responseMsg = "zone ip address is not existing.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            {
                this.logger.info((Object)("--------deleteZoneIpWithMask-------- end : " + System.currentTimeMillis()));
                responseCode = 200;
                responseMsg = "delete Zone Ip succeed.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                logInfo.setTarget(zoneForm.getZoneName());
                return this.logExitThird(logInfo);
            }
        }
        catch (RuntimeException e) {
            responseCode = 500;
            responseMsg = "deleteZoneIpWithMask failed.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            if (zoneNameInfo == null) {
                return this.noOpeLogExit(logInfo);
            }
            logInfo.setTarget(zoneNameInfo);
            this.logger.error((Object)("exception : " + e.getMessage()));
            return this.logExitThird(logInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @POST
    @Path(value="/zone_ip/move")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteAndAddZoneIpWithMask(String zoneNameIpJson) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone_ip/move");
        String requestMsg = "move zone ip. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String json = zoneNameIpJson;
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone_ip/move");
            requestMsg = "restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.move.zoneip");
        String apiName = "deleteAndAddZoneIpWithMask";
        logInfo.setApiName(apiName);
        logInfo.setTargetLocal(false);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            this.generateResponseJson(responseBuilder, responseCode, "illegal token.");
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            return responseBuilder.build();
        }
        this.logger.info((Object)("deleteAndAddZoneIpWithMask : is Legal Token" + requestMsg));
        String zoneNameInfo = null;
        try {
            String zoneNameRegexS;
            List operationIds;
            if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
                return this.handleOverAPInvokeLimit(logInfo, responseBuilder);
            }
            ZoneInfoForm sourceZoneForm = null;
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            Map paramsMap = null;
            try {
                this.checkJson(zoneNameIpJson);
                paramsMap = (Map)JSONUtil.getInstance().fromJSON(zoneNameIpJson, new MyTypeReference());
            }
            catch (Exception e) {
                this.logger.error((Object)("deleteAndAddZoneIpWithMask [json format error] , json : " + json + " " + e.getMessage()));
                responseMsg = "json format error";
                responseCode = 400;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            boolean isAdmin = "admin".equals(userName);
            if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2423L) && operationIds.contains(2202L) && operationIds.contains(2226L) && operationIds.contains(2223L))) {
                responseMsg = "current user can not transfer ip between zones.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            String zoneIpWithMask = null == paramsMap ? null : (String)paramsMap.get("zone_ip");
            String destZoneName = null == paramsMap ? "" : (String)paramsMap.get("zone_name");
            if (!destZoneName.matches(zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$") || destZoneName.length() > 32) {
                responseCode = 400;
                responseMsg = "illegal parameter, zone name is not correct.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            if (null == zoneIpWithMask || zoneIpWithMask.trim().length() == 0 || !zoneIpWithMask.contains("/")) {
                this.logger.error((Object)("deleteAndAddZoneIpWithMask , zoneIp is not correct , zoneIpWithMask : " + zoneIpWithMask));
                responseMsg = "illegal parameter, zone ip is not correct.";
                responseCode = 400;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                return this.noOpeLogExit(logInfo);
            }
            String[] ipWithMask = zoneIpWithMask.split("/");
            String zoneIp = ipWithMask[0];
            if (!IPUtil.isIpv4((String)zoneIp) && !IPUtil.isIpv6((String)zoneIp)) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            String maskStr = ipWithMask[1];
            try {
                RestZoneServiceImpl.isNumeric(maskStr);
                int mask = Integer.parseInt(maskStr);
                String type = IPUtil.isIpv4((String)zoneIp) ? "ipv4" : "ipv6";
                RestZoneServiceImpl.checkMask(mask, type);
            }
            catch (Exception e) {
                responseCode = 400;
                responseMsg = e.getMessage();
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                this.logger.error((Object)("Exception :" + e.getMessage()));
                return this.noOpeLogExit(logInfo);
            }
            ArrayList<String> restIps = new ArrayList<String>();
            ArrayList<String> restIps4Add = new ArrayList<String>();
            restIps.add(zoneIp);
            restIps4Add.add(zoneIpWithMask);
            ZoneIpForm zoneIptemp = new ZoneIpForm();
            String[] rangeIps = null;
            try {
                rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(maskStr));
            }
            catch (IllegalArgumentException e) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                this.logger.error((Object)("Exception : " + e.getMessage()));
                return this.noOpeLogExit(logInfo);
            }
            catch (RuntimeException e) {
                responseCode = 400;
                responseMsg = "illegal parameter.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                this.logger.error((Object)("Exception :" + e.getMessage()));
                return this.noOpeLogExit(logInfo);
            }
            boolean isIpv4 = IPUtil.isIpv4((String)zoneIp);
            zoneIptemp.setZoneIp(zoneIp);
            zoneIptemp.setMask(Integer.valueOf(Integer.parseInt(maskStr)));
            zoneIptemp.setStartIp(rangeIps[0]);
            zoneIptemp.setEndIp(rangeIps[1]);
            ZoneIpForm sourceZoneIpForm = null;
            List existForms = zoneService.findExistIp(zoneIptemp);
            this.logger.warn((Object)("deleteAndAddZoneIpWithMask : zoneService.findExistIp(zoneIpForm).existForms is " + existForms + "; " + requestMsg));
            if (null == existForms || existForms.isEmpty()) {
                responseCode = 404;
                responseMsg = "source zone ip address is not exist.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            sourceZoneIpForm = (ZoneIpForm)existForms.get(0);
            Long sourceZoneId = sourceZoneIpForm.getZoneId();
            this.logger.warn((Object)("deleteAndAddZoneIpWithMask : zoneService.findExistIp(zoneIpForm).existForms is exist zoneId: " + sourceZoneId + "; " + requestMsg));
            sourceZoneForm = zoneService.getZoneNOIpById(sourceZoneId);
            if (null == sourceZoneForm) {
                responseCode = 404;
                responseMsg = "source zone is not exist.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            if (sourceZoneForm.getZoneName().equals(destZoneName)) {
                responseCode = 423;
                responseMsg = String.format("source zone is as same as destination zone, source zone: %s, destination zone: %s", sourceZoneForm.getZoneName(), destZoneName);
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                return this.noOpeLogExit(logInfo);
            }
            ArrayList<Long> sourceZoneIdList = new ArrayList<Long>();
            sourceZoneIdList.add(sourceZoneId);
            try {
                this.checkDevicePermissionByUserName(userName, sourceZoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(logInfo, e);
            }
            Class<RestZoneServiceImpl> clazz = RestZoneServiceImpl.class;
            synchronized (RestZoneServiceImpl.class) {
                ArrayList<Long> destZoneIdList;
                ZoneInfoForm destZoneForm;
                ZoneListIpForm destZoneListIpForm;
                ZoneIpForm destZoneIpForm;
                String sourceZoneName;
                block65: {
                    List zoneListIpSigForms = zoneService.findExistByIpMask(zoneIp, isIpv4, Integer.parseInt(maskStr));
                    if (null == zoneListIpSigForms || zoneListIpSigForms.isEmpty()) {
                        responseCode = 404;
                        responseMsg = "source zone ip address is not exist.";
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return this.noOpeLogExit(logInfo);
                    }
                    sourceZoneName = sourceZoneForm.getZoneName();
                    if (VsmUtil.getInstance().isLockedZones(sourceZoneIdList).booleanValue()) {
                        responseCode = 423;
                        responseMsg = String.format("source Zone %s is Locked by other request.", sourceZoneName);
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return this.noOpeLogExit(logInfo);
                    }
                    zoneService = ZoneReferUtil.getZoneService();
                    destZoneIpForm = sourceZoneIpForm;
                    destZoneListIpForm = new ZoneListIpForm();
                    destZoneListIpForm.setEndIp(zoneIptemp.getEndIp());
                    destZoneListIpForm.setStartIp(zoneIptemp.getStartIp());
                    destZoneListIpForm.setIntMask(zoneIptemp.getMask().intValue());
                    destZoneListIpForm.setIpType(0);
                    destZoneListIpForm.setMaskType(0);
                    destZoneListIpForm.setZoneIp(zoneIptemp.getZoneIp());
                    destZoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                    destZoneForm = zoneService.getCustomZoneByName(destZoneName);
                    destZoneIdList = new ArrayList<Long>();
                    if (null == destZoneForm) {
                        responseCode = 404;
                        responseMsg = "destination zone is not exist.";
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return this.noOpeLogExit(logInfo);
                    }
                    zoneNameInfo = destZoneName;
                    if (!isAdmin) {
                        ArrayList<Long> moIdList = new ArrayList<Long>();
                        moIdList.add(sourceZoneForm.getMoId());
                        moIdList.add(destZoneForm.getMoId());
                        try {
                            IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                            long userId = userMgr.getUserInfoByName(userName).getId();
                            BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                        }
                        catch (LegoCheckedException e) {
                            if (630114L == e.getErrorCode()) {
                                responseCode = 455;
                                responseMsg = "The current user does not have the resources for this zone.";
                                logInfo.setResponseMsg(responseMsg);
                                logInfo.setResponseCode(responseCode);
                                logInfo.setResponseDetail(String.valueOf(responseCode));
                                // ** MonitorExit[var34_42] (shouldn't be in output)
                                return this.noOpeLogExit(logInfo);
                            }
                            if (570506L != e.getErrorCode()) break block65;
                            responseCode = 500;
                            responseMsg = "Unable to get the service published in the background.";
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(String.valueOf(responseCode));
                            // ** MonitorExit[var34_42] (shouldn't be in output)
                            return this.noOpeLogExit(logInfo);
                        }
                    }
                }
                destZoneIdList.add(destZoneForm.getZoneId());
                IZoneDeviceService zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
                List sourceZoneDevicelist = zoneDeviceService.queryZoneDeviceFormsByZoneID(sourceZoneForm.getZoneId());
                if (null == sourceZoneDevicelist || sourceZoneDevicelist.size() == 0) {
                    responseCode = 404;
                    responseMsg = "can't find device for source zone";
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(String.valueOf(responseCode));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.noOpeLogExit(logInfo);
                }
                AticDeviceServiceImpl aticDeviceService = (AticDeviceServiceImpl)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
                for (Object deviceForm : sourceZoneDevicelist) {
                    TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                    AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                    if (null == aticDevice || null == telnetPara) {
                        responseCode = 404;
                        responseMsg = String.format("source zone's device is not exist!", new Object[0]);
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return this.noOpeLogExit(logInfo);
                    }
                    if (8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
                    ExcmdConnectUtil excmdConnectUtil = null;
                    try {
                        excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                        List result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, Collections.singletonList("display ddos-zone " + sourceZoneName), (boolean)true);
                        for (Object string : result) {
                            if (null != string && !((String)string).contains("Error")) continue;
                            responseCode = 404;
                            responseMsg = String.format("source zone is not deployed on device %s", aticDevice.getName());
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(String.valueOf(responseCode));
                            logInfo.setTarget(destZoneName);
                            Response response = this.logExitThird(logInfo);
                            // ** MonitorExit[var34_42] (shouldn't be in output)
                            return response;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("deleteAndAddZoneIpWithMask : " + String.format("source zone is not deployed on device %s", aticDevice.getName()) + " " + e.getMessage()));
                        responseCode = 404;
                        responseMsg = String.format("source zone is not deployed on device %s", aticDevice.getName());
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        logInfo.setTarget(destZoneName);
                        this.logger.error((Object)("Exception :" + e.getMessage()));
                        Response response = this.logExitThird(logInfo);
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return response;
                    }
                    finally {
                        ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
                    }
                }
                List list = zoneDeviceService.queryZoneDeviceFormsByZoneID(destZoneForm.getZoneId());
                if (null == list || list.size() == 0) {
                    responseCode = 404;
                    responseMsg = "can't find device for destination zone";
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(String.valueOf(responseCode));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.noOpeLogExit(logInfo);
                }
                for (ZoneDeviceForm deviceForm : list) {
                    TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                    AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                    if (null == aticDevice || null == telnetPara) {
                        responseCode = 404;
                        responseMsg = String.format("destination zone's device is not exist!", new Object[0]);
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return this.noOpeLogExit(logInfo);
                    }
                    if (8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
                    ExcmdConnectUtil excmdConnectUtil = null;
                    try {
                        excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                        List result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, Collections.singletonList("display ddos-zone " + destZoneName), (boolean)true);
                        for (String string : result) {
                            if (null != string && !string.contains("Error")) continue;
                            responseCode = 404;
                            responseMsg = String.format("destination zone is not deployed on device %s", aticDevice.getName());
                            logInfo.setResponseMsg(responseMsg);
                            logInfo.setResponseCode(responseCode);
                            logInfo.setResponseDetail(String.valueOf(responseCode));
                            logInfo.setTarget(destZoneName);
                            Response response = this.logExitThird(logInfo);
                            // ** MonitorExit[var34_42] (shouldn't be in output)
                            return response;
                        }
                    }
                    catch (Exception e) {
                        Object string;
                        this.logger.error((Object)("deleteAndAddZoneIpWithMask : " + String.format("destination zone is not deployed on device %s", aticDevice.getName()) + " " + e.getMessage()));
                        responseCode = 404;
                        responseMsg = String.format("destination zone is not deployed on device %s", aticDevice.getName());
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(String.valueOf(responseCode));
                        logInfo.setTarget(destZoneName);
                        string = this.logExitThird(logInfo);
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return string;
                    }
                    finally {
                        ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
                    }
                }
                if (VsmUtil.getInstance().isLockedZones(destZoneIdList).booleanValue()) {
                    responseCode = 423;
                    responseMsg = String.format("destination zone %s is Locked by other request.", destZoneName);
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(String.valueOf(responseCode));
                    logInfo.setTarget(destZoneName);
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.logExitThird(logInfo);
                }
                this.logger.info((Object)("--------deleteAndAddZoneIpWithMask-------- start [ip= " + zoneIptemp.getZoneIp() + " ] : " + System.currentTimeMillis()));
                zoneService.deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                try {
                    this.move(sourceZoneDevicelist, sourceZoneName, list, destZoneName, zoneIptemp, isIpv4);
                }
                catch (LegoCheckedException e) {
                    zoneService.updateSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                    responseMsg = "move ip deploy failed." + errorMsg;
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    logInfo.setTarget(destZoneName);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.logExitThird(logInfo);
                }
                this.logger.info((Object)("--------deleteAndAddZoneIpWithMask-------- middle [ip= " + zoneIptemp.getZoneIp() + " ] : " + System.currentTimeMillis()));
                IZonePolicyMgrService zonePolicyMgrSer = ZoneReferUtil.getZonePolicyMgrService();
                try {
                    zonePolicyMgrSer.deployInRest(sourceZoneIdList, this.initFeatures("deleteZoneIp"), restIps);
                }
                catch (LegoCheckedException e) {
                    zoneService.updateSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    this.remove(list, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    this.back(sourceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                    responseMsg = "source zone delete ip : deploy failed. zoneName is " + sourceZoneForm.getZoneDesc() + "; zone_ip is :" + zoneIp + "; error message is : " + (String)errorMsg;
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    logInfo.setTarget(destZoneName);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.logExitThird(logInfo);
                }
                catch (Exception e) {
                    zoneService.updateSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    this.remove(list, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    this.back(sourceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    responseMsg = "ATIC inner error occurred while deploy source zone delete ip : . zoneName is " + sourceZoneForm.getZoneDesc() + "; zone_ip is : " + zoneIp;
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    logInfo.setTarget(destZoneName);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.logExitThird(logInfo);
                }
                List newDbZoneListIps = zoneService.getListIpByZoneId(sourceZoneForm.getZoneId());
                if (!newDbZoneListIps.isEmpty()) {
                    for (ZoneListIpForm newZoneListIpForm : newDbZoneListIps) {
                        if (!restIps.contains(newZoneListIpForm.getZoneIp()) || newZoneListIpForm.getDeleteFlag() != 0) continue;
                        this.logger.error((Object)("deleteZoneIpWithMask fail. zone_ip is : " + zoneIp + "-------"));
                        zoneService.saveOrUpdateSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                        this.remove(list, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                        this.back(sourceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                        zonePolicyMgrSer.deployInRest(sourceZoneIdList, this.initFeatures("addZoneIp"), restIps4Add);
                        responseMsg = "deploy failed. zoneName is " + sourceZoneForm.getZoneName() + "; zone_ip is :" + zoneIp;
                        responseCode = 507;
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        logInfo.setTarget(destZoneName);
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return this.logExitThird(logInfo);
                    }
                }
                try {
                    zonePolicyMgrSer.deployInRest(destZoneIdList, this.initFeatures("addZoneIp"), restIps4Add);
                }
                catch (LegoCheckedException e) {
                    zoneService.saveOrUpdateSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    this.remove(list, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    this.back(sourceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    zonePolicyMgrSer.deployInRest(sourceZoneIdList, this.initFeatures("addZoneIp"), restIps4Add);
                    String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                    responseMsg = "move zone ip error while depoly destination zone ip failed. zoneName is " + destZoneForm.getZoneName() + "; error message is : " + errorMsg;
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    logInfo.setTarget(destZoneName);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.logExitThird(logInfo);
                }
                catch (Exception e) {
                    zoneService.saveOrUpdateSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    this.remove(list, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    this.back(sourceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                    zonePolicyMgrSer.deployInRest(sourceZoneIdList, this.initFeatures("addZoneIp"), restIps4Add);
                    responseMsg = "ATIC inner error occurred while deploy zone. zoneName is " + destZoneForm.getZoneName();
                    responseCode = 507;
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    logInfo.setResponseDetail(responseCode + "," + responseMsg);
                    logInfo.setTarget(destZoneName);
                    this.logger.error((Object)("Exception :" + e.getMessage()));
                    // ** MonitorExit[var34_42] (shouldn't be in output)
                    return this.logExitThird(logInfo);
                }
                this.logger.info((Object)("--------deleteAndAddZoneIpWithMask-------- enddd [ip= " + zoneIptemp.getZoneIp() + " ] : " + System.currentTimeMillis()));
                IDivertForPolicy divertTacticsService = ZoneReferUtil.getDivertForPolicyService();
                List divertTacticsForms = divertTacticsService.getDivertTacticsByIp(zoneIptemp.getStartIp(), zoneIptemp.getEndIp());
                if (!divertTacticsForms.isEmpty()) {
                    String[] params;
                    ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
                    for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                        BatchOperation bo = new BatchOperation();
                        bo.setTargetId(divertTacticsForm.getId().longValue());
                        bo.setTargetName("(" + divertTacticsForm.getDeviceName() + ", IP :" + zoneIp + ")");
                        boList.add(bo);
                    }
                    BatchOperationResult boResult = divertTacticsService.deleteDivertTactics(boList, true, userName, terminalIp + "(restful)");
                    if (boResult.getFailCount() > 0) {
                        responseCode = 500;
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteAndAddZoneIpWithMask : delete diversion task failed.");
                        detailPara[2] = responseCode + "";
                        params = new String[]{terminalIp, userName, "atic.bis.divert.tactics.operate.type.delete", sourceZoneName};
                        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
                        responseBuilder = responseBuilder.status(responseCode);
                        this.generateResponseJson(responseBuilder, responseCode, "move ip succeed, but delete source zone ip divert failed.");
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        // ** MonitorExit[var34_42] (shouldn't be in output)
                        return responseBuilder.build();
                    }
                    responseCode = 200;
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteAndAddZoneIpWithMask : delete diversion succeed.");
                    detailPara[2] = responseCode + "";
                    params = new String[]{terminalIp, userName, "atic.bis.divert.tactics.operate.type.delete", sourceZoneName};
                    RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
                }
                this.logger.info((Object)("--------deleteAndAddZoneIpWithMask-------- end [ip= " + zoneIptemp.getZoneIp() + " ] : " + System.currentTimeMillis()));
                responseCode = 200;
                responseMsg = "move zone ip succeed.";
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(String.valueOf(responseCode));
                logInfo.setTarget(destZoneName);
                // ** MonitorExit[var34_42] (shouldn't be in output)
                return this.logExitThird(logInfo);
            }
        }
        catch (RuntimeException e) {
            responseCode = 500;
            responseMsg = "move zone ip failed.";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            if (zoneNameInfo == null) {
                return this.noOpeLogExit(logInfo);
            }
            logInfo.setTarget(zoneNameInfo);
            this.logger.error((Object)("exception : " + e.getMessage()));
            return this.logExitThird(logInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void back(List<ZoneDeviceForm> srouceZoneDevicelist, String sourceZoneName, ZoneIpForm zoneIptemp, AticDeviceServiceImpl aticDeviceService, boolean isIpv4) {
        String cmdUndo = isIpv4 ? "undo ip address " : "undo ipv6 address ";
        String cmdDo = isIpv4 ? "ip address " : "ipv6 address ";
        for (ZoneDeviceForm deviceForm : srouceZoneDevicelist) {
            TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
            AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
            if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
            ExcmdConnectUtil excmdConnectUtil = null;
            try {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                ArrayList<String> cmdSys = new ArrayList<String>();
                cmdSys.add("sys");
                cmdSys.add("ddos-zone name " + sourceZoneName);
                ArrayList<String> cmdIp = new ArrayList<String>();
                cmdIp.add(cmdUndo + zoneIptemp.getStartIp() + " " + zoneIptemp.getMask());
                cmdIp.add(cmdDo + zoneIptemp.getStartIp() + " " + zoneIptemp.getMask());
                List resultList = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                this.logger.info((Object)("info : back move source action error, zone name :" + resultList.toString()));
                resultList = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                this.logger.info((Object)("info : back move source action error, zone name :" + resultList.toString()));
                Boolean flag = VsmUtil.getInstance().checkCmdResult(resultList);
                if (flag.booleanValue()) continue;
                this.logger.error((Object)("err : back move source action error, zone name :" + AticUtil.getcleanedMessage((String)sourceZoneName) + " zone ip :" + zoneIptemp.getStartIp()));
                this.logger.error((Object)("err : back move source action error, zone name :" + resultList.toString()));
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("back move source action error, zone name :" + AticUtil.getcleanedMessage((String)sourceZoneName) + " zone ip :" + zoneIptemp.getStartIp() + " " + e.getMessage()));
            }
            finally {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(List<ZoneDeviceForm> destZoneDevicelist, String destZoneName, ZoneIpForm zoneIptemp, AticDeviceServiceImpl aticDeviceService, boolean isIpv4) {
        String cmdUndo = isIpv4 ? "undo ip address " : "undo ipv6 address ";
        for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
            TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
            AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
            if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
            ExcmdConnectUtil excmdConnectUtil = null;
            try {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                ArrayList<String> cmdSys = new ArrayList<String>();
                cmdSys.add("sys");
                cmdSys.add("ddos-zone name " + destZoneName);
                ArrayList<String> cmdIp = new ArrayList<String>();
                cmdIp.add(cmdUndo + zoneIptemp.getStartIp() + " " + zoneIptemp.getMask());
                List resultList = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                this.logger.info((Object)("info : back move destination action error, zone name :" + resultList.toString()));
                resultList = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                this.logger.info((Object)("info : back move destination action error, zone name :" + resultList.toString()));
                Boolean flag = VsmUtil.getInstance().checkCmdResult(resultList);
                if (flag.booleanValue()) continue;
                this.logger.error((Object)("err : back move destination action error, zone name :" + AticUtil.getcleanedMessage((String)destZoneName) + " zone ip :" + zoneIptemp.getStartIp()));
                this.logger.error((Object)("err : back move destination action error, zone name :" + resultList.toString()));
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("err : back move destination action error, zone name :" + AticUtil.getcleanedMessage((String)destZoneName) + " zone ip :" + zoneIptemp.getStartIp() + " " + e.getMessage()));
            }
            finally {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
            }
        }
    }

    private void move(List<ZoneDeviceForm> srouceZoneDevicelist, String sourceZoneName, List<ZoneDeviceForm> destZoneDevicelist, String destZoneName, ZoneIpForm zoneIptemp, boolean isIpv4) {
        Boolean flag;
        List result;
        ArrayList<String> cmdIp;
        ArrayList<String> cmdSys;
        ExcmdConnectUtil excmdConnectUtil;
        AticDevice aticDevice;
        TelnetPara telnetPara;
        String cmdUndo = isIpv4 ? "undo ip address " : "undo ipv6 address ";
        String cmdDo = isIpv4 ? "ip address " : "ipv6 address ";
        AticDeviceServiceImpl aticDeviceService = (AticDeviceServiceImpl)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
        for (ZoneDeviceForm deviceForm : srouceZoneDevicelist) {
            telnetPara = aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
            aticDevice = aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
            if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
            excmdConnectUtil = null;
            try {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                cmdSys = new ArrayList<String>();
                cmdSys.add("sys");
                cmdSys.add("ddos-zone name " + sourceZoneName);
                cmdIp = new ArrayList<String>();
                cmdIp.add(cmdUndo + zoneIptemp.getStartIp() + " " + zoneIptemp.getMask());
                result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                flag = VsmUtil.getInstance().checkCmdResult(result);
                if (flag.booleanValue()) continue;
                this.logger.error((Object)("err : move source action error, zone name :" + AticUtil.getcleanedMessage((String)sourceZoneName) + " zone ip :" + zoneIptemp.getStartIp()));
                this.back(srouceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                throw new LegoCheckedException(630005L);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("move source action error, zone name :" + AticUtil.getcleanedMessage((String)sourceZoneName) + " zone ip :" + zoneIptemp.getStartIp() + " " + e.getMessage()));
                this.back(srouceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                throw new LegoCheckedException(e.getErrorCode());
            }
            finally {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
            }
        }
        for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
            telnetPara = aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
            aticDevice = aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
            if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
            excmdConnectUtil = null;
            try {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                cmdSys = new ArrayList();
                cmdSys.add("sys");
                cmdSys.add("ddos-zone name " + destZoneName);
                cmdIp = new ArrayList();
                cmdIp.add(cmdUndo + zoneIptemp.getStartIp() + " " + zoneIptemp.getMask());
                cmdIp.add(cmdDo + zoneIptemp.getStartIp() + " " + zoneIptemp.getMask());
                result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                flag = VsmUtil.getInstance().checkCmdResult(result);
                if (flag.booleanValue()) continue;
                this.logger.error((Object)("err : move destination action error, zone name :" + AticUtil.getcleanedMessage((String)destZoneName) + " zone ip :" + zoneIptemp.getStartIp()));
                this.remove(destZoneDevicelist, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                this.back(srouceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                throw new LegoCheckedException(630005L);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("move destination action error, zone name :" + AticUtil.getcleanedMessage((String)destZoneName) + " zone ip :" + zoneIptemp.getStartIp() + " " + e.getMessage()));
                this.remove(destZoneDevicelist, destZoneName, zoneIptemp, aticDeviceService, isIpv4);
                this.back(srouceZoneDevicelist, sourceZoneName, zoneIptemp, aticDeviceService, isIpv4);
                throw new LegoCheckedException(e.getErrorCode());
            }
            finally {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
            }
        }
    }

    private void generateResponseJson(Response.ResponseBuilder responseBuilder, int responseCode, String responseMsg) {
        HashMap<String, String> responseObj = new HashMap<String, String>();
        responseObj.put("errorCode", responseCode + "");
        responseObj.put("errorMsg", responseMsg);
        try {
            responseBuilder.entity((Object)JSONUtil.getInstance().toJSON(responseObj));
        }
        catch (IOException e) {
            this.logger.error((Object)("logExitThird obj to json error obj : " + responseObj + " " + e.getMessage()));
        }
    }

    private static void checkMask(int subnetmask, String type) {
        String numReg = "([0-9]\\d*)";
        Matcher m = Pattern.compile("([0-9]\\d*)").matcher(String.valueOf(subnetmask));
        if (m.matches()) {
            if ("ipv4".equals(type) && (subnetmask > 32 || subnetmask < 0)) {
                throw new IllegalArgumentException("the subnetmask of ipv4 is must smaller than 32 and bigger than 0.");
            }
            if ("ipv6".equals(type) && (subnetmask > 128 || subnetmask < 0)) {
                throw new IllegalArgumentException("the subnetmask of ipv6 is must smaller than 128 and bigger than 0.");
            }
        } else {
            throw new IllegalArgumentException("the subnetmask of ip is must number type.");
        }
    }

    @Override
    @GET
    @Path(value="/zone/location")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryAllLocationPolicy() {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone/location");
        String requestMsg = "query all zone's location policy. restful request is null.";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone/location");
            requestMsg = "restful request url : " + url + ".";
        }
        int responseCode = 500;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
            String responseMsg = "current user can not query all location policy.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        List zoneInfoForms = zoneService.getAll(Long.valueOf(userId), Boolean.valueOf(isAdmin));
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        for (ZoneInfoForm zoneInfo : zoneInfoForms) {
            zoneIdList.add(zoneInfo.getZoneId());
        }
        try {
            this.checkDevicePermissionByUserName(userName, zoneIdList);
        }
        catch (LegoCheckedException e) {
            return this.buildErrorResponse(responseBuilder, requestMsg, e);
        }
        IZoneIpLocationService zoneIpLocationService = (IZoneIpLocationService)ServiceContext.getInstance().getService("zoneIpLocationService", IZoneIpLocationService.class);
        List allIpLocation = zoneIpLocationService.getAll();
        IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
        List allStatus = zoneDeviceDeployStatusService.getAllStatus();
        String json = null;
        try {
            json = this.assemblyAllLocationPolicyJson(zoneInfoForms, allIpLocation, allStatus);
        }
        catch (IOException e) {
            String responseMsg = "json format error";
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            this.logger.error((Object)"json format error ");
            return responseBuilder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"");
        responseBuilder = responseBuilder.status(responseCode);
        responseBuilder.entity((Object)json);
        return responseBuilder.build();
    }

    private String assemblyAllLocationPolicyJson(List<ZoneInfoForm> zones, List<ZoneIpLocationForm> locations, List<ZoneDeviceDeployStatusForm> statuses) throws IOException {
        ZoneLocationInfos infos = new ZoneLocationInfos();
        IpLocationInfo locationInfo = null;
        ZoneLocationInfo info = null;
        ArrayList<IpLocationInfo> locationList = null;
        ArrayList<ZoneLocationInfo> zoneLocationInfoList = new ArrayList<ZoneLocationInfo>();
        IZonePolicyApplyService service = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        for (ZoneInfoForm zone : zones) {
            info = new ZoneLocationInfo();
            locationList = new ArrayList<IpLocationInfo>();
            List zoneModifyDetail = service.getZoneModifyDetail(zone.getZoneId());
            boolean partSuccess = false;
            if (null != zoneModifyDetail) {
                for (ZoneModifyDetailForm zoneModifyDetailForm : zoneModifyDetail) {
                    if (!"com.hs.vsm.secservice.ddos.policy.zonepolicy.zoneiplocation.info.changed".equals(zoneModifyDetailForm.getModifyDetail())) continue;
                    partSuccess = true;
                    break;
                }
            }
            info.setDeployStatus("failure");
            if (!partSuccess && null != statuses && !statuses.isEmpty()) {
                info.setDeployStatus("success");
                for (ZoneDeviceDeployStatusForm status : statuses) {
                    if (!zone.getZoneId().equals(status.getZoneId()) || status.getDeployType() != 1 || "lego.err.631045".equalsIgnoreCase(status.getErrorMsgKey()) || !"lego.err.630005".equalsIgnoreCase(status.getErrorMsgKey())) continue;
                    info.setDeployStatus("failure");
                    break;
                }
            }
            for (ZoneIpLocationForm location : locations) {
                if (zone.getZoneId().longValue() != location.getZoneId()) continue;
                locationInfo = new IpLocationInfo();
                String state = "pass";
                if (location.getLocationAction() == 3) {
                    state = "limit";
                    locationInfo.setThreshold(location.getLocationLimit().toString());
                } else if (location.getLocationAction() == 2) {
                    state = "block";
                }
                if ("OtherLocation".equals(location.getLocationNameEn())) {
                    locationInfo.setDeployLocation("other");
                } else {
                    locationInfo.setDeployLocation(location.getLocationNameEn());
                }
                locationInfo.setBolckState(state);
                locationList.add(locationInfo);
            }
            info.setZoneAccount(zone.getZoneName());
            info.setZones(locationList);
            zoneLocationInfoList.add(info);
        }
        infos.setTotal(zones.size());
        infos.setZones(zoneLocationInfoList);
        String json = JSONUtil.getInstance().toJSON((Object)infos);
        return json;
    }

    @Override
    @GET
    @Path(value="/zone/udpblock/{zone_name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryZoneUDPBlockStatue(@PathParam(value="zone_name") String zoneName) {
        List operationIds;
        RestLogInfo logInfo = new RestLogInfo();
        logInfo.setApiName("/udpblock/{zone_name}");
        String responseMsg = "";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)("ddos/zone/" + logInfo.getApiName()));
        Response response = this.checkTokenAndConcurrent(request, userName, zoneName, logInfo, "atic.restful.query.zonebyaccount");
        if (null != response) {
            return response;
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
            responseMsg = "current user can not query zone udp block statue";
            int responseCode = 455;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        int responseCode = 500;
        CommonResult<ZoneInfoForm> commonResult = this.checkZoneAccount(zoneName);
        if (200 != commonResult.getCode()) {
            this.logger.error((Object)("query zone UDPBlock statue:" + commonResult.getMessage()));
            responseMsg = commonResult.getMessage();
            responseCode = commonResult.getCode();
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        ZoneInfoForm zoneInfoForm = (ZoneInfoForm)commonResult.getContent();
        if (!isAdmin) {
            block15: {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneInfoForm.getMoId());
                try {
                    IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                    long userId = userMgr.getUserInfoByName(userName).getId();
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        return this.noOpeLogInfoExit(logInfo, null);
                    }
                    if (570506L != e.getErrorCode()) break block15;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    return this.noOpeLogInfoExit(logInfo, null);
                }
            }
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            zoneIdList.add(zoneInfoForm.getZoneId());
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(logInfo, e);
            }
        }
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        List listResult = zonePolicyMgrService.queryAllDeployResultByZoneId(zoneInfoForm.getZoneId());
        Map<String, String> map = this.deployStatus(listResult, zoneName);
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        RestUdpPolicyInfo info = new RestUdpPolicyInfo();
        info.setZoneAccount(zoneName);
        info.setDetail("");
        if ("0".equals(map.get("flag"))) {
            result.setMessage("success!");
            CommonResult<List<String>> commonResult2 = this.checkUdpBlock(zoneInfoForm, map);
            if (null == commonResult2) {
                result.setMessage("zone not deployment or deployment error");
                info.setDetail("zone not deployment or deployment error ");
                info.setUdpBlock("anomaly");
            } else if ("other".equals(commonResult2.getMessage())) {
                result.setMessage(commonResult2.getMessage());
                List unblockList = (List)commonResult2.getContent();
                info.setDetail("unblock device Ip is " + unblockList.toString());
                info.setUdpBlock(commonResult2.getMessage());
            } else {
                result.setMessage(commonResult2.getMessage());
                info.setUdpBlock(commonResult2.getMessage());
            }
        } else {
            result.setMessage(map.get("responseMsg"));
            info.setDetail(zoneName + ":" + map.get("responseMsg"));
            info.setUdpBlock("anomaly");
        }
        this.logger.info((Object)("query zone UDPBlock statue: " + result.getMessage()));
        responseCode = result.getCode();
        responseMsg = result.getMessage();
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        String json = JSONUtil.getInstance().toJSONString((Object)info);
        return this.noOpeLogInfoExit(logInfo, json);
    }

    private Response checkTokenAndConcurrent(HttpServletRequest request, String userName, String param, RestLogInfo logInfo, String operation) {
        String requestMsg = logInfo.getApiName() + ". restful request is null. incoming entry is :" + param + ". ";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = "/udpblock/{zone_name}".equals(logInfo.getApiName()) ? RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone/udpblock/" + param)) : RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone/" + logInfo.getApiName()));
            requestMsg = "restful request url : " + url;
            terminalIp = request.getRemoteAddr();
        }
        logInfo.setUrl(url);
        logInfo.setJson(param);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation(operation);
        if (null == userName) {
            int responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            this.logger.error((Object)(logInfo.getApiName() + " illegal token. clientIp: " + terminalIp + "; incoming entry is :" + param));
            String resultJson = "{\"detail\": \"illegal token.\"}";
            Response.ResponseBuilder responseBuilder = Response.ok((Object)resultJson);
            responseBuilder = responseBuilder.status(412);
            return responseBuilder.build();
        }
        this.logger.info((Object)(logInfo.getApiName() + " clientIp: " + terminalIp + "; isLegalToken :" + userName + " ; requestMsg : " + requestMsg));
        logInfo.setApiName(logInfo.getApiName());
        if (!VsmUtil.getInstance().acquireApiInvoke(logInfo.getApiName()).booleanValue()) {
            Response response = this.handleOverAPInvokeLimitReturnInfo(logInfo);
            return response;
        }
        return null;
    }

    private CommonResult<ZoneInfoForm> checkZoneAccount(String zoneAccount) {
        CommonResult result = new CommonResult();
        result.setCode(200);
        ZoneInfoForm zoneForm = null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        String zoneNameRegexS = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (null == zoneAccount || zoneAccount.trim().isEmpty()) {
            result.setCode(400);
            result.setMessage("zone_account is null or empty!");
            return result;
        }
        if (!zoneAccount.matches(zoneNameRegexS)) {
            result.setCode(404);
            result.setMessage("zone_account:[" + zoneAccount + "] format is error!");
            return result;
        }
        if (zoneAccount.length() > 32) {
            result.setCode(404);
            result.setMessage("Account length exceeds 32 !");
            return result;
        }
        zoneForm = zoneService.getZoneByName(zoneAccount);
        if (null == zoneForm) {
            result.setCode(404);
            result.setMessage("zone_account:[" + zoneAccount + "] not exist!");
            return result;
        }
        if (!ZoneConstants.ZONE_TYPE_CUSTOME.equals(zoneForm.getZoneType())) {
            result.setCode(406);
            result.setMessage("zone_account:[" + zoneAccount + "] type is error!");
            return result;
        }
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        if (0 >= defaultServices.size()) {
            result.setCode(404);
            result.setMessage("zone_account:[" + zoneAccount + "] not include default service binding ddos device!");
            return result;
        }
        result.setContent((Object)zoneForm);
        return result;
    }

    private Map<String, String> deployStatus(List<ZoneDeviceDeployStatusForm> listResult, String zoneAccount) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        StringBuilder resopnseM = new StringBuilder();
        boolean flag = true;
        String responseMsg = "";
        int ddosFalse = 0;
        int ddosSuccess = 0;
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        try {
            for (ZoneDeviceDeployStatusForm form : listResult) {
                Long deviceId = form.getDeviceId();
                AticDevice device = aticDeviceService.getDeviceByMoid(deviceId.longValue());
                if (1 != device.getDeviceType()) continue;
                map.put(String.valueOf(deviceId), device.getIpAddress());
                if (!form.getDeployState().booleanValue()) {
                    String errorMsgKey = form.getErrorMsgKey();
                    if (this.isInvalidErrorMsgKey(errorMsgKey)) continue;
                    String errorMsg = AticUtil.getText((String)errorMsgKey, (Locale)new Locale("en"));
                    String errorParam = form.getErrorParam();
                    errorMsg = errorMsg.replaceFirst("\\$0", errorParam == null ? "" : errorParam);
                    resopnseM.append("updateZoneUDPPolicy. deploy failed. zoneAccount is ").append(zoneAccount).append("; error message is : ").append(errorMsg);
                    this.logger.error((Object)resopnseM.toString());
                    resopnseM.append("; device ip : ").append(device.getIpAddress());
                    if (1 == form.getDeployType()) {
                        ++ddosFalse;
                    }
                    flag = false;
                    continue;
                }
                if (1 != form.getDeployType()) continue;
                ++ddosSuccess;
            }
        }
        catch (LegoCheckedException e) {
            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            responseMsg = "updateZoneUDPPolicy. happened exception, error message is : " + errorMsg;
            this.logger.error((Object)(responseMsg + " " + e.getMessage()));
            flag = false;
        }
        catch (Exception e) {
            this.logger.error((Object)("updateZoneUDPPolicy. happened exception. zoneAccount is " + zoneAccount + ". " + e.getMessage()));
            flag = false;
        }
        if (flag && 0 == ddosFalse && ddosSuccess > 0) {
            map.put("flag", "0");
        } else if (!flag && 0 == ddosFalse && ddosSuccess > 0) {
            map.put("flag", "1");
        } else if (!flag && ddosFalse > 0 && ddosSuccess > 0) {
            map.put("flag", "2");
        } else if (!flag && ddosFalse > 0 && 0 == ddosSuccess) {
            map.put("flag", "3");
        }
        map.put("responseMsg", resopnseM.toString());
        if (0 == ddosFalse && 0 == ddosSuccess) {
            map.put("flag", "4");
            map.put("responseMsg", "The ddos zone deploy error  or zone is not deployed.");
        }
        return map;
    }

    private CommonResult<List<String>> checkUdpBlock(ZoneInfoForm zoneForm, Map<String, String> map) {
        CommonResult result = new CommonResult();
        IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        ArrayList<String> features = new ArrayList<String>();
        features.add(Constant.Feature.ServiceUdpDefendData.toString());
        UdpDefendPolicyForm udp = null;
        ZoneServiceForm zoneServiceForm = null;
        boolean error = true;
        if (!defaultServices.isEmpty()) {
            int num = defaultServices.size();
            ArrayList<String> list = new ArrayList<String>(num);
            for (int i = 0; i < num; ++i) {
                zoneServiceForm = serviceService.query(defaultServices.get(i).getPkid(), features);
                UdpDefendPolicyForm udpDefendPolicyForm = udp = null == zoneServiceForm ? null : zoneServiceForm.getUdpDefendPolicyForm();
                if (null == udp) {
                    error = false;
                    break;
                }
                if (null != udp.getUdpBlock() && udp.getUdpBlock().booleanValue()) continue;
                if (null == map.get(String.valueOf(zoneServiceForm.getDeviceId()))) {
                    error = false;
                    break;
                }
                list.add(map.get(String.valueOf(zoneServiceForm.getDeviceId())));
            }
            if (error) {
                if (num == list.size()) {
                    result.setMessage("unblock");
                } else if (list.size() > 0) {
                    result.setMessage("other");
                    result.setContent(list);
                } else if (0 == list.size()) {
                    result.setMessage("block");
                }
                return result;
            }
        }
        return null;
    }

    private Response logExitReturnInfo(RestLogInfo logInfo, String json) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        String[] params = new String[]{logInfo.getTerminalIp(), logInfo.getUserName(), logInfo.getOperation(), logInfo.getTarget()};
        String[] detailPara = new String[]{logInfo.getUrl(), logInfo.getJson(), logInfo.getResponseDetail()};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)logInfo.getResponseCode(), (String[])params, (boolean)logInfo.isTargetLocal());
        if (null == json) {
            json = "{\"detail\": \"" + logInfo.getResponseMsg() + "\"}";
        }
        Response.ResponseBuilder responseBuilder = Response.ok((Object)json);
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        return responseBuilder.build();
    }

    private Response noOpeLogInfoExit(RestLogInfo logInfo, String json) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        if (null == json) {
            json = "{\"detail\": \"" + logInfo.getResponseMsg() + "\"}";
        }
        Response.ResponseBuilder responseBuilder = Response.ok((Object)json);
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        return responseBuilder.build();
    }

    @Override
    @GET
    @Path(value="/zone/udpblock/allzones")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryAllZonesUDPBlockStatue() {
        List operationIds;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/zone/udpblock/allzones");
        String requestMsg = "query allZones UDPBlock Statue. restful request is null.";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/zone/udpblock/allzones");
            requestMsg = "restful request url : " + url + ".";
        }
        String responseMsg = "";
        int responseCode = 500;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            String json = "{\"detail\":\" illegal token.\"}";
            Response.ResponseBuilder responseBuilder = Response.ok((Object)json);
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        RestLogInfo logInfo = new RestLogInfo();
        logInfo.setApiName("allzones");
        logInfo.setResponseMsg(responseMsg);
        logInfo.setOperation("atic.restful.queryall.zone");
        if (!VsmUtil.getInstance().acquireApiInvoke(logInfo.getApiName()).booleanValue()) {
            Response response = this.handleOverAPInvokeLimitReturnInfo(logInfo);
            return response;
        }
        this.logger.info((Object)("is Legal Token" + requestMsg));
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
            responseMsg = "current user can not query all zones udp block statue";
            responseCode = 455;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        List udpList = zonePolicyMgrService.queryAllZonesUDPBlock(userId, isAdmin);
        ArrayList<RestUdpPolicyInfo> list = new ArrayList<RestUdpPolicyInfo>();
        if (null == udpList || udpList.isEmpty()) {
            this.logger.info((Object)"allZone UdpBlockState of db_data is empty or null");
        } else {
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            for (ZoneUdpBlockInfo zoneUdpBlockInfo : udpList) {
                zoneIdList.add(zoneUdpBlockInfo.getZoneId());
            }
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(logInfo, e);
            }
            this.transformDataToInfo(udpList, list);
        }
        String json = "{\"zones\":" + JSONUtil.getInstance().toJSONString(list) + "}";
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(200);
        return this.noOpeLogInfoExit(logInfo, json);
    }

    private void transformDataToInfo(List<ZoneUdpBlockInfo> udpList, List<RestUdpPolicyInfo> list) {
        RestUdpPolicyInfo info = null;
        String udpBlock = "anomaly";
        String deployState = "";
        String[] statu = null;
        String[] blocks = null;
        for (ZoneUdpBlockInfo zoneUdpBlockInfo : udpList) {
            info = new RestUdpPolicyInfo();
            info.setZoneAccount(zoneUdpBlockInfo.getZoneName());
            info.setDetail("");
            list.add(info);
            boolean state = true;
            deployState = zoneUdpBlockInfo.getDeployState();
            if (null != deployState && !deployState.trim().isEmpty()) {
                String string;
                int n;
                deployState = deployState.trim();
                String[] stringArray = statu = deployState.split(",");
                int n2 = stringArray.length;
                for (n = 0; n < n2 && (state = (string = stringArray[n]).matches("[0-2]")); ++n) {
                }
                if (state) {
                    if (deployState.indexOf("2") > -1 || deployState.indexOf("0") > -1) {
                        info.setUdpBlock("anomaly");
                        info.setDetail("zone not deployment or deployment error");
                    } else {
                        udpBlock = zoneUdpBlockInfo.getUdpBlock();
                        if (null != udpBlock && !udpBlock.trim().isEmpty()) {
                            udpBlock = udpBlock.trim();
                            stringArray = blocks = udpBlock.split(",");
                            n2 = stringArray.length;
                            for (n = 0; n < n2 && (state = (string = stringArray[n]).trim().matches("[0-1]")); ++n) {
                            }
                            if (state) {
                                if (-1 == udpBlock.indexOf("0")) {
                                    info.setUdpBlock("block");
                                } else if (-1 == udpBlock.indexOf("1")) {
                                    info.setUdpBlock("unblock");
                                } else {
                                    StringBuffer detail = new StringBuffer("");
                                    info.setUdpBlock("other");
                                    String[] ipAddresss = zoneUdpBlockInfo.getIpAddress().split(",");
                                    for (int i = 0; i < blocks.length; ++i) {
                                        if (!"0".equals(blocks[i])) continue;
                                        detail.append(ipAddresss[i] + " ");
                                    }
                                    info.setDetail(detail.toString() + " is unblock");
                                }
                            }
                        } else {
                            state = false;
                        }
                    }
                }
            } else {
                state = false;
            }
            if (state) continue;
            info.setUdpBlock("anomaly");
            info.setDetail("db data error");
        }
    }

    @Override
    @PUT
    @Path(value="/zone/updateZoneUDPPolicy")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateZoneUDPPolicy(String json) {
        List operationIds;
        RestLogInfo logInfo = new RestLogInfo();
        logInfo.setApiName("updateZoneUDPPolicy");
        String responseMsg = "";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)("ddos/zone/" + logInfo.getApiName()));
        Response response = this.checkTokenAndConcurrent(request, userName, json, logInfo, "atic.restful.update.zone");
        if (null != response) {
            return response;
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2206L) && operationIds.contains(2202L))) {
            responseMsg = "current user can not update zone udp policy.";
            int responseCode = 455;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        int responseCode = 500;
        Map paramsMap = null;
        try {
            this.checkJson(json);
            paramsMap = (Map)JSONUtil.getInstance().fromJSON(json, new MyTypeReference());
        }
        catch (Exception e) {
            responseMsg = "param  or request  error";
            responseCode = 400;
            this.logger.error((Object)("json format error. json string is " + json + " " + e.getMessage()));
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        if (null == paramsMap) {
            responseMsg = "param JSON is null";
            responseCode = 400;
            this.logger.error((Object)("json format error. json string is " + json));
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        CommonResult<ZoneInfoForm> commonResult = this.checkUdpUpdateParams(paramsMap);
        if (200 != commonResult.getCode()) {
            this.logger.error((Object)("updateZoneUDPPolicy. " + commonResult.getMessage()));
            responseMsg = commonResult.getMessage();
            responseCode = commonResult.getCode();
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            return this.noOpeLogInfoExit(logInfo, null);
        }
        ZoneInfoForm zoneForm = (ZoneInfoForm)commonResult.getContent();
        logInfo.setTarget(zoneForm.getZoneName());
        logInfo.setTargetLocal(false);
        if (!isAdmin) {
            block27: {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneForm.getMoId());
                try {
                    IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                    long userId = userMgr.getUserInfoByName(userName).getId();
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        return this.noOpeLogInfoExit(logInfo, null);
                    }
                    if (570506L != e.getErrorCode()) break block27;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    logInfo.setResponseMsg(responseMsg);
                    logInfo.setResponseCode(responseCode);
                    return this.noOpeLogInfoExit(logInfo, null);
                }
            }
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            zoneIdList.add(zoneForm.getZoneId());
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(logInfo, e);
            }
        }
        boolean updateFlag = false;
        try {
            updateFlag = this.handleUDPPolicy(paramsMap, zoneForm);
            if (!updateFlag) {
                responseCode = 500;
                responseMsg = "update zone UDP-Policy  fail.";
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("Exception :" + e.getMessage()));
            if (e.getErrorCode() == 630154L) {
                responseCode = 423;
                responseMsg = "Another administrator is operating this Zone.";
            }
            responseCode = 500;
            responseMsg = "update zone UDP-Policy error.";
        }
        this.logger.info((Object)"update zone UDP-Policy over. ");
        if (!updateFlag) {
            this.logger.error((Object)"update zone UDP-Policy fail.");
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            return this.logExitReturnInfo(logInfo, null);
        }
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneForm.getZoneId());
        String zoneAccount = (String)paramsMap.get("zone_name");
        RestfuResult result = this.deployZoneUdp(zonePolicyMgrService, zoneIdList, zoneAccount);
        if (200 != result.getCode()) {
            this.logger.error((Object)("updateZoneUDPPolicy. " + result.getMessage()));
            responseCode = result.getCode();
            responseMsg = "updateZoneUDPPolicy. " + result.getMessage();
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + " " + responseMsg);
            return this.logExitReturnInfo(logInfo, null);
        }
        List listResult = zonePolicyMgrService.queryAllDeployResultByZoneId(zoneForm.getZoneId());
        Map<String, String> map = this.deployStatus(listResult, zoneAccount);
        if ("0".equals(map.get("flag"))) {
            result.setMessage("success!");
        } else if ("1".equals(map.get("flag"))) {
            result.setCode(508);
            result.setMessage(map.get("responseMsg"));
        } else if ("2".equals(map.get("flag"))) {
            result.setCode(509);
            result.setMessage(map.get("responseMsg"));
        } else if ("3".equals(map.get("flag"))) {
            result.setCode(507);
            result.setMessage(map.get("responseMsg"));
        } else if ("4".equals(map.get("flag"))) {
            result.setCode(510);
            result.setMessage(map.get("responseMsg"));
        }
        this.logger.info((Object)("updateZoneUDPPolicy. " + result.getMessage()));
        responseCode = result.getCode();
        responseMsg = result.getMessage();
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(responseCode + " " + result.getMessage());
        return this.logExitReturnInfo(logInfo, null);
    }

    private RestfuResult deployZoneUdp(IZonePolicyMgrService zonePolicyMgrService, List<Long> zoneIdList, String zoneAccount) {
        RestfuResult result = new RestfuResult();
        result.setCode(200);
        try {
            zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("updateZoneUDPPolicy"), null);
        }
        catch (LegoCheckedException e) {
            String errorMsg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            String responseMsg = "ZoneUdpPolicy. deploy failed. zoneAccount is " + zoneAccount + "; error message is : " + errorMsg;
            this.logger.error((Object)(responseMsg + e.getMessage()));
            result.setCode(507);
            result.setMessage(errorMsg);
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)("ZoneUdpPolicy. deploy failed. zoneAccount is " + zoneAccount + ". " + e.getMessage()));
            result.setCode(507);
            result.setMessage("ATIC inner error occurred while  deploy udpPolicy.");
            return result;
        }
        return result;
    }

    private CommonResult<ZoneInfoForm> checkUdpUpdateParams(Map<String, String> paramsMap) {
        CommonResult result = new CommonResult();
        result.setCode(200);
        if (paramsMap.size() != 2) {
            result.setCode(400);
            result.setMessage("params size  can only be 2 !");
            return result;
        }
        if (!paramsMap.containsKey("zone_name") || !paramsMap.containsKey("udp_block")) {
            result.setCode(400);
            result.setMessage("params must contain: zone_name and udp_block!");
            return result;
        }
        String zoneAccount = paramsMap.get("zone_name");
        String block = paramsMap.get("udp_block");
        if (!"block".equals(block) && !"unblock".equals(block)) {
            result.setCode(400);
            result.setMessage("udp_block:[" + block + "] is error, the value can only be block or unblock !");
            return result;
        }
        return this.checkZoneAccount(zoneAccount);
    }

    private boolean handleUDPPolicy(Map<String, String> params, ZoneInfoForm zoneForm) {
        ZoneServiceForm zoneServiceForm = null;
        IZoneServiceService serviceService = ZoneReferUtil.getZoneServiceService();
        List<ZoneServiceForm> defaultServices = this.getDDOSDefaultZoneServiceForms(zoneForm);
        ArrayList<String> features = new ArrayList<String>();
        features.add(Constant.Feature.ServiceUdpDefendData.toString());
        UdpDefendPolicyForm udp = null;
        String block = params.get("udp_block");
        if (!defaultServices.isEmpty()) {
            for (ZoneServiceForm service : defaultServices) {
                zoneServiceForm = serviceService.query(service.getPkid(), features);
                udp = null == zoneServiceForm ? null : zoneServiceForm.getUdpDefendPolicyForm();
                if (null == udp) continue;
                if ("block".equals(block)) {
                    if (null != udp.getUdpBlock() && udp.getUdpBlock().booleanValue()) continue;
                    udp.setUdpBlock(Boolean.valueOf(true));
                } else {
                    if (null == udp.getUdpBlock() || !udp.getUdpBlock().booleanValue()) continue;
                    udp.setUdpBlock(Boolean.valueOf(false));
                }
                serviceService.create((Object)zoneServiceForm);
            }
            return true;
        }
        return false;
    }

    private Response handleOverAPInvokeLimitReturnInfo(RestLogInfo logInfo) {
        int responseCode = 423;
        String responseMsg = "exceed concurrent api call limit.";
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.noOpeLogInfoExit(logInfo, null);
    }

    @Override
    @POST
    @Path(value="/zone/updateLocationPolicy")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateLocationPolicy(String json) {
        Long zoneId;
        ArrayList<Long> zoneIdList;
        String zoneAccount;
        LocationPolicyInfo locationPolicyInfo;
        IZoneIpLocationService locationService;
        LocationPolicyResult locationPolicyResult;
        int responseCode;
        RestLogInfo logInfo;
        block25: {
            List operationIds;
            this.logger.info((Object)("updateLocationPolicy start to do ...and json is:" + json));
            logInfo = new RestLogInfo();
            String apiName = "updateLocationPolicy";
            Response.ResponseBuilder responseBuilder = Response.ok();
            HttpServletRequest request = ServletActionContext.getRequest();
            String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)("ddos/zone/" + apiName));
            String requestMsg = "updateLocationPolicy. restful request is null. json string is :" + json + ". ";
            String terminalIp = "127.0.0.1";
            String url = "null";
            if (null != request) {
                url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/zone/" + apiName));
                requestMsg = "restful request url : " + url + ". json string is :" + json + ". ";
                terminalIp = request.getRemoteAddr();
            }
            this.logger.info((Object)("updateLocationPolicy request information:" + requestMsg));
            responseCode = 500;
            if (AticUtil.isNull((String)userName)) {
                responseCode = 412;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)"illegal token.");
                return responseBuilder.build();
            }
            logInfo.setUrl(url);
            logInfo.setJson(json);
            logInfo.setUserName(userName);
            logInfo.setTerminalIp(terminalIp);
            logInfo.setApiName(apiName);
            if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
                Response response = this.handleOverAPInvokeLimit(logInfo, responseBuilder);
                return response;
            }
            locationPolicyResult = new LocationPolicyResult();
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            locationService = ZoneReferUtil.getZoneIpLocationService();
            locationPolicyInfo = null;
            zoneAccount = "";
            try {
                this.checkJson(json);
                locationPolicyInfo = (LocationPolicyInfo)JSONUtil.getInstance().fromJSON(json, LocationPolicyInfo.class);
                zoneAccount = locationPolicyInfo.getZoneAccount();
            }
            catch (IOException e) {
                this.logger.error((Object)("updateLocationPolicy request json format error. " + e.getMessage()));
                locationPolicyResult.setZoneAccount(zoneAccount);
                locationPolicyResult.setDeployStatus("failure");
                locationPolicyResult.setDetail("json format error");
                responseCode = 400;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                return responseBuilder.build();
            }
            boolean isAdmin = "admin".equals(userName);
            if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2206L) && operationIds.contains(2202L))) {
                locationPolicyResult.setZoneAccount(zoneAccount);
                locationPolicyResult.setDeployStatus("failure");
                locationPolicyResult.setDetail("current user can not update location policy.");
                responseCode = 455;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                return responseBuilder.build();
            }
            locationPolicyResult = this.checkJsonParams(locationPolicyInfo, logInfo);
            if (!locationPolicyResult.getDeployStatus().equals("success")) {
                responseCode = 400;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                return responseBuilder.build();
            }
            ZoneInfoForm zoneInfoForm = zoneService.getZoneByName(zoneAccount);
            if (null == zoneInfoForm) {
                locationPolicyResult.setZoneAccount(zoneAccount);
                locationPolicyResult.setDeployStatus("failure");
                locationPolicyResult.setDetail("zoneAccount is not exist");
                responseCode = 445;
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                return responseBuilder.build();
            }
            zoneIdList = new ArrayList<Long>();
            zoneId = zoneInfoForm.getZoneId();
            zoneIdList.add(zoneId);
            if (!isAdmin) {
                block24: {
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    moIdList.add(zoneInfoForm.getMoId());
                    try {
                        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                        long userId = userMgr.getUserInfoByName(userName).getId();
                        BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                    }
                    catch (LegoCheckedException e) {
                        if (630114L == e.getErrorCode()) {
                            locationPolicyResult.setZoneAccount(zoneAccount);
                            locationPolicyResult.setDeployStatus("failure");
                            locationPolicyResult.setDetail("The current user does not have the resources for this zone.");
                            responseCode = 455;
                            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                            responseBuilder = responseBuilder.status(responseCode);
                            responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                            return responseBuilder.build();
                        }
                        if (570506L != e.getErrorCode()) break block24;
                        locationPolicyResult.setZoneAccount(zoneAccount);
                        locationPolicyResult.setDeployStatus("failure");
                        locationPolicyResult.setDetail("Unable to get the service published in the background.");
                        responseCode = 500;
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                        return responseBuilder.build();
                    }
                }
                try {
                    this.checkDevicePermissionByUserName(userName, zoneIdList);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        locationPolicyResult.setZoneAccount(zoneAccount);
                        locationPolicyResult.setDeployStatus("failure");
                        locationPolicyResult.setDetail("The current user does not have the device resource permissions associated with the this zone.");
                        responseCode = 455;
                        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                        return responseBuilder.build();
                    }
                    if (570506L != e.getErrorCode()) break block25;
                    locationPolicyResult.setZoneAccount(zoneAccount);
                    locationPolicyResult.setDeployStatus("failure");
                    locationPolicyResult.setDetail("Unable to get the service published in the background.");
                    responseCode = 500;
                    VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)this.formatResult(locationPolicyResult));
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)this.formatResult(locationPolicyResult));
                    return responseBuilder.build();
                }
            }
        }
        try {
            locationService.deleteByZoneId(zoneId);
            List<IpLocationInfo> zones = locationPolicyInfo.getZones();
            if (null != zones && !zones.isEmpty()) {
                List<ZoneIpLocationInfo> infoList = this.getIpLocation(zoneId, zones);
                locationService.saveIpLocation(infoList);
            } else {
                locationService.deleteByZoneId(zoneId);
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("updateLocationPolicy saveIpLocation error. " + e.getMessage()));
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail("saveIpLocation error");
            responseCode = 400;
            this.locationPolicyResult(locationPolicyResult, logInfo, zoneAccount, responseCode);
            return this.logExit(logInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)("updateLocationPolicy saveIpLocation error. " + e.getMessage()));
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail("saveIpLocation error");
            responseCode = 400;
            this.locationPolicyResult(locationPolicyResult, logInfo, zoneAccount, responseCode);
            return this.logExit(logInfo);
        }
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        try {
            zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures("updateLocationPolicy"), null);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("updateLocationPolicy deployIpLocation error. " + e.getMessage()));
            String detail = this.handleDeployRestult(zoneId);
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail(detail);
            responseCode = 400;
            this.locationPolicyResult(locationPolicyResult, logInfo, zoneAccount, responseCode);
            return this.logExit(logInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)("updateLocationPolicy deployIpLocation error. " + e.getMessage()));
            String detail = this.handleDeployRestult(zoneId);
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail(detail);
            responseCode = 400;
            this.locationPolicyResult(locationPolicyResult, logInfo, zoneAccount, responseCode);
            return this.logExit(logInfo);
        }
        String resultDetail = this.handleDeployRestult(zoneId);
        if (!"success".equals(resultDetail)) {
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail(resultDetail);
            responseCode = 400;
            this.locationPolicyResult(locationPolicyResult, logInfo, zoneAccount, responseCode);
            return this.logExit(logInfo);
        }
        locationPolicyResult.setZoneAccount(zoneAccount);
        locationPolicyResult.setDeployStatus("success");
        locationPolicyResult.setDetail("");
        responseCode = 200;
        this.locationPolicyResult(locationPolicyResult, logInfo, zoneAccount, responseCode);
        return this.logExit(logInfo);
    }

    private String handleDeployRestult(Long zoneId) {
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
        List deployResult = zoneDeviceDeployStatusService.queryPolicyDeployResult(zoneId);
        String detail = "success";
        int succCount = 0;
        int failCount = 0;
        if (null != deployResult && !deployResult.isEmpty()) {
            StringBuffer msg = new StringBuffer();
            for (ZoneDeviceDeployStatusInfo deStatusForm : deployResult) {
                Long deviceId = deStatusForm.getDeviceId();
                AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceId.longValue());
                String deviceIp = aticDevice.getIpAddress();
                if (1 != aticDevice.getDeviceType()) continue;
                if (deStatusForm.getDeployState().booleanValue()) {
                    msg.append(deviceIp + "-success;");
                    ++succCount;
                }
                if (!deStatusForm.getDeployState().booleanValue()) {
                    msg.append(deviceIp + "-failure;");
                    ++failCount;
                }
                detail = msg.toString();
            }
            if (deployResult.size() == succCount) {
                detail = "success";
            }
            if (deployResult.size() == failCount) {
                detail = "failure";
            }
        }
        return detail;
    }

    private List<ZoneIpLocationInfo> getIpLocation(Long zoneId, List<IpLocationInfo> zones) {
        ArrayList<ZoneIpLocationInfo> infoList = new ArrayList<ZoneIpLocationInfo>();
        Map<String, IpLocation> location = IpLocationUtil.initIpLocationMapAndIpLocationNameMap();
        for (IpLocationInfo info : zones) {
            ZoneIpLocationInfo zoneIpLocationInfo = new ZoneIpLocationInfo();
            zoneIpLocationInfo.setZoneId(zoneId.longValue());
            if (info.getDeployLocation().equalsIgnoreCase("other")) {
                zoneIpLocationInfo.setLocationId(10000L);
                zoneIpLocationInfo.setLocationNameZh("OtherLocation");
                zoneIpLocationInfo.setLocationNameEn("OtherLocation");
                zoneIpLocationInfo.setShortName("other");
                zoneIpLocationInfo.setLocationAction(Integer.valueOf(IpLocationUtil.locationAction(info.getBolckState())));
                zoneIpLocationInfo.setLocationLimit(info.getThreshold() == null ? null : Integer.valueOf(info.getThreshold()));
                infoList.add(zoneIpLocationInfo);
                continue;
            }
            IpLocation iplocation = location.get(info.getDeployLocation());
            zoneIpLocationInfo.setLocationId(iplocation.getLocationId());
            zoneIpLocationInfo.setLocationNameZh(iplocation.getLocationNameZh());
            zoneIpLocationInfo.setLocationNameEn(iplocation.getLocationNameEn());
            zoneIpLocationInfo.setShortName(iplocation.getShortName().toLowerCase(Locale.ENGLISH));
            zoneIpLocationInfo.setLocationAction(Integer.valueOf(IpLocationUtil.locationAction(info.getBolckState())));
            zoneIpLocationInfo.setLocationLimit(info.getThreshold() == null ? null : Integer.valueOf(info.getThreshold()));
            infoList.add(zoneIpLocationInfo);
        }
        return infoList;
    }

    private void locationPolicyResult(LocationPolicyResult locationPolicyResult, RestLogInfo logInfo, String zoneAccount, int responseCode) {
        logInfo.setResponseMsg(this.formatResult(locationPolicyResult));
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(this.formatResult(locationPolicyResult));
        logInfo.setOperation("neglobal.location.updateLocationPolicy");
        logInfo.setTarget(zoneAccount);
        logInfo.setTargetLocal(false);
    }

    private LocationPolicyResult checkJsonParams(LocationPolicyInfo locationPolicyInfo, RestLogInfo logInfo) {
        LocationPolicyResult locationPolicyResult = new LocationPolicyResult();
        String zoneAccount = locationPolicyInfo.getZoneAccount();
        int responseCode = 200;
        String zoneAccoutReg = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$";
        if (AticUtil.isNull((String)zoneAccount)) {
            this.logger.warn((Object)"zoneAccount is null!");
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail("zoneAccount is null");
            responseCode = 445;
            return locationPolicyResult;
        }
        if (!zoneAccount.matches(zoneAccoutReg) || zoneAccount.length() > 32) {
            this.logger.warn((Object)"zoneAccount is illegal!");
            locationPolicyResult.setZoneAccount(zoneAccount);
            locationPolicyResult.setDeployStatus("failure");
            locationPolicyResult.setDetail("zoneAccount is illegal");
            responseCode = 445;
            return locationPolicyResult;
        }
        List<IpLocationInfo> zones = locationPolicyInfo.getZones();
        if (null != zones && !zones.isEmpty()) {
            List<String> names = IpLocationUtil.getLocationNames();
            for (IpLocationInfo ipLocationInfo : zones) {
                String deployLocation = ipLocationInfo.getDeployLocation();
                String blockState = ipLocationInfo.getBolckState();
                String threshold = ipLocationInfo.getThreshold();
                if (AticUtil.isNull((String)deployLocation)) {
                    this.logger.warn((Object)"deployLocation is null");
                    locationPolicyResult.setZoneAccount(zoneAccount);
                    locationPolicyResult.setDeployStatus("failure");
                    locationPolicyResult.setDetail("deployLocation is null");
                    responseCode = 404;
                    return locationPolicyResult;
                }
                if (!deployLocation.equals("Other") && !names.contains(deployLocation)) {
                    this.logger.warn((Object)"deployLocation is not defaultLocation");
                    locationPolicyResult.setZoneAccount(zoneAccount);
                    locationPolicyResult.setDeployStatus("failure");
                    locationPolicyResult.setDetail("deployLocation is not defaultLocation");
                    responseCode = 404;
                    return locationPolicyResult;
                }
                if (AticUtil.isNull((String)blockState)) {
                    this.logger.warn((Object)"blockState is null");
                    locationPolicyResult.setZoneAccount(zoneAccount);
                    locationPolicyResult.setDeployStatus("failure");
                    locationPolicyResult.setDetail("blockState is null");
                    responseCode = 404;
                    return locationPolicyResult;
                }
                if (!(blockState.equals("block") || blockState.equals("pass") || blockState.equals("limit"))) {
                    this.logger.warn((Object)"blockState is wrong");
                    locationPolicyResult.setZoneAccount(zoneAccount);
                    locationPolicyResult.setDeployStatus("failure");
                    locationPolicyResult.setDetail("blockState is wrong");
                    responseCode = 404;
                    return locationPolicyResult;
                }
                if (null == threshold) continue;
                int thresholdValue = -1;
                try {
                    thresholdValue = Integer.parseInt(threshold);
                }
                catch (NumberFormatException e) {
                    this.logger.warn((Object)"threshold is wrong");
                    locationPolicyResult.setZoneAccount(zoneAccount);
                    locationPolicyResult.setDeployStatus("failure");
                    locationPolicyResult.setDetail("threshold is wrong");
                    responseCode = 404;
                    return locationPolicyResult;
                }
                if (thresholdValue >= 1 && thresholdValue <= 10240) continue;
                this.logger.warn((Object)"threshold is out of range");
                locationPolicyResult.setZoneAccount(zoneAccount);
                locationPolicyResult.setDeployStatus("failure");
                locationPolicyResult.setDetail("threshold is out of range");
                responseCode = 404;
                return locationPolicyResult;
            }
        }
        locationPolicyResult.setZoneAccount(zoneAccount);
        locationPolicyResult.setDeployStatus("success");
        locationPolicyResult.setDetail("");
        responseCode = 200;
        return locationPolicyResult;
    }

    private String formatResult(LocationPolicyResult resultBean) {
        String jsonResult = "";
        try {
            jsonResult = JSONUtil.getInstance().toJSON((Object)resultBean);
            this.logger.info((Object)("updateLocationPolicy response result :" + jsonResult));
        }
        catch (Exception e) {
            RestUtil.processSysLog((String)"divert", (int)500, (String)"convert the format from java to json  failed.", (Exception)e);
            this.logger.error((Object)("updateLocationPolicy LocationPolicyResult convert the format from java to json  failed." + e.getMessage()));
        }
        return jsonResult;
    }

    @Override
    @GET
    @Path(value="/zone/location/{zone_account}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryLocation(@PathParam(value="zone_account") String zoneAccount) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)("zone/location/" + zoneAccount));
        String requestMsg = "query One Zone. restful request is null.";
        if (null != request) {
            String url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("zone/location/" + zoneAccount));
            requestMsg = "restful request url : " + url + ".";
        }
        String responseMsg = "";
        int responseCode = 500;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        if (!ZoneUtil.isValidZoneName((String)zoneAccount)) {
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal zoneAccount.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal zoneAccount.");
            return responseBuilder.build();
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2201L))) {
            responseMsg = "current user can not query location.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = ZoneReferUtil.getZoneDeviceDeployStatusService();
        IZonePolicyApplyService service = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        ZoneInfoForm zoneInfoForm = zoneService.getZoneByName(zoneAccount);
        if (null == zoneInfoForm) {
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"zoneService.getZoneByName() failed.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"get zone by name failed");
            return responseBuilder.build();
        }
        if (!isAdmin) {
            block25: {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(zoneInfoForm.getMoId());
                try {
                    IUserMgr userMgr = ZoneReferUtil.getUserMgr();
                    long userId = userMgr.getUserInfoByName(userName).getId();
                    BisUtil.checkRestfulUserSecurity(moIdList, (long)userId, (boolean)isAdmin);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        responseCode = 455;
                        responseMsg = "The current user does not have the resources for this zone.";
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                        responseBuilder = responseBuilder.status(responseCode);
                        responseBuilder.entity((Object)responseMsg);
                        return responseBuilder.build();
                    }
                    if (570506L != e.getErrorCode()) break block25;
                    responseCode = 500;
                    responseMsg = "Unable to get the service published in the background.";
                    RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                    responseBuilder = responseBuilder.status(responseCode);
                    responseBuilder.entity((Object)responseMsg);
                    return responseBuilder.build();
                }
            }
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            zoneIdList.add(zoneInfoForm.getZoneId());
            try {
                this.checkDevicePermissionByUserName(userName, zoneIdList);
            }
            catch (LegoCheckedException e) {
                return this.buildErrorResponse(responseBuilder, requestMsg, e);
            }
        }
        ZoneLocationInfo zoneLocation = new ZoneLocationInfo();
        List zoneDeviceStatusList = zoneDeviceDeployStatusService.queryByZoneId(zoneInfoForm.getZoneId());
        if (null != zoneDeviceStatusList && !zoneDeviceStatusList.isEmpty()) {
            IZoneIpLocationService zoneIpLocationService = ZoneReferUtil.getZoneIpLocationService();
            List zoneModifyDetail = service.getZoneModifyDetail(zoneInfoForm.getZoneId());
            boolean partSuccess = false;
            if (null != zoneModifyDetail) {
                for (ZoneModifyDetailForm zoneModifyDetailForm : zoneModifyDetail) {
                    if (!"com.hs.vsm.secservice.ddos.policy.zonepolicy.zoneiplocation.info.changed".equals(zoneModifyDetailForm.getModifyDetail())) continue;
                    partSuccess = true;
                }
            }
            String deployLocationState = "failure";
            if (!partSuccess) {
                deployLocationState = "success";
                for (ZoneDeviceDeployStatusForm statusForm : zoneDeviceStatusList) {
                    if (!"lego.err.631045".equalsIgnoreCase(statusForm.getErrorMsgKey()) && !"lego.err.630005".equalsIgnoreCase(statusForm.getErrorMsgKey())) continue;
                    deployLocationState = "failure";
                    break;
                }
            }
            zoneLocation.setZoneAccount(zoneInfoForm.getZoneName());
            zoneLocation.setDeployStatus(deployLocationState);
            List zoneIpLocationList = zoneIpLocationService.getByZoneId(zoneInfoForm.getZoneId().longValue());
            if (null != zoneIpLocationList && !zoneIpLocationList.isEmpty()) {
                ArrayList<IpLocationInfo> ipLocationList = new ArrayList<IpLocationInfo>();
                for (ZoneIpLocationForm zoneIpLocationForm : zoneIpLocationList) {
                    IpLocationInfo ipLocation = new IpLocationInfo();
                    if ("OtherLocation".equals(zoneIpLocationForm.getLocationNameEn())) {
                        ipLocation.setDeployLocation("other");
                    } else {
                        ipLocation.setDeployLocation(zoneIpLocationForm.getLocationNameEn());
                    }
                    if (zoneIpLocationForm.getLocationAction() == 1) {
                        ipLocation.setBolckState("pass");
                    } else if (zoneIpLocationForm.getLocationAction() == 2) {
                        ipLocation.setBolckState("block");
                    } else {
                        ipLocation.setBolckState("limit");
                        ipLocation.setThreshold(String.valueOf(zoneIpLocationForm.getLocationLimit()));
                    }
                    ipLocationList.add(ipLocation);
                }
                zoneLocation.setZones(ipLocationList);
            }
        } else {
            zoneLocation.setDeployStatus("failure");
        }
        responseMsg = JSONUtil.getInstance().toJSONString((Object)zoneLocation);
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        return Response.ok((Object)responseMsg).build();
    }

    public void setPermissionService(IPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private static class MyTypeReference<T>
    extends TypeReference<T> {
    }
}

