/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system.service;

import com.hs.atic.sdk.bis.service.IDivertTacticsLogService;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsLogService;
import com.hs.lego.cbb.validity.service.ILogStorage;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.file.util.FileZip;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LogStorageUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogStorageImpl
implements ILogStorage {
    protected Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private ISysOptLog sysOptLog;
    private IDivertTacticsLogService divertTacticsLogService;
    private IOutboundDivertTacticsLogService outboundDivertTacticsLogService;
    private static int SECOND = 1000;

    @Override
    public String transferLog(String fileType, long endTime, String lang) {
        File tempFileDir1;
        StringBuffer sBufQObj;
        String dateTime;
        if (!LogStorageUtil.hasEnoughMemory()) {
            return "";
        }
        this.sysOptLog.judgingCapacity("log_bk");
        this.logger.info((Object)"System transferLog begin");
        int optLogTotalNum = this.getCountWithOptLog(endTime);
        long divertEndTime = endTime / (long)SECOND;
        int inboundLogTotalNum = this.getCountWithInboundDivertLog(divertEndTime);
        int outboundLogTotalNum = this.getCountWithOutboundDivertLog(endTime);
        if (optLogTotalNum <= 0 && inboundLogTotalNum <= 0 && outboundLogTotalNum <= 0) {
            this.writeOptLogNoFile();
            return "lego.dic.warningaralm.noexist";
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
        String tempfileName = dateTime = dateFormat.format(date);
        String currentPath = LogStorageUtil.getDumpPathByDateType((String)"log_bk");
        LogStorageUtil.createDirectory((String)currentPath);
        this.logger.info((Object)("log dump create:" + dateTime));
        File tempFileDir = new File(currentPath + File.separator + tempfileName);
        this.logger.info((Object)("log dump ,endTime:" + endTime + "optLogTotalNum:" + optLogTotalNum + "inboundLogTotal:" + inboundLogTotalNum));
        if (optLogTotalNum > 0) {
            sBufQObj = new StringBuffer("FROM OptLogMo where opTime < " + endTime);
            tempFileDir1 = new File(currentPath + File.separator + tempfileName + File.separator + "systemOptLog");
            LogStorageUtil.createDirectory((String)(currentPath + File.separator + tempfileName + File.separator + "systemOptLog" + File.separator + "detail"));
            this.sysOptLog.transLog2File(optLogTotalNum, sBufQObj, fileType, lang, tempFileDir1, tempfileName);
        }
        if (inboundLogTotalNum > 0) {
            sBufQObj = new StringBuffer("FROM DivertTacticsLog where logTime < " + divertEndTime);
            tempFileDir1 = new File(currentPath + File.separator + tempfileName + File.separator + "inboundDivertLog");
            LogStorageUtil.createDirectory((String)(currentPath + File.separator + tempfileName + File.separator + "inboundDivertLog"));
            this.divertTacticsLogService.transLog2File(inboundLogTotalNum, sBufQObj, fileType, lang, tempFileDir1, tempfileName);
        }
        if (outboundLogTotalNum > 0) {
            sBufQObj = new StringBuffer("FROM OutboundDivertTacticsLog where logTime < " + endTime);
            tempFileDir1 = new File(currentPath + File.separator + tempfileName + File.separator + "outboundDivertLog");
            LogStorageUtil.createDirectory((String)(currentPath + File.separator + tempfileName + File.separator + "outboundDivertLog"));
            this.outboundDivertTacticsLogService.transLog2File(outboundLogTotalNum, sBufQObj, fileType, lang, tempFileDir1, tempfileName);
        }
        try {
            FileZip.zip((String)(currentPath + File.separator + tempfileName), (String)(currentPath + File.separator + tempfileName + ".zip"), (String)tempfileName);
            FileZip.getInstance().deleteFile(tempFileDir);
        }
        catch (Exception e) {
            this.logger.error((Object)("zip file error!" + e.getMessage()));
        }
        this.deleteAllLog(endTime);
        this.writetTransferLog(endTime, tempfileName, optLogTotalNum);
        return tempfileName + ".zip";
    }

    @Override
    public String transferDivertTacticsLog(String fileType, long endTime, String lang, long minCount) {
        File tempFileDir1;
        StringBuffer sBufQObj;
        String dateTime;
        if (!LogStorageUtil.hasEnoughMemory()) {
            return "";
        }
        this.sysOptLog.judgingCapacity("divert_log_bk");
        this.logger.info((Object)"System transfer devert Log begin");
        long divertEndTime = endTime / (long)SECOND;
        int inboundLogTotalNum = this.getCountWithInboundDivertLog(divertEndTime);
        int outboundLogTotalNum = this.getCountWithOutboundDivertLog(endTime);
        if ((long)inboundLogTotalNum <= minCount && (long)outboundLogTotalNum <= minCount) {
            this.writeOptLogNoFile();
            return "lego.dic.warningaralm.noexist";
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
        String tempfileName = dateTime = dateFormat.format(date);
        String currentPath = LogStorageUtil.getDumpPathByDateType((String)"log_bk");
        LogStorageUtil.createDirectory((String)currentPath);
        this.logger.info((Object)("create dateTime:" + dateTime + ",endTime:" + endTime + ",TotalNum:" + inboundLogTotalNum));
        File tempFileDir = new File(currentPath + File.separator + tempfileName);
        if ((long)inboundLogTotalNum > minCount) {
            sBufQObj = new StringBuffer("FROM DivertTacticsLog where logTime < " + divertEndTime);
            tempFileDir1 = new File(currentPath + File.separator + tempfileName + File.separator + "inboundDivertLog");
            LogStorageUtil.createDirectory((String)(currentPath + File.separator + tempfileName + File.separator + "inboundDivertLog"));
            this.divertTacticsLogService.transLog2File(inboundLogTotalNum, sBufQObj, fileType, lang, tempFileDir1, tempfileName);
        }
        if ((long)outboundLogTotalNum > minCount) {
            sBufQObj = new StringBuffer("FROM OutboundDivertTacticsLog where logTime < " + endTime);
            tempFileDir1 = new File(currentPath + File.separator + tempfileName + File.separator + "outboundDivertLog");
            LogStorageUtil.createDirectory((String)(currentPath + File.separator + tempfileName + File.separator + "outboundDivertLog"));
            this.outboundDivertTacticsLogService.transLog2File(outboundLogTotalNum, sBufQObj, fileType, lang, tempFileDir1, tempfileName);
        }
        this.logger.info((Object)("create dateTime2:" + dateTime));
        try {
            FileZip.zip((String)(currentPath + File.separator + tempfileName), (String)(currentPath + File.separator + tempfileName + ".zip"), (String)tempfileName);
            FileZip.getInstance().deleteFile(tempFileDir);
        }
        catch (Exception e) {
            this.logger.error((Object)("zip file error!" + e.getMessage()));
        }
        this.deleteDivertTacticsLog(divertEndTime);
        this.writetTransferLog(endTime, tempfileName, inboundLogTotalNum);
        return tempfileName + ".zip";
    }

    private void writetTransferLog(long endTime, String tempfileName, int totalNum) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.sys.sysLog.operLog");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.ver.storage.sysOptLog");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.sysOptLog");
        oOptLog.setResult(1);
        oOptLog.setTerminalIp("127.0.0.1");
        Date da = new Date(endTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dt = df.format(da);
        String filePathTemp = tempfileName + ".zip";
        String[] para = new String[]{dt, "" + totalNum, filePathTemp};
        oOptLog.setDetailPara(para);
        oOptLog.setOperator("system");
        this.sysOptLog.writeOptLog(oOptLog);
    }

    private void writeOptLogNoFile() {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.sys.sysLog.operLog");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.dic.warningaralm.noexist");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.sysOptLog");
        oOptLog.setResult(1);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        this.sysOptLog.writeOptLog(oOptLog);
    }

    private int getCountWithOptLog(long endTime) {
        return this.sysOptLog.getCountByHql(endTime);
    }

    private int getCountWithOutboundDivertLog(long endTime) {
        return this.outboundDivertTacticsLogService.getCountByHql(endTime);
    }

    private int getCountWithInboundDivertLog(long endTime) {
        return this.divertTacticsLogService.getCountByHql(endTime);
    }

    public void deleteAllLog(long endTime) {
        this.sysOptLog.deleteLog(endTime);
        this.divertTacticsLogService.deleteLog(Long.valueOf(endTime / (long)SECOND));
    }

    private void deleteDivertTacticsLog(long endTime) {
        this.divertTacticsLogService.deleteLog(Long.valueOf(endTime));
        this.outboundDivertTacticsLogService.deleteLog(Long.valueOf(endTime));
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public IDivertTacticsLogService getDivertTacticsLogService() {
        return this.divertTacticsLogService;
    }

    public void setDivertTacticsLogService(IDivertTacticsLogService divertTacticsLogService) {
        this.divertTacticsLogService = divertTacticsLogService;
    }

    public IOutboundDivertTacticsLogService getOutboundDivertTacticsLogService() {
        return this.outboundDivertTacticsLogService;
    }

    public void setOutboundDivertTacticsLogService(IOutboundDivertTacticsLogService outboundDivertTacticsLogService) {
        this.outboundDivertTacticsLogService = outboundDivertTacticsLogService;
    }
}

