/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.certjob;

import com.hs.lego.cbb.fault.sdk.model.FaultVO;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.task.certjob.ICertificateValidator;
import com.hs.lego.cbb.task.certjob.TaskConfig;
import com.hs.lego.cbb.task.certjob.ValidityUtil;
import com.hs.lego.cbb.validity.CertificateValidity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import java.io.File;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractCertificateValidator
implements ICertificateValidator {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);

    public abstract void validateCertificate(CertificateValidity var1);

    @Override
    public void validate(List<CertificateValidity> certificates) {
        Iterator<CertificateValidity> itCertificate = certificates.iterator();
        CertificateValidity next = null;
        while (itCertificate.hasNext()) {
            next = itCertificate.next();
            this.validateCertificate(next);
        }
    }

    protected void checkCertificateValidity(Certificate certificate, CertificateValidity next) {
        int threshold;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        X509Certificate x509Certificate = (X509Certificate)certificate;
        Date notAfter = x509Certificate.getNotAfter();
        Date notBefore = x509Certificate.getNotBefore();
        Date nowDate = new Date();
        ArrayList<String> alarmParams = new ArrayList<String>();
        alarmParams.add(next.getName());
        String strAlarmSeverity = String.valueOf(FaultEnum.AlarmSeverity.MAJOR.getValue());
        if (nowDate.before(notBefore)) {
            String strNotBefore = dateFormat.format(notBefore);
            alarmParams.add(strNotBefore);
            this.createAlarm("0x10010013", Byte.valueOf(strAlarmSeverity), alarmParams);
            return;
        }
        if (nowDate.after(notAfter)) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String paramExpired = dateFormatter.format(notAfter);
            alarmParams.add(paramExpired);
            this.createAlarm("0x10010011", Byte.valueOf(strAlarmSeverity), alarmParams);
            return;
        }
        long currentCycle = ValidityUtil.checkIntervalDays(notAfter);
        if (currentCycle < (long)(threshold = TaskConfig.getInstance().getThreshold().intValue())) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String paramExpiredDate = dateFormatter.format(notAfter);
            alarmParams.add(paramExpiredDate);
            alarmParams.add(String.valueOf(currentCycle));
            this.createAlarm("0x10010012", Byte.valueOf(strAlarmSeverity), alarmParams);
            return;
        }
    }

    private void createAlarm(String faultDefineId, Byte alarmLevel, List<String> params) {
        String[] faultParams = new String[params.size()];
        params.toArray(faultParams);
        FaultVO fault = new FaultVO();
        fault.setFaultDefineId(faultDefineId);
        fault.setMoId(Long.valueOf(-1L));
        fault.setSource("System");
        fault.setParam(faultParams);
        FaultService faultService = (FaultService)ServiceContext.getInstance().getService("faultService", FaultService.class);
        faultService.createFault(fault);
    }

    protected boolean certificateExists(String path) {
        File certFile = new File(path);
        return certFile.exists();
    }
}

