/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.certjob;

import com.hs.lego.cbb.task.certjob.AbstractCertificateValidator;
import com.hs.lego.cbb.validity.CertificateValidity;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class CertificateValidator
extends AbstractCertificateValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateCertificate(CertificateValidity next) {
        String jksPath = next.getPath();
        if (!this.certificateExists(jksPath)) {
            this.logger.error((Object)("The certificate " + next.getName() + "does not exist."));
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(next.getPath());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(in);
            this.checkCertificateValidity(cert, next);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"file not found exception");
        }
        catch (CertificateException e) {
            this.logger.error((Object)"validateCertificate Certificate get error.");
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"validateCertificate IOException error");
                }
            }
        }
    }
}

