/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.certjob;

import com.hs.lego.cbb.task.certjob.AbstractCertificateValidator;
import com.hs.lego.cbb.validity.CertificateValidity;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;

public class KeyStoreCertificateValidator
extends AbstractCertificateValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateCertificate(CertificateValidity next) {
        String keystorekey = next.getKeyStorePass();
        String jksPath = next.getPath();
        if (!this.certificateExists(jksPath)) {
            this.logger.error((Object)("The certificate " + next.getName() + "does not exist."));
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(jksPath);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, keystorekey.toCharArray());
            Enumeration<String> als = ks.aliases();
            while (als.hasMoreElements()) {
                Certificate cert = ks.getCertificate(als.nextElement());
                this.checkCertificateValidity(cert, next);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"validateCertificate file not found exception");
        }
        catch (KeyStoreException e) {
            this.logger.error((Object)"validateCertificate KeyStore error.");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)"validateCertificate algorithm error.");
        }
        catch (CertificateException e) {
            this.logger.error((Object)"validateCertificate Certificate error.");
        }
        catch (IOException e) {
            this.logger.error((Object)"validateCertificate IOException error.");
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"validateCertificate stream close error.");
                }
            }
        }
    }
}

