/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.certjob;

import com.hs.lego.cbb.task.certjob.TaskConfig;
import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.dao.ITaskTypeDAO;
import com.hs.lego.cbb.task.manager.TaskManager;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskParameter;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.cbb.task.sdk.service.TaskExecuteType;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TaskInitializer
implements Runnable {
    private static final String TASK_TYPE_CERTIFICATE = "cert_bk";
    private static final String TASK_NAME = "Certificate Validity";
    private ITaskTypeDAO taskTypeDao;
    private ITaskDAO taskDao;
    private TaskManager taskManager;
    private ITaskService taskService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);

    public void init() {
        if (!this.checkTaskExists()) {
            this.logger.info((Object)"Certificate task doesn't exist,create a new task.");
            Task task = this.createDefaultTask();
            this.taskDao.addTask(task);
            this.taskManager.start(task);
        } else {
            this.need2UpdateTask();
            this.logger.info((Object)"TaskManager will schedule all the task.");
        }
    }

    private void need2UpdateTask() {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", TASK_TYPE_CERTIFICATE);
        List taskList = this.taskDao.queryTask(condition);
        if (null == taskList || taskList.isEmpty()) {
            return;
        }
        Task certTask = (Task)taskList.get(0);
        Date baseTime = certTask.getBaseTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        String curTime = dateFormat.format(baseTime);
        String runTime = TaskConfig.getInstance().getRunTime();
        boolean need2Update = false;
        if (!curTime.equals(runTime) || !certTask.getPeriod().equals(TaskConfig.getInstance().getPeriod())) {
            need2Update = true;
        }
        if (need2Update) {
            this.updateTask(certTask);
        }
    }

    private void updateTask(Task certTask) {
        certTask.setPeriod(TaskConfig.getInstance().getPeriod());
        Date runTime = this.getRunTime();
        certTask.setBaseTime(runTime);
        certTask.setNextTime(null);
        this.taskService.updateTask(certTask);
    }

    private Date getRunTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        Date nowTime = new Date();
        String runTime = TaskConfig.getInstance().getRunTime();
        Date firstStartTime = null;
        try {
            firstStartTime = dateFormat.parse(formatDay.format(nowTime) + " " + runTime);
        }
        catch (ParseException e) {
            long startTime = nowTime.getTime() + 60000L;
            firstStartTime = new Date(startTime);
        }
        return firstStartTime;
    }

    private Task createDefaultTask() {
        Task task = new Task();
        Integer periodDay = TaskConfig.getInstance().getPeriod();
        task.defaultSystemTask(TASK_NAME, periodDay);
        Date firstStartTime = this.getRunTime();
        task.setBaseTime(firstStartTime);
        task.setExecuteType(Integer.valueOf(TaskExecuteType.period.getValue()));
        TaskParameter taskParams = task.getParameter();
        taskParams.setParameter2("30");
        taskParams.setParameter4("03:00");
        TaskType taskType = this.taskTypeDao.readTaskType(TASK_TYPE_CERTIFICATE);
        task.setTaskType(taskType);
        return task;
    }

    private boolean checkTaskExists() {
        boolean bExist = true;
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", TASK_TYPE_CERTIFICATE);
        List taskList = this.taskDao.queryTask(condition);
        if (null == taskList || taskList.isEmpty()) {
            bExist = false;
        }
        return bExist;
    }

    public ITaskTypeDAO getTaskTypeDao() {
        return this.taskTypeDao;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public ITaskDAO getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    public void run() {
        this.init();
    }
}

